/*
 * Decompiled with CFR 0.152.
 */
package railo.loader.classloader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import railo.loader.util.Util;

public final class RailoClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    private Hashtable resources = new Hashtable();
    private ClassLoader pcl;

    public RailoClassLoader(File file, ClassLoader classLoader) throws IOException {
        this(new FileInputStream(file), classLoader, RailoClassLoader.isSecure(file));
    }

    private static boolean isSecure(File file) {
        return !file.getName().toLowerCase().endsWith(".rc");
    }

    public RailoClassLoader(InputStream inputStream, ClassLoader classLoader, boolean bl) throws IOException {
        super(classLoader);
        if (bl) {
            throw new IOException("secured core files are not supported");
        }
        this.pcl = classLoader;
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
        try {
            ZipEntry zipEntry;
            byte[] byArray = new byte[65535];
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (zipEntry.isDirectory()) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = zipInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                String string = zipEntry.getName().replace('\\', '/');
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                if (string.endsWith(".class")) {
                    String string2 = string.substring(0, string.length() - 6);
                    string2 = string2.replace('/', '.');
                    this.classes.put(string2, byArray2);
                }
                this.resources.put(string, byArray2);
                zipInputStream.closeEntry();
                byteArrayOutputStream.close();
            }
        }
        finally {
            Util.closeEL(zipInputStream);
        }
    }

    public Class findClass(String string) throws ClassNotFoundException {
        byte[] byArray = (byte[])this.classes.get(string);
        if (byArray == null) {
            throw new ClassNotFoundException("class [" + string + "] not found");
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    private Class findClassEL(String string) {
        byte[] byArray = (byte[])this.classes.get(string);
        if (byArray == null) {
            return null;
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null && (clazz = this.findClassEL(string)) == null) {
            clazz = this.pcl.loadClass(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        byte[] byArray = (byte[])this.resources.get(string = string.replace('\\', '/'));
        if (byArray == null) {
            return super.getResourceAsStream(string);
        }
        return new ByteArrayInputStream(byArray);
    }
}

