<?php
/**
 * Turn register globals off, even if it's on
 * taken from Wordpress
 *
 * @access private
 * @since 2.2.10
 * @return null Will return null if register_globals PHP directive was disabled
 */
function unregister_GLOBALS() {
    if ( !ini_get('register_globals') )
        return;

    if ( isset($_REQUEST['GLOBALS']) )
        die('GLOBALS overwrite attempt detected');

    // Variables that shouldn't be unset
    $noUnset = array('GLOBALS', '_GET', '_POST', '_COOKIE', '_REQUEST', '_SERVER', '_ENV', '_FILES');

    $input = array_merge($_GET, $_POST, $_COOKIE, $_SERVER, $_ENV, $_FILES, isset($_SESSION) && is_array($_SESSION) ? $_SESSION : array());
    foreach ( $input as $k => $v )
        if ( !in_array($k, $noUnset) && isset($GLOBALS[$k]) ) {
            $GLOBALS[$k] = NULL;
            unset($GLOBALS[$k]);
        }
}

unregister_GLOBALS();

