# hgrcutils.py - Functions to manipulate hgrc (or similar) files
#
# Copyright 2011 Angel Ezquerra <angel.ezquerra@gmail.com>
#
# This software may be used and distributed according to the terms of the
# GNU General Public License version 2 or any later version.

import os

from tortoisehg.hgqt.i18n import _
from tortoisehg.hgqt import qtlib
from tortoisehg.util import wconfig

def loadIniFile(rcpath, parent=None):
    for fn in rcpath:
        if os.path.exists(fn):
            break
    else:
        for fn in rcpath:
            # Try to create a file from rcpath
            try:
                f = open(fn, 'w')
                f.write('# Generated by TortoiseHg\n')
                f.close()
                break
            except EnvironmentError:
                pass
        else:
            qtlib.WarningMsgBox(_('Unable to create a config file'),
                   _('Insufficient access rights.'), parent=parent)
            return None, {}

    return fn, wconfig.readfile(fn)

def setConfigValue(rcfilepath, cfgpath, value):
    '''
    Set a value on a config file, such as an hgrc or a .ini file

    rcpfilepath: Absolute path to a configuration file
    cfgpath: Full "path" of a configurable key
             Format is section.keyNamee.g. 'web.name')
    value: String value for the selected config key
    '''
    fn, cfg = loadIniFile([rcfilepath])
    if not hasattr(cfg, 'write'):
        return False
    if fn is None:
        return False
    cfgFullKey = cfgpath.split('.')
    if len(cfgFullKey) < 2:
        return False
    cfg.set(cfgFullKey[0], cfgFullKey[1], value)
    try:
        wconfig.writefile(cfg, fn)
    except EnvironmentError, e:
        return False
    return True
