/*
    MaskedException - Allow masking of exceptions.

    Copyright (C) 1995, Adam Fedor.

*/
#ifndef _MaskedException_INCLUDE_
#define _MaskedException_INCLUDE_

#ifndef GNUSTEP
#import <Foundation/Foundation.h>
#else
#include <Foundation/NSException.h>
#include <Foundation/NSString.h>
#endif

typedef enum {
    RaiseException,		/* Act normal */
    AbortException,		/* Abort with information (via assert) */
    HandleException,		/* Call an alternate exception handler */
    LogException,		/* Ignore but print exception (DANGEROUS!) */
    IgnoreException,		/* Silent Ignore and continue (DANGEROUS!) */
} ExceptionMask;

@protocol MaskedExceptionHandling
- (void)exceptionWithName: (NSString *)raise_name
	reason: (NSString *)raise_reason
	userInfo: (NSDictionary *)raise_info;
@end

@interface MaskedException : NSException
{
}

+ (void)bodysnatchNSException;
	/* Same as [MaskedException poseAsClass:NSException].  Apply our
	   devious masking to all exceptions */

// Setting exception handler
+ (void)setHandler:(id <MaskedExceptionHandling>)handler 
	forException:(NSString *)exceptionName;
+ (void)setHandler:(id <MaskedExceptionHandling>)handler 
	forExceptionsWithPrefix:(NSString *)prefix;
+ (void)setHandlerForAllExceptions:(id <MaskedExceptionHandling>)handler;

// Setting masks
+ (void)setMask:(ExceptionMask)mask forException:(NSString *)exceptionName;
+ (void)setMask:(ExceptionMask)mask forExceptionsWithPrefix:(NSString *)prefix;
+ (void)setMaskForAllExceptions:(ExceptionMask)mask;

// Getting mask information
+ (ExceptionMask)maskForException:(NSString *)exceptionName;

@end

#endif
