if not modules then modules = { } end modules ['mult-mes'] = {
    version   = 1.001,
    comment   = "companion to mult-ini.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "PRAGMA ADE / ConTeXt Development Team",
    license   = "see context related readme files"
}

-- floatsblocks -> floats
-- bodyfont     -> fonts
-- verbatims    -> buffers

-- check all interfaces.showmessage
-- replace all writestatus (tricky as %'s in names, but we can support --)

return {
    formats = {
        ["adapted: preamble '%s', state '%s', order '%s'"] = {
            nl = "aangepast: preamble '%s', status '%s', volgorde '%s'",
        },
        ["already loaded: '%s'"] = {
            nl = "al geladen: '%s'",
        },
        ["check:1"] = {
            cs = "postradam '=' po '%s' na radku %s",
            de = "Fehlendes '=' nach '%s' in Zeile %s",
            en = "missing or ungrouped '=' after '%s' in line %s",
            fr = "manquant ou dégroupé '=' après '%s' à la ligne %s",
            it = "'=' mancante o non raggruppato dopo '%s' alla riga %s",
            nl = "'=' ontbreekt of zonder {} na '%s' in regel %s",
            no = "manglende '=' etter '%s' i linje %s",
            ro = "lipseste '=' dupa '%s' in linia %s",
        },
        ["check:2"] = {
            cs = "ocekavam %s argument(y) na radku %s",
            de = "%s Argument(e) in Zeile %s erwartet",
            en = "%s argument(s) expected in line %s",
            fr = "%s argument(s) attendu(s) à la ligne %s",
            it = "%s argomento/i attesi alla riga %s",
            nl = "%s argument(en) verwacht in regel %s",
            no = "%s argument forventet i linje %s",
            ro = "argumentul(ele) %s sunt asteptate in linia  %s",
        },
        ["check:3"] = {
            cs = "%s %s nahrazuje makro, uzijte VERZALKY!",
            de = "%s %s ersetzt ein Makro, verwende VERSALIEN!",
            en = "%s %s replaces a macro, use CAPITALS!",
            fr = "%s %s remplace une macro, utilisez des MAJUSCULES !",
            it = "%s %s sostituisce una macro, usare le MAIUSCOLE!",
            nl = "%s %s vervangt een macro, gebruik HOOFDLETTERS!",
            no = "%s %s overskygger en makro, bruk STORE BOKSTAVER!",
            ro = "%s %s inlocuieste un macro, folositi MAJUSCULE!",
        },
        ["checking file: '%s'"] = {
            nl = "controleren file: '%s'",
        },
        ["checking url: '%s'"] = {
            nl = "controleren url: '%s'",
        },
        ["colors:1"] = {
            cs = "system %s je globalne aktivovana",
            de = "system %s ist global aktiviert",
            en = "system %s is global activated",
            fr = "le système %s est globalement activé",
            it = "sistema %s attivato globalmente",
            nl = "systeem %s is globaal actief",
            no = "system %s er aktivert globalt",
            ro = "sistem %s este activata global",
        },
        ["colors:10"] = {
            cs = "%s prostor barev je podporovan",
            de = "%s Farbraum wird unterstuetzt",
            en = "%s color space is supported",
            fr = "%s l'espace de couleur est supporté",
            it = "spazio dei colori %s supportato",
            nl = "%s kleurruimte wordt ondersteund",
            no = "%s fargerom er støttet",
            ro = "spatiul de culoare %s este suportat",
        },
        ["colors:11"] = {
            cs = "barva je prevedena na sed",
            de = "Farbe wird in Grau umgewandelt",
            en = "color is converted to gray",
            fr = "la couleur est convertie en niveau de gris",
            it = "il colore ø convertito in grigio",
            nl = "kleur wordt vertaald in grijs",
            no = "fargen vil bli vist som grø",
            ro = "culoarea este convertita la gri",
        },
        ["colors:12"] = {
            cs = "%s is registered",
            de = "%s is registered",
            en = "%s is registered",
            fr = "%s est enregistré",
            it = "%s is registered",
            nl = "%s is geregistreerd",
            no = "%s is registered",
            ro = "%s is registered",
        },
        ["colors:2"] = {
            cs = "system %s je lokalne activovana",
            de = "system %s ist lokal aktiviert",
            en = "system %s is local activated",
            fr = "le système %s est localement activé",
            it = "sistema %s attivato localmente",
            nl = "systeem %s is lokaal actief",
            no = "system %s er aktivert lokalt",
            ro = "sistem %s este activata local",
        },
        ["colors:3"] = {
            cs = "%s neni definovana %s",
            de = "%s ist undefiniert %s",
            en = "%s is not defined %s",
            fr = "%s n'est pas défini %s",
            it = "%s non definito %s",
            nl = "%s is niet gedefinieerd %s",
            no = "%s er udefinert %s",
            ro = "%s nu este definita %s",
        },
        ["colors:4"] = {
            cs = "system %s je nacten",
            de = "system %s ist geladen",
            en = "system %s is loaded",
            fr = "le système %s est chargé",
            it = "sistema %s caricato",
            nl = "systeem %s wordt geladen",
            no = "system %s er lest inn",
            ro = "sistem %s este incarcata",
        },
        ["colors:5"] = {
            cs = "neznamy system %s",
            de = "unbekanntes System %s",
            en = "unknown system %s",
            fr = "système %s inconnu",
            it = "sistema %s sconosciuto",
            nl = "onbekend systeem %s",
            no = "ukjent system %s",
            ro = "sistem %s necunoscuta",
        },
        ["colors:6"] = {
            cs = "palette %s je k dispozici",
            de = "palette %s ist verfuegbar",
            en = "palette %s is available",
            fr = "la palette %s est disponible",
            it = "tavolozza %s resa disponibile",
            nl = "palet %s is beschikbaar",
            no = "palett %s er tilgjengelig",
            ro = "paleta %s este disponibila",
        },
        ["colors:7"] = {
            cs = "palette %s neni k dispozici",
            de = "palette %s ist nicht verfuegbar",
            en = "palette %s is not available",
            fr = "le palette %s n'est pas disponible",
            it = "tavolozza %s non disponibile",
            nl = "palet %s is niet beschikbaar",
            no = "palett %s er ikke tilgjengelig",
            ro = "palette %s nu este disponibila",
        },
        ["colors:8"] = {
            cs = "specifikace %s v barve %s bude cerna",
            de = "Spezifikation %s bei Farbe %s wird schwarz",
            en = "specification %s at color %s becomes black",
            fr = "la spécification %s de la couleur %s devient noire",
            it = "specifica %s del colore %s convertita in nero",
            nl = "specificatie %s bij %s wordt zwart",
            no = "spesifikasjon %s for farge %s gir kun svart",
            ro = "specificatia %s la culoarea %s devine neagra",
        },
        ["colors:9"] = {
            cs = "%s prostor barev neni podporovan",
            de = "%s Farbraum wird nicht unterstuetzt",
            en = "%s color space is not supported",
            fr = "l'espace de couleur %s n'est pas supporté",
            it = "spazio dei colori %s non supportato",
            nl = "%s kleurruimte wordt niet ondersteund",
            no = "%s fargerom er ikke støttet",
            ro = "spatiul de culoare %s nu este suportat",
        },
        ["columns:1"] = {
            cs = "je mozno pouze %s sloupcu",
            de = "nur %s Spalten moeglich",
            en = "only %s columns possible",
            fr = "seules %s colonnes possibles",
            it = "solo %s colonne possibili",
            nl = "maximaal %s kolommen",
            no = "maksimalt %s kolonner",
            ro = "este posibil numai %s coloane",
        },
        ["columns:10"] = {
            cs = "zbyl (mene nez) 1 radek",
            de = "(weniger als) 1 Zeile uebrig",
            en = "(less than) 1 line left",
            fr = "(moins de) 1 ligne restante",
            it = "(meno di) una riga rimasta",
            nl = "(minder dan) 1 regel over",
            no = "(mindre enn) 1 linje igjen",
            ro = "a mai ramas (mai putin de) 1 linie",
        },
        ["columns:11"] = {
            cs = "plovouci objekt je pro sloupec prilis siroky",
            de = "Gleitobjekt zu breit fuer Spalte",
            en = "float too wide for column",
            fr = "flottant mis à la largeur de la colonne",
            it = "oggetto mobile troppo ampio per la colonna",
            nl = "plaatsblok te breed voor kolom",
            no = "flytblokk for bredt for kolonna",
            ro = "blocul este prea lat pentru coloana",
        },
        ["columns:12"] = {
            cs = "plovouci objekt je presunut do nasledujiciho sloupce / %s",
            de = "Gleitobjekt in naechste Zeile verschoben / %s",
            en = "float moved to next column / %s",
            fr = "flottant déplacé à la colonne suivante / %s",
            it = "oggetto mobile spostata alla colonna successiva / %s",
            nl = "plaatsblok verplaatst naar volgende kolom / %s",
            no = "flytblokk forskjøvet til neste kolonne / %s",
            ro = "blocul este mutat pe urmatoarea coloana / %s",
        },
        ["columns:13"] = {
            cs = "siroky plovouci objekt je presunut nad sloupce",
            de = "breites Gleitobjekt an den Anfang der Spalten verschoben",
            en = "wide float moved to top of columns",
            fr = "flottant large déplacé dans la partie supérieure de la colonne",
            it = "oggetto mobile ampio spostato sopra le colonne",
            nl = "breed figuur geplaatst boven kolommen",
            no = "bred flytblokk forksjøvet til toppen av kolonnene",
            ro = "blocul lat este mutat in partea de sus a coloanelor",
        },
        ["columns:2"] = {
            cs = "pouzijte \\string\\filbreak\\space jako alternativu",
            de = "benutzte \\string\\filbreak\\space als Alternative",
            en = "use \\string\\filbreak\\space as alternative",
            fr = "utilisez \\string\\filbreak\\space en tant qu'alternative",
            it = "in alternativa, usare \\string\\filbreak",
            nl = "gebruik eventueel \\string\\filbreak",
            no = "bruk \\string\\filbreak\\space som et alternativ",
            ro = "folositi \\string\\filbreak\\space ca alternativa",
        },
        ["columns:3"] = {
            cs = "problem, vypina se vyvazovani",
            de = "Problem, verwende [ausgleich=nein]",
            en = "problems, disable balancing",
            fr = "problèmes, désactive l'équilibrage",
            it = "problemi, disabilitare il bilanciamento",
            nl = "probleempje, probeer [balanceren=nee]",
            no = "problemer, slår av balansering",
            ro = "probleme, se dezactiveaza alinierea",
        },
        ["columns:4"] = {
            cs = "horni plovouci objekt jeste neni podporovan",
            de = "Gleitobjekt oben ncoh nicht unterstuetzt",
            en = "top float not yet supported",
            fr = "flottant en partie supérieure pas encore supporté",
            it = "float in cima non ancora supportato",
            nl = "plaatsblok boven nog niet mogelijk",
            no = "flytblokker øverst er ikke støttet enda",
            ro = "cadrele top (top float) nu sunt inca suportate",
        },
        ["columns:5"] = {
            cs = "spodni plovouci objekt jeste neni podporovan",
            de = "Gleitobjekt unten ncoh nicht unterstuetzt",
            en = "bottom float not yet supported",
            fr = "flottant en partie inférieure pas encore supporté",
            it = "float in fondo non ancora supportato",
            nl = "plaatsblok onder nog niet mogelijk",
            no = "flytblokker nedert er ikke støttet enda",
            ro = "cadrele bottom (bottom float) nu sunt inca suportate",
        },
        ["columns:6"] = {
            cs = "%s plovouci objekt(y) odlozeny",
            de = "%s Gleitobjekt(e) verschoben",
            en = "%s float(s) postponed",
            fr = "%s flottant(s) reporté(s)",
            it = "%s float(s) posticipate",
            nl = "%s plaatsblok(en) opgeschort",
            no = "%s flytblokk forskjøvet",
            ro = "%s blocurile sunt amanate",
        },
        ["columns:7"] = {
            cs = "vyvazovani ukonceno po 100 krocich",
            de = "ausgleich nach 100 Schritten abgebrocheb",
            en = "balancing aborted after 100 steps",
            fr = "équilibrage abandonné après 100 pas",
            it = "bilanciamento annullato dopo 100 passi",
            nl = "balanceren afgebroken na 100 stappen",
            no = "balansering avbrutt etter 100 iterasjoner",
            ro = "alinierea este oprita dupa 100 de incercari",
        },
        ["columns:8"] = {
            cs = "vyvazeno v %s krocich",
            de = "ausgeglichen nach  %s Schritt(en)",
            en = "balanced in %s step(s)",
            fr = "équilibré en %s pas",
            it = "bilanciamento in %s passo/i",
            nl = "gebalanceerd in %s stap(pen)",
            no = "balansert etter %s iterasjoner",
            ro = "aliniat in  %s pas(i)",
        },
        ["columns:9"] = {
            cs = "kontrola nerovnost",
            de = "Ausrichtung ueberpruefen",
            en = "check raggedness",
            fr = "vérification des irrégularités",
            it = "controllare seghettamento",
            nl = "uitlijnen controleren!",
            no = "kontroller tekstlayout!",
            ro = "verificat alinierea",
        },
        ["databases:1"] = {
            cs = "%s",
            de = "%s",
            en = "%s",
            fr = "%s",
            it = "%s",
            nl = "%s",
            no = "%s",
            ro = "%s",
        },
        ["databases:2"] = {
            cs = "local file %s",
            de = "lokale Datei %s",
            en = "local file %s",
            fr = "fichier local %s",
            it = "file locale %s",
            nl = "lokaal bestand %s",
            no = "lokal fil %s",
            ro = "fisier local %s",
        },
        ["databases:3"] = {
            cs = "global file %s",
            de = "globale Datei %s",
            en = "global file %s",
            fr = "fichier global %s",
            it = "file globale %s",
            nl = "globaal bestand %s",
            no = "global fil %s",
            ro = "fisier global %s",
        },
        ["databases:4"] = {
            cs = "unknown file %s",
            de = "unbekannte Datei %s",
            en = "unknown file %s",
            fr = "fichier inconnu %s",
            it = "file sconosciuto %s",
            nl = "onbekend bestand %s",
            no = "ukjent fil %s",
            ro = "fisier necunoscut %s",
        },
        ["extended: preamble '%s', state '%s', order '%s'"] = {
            nl = "uitgebreid: preamble '%s', status '%s', volgorde '%s'",
        },
        ["figures:1"] = {
            cs = "obraz %s nelze nalezt",
            de = "Abbildung %s kann nicht gefunden werden",
            en = "figure %s can not be found",
            fr = "la figure %s ne peut être trouvée",
            it = "figura %s non trovata",
            nl = "figuur %s is niet te vinden",
            ro = "figura %s nu poate fi gasita",
        },
        ["figures:2"] = {
            cs = "obraz %s nepritomen",
            de = "Abbildung %s wird nicht erstellt",
            en = "figure %s is not preset",
            fr = "la figure %s n'est pas pré-sélectionnée",
            it = "la figura %s non è preimpostata",
            nl = "figuur %s wordt niet preset",
            ro = "figura %s nu este presetata",
        },
        ["figures:3"] = {
            cs = "dimensions of %s are determined externally",
            de = "dimensions of %s are determined externally",
            en = "dimensions of %s are determined externally",
            fr = "dimensions of %s are determined externally",
            it = "dimensions of %s are determined externally",
            nl = "maten van %s worden extern vastgesteld",
            ro = "dimensions of %s are determined externally",
        },
        ["figures:4"] = {
            cs = "dimenze obrazu %s nacteny primo z jeho souboru",
            de = "Dimensionen von %s geladen aus der Abbildungsdatei selbst",
            en = "dimensions of %s loaded from figurefile itself",
            fr = "les dimensions de %s chargées implicitement à partir du fichier de figure",
            it = "dimensioni di %s caricate dal file di immagini stesso",
            nl = "maten van %s geladen uit figuurfile zelf",
            ro = "dimensiunea figurii %s se incarca din fisierul insusi",
        },
        ["figures:5"] = {
            cs = "dimensions of %s are unknown",
            de = "Dimensions of %s are unknown",
            en = "dimensions of %s are unknown",
            fr = "dimensions of %s are unknown",
            it = "dimensions of %s are unknown",
            nl = "maten van %s zijn onbekend",
            ro = "dimensions of %s are unknown",
        },
        ["figures:6"] = {
            cs = "dimenze obrazu %s spocteny programem rlxtools",
            de = "Dimensionen von %s ausgerechnet durch rlxtools",
            en = "dimensions of %s calculated by rlxtools",
            fr = "les dimensions de %s calculées par rlxtools",
            it = "dimensioni di %s calcolate da rlxtools",
            nl = "maten van %s berekend door rlxtools",
            ro = "dimensiunea figurii %s este calculata de rlxtools",
        },
        ["figures:8"] = {
            cs = "obrazovy objekt %s je znovu pouzit",
            de = "Abbildungobjekt %s wurde wiederverwandt",
            en = "figureobject %s is reused",
            fr = "figureobject %s est réutilisé",
            it = "oggetto-figura %s riutilizzato",
            nl = "figuurobject %s wordt opnieuw gebruikt",
            ro = "obiectul figura %s este refolosit",
        },
        ["files:1"] = {
            cs = "synonymum souboru %s je jiz pouzito pro %s",
            de = "Dateisynonym %s wird bereits fuer %s benutzt",
            en = "file synonym %s is already used for %s",
            fr = "le synonyme de fichier %s est déjà utilisé pour %s",
            it = "sinonimo file %s già in uso per %s",
            nl = "file synoniem %s is al in gebruik voor %s",
            no = "filesynonym %s er allerede brukt for %s",
            ro = "sinonimul fisierelor %s este folosit deja pentru %s",
        },
        ["filters:1"] = {
            cs = "filter %s is loaded",
            de = "filter %s ist geladen",
            en = "filter %s is loaded",
            fr = "le filtre %s est chargé",
            it = "filtro %s caricato",
            nl = "filter %s wordt geladen",
        },
        ["filters:2"] = {
            cs = "unknown filter %s",
            de = "unknown filter %s",
            en = "unknown filter %s",
            fr = "filtre %s inconnu",
            it = "filtro sconosciuto %s",
            nl = "onbekend filter %s",
        },
        ["floatblocks:1"] = {
            cs = "%s precislovano / %s => %s",
            de = "%s neu nummeriert / %s => %s",
            en = "%s renumbered / %s => %s",
            fr = "%s renuméroté / %s => %s",
            it = "%s rinumerato / %s => %s",
            nl = "%s hernummerd / %s => %s",
            no = "%s renummerert / %s => %s",
            ro = "%s renumerotat / %s => %s",
        },
        ["floatblocks:10"] = {
            cs = "%s omezeno",
            de = "%s begrenzt",
            en = "%s limited",
            fr = "%s limité",
            it = "%s limitato",
            nl = "%s begrensd",
            no = "%s begrenset",
            ro = "%s limitat",
        },
        ["floatblocks:11"] = {
            cs = "nedan zadny blok",
            de = "kein Block gegeben",
            en = "no block given",
            fr = "pas de bloc donné",
            it = "nessun oggetto specificato",
            nl = "geen blok opgegeven",
            no = "ingen blokk oppgitt",
            ro = "nu este dat nici un bloc",
        },
        ["floatblocks:12"] = {
            cs = "nedefinovano",
            de = "undefiniert",
            en = "undefined",
            fr = "indéfini",
            it = "non definito",
            nl = "niet gedefinieerd",
            no = "udefinert",
            ro = "nedefinit",
        },
        ["floatblocks:13"] = {
            cs = "there is nothing to split",
            de = "there is nothing to split",
            en = "there is nothing to split",
            fr = "there is nothing to split",
            it = "there is nothing to split",
            nl = "er is niets te splitsen",
            no = "there is nothing to split",
            ro = "there is nothing to split",
        },
        ["floatblocks:2"] = {
            cs = "%s ulozeno",
            de = "%s gespeichert",
            en = "%s saved",
            fr = "%s sauvegardé",
            it = "%s salvato",
            nl = "%s bewaard",
            no = "%s lagret",
            ro = "%s salvat",
        },
        ["floatblocks:3"] = {
            cs = "%s presunuto",
            de = "%s verschoben",
            en = "%s moved",
            fr = "%s déplacé",
            it = "%s mosso",
            nl = "%s verplaatst",
            no = "%s flyttet",
            ro = "%s mutat",
        },
        ["floatblocks:4"] = {
            cs = "%s umisteno",
            de = "%s plaziert",
            en = "%s placed",
            fr = "%s placé",
            it = "%s sistemato",
            nl = "%s geplaatst",
            no = "%s plassert",
            ro = "%s plasat",
        },
        ["floatblocks:5"] = {
            cs = "poradi prizpusobeno",
            de = "Reihenfolge angepasst",
            en = "order adapted",
            fr = "ordre adapté",
            it = "ordine aggiustato",
            nl = "volgorde aangepast",
            no = "rekkefølge tilpasset",
            ro = "ordinea adaptata",
        },
        ["floatblocks:6"] = {
            cs = "pocet hornich plovoucich objektu je omezen na %s",
            de = "Anz. der oberen Gleitobjekte beschraengt auf %s",
            en = "n of top floats limited to %s",
            fr = "n flottants de haut de page limité à %s",
            it = "n di top floats limitato a %s",
            nl = "maximaal %s boven",
            no = "maksimalt %s flytblokker øverst",
            ro = "nr. cadrelor de sus limitat la  %s",
        },
        ["floatblocks:7"] = {
            cs = "pocet spodnich plovoucich objektu je omezen na %s",
            de = "Anz. der unteren Gleitobjekte beschraengt auf  %s",
            en = "n of bottom floats limited to %s",
            fr = "n flottants de bas de page limité à %s",
            it = "n di bottom floats limitato a %s",
            nl = "maximaal %s onder",
            no = "maksimalt %s flytblokker nederst",
            ro = "nr. blocurilor de jos limitat la %s",
        },
        ["floatblocks:8"] = {
            cs = "radku je mene nez %s",
            de = "weniger als %s zeilen",
            en = "less than %s lines",
            fr = "moins de %s lignes",
            it = "meno di %s righe",
            nl = "minder dan %s regels",
            no = "mindre enn %s linjer",
            ro = "mai putin de %s linii",
        },
        ["floatblocks:9"] = {
            cs = "poradi naruseno",
            de = "Reigenfolge gestoert",
            en = "order disturbed",
            fr = "ordre perturbé",
            it = "ordine disturbato",
            nl = "volgorde verstoord",
            no = "rekkefølge endret",
            ro = "ordinea deranjata",
        },
        ["flushed: preamble '%s'"] = {
            nl = "weggeschreven: preamble '%s'",
        },
        ["fonts:1"] = {
            cs = "kodovani %s",
            de = "Kodierung %s",
            en = "coding %s",
            fr = "encodage %s",
            it = "codifica %s",
            nl = "codering %s",
            no = "koding %s",
            ro = "codificarea %s",
        },
        ["fonts:10"] = {
            cs = "neznamy font %s",
            de = "unbekanntes Font %s",
            en = "unknown font file %s",
            fr = "fichier de police %s inconnu",
            it = "file di font sconosciuto %s",
            nl = "onbekende font file %s",
            no = "ukjent fontfil %s",
            ro = "fisier font necunoscut %s",
        },
        ["fonts:14"] = {
            cs = "bodyfont %s is defined (can better be done global)",
            de = "Fliesstext %s wurde definiert (besser waere globale Definition)",
            en = "bodyfont %s is defined (can better be done global)",
            fr = "policecorps %s est défini (une définition globale pourrait être plus adéquat)",
            it = "corpo del testo %s definito (sarebbe meglio globale)",
            nl = "korps %s is gedefinieerd (kan beter globaal plaatsvinden)",
            no = "bodyfont %s is defined (can better be done global)",
            ro = "bodyfont %s is defined (can better be done global)",
        },
        ["fonts:2"] = {
            cs = "varianta %s je nactena",
            de = "Variante %s ist geladen",
            en = "variant %s is loaded",
            fr = "la variante %s est chargée",
            it = "variante %s caricata",
            nl = "variant %s wordt geladen",
            no = "variant %s er lest inn",
            ro = "varianta %s este incarcata",
        },
        ["fonts:3"] = {
            cs = "neznama varianta %s",
            de = "Unbekannte Variante %s",
            en = "unknown variant %s",
            fr = "variante %s inconnue",
            it = "variante sconosciuta %s",
            nl = "onbekende variant %s",
            no = "ukjent variant %s",
            ro = "varianta necunoscuta %s",
        },
        ["fonts:4"] = {
            cs = "zakladni font %s neni definovan",
            de = "Fliesstext %s ist nicht definiert",
            en = "bodyfont %s is not defined",
            fr = "policecorps %s n'est pas définie",
            it = "corpo del testo %s non definito",
            nl = "korps %s is niet gedefinieerd",
            no = "hovedfont %s er ikke definert",
            ro = "corpul de litere %s nu este definit",
        },
        ["fonts:5"] = {
            cs = "styl %s neni definovan",
            de = "Stil %s ist nicht definiert",
            en = "style %s is not defined",
            fr = "le style %s n'est pas défini",
            it = "stile %s non definito",
            nl = "stijl %s is niet gedefinieerd",
            no = "stil %s er ikke definert",
            ro = "stilul %s nu este definit",
        },
        ["fonts:6"] = {
            cs = "%s je nacten",
            de = "%s ist geladen",
            en = "%s is loaded",
            fr = "%s est chargé",
            it = "%s caricato",
            nl = "%s wordt geladen",
            no = "%s er lest inn",
            ro = "%s este incarcat",
        },
        ["fonts:7"] = {
            cs = "neznamy format %s",
            de = "unbekanntes Format %s",
            en = "unknown format %s",
            fr = "format %s inconnu",
            it = "formato sconosciuto %s",
            nl = "onbekend formaat %s",
            no = "ukjent format %s",
            ro = "format necunoscut %s",
        },
        ["fonts:8"] = {
            cs = "styl %s definovan",
            de = "Stil %s definiert",
            en = "style %s defined",
            fr = "style %s défini",
            it = "stile %s definito",
            nl = "stijl %s gedefinieerd",
            no = "stil %s definert",
            ro = "stilul %s definit",
        },
        ["interactions:1"] = {
            cs = "pomer %s x %s (s x v)",
            de = "Seitenverhaeltnis %s x %s (B x H)",
            en = "aspect ratio %s x %s (b x h)",
            fr = "ratio d'aspect %s x %s (b x h)",
            it = "rapporto %s x %s (b x a)",
            nl = "aspect ratio %s x %s (b x h)",
            no = "forholdstall %s x %s (b x h)",
            ro = "aspectul %s x %s (b x h)",
        },
        ["interactions:2"] = {
            cs = "aktivni",
            de = "aktiv",
            en = "active",
            fr = "actif",
            it = "attiva",
            nl = "actief",
            no = "aktiv",
            ro = "activ",
        },
        ["interactions:21"] = {
            cs = "%s kod vlozen",
            de = "%s Code eingefuegt",
            en = "%s code inserted",
            fr = "%s code inseré",
            it = "codice %s inserito",
            nl = "%s code tussengevoegd",
            no = "%s kode satt inn / tilføyd",
            ro = "%s cod inserat",
        },
        ["interactions:3"] = {
            cs = "neaktivni",
            de = "inaktiv",
            en = "inactive",
            fr = "inactif",
            it = "inattiva",
            nl = "niet actief",
            no = "inaktiv",
            ro = "inactiv",
        },
        ["interactions:4"] = {
            cs = "zadna strankova synchronizace (%s) v hmode",
            de = "keine Seitensynchronisation (%s) im hmode",
            en = "no pagesynchronisation (%s) in hmode",
            fr = "pas de synchronisation de page (%s) dans le hmode",
            it = "sincronizzazione di pagina (%s) non disponibile in hmode",
            nl = "geen paginasynchronisatie (%s) in hmode",
            no = "ingen sidesynkronisering (%s) i hmode",
            ro = "nu exista sincronizare pt. pagini (%s) in hmode",
        },
        ["interactions:5"] = {
            cs = "unknown attachment %s",
            de = "unknown attachment %s",
            en = "unknown attachment %s",
            fr = "le fichier joint %s est inconnu",
            it = "unknown attachment %s",
            nl = "onbekend attachment %s",
            no = "unknown attachment %s",
            ro = "unknown attachment %s",
        },
        ["interactions:6"] = {
            cs = "attachment file %s does not exist",
            de = "attachment file %s does not exist",
            en = "attachment file %s does not exist",
            fr = "le fichier joint %s n'existe pas",
            it = "attachment file %s does not exist",
            nl = "attachment file %s bestaat niet",
            no = "attachment file %s does not exist",
            ro = "attachment file %s does not exist",
        },
        ["languages:1"] = {
            cs = "vzory %s pro %s nacteny (n=%s,e=%s,m=%s)",
            de = "Trennmuster %s fuer %s geladen (n=%s,e=%s,m=%s)",
            en = "patterns %s for %s loaded (n=%s,e=%s,m=%s)",
            fr = "les motifs %s pour %s sont chargés (n=%s,e=%s,m=%s)",
            it = "schemi %s per %s caricati (n=%s,e=%s,m=%s)",
            nl = "afbreekpatronen %s voor %s geladen (n=%s,e=%s,m=%s)",
            no = "orddelingsmønster %s for %s er lest inn (n=%s,e=%s,m=%s)",
            ro = "sablonul %s pentru %s s-a incarcat (n=%s,e=%s,m=%s)",
        },
        ["languages:10"] = {
            cs = "vzory %s nacteny",
            de = "Trennmuster %s geladen",
            en = "patterns %s loaded",
            fr = "motifs %s chargés",
            it = "schemi %s caricati",
            nl = "patronen %sgeladen",
            no = "orddelingsmønster %s er lest inn",
            ro = "sabloanele %s incarcate",
        },
        ["languages:2"] = {
            cs = "zadne vzory %s pro %s (n=%s,e=%s,m=%s) (%s,%s)",
            de = "Keine Trennmuster %s fuer %s (n=%s,e=%s,m=%s) (%s,%s)",
            en = "no patterns %s for %s (n=%s,e=%s,m=%s) (%s,%s)",
            fr = "pas de motifs %s pour %s (n=%s,e=%s,m=%s) (%s,%s)",
            it = "niente schemi %s per %s (n=%s,e=%s,m=%s) (%s,%s)",
            nl = "geen afbreekpatronen %s voor %s (n=%s,e=%s,m=%s) (%s,%s)",
            no = "ingen orddelingsmønster %s for %s (n=%s,e=%s,m=%s) (%s,%s)",
            ro = "nu exista sabloane %s pentru %s (n=%s,e=%s,m=%s) (%s,%s)",
        },
        ["languages:3"] = {
            cs = "deleni slov %s pro %s nacteno (n=%s,e=%s,m=%s)",
            de = "Trenndefinitionen %s fuer %s geladen (n=%s,e=%s,m=%s)",
            en = "hyphenations %s for %s loaded (n=%s,e=%s,m=%s)",
            fr = "hyphenations %s pour %s chargés (n=%s,e=%s,m=%s)",
            it = "sillabazione %s per %s caricata (n=%s,e=%s,m=%s)",
            nl = "afbreekdefinities %s voor %s geladen (n=%s,e=%s,m=%s)",
            no = "orddelingsdefinisjon %s for %s er lest inn (n=%s,e=%s,m=%s)",
            ro = "despartirea in silabe %s pentru %s s-a incarcat (n=%s,e=%s,m=%s)",
        },
        ["languages:4"] = {
            cs = "zadne deleni slov %s pro %s (n=%s,e=%s,m=%s)",
            de = "Keine Trenndefinitionen %s fuer %s (n=%s,e=%s,m=%s)",
            en = "no hyphenations %s for %s (n=%s,e=%s,m=%s)",
            fr = "pas d'hyphenations %s pour %s (n=%s,e=%s,m=%s)",
            it = "niente sillabazione %s per %s (n=%s,e=%s,m=%s)",
            nl = "geen afbreekdefinities %s voor %s (n=%s,e=%s,m=%s)",
            no = "ingen orddelingsdefinisjon %s for %s (n=%s,e=%s,m=%s)",
            ro = "nu exista despartire in silabe %s pentru %s (n=%s,e=%s,m=%s)",
        },
        ["languages:5"] = {
            cs = "vzory pro %s nenacteny",
            de = "Trennmuster fuer %s nicht geladen",
            en = "patterns for %s not loaded",
            fr = "les motifs pour %s ne sont pas chargés",
            it = "schemi per %s non caricati",
            nl = "afbreekpatronen voor %s niet geladen",
            no = "orddelingsmønster for %s er ikke lest inn",
            ro = "sabloanele pentru %s nu sunt incarcate",
        },
        ["languages:6"] = {
            cs = "jazyk %s neni definovan",
            de = "Sprache %s ist undefiniert",
            en = "language %s is undefined",
            fr = "langue %s non définie",
            it = "lingua %s non definita",
            nl = "taal %s is niet gedefinieerd",
            no = "spràk %s er udefinert",
            ro = "limba %s nu este definita",
        },
        ["languages:7"] = {
            cs = "specificke volby jazyka [%s] zavadeji %s (zavlecenou) mezeru",
            de = "Sprachenspezifische Option [%s] fuegt eine Luecke von %s ein",
            en = "language specific options [%s] introduce a %s skip",
            fr = "les options spécifiques de langue [%s] introduisent un %s saut",
            it = "opzioni specifiche per la lingua [%s] introducono un salto %s",
            nl = "taal specifieke opties [%s] introduceren een skip van %s",
            no = "spràk spesifikk opsjon [%s] introduserer et %s hopp",
            ro = "optiunile specifice ale limbii [%s] introduc un spatiu %s",
        },
        ["languages:8"] = {
            cs = "specificke volby jazyka [%s] bez mezer pripojeny",
            de = "Sprachenspezifische Option [%s] nahtlos hinzugefuegt",
            en = "language specific options [%s] seamless appended",
            fr = "les options spécifiques de langue [%s] sont ajoutés en douceur",
            it = "opzioni specifiche per la lingua [%s] aggiunte trasparentemente",
            nl = "taal specifieke opties [%s] naadloos toegevoegd",
            no = "spràk spesifikk opsjon [%s] problemfritt tilføyd",
            ro = "optiunile specifice ale limbii [%s] adaugate",
        },
        ["languages:9"] = {
            cs = "language %s is active",
            de = "Sprache %s ist aktiv",
            en = "language %s is active",
            fr = "la langue %s est active",
            it = "lingua %s attiva",
            nl = "taal %s is actief",
            no = "spràk %s er aktivt",
            ro = "limba %s este activa",
        },
        ["layouts:1"] = {
            cs = "vyska textu prizpusobena s %s na strane %s",
            de = "Texthoehe angepasst mit %s auf Seite %s",
            en = "textheight adapted with %s at page %s",
            fr = "hauteurtexte adaptée avec %s à la page %s",
            it = "altezza del testo adattata con %s a pagina %s",
            nl = "teksthoogte aangepast met %s op pagina %s",
            no = "teksthøyde tilpasset med %s på side %s",
            ro = "textheight adaptat cu %s la pagina %s",
        },
        ["layouts:10"] = {
            cs = "%s a %s nedava dohromady 1.0",
            de = "%s und %s ergeben zusammen nicht 1.0",
            en = "%s and %s don't add up to 1.0",
            fr = "%s et %s ne sont pas ajoutés à 1.0",
            it = "%s e %s non sommano a 1.0",
            nl = "%s en %s tellen niet op tot 1.0",
            no = "%s og %s er ikke 1.0 til sammen",
            ro = "%s si %s nu se adauga pana la 1.0",
        },
        ["layouts:11"] = {
            cs = "svisla mezera %s neni povolena v pevnem radkovem rejstriku",
            de = "Zwischenraum %s nicht im Grittermoduserlau",
            en = "spacing %s not permitted in gridmode",
            fr = "espacement %s non permis en modegrille",
            it = "spaziatura %s non permessa in modo griglia",
            nl = "interlinie %s niet toegestaan in gridmode",
            no = "mellomrom %s ikke tillatt i gridmodus",
            ro = "spatierea %s nu este permisa in gridmode",
        },
        ["layouts:2"] = {
            cs = "%s krat odlozeny text umisten",
            de = "%s mal verschobener Text plaziert",
            en = "%s times postponed text placed",
            fr = "%s times postponed text placed",
            it = "posizionato testo posticipato %s volte",
            nl = "%s maal uitgestelde tekst tussengevoegd",
            no = "%s ganger forskjøvet tekst plassert",
            ro = "textul amanat de %s ori a fost plasat",
        },
        ["layouts:3"] = {
            cs = "%s krat text odlozen",
            de = "%s mal Text verschoben",
            en = "%s times text postponed",
            fr = "%s times text postponed",
            it = "testo posticipato %s volte",
            nl = "%s maal tekst plaatsen uitstellen",
            no = "%s ganger tekst forskjøvet",
            ro = "textul amanat de %s ori",
        },
        ["layouts:4"] = {
            cs = "okrajove bloky aktivni",
            de = "marginalbloecke aktiv",
            en = "marginblocks active",
            fr = "blocsmarge actifs",
            it = "blocchi in margine attivi",
            nl = "margeblokken actief",
            no = "margblokker aktive",
            ro = "blocuri marginale active",
        },
        ["layouts:5"] = {
            cs = "okrajove bloky neaktivni",
            de = "marginalbloecke inaktiv",
            en = "marginblocks inactive",
            fr = "blocsmarge inactifs",
            it = "blocchi in margine inattivi",
            nl = "margeblokken inactief",
            no = "margblokker inaktive",
            ro = "blocuri marginale inactive",
        },
        ["layouts:6"] = {
            cs = "sada stran %s zpracovana (velikost %s)",
            de = "Unterseitenfolge %s verarbeitet (Groesse %s)",
            en = "subpage set %s processed (size %s)",
            fr = "jeu de souspage %s traité (taille %s)",
            it = "gruppo di sottopagine %s elaborato (dimensione %s)",
            nl = "subpagina reeks %s verwerkt (aantal %s)",
            no = "delside sett %s behandlet (størrelse %s)",
            ro = "setul %s de subpagini procesat (dimensiunea %s)",
        },
        ["layouts:7"] = {
            cs = "pocita se misto pro logo",
            de = "berechne Platzbedarf des Logos",
            en = "calculating logospace",
            fr = "calcul de l'espace pour le logo",
            it = "calcolo dello spazio per logo",
            nl = "beeldmerken berekenen",
            no = "beregner plass for logo",
            ro = "se calculeaza spatiul pentru logo",
        },
        ["layouts:8"] = {
            cs = "pocita se pozadi",
            de = "berechne Hintergrund",
            en = "calculating backgrounds",
            fr = "calcul des arrières-plans",
            it = "calcolo dello sfondo",
            nl = "achtergronden berekenen",
            no = "beregner bakgrunn",
            ro = "se calculeaza fundalurile",
        },
        ["layouts:9"] = {
            cs = "aktualne ne vice nez %s urovne/urovni vyctu",
            de = "z.Z. nicht mehr als %s Ebenen in Aufzaehlungen",
            en = "currently no more than %s levels in itemizations",
            fr = "pas plus de %s niveaux pour l'instant dans les élémentarisations",
            it = "attualmente non più di %s livelli di elencazione",
            nl = "momenteel maximaal %s niveaus in opsommingen",
            no = "for øyeblikket maksimalt %s nivåer i opplisting",
            ro = "acum nu se supota mai mult de %s nivele de adancime la iteratii",
        },
        ["loaded: '%s'"] = {
            nl = "geladen: '%s'",
        },
        ["loaded: library '%s'"] = {
            nl = "geladen: bibliotheek '%s'",
        },
        ["loading: '%s'"] = {
            nl = "laden: '%s'",
        },
        ["locating: '%s'"] = {
            nl = "zoeken: '%s'",
        },
        ["not found: '%s'"] = {
            nl = "niet gevonden: '%s'",
        },
        ["number 1: %s, number 2: %s"] = {
            en = "number 1: (%s), number 2: (%s)",
            nl = "nummer 1: (%s), nummer 2: (%s)",
        },
        ["popping level: %s"] = {
            nl = "niveau omlaag: %s",
        },
        ["publications:1"] = {
            en = "file %s not found, unknown style ignored",
        },
        ["publications:2"] = {
            en = "file %s not found, waiting for bibtex",
        },
        ["publications:3"] = {
            en = "wrote a new auxiliary file \\jobname.aux",
        },
        ["publications:4"] = {
            en = "loading database from %s",
        },
        ["publications:5"] = {
            en = "warning: unknown cite argument %s on line \\the\\inputlineno",
        },
        ["publications:6"] = {
            en = "loading formatting style from %s",
        },
        ["publications:7"] = {
            en = "placing all entries, use 'text' to be more selective",
        },
        ["pushing level: %s"] = {
            nl = "niveau omhoog: %s",
        },
        ["references:1"] = {
            cs = "neznama reference %s",
            de = "unbekannte Referenz %s",
            en = "unknown reference %s",
            fr = "réference %s inconnue",
            it = "riferimento sconosciuto %s",
            nl = "onbekende verwijzing %s",
            no = "ukjent referanse %s",
            ro = "referinta necunoscuta %s",
        },
        ["references:2"] = {
            cs = "duplicitni reference %s na strane %s",
            de = "doppelte Referenz %s auf Seite %s",
            en = "duplicate reference %s on page %s",
            fr = "réference %s dupliquée à la page %s",
            it = "riferimento duplicato %s a pagina %s",
            nl = "dubbele verwijzing %s op pagina %s",
            no = "duplikat referanse %s pø side %s",
            ro = "referinta duplicat %s la pagina %s",
        },
        ["references:21"] = {
            cs = "dokument %s nacten",
            de = "Dokument %s geladen",
            en = "document %s loaded",
            fr = "document %s chargé",
            it = "documento %s caricato",
            nl = "document %s geladen",
            no = "dokument %s er lest inn",
            ro = "documentul %s este incarcat",
        },
        ["references:22"] = {
            cs = "dokument %s neni interaktivni",
            de = "Dokument %s ist nicht aktiv",
            en = "document %s is not interactive",
            fr = "le document %s n'est pas interactif",
            it = "il documento %s non ø interattivo",
            nl = "document %s is niet interactief",
            no = "dokument %s er ikke interaktivt",
            ro = "documentul %s nu este interactiv",
        },
        ["references:23"] = {
            cs = "obskurni (nejasna) reference %s (prefix=%s)",
            de = "Obskure Referenz %s (Prefix=%s)",
            en = "obscure reference %s (prefix=%s)",
            fr = "reference %s indéterminé (préfixe=%s)",
            it = "riferimento ambiguo %s (prefisso=%s)",
            nl = "onduidelijke verwijzing %s (prefix=%s)",
            no = "obskur referanse %s (Prefix=%s)",
            ro = "referinta obscura %s (prefix=%s)",
        },
        ["references:24"] = {
            en = "references from document '%s' are not exported",
        },
        ["references:25"] = {
            en = "references from document '%s' are not imported (export again)",
        },
        ["references:26"] = {
            en = "references from document '%s' are imported",
        },
        ["references:3"] = {
            cs = "neznamy typ reference %s",
            de = "unbekannte Referenz Typ %s",
            en = "unknown reference type %s",
            fr = "type %s de réference inconnu",
            it = "riferimento di tipo sconosciuto %s",
            nl = "type verwijzing %s onbekend",
            no = "ukjent referansetype %s",
            ro = "tip necunoscut de referinta %s",
        },
        ["references:30"] = {
            cs = "neznamy objekt %s",
            de = "unbekanntes Object %s",
            en = "unknown object %s",
            fr = "objet %s inconnu",
            it = "oggetto sconosciuto %s",
            nl = "onbekend object %s",
            no = "ukjent objekt %s",
            ro = "obiect necunoscut %s",
        },
        ["references:31"] = {
            cs = "duplicitni object %s",
            de = "doppeltes Object %s",
            en = "duplicate object %s",
            fr = "objet %s dupliqué",
            it = "oggetto duplicato %s",
            nl = "dubbel object %s",
            no = "duplikat objekt %s",
            ro = "obiect duplicat %s",
        },
        ["references:4"] = {
            cs = "nedovolena reference %s",
            de = "illegale Referenz %s",
            en = "illegal reference %s",
            fr = "réference %s inconnue",
            it = "riferimento illecito %s",
            nl = "verboden verwijzing %s",
            no = "ulovlig referanse %s",
            ro = "referinta eronata %s",
        },
     -- ["number of unknown references: %s"] = {
     -- },
        ["references:6"] = {
            en = "number of illegal references: %s",
        },
        ["start: '%s'"] = {
        },
        ["stop: '%s'"] = {
        },
        ["stored: preamble '%s', state '%s', order '%s'"] = {
            nl = "opgeslagen: preamble '%s', status '%s', volgorde '%s'",
        },
        ["structures:1"] = {
            cs = "zacatek oddilu (sekce) %s",
            de = "Begin des Abschnittsblocks %s",
            en = "begin of sectionblock %s",
            fr = "début de blocsection %s",
            it = "inizio del blocco (sezione) %s",
            nl = "begin van sectieblok %s",
            no = "starten av blokk %s (seksjon)",
            ro = "inceput de bloc sectiune %s",
        },
        ["structures:2"] = {
            cs = "konec oddilu (sekce) %s",
            de = "Ende des Abschnittsblocks %s",
            en = "end of sectionblock %s",
            fr = "fin de blocsection %s",
            it = "fine del blocco (sezione) %s",
            nl = "eind van sectieblok %s",
            no = "slutten av blokk %s (seksjon)",
            ro = "sfarsit de bloc sectiune %s",
        },
        ["symbols:1"] = {
            cs = "nacita se soubor symbolu %s",
            de = "Lade Symboldatei %s",
            en = "loading symbolset %s",
            fr = "chargement du jeu de symbole %s",
            it = "caricamento gruppo di simboli %s",
            nl = "symboolset %s wordt geladen",
            no = "leser inn symbolsett %s",
            ro = "se incarca setul de simboluri %s",
        },
        ["system:1"] = {
            cs = "nacteni pomocneho souboru odlozeno (typemode)",
            de = "Laden der Hilfsdatei aufgeschoben (Eingabe-Modus)",
            en = "loading utility-file postponed (typemode)",
            fr = "chargement de fichier utilitaire reporté (typemode)",
            it = "caricamento dei file supplementari posticipato (typemode)",
            nl = "laden hulpfile uitgesteld (typemode)",
            no = "innlesning av hjelpefila utsatt (typemode)",
            ro = "se incarca utilitarul-fisierul este amanat (typemode)",
        },
        ["system:10"] = {
            cs = "nepouzivejte em v %s",
            de = "Benutzte kein em in %s",
            en = "don't use em in %s",
            fr = "n'utilisez pas em dans %s",
            it = "non usare em in %s",
            nl = "gebruik geen em in %s",
            no = "ikke bruk em i %s",
            ro = "nu folositi em in %s",
        },
        ["system:11"] = {
            cs = "vytvarim jednoduchy pomocny soubor",
            de = "Erstelle einfache Hilfdatei",
            en = "building simple util",
            fr = "construction util simple",
            it = "costruzione di un semplice supplemento",
            nl = "aanmaken basale hulpfile",
            no = "lager enkel hjelpefil",
            ro = "se creeaza un utilitar simplu",
        },
        ["system:12"] = {
            cs = "pomosny soubor neni setriden, pouzijte texutil",
            de = "Die Hilfdatei ist nicht sortiert, verwende texutil",
            en = "the utility-file is not sorted, use texutil",
            fr = "le fichier utilitaire n'est pas trié, utilise texutil",
            it = "file di supplemento non ordinato, usare texutil",
            nl = "de hulpfile is niet gesorteerd, gebruik texutil",
            no = "hjelpefila er ikke sortert, bruk texutil",
            ro = "fisierul utilitar nu este sortat, folositi texutil",
        },
        ["system:13"] = {
            cs = "znacka %s definovana %s",
            de = "Beschriftung %s definiert %s",
            en = "mark %s defined %s",
            fr = "marquage %s defini %s",
            it = "marcatura %s definita %s",
            nl = "markering %s gedefinieerd %s",
            no = "markering %s definert %s",
            ro = "marcajul %s definit %s",
        },
        ["system:14"] = {
            cs = "vynucena nova stranka v seznamu na %s",
            de = "Erzwungendes Seitenumbruch in Liste bei %s",
            en = "forced newpage in list at %s",
            fr = "nouvellepage forcée dans la liste à %s",
            it = "nuova pagina obbligata in lista a %s",
            nl = "geforceerde paginaovergang in lijst voor %s",
            no = "tvunget sideskift i liste ved %s",
            ro = "s-a fortat trecere pa pagina noua in lista la %s",
        },
        ["system:15"] = {
            cs = "uklada se buffer %s",
            de = "Speichere Buffer %s",
            en = "saving buffer %s",
            fr = "sauvegarde du tampon (buffer) %s",
            it = "salvataggio del buffer %s",
            nl = "wegschrijven buffer %s",
            no = "lagrer Buffer %s",
            ro = "buffer salvat %s",
        },
        ["system:16"] = {
            cs = "sazi se buffer %s",
            de = "Setzte Buffer %s",
            en = "typesetting buffer %s",
            fr = "composition du tampon (buffer) %s",
            it = "composizione del buffer %s",
            nl = "inlezen buffer %s",
            no = "tegnsetter buffer %s",
            ro = "buffer-ul %s s-a cules",
        },
        ["system:17"] = {
            cs = "sazi se doslovny (verbatim) buffer %s",
            de = "Setzte tippen-Buffer %s",
            en = "typesetting verbatim buffer %s",
            fr = "composition textuelle du tampon (buffer) %s",
            it = "composizione verbatim del buffer %s",
            nl = "verbatim inlezen buffer %s",
            no = "tegnsetter verbatim-buffer %s",
            ro = "se culege buffer-ul verbatim %s",
        },
        ["system:18"] = {
            cs = "synonymum %s %s neexistuje",
            de = "Synonym %s %s existiert nicht",
            en = "synonym %s %s does not exist",
            fr = "le synonyme %s %s n'existe pas",
            it = "sinonimo %s %s non esistente",
            nl = "synoniem %s %s bestaat niet",
            no = "synonym %s %s eksisterer ikke",
            ro = "sinonimul %s %s nu exista",
        },
        ["system:19"] = {
            cs = "vyznam (synonyma) %s nacten",
            de = "Bedeutung (synonyme) von %s geladen",
            en = "meaning (synonyms) of %s loaded",
            fr = "signification (synonymes) de %s chargée",
            it = "significato (sinonimi) di %s caricato",
            nl = "betekenissen (synoniemen) van %s geladen",
            no = "betydning (synonymer) av %s er lest inn",
            ro = "intelesul (sinonimele) pentru %s incarcat",
        },
        ["system:2"] = {
            cs = "%s nacteno",
            de = "%s geladen",
            en = "%s loaded",
            fr = "%s chargé",
            it = "%s caricato",
            nl = "%s geladen",
            no = "%s er lest inn",
            ro = "%s s-a incarcat",
        },
        ["system:20"] = {
            cs = "vyznam (trideni) %s nacten",
            de = "Bedeutung (sortieren) von %s geladen",
            en = "meaning (sorts) of %s loaded",
            fr = "signification (tris) de %s chargée",
            it = "significato (specie) di %s caricato",
            nl = "betekenissen (sorteren) van %s geladen",
            no = "betydning (sorterer) av %s er lest inn",
            ro = "intelesul (ordinea) pentru %s incarcat",
        },
        ["system:21"] = {
            cs = "pomocny soubor necten",
            de = "Die Hilfsdatei ist nicht geladen",
            en = "no utility data is loaded",
            fr = "pas de données utilitaires chargées",
            it = "nessuna informazione supplementare caricata",
            nl = "de hulpfile is niet geladen",
            no = "hjelpefila er ikke lest inn",
            ro = "nici o data utilitara nu este incarcata",
        },
        ["system:22"] = {
            cs = "pouzijte platny pomocny soubor",
            de = "Benoetige gueltige Hilfsdateie",
            en = "use a valid utilityfile",
            fr = "utilise un fichier utilitaire valide",
            it = "usare un file supplementare valido",
            nl = "gebruik een goede hulpfile",
            no = "bruk en gyldig hjelpefil",
            ro = "folositi un fisier utilitar valid",
        },
        ["system:23"] = {
            cs = "%s upraveno na %s",
            de = "%s angeordnet auf %s",
            en = "%s arranged at %s",
            fr = "%s arrangé à %s",
            it = "%s sistemato a %s",
            nl = "%s gearrangeerd op %s",
            no = "%s arrangert på %s",
            ro = "%s aranjat la %s",
        },
        ["system:24"] = {
            cs = "plovouci bloky",
            de = "Fliessbloecke",
            en = "Floatblocks",
            fr = "blocsflottants",
            it = "Oggetti mobili",
            nl = "Plaatsblokken",
            no = "Flytblokker",
            ro = "Blocuri",
        },
        ["system:25"] = {
            cs = "reference",
            de = "Referenzen",
            en = "References",
            fr = "Réferences",
            it = "Riferimenti",
            nl = "Verwijzingen",
            no = "Referanser",
            ro = "Referinte",
        },
        ["system:26"] = {
            cs = "registry",
            de = "Register",
            en = "Registers",
            fr = "Registres",
            it = "Registri",
            nl = "Registers",
            no = "Registere",
            ro = "Registri",
        },
        ["system:27"] = {
            cs = "verze",
            de = "Version",
            en = "Version",
            fr = "Version",
            it = "Versione",
            nl = "Versie",
            no = "Versjon",
            ro = "Versiune",
        },
        ["system:4"] = {
            cs = "prikaz %s je jiz definovan",
            de = "Befehl %s ist bereits definiert",
            en = "command %s is already defined",
            fr = "la commande %s est déjà définie",
            it = "comando %s già definito",
            nl = "commando %s is al gedefinieerd",
            no = "kommando %s er allerede definert",
            ro = "comanda %s este deja definita",
        },
        ["system:41"] = {
            cs = "externi soubor %s ve skupine %s neexistuje",
            de = "Externe Datei %s in Gruppe %s existiert nicht",
            en = "external file %s in group %s does not exist",
            fr = "le fichier externe %s du groupe %s n'existe pas",
            it = "il file esterno %s del gruppo %s non esiste",
            nl = "externe file %s in groep %s bestaat niet",
            no = "ekstern fil %s i gruppe %s eksisterer ikke",
            ro = "fisierul extern %s din grupul %s nu exista",
        },
        ["system:5"] = {
            cs = "makra z %s nactena",
            de = "Modul %s geladen",
            en = "module %s loaded",
            fr = "module %s chargé",
            it = "macro del modulo %s caricate",
            nl = "module %s geladen",
            no = "makroene i modul  %s er lest inn",
            ro = "macro-urile din modulul %s s-au incarcat",
        },
        ["system:6"] = {
            cs = "zadna makra v %s nenalezena",
            de = "Modul %s gefunden",
            en = "module %s not found",
            fr = "module %s non trouvé",
            it = "nessuna macro trovata nel modulo %s",
            nl = "geen module %s gevonden",
            no = "ingen makroer funnet i modul %s-",
            ro = "nu s-au gasit macro-uri in modulul %s",
        },
        ["system:7"] = {
            cs = "makra z %s jsou jiz nactena",
            de = "Modul %s bereits geladen",
            en = "module %s already loaded",
            fr = "module %s déjà chargé",
            it = "macro del modulo %s già caricate",
            nl = "module %s reeds geladen",
            no = "makroene i modul %s er allerede lest inn",
            ro = "macro-urile din modulul %s s-au incarcat deja",
        },
        ["system:8"] = {
            cs = "nova verze pomocneho souboru, je treba druheho behu",
            de = "Neue Version der Hilfsdatei, zweiter Durchlauf benoetigt",
            en = "new version of utility file, second pass needed",
            fr = "nouvelle version de fichier utilitaire, seconde passe nécessaire",
            it = "nuova versione del file supplementare, seconda passata necessaria",
            nl = "nieuwe versie hulpfile, tweede run nodig",
            no = "ny versjon av hjelpefil, andre gjennomkjøring nødvendig",
            ro = "o noua versiune de fisier utilitar, este necesara o noua trecere",
        },
        ["system:9"] = {
            cs = "%s nenalezeno/nezpracovano",
            de = "%s nicht gefunden/verarbeitet",
            en = "%s not found/processed",
            fr = "%s non trouvé/traité",
            it = "%s non trovato/elaborato",
            nl = "%s niet gevonden/geplaatst",
            no = "%s ikke funnet/behandlet",
            ro = "%s nu este gasit/procesat",
        },
        ["system:91"] = {
            en = "papertray %s",
            nl = "papierlade %s",
        },
        ["textblocks:1"] = {
            cs = "nova verze, je treba druhy beh",
            de = "neue Version, zweiter Durchlauf benoetigt",
            en = "new version, second pass needed",
            fr = "nouvelle version, une seconde passe est nécessaire",
            it = "nuova versione, seconda passata necessaria",
            nl = "nieuwe versie, tweede run nodig",
            no = "ny versjon, andre gjennomkjøring nødvendig",
            ro = "o noua versiune, este nevoie de inca o trecere",
        },
        ["textblocks:10"] = {
            cs = "%s nacteno a zpracovano",
            de = "%s geladen und verarbeitet",
            en = "%s loaded and processed",
            fr = "%s chargé et traité",
            it = "%s caricato ed elaborato",
            nl = "%s geladen en verwerkt",
            no = "%s lest inn og behandlet",
            ro = "%s incarcat si procesat",
        },
        ["textblocks:11"] = {
            cs = "%s nacteno a vysazeno",
            de = "%s geladen und gesetzt",
            en = "%s loaded and typeset",
            fr = "%s chargé et composé",
            it = "%s caricato e composto",
            nl = "%s geladen en geplaatst",
            no = "%s lest inn og tegnsatt",
            ro = "%s incarcat si cules",
        },
        ["textblocks:12"] = {
            cs = "%s preskoceno",
            de = "%s ausgelassen",
            en = "%s skipped",
            fr = "%s sauté",
            it = "%s saltato",
            nl = "%s overgeslagen",
            no = "%s utelatt",
            ro = "%s sarit peste",
        },
        ["textblocks:2"] = {
            cs = "zapisuji bloky do %s",
            de = "schreibe Bloecke zu %s",
            en = "writing blocks to %s",
            fr = "ecriture des blocs vers %s",
            it = "scrittura dei blocchi su %s",
            nl = "wegschrijven blokken naar %s",
            no = "skriver blokker til %s",
            ro = "se scriu blocurile in %s",
        },
        ["textblocks:3"] = {
            cs = "ctu bloky z %s",
            de = "lese Bloecke von %s",
            en = "reading blocks from %s",
            fr = "lecture des blocs en provenance de %s",
            it = "lettura dei blocchi da %s",
            nl = "inlezen blokken uit %s",
            no = "leser blokker fra %s",
            ro = "se citesc blocurile din %s",
        },
        ["textblocks:4"] = {
            cs = "je treba druhy beh",
            de = "zweiter Durchlauf benoetigt",
            en = "second pass needed",
            fr = "seconde passe nécessaire",
            it = "seconda passata necessaria",
            nl = "er is een tweede run nodig",
            no = "andre gjennomkjøring nødvendig",
            ro = "este nevoie de inca o trecere",
        },
        ["textblocks:5"] = {
            cs = "%s neni skryto",
            de = "%s nicht verborgen",
            en = "%s not hidden",
            fr = "%s non caché",
            it = "%s non nascosto",
            nl = "%s niet verborgen",
            no = "%s ikke skjult",
            ro = "%s nu este ascuns",
        },
        ["textblocks:6"] = {
            cs = "%s skryto a zpracovano",
            de = "%s verborgen und verarbeitet",
            en = "%s hidden and processed",
            fr = "%s caché et traité",
            it = "%s nascosto ed elaborato",
            nl = "%s verborgen en verwerkt",
            no = "%s skjult og behandlet",
            ro = "%s ascuns si procesat",
        },
        ["textblocks:7"] = {
            cs = "%s skryto",
            de = "%s verborgen",
            en = "%s hidden",
            fr = "%s caché",
            it = "%s nascosto",
            nl = "%s verborgen",
            no = "%s skjult",
            ro = "%s ascuns",
        },
        ["textblocks:8"] = {
            cs = "%s vysazeno",
            de = "%s gesetzt",
            en = "%s typeset",
            fr = "%s composé",
            it = "%s composto",
            nl = "%s gehandhaafd",
            no = "%s tegnsatt",
            ro = "%s cules",
        },
        ["textblocks:9"] = {
            cs = "%s nevysazeno",
            de = "%s nicht gesetzt",
            en = "%s not typeset",
            fr = "%s non composé",
            it = "%s non composto",
            nl = "%s niet gehandhaafd",
            no = "%s ikke tegnsatt",
            ro = "%s nu este cules",
        },
        ["unknown: library '%s'"] = {
            nl = "onbekend: bibliotheek '%s'",
        },
        ["used: code '%s'"] = {
            nl = "gebruikt: code '%s'",
        },
        ["used: code '%s', preamble '%s'"] = {
            nl = "gebruikt: code '%s', preamble '%s'",
        },
        ["used: function '%s'"] = {
            nl = "gebruikt: functie '%s'",
        },
        ["used: preamble '%s', state '%s', order '%s'"] = {
            nl = "gebruikt: preamble '%s', status '%s', volgorde '%s'",
        },
        ["vector '%s' is loaded"] = {
            nl = "vector '%s' is geladen",
        },
        ["vector '%s' is unknown"] = {
            nl = "onbekende vector '%s'",
        },
        ["verbatims:1"] = {
            cs = "soubor %s neexistuje",
            de = "Datei %s existiert nicht",
            en = "file %s does not exist",
            fr = "le fichier %s n'existe pas",
            it = "il file %s non esiste",
            nl = "file %s bestaat niet",
            no = "fil %s eksisterer ikke",
            ro = "fisierul %s nu exista",
        },
    },
    translations = {
        check = {
            cs = "kontrola",
            de = "check",
            en = "check",
            fr = "vérification",
            it = "controllo",
            nl = "controle",
            no = "kontroll",
            ro = "verificari",
        },
        colors = {
            cs = "barva",
            de = "farbe",
            en = "colors",
            fr = "couleurs",
            it = "colore",
            nl = "kleuren",
            no = "farge",
            ro = "culori",
        },
        columns = {
            cs = "sloupce",
            de = "Spalten",
            en = "columns",
            fr = "colonnes",
            it = "colonne",
            nl = "kolommen",
            no = "kolonner",
            ro = "coloane",
        },
        databases = {
            cs = "databases",
            de = "Datenbank",
            en = "databases",
            fr = "bases de données",
            it = "database",
            nl = "database",
            no = "databaser",
            ro = "baze de date",
        },
        figures = {
            cs = "obrazy",
            de = "Abbildungen",
            en = "figures",
            fr = "figures",
            it = "figure",
            nl = "figuren",
            ro = "figuri",
        },
        files = {
            cs = "soubory",
            de = "files",
            en = "files",
            fr = "fichiers",
            it = "file",
            nl = "files",
            no = "filer",
            ro = "fisiere",
        },
        filters = {
            cs = "filters",
            de = "filters",
            en = "filters",
            fr = "filtre",
            it = "filtri",
            nl = "filters",
        },
        floatblocks = {
            cs = "plovouciobjekty",
            de = "Gleitobjektbloecke",
            en = "floatblocks",
            fr = "blocs de flottants",
            it = "oggetti mobili",
            nl = "plaatsblokken",
            no = "flytblokker",
            ro = "Blocuri",
        },
        fonts = {
            cs = "zakladnifont",
            de = "Fliesstext",
            en = "bodyfont",
            fr = "corps de texte",
            it = "font del corpo",
            nl = "korps",
            no = "hovedfont",
            ro = "corp de litere",
        },
        interactions = {
            cs = "interakce",
            de = "Interaktions",
            en = "interactions",
            fr = "interactions",
            it = "interazione",
            nl = "interacties",
            no = "interaksjon",
            ro = "interactiuni",
        },
        languages = {
            cs = "jazyky",
            de = "Sprache",
            en = "languages",
            fr = "langue",
            it = "lingua",
            nl = "talen",
            no = "sprøk",
            ro = "limbi",
        },
        layouts = {
            cs = "layouts",
            de = "Layouts",
            en = "layouts",
            fr = "calque",
            it = "layouts",
            nl = "layouts",
            no = "layouts",
            ro = "aranjamente",
        },
        numbers = {
            nl = "nummers",
        },
        publications = {
            en = "publications",
        },
        references = {
            cs = "reference",
            de = "referenzen",
            en = "references",
            fr = "réferences",
            it = "riferimenti",
            nl = "verwijzingen",
            no = "referanser",
            ro = "referinte",
        },
        regimes = {
            de = "Kodierungen",
            fr = "encodages",
            nl = "regimes",
        },
        structures = {
            cs = "struktury",
            de = "strukture",
            en = "structures",
            fr = "structures",
            it = "struttura",
            nl = "structuren",
            no = "struktur",
            ro = "structuri",
        },
        symbols = {
            cs = "symboly",
            de = "Symbole",
            en = "symbols",
            fr = "symboles",
            it = "simboli",
            nl = "symbolen",
            no = "symboler",
            ro = "simboluri",
        },
        system = {
            cs = "system",
            de = "system",
            en = "system",
            fr = "système",
            it = "sistema",
            nl = "systeem",
            no = "system",
            ro = "sistem",
        },
        textblocks = {
            cs = "textovyblok",
            de = "textblock",
            en = "textblocks",
            fr = "blocs de texte",
            it = "blocchi di testo",
            nl = "tekstblokken",
            no = "tekstblokker",
            ro = "blocuri de text",
        },
        verbatims = {
            cs = "verbatim",
            de = "verbatim",
            en = "verbatim",
            fr = "verbatim",
            it = "verbatim",
            nl = "typen",
            no = "verbatim",
            ro = "verbatim",
        },
    },
}
