Puppet::Type.type(:service).provide :openbsd, :parent => :init do

  desc "Provider for OpenBSD."

  confine :operatingsystem => [:openbsd]
  defaultfor :operatingsystem => [:openbsd]

  class << self
    attr_accessor :defpath
  end

  @defpath = "/etc/rc.d"

  def startcmd
    [self.initscript, :start]
  end

  def stopcmd
    [self.initscript, :stop]
  end

  def statuscmd
    [self.initscript, :check]
  end

  # A simple wrapper so execution failures are a bit more informative.
  # If an exception occurs, we show a warning instead of an error.
  def texecute(type, command, fof = true)
    begin
      # #565: Services generally produce no output, so squelch them.
      execute(command, :failonfail => fof, :squelch => true)
    rescue Puppet::ExecutionFailure => detail
      @resource.warning "Could not #{type} #{@resource.ref}: #{detail}"
    end
    nil
  end

end
