/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceInputStream
extends InputStream {
    private Iterator<InputStream> m_itInputStreams;
    private InputStream m_isCurrent;

    public SequenceInputStream(InputStream inputStream, InputStream inputStream2) {
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>(2);
        arrayList.add(inputStream);
        arrayList.add(inputStream2);
        this.m_itInputStreams = arrayList.iterator();
        try {
            this.useNextInputStream();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not use first InputStream in SequenceInputStream(List) : " + iOException);
        }
    }

    public SequenceInputStream(Iterator<InputStream> iterator) {
        this.m_itInputStreams = iterator;
        try {
            this.useNextInputStream();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not use first InputStream in SequenceInputStream(List) : " + iOException);
        }
    }

    private InputStream getCurrentInputStream() {
        return this.m_isCurrent;
    }

    private void useNextInputStream() throws IOException {
        this.closeCurrentInputStream();
        this.m_isCurrent = null;
        while (this.m_itInputStreams.hasNext()) {
            InputStream inputStream = this.m_itInputStreams.next();
            if (inputStream == null) continue;
            this.m_isCurrent = inputStream;
            break;
        }
    }

    private void closeCurrentInputStream() throws IOException {
        InputStream inputStream = this.getCurrentInputStream();
        if (inputStream != null) {
            inputStream.close();
        }
    }

    @Override
    public int available() throws IOException {
        InputStream inputStream = this.getCurrentInputStream();
        if (inputStream != null) {
            return inputStream.available();
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        while (true) {
            int n;
            InputStream inputStream;
            if ((inputStream = this.getCurrentInputStream()) == null) {
                this.useNextInputStream();
                inputStream = this.getCurrentInputStream();
                if (inputStream == null) {
                    return -1;
                }
            }
            if ((n = inputStream.read()) >= 0) {
                return n;
            }
            this.useNextInputStream();
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n >= byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("Offset: " + n + ", Length: " + n2 + ", Buffer length: " + byArray.length);
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            InputStream inputStream = this.getCurrentInputStream();
            if (inputStream == null) {
                this.useNextInputStream();
                inputStream = this.getCurrentInputStream();
                if (inputStream == null) {
                    if (n3 > 0) break;
                    return -1;
                }
            }
            if ((n4 = inputStream.read(byArray, n + n3, n2 - n3)) > 0) {
                n3 += n4;
                continue;
            }
            this.useNextInputStream();
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        do {
            this.useNextInputStream();
        } while (this.getCurrentInputStream() != null);
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public void mark(int n) {
        super.mark(n);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(": ");
        Vector<InputStream> vector = new Vector<InputStream>();
        while (this.m_itInputStreams.hasNext()) {
            InputStream inputStream = this.m_itInputStreams.next();
            stringBuffer.append("\n  ");
            stringBuffer.append(inputStream.toString());
            stringBuffer.append(",");
            vector.add(inputStream);
        }
        this.m_itInputStreams = vector.iterator();
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

