/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.ProcessInfo;
import com.jezhumble.javasysmon.ProcessVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class OsProcess {
    private final ArrayList children = new ArrayList();
    private final ProcessInfo processInfo;

    private OsProcess(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public static OsProcess createTree(ProcessInfo[] processTable) {
        int i;
        HashMap<Integer, OsProcess> processes = new HashMap<Integer, OsProcess>();
        OsProcess topLevelProcess = new OsProcess(null);
        for (i = 0; i < processTable.length; ++i) {
            OsProcess process = new OsProcess(processTable[i]);
            processes.put(new Integer(processTable[i].getPid()), process);
        }
        for (i = 0; i < processTable.length; ++i) {
            int pid = processTable[i].getPid();
            int ppid = processTable[i].getParentPid();
            OsProcess process = (OsProcess)processes.get(new Integer(pid));
            if (ppid == pid || !processes.containsKey(new Integer(ppid))) {
                topLevelProcess.children.add(process);
                continue;
            }
            ((OsProcess)processes.get((Object)new Integer((int)ppid))).children.add(process);
        }
        return topLevelProcess;
    }

    public List children() {
        return this.children;
    }

    public ProcessInfo processInfo() {
        return this.processInfo;
    }

    public OsProcess find(int pid) {
        if (this.processInfo != null && this.processInfo.getPid() == pid) {
            return this;
        }
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            OsProcess found = ((OsProcess)it.next()).find(pid);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void accept(ProcessVisitor processVisitor, int level) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            ((OsProcess)it.next()).accept(processVisitor, level + 1);
        }
        if (this.processInfo != null && processVisitor.visit(this, level)) {
            new JavaSysMon().killProcess(this.processInfo.getPid());
        }
    }
}

