/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.poifs.storage.RawDataBlock;
import org.apache.poi.util.IntList;
import org.apache.poi.util.LittleEndian;

public class BlockAllocationTableReader {
    private IntList _entries = new IntList();

    public BlockAllocationTableReader(int n, int[] nArray, int n2, int n3, BlockList blockList) throws IOException {
        this();
        int n4;
        if (n <= 0) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Illegal block count; minimum count is 1, got ").append(n).append(" instead"))));
        }
        ListManagedBlock[] listManagedBlockArray = new RawDataBlock[n];
        int n5 = Math.min(n, nArray.length);
        for (n4 = 0; n4 < n5; ++n4) {
            listManagedBlockArray[n4] = (RawDataBlock)blockList.remove(nArray[n4]);
        }
        if (n4 < n) {
            if (n3 < 0) {
                throw new IOException("BAT count exceeds limit, yet XBAT index indicates no valid entries");
            }
            int n6 = n3;
            int n7 = BATBlock.entriesPerXBATBlock();
            int n8 = BATBlock.getXBATChainOffset();
            for (int i = 0; i < n2; ++i) {
                n5 = Math.min(n - n4, n7);
                byte[] byArray = blockList.remove(n6).getData();
                int n9 = 0;
                for (int j = 0; j < n5; ++j) {
                    listManagedBlockArray[n4++] = (RawDataBlock)blockList.remove(LittleEndian.getInt(byArray, n9));
                    n9 += 4;
                }
                n6 = LittleEndian.getInt(byArray, n8);
                if (n6 == -2) break;
            }
        }
        if (n4 != n) {
            throw new IOException("Could not find all blocks");
        }
        this.setEntries(listManagedBlockArray, blockList);
    }

    BlockAllocationTableReader(ListManagedBlock[] listManagedBlockArray, BlockList blockList) throws IOException {
        this();
        this.setEntries(listManagedBlockArray, blockList);
    }

    BlockAllocationTableReader() {
    }

    ListManagedBlock[] fetchBlocks(int n, BlockList blockList) throws IOException {
        ArrayList<ListManagedBlock> arrayList = new ArrayList<ListManagedBlock>();
        int n2 = n;
        while (n2 != -2) {
            arrayList.add(blockList.remove(n2));
            n2 = this._entries.get(n2);
        }
        return arrayList.toArray(new ListManagedBlock[0]);
    }

    boolean isUsed(int n) {
        boolean bl = false;
        try {
            bl = this._entries.get(n) != -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return bl;
    }

    int getNextBlockIndex(int n) throws IOException {
        if (this.isUsed(n)) {
            return this._entries.get(n);
        }
        throw new IOException(String.valueOf(String.valueOf(new StringBuffer("index ").append(n).append(" is unused"))));
    }

    private void setEntries(ListManagedBlock[] listManagedBlockArray, BlockList blockList) throws IOException {
        int n = BATBlock.entriesPerBlock();
        for (int i = 0; i < listManagedBlockArray.length; ++i) {
            byte[] byArray = listManagedBlockArray[i].getData();
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                int n3 = LittleEndian.getInt(byArray, n2);
                if (n3 == -1) {
                    blockList.zap(this._entries.size());
                }
                this._entries.add(n3);
                n2 += 4;
            }
            listManagedBlockArray[i] = null;
        }
        blockList.setBAT(this);
    }
}

