/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression.function;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.expression.function.BasicFunctionExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringFunction
extends BasicFunctionExpression<String>
implements Serializable {
    public static final String NAME = "substring";
    private final Expression<String> value;
    private final Expression<Integer> start;
    private final Expression<Integer> length;

    public SubstringFunction(CriteriaBuilderImpl criteriaBuilder, Expression<String> value, Expression<Integer> start, Expression<Integer> length) {
        super(criteriaBuilder, String.class, NAME);
        this.value = value;
        this.start = start;
        this.length = length;
    }

    public SubstringFunction(CriteriaBuilderImpl criteriaBuilder, Expression<String> value, Expression<Integer> start) {
        this(criteriaBuilder, value, start, (Expression<Integer>)((Expression)null));
    }

    public SubstringFunction(CriteriaBuilderImpl criteriaBuilder, Expression<String> value, int start) {
        this(criteriaBuilder, value, new LiteralExpression<Integer>(criteriaBuilder, start));
    }

    public SubstringFunction(CriteriaBuilderImpl criteriaBuilder, Expression<String> value, int start, int length) {
        this(criteriaBuilder, value, new LiteralExpression<Integer>(criteriaBuilder, start), new LiteralExpression<Integer>(criteriaBuilder, length));
    }

    public Expression<Integer> getLength() {
        return this.length;
    }

    public Expression<Integer> getStart() {
        return this.start;
    }

    public Expression<String> getValue() {
        return this.value;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getLength(), registry);
        ParameterContainer.Helper.possibleParameter(this.getStart(), registry);
        ParameterContainer.Helper.possibleParameter(this.getValue(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("substring(").append(((Renderable)this.getValue()).render(renderingContext)).append(',').append(((Renderable)this.getStart()).render(renderingContext));
        if (this.getLength() != null) {
            buffer.append(',').append(((Renderable)this.getLength()).render(renderingContext));
        }
        buffer.append(')');
        return buffer.toString();
    }
}

