/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.entity;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cache.jbc.access.TransactionalAccessDelegate;
import org.hibernate.cache.jbc.entity.EntityRegionImpl;

public class TransactionalAccess
implements EntityRegionAccessStrategy {
    protected final EntityRegionImpl region;
    private final TransactionalAccessDelegate delegate;

    public TransactionalAccess(EntityRegionImpl region) {
        this(region, new TransactionalAccessDelegate(region, region.getPutFromLoadValidator()));
    }

    protected TransactionalAccess(EntityRegionImpl region, TransactionalAccessDelegate delegate) {
        this.region = region;
        this.delegate = delegate;
    }

    public EntityRegion getRegion() {
        return this.region;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.delegate.get(key, txTimestamp);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version, minimalPutOverride);
    }

    public boolean insert(Object key, Object value, Object version) throws CacheException {
        return this.delegate.insert(key, value, version);
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return this.delegate.update(key, value, currentVersion, previousVersion);
    }

    public void remove(Object key) throws CacheException {
        this.delegate.remove(key);
    }

    public void removeAll() throws CacheException {
        this.delegate.removeAll();
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        return false;
    }
}

