/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public class EdgeNGramTokenizer
extends Tokenizer {
    public static final Side DEFAULT_SIDE;
    public static final int DEFAULT_MAX_GRAM_SIZE = 1;
    public static final int DEFAULT_MIN_GRAM_SIZE = 1;
    private int minGram;
    private int maxGram;
    private int gramSize;
    private Side side;
    private boolean started = false;
    private int inLen;
    private String inStr;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EdgeNGramTokenizer(Reader input, Side side, int minGram, int maxGram) {
        super(input);
        if (side == null) {
            throw new IllegalArgumentException("sideLabel must be either front or back");
        }
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.side = side;
    }

    public EdgeNGramTokenizer(Reader input, String sideLabel, int minGram, int maxGram) {
        this(input, Side.getSide(sideLabel), minGram, maxGram);
    }

    public final Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        if (!this.started) {
            this.started = true;
            char[] chars = new char[1024];
            this.input.read(chars);
            this.inStr = new String(chars).trim();
            this.inLen = this.inStr.length();
            this.gramSize = this.minGram;
        }
        if (this.gramSize > this.inLen) {
            return null;
        }
        if (this.gramSize > this.maxGram) {
            return null;
        }
        int start = this.side == Side.FRONT ? 0 : this.inLen - this.gramSize;
        int end = start + this.gramSize;
        reusableToken.setTermBuffer(this.inStr, start, this.gramSize);
        reusableToken.setStartOffset(start);
        reusableToken.setEndOffset(end);
        ++this.gramSize;
        return reusableToken;
    }

    static {
        $assertionsDisabled = !EdgeNGramTokenizer.class.desiredAssertionStatus();
        DEFAULT_SIDE = Side.FRONT;
    }

    public static class Side {
        private String label;
        public static Side FRONT = new Side("front");
        public static Side BACK = new Side("back");

        private Side(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Side getSide(String sideName) {
            if (FRONT.getLabel().equals(sideName)) {
                return FRONT;
            }
            if (BACK.getLabel().equals(sideName)) {
                return BACK;
            }
            return null;
        }
    }
}

