/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.xpath.ExprSingle;
import oracle.xml.xpath.InstanceOfExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class IfExpr
extends XSLExprBase {
    private XSLExprBase testExpr;

    IfExpr() {
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        if (xSLParseString.peekToken(10)) {
            IfExpr ifExpr = new IfExpr();
            ifExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            if (xSLParseString.peekToken() == 26) {
                throw new XPathException(1018, "if");
            }
            ifExpr.testExpr = XSLExpr.parse(xSLParseString);
            if (xSLParseString.nextToken() != 26) {
                throw new XPathException(1018, "if");
            }
            if (xSLParseString.nextToken() != 11) {
                throw new XPathException(1018, "if");
            }
            ifExpr.leftExpr = XSLExpr.parse(xSLParseString);
            if (xSLParseString.nextToken() != 12) {
                throw new XPathException(1018, "if");
            }
            ifExpr.rightExpr = ExprSingle.parse(xSLParseString);
            ifExpr.setExprType(ifExpr.leftExpr.getExprType() | ifExpr.rightExpr.getExprType());
            if (xSLParseString.isCachingExpr() && !ifExpr.canCacheExpr()) {
                ifExpr.cacheSubExpr();
            }
            return ifExpr;
        }
        return InstanceOfExpr.parse(xSLParseString);
    }

    void cacheSubExpr() throws XQException {
        if (this.testExpr.canCacheExpr()) {
            this.testExpr = this.testExpr.createCachedExpr();
        }
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
        if (this.rightExpr.canCacheExpr()) {
            this.rightExpr = this.rightExpr.createCachedExpr();
        }
    }

    boolean canCacheExpr() {
        return this.testExpr.canCacheExpr() && this.leftExpr.canCacheExpr() && this.rightExpr.canCacheExpr();
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(10);
        stringBuffer.append(this.testExpr.getNormalizedExpr());
        stringBuffer.append(11);
        stringBuffer.append(this.leftExpr.getNormalizedExpr());
        stringBuffer.append(12);
        stringBuffer.append(this.rightExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        return this.leftExpr.checkPosLastFN() || this.rightExpr.checkPosLastFN() || this.testExpr.checkPosLastFN();
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        xSLTContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.testExpr.evaluate(xSLTContext);
        if (XPathSequence.getBooleanValue(xSLTContext.popExprValue())) {
            this.leftExpr.evaluate(xSLTContext);
        } else {
            this.rightExpr.evaluate(xSLTContext);
        }
    }
}

