/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.Vector;
import oracle.net.TNSAddress.Description;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavAddressList;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavDescription
extends Description
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int descProcessed;
    private boolean done = false;

    public NavDescription(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        super(schemaObjectFactoryInterface);
    }

    public void navigate(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        stringBuffer.append("(DESCRIPTION=");
        try {
            if (this.SDU != null) {
                connStrategy.sdu = Integer.parseInt(this.SDU);
            }
            if (this.TDU != null) {
                connStrategy.tdu = Integer.parseInt(this.TDU);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        connStrategy.addSocketOptions(this.keepAlive);
        if (this.sourceRoute) {
            if (!this.backwardCompatibilityCase(this.children, connStrategy)) {
                this.activeChildren = this.children;
                ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(connStrategy, stringBuffer);
                for (int i = 1; i < this.activeChildren.size(); ++i) {
                    ((NavSchemaObject)this.activeChildren.elementAt(i)).addToString(connStrategy);
                }
            } else {
                this.setConnectionOption(connStrategy, stringBuffer);
            }
            this.closeNVPair(connStrategy);
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (int i = 0; i < this.activeChildren.size(); ++i) {
                ((NavSchemaObject)this.activeChildren.elementAt(i)).navigate(connStrategy, stringBuffer);
            }
            this.closeNVPair(connStrategy);
        }
        this.done = true;
    }

    public void closeNVPair(ConnStrategy connStrategy) {
        for (int i = connStrategy.cOpts.size() - 1; i >= 0 && !((ConnOption)connStrategy.cOpts.elementAt((int)i)).done; --i) {
            ConnOption connOption = (ConnOption)connStrategy.cOpts.elementAt(i);
            if (this.sourceRoute) {
                connOption.conn_data.append("(SOURCE_ROUTE=yes)");
            }
            connOption.conn_data.append("(CONNECT_DATA=");
            connOption.conn_data.append("(CID=(PROGRAM=)(HOST=__jdbc__)(USER=))");
            connOption.conn_data.append(this.connectData);
            connOption.conn_data.append(")");
            if (this.SID != null) {
                connOption.sid = this.SID;
            }
            if (this.serviceName != null) {
                connOption.service_name = this.serviceName;
            }
            if (this.instanceName != null) {
                connOption.instance_name = this.instanceName;
            }
            connOption.conn_data.append(")");
            connOption.done = true;
        }
    }

    public void addToString(ConnStrategy connStrategy) {
    }

    private boolean backwardCompatibilityCase(Vector vector, ConnStrategy connStrategy) {
        if (vector.size() == 1 && ((NavSchemaObject)vector.elementAt(0)).isA() == 1 && !((NavAddressList)vector.elementAt((int)0)).sourceRoute) {
            NavAddressList navAddressList = (NavAddressList)vector.elementAt(0);
            int n = navAddressList.getChildrenSize();
            if (n == 0) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (navAddressList.getChildrenType(i) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setConnectionOption(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        stringBuffer.append("(ADDRESS_LIST=");
        NavAddressList navAddressList = (NavAddressList)this.children.elementAt(0);
        NavAddress navAddress = navAddressList.getChild(0);
        int n = navAddressList.getChildrenSize();
        navAddress.navigate(connStrategy, stringBuffer);
        for (int i = 1; i < n; ++i) {
            navAddressList.getChild(i).addToString(connStrategy);
        }
        ((ConnOption)connStrategy.cOpts.elementAt((int)0)).conn_data.append(")");
    }
}

