/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GetCharSetError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CError;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.SQLName;
import oracle.sql.converter.CharacterSetMetaData;

public class T2CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    short[] queryMetaData1 = null;
    byte[] queryMetaData2 = null;
    int queryMetaData1Offset = 0;
    int queryMetaData2Offset = 0;
    private Properties nativeInfo;
    static final int QMD_dbtype = 0;
    static final int QMD_dbsize = 1;
    static final int QMD_nullok = 2;
    static final int QMD_precision = 3;
    static final int QMD_scale = 4;
    static final int QMD_formOfUse = 5;
    static final int QMD_columnNameLength = 6;
    static final int QMD_tdo0 = 7;
    static final int QMD_tdo1 = 8;
    static final int QMD_tdo2 = 9;
    static final int QMD_tdo3 = 10;
    static final int QMD_charLength = 11;
    static final int QMD_typeNameLength = 12;
    static final int T2C_LOCATOR_MAX_LEN = 16;
    static final int T2C_LINEARIZED_LOCATOR_MAX_LEN = 4000;
    static final int T2C_LINEARIZED_BFILE_LOCATOR_MAX_LEN = 530;
    static final int METADATA1_INDICES_PER_COLUMN = 13;
    protected static final int SIZEOF_QUERYMETADATA2 = 8;
    int queryMetaData1Size = 100;
    int queryMetaData2Size = 800;
    long m_nativeState;
    short m_clientCharacterSet;
    byte m_byteAlign;
    private static final int EOJ_SUCCESS = 0;
    private static final int EOJ_ERROR = -1;
    private static final int EOJ_WARNING = 1;
    private static final String OCILIBRARY = "ocijdbc10";
    private int logon_mode = 0;
    static final int LOGON_MODE_DEFAULT = 0;
    static final int LOGON_MODE_SYSDBA = 2;
    static final int LOGON_MODE_SYSOPER = 4;
    static final int LOGON_MODE_CONNECTION_POOL = 5;
    static final int LOGON_MODE_CONNPOOL_CONNECTION = 6;
    static final int LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
    static final int LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
    static final int T2C_PROXYTYPE_NONE = 0;
    static final int T2C_PROXYTYPE_USER_NAME = 1;
    static final int T2C_PROXYTYPE_DISTINGUISHED_NAME = 2;
    static final int T2C_PROXYTYPE_CERTIFICATE = 3;
    private static boolean isLibraryLoaded;
    OracleOCIFailover m_appCbk = null;
    Object m_cbkObj = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    protected T2CConnection(String string, String string2, String string3, String string4, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        super(string, string2, string3, string4, properties, oracleDriverExtension);
        this.initialize();
    }

    protected void initialize() {
        this.allocQueryMetaDataBuffers();
    }

    private void allocQueryMetaDataBuffers() {
        this.queryMetaData1Offset = 0;
        this.queryMetaData1 = new short[this.queryMetaData1Size * 13];
        this.queryMetaData2Offset = 0;
        this.queryMetaData2 = new byte[this.queryMetaData2Size];
        this.namedTypeAccessorByteLen = 0;
        this.refTypeAccessorByteLen = 0;
    }

    void reallocateQueryMetaData(int n, int n2) {
        this.queryMetaData1 = null;
        this.queryMetaData2 = null;
        this.queryMetaData1Size = Math.max(n, this.queryMetaData1Size);
        this.queryMetaData2Size = Math.max(n2, this.queryMetaData2Size);
        this.allocQueryMetaDataBuffers();
    }

    protected void logon() throws SQLException {
        if (this.database == null) {
            DatabaseError.throwSqlException(64);
        }
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary(this.connectionProperties);
        }
        if (this.connectionProperties.getProperty("is_connection_pooling") == "true") {
            this.processOCIConnectionPooling();
        } else {
            byte[] byArray;
            byte[] byArray2;
            String string;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            String string2 = this.connectionProperties.getProperty("OCISvcCtxHandle");
            if (string2 != null && (string = this.connectionProperties.getProperty("OCIEnvHandle")) != null) {
                String string3;
                l = Long.parseLong(string2);
                l2 = Long.parseLong(string);
                String string4 = this.connectionProperties.getProperty("OCIErrHandle");
                if (string4 != null) {
                    l3 = Long.parseLong(string4);
                }
                if ((string3 = this.connectionProperties.getProperty("JDBCDriverCharSetId")) != null) {
                    this.m_clientCharacterSet = new Integer(string3).shortValue();
                } else {
                    DatabaseError.throwSqlException(89);
                }
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                short[] sArray = new short[3];
                this.m_warning = this.checkError(this.t2cUseConnection(this.m_nativeState, l2, l, l3, sArray), this.m_warning);
                this.conversion = new DBConversion(sArray[0], this.m_clientCharacterSet, sArray[1]);
                this.m_byteAlign = (byte)(sArray[2] & 0xFF);
                return;
            }
            String string5 = this.connectionProperties.getProperty("internal_logon");
            if (string5 == null) {
                this.logon_mode = 0;
            } else if (string5.equalsIgnoreCase("SYSDBA")) {
                this.logon_mode = 2;
            } else if (string5.equalsIgnoreCase("SYSOPER")) {
                this.logon_mode = 4;
            }
            String string6 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            String string7 = null;
            byte[] byArray5 = new byte[]{};
            if (this.connectionProperties != null) {
                string7 = (String)this.connectionProperties.get("OCINewPassword");
            }
            if (string6 != null && string6.equalsIgnoreCase("true")) {
                this.m_clientCharacterSet = T2CConnection.getDriverCharSetIdFromNLS_LANG(this.connectionProperties);
                if (string7 != null) {
                    byArray5 = DBConversion.stringToAsciiBytes(string7);
                }
            } else {
                this.m_clientCharacterSet = T2CConnection.getCharSetIds(this.user, this.password, string7, this.database, this.logon_mode, null, this.connectionProperties);
                if (string7 != null) {
                    byArray4 = DBConversion.stringToAsciiBytes(string7);
                    byArray5 = new byte[]{};
                }
            }
            byte[] byArray6 = byArray3 = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            if (byArray4 == null) {
                byArray4 = this.password == null ? new byte[]{} : DBConversion.stringToAsciiBytes(this.password);
            }
            byte[] byArray7 = DBConversion.stringToAsciiBytes(this.database);
            short[] sArray = new short[3];
            if (!Locale.getDefault().toString().equals("en")) {
                byArray2 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
                byArray = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
            } else {
                byArray = byArray2 = new byte[0];
            }
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.m_warning = this.m_nativeState == 0L ? this.checkError(this.t2cCreateState(byArray3, byArray3.length, byArray4, byArray4.length, byArray5, byArray5.length, byArray7, byArray7.length, this.m_clientCharacterSet, this.logon_mode, sArray, byArray2, byArray), this.m_warning) : this.checkError(this.t2cLogon(this.m_nativeState, byArray3, byArray3.length, byArray4, byArray4.length, byArray5, byArray5.length, byArray7, byArray7.length, this.logon_mode, sArray, byArray2, byArray), this.m_warning);
            this.conversion = new DBConversion(sArray[0], this.m_clientCharacterSet, sArray[1]);
            this.m_byteAlign = (byte)(sArray[2] & 0xFF);
        }
    }

    protected void logoff() throws SQLException {
        try {
            if (this.m_nativeState != 0L) {
                this.checkError(this.t2cLogoff(this.m_nativeState));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void open(OracleStatement oracleStatement) throws SQLException {
        byte[] byArray = oracleStatement.m_sql.getSql(this.m_process_escapes).getBytes();
        this.checkError(this.t2cCreateStatement(this.m_nativeState, 0L, byArray, byArray.length, oracleStatement, false, oracleStatement.row_prefetch));
    }

    void do_cancel() throws SQLException {
        this.checkError(this.t2cCancel(this.m_nativeState));
    }

    protected void do_setAutoCommit(boolean bl) throws SQLException {
        this.checkError(this.t2cSetAutoCommit(this.m_nativeState, bl));
    }

    protected void do_commit() throws SQLException {
        this.checkError(this.t2cCommit(this.m_nativeState));
    }

    protected void do_rollback() throws SQLException {
        this.checkError(this.t2cRollback(this.m_nativeState));
    }

    protected String do_getDatabaseProductVersion() throws SQLException {
        byte[] byArray = this.t2cGetProductionVersion(this.m_nativeState);
        return this.conversion.CharBytesToString(byArray, byArray.length);
    }

    protected short do_getVersionNumber() throws SQLException {
        short s = 0;
        try {
            String string = this.do_getDatabaseProductVersion();
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " .", false);
            String string2 = null;
            int n = 0;
            short s2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                try {
                    s2 = Integer.decode(string2).shortValue();
                    s = (short)(s * 10 + s2);
                    if (++n != 4) continue;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (s == -1) {
            s = 0;
        }
        return s;
    }

    public int getDefaultStreamChunkSize() {
        return 2000;
    }

    public ClobDBAccess createClobDBAccess() {
        return this;
    }

    public BlobDBAccess createBlobDBAccess() {
        return this;
    }

    public BfileDBAccess createBfileDBAccess() {
        return this;
    }

    public CLOB createClob(byte[] byArray) throws SQLException {
        return new CLOB(this, byArray);
    }

    public CLOB createClob(byte[] byArray, short s) throws SQLException {
        return new CLOB(this, byArray, s);
    }

    public BLOB createBlob(byte[] byArray) throws SQLException {
        return new BLOB(this, byArray);
    }

    public BFILE createBfile(byte[] byArray) throws SQLException {
        return new BFILE(this, byArray);
    }

    protected SQLWarning checkError(int n) throws SQLException {
        return this.checkError(n, null);
    }

    protected SQLWarning checkError(int n, SQLWarning sQLWarning) throws SQLException {
        switch (n) {
            case 0: {
                break;
            }
            case -1: 
            case 1: {
                int n2;
                T2CError t2CError = new T2CError();
                int n3 = -1;
                if (this.m_nativeState != 0L) {
                    n3 = this.t2cDescribeError(this.m_nativeState, t2CError, t2CError.m_errorMessage);
                } else {
                    DatabaseError.throwSqlException(8);
                }
                switch (t2CError.m_errorNumber) {
                    case 28: 
                    case 600: 
                    case 1012: 
                    case 1041: 
                    case 3113: 
                    case 3114: {
                        this.internalClose();
                    }
                }
                if (n3 == -1) {
                    DatabaseError.throwSqlException(1, "Fetch error message failed!");
                }
                for (n2 = 0; n2 < t2CError.m_errorMessage.length && t2CError.m_errorMessage[n2] != 0; ++n2) {
                }
                String string = this.conversion.CharBytesToString(t2CError.m_errorMessage, n2, true);
                String string2 = DatabaseError.ErrorToSQLState(t2CError.m_errorNumber);
                if (n == -1) {
                    DatabaseError.throwSqlException(string, string2, t2CError.m_errorNumber);
                    break;
                }
                sQLWarning = DatabaseError.addSqlWarning(sQLWarning, string, string2, t2CError.m_errorNumber);
                break;
            }
        }
        return sQLWarning;
    }

    OracleStatement RefCursorBytesToStatement(byte[] byArray, OracleStatement oracleStatement) throws SQLException {
        T2CStatement t2CStatement = new T2CStatement(this, 1, this.default_row_prefetch, -1, -1);
        t2CStatement.need_to_parse = false;
        t2CStatement.serverCursor = true;
        t2CStatement.m_isOpen = true;
        t2CStatement.prepare_for_new_result(true, false);
        t2CStatement.m_sql.initialize("select unknown as ref cursor from whatever");
        t2CStatement.sql_kind = 0;
        this.checkError(this.t2cCreateStatement(this.m_nativeState, oracleStatement.c_state, byArray, byArray.length, t2CStatement, true, this.default_row_prefetch));
        return t2CStatement;
    }

    public void getForm(OracleTypeADT oracleTypeADT, OracleTypeCLOB oracleTypeCLOB, int n) throws SQLException {
        boolean bl = false;
        if (oracleTypeCLOB != null) {
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[1];
            SQLName.parse(oracleTypeADT.getFullName(), stringArray, stringArray2, true);
            String string = "\"" + stringArray[0] + "\".\"" + stringArray2[0] + "\"";
            byte[] byArray = this.conversion.StringToCharBytes(string);
            int n2 = this.t2cGetFormOfUse(this.m_nativeState, oracleTypeCLOB, byArray, byArray.length, n);
            if (n2 < 0) {
                this.checkError(n2);
            }
            oracleTypeCLOB.setForm(n2);
        }
    }

    public void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
        boolean bl = false;
        if (oracleTypeADT != null) {
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[1];
            SQLName.parse(oracleTypeADT.getFullName(), stringArray, stringArray2, true);
            String string = "\"" + stringArray[0] + "\".\"" + stringArray2[0] + "\"";
            byte[] byArray = this.conversion.StringToCharBytes(string);
            int[] nArray = new int[1];
            long l = this.t2cGetTDO(this.m_nativeState, byArray, byArray.length, nArray);
            if (l == 0L) {
                this.checkError(nArray[0]);
            } else {
                oracleTypeADT.tdo_c_state = l;
            }
        }
    }

    public Properties getDBAccessProperties() throws SQLException {
        return this.getOCIHandles();
    }

    public synchronized Properties getOCIHandles() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (this.nativeInfo == null) {
            long[] lArray = new long[3];
            this.checkError(this.t2cGetHandles(this.m_nativeState, lArray));
            this.nativeInfo = new Properties();
            this.nativeInfo.put("OCIEnvHandle", String.valueOf(lArray[0]));
            this.nativeInfo.put("OCISvcCtxHandle", String.valueOf(lArray[1]));
            this.nativeInfo.put("OCIErrHandle", String.valueOf(lArray[2]));
            this.nativeInfo.put("ClientCharSet", String.valueOf(this.m_clientCharacterSet));
        }
        return this.nativeInfo;
    }

    public Properties getConnectionPoolInfo() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        Properties properties = new Properties();
        this.checkError(this.get_conn_pool_info(this.m_nativeState, properties));
        return properties;
    }

    public void setConnectionPoolInfo(int n, int n2, int n3, int n4, int n5, int n6) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        this.checkError(this.set_conn_pool_info(this.m_nativeState, n, n2, n3, n4, n5, n6));
    }

    public void ociPasswordChange(String string, String string2, String string3) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        byte[] byArray = string == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(string, this.m_clientCharacterSet);
        byte[] byArray2 = string2 == null ? new byte[]{} : DBConversion.stringToAsciiBytes(string2);
        byte[] byArray3 = string3 == null ? new byte[]{} : DBConversion.stringToAsciiBytes(string3);
        this.m_warning = this.checkError(this.password_change(this.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length), this.m_warning);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOCIConnectionPooling() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        byte[] byArray = null;
        byte[] byArray2 = this.password == null ? new byte[]{} : DBConversion.stringToAsciiBytes(this.password);
        byte[] byArray3 = DBConversion.stringToAsciiBytes(this.database);
        String string = this.connectionProperties.getProperty("connection_pool");
        short[] sArray = new short[3];
        if (string == "connection_pool") {
            String string2 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            this.m_clientCharacterSet = string2 != null && string2.equalsIgnoreCase("true") ? T2CConnection.getDriverCharSetIdFromNLS_LANG(this.connectionProperties) : T2CConnection.getCharSetIds(this.user, this.password, null, this.database, 0, null, this.connectionProperties);
            byArray = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.logon_mode = 5;
            if (this.m_nativeState != 0L) throw DatabaseError.newSqlException(0, "Internal Error: ");
            int[] nArray = new int[6];
            OracleOCIConnectionPool.readPoolConfig(this.connectionProperties, nArray);
            this.m_warning = this.checkError(this.t2cCreateConnPool(byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, this.m_clientCharacterSet, this.logon_mode, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]), this.m_warning);
            this.versionNumber = (short)10000;
        } else if (string == "connpool_connection") {
            byte[] byArray4;
            byte[] byArray5;
            this.logon_mode = 6;
            T2CConnection t2CConnection = (T2CConnection)this.connectionProperties.get("connpool_object");
            this.m_clientCharacterSet = t2CConnection.m_clientCharacterSet;
            byArray = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            if (!Locale.getDefault().toString().equals("en")) {
                byArray5 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
                byArray4 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
            } else {
                byArray4 = byArray5 = new byte[0];
            }
            this.m_warning = this.checkError(this.t2cConnPoolLogon(t2CConnection.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, null, 0, sArray, byArray5, byArray4), this.m_warning);
        } else if (string == "connpool_alias_connection") {
            byte[] byArray6;
            byte[] byArray7;
            this.logon_mode = 8;
            byte[] byArray8 = null;
            byArray8 = (byte[])this.connectionProperties.get("connection_id");
            T2CConnection t2CConnection = (T2CConnection)this.connectionProperties.get("connpool_object");
            this.m_clientCharacterSet = t2CConnection.m_clientCharacterSet;
            byArray = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            if (!Locale.getDefault().toString().equals("en")) {
                byArray7 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
                byArray6 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
            } else {
                byArray6 = byArray7 = new byte[0];
            }
            this.m_warning = this.checkError(this.t2cConnPoolLogon(t2CConnection.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, byArray8, byArray8 == null ? 0 : byArray8.length, sArray, byArray7, byArray6), this.m_warning);
        } else if (string == "connpool_proxy_connection") {
            byte[] byArray9;
            byte[] byArray10;
            this.logon_mode = 7;
            String string3 = this.connectionProperties.getProperty("proxytype");
            Integer n = (Integer)this.connectionProperties.get("proxy_num_roles");
            int n2 = n;
            String[] stringArray = null;
            if (n2 > 0) {
                stringArray = (String[])this.connectionProperties.get("proxy_roles");
            }
            byte[] byArray11 = null;
            byte[] byArray12 = null;
            byte[] byArray13 = null;
            byte[] byArray14 = null;
            int n3 = 0;
            if (string3 == "proxytype_user_name") {
                n3 = 1;
                String string4 = this.connectionProperties.getProperty("proxy_user_name");
                if (string4 != null) {
                    byArray11 = string4.getBytes();
                }
                if ((string4 = this.connectionProperties.getProperty("proxy_password")) != null) {
                    byArray12 = string4.getBytes();
                }
            } else if (string3 == "proxytype_distinguished_name") {
                n3 = 2;
                String string5 = this.connectionProperties.getProperty("proxy_distinguished_name");
                if (string5 != null) {
                    byArray13 = string5.getBytes();
                }
            } else if (string3 == "proxytype_certificate") {
                n3 = 3;
                byArray14 = (byte[])this.connectionProperties.get("proxy_certificate");
            } else {
                DatabaseError.throwSqlException(107);
            }
            T2CConnection t2CConnection = (T2CConnection)this.connectionProperties.get("connpool_object");
            this.m_clientCharacterSet = t2CConnection.m_clientCharacterSet;
            byte[] byArray15 = byArray = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            if (!Locale.getDefault().toString().equals("en")) {
                byArray10 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
                byArray9 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
            } else {
                byArray9 = byArray10 = new byte[0];
            }
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.m_warning = this.checkError(this.t2cConnPoolLogon(t2CConnection.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, this.logon_mode, n3, n2, stringArray, byArray11, byArray11 == null ? 0 : byArray11.length, byArray12, byArray12 == null ? 0 : byArray12.length, byArray13, byArray13 == null ? 0 : byArray13.length, byArray14, byArray14 == null ? 0 : byArray14.length, null, 0, sArray, byArray10, byArray9), this.m_warning);
        } else {
            DatabaseError.throwSqlException(23, "connection-pool-logon");
        }
        this.m_byteAlign = (byte)(sArray[2] & 0xFF);
        this.conversion = new DBConversion(sArray[0], this.m_clientCharacterSet, sArray[1]);
    }

    public boolean isDescriptorSharable(OracleConnection oracleConnection) throws SQLException {
        T2CConnection t2CConnection = this;
        PhysicalConnection physicalConnection = (PhysicalConnection)oracleConnection.getPhysicalConnection();
        return t2CConnection == physicalConnection;
    }

    native int blob_read(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9);

    native int clob_read(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, boolean var10);

    native int blob_write(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, byte[][] var10);

    native int clob_write(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, byte[][] var10, boolean var11);

    native long lob_getLength(long var1, byte[] var3, int var4);

    native int bfile_open(long var1, byte[] var3, int var4, byte[][] var5);

    native int bfile_isOpen(long var1, byte[] var3, int var4, boolean[] var5);

    native int bfile_exists(long var1, byte[] var3, int var4, boolean[] var5);

    native String bfile_getName(long var1, byte[] var3, int var4);

    native String bfile_getDirAlias(long var1, byte[] var3, int var4);

    native int bfile_close(long var1, byte[] var3, int var4, byte[][] var5);

    native int lob_getChunkSize(long var1, byte[] var3, int var4);

    native int lob_trim(long var1, int var3, long var4, byte[] var6, int var7, byte[][] var8);

    native int lob_createTemporary(long var1, int var3, boolean var4, int var5, short var6, byte[][] var7);

    native int lob_freeTemporary(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    native int lob_isTemporary(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int lob_open(long var1, int var3, byte[] var4, int var5, int var6, byte[][] var7);

    native int lob_isOpen(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int lob_close(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    private long lobLength(byte[] byArray) throws SQLException {
        long l = 0L;
        l = this.lob_getLength(this.m_nativeState, byArray, byArray.length);
        this.checkError((int)l);
        return l;
    }

    private int blobRead(byte[] byArray, long l, int n, byte[] byArray2) throws SQLException {
        int n2 = 0;
        n2 = this.blob_read(this.m_nativeState, byArray, byArray.length, l, n, byArray2, byArray2.length);
        this.checkError(n2);
        return n2;
    }

    private int blobWrite(byte[] byArray, long l, byte[] byArray2, byte[][] byArray3, int n, int n2) throws SQLException {
        int n3 = 0;
        n3 = this.blob_write(this.m_nativeState, byArray, byArray.length, l, n2, byArray2, n, byArray3);
        this.checkError(n3);
        return n3;
    }

    private int clobWrite(byte[] byArray, long l, char[] cArray, byte[][] byArray2, boolean bl, int n, int n2) throws SQLException {
        int n3 = 0;
        n3 = this.clob_write(this.m_nativeState, byArray, byArray.length, l, n2, cArray, n, byArray2, bl);
        this.checkError(n3);
        return n3;
    }

    private int lobGetChunkSize(byte[] byArray) throws SQLException {
        int n = 0;
        n = this.lob_getChunkSize(this.m_nativeState, byArray, byArray.length);
        this.checkError(n);
        return n;
    }

    public long length(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        return this.lobLength(byArray);
    }

    public long position(BFILE bFILE, byte[] byArray, long l) throws SQLException {
        long l2;
        if (l < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l2 = (l2 = LobPlsqlUtil.plsql_hasPattern(bFILE, byArray, l)) == 0L ? -1L : l2;
        return l2;
    }

    public long position(BFILE bFILE, BFILE bFILE2, long l) throws SQLException {
        long l2;
        if (l < 1L) {
            DatabaseError.throwSqlException(68, "position()");
        }
        l2 = (l2 = LobPlsqlUtil.plsql_isSubLob(bFILE, bFILE2, l)) == 0L ? -1L : l2;
        return l2;
    }

    public int getBytes(BFILE bFILE, long l, int n, byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray2 = bFILE.getLocator()) != null, 54);
        if (n <= 0 || byArray == null) {
            return 0;
        }
        if (n > byArray.length) {
            n = byArray.length;
        }
        return this.blobRead(byArray2, l, n, byArray);
    }

    public String getName(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        String string = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        string = this.bfile_getName(this.m_nativeState, byArray, byArray.length);
        this.checkError(string.length());
        return string;
    }

    public String getDirAlias(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        String string = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        string = this.bfile_getDirAlias(this.m_nativeState, byArray, byArray.length);
        this.checkError(string.length());
        return string;
    }

    public void openFile(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.bfile_open(this.m_nativeState, byArray, byArray.length, byArrayArray));
        bFILE.setLocator(byArrayArray[0]);
    }

    public boolean isFileOpen(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.bfile_isOpen(this.m_nativeState, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public boolean fileExists(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.bfile_exists(this.m_nativeState, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public void closeFile(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.bfile_close(this.m_nativeState, byArray, byArray.length, byArrayArray));
        bFILE.setLocator(byArrayArray[0]);
    }

    public void open(BFILE bFILE, int n) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_open(this.m_nativeState, 114, byArray, byArray.length, n, byArrayArray));
        bFILE.setShareBytes(byArrayArray[0]);
    }

    public void close(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_close(this.m_nativeState, 114, byArray, byArray.length, byArrayArray));
        bFILE.setShareBytes(byArrayArray[0]);
    }

    public boolean isOpen(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lob_isOpen(this.m_nativeState, 114, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public InputStream newInputStream(BFILE bFILE, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleBlobInputStream(bFILE, n);
        }
        return new OracleBlobInputStream(bFILE, n, l);
    }

    public InputStream newConversionInputStream(BFILE bFILE, int n) throws SQLException {
        this.checkTrue(bFILE != null && bFILE.shareBytes() != null, 54);
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bFILE.getBinaryStream(), n);
        return oracleConversionInputStream;
    }

    public Reader newConversionReader(BFILE bFILE, int n) throws SQLException {
        this.checkTrue(bFILE != null && bFILE.shareBytes() != null, 54);
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bFILE.getBinaryStream(), n);
        return oracleConversionReader;
    }

    public long length(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.getLocator()) != null, 54);
        return this.lobLength(byArray);
    }

    public long position(BLOB bLOB, byte[] byArray, long l) throws SQLException {
        long l2;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        if (l < 1L) {
            DatabaseError.check_error(68, "position()");
        }
        l2 = (l2 = LobPlsqlUtil.plsql_hasPattern(bLOB, byArray, l)) == 0L ? -1L : l2;
        return l2;
    }

    public long position(BLOB bLOB, BLOB bLOB2, long l) throws SQLException {
        long l2;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        this.checkTrue(bLOB2 != null && bLOB2.shareBytes() != null, 54);
        if (l < 1L) {
            DatabaseError.check_error(68, "position()");
        }
        l2 = (l2 = LobPlsqlUtil.plsql_isSubLob(bLOB, bLOB2, l)) == 0L ? -1L : l2;
        return l2;
    }

    public int getBytes(BLOB bLOB, long l, int n, byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && (byArray2 = bLOB.getLocator()) != null, 54);
        if (n <= 0 || byArray == null) {
            return 0;
        }
        if (n > byArray.length) {
            n = byArray.length;
        }
        return this.blobRead(byArray2, l, n, byArray);
    }

    public int putBytes(BLOB bLOB, long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkTrue(l >= 0L, 68);
        int n3 = 0;
        if (byArray == null || byArray.length == 0 || n2 <= 0) {
            n3 = 0;
        } else {
            byte[] byArray2 = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(bLOB != null && (byArray2 = bLOB.getLocator()) != null, 54);
            if (byArray == null) {
                return 0;
            }
            byte[][] byArrayArray = new byte[1][];
            n3 = this.blobWrite(byArray2, l, byArray, byArrayArray, n, n2);
            bLOB.setLocator(byArrayArray[0]);
        }
        return n3;
    }

    public int getChunkSize(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.getLocator()) != null, 54);
        return this.lobGetChunkSize(byArray);
    }

    public void trim(BLOB bLOB, long l) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_trim(this.m_nativeState, 113, l, byArray, byArray.length, byArrayArray));
        bLOB.setShareBytes(byArrayArray[0]);
    }

    public BLOB createTemporaryBlob(Connection connection, boolean bl, int n) throws SQLException {
        BLOB bLOB = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        bLOB = new BLOB((PhysicalConnection)connection);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_createTemporary(this.m_nativeState, 113, bl, n, (short)0, byArrayArray));
        bLOB.setShareBytes(byArrayArray[0]);
        return bLOB;
    }

    public void freeTemporary(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_freeTemporary(this.m_nativeState, 113, byArray, byArray.length, byArrayArray));
        bLOB.setShareBytes(byArrayArray[0]);
    }

    public boolean isTemporary(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lob_isTemporary(this.m_nativeState, 113, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public void open(BLOB bLOB, int n) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_open(this.m_nativeState, 113, byArray, byArray.length, n, byArrayArray));
        bLOB.setShareBytes(byArrayArray[0]);
    }

    public void close(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_close(this.m_nativeState, 113, byArray, byArray.length, byArrayArray));
        bLOB.setShareBytes(byArrayArray[0]);
    }

    public boolean isOpen(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lob_isOpen(this.m_nativeState, 113, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public InputStream newInputStream(BLOB bLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleBlobInputStream(bLOB, n);
        }
        return new OracleBlobInputStream(bLOB, n, l);
    }

    public OutputStream newOutputStream(BLOB bLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleBlobOutputStream(bLOB, n);
        }
        return new OracleBlobOutputStream(bLOB, n, l);
    }

    public InputStream newConversionInputStream(BLOB bLOB, int n) throws SQLException {
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bLOB.getBinaryStream(), n);
        return oracleConversionInputStream;
    }

    public Reader newConversionReader(BLOB bLOB, int n) throws SQLException {
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bLOB.getBinaryStream(), n);
        return oracleConversionReader;
    }

    public long length(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.getLocator()) != null, 54);
        return this.lobLength(byArray);
    }

    public long position(CLOB cLOB, String string, long l) throws SQLException {
        if (string == null) {
            throw new SQLException("pattern cannot be null.");
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && cLOB.shareBytes() != null, 54);
        if (l < 1L) {
            DatabaseError.check_error(68, "position()");
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        long l2 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l);
        l2 = l2 == 0L ? -1L : l2;
        return l2;
    }

    public long position(CLOB cLOB, CLOB cLOB2, long l) throws SQLException {
        long l2;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && cLOB.shareBytes() != null, 54);
        this.checkTrue(cLOB2 != null && cLOB2.shareBytes() != null, 54);
        if (l < 1L) {
            DatabaseError.check_error(68, "position()");
        }
        l2 = (l2 = LobPlsqlUtil.plsql_isSubLob(cLOB, cLOB2, l)) == 0L ? -1L : l2;
        return l2;
    }

    public int getChars(CLOB cLOB, long l, int n, char[] cArray) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.getLocator()) != null, 54);
        if (n <= 0 || cArray == null) {
            return 0;
        }
        if (n > cArray.length) {
            n = cArray.length;
        }
        int n2 = 0;
        n2 = this.clob_read(this.m_nativeState, byArray, byArray.length, l, n, cArray, cArray.length, cLOB.isNCLOB());
        this.checkError(n2);
        return n2;
    }

    public int putChars(CLOB cLOB, long l, char[] cArray, int n, int n2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(l >= 0L, 68);
        this.checkTrue(cLOB != null && (byArray = cLOB.getLocator()) != null, 54);
        if (cArray == null) {
            return 0;
        }
        byte[][] byArrayArray = new byte[1][];
        int n3 = this.clobWrite(byArray, l, cArray, byArrayArray, cLOB.isNCLOB(), n, n2);
        cLOB.setLocator(byArrayArray[0]);
        return n3;
    }

    public int getChunkSize(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.getLocator()) != null, 54);
        return this.lobGetChunkSize(byArray);
    }

    public void trim(CLOB cLOB, long l) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_trim(this.m_nativeState, 112, l, byArray, byArray.length, byArrayArray));
        cLOB.setShareBytes(byArrayArray[0]);
    }

    public CLOB createTemporaryClob(Connection connection, boolean bl, int n, short s) throws SQLException {
        CLOB cLOB = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        cLOB = new CLOB((PhysicalConnection)connection);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_createTemporary(this.m_nativeState, 112, bl, n, s, byArrayArray));
        cLOB.setShareBytes(byArrayArray[0]);
        return cLOB;
    }

    public void freeTemporary(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_freeTemporary(this.m_nativeState, 112, byArray, byArray.length, byArrayArray));
        cLOB.setShareBytes(byArrayArray[0]);
    }

    public boolean isTemporary(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lob_isTemporary(this.m_nativeState, 112, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public void open(CLOB cLOB, int n) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_open(this.m_nativeState, 112, byArray, byArray.length, n, byArrayArray));
        cLOB.setShareBytes(byArrayArray[0]);
    }

    public void close(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.lob_close(this.m_nativeState, 112, byArray, byArray.length, byArrayArray));
        cLOB.setShareBytes(byArrayArray[0]);
    }

    public boolean isOpen(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.lob_isOpen(this.m_nativeState, 112, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public InputStream newInputStream(CLOB cLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleClobInputStream(cLOB, n);
        }
        return new OracleClobInputStream(cLOB, n, l);
    }

    public OutputStream newOutputStream(CLOB cLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleClobOutputStream(cLOB, n);
        }
        return new OracleClobOutputStream(cLOB, n, l);
    }

    public Reader newReader(CLOB cLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleClobReader(cLOB, n);
        }
        return new OracleClobReader(cLOB, n, l);
    }

    public Writer newWriter(CLOB cLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleClobWriter(cLOB, n);
        }
        return new OracleClobWriter(cLOB, n, l);
    }

    public synchronized void registerTAFCallback(OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        this.m_appCbk = oracleOCIFailover;
        this.m_cbkObj = object;
        this.checkError(this.t2cRegisterTAFCallback(this.m_nativeState));
    }

    synchronized int callTAFCallbackMethod(int n, int n2) {
        int n3 = 0;
        if (this.m_appCbk != null) {
            n3 = this.m_appCbk.callbackFn(this, this.m_cbkObj, n, n2);
        }
        return n3;
    }

    public int getHeapAllocSize() throws SQLException {
        int n;
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if ((n = this.t2cGetHeapAllocSize(this.m_nativeState)) < 0) {
            if (n == -999) {
                DatabaseError.throwSqlException(23);
            }
            DatabaseError.throwSqlException(89);
        }
        return n;
    }

    public int getOCIEnvHeapAllocSize() throws SQLException {
        int n;
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if ((n = this.t2cGetOciEnvHeapAllocSize(this.m_nativeState)) < 0) {
            if (n == -999) {
                DatabaseError.throwSqlException(23);
            } else {
                this.checkError(n);
            }
            DatabaseError.throwSqlException(89);
        }
        return n;
    }

    public static short getCharSetIds(String string, String string2, String string3, String string4, int n, short[] sArray, Properties properties) throws SQLException {
        short s;
        if (sArray != null && sArray.length < 2) {
            DatabaseError.throwSqlException(68);
        }
        GetCharSetError getCharSetError = new GetCharSetError();
        char[] cArray = T2CConnection.getCharArray(string);
        char[] cArray2 = T2CConnection.getCharArray(string2);
        char[] cArray3 = T2CConnection.getCharArray(string4);
        char[] cArray4 = T2CConnection.getCharArray(string3);
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary(properties);
        }
        if ((s = T2CConnection.t2cGetCharSet(cArray, cArray.length, cArray2, cArray2.length, cArray4, cArray4.length, cArray3, cArray3.length, n, sArray, getCharSetError)) < 0) {
            getCharSetError.processError();
        }
        return s;
    }

    public static short getDriverCharSetIdFromNLS_LANG(Properties properties) throws SQLException {
        short s;
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary(properties);
        }
        if ((s = T2CConnection.t2cGetDriverCharSetFromNlsLang()) < 0) {
            DatabaseError.throwSqlException(8);
        }
        return s;
    }

    private static final void loadNativeLibrary(Properties properties) throws SQLException {
        block4: {
            String string = null;
            try {
                if (properties != null) {
                    string = properties.getProperty("oracle.jdbc.ocinativelibrary");
                }
                if (string == null) {
                    string = OCILIBRARY;
                }
                System.loadLibrary(string);
                isLibraryLoaded = true;
            }
            catch (SecurityException securityException) {
                if (isLibraryLoaded) break block4;
                System.loadLibrary(string);
                isLibraryLoaded = true;
            }
        }
    }

    private final void checkTrue(boolean bl, int n) throws SQLException {
        if (!bl) {
            DatabaseError.throwSqlException(n);
        }
    }

    boolean useLittleEndianSetCHARBinder() throws SQLException {
        return this.t2cPlatformIsLittleEndian(this.m_nativeState);
    }

    static final char[] getCharArray(String string) {
        char[] cArray = null;
        if (string == null) {
            cArray = new char[]{};
        } else {
            cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
        }
        return cArray;
    }

    static native short t2cGetCharSet(char[] var0, int var1, char[] var2, int var3, char[] var4, int var5, char[] var6, int var7, int var8, short[] var9, GetCharSetError var10);

    static native short t2cGetDriverCharSetFromNlsLang();

    native int t2cDescribeError(long var1, T2CError var3, byte[] var4);

    native int t2cCreateState(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, short var9, int var10, short[] var11, byte[] var12, byte[] var13);

    native int t2cLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, int var11, short[] var12, byte[] var13, byte[] var14);

    private native int t2cLogoff(long var1);

    private native int t2cCancel(long var1);

    private native int t2cCreateStatement(long var1, long var3, byte[] var5, int var6, OracleStatement var7, boolean var8, int var9);

    private native int t2cSetAutoCommit(long var1, boolean var3);

    private native int t2cCommit(long var1);

    private native int t2cRollback(long var1);

    private native byte[] t2cGetProductionVersion(long var1);

    private native int t2cGetVersionNumber(long var1);

    private native int t2cGetDefaultStreamChunkSize(long var1);

    native int t2cGetFormOfUse(long var1, OracleTypeCLOB var3, byte[] var4, int var5, int var6);

    native long t2cGetTDO(long var1, byte[] var3, int var4, int[] var5);

    native int t2cCreateConnPool(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, short var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    native int t2cConnPoolLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9, int var10, int var11, String[] var12, byte[] var13, int var14, byte[] var15, int var16, byte[] var17, int var18, byte[] var19, int var20, byte[] var21, int var22, short[] var23, byte[] var24, byte[] var25);

    native int get_conn_pool_info(long var1, Properties var3);

    native int set_conn_pool_info(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    native int password_change(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    protected native byte[] get_connection_id(long var1);

    native int t2cGetHandles(long var1, long[] var3);

    native int t2cUseConnection(long var1, long var3, long var5, long var7, short[] var9);

    native boolean t2cPlatformIsLittleEndian(long var1);

    native int t2cRegisterTAFCallback(long var1);

    native int t2cGetHeapAllocSize(long var1);

    native int t2cGetOciEnvHeapAllocSize(long var1);

    native int t2cAbort(long var1);

    void doAbort() throws SQLException {
        this.t2cAbort(this.m_nativeState);
    }

    static {
        _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    }
}

