# Copyright (c) 2007
# 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
# 
# This file is part of PyQt.
# 
# This copy of PyQt is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.
# 
# PyQt is supplied in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
# 
# You should have received a copy of the GNU General Public License along with
# PyQt; see the file LICENSE.  If not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# This module is intended to be used by the configuration scripts of extension
# modules that %Import PyQt modules.


import sipconfig


# These are installation specific values created when PyQt was configured.
_pkg_config = {
    'pyqt_bin_dir':              '/usr/local/bin',
    'pyqt_config_args':          '-w -b /usr/local/bin -d /usr/local/lib/python2.7/site-packages -g /usr/local/include/X11/qt3 -l /usr/local/include/python2.7 -m /usr/local/lib/qt3 -q /usr/local/lib/qt3 -v /usr/local/share/sip -y qt-mt INCDIR_QT=/usr/local/include/X11/qt3 LIBDIR=/usr/local/lib LIBDIR_QT=/usr/local/lib/qt3 CC=cc CXX=c++ CFLAGS=-O2 -pipe  CXXFLAGS=-O2 -pipe ',
    'pyqt_mod_dir':              '/usr/local/lib/python2.7/site-packages',
    'pyqt_modules':              'qt qtcanvas qtnetwork qttable qtxml qtgl qtui qtsql',
    'pyqt_qt_sip_flags':         '-x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x Qt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t Qt_3_3_6',
    'pyqt_qtcanvas_sip_flags':   '-x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x Qt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t Qt_3_3_6',
    'pyqt_qtgl_sip_flags':       '-x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x Qt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t Qt_3_3_6',
    'pyqt_qtnetwork_sip_flags':  '-x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x Qt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t Qt_3_3_6',
    'pyqt_qtsql_sip_flags':      '-x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x Qt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t Qt_3_3_6',
    'pyqt_qttable_sip_flags':    '-x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x Qt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t Qt_3_3_6',
    'pyqt_qtui_sip_flags':       '-x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x Qt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t Qt_3_3_6',
    'pyqt_qtxml_sip_flags':      '-x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x Qt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t Qt_3_3_6',
    'pyqt_sip_dir':              '/usr/local/share/sip',
    'pyqt_version':              0x031201,
    'pyqt_version_str':          '3.18.1',
    'qt_dir':                    '/usr/local/lib/qt3',
    'qt_edition':                'free',
    'qt_framework':              0,
    'qt_inc_dir':                '/usr/local/include/X11/qt3',
    'qt_lib':                    'qt-mt',
    'qt_lib_dir':                '/usr/local/lib/qt3',
    'qt_threaded':               1,
    'qt_version':                0x030308,
    'qt_winconfig':              ''
}

_default_macros = {
    'AIX_SHLIB':                '',
    'AR':                       'ar q',
    'CC':                       'cc',
    'CFLAGS':                   '-O2 -pipe ',
    'CFLAGS_APP':               '',
    'CFLAGS_CONSOLE':           '',
    'CFLAGS_DEBUG':             '-g',
    'CFLAGS_EXCEPTIONS_OFF':    '',
    'CFLAGS_EXCEPTIONS_ON':     '',
    'CFLAGS_MT':                '',
    'CFLAGS_MT_DBG':            '',
    'CFLAGS_MT_DLL':            '',
    'CFLAGS_MT_DLLDBG':         '',
    'CFLAGS_RELEASE':           '-O2',
    'CFLAGS_RTTI_OFF':          '',
    'CFLAGS_RTTI_ON':           '',
    'CFLAGS_SHLIB':             '-fPIC',
    'CFLAGS_STL_OFF':           '',
    'CFLAGS_STL_ON':            '',
    'CFLAGS_THREAD':            '-pthread',
    'CFLAGS_WARN_OFF':          '-w',
    'CFLAGS_WARN_ON':           '-Wall -W',
    'CHK_DIR_EXISTS':           'test -d',
    'CONFIG':                   'qt warn_on release link_prl thread',
    'COPY':                     'cp -f',
    'CXX':                      'c++',
    'CXXFLAGS':                 '-O2 -pipe ',
    'CXXFLAGS_APP':             '',
    'CXXFLAGS_CONSOLE':         '',
    'CXXFLAGS_DEBUG':           '-g',
    'CXXFLAGS_EXCEPTIONS_OFF':  '',
    'CXXFLAGS_EXCEPTIONS_ON':   '',
    'CXXFLAGS_MT':              '',
    'CXXFLAGS_MT_DBG':          '',
    'CXXFLAGS_MT_DLL':          '',
    'CXXFLAGS_MT_DLLDBG':       '',
    'CXXFLAGS_RELEASE':         '-O2',
    'CXXFLAGS_RTTI_OFF':        '',
    'CXXFLAGS_RTTI_ON':         '',
    'CXXFLAGS_SHLIB':           '-fPIC',
    'CXXFLAGS_STL_OFF':         '',
    'CXXFLAGS_STL_ON':          '',
    'CXXFLAGS_THREAD':          '-pthread',
    'CXXFLAGS_WARN_OFF':        '-w',
    'CXXFLAGS_WARN_ON':         '-Wall -W',
    'DEFINES':                  '',
    'DEL_FILE':                 'rm -f',
    'EXTENSION_PLUGIN':         '',
    'EXTENSION_SHLIB':          '',
    'INCDIR':                   '/include',
    'INCDIR_OPENGL':            '/usr/X11R6/include',
    'INCDIR_QT':                '/usr/local/include/X11/qt3',
    'INCDIR_X11':               '/usr/X11R6/include',
    'LFLAGS':                   '',
    'LFLAGS_CONSOLE':           '',
    'LFLAGS_CONSOLE_DLL':       '',
    'LFLAGS_DEBUG':             '',
    'LFLAGS_DLL':               '',
    'LFLAGS_OPENGL':            '',
    'LFLAGS_PLUGIN':            '-shared',
    'LFLAGS_RELEASE':           '',
    'LFLAGS_RPATH':             '',
    'LFLAGS_SHLIB':             '-shared',
    'LFLAGS_SONAME':            '',
    'LFLAGS_THREAD':            '-pthread',
    'LFLAGS_WINDOWS':           '',
    'LFLAGS_WINDOWS_DLL':       '',
    'LIB':                      '',
    'LIBDIR':                   '/usr/local/lib',
    'LIBDIR_OPENGL':            '/usr/X11R6/lib',
    'LIBDIR_QT':                '/usr/local/lib/qt3',
    'LIBDIR_X11':               '/usr/X11R6/lib',
    'LIBS':                     '',
    'LIBS_CONSOLE':             '',
    'LIBS_CORE':                '',
    'LIBS_GUI':                 '',
    'LIBS_NETWORK':             '',
    'LIBS_OPENGL':              '-lGLU -lGL -lXmu',
    'LIBS_RT':                  '',
    'LIBS_RTMT':                '',
    'LIBS_THREAD':              '',
    'LIBS_WEBKIT':              '',
    'LIBS_WINDOWS':             '',
    'LIBS_X11':                 '-lXext -lX11 -lm',
    'LINK':                     'g++',
    'LINK_SHLIB':               'g++',
    'LINK_SHLIB_CMD':           'g++  	-fPIC  	-o    ',
    'MAKEFILE_GENERATOR':       'UNIX',
    'MKDIR':                    'mkdir -p',
    'MOC':                      '/usr/local/lib/qt3/bin/moc',
    'RANLIB':                   'ranlib',
    'RPATH':                    '',
    'STRIP':                    ''
}


class Configuration(sipconfig.Configuration):
    """The class that represents PyQt configuration values.
    """
    def __init__(self, sub_cfg=None):
        """Initialise an instance of the class.

        sub_cfg is the list of sub-class configurations.  It should be None
        when called normally.
        """
        if sub_cfg:
            cfg = sub_cfg
        else:
            cfg = []

        cfg.append(_pkg_config)

        sipconfig.Configuration.__init__(self, cfg)


class QtModuleMakefile(sipconfig.SIPModuleMakefile):
    """The Makefile class for modules that %Import qt.
    """
    def __init__(self, *args, **kw):
        """Initialise an instance of a module Makefile.
        """
        kw["qt"] = 1
        apply(sipconfig.SIPModuleMakefile.__init__, (self, ) + args, kw)

    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("qt"))

        sipconfig.SIPModuleMakefile.finalise(self)


class QtAxContainerModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtaxcontainer.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtaxcontainer"))

        QtModuleMakefile.finalise(self)


class QtCanvasModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtcanvas.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtcanvas"))

        QtModuleMakefile.finalise(self)


class QtExtModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtext.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtext"))

        self.extra_defines.extend(self.config._pyqt_qscintilla_defines)
        self.extra_include_dirs.append(self.config._pyqt_qscintilla_inc_dir)
        self.extra_lib_dirs.append(self.config._pyqt_qscintilla_lib_dir)
        self.extra_libs.append("qscintilla")

        QtModuleMakefile.finalise(self)


class QtGLModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtgl.
    """
    def __init__(self, *args, **kw):
        """Initialise an instance of a module Makefile.
        """
        kw["opengl"] = 1
        apply(QtModuleMakefile.__init__, (self, ) + args, kw)

    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtgl"))

        QtModuleMakefile.finalise(self)


class QtNetworkModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtnetwork.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtnetwork"))

        QtModuleMakefile.finalise(self)


class QtTableModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qttable.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qttable"))

        QtModuleMakefile.finalise(self)


class QtSQLModuleMakefile(QtTableModuleMakefile):
    """The Makefile class for modules that %Import qtsql.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtsql"))

        QtTableModuleMakefile.finalise(self)


class QtUIModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtui.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtui"))

        QtModuleMakefile.finalise(self)


class QtXMLModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtxml.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtxml"))

        QtModuleMakefile.finalise(self)
