<?php

/*
 * Copyright (C) 2008-2012 Oracle Corporation
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the "COPYING.LIB" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.
 *
 * This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
 */

class VBox_ManagedObject
{
    protected $connection;
    protected $handle;

    public function __construct($soap, $handle = null)
    {
        $this->connection = $soap;
        $this->handle = $handle;
    }

    public function __toString()
    {
        return (string)$this->handle;
    }

    public function __set($attr, $value)
    {
        $methodName = "set" . $attr;
        if (method_exists($this, $methodName))
            $this->$methodName($value);
        else
            throw new Exception("Attribute does not exist");
    }

    public function __get($attr)
    {
        $methodName = "get" . $attr;
        if (method_exists($this, $methodName))
            return $this->$methodName();
        else
            throw new Exception("Attribute does not exist");
    }

    public function getHandle()
    {
        return $this->handle;
    }

    public function cast($class)
    {
        if (is_subclass_of($class, 'VBox_ManagedObject'))
        {
            return new $class($this->connection, $this->handle);
        }
        throw new Exception('Cannot cast VBox_ManagedObject to non-child class VBox_ManagedObject');
    }

    public function releaseRemote()
    {
        try
        {
            $request = new stdClass();
            $request->_this = $this->handle;
            $this->connection->__soapCall('IManagedObjectRef_release', array((array)$request));
        }
        catch (Exception $ex)
        {
        }
    }
}

abstract class VBox_Collection implements ArrayAccess, Iterator, Countable
{
    protected $_connection;
    protected $_values;
    protected $_objects;
    protected $_interfaceName;

    public function __construct($soap, array $values = array())
    {
        $this->_connection = $soap;
        $this->_values = $values;
        $this->_soapToObject();
    }

    protected function _soapToObject()
    {
        $this->_objects = array();
        foreach($this->_values as $value)
        {
            $this->_objects[] = new $this->_interfaceName($this->_connection, $value);
        }
    }

    /** ArrayAccess Functions **/
    public function offsetSet($offset, $value)
    {
        if ($value instanceof $this->_interfaceName)
        {
            if ($offset)
            {
                $this->_objects[$offset] = $value;
            }
            else
            {
                $this->_objects[] = $value;
            }
        }
        else
        {
            throw new Exception("Value must be a instance of " . $this->_interfaceName);
        }
    }

    public function offsetExists($offset)
    {
        return isset($this->_objects[$offset]);
    }

    public function offsetUnset($offset)
    {
        unset($this->_objects[$offset]);
    }

    public function offsetGet($offset)
    {
        return isset($this->_objects[$offset]) ? $this->_objects[$offset] : null;
    }

    /** Iterator Functions **/
    public function rewind()
    {
        reset($this->_objects);
    }

    public function current()
    {
        return current($this->_objects);
    }

    public function key()
    {
        return key($this->_objects);
    }

    public function next()
    {
        return next($this->_objects);
    }

    public function valid()
    {
        return ($this->current() !== false);
    }

    /** Countable Functions **/
    public function count()
    {
        return count($this->_objects);
    }
}

class VBox_ManagedObjectCollection extends VBox_Collection
{
    protected $_interfaceName = 'VBox_ManagedObject';

    // Result is undefined if this is called AFTER any call to VBox_Collection::offsetSet or VBox_Collection::offsetUnset
    public function setInterfaceName($interface)
    {
        if (!is_subclass_of($interface, 'VBox_ManagedObject'))
        {
            throw new Exception('Cannot set collection interface to non-child class of VBox_ManagedObject');
        }
        $this->_interfaceName = $interface;
        $this->_soapToObject();
    }
}

abstract class VBox_Struct
{
    protected $connection;

    public function __get($attr)
    {
        $methodName = "get" . $attr;
        if (method_exists($this, $methodName))
            return $this->$methodName();
        else
            throw new Exception("Attribute does not exist");
    }
}

abstract class VBox_StructCollection extends VBox_Collection
{

    public function __construct($soap, array $values = array())
    {
        if (!(array_values($values) === $values))
        {
            $values = array((object)$values); //Fix for when struct return value only contains one list item (e.g. one medium attachment)
        }
        parent::__construct($soap, $values);
    }
}

abstract class VBox_Enum
{
    protected $_handle;

    public function __construct($connection, $handle)
    {
        if (is_string($handle))
            $this->_handle = $this->ValueMap[$handle];
        else
            $this->_handle = $handle;
    }

    public function __toString()
    {
        return (string)$this->NameMap[$this->_handle];
    }
}

abstract class VBox_EnumCollection extends VBox_Collection
{
}


/**
 * VirtualBox COM result codes
 */
class VirtualBox_COM_result_codes
{

    const VBOX_E_OBJECT_NOT_FOUND = 0x80BB0001;

    const VBOX_E_INVALID_VM_STATE = 0x80BB0002;

    const VBOX_E_VM_ERROR = 0x80BB0003;

    const VBOX_E_FILE_ERROR = 0x80BB0004;

    const VBOX_E_IPRT_ERROR = 0x80BB0005;

    const VBOX_E_PDM_ERROR = 0x80BB0006;

    const VBOX_E_INVALID_OBJECT_STATE = 0x80BB0007;

    const VBOX_E_HOST_ERROR = 0x80BB0008;

    const VBOX_E_NOT_SUPPORTED = 0x80BB0009;

    const VBOX_E_XML_ERROR = 0x80BB000A;

    const VBOX_E_INVALID_SESSION_STATE = 0x80BB000B;

    const VBOX_E_OBJECT_IN_USE = 0x80BB000C;

}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IVirtualBoxErrorInfo extends VBox_ManagedObject
{

    public function getResultCode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getResultCode', array((array)$request));
        return (int)$response->returnval;
    }

    public function getInterfaceID()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getInterfaceID', array((array)$request));
        return (string)$response->returnval;
    }

    public function getComponent()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getComponent', array((array)$request));
        return (string)$response->returnval;
    }

    public function getText()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getText', array((array)$request));
        return (string)$response->returnval;
    }

    public function getNext()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBoxErrorInfo_getNext', array((array)$request));
        return new IVirtualBoxErrorInfo ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IVirtualBoxErrorInfoCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IVirtualBoxErrorInfo";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IDHCPServer extends VBox_ManagedObject
{

    public function setConfiguration($arg_IPAddress, $arg_networkMask, $arg_FromIPAddress, $arg_ToIPAddress)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->IPAddress = $arg_IPAddress;
        $request->networkMask = $arg_networkMask;
        $request->FromIPAddress = $arg_FromIPAddress;
        $request->ToIPAddress = $arg_ToIPAddress;
        $response = $this->connection->__soapCall('IDHCPServer_setConfiguration', array((array)$request));
        return ;
    }

    public function start($arg_networkName, $arg_trunkName, $arg_trunkType)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->networkName = $arg_networkName;
        $request->trunkName = $arg_trunkName;
        $request->trunkType = $arg_trunkType;
        $response = $this->connection->__soapCall('IDHCPServer_start', array((array)$request));
        return ;
    }

    public function stop()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDHCPServer_stop', array((array)$request));
        return ;
    }

    public function getEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDHCPServer_getEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->enabled = $value;
        }
        else
        {
            $request->enabled = $value->handle;
        }
        $this->connection->__soapCall('IDHCPServer_setEnabled', array((array)$request));
    }

    public function getIPAddress()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDHCPServer_getIPAddress', array((array)$request));
        return (string)$response->returnval;
    }

    public function getNetworkMask()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDHCPServer_getNetworkMask', array((array)$request));
        return (string)$response->returnval;
    }

    public function getNetworkName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDHCPServer_getNetworkName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getLowerIP()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDHCPServer_getLowerIP', array((array)$request));
        return (string)$response->returnval;
    }

    public function getUpperIP()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDHCPServer_getUpperIP', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IDHCPServerCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IDHCPServer";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IVirtualBox extends VBox_ManagedObject
{

    public function composeMachineFilename($arg_name, $arg_group, $arg_createFlags, $arg_baseFolder)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->group = $arg_group;
        $request->createFlags = $arg_createFlags;
        $request->baseFolder = $arg_baseFolder;
        $response = $this->connection->__soapCall('IVirtualBox_composeMachineFilename', array((array)$request));
        return (string)$response->returnval;
    }

    public function createMachine($arg_settingsFile, $arg_name, $arg_groups, $arg_osTypeId, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->settingsFile = $arg_settingsFile;
        $request->name = $arg_name;
        $request->groups = $arg_groups;
        $request->osTypeId = $arg_osTypeId;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IVirtualBox_createMachine', array((array)$request));
        return new IMachine ($this->connection, $response->returnval);
    }

    public function openMachine($arg_settingsFile)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->settingsFile = $arg_settingsFile;
        $response = $this->connection->__soapCall('IVirtualBox_openMachine', array((array)$request));
        return new IMachine ($this->connection, $response->returnval);
    }

    public function registerMachine($arg_machine)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->machine = $arg_machine;
        $response = $this->connection->__soapCall('IVirtualBox_registerMachine', array((array)$request));
        return ;
    }

    public function findMachine($arg_nameOrId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->nameOrId = $arg_nameOrId;
        $response = $this->connection->__soapCall('IVirtualBox_findMachine', array((array)$request));
        return new IMachine ($this->connection, $response->returnval);
    }

    public function getMachinesByGroups($arg_groups)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->groups = $arg_groups;
        $response = $this->connection->__soapCall('IVirtualBox_getMachinesByGroups', array((array)$request));
        return new IMachineCollection ($this->connection, (array)$response->returnval);
    }

    public function getMachineStates($arg_machines)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->machines = $arg_machines;
        $response = $this->connection->__soapCall('IVirtualBox_getMachineStates', array((array)$request));
        return new MachineStateCollection ($this->connection, (array)$response->returnval);
    }

    public function createAppliance()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_createAppliance', array((array)$request));
        return new IAppliance ($this->connection, $response->returnval);
    }

    public function createHardDisk($arg_format, $arg_location)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->format = $arg_format;
        $request->location = $arg_location;
        $response = $this->connection->__soapCall('IVirtualBox_createHardDisk', array((array)$request));
        return new IMedium ($this->connection, $response->returnval);
    }

    public function openMedium($arg_location, $arg_deviceType, $arg_accessMode, $arg_forceNewUuid)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->location = $arg_location;
        $request->deviceType = $arg_deviceType;
        $request->accessMode = $arg_accessMode;
        $request->forceNewUuid = $arg_forceNewUuid;
        $response = $this->connection->__soapCall('IVirtualBox_openMedium', array((array)$request));
        return new IMedium ($this->connection, $response->returnval);
    }

    public function getGuestOSType($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IVirtualBox_getGuestOSType', array((array)$request));
        return new IGuestOSType ($this->connection, $response->returnval);
    }

    public function createSharedFolder($arg_name, $arg_hostPath, $arg_writable, $arg_automount)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->hostPath = $arg_hostPath;
        $request->writable = $arg_writable;
        $request->automount = $arg_automount;
        $response = $this->connection->__soapCall('IVirtualBox_createSharedFolder', array((array)$request));
        return ;
    }

    public function removeSharedFolder($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IVirtualBox_removeSharedFolder', array((array)$request));
        return ;
    }

    public function getExtraDataKeys()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getExtraDataKeys', array((array)$request));
        return (array)$response->returnval;
    }

    public function getExtraData($arg_key)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->key = $arg_key;
        $response = $this->connection->__soapCall('IVirtualBox_getExtraData', array((array)$request));
        return (string)$response->returnval;
    }

    public function setExtraData($arg_key, $arg_value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->key = $arg_key;
        $request->value = $arg_value;
        $response = $this->connection->__soapCall('IVirtualBox_setExtraData', array((array)$request));
        return ;
    }

    public function setSettingsSecret($arg_password)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->password = $arg_password;
        $response = $this->connection->__soapCall('IVirtualBox_setSettingsSecret', array((array)$request));
        return ;
    }

    public function createDHCPServer($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IVirtualBox_createDHCPServer', array((array)$request));
        return new IDHCPServer ($this->connection, $response->returnval);
    }

    public function findDHCPServerByNetworkName($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IVirtualBox_findDHCPServerByNetworkName', array((array)$request));
        return new IDHCPServer ($this->connection, $response->returnval);
    }

    public function removeDHCPServer($arg_server)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->server = $arg_server;
        $response = $this->connection->__soapCall('IVirtualBox_removeDHCPServer', array((array)$request));
        return ;
    }

    public function checkFirmwarePresent($arg_firmwareType, $arg_version)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->firmwareType = $arg_firmwareType;
        $request->version = $arg_version;
        $response = $this->connection->__soapCall('IVirtualBox_checkFirmwarePresent', array((array)$request));
        return array((bool)$response->returnval, (string)$response->url, (string)$response->file);
    }

    public function getVersion()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getVersion', array((array)$request));
        return (string)$response->returnval;
    }

    public function getVersionNormalized()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getVersionNormalized', array((array)$request));
        return (string)$response->returnval;
    }

    public function getRevision()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getRevision', array((array)$request));
        return (float)$response->returnval;
    }

    public function getPackageType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getPackageType', array((array)$request));
        return (string)$response->returnval;
    }

    public function getAPIVersion()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getAPIVersion', array((array)$request));
        return (string)$response->returnval;
    }

    public function getHomeFolder()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getHomeFolder', array((array)$request));
        return (string)$response->returnval;
    }

    public function getSettingsFilePath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getSettingsFilePath', array((array)$request));
        return (string)$response->returnval;
    }

    public function getHost()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getHost', array((array)$request));
        return new IHost ($this->connection, $response->returnval);
    }

    public function getSystemProperties()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getSystemProperties', array((array)$request));
        return new ISystemProperties ($this->connection, $response->returnval);
    }

    public function getMachines()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getMachines', array((array)$request));
        return new IMachineCollection ($this->connection, (array)$response->returnval);
    }

    public function getMachineGroups()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getMachineGroups', array((array)$request));
        return (array)$response->returnval;
    }

    public function getHardDisks()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getHardDisks', array((array)$request));
        return new IMediumCollection ($this->connection, (array)$response->returnval);
    }

    public function getDVDImages()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getDVDImages', array((array)$request));
        return new IMediumCollection ($this->connection, (array)$response->returnval);
    }

    public function getFloppyImages()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getFloppyImages', array((array)$request));
        return new IMediumCollection ($this->connection, (array)$response->returnval);
    }

    public function getProgressOperations()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getProgressOperations', array((array)$request));
        return new IProgressCollection ($this->connection, (array)$response->returnval);
    }

    public function getGuestOSTypes()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getGuestOSTypes', array((array)$request));
        return new IGuestOSTypeCollection ($this->connection, (array)$response->returnval);
    }

    public function getSharedFolders()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getSharedFolders', array((array)$request));
        return new ISharedFolderCollection ($this->connection, (array)$response->returnval);
    }

    public function getPerformanceCollector()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getPerformanceCollector', array((array)$request));
        return new IPerformanceCollector ($this->connection, $response->returnval);
    }

    public function getDHCPServers()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getDHCPServers', array((array)$request));
        return new IDHCPServerCollection ($this->connection, (array)$response->returnval);
    }

    public function getEventSource()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getEventSource', array((array)$request));
        return new IEventSource ($this->connection, $response->returnval);
    }

    public function getInternalNetworks()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getInternalNetworks', array((array)$request));
        return (array)$response->returnval;
    }

    public function getGenericNetworkDrivers()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualBox_getGenericNetworkDrivers', array((array)$request));
        return (array)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IVirtualBoxCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IVirtualBox";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IVFSExplorer extends VBox_ManagedObject
{

    public function update()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVFSExplorer_update', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function cd($arg_aDir)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aDir = $arg_aDir;
        $response = $this->connection->__soapCall('IVFSExplorer_cd', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function cdUp()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVFSExplorer_cdUp', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function entryList()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVFSExplorer_entryList', array((array)$request));
        return array((array)$response->aNames, (array)$response->aTypes, (array)$response->aSizes, (array)$response->aModes);
    }

    public function exists($arg_aNames)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aNames = $arg_aNames;
        $response = $this->connection->__soapCall('IVFSExplorer_exists', array((array)$request));
        return (array)$response->returnval;
    }

    public function remove($arg_aNames)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aNames = $arg_aNames;
        $response = $this->connection->__soapCall('IVFSExplorer_remove', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function getPath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVFSExplorer_getPath', array((array)$request));
        return (string)$response->returnval;
    }

    public function getType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVFSExplorer_getType', array((array)$request));
        return new VFSType ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IVFSExplorerCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IVFSExplorer";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IAppliance extends VBox_ManagedObject
{

    public function read($arg_file)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->file = $arg_file;
        $response = $this->connection->__soapCall('IAppliance_read', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function interpret()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IAppliance_interpret', array((array)$request));
        return ;
    }

    public function importMachines($arg_options)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->options = $arg_options;
        $response = $this->connection->__soapCall('IAppliance_importMachines', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function createVFSExplorer($arg_aUri)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aUri = $arg_aUri;
        $response = $this->connection->__soapCall('IAppliance_createVFSExplorer', array((array)$request));
        return new IVFSExplorer ($this->connection, $response->returnval);
    }

    public function write($arg_format, $arg_manifest, $arg_path)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->format = $arg_format;
        $request->manifest = $arg_manifest;
        $request->path = $arg_path;
        $response = $this->connection->__soapCall('IAppliance_write', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function getWarnings()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IAppliance_getWarnings', array((array)$request));
        return (array)$response->returnval;
    }

    public function getPath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IAppliance_getPath', array((array)$request));
        return (string)$response->returnval;
    }

    public function getDisks()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IAppliance_getDisks', array((array)$request));
        return (array)$response->returnval;
    }

    public function getVirtualSystemDescriptions()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IAppliance_getVirtualSystemDescriptions', array((array)$request));
        return new IVirtualSystemDescriptionCollection ($this->connection, (array)$response->returnval);
    }

    public function getMachines()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IAppliance_getMachines', array((array)$request));
        return (array)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IApplianceCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IAppliance";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IVirtualSystemDescription extends VBox_ManagedObject
{

    public function getDescription()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualSystemDescription_getDescription', array((array)$request));
        return array(new VirtualSystemDescriptionTypeCollection ($this->connection, (array)$response->aTypes), (array)$response->aRefs, (array)$response->aOvfValues, (array)$response->aVBoxValues, (array)$response->aExtraConfigValues);
    }

    public function getDescriptionByType($arg_aType)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aType = $arg_aType;
        $response = $this->connection->__soapCall('IVirtualSystemDescription_getDescriptionByType', array((array)$request));
        return array(new VirtualSystemDescriptionTypeCollection ($this->connection, (array)$response->aTypes), (array)$response->aRefs, (array)$response->aOvfValues, (array)$response->aVBoxValues, (array)$response->aExtraConfigValues);
    }

    public function getValuesByType($arg_aType, $arg_aWhich)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aType = $arg_aType;
        $request->aWhich = $arg_aWhich;
        $response = $this->connection->__soapCall('IVirtualSystemDescription_getValuesByType', array((array)$request));
        return (array)$response->returnval;
    }

    public function setFinalValues($arg_aEnabled, $arg_aVBoxValues, $arg_aExtraConfigValues)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aEnabled = $arg_aEnabled;
        $request->aVBoxValues = $arg_aVBoxValues;
        $request->aExtraConfigValues = $arg_aExtraConfigValues;
        $response = $this->connection->__soapCall('IVirtualSystemDescription_setFinalValues', array((array)$request));
        return ;
    }

    public function addDescription($arg_aType, $arg_aVBoxValue, $arg_aExtraConfigValue)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aType = $arg_aType;
        $request->aVBoxValue = $arg_aVBoxValue;
        $request->aExtraConfigValue = $arg_aExtraConfigValue;
        $response = $this->connection->__soapCall('IVirtualSystemDescription_addDescription', array((array)$request));
        return ;
    }

    public function getCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVirtualSystemDescription_getCount', array((array)$request));
        return (float)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IVirtualSystemDescriptionCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IVirtualSystemDescription";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IBIOSSettings extends VBox_ManagedObject
{

    public function getLogoFadeIn()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBIOSSettings_getLogoFadeIn', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setLogoFadeIn($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->logoFadeIn = $value;
        }
        else
        {
            $request->logoFadeIn = $value->handle;
        }
        $this->connection->__soapCall('IBIOSSettings_setLogoFadeIn', array((array)$request));
    }

    public function getLogoFadeOut()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBIOSSettings_getLogoFadeOut', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setLogoFadeOut($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->logoFadeOut = $value;
        }
        else
        {
            $request->logoFadeOut = $value->handle;
        }
        $this->connection->__soapCall('IBIOSSettings_setLogoFadeOut', array((array)$request));
    }

    public function getLogoDisplayTime()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBIOSSettings_getLogoDisplayTime', array((array)$request));
        return (float)$response->returnval;
    }

    public function setLogoDisplayTime($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->logoDisplayTime = $value;
        }
        else
        {
            $request->logoDisplayTime = $value->handle;
        }
        $this->connection->__soapCall('IBIOSSettings_setLogoDisplayTime', array((array)$request));
    }

    public function getLogoImagePath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBIOSSettings_getLogoImagePath', array((array)$request));
        return (string)$response->returnval;
    }

    public function setLogoImagePath($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->logoImagePath = $value;
        }
        else
        {
            $request->logoImagePath = $value->handle;
        }
        $this->connection->__soapCall('IBIOSSettings_setLogoImagePath', array((array)$request));
    }

    public function getBootMenuMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBIOSSettings_getBootMenuMode', array((array)$request));
        return new BIOSBootMenuMode ($this->connection, $response->returnval);
    }

    public function setBootMenuMode($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->bootMenuMode = $value;
        }
        else
        {
            $request->bootMenuMode = $value->handle;
        }
        $this->connection->__soapCall('IBIOSSettings_setBootMenuMode', array((array)$request));
    }

    public function getACPIEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBIOSSettings_getACPIEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setACPIEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->ACPIEnabled = $value;
        }
        else
        {
            $request->ACPIEnabled = $value->handle;
        }
        $this->connection->__soapCall('IBIOSSettings_setACPIEnabled', array((array)$request));
    }

    public function getIOAPICEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBIOSSettings_getIOAPICEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setIOAPICEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->IOAPICEnabled = $value;
        }
        else
        {
            $request->IOAPICEnabled = $value->handle;
        }
        $this->connection->__soapCall('IBIOSSettings_setIOAPICEnabled', array((array)$request));
    }

    public function getTimeOffset()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBIOSSettings_getTimeOffset', array((array)$request));
        return (float)$response->returnval;
    }

    public function setTimeOffset($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->timeOffset = $value;
        }
        else
        {
            $request->timeOffset = $value->handle;
        }
        $this->connection->__soapCall('IBIOSSettings_setTimeOffset', array((array)$request));
    }

    public function getPXEDebugEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBIOSSettings_getPXEDebugEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setPXEDebugEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->PXEDebugEnabled = $value;
        }
        else
        {
            $request->PXEDebugEnabled = $value->handle;
        }
        $this->connection->__soapCall('IBIOSSettings_setPXEDebugEnabled', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IBIOSSettingsCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IBIOSSettings";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMachine extends VBox_ManagedObject
{

    public function lockMachine($arg_session, $arg_lockType)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->session = $arg_session;
        $request->lockType = $arg_lockType;
        $response = $this->connection->__soapCall('IMachine_lockMachine', array((array)$request));
        return ;
    }

    public function launchVMProcess($arg_session, $arg_type, $arg_environment)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->session = $arg_session;
        $request->type = $arg_type;
        $request->environment = $arg_environment;
        $response = $this->connection->__soapCall('IMachine_launchVMProcess', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function setBootOrder($arg_position, $arg_device)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->position = $arg_position;
        $request->device = $arg_device;
        $response = $this->connection->__soapCall('IMachine_setBootOrder', array((array)$request));
        return ;
    }

    public function getBootOrder($arg_position)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->position = $arg_position;
        $response = $this->connection->__soapCall('IMachine_getBootOrder', array((array)$request));
        return new DeviceType ($this->connection, $response->returnval);
    }

    public function attachDevice($arg_name, $arg_controllerPort, $arg_device, $arg_type, $arg_medium)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $request->type = $arg_type;
        $request->medium = $arg_medium;
        $response = $this->connection->__soapCall('IMachine_attachDevice', array((array)$request));
        return ;
    }

    public function attachDeviceWithoutMedium($arg_name, $arg_controllerPort, $arg_device, $arg_type)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $request->type = $arg_type;
        $response = $this->connection->__soapCall('IMachine_attachDeviceWithoutMedium', array((array)$request));
        return ;
    }

    public function detachDevice($arg_name, $arg_controllerPort, $arg_device)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $response = $this->connection->__soapCall('IMachine_detachDevice', array((array)$request));
        return ;
    }

    public function passthroughDevice($arg_name, $arg_controllerPort, $arg_device, $arg_passthrough)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $request->passthrough = $arg_passthrough;
        $response = $this->connection->__soapCall('IMachine_passthroughDevice', array((array)$request));
        return ;
    }

    public function temporaryEjectDevice($arg_name, $arg_controllerPort, $arg_device, $arg_temporaryEject)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $request->temporaryEject = $arg_temporaryEject;
        $response = $this->connection->__soapCall('IMachine_temporaryEjectDevice', array((array)$request));
        return ;
    }

    public function nonRotationalDevice($arg_name, $arg_controllerPort, $arg_device, $arg_nonRotational)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $request->nonRotational = $arg_nonRotational;
        $response = $this->connection->__soapCall('IMachine_nonRotationalDevice', array((array)$request));
        return ;
    }

    public function setAutoDiscardForDevice($arg_name, $arg_controllerPort, $arg_device, $arg_discard)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $request->discard = $arg_discard;
        $response = $this->connection->__soapCall('IMachine_setAutoDiscardForDevice', array((array)$request));
        return ;
    }

    public function setBandwidthGroupForDevice($arg_name, $arg_controllerPort, $arg_device, $arg_bandwidthGroup)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $request->bandwidthGroup = $arg_bandwidthGroup;
        $response = $this->connection->__soapCall('IMachine_setBandwidthGroupForDevice', array((array)$request));
        return ;
    }

    public function setNoBandwidthGroupForDevice($arg_name, $arg_controllerPort, $arg_device)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $response = $this->connection->__soapCall('IMachine_setNoBandwidthGroupForDevice', array((array)$request));
        return ;
    }

    public function unmountMedium($arg_name, $arg_controllerPort, $arg_device, $arg_force)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $request->force = $arg_force;
        $response = $this->connection->__soapCall('IMachine_unmountMedium', array((array)$request));
        return ;
    }

    public function mountMedium($arg_name, $arg_controllerPort, $arg_device, $arg_medium, $arg_force)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $request->medium = $arg_medium;
        $request->force = $arg_force;
        $response = $this->connection->__soapCall('IMachine_mountMedium', array((array)$request));
        return ;
    }

    public function getMedium($arg_name, $arg_controllerPort, $arg_device)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $response = $this->connection->__soapCall('IMachine_getMedium', array((array)$request));
        return new IMedium ($this->connection, $response->returnval);
    }

    public function getMediumAttachmentsOfController($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IMachine_getMediumAttachmentsOfController', array((array)$request));
        return new IMediumAttachmentCollection ($this->connection, (array)$response->returnval);
    }

    public function getMediumAttachment($arg_name, $arg_controllerPort, $arg_device)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->controllerPort = $arg_controllerPort;
        $request->device = $arg_device;
        $response = $this->connection->__soapCall('IMachine_getMediumAttachment', array((array)$request));
        return new IMediumAttachment ($this->connection, $response->returnval);
    }

    public function attachHostPCIDevice($arg_hostAddress, $arg_desiredGuestAddress, $arg_tryToUnbind)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->hostAddress = $arg_hostAddress;
        $request->desiredGuestAddress = $arg_desiredGuestAddress;
        $request->tryToUnbind = $arg_tryToUnbind;
        $response = $this->connection->__soapCall('IMachine_attachHostPCIDevice', array((array)$request));
        return ;
    }

    public function detachHostPCIDevice($arg_hostAddress)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->hostAddress = $arg_hostAddress;
        $response = $this->connection->__soapCall('IMachine_detachHostPCIDevice', array((array)$request));
        return ;
    }

    public function getNetworkAdapter($arg_slot)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->slot = $arg_slot;
        $response = $this->connection->__soapCall('IMachine_getNetworkAdapter', array((array)$request));
        return new INetworkAdapter ($this->connection, $response->returnval);
    }

    public function addStorageController($arg_name, $arg_connectionType)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->connectionType = $arg_connectionType;
        $response = $this->connection->__soapCall('IMachine_addStorageController', array((array)$request));
        return new IStorageController ($this->connection, $response->returnval);
    }

    public function getStorageControllerByName($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IMachine_getStorageControllerByName', array((array)$request));
        return new IStorageController ($this->connection, $response->returnval);
    }

    public function getStorageControllerByInstance($arg_instance)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->instance = $arg_instance;
        $response = $this->connection->__soapCall('IMachine_getStorageControllerByInstance', array((array)$request));
        return new IStorageController ($this->connection, $response->returnval);
    }

    public function removeStorageController($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IMachine_removeStorageController', array((array)$request));
        return ;
    }

    public function setStorageControllerBootable($arg_name, $arg_bootable)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->bootable = $arg_bootable;
        $response = $this->connection->__soapCall('IMachine_setStorageControllerBootable', array((array)$request));
        return ;
    }

    public function getSerialPort($arg_slot)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->slot = $arg_slot;
        $response = $this->connection->__soapCall('IMachine_getSerialPort', array((array)$request));
        return new ISerialPort ($this->connection, $response->returnval);
    }

    public function getParallelPort($arg_slot)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->slot = $arg_slot;
        $response = $this->connection->__soapCall('IMachine_getParallelPort', array((array)$request));
        return new IParallelPort ($this->connection, $response->returnval);
    }

    public function getExtraDataKeys()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getExtraDataKeys', array((array)$request));
        return (array)$response->returnval;
    }

    public function getExtraData($arg_key)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->key = $arg_key;
        $response = $this->connection->__soapCall('IMachine_getExtraData', array((array)$request));
        return (string)$response->returnval;
    }

    public function setExtraData($arg_key, $arg_value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->key = $arg_key;
        $request->value = $arg_value;
        $response = $this->connection->__soapCall('IMachine_setExtraData', array((array)$request));
        return ;
    }

    public function getCPUProperty($arg_property)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->property = $arg_property;
        $response = $this->connection->__soapCall('IMachine_getCPUProperty', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setCPUProperty($arg_property, $arg_value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->property = $arg_property;
        $request->value = $arg_value;
        $response = $this->connection->__soapCall('IMachine_setCPUProperty', array((array)$request));
        return ;
    }

    public function getCPUIDLeaf($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IMachine_getCPUIDLeaf', array((array)$request));
        return array((float)$response->valEax, (float)$response->valEbx, (float)$response->valEcx, (float)$response->valEdx);
    }

    public function setCPUIDLeaf($arg_id, $arg_valEax, $arg_valEbx, $arg_valEcx, $arg_valEdx)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $request->valEax = $arg_valEax;
        $request->valEbx = $arg_valEbx;
        $request->valEcx = $arg_valEcx;
        $request->valEdx = $arg_valEdx;
        $response = $this->connection->__soapCall('IMachine_setCPUIDLeaf', array((array)$request));
        return ;
    }

    public function removeCPUIDLeaf($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IMachine_removeCPUIDLeaf', array((array)$request));
        return ;
    }

    public function removeAllCPUIDLeaves()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_removeAllCPUIDLeaves', array((array)$request));
        return ;
    }

    public function getHWVirtExProperty($arg_property)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->property = $arg_property;
        $response = $this->connection->__soapCall('IMachine_getHWVirtExProperty', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setHWVirtExProperty($arg_property, $arg_value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->property = $arg_property;
        $request->value = $arg_value;
        $response = $this->connection->__soapCall('IMachine_setHWVirtExProperty', array((array)$request));
        return ;
    }

    public function saveSettings()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_saveSettings', array((array)$request));
        return ;
    }

    public function discardSettings()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_discardSettings', array((array)$request));
        return ;
    }

    public function unregister($arg_cleanupMode)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->cleanupMode = $arg_cleanupMode;
        $response = $this->connection->__soapCall('IMachine_unregister', array((array)$request));
        return new IMediumCollection ($this->connection, (array)$response->returnval);
    }

    public function delete($arg_aMedia)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aMedia = $arg_aMedia;
        $response = $this->connection->__soapCall('IMachine_delete', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function export($arg_aAppliance, $arg_location)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->aAppliance = $arg_aAppliance;
        $request->location = $arg_location;
        $response = $this->connection->__soapCall('IMachine_export', array((array)$request));
        return new IVirtualSystemDescription ($this->connection, $response->returnval);
    }

    public function findSnapshot($arg_nameOrId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->nameOrId = $arg_nameOrId;
        $response = $this->connection->__soapCall('IMachine_findSnapshot', array((array)$request));
        return new ISnapshot ($this->connection, $response->returnval);
    }

    public function createSharedFolder($arg_name, $arg_hostPath, $arg_writable, $arg_automount)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->hostPath = $arg_hostPath;
        $request->writable = $arg_writable;
        $request->automount = $arg_automount;
        $response = $this->connection->__soapCall('IMachine_createSharedFolder', array((array)$request));
        return ;
    }

    public function removeSharedFolder($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IMachine_removeSharedFolder', array((array)$request));
        return ;
    }

    public function canShowConsoleWindow()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_canShowConsoleWindow', array((array)$request));
        return (bool)$response->returnval;
    }

    public function showConsoleWindow()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_showConsoleWindow', array((array)$request));
        return (float)$response->returnval;
    }

    public function getGuestProperty($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IMachine_getGuestProperty', array((array)$request));
        return array((string)$response->value, (float)$response->timestamp, (string)$response->flags);
    }

    public function getGuestPropertyValue($arg_property)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->property = $arg_property;
        $response = $this->connection->__soapCall('IMachine_getGuestPropertyValue', array((array)$request));
        return (string)$response->returnval;
    }

    public function getGuestPropertyTimestamp($arg_property)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->property = $arg_property;
        $response = $this->connection->__soapCall('IMachine_getGuestPropertyTimestamp', array((array)$request));
        return (float)$response->returnval;
    }

    public function setGuestProperty($arg_property, $arg_value, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->property = $arg_property;
        $request->value = $arg_value;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IMachine_setGuestProperty', array((array)$request));
        return ;
    }

    public function setGuestPropertyValue($arg_property, $arg_value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->property = $arg_property;
        $request->value = $arg_value;
        $response = $this->connection->__soapCall('IMachine_setGuestPropertyValue', array((array)$request));
        return ;
    }

    public function deleteGuestProperty($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IMachine_deleteGuestProperty', array((array)$request));
        return ;
    }

    public function enumerateGuestProperties($arg_patterns)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->patterns = $arg_patterns;
        $response = $this->connection->__soapCall('IMachine_enumerateGuestProperties', array((array)$request));
        return array((array)$response->name, (array)$response->value, (array)$response->timestamp, (array)$response->flags);
    }

    public function querySavedGuestScreenInfo($arg_screenId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $response = $this->connection->__soapCall('IMachine_querySavedGuestScreenInfo', array((array)$request));
        return array((float)$response->originX, (float)$response->originY, (float)$response->width, (float)$response->height, (bool)$response->enabled);
    }

    public function querySavedThumbnailSize($arg_screenId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $response = $this->connection->__soapCall('IMachine_querySavedThumbnailSize', array((array)$request));
        return array((float)$response->size, (float)$response->width, (float)$response->height);
    }

    public function readSavedThumbnailToArray($arg_screenId, $arg_BGR)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $request->BGR = $arg_BGR;
        $response = $this->connection->__soapCall('IMachine_readSavedThumbnailToArray', array((array)$request));
        return array((array)$response->returnval, (float)$response->width, (float)$response->height);
    }

    public function readSavedThumbnailPNGToArray($arg_screenId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $response = $this->connection->__soapCall('IMachine_readSavedThumbnailPNGToArray', array((array)$request));
        return array((array)$response->returnval, (float)$response->width, (float)$response->height);
    }

    public function querySavedScreenshotPNGSize($arg_screenId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $response = $this->connection->__soapCall('IMachine_querySavedScreenshotPNGSize', array((array)$request));
        return array((float)$response->size, (float)$response->width, (float)$response->height);
    }

    public function readSavedScreenshotPNGToArray($arg_screenId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $response = $this->connection->__soapCall('IMachine_readSavedScreenshotPNGToArray', array((array)$request));
        return array((array)$response->returnval, (float)$response->width, (float)$response->height);
    }

    public function hotPlugCPU($arg_cpu)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->cpu = $arg_cpu;
        $response = $this->connection->__soapCall('IMachine_hotPlugCPU', array((array)$request));
        return ;
    }

    public function hotUnplugCPU($arg_cpu)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->cpu = $arg_cpu;
        $response = $this->connection->__soapCall('IMachine_hotUnplugCPU', array((array)$request));
        return ;
    }

    public function getCPUStatus($arg_cpu)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->cpu = $arg_cpu;
        $response = $this->connection->__soapCall('IMachine_getCPUStatus', array((array)$request));
        return (bool)$response->returnval;
    }

    public function queryLogFilename($arg_idx)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->idx = $arg_idx;
        $response = $this->connection->__soapCall('IMachine_queryLogFilename', array((array)$request));
        return (string)$response->returnval;
    }

    public function readLog($arg_idx, $arg_offset, $arg_size)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->idx = $arg_idx;
        $request->offset = $arg_offset;
        $request->size = $arg_size;
        $response = $this->connection->__soapCall('IMachine_readLog', array((array)$request));
        return (array)$response->returnval;
    }

    public function cloneTo($arg_target, $arg_mode, $arg_options)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->target = $arg_target;
        $request->mode = $arg_mode;
        $request->options = $arg_options;
        $response = $this->connection->__soapCall('IMachine_cloneTo', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function getParent()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getParent', array((array)$request));
        return new IVirtualBox ($this->connection, $response->returnval);
    }

    public function getAccessible()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getAccessible', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getAccessError()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getAccessError', array((array)$request));
        return new IVirtualBoxErrorInfo ($this->connection, $response->returnval);
    }

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function setName($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->name = $value;
        }
        else
        {
            $request->name = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setName', array((array)$request));
    }

    public function getDescription()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getDescription', array((array)$request));
        return (string)$response->returnval;
    }

    public function setDescription($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->description = $value;
        }
        else
        {
            $request->description = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setDescription', array((array)$request));
    }

    public function getId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getGroups()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getGroups', array((array)$request));
        return (array)$response->returnval;
    }

    public function setGroups($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_array($value) || is_null($value) || is_scalar($value))
        {
            $request->groups = $value;
        }
        else
        {
            $request->groups = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setGroups', array((array)$request));
    }

    public function getOSTypeId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getOSTypeId', array((array)$request));
        return (string)$response->returnval;
    }

    public function setOSTypeId($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->OSTypeId = $value;
        }
        else
        {
            $request->OSTypeId = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setOSTypeId', array((array)$request));
    }

    public function getHardwareVersion()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getHardwareVersion', array((array)$request));
        return (string)$response->returnval;
    }

    public function setHardwareVersion($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->hardwareVersion = $value;
        }
        else
        {
            $request->hardwareVersion = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setHardwareVersion', array((array)$request));
    }

    public function getHardwareUUID()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getHardwareUUID', array((array)$request));
        return (string)$response->returnval;
    }

    public function setHardwareUUID($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->hardwareUUID = $value;
        }
        else
        {
            $request->hardwareUUID = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setHardwareUUID', array((array)$request));
    }

    public function getCPUCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getCPUCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function setCPUCount($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->CPUCount = $value;
        }
        else
        {
            $request->CPUCount = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setCPUCount', array((array)$request));
    }

    public function getCPUHotPlugEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getCPUHotPlugEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setCPUHotPlugEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->CPUHotPlugEnabled = $value;
        }
        else
        {
            $request->CPUHotPlugEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setCPUHotPlugEnabled', array((array)$request));
    }

    public function getCPUExecutionCap()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getCPUExecutionCap', array((array)$request));
        return (float)$response->returnval;
    }

    public function setCPUExecutionCap($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->CPUExecutionCap = $value;
        }
        else
        {
            $request->CPUExecutionCap = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setCPUExecutionCap', array((array)$request));
    }

    public function getMemorySize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getMemorySize', array((array)$request));
        return (float)$response->returnval;
    }

    public function setMemorySize($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->memorySize = $value;
        }
        else
        {
            $request->memorySize = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setMemorySize', array((array)$request));
    }

    public function getMemoryBalloonSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getMemoryBalloonSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function setMemoryBalloonSize($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->memoryBalloonSize = $value;
        }
        else
        {
            $request->memoryBalloonSize = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setMemoryBalloonSize', array((array)$request));
    }

    public function getPageFusionEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getPageFusionEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setPageFusionEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->pageFusionEnabled = $value;
        }
        else
        {
            $request->pageFusionEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setPageFusionEnabled', array((array)$request));
    }

    public function getVRAMSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getVRAMSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function setVRAMSize($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->VRAMSize = $value;
        }
        else
        {
            $request->VRAMSize = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setVRAMSize', array((array)$request));
    }

    public function getAccelerate3DEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getAccelerate3DEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setAccelerate3DEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->accelerate3DEnabled = $value;
        }
        else
        {
            $request->accelerate3DEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setAccelerate3DEnabled', array((array)$request));
    }

    public function getAccelerate2DVideoEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getAccelerate2DVideoEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setAccelerate2DVideoEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->accelerate2DVideoEnabled = $value;
        }
        else
        {
            $request->accelerate2DVideoEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setAccelerate2DVideoEnabled', array((array)$request));
    }

    public function getMonitorCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getMonitorCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function setMonitorCount($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->monitorCount = $value;
        }
        else
        {
            $request->monitorCount = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setMonitorCount', array((array)$request));
    }

    public function getVideoCaptureEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getVideoCaptureEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setVideoCaptureEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->VideoCaptureEnabled = $value;
        }
        else
        {
            $request->VideoCaptureEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setVideoCaptureEnabled', array((array)$request));
    }

    public function getVideoCaptureFile()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getVideoCaptureFile', array((array)$request));
        return (string)$response->returnval;
    }

    public function setVideoCaptureFile($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->VideoCaptureFile = $value;
        }
        else
        {
            $request->VideoCaptureFile = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setVideoCaptureFile', array((array)$request));
    }

    public function getVideoCaptureWidth()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getVideoCaptureWidth', array((array)$request));
        return (float)$response->returnval;
    }

    public function setVideoCaptureWidth($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->VideoCaptureWidth = $value;
        }
        else
        {
            $request->VideoCaptureWidth = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setVideoCaptureWidth', array((array)$request));
    }

    public function getVideoCaptureHeight()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getVideoCaptureHeight', array((array)$request));
        return (float)$response->returnval;
    }

    public function setVideoCaptureHeight($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->VideoCaptureHeight = $value;
        }
        else
        {
            $request->VideoCaptureHeight = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setVideoCaptureHeight', array((array)$request));
    }

    public function getBIOSSettings()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getBIOSSettings', array((array)$request));
        return new IBIOSSettings ($this->connection, $response->returnval);
    }

    public function getFirmwareType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getFirmwareType', array((array)$request));
        return new FirmwareType ($this->connection, $response->returnval);
    }

    public function setFirmwareType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->firmwareType = $value;
        }
        else
        {
            $request->firmwareType = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setFirmwareType', array((array)$request));
    }

    public function getPointingHIDType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getPointingHIDType', array((array)$request));
        return new PointingHIDType ($this->connection, $response->returnval);
    }

    public function setPointingHIDType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->pointingHIDType = $value;
        }
        else
        {
            $request->pointingHIDType = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setPointingHIDType', array((array)$request));
    }

    public function getKeyboardHIDType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getKeyboardHIDType', array((array)$request));
        return new KeyboardHIDType ($this->connection, $response->returnval);
    }

    public function setKeyboardHIDType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->keyboardHIDType = $value;
        }
        else
        {
            $request->keyboardHIDType = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setKeyboardHIDType', array((array)$request));
    }

    public function getHPETEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getHPETEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setHPETEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->HPETEnabled = $value;
        }
        else
        {
            $request->HPETEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setHPETEnabled', array((array)$request));
    }

    public function getChipsetType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getChipsetType', array((array)$request));
        return new ChipsetType ($this->connection, $response->returnval);
    }

    public function setChipsetType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->chipsetType = $value;
        }
        else
        {
            $request->chipsetType = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setChipsetType', array((array)$request));
    }

    public function getSnapshotFolder()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getSnapshotFolder', array((array)$request));
        return (string)$response->returnval;
    }

    public function setSnapshotFolder($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->snapshotFolder = $value;
        }
        else
        {
            $request->snapshotFolder = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setSnapshotFolder', array((array)$request));
    }

    public function getVRDEServer()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getVRDEServer', array((array)$request));
        return new IVRDEServer ($this->connection, $response->returnval);
    }

    public function getEmulatedUSBWebcameraEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getEmulatedUSBWebcameraEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEmulatedUSBWebcameraEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->emulatedUSBWebcameraEnabled = $value;
        }
        else
        {
            $request->emulatedUSBWebcameraEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setEmulatedUSBWebcameraEnabled', array((array)$request));
    }

    public function getEmulatedUSBCardReaderEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getEmulatedUSBCardReaderEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEmulatedUSBCardReaderEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->emulatedUSBCardReaderEnabled = $value;
        }
        else
        {
            $request->emulatedUSBCardReaderEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setEmulatedUSBCardReaderEnabled', array((array)$request));
    }

    public function getMediumAttachments()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getMediumAttachments', array((array)$request));
        return new IMediumAttachmentCollection ($this->connection, (array)$response->returnval);
    }

    public function getUSBController()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getUSBController', array((array)$request));
        return new IUSBController ($this->connection, $response->returnval);
    }

    public function getAudioAdapter()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getAudioAdapter', array((array)$request));
        return new IAudioAdapter ($this->connection, $response->returnval);
    }

    public function getStorageControllers()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getStorageControllers', array((array)$request));
        return new IStorageControllerCollection ($this->connection, (array)$response->returnval);
    }

    public function getSettingsFilePath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getSettingsFilePath', array((array)$request));
        return (string)$response->returnval;
    }

    public function getSettingsModified()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getSettingsModified', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getSessionState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getSessionState', array((array)$request));
        return new SessionState ($this->connection, $response->returnval);
    }

    public function getSessionType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getSessionType', array((array)$request));
        return (string)$response->returnval;
    }

    public function getSessionPID()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getSessionPID', array((array)$request));
        return (float)$response->returnval;
    }

    public function getState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getState', array((array)$request));
        return new MachineState ($this->connection, $response->returnval);
    }

    public function getLastStateChange()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getLastStateChange', array((array)$request));
        return (float)$response->returnval;
    }

    public function getStateFilePath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getStateFilePath', array((array)$request));
        return (string)$response->returnval;
    }

    public function getLogFolder()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getLogFolder', array((array)$request));
        return (string)$response->returnval;
    }

    public function getCurrentSnapshot()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getCurrentSnapshot', array((array)$request));
        return new ISnapshot ($this->connection, $response->returnval);
    }

    public function getSnapshotCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getSnapshotCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getCurrentStateModified()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getCurrentStateModified', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getSharedFolders()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getSharedFolders', array((array)$request));
        return new ISharedFolderCollection ($this->connection, (array)$response->returnval);
    }

    public function getClipboardMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getClipboardMode', array((array)$request));
        return new ClipboardMode ($this->connection, $response->returnval);
    }

    public function setClipboardMode($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->clipboardMode = $value;
        }
        else
        {
            $request->clipboardMode = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setClipboardMode', array((array)$request));
    }

    public function getDragAndDropMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getDragAndDropMode', array((array)$request));
        return new DragAndDropMode ($this->connection, $response->returnval);
    }

    public function setDragAndDropMode($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->dragAndDropMode = $value;
        }
        else
        {
            $request->dragAndDropMode = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setDragAndDropMode', array((array)$request));
    }

    public function getGuestPropertyNotificationPatterns()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getGuestPropertyNotificationPatterns', array((array)$request));
        return (string)$response->returnval;
    }

    public function setGuestPropertyNotificationPatterns($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->guestPropertyNotificationPatterns = $value;
        }
        else
        {
            $request->guestPropertyNotificationPatterns = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setGuestPropertyNotificationPatterns', array((array)$request));
    }

    public function getTeleporterEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getTeleporterEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setTeleporterEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->teleporterEnabled = $value;
        }
        else
        {
            $request->teleporterEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setTeleporterEnabled', array((array)$request));
    }

    public function getTeleporterPort()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getTeleporterPort', array((array)$request));
        return (float)$response->returnval;
    }

    public function setTeleporterPort($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->teleporterPort = $value;
        }
        else
        {
            $request->teleporterPort = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setTeleporterPort', array((array)$request));
    }

    public function getTeleporterAddress()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getTeleporterAddress', array((array)$request));
        return (string)$response->returnval;
    }

    public function setTeleporterAddress($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->teleporterAddress = $value;
        }
        else
        {
            $request->teleporterAddress = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setTeleporterAddress', array((array)$request));
    }

    public function getTeleporterPassword()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getTeleporterPassword', array((array)$request));
        return (string)$response->returnval;
    }

    public function setTeleporterPassword($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->teleporterPassword = $value;
        }
        else
        {
            $request->teleporterPassword = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setTeleporterPassword', array((array)$request));
    }

    public function getFaultToleranceState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getFaultToleranceState', array((array)$request));
        return new FaultToleranceState ($this->connection, $response->returnval);
    }

    public function setFaultToleranceState($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->faultToleranceState = $value;
        }
        else
        {
            $request->faultToleranceState = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setFaultToleranceState', array((array)$request));
    }

    public function getFaultTolerancePort()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getFaultTolerancePort', array((array)$request));
        return (float)$response->returnval;
    }

    public function setFaultTolerancePort($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->faultTolerancePort = $value;
        }
        else
        {
            $request->faultTolerancePort = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setFaultTolerancePort', array((array)$request));
    }

    public function getFaultToleranceAddress()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getFaultToleranceAddress', array((array)$request));
        return (string)$response->returnval;
    }

    public function setFaultToleranceAddress($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->faultToleranceAddress = $value;
        }
        else
        {
            $request->faultToleranceAddress = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setFaultToleranceAddress', array((array)$request));
    }

    public function getFaultTolerancePassword()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getFaultTolerancePassword', array((array)$request));
        return (string)$response->returnval;
    }

    public function setFaultTolerancePassword($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->faultTolerancePassword = $value;
        }
        else
        {
            $request->faultTolerancePassword = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setFaultTolerancePassword', array((array)$request));
    }

    public function getFaultToleranceSyncInterval()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getFaultToleranceSyncInterval', array((array)$request));
        return (float)$response->returnval;
    }

    public function setFaultToleranceSyncInterval($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->faultToleranceSyncInterval = $value;
        }
        else
        {
            $request->faultToleranceSyncInterval = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setFaultToleranceSyncInterval', array((array)$request));
    }

    public function getRTCUseUTC()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getRTCUseUTC', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setRTCUseUTC($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->RTCUseUTC = $value;
        }
        else
        {
            $request->RTCUseUTC = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setRTCUseUTC', array((array)$request));
    }

    public function getIOCacheEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getIOCacheEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setIOCacheEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->IOCacheEnabled = $value;
        }
        else
        {
            $request->IOCacheEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setIOCacheEnabled', array((array)$request));
    }

    public function getIOCacheSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getIOCacheSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function setIOCacheSize($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->IOCacheSize = $value;
        }
        else
        {
            $request->IOCacheSize = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setIOCacheSize', array((array)$request));
    }

    public function getPCIDeviceAssignments()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getPCIDeviceAssignments', array((array)$request));
        return new IPCIDeviceAttachmentCollection ($this->connection, (array)$response->returnval);
    }

    public function getBandwidthControl()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getBandwidthControl', array((array)$request));
        return new IBandwidthControl ($this->connection, $response->returnval);
    }

    public function getTracingEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getTracingEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setTracingEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->tracingEnabled = $value;
        }
        else
        {
            $request->tracingEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setTracingEnabled', array((array)$request));
    }

    public function getTracingConfig()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getTracingConfig', array((array)$request));
        return (string)$response->returnval;
    }

    public function setTracingConfig($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->tracingConfig = $value;
        }
        else
        {
            $request->tracingConfig = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setTracingConfig', array((array)$request));
    }

    public function getAllowTracingToAccessVM()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getAllowTracingToAccessVM', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setAllowTracingToAccessVM($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->allowTracingToAccessVM = $value;
        }
        else
        {
            $request->allowTracingToAccessVM = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setAllowTracingToAccessVM', array((array)$request));
    }

    public function getAutostartEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getAutostartEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setAutostartEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->autostartEnabled = $value;
        }
        else
        {
            $request->autostartEnabled = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setAutostartEnabled', array((array)$request));
    }

    public function getAutostartDelay()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getAutostartDelay', array((array)$request));
        return (float)$response->returnval;
    }

    public function setAutostartDelay($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->autostartDelay = $value;
        }
        else
        {
            $request->autostartDelay = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setAutostartDelay', array((array)$request));
    }

    public function getAutostopType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachine_getAutostopType', array((array)$request));
        return new AutostopType ($this->connection, $response->returnval);
    }

    public function setAutostopType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->autostopType = $value;
        }
        else
        {
            $request->autostopType = $value->handle;
        }
        $this->connection->__soapCall('IMachine_setAutostopType', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMachineCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMachine";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IConsole extends VBox_ManagedObject
{

    public function powerUp()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_powerUp', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function powerUpPaused()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_powerUpPaused', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function powerDown()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_powerDown', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function reset()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_reset', array((array)$request));
        return ;
    }

    public function pause()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_pause', array((array)$request));
        return ;
    }

    public function resume()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_resume', array((array)$request));
        return ;
    }

    public function powerButton()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_powerButton', array((array)$request));
        return ;
    }

    public function sleepButton()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_sleepButton', array((array)$request));
        return ;
    }

    public function getPowerButtonHandled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getPowerButtonHandled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getGuestEnteredACPIMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getGuestEnteredACPIMode', array((array)$request));
        return (bool)$response->returnval;
    }

    public function saveState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_saveState', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function adoptSavedState($arg_savedStateFile)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->savedStateFile = $arg_savedStateFile;
        $response = $this->connection->__soapCall('IConsole_adoptSavedState', array((array)$request));
        return ;
    }

    public function discardSavedState($arg_fRemoveFile)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->fRemoveFile = $arg_fRemoveFile;
        $response = $this->connection->__soapCall('IConsole_discardSavedState', array((array)$request));
        return ;
    }

    public function getDeviceActivity($arg_type)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->type = $arg_type;
        $response = $this->connection->__soapCall('IConsole_getDeviceActivity', array((array)$request));
        return new DeviceActivity ($this->connection, $response->returnval);
    }

    public function attachUSBDevice($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IConsole_attachUSBDevice', array((array)$request));
        return ;
    }

    public function detachUSBDevice($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IConsole_detachUSBDevice', array((array)$request));
        return new IUSBDevice ($this->connection, $response->returnval);
    }

    public function findUSBDeviceByAddress($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IConsole_findUSBDeviceByAddress', array((array)$request));
        return new IUSBDevice ($this->connection, $response->returnval);
    }

    public function findUSBDeviceById($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IConsole_findUSBDeviceById', array((array)$request));
        return new IUSBDevice ($this->connection, $response->returnval);
    }

    public function createSharedFolder($arg_name, $arg_hostPath, $arg_writable, $arg_automount)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->hostPath = $arg_hostPath;
        $request->writable = $arg_writable;
        $request->automount = $arg_automount;
        $response = $this->connection->__soapCall('IConsole_createSharedFolder', array((array)$request));
        return ;
    }

    public function removeSharedFolder($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IConsole_removeSharedFolder', array((array)$request));
        return ;
    }

    public function takeSnapshot($arg_name, $arg_description)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->description = $arg_description;
        $response = $this->connection->__soapCall('IConsole_takeSnapshot', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function deleteSnapshot($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IConsole_deleteSnapshot', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function deleteSnapshotAndAllChildren($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IConsole_deleteSnapshotAndAllChildren', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function deleteSnapshotRange($arg_startId, $arg_endId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->startId = $arg_startId;
        $request->endId = $arg_endId;
        $response = $this->connection->__soapCall('IConsole_deleteSnapshotRange', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function restoreSnapshot($arg_snapshot)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->snapshot = $arg_snapshot;
        $response = $this->connection->__soapCall('IConsole_restoreSnapshot', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function teleport($arg_hostname, $arg_tcpport, $arg_password, $arg_maxDowntime)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->hostname = $arg_hostname;
        $request->tcpport = $arg_tcpport;
        $request->password = $arg_password;
        $request->maxDowntime = $arg_maxDowntime;
        $response = $this->connection->__soapCall('IConsole_teleport', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function getMachine()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getMachine', array((array)$request));
        return new IMachine ($this->connection, $response->returnval);
    }

    public function getState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getState', array((array)$request));
        return new MachineState ($this->connection, $response->returnval);
    }

    public function getGuest()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getGuest', array((array)$request));
        return new IGuest ($this->connection, $response->returnval);
    }

    public function getKeyboard()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getKeyboard', array((array)$request));
        return new IKeyboard ($this->connection, $response->returnval);
    }

    public function getMouse()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getMouse', array((array)$request));
        return new IMouse ($this->connection, $response->returnval);
    }

    public function getDisplay()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getDisplay', array((array)$request));
        return new IDisplay ($this->connection, $response->returnval);
    }

    public function getUSBDevices()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getUSBDevices', array((array)$request));
        return new IUSBDeviceCollection ($this->connection, (array)$response->returnval);
    }

    public function getRemoteUSBDevices()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getRemoteUSBDevices', array((array)$request));
        return new IHostUSBDeviceCollection ($this->connection, (array)$response->returnval);
    }

    public function getSharedFolders()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getSharedFolders', array((array)$request));
        return new ISharedFolderCollection ($this->connection, (array)$response->returnval);
    }

    public function getVRDEServerInfo()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getVRDEServerInfo', array((array)$request));
        return new IVRDEServerInfo ($this->connection, $response->returnval);
    }

    public function getEventSource()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getEventSource', array((array)$request));
        return new IEventSource ($this->connection, $response->returnval);
    }

    public function getAttachedPCIDevices()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getAttachedPCIDevices', array((array)$request));
        return new IPCIDeviceAttachmentCollection ($this->connection, (array)$response->returnval);
    }

    public function getUseHostClipboard()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IConsole_getUseHostClipboard', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setUseHostClipboard($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->useHostClipboard = $value;
        }
        else
        {
            $request->useHostClipboard = $value->handle;
        }
        $this->connection->__soapCall('IConsole_setUseHostClipboard', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IConsoleCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IConsole";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IHostNetworkInterface extends VBox_ManagedObject
{

    public function enableStaticIPConfig($arg_IPAddress, $arg_networkMask)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->IPAddress = $arg_IPAddress;
        $request->networkMask = $arg_networkMask;
        $response = $this->connection->__soapCall('IHostNetworkInterface_enableStaticIPConfig', array((array)$request));
        return ;
    }

    public function enableStaticIPConfigV6($arg_IPV6Address, $arg_IPV6NetworkMaskPrefixLength)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->IPV6Address = $arg_IPV6Address;
        $request->IPV6NetworkMaskPrefixLength = $arg_IPV6NetworkMaskPrefixLength;
        $response = $this->connection->__soapCall('IHostNetworkInterface_enableStaticIPConfigV6', array((array)$request));
        return ;
    }

    public function enableDynamicIPConfig()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_enableDynamicIPConfig', array((array)$request));
        return ;
    }

    public function DHCPRediscover()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_DHCPRediscover', array((array)$request));
        return ;
    }

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getNetworkName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getNetworkName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getDHCPEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getDHCPEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getIPAddress()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getIPAddress', array((array)$request));
        return (string)$response->returnval;
    }

    public function getNetworkMask()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getNetworkMask', array((array)$request));
        return (string)$response->returnval;
    }

    public function getIPV6Supported()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getIPV6Supported', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getIPV6Address()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getIPV6Address', array((array)$request));
        return (string)$response->returnval;
    }

    public function getIPV6NetworkMaskPrefixLength()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getIPV6NetworkMaskPrefixLength', array((array)$request));
        return (float)$response->returnval;
    }

    public function getHardwareAddress()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getHardwareAddress', array((array)$request));
        return (string)$response->returnval;
    }

    public function getMediumType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getMediumType', array((array)$request));
        return new HostNetworkInterfaceMediumType ($this->connection, $response->returnval);
    }

    public function getStatus()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getStatus', array((array)$request));
        return new HostNetworkInterfaceStatus ($this->connection, $response->returnval);
    }

    public function getInterfaceType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostNetworkInterface_getInterfaceType', array((array)$request));
        return new HostNetworkInterfaceType ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IHostNetworkInterfaceCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IHostNetworkInterface";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IHost extends VBox_ManagedObject
{

    public function getProcessorSpeed($arg_cpuId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->cpuId = $arg_cpuId;
        $response = $this->connection->__soapCall('IHost_getProcessorSpeed', array((array)$request));
        return (float)$response->returnval;
    }

    public function getProcessorFeature($arg_feature)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->feature = $arg_feature;
        $response = $this->connection->__soapCall('IHost_getProcessorFeature', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getProcessorDescription($arg_cpuId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->cpuId = $arg_cpuId;
        $response = $this->connection->__soapCall('IHost_getProcessorDescription', array((array)$request));
        return (string)$response->returnval;
    }

    public function getProcessorCPUIDLeaf($arg_cpuId, $arg_leaf, $arg_subLeaf)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->cpuId = $arg_cpuId;
        $request->leaf = $arg_leaf;
        $request->subLeaf = $arg_subLeaf;
        $response = $this->connection->__soapCall('IHost_getProcessorCPUIDLeaf', array((array)$request));
        return array((float)$response->valEax, (float)$response->valEbx, (float)$response->valEcx, (float)$response->valEdx);
    }

    public function createHostOnlyNetworkInterface()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_createHostOnlyNetworkInterface', array((array)$request));
        return array(new IProgress ($this->connection, $response->returnval), new IHostNetworkInterface ($this->connection, $response->hostInterface));
    }

    public function removeHostOnlyNetworkInterface($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IHost_removeHostOnlyNetworkInterface', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function createUSBDeviceFilter($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IHost_createUSBDeviceFilter', array((array)$request));
        return new IHostUSBDeviceFilter ($this->connection, $response->returnval);
    }

    public function insertUSBDeviceFilter($arg_position, $arg_filter)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->position = $arg_position;
        $request->filter = $arg_filter;
        $response = $this->connection->__soapCall('IHost_insertUSBDeviceFilter', array((array)$request));
        return ;
    }

    public function removeUSBDeviceFilter($arg_position)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->position = $arg_position;
        $response = $this->connection->__soapCall('IHost_removeUSBDeviceFilter', array((array)$request));
        return ;
    }

    public function findHostDVDDrive($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IHost_findHostDVDDrive', array((array)$request));
        return new IMedium ($this->connection, $response->returnval);
    }

    public function findHostFloppyDrive($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IHost_findHostFloppyDrive', array((array)$request));
        return new IMedium ($this->connection, $response->returnval);
    }

    public function findHostNetworkInterfaceByName($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IHost_findHostNetworkInterfaceByName', array((array)$request));
        return new IHostNetworkInterface ($this->connection, $response->returnval);
    }

    public function findHostNetworkInterfaceById($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IHost_findHostNetworkInterfaceById', array((array)$request));
        return new IHostNetworkInterface ($this->connection, $response->returnval);
    }

    public function findHostNetworkInterfacesOfType($arg_type)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->type = $arg_type;
        $response = $this->connection->__soapCall('IHost_findHostNetworkInterfacesOfType', array((array)$request));
        return new IHostNetworkInterfaceCollection ($this->connection, (array)$response->returnval);
    }

    public function findUSBDeviceById($arg_id)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->id = $arg_id;
        $response = $this->connection->__soapCall('IHost_findUSBDeviceById', array((array)$request));
        return new IHostUSBDevice ($this->connection, $response->returnval);
    }

    public function findUSBDeviceByAddress($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IHost_findUSBDeviceByAddress', array((array)$request));
        return new IHostUSBDevice ($this->connection, $response->returnval);
    }

    public function generateMACAddress()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_generateMACAddress', array((array)$request));
        return (string)$response->returnval;
    }

    public function getDVDDrives()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getDVDDrives', array((array)$request));
        return new IMediumCollection ($this->connection, (array)$response->returnval);
    }

    public function getFloppyDrives()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getFloppyDrives', array((array)$request));
        return new IMediumCollection ($this->connection, (array)$response->returnval);
    }

    public function getUSBDevices()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getUSBDevices', array((array)$request));
        return new IHostUSBDeviceCollection ($this->connection, (array)$response->returnval);
    }

    public function getUSBDeviceFilters()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getUSBDeviceFilters', array((array)$request));
        return new IHostUSBDeviceFilterCollection ($this->connection, (array)$response->returnval);
    }

    public function getNetworkInterfaces()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getNetworkInterfaces', array((array)$request));
        return new IHostNetworkInterfaceCollection ($this->connection, (array)$response->returnval);
    }

    public function getProcessorCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getProcessorCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getProcessorOnlineCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getProcessorOnlineCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getProcessorCoreCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getProcessorCoreCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMemorySize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getMemorySize', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMemoryAvailable()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getMemoryAvailable', array((array)$request));
        return (float)$response->returnval;
    }

    public function getOperatingSystem()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getOperatingSystem', array((array)$request));
        return (string)$response->returnval;
    }

    public function getOSVersion()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getOSVersion', array((array)$request));
        return (string)$response->returnval;
    }

    public function getUTCTime()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getUTCTime', array((array)$request));
        return (float)$response->returnval;
    }

    public function getAcceleration3DAvailable()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHost_getAcceleration3DAvailable', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IHostCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IHost";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISystemProperties extends VBox_ManagedObject
{

    public function getMaxNetworkAdapters($arg_chipset)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->chipset = $arg_chipset;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxNetworkAdapters', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxNetworkAdaptersOfType($arg_chipset, $arg_type)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->chipset = $arg_chipset;
        $request->type = $arg_type;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxNetworkAdaptersOfType', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxDevicesPerPortForStorageBus($arg_bus)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->bus = $arg_bus;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxDevicesPerPortForStorageBus', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMinPortCountForStorageBus($arg_bus)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->bus = $arg_bus;
        $response = $this->connection->__soapCall('ISystemProperties_getMinPortCountForStorageBus', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxPortCountForStorageBus($arg_bus)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->bus = $arg_bus;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxPortCountForStorageBus', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxInstancesOfStorageBus($arg_chipset, $arg_bus)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->chipset = $arg_chipset;
        $request->bus = $arg_bus;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxInstancesOfStorageBus', array((array)$request));
        return (float)$response->returnval;
    }

    public function getDeviceTypesForStorageBus($arg_bus)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->bus = $arg_bus;
        $response = $this->connection->__soapCall('ISystemProperties_getDeviceTypesForStorageBus', array((array)$request));
        return new DeviceTypeCollection ($this->connection, (array)$response->returnval);
    }

    public function getDefaultIoCacheSettingForStorageController($arg_controllerType)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->controllerType = $arg_controllerType;
        $response = $this->connection->__soapCall('ISystemProperties_getDefaultIoCacheSettingForStorageController', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getMinGuestRAM()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getMinGuestRAM', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxGuestRAM()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxGuestRAM', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMinGuestVRAM()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getMinGuestVRAM', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxGuestVRAM()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxGuestVRAM', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMinGuestCPUCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getMinGuestCPUCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxGuestCPUCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxGuestCPUCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxGuestMonitors()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxGuestMonitors', array((array)$request));
        return (float)$response->returnval;
    }

    public function getInfoVDSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getInfoVDSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function getSerialPortCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getSerialPortCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getParallelPortCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getParallelPortCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxBootPosition()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getMaxBootPosition', array((array)$request));
        return (float)$response->returnval;
    }

    public function getDefaultMachineFolder()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getDefaultMachineFolder', array((array)$request));
        return (string)$response->returnval;
    }

    public function setDefaultMachineFolder($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->defaultMachineFolder = $value;
        }
        else
        {
            $request->defaultMachineFolder = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setDefaultMachineFolder', array((array)$request));
    }

    public function getMediumFormats()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getMediumFormats', array((array)$request));
        return new IMediumFormatCollection ($this->connection, (array)$response->returnval);
    }

    public function getDefaultHardDiskFormat()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getDefaultHardDiskFormat', array((array)$request));
        return (string)$response->returnval;
    }

    public function setDefaultHardDiskFormat($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->defaultHardDiskFormat = $value;
        }
        else
        {
            $request->defaultHardDiskFormat = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setDefaultHardDiskFormat', array((array)$request));
    }

    public function getFreeDiskSpaceWarning()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getFreeDiskSpaceWarning', array((array)$request));
        return (float)$response->returnval;
    }

    public function setFreeDiskSpaceWarning($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->freeDiskSpaceWarning = $value;
        }
        else
        {
            $request->freeDiskSpaceWarning = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setFreeDiskSpaceWarning', array((array)$request));
    }

    public function getFreeDiskSpacePercentWarning()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getFreeDiskSpacePercentWarning', array((array)$request));
        return (float)$response->returnval;
    }

    public function setFreeDiskSpacePercentWarning($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->freeDiskSpacePercentWarning = $value;
        }
        else
        {
            $request->freeDiskSpacePercentWarning = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setFreeDiskSpacePercentWarning', array((array)$request));
    }

    public function getFreeDiskSpaceError()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getFreeDiskSpaceError', array((array)$request));
        return (float)$response->returnval;
    }

    public function setFreeDiskSpaceError($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->freeDiskSpaceError = $value;
        }
        else
        {
            $request->freeDiskSpaceError = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setFreeDiskSpaceError', array((array)$request));
    }

    public function getFreeDiskSpacePercentError()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getFreeDiskSpacePercentError', array((array)$request));
        return (float)$response->returnval;
    }

    public function setFreeDiskSpacePercentError($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->freeDiskSpacePercentError = $value;
        }
        else
        {
            $request->freeDiskSpacePercentError = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setFreeDiskSpacePercentError', array((array)$request));
    }

    public function getVRDEAuthLibrary()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getVRDEAuthLibrary', array((array)$request));
        return (string)$response->returnval;
    }

    public function setVRDEAuthLibrary($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->VRDEAuthLibrary = $value;
        }
        else
        {
            $request->VRDEAuthLibrary = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setVRDEAuthLibrary', array((array)$request));
    }

    public function getWebServiceAuthLibrary()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getWebServiceAuthLibrary', array((array)$request));
        return (string)$response->returnval;
    }

    public function setWebServiceAuthLibrary($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->webServiceAuthLibrary = $value;
        }
        else
        {
            $request->webServiceAuthLibrary = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setWebServiceAuthLibrary', array((array)$request));
    }

    public function getDefaultVRDEExtPack()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getDefaultVRDEExtPack', array((array)$request));
        return (string)$response->returnval;
    }

    public function setDefaultVRDEExtPack($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->defaultVRDEExtPack = $value;
        }
        else
        {
            $request->defaultVRDEExtPack = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setDefaultVRDEExtPack', array((array)$request));
    }

    public function getLogHistoryCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getLogHistoryCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function setLogHistoryCount($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->logHistoryCount = $value;
        }
        else
        {
            $request->logHistoryCount = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setLogHistoryCount', array((array)$request));
    }

    public function getDefaultAudioDriver()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getDefaultAudioDriver', array((array)$request));
        return new AudioDriverType ($this->connection, $response->returnval);
    }

    public function getAutostartDatabasePath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getAutostartDatabasePath', array((array)$request));
        return (string)$response->returnval;
    }

    public function setAutostartDatabasePath($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->autostartDatabasePath = $value;
        }
        else
        {
            $request->autostartDatabasePath = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setAutostartDatabasePath', array((array)$request));
    }

    public function getDefaultAdditionsISO()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISystemProperties_getDefaultAdditionsISO', array((array)$request));
        return (string)$response->returnval;
    }

    public function setDefaultAdditionsISO($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->defaultAdditionsISO = $value;
        }
        else
        {
            $request->defaultAdditionsISO = $value->handle;
        }
        $this->connection->__soapCall('ISystemProperties_setDefaultAdditionsISO', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISystemPropertiesCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISystemProperties";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuestSession extends VBox_ManagedObject
{

    public function close()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_close', array((array)$request));
        return ;
    }

    public function copyFrom($arg_source, $arg_dest, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->source = $arg_source;
        $request->dest = $arg_dest;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IGuestSession_copyFrom', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function copyTo($arg_source, $arg_dest, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->source = $arg_source;
        $request->dest = $arg_dest;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IGuestSession_copyTo', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function directoryCreate($arg_path, $arg_mode, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $request->mode = $arg_mode;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IGuestSession_directoryCreate', array((array)$request));
        return ;
    }

    public function directoryCreateTemp($arg_templateName, $arg_mode, $arg_path, $arg_secure)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->templateName = $arg_templateName;
        $request->mode = $arg_mode;
        $request->path = $arg_path;
        $request->secure = $arg_secure;
        $response = $this->connection->__soapCall('IGuestSession_directoryCreateTemp', array((array)$request));
        return (string)$response->returnval;
    }

    public function directoryExists($arg_path)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $response = $this->connection->__soapCall('IGuestSession_directoryExists', array((array)$request));
        return (bool)$response->returnval;
    }

    public function directoryOpen($arg_path, $arg_filter, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $request->filter = $arg_filter;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IGuestSession_directoryOpen', array((array)$request));
        return new IGuestDirectory ($this->connection, $response->returnval);
    }

    public function directoryQueryInfo($arg_path)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $response = $this->connection->__soapCall('IGuestSession_directoryQueryInfo', array((array)$request));
        return new IGuestFsObjInfo ($this->connection, $response->returnval);
    }

    public function directoryRemove($arg_path)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $response = $this->connection->__soapCall('IGuestSession_directoryRemove', array((array)$request));
        return ;
    }

    public function directoryRemoveRecursive($arg_path, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IGuestSession_directoryRemoveRecursive', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function directoryRename($arg_source, $arg_dest, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->source = $arg_source;
        $request->dest = $arg_dest;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IGuestSession_directoryRename', array((array)$request));
        return ;
    }

    public function directorySetACL($arg_path, $arg_acl)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $request->acl = $arg_acl;
        $response = $this->connection->__soapCall('IGuestSession_directorySetACL', array((array)$request));
        return ;
    }

    public function environmentClear()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_environmentClear', array((array)$request));
        return ;
    }

    public function environmentGet($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IGuestSession_environmentGet', array((array)$request));
        return (string)$response->returnval;
    }

    public function environmentSet($arg_name, $arg_value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->value = $arg_value;
        $response = $this->connection->__soapCall('IGuestSession_environmentSet', array((array)$request));
        return ;
    }

    public function environmentUnset($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IGuestSession_environmentUnset', array((array)$request));
        return ;
    }

    public function fileCreateTemp($arg_templateName, $arg_mode, $arg_path, $arg_secure)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->templateName = $arg_templateName;
        $request->mode = $arg_mode;
        $request->path = $arg_path;
        $request->secure = $arg_secure;
        $response = $this->connection->__soapCall('IGuestSession_fileCreateTemp', array((array)$request));
        return new IGuestFile ($this->connection, $response->returnval);
    }

    public function fileExists($arg_path)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $response = $this->connection->__soapCall('IGuestSession_fileExists', array((array)$request));
        return (bool)$response->returnval;
    }

    public function fileRemove($arg_path)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $response = $this->connection->__soapCall('IGuestSession_fileRemove', array((array)$request));
        return ;
    }

    public function fileOpen($arg_path, $arg_openMode, $arg_disposition, $arg_creationMode, $arg_offset)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $request->openMode = $arg_openMode;
        $request->disposition = $arg_disposition;
        $request->creationMode = $arg_creationMode;
        $request->offset = $arg_offset;
        $response = $this->connection->__soapCall('IGuestSession_fileOpen', array((array)$request));
        return new IGuestFile ($this->connection, $response->returnval);
    }

    public function fileQueryInfo($arg_path)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $response = $this->connection->__soapCall('IGuestSession_fileQueryInfo', array((array)$request));
        return new IGuestFsObjInfo ($this->connection, $response->returnval);
    }

    public function fileQuerySize($arg_path)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $response = $this->connection->__soapCall('IGuestSession_fileQuerySize', array((array)$request));
        return (float)$response->returnval;
    }

    public function fileRename($arg_source, $arg_dest, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->source = $arg_source;
        $request->dest = $arg_dest;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IGuestSession_fileRename', array((array)$request));
        return ;
    }

    public function fileSetACL($arg_file, $arg_acl)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->file = $arg_file;
        $request->acl = $arg_acl;
        $response = $this->connection->__soapCall('IGuestSession_fileSetACL', array((array)$request));
        return ;
    }

    public function processCreate($arg_command, $arg_arguments, $arg_environment, $arg_flags, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->command = $arg_command;
        $request->arguments = $arg_arguments;
        $request->environment = $arg_environment;
        $request->flags = $arg_flags;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IGuestSession_processCreate', array((array)$request));
        return new IGuestProcess ($this->connection, $response->returnval);
    }

    public function processCreateEx($arg_command, $arg_arguments, $arg_environment, $arg_flags, $arg_timeoutMS, $arg_priority, $arg_affinity)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->command = $arg_command;
        $request->arguments = $arg_arguments;
        $request->environment = $arg_environment;
        $request->flags = $arg_flags;
        $request->timeoutMS = $arg_timeoutMS;
        $request->priority = $arg_priority;
        $request->affinity = $arg_affinity;
        $response = $this->connection->__soapCall('IGuestSession_processCreateEx', array((array)$request));
        return new IGuestProcess ($this->connection, $response->returnval);
    }

    public function processGet($arg_pid)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->pid = $arg_pid;
        $response = $this->connection->__soapCall('IGuestSession_processGet', array((array)$request));
        return new IGuestProcess ($this->connection, $response->returnval);
    }

    public function symlinkCreate($arg_source, $arg_target, $arg_type)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->source = $arg_source;
        $request->target = $arg_target;
        $request->type = $arg_type;
        $response = $this->connection->__soapCall('IGuestSession_symlinkCreate', array((array)$request));
        return ;
    }

    public function symlinkExists($arg_symlink)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->symlink = $arg_symlink;
        $response = $this->connection->__soapCall('IGuestSession_symlinkExists', array((array)$request));
        return (bool)$response->returnval;
    }

    public function symlinkRead($arg_symlink, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->symlink = $arg_symlink;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IGuestSession_symlinkRead', array((array)$request));
        return (string)$response->returnval;
    }

    public function symlinkRemoveDirectory($arg_path)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->path = $arg_path;
        $response = $this->connection->__soapCall('IGuestSession_symlinkRemoveDirectory', array((array)$request));
        return ;
    }

    public function symlinkRemoveFile($arg_file)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->file = $arg_file;
        $response = $this->connection->__soapCall('IGuestSession_symlinkRemoveFile', array((array)$request));
        return ;
    }

    public function getUser()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_getUser', array((array)$request));
        return (string)$response->returnval;
    }

    public function getDomain()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_getDomain', array((array)$request));
        return (string)$response->returnval;
    }

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_getId', array((array)$request));
        return (float)$response->returnval;
    }

    public function getTimeout()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_getTimeout', array((array)$request));
        return (float)$response->returnval;
    }

    public function setTimeout($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->timeout = $value;
        }
        else
        {
            $request->timeout = $value->handle;
        }
        $this->connection->__soapCall('IGuestSession_setTimeout', array((array)$request));
    }

    public function getEnvironment()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_getEnvironment', array((array)$request));
        return (array)$response->returnval;
    }

    public function setEnvironment($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_array($value) || is_null($value) || is_scalar($value))
        {
            $request->environment = $value;
        }
        else
        {
            $request->environment = $value->handle;
        }
        $this->connection->__soapCall('IGuestSession_setEnvironment', array((array)$request));
    }

    public function getProcesses()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_getProcesses', array((array)$request));
        return new IGuestProcessCollection ($this->connection, (array)$response->returnval);
    }

    public function getDirectories()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_getDirectories', array((array)$request));
        return new IGuestDirectoryCollection ($this->connection, (array)$response->returnval);
    }

    public function getFiles()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestSession_getFiles', array((array)$request));
        return new IGuestFileCollection ($this->connection, (array)$response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestSessionCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuestSession";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IProcess extends VBox_ManagedObject
{

    public function waitFor($arg_waitFor, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->waitFor = $arg_waitFor;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IProcess_waitFor', array((array)$request));
        return new ProcessWaitResult ($this->connection, $response->returnval);
    }

    public function waitForArray($arg_waitFor, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->waitFor = $arg_waitFor;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IProcess_waitForArray', array((array)$request));
        return new ProcessWaitResult ($this->connection, $response->returnval);
    }

    public function read($arg_handle, $arg_toRead, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->handle = $arg_handle;
        $request->toRead = $arg_toRead;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IProcess_read', array((array)$request));
        return (array)$response->returnval;
    }

    public function write($arg_handle, $arg_flags, $arg_data, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->handle = $arg_handle;
        $request->flags = $arg_flags;
        $request->data = $arg_data;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IProcess_write', array((array)$request));
        return (float)$response->returnval;
    }

    public function writeArray($arg_handle, $arg_flags, $arg_data, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->handle = $arg_handle;
        $request->flags = $arg_flags;
        $request->data = $arg_data;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IProcess_writeArray', array((array)$request));
        return (float)$response->returnval;
    }

    public function terminate()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProcess_terminate', array((array)$request));
        return ;
    }

    public function getPID()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProcess_getPID', array((array)$request));
        return (float)$response->returnval;
    }

    public function getStatus()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProcess_getStatus', array((array)$request));
        return new ProcessStatus ($this->connection, $response->returnval);
    }

    public function getExitCode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProcess_getExitCode', array((array)$request));
        return (int)$response->returnval;
    }

    public function getEnvironment()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProcess_getEnvironment', array((array)$request));
        return (array)$response->returnval;
    }

    public function getArguments()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProcess_getArguments', array((array)$request));
        return (array)$response->returnval;
    }

    public function getExecutablePath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProcess_getExecutablePath', array((array)$request));
        return (string)$response->returnval;
    }

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProcess_getName', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IProcessCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IProcess";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuestProcess extends IProcess
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestProcessCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuestProcess";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IDirectory extends VBox_ManagedObject
{

    public function close()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDirectory_close', array((array)$request));
        return ;
    }

    public function read()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDirectory_read', array((array)$request));
        return new IFsObjInfo ($this->connection, $response->returnval);
    }

    public function getDirectoryName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDirectory_getDirectoryName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getFilter()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDirectory_getFilter', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IDirectoryCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IDirectory";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuestDirectory extends IDirectory
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestDirectoryCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuestDirectory";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IFile extends VBox_ManagedObject
{

    public function close()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFile_close', array((array)$request));
        return ;
    }

    public function queryInfo()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFile_queryInfo', array((array)$request));
        return new IFsObjInfo ($this->connection, $response->returnval);
    }

    public function read($arg_toRead, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->toRead = $arg_toRead;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IFile_read', array((array)$request));
        return (array)$response->returnval;
    }

    public function readAt($arg_offset, $arg_toRead, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->offset = $arg_offset;
        $request->toRead = $arg_toRead;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IFile_readAt', array((array)$request));
        return (array)$response->returnval;
    }

    public function seek($arg_offset, $arg_whence)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->offset = $arg_offset;
        $request->whence = $arg_whence;
        $response = $this->connection->__soapCall('IFile_seek', array((array)$request));
        return ;
    }

    public function setACL($arg_acl)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->acl = $arg_acl;
        $response = $this->connection->__soapCall('IFile_setACL', array((array)$request));
        return ;
    }

    public function write($arg_data, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->data = $arg_data;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IFile_write', array((array)$request));
        return (float)$response->returnval;
    }

    public function writeAt($arg_offset, $arg_data, $arg_timeoutMS)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->offset = $arg_offset;
        $request->data = $arg_data;
        $request->timeoutMS = $arg_timeoutMS;
        $response = $this->connection->__soapCall('IFile_writeAt', array((array)$request));
        return (float)$response->returnval;
    }

    public function getCreationMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFile_getCreationMode', array((array)$request));
        return (float)$response->returnval;
    }

    public function getDisposition()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFile_getDisposition', array((array)$request));
        return (float)$response->returnval;
    }

    public function getFileName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFile_getFileName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getInitialSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFile_getInitialSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function getOpenMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFile_getOpenMode', array((array)$request));
        return (float)$response->returnval;
    }

    public function getOffset()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFile_getOffset', array((array)$request));
        return (float)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IFileCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IFile";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuestFile extends IFile
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestFileCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuestFile";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IFsObjInfo extends VBox_ManagedObject
{

    public function getAccessTime()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getAccessTime', array((array)$request));
        return (float)$response->returnval;
    }

    public function getAllocatedSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getAllocatedSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function getBirthTime()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getBirthTime', array((array)$request));
        return (float)$response->returnval;
    }

    public function getChangeTime()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getChangeTime', array((array)$request));
        return (float)$response->returnval;
    }

    public function getDeviceNumber()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getDeviceNumber', array((array)$request));
        return (float)$response->returnval;
    }

    public function getFileAttributes()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getFileAttributes', array((array)$request));
        return (string)$response->returnval;
    }

    public function getGenerationId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getGenerationId', array((array)$request));
        return (float)$response->returnval;
    }

    public function getGID()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getGID', array((array)$request));
        return (float)$response->returnval;
    }

    public function getGroupName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getGroupName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getHardLinks()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getHardLinks', array((array)$request));
        return (float)$response->returnval;
    }

    public function getModificationTime()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getModificationTime', array((array)$request));
        return (float)$response->returnval;
    }

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getNodeId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getNodeId', array((array)$request));
        return (float)$response->returnval;
    }

    public function getNodeIdDevice()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getNodeIdDevice', array((array)$request));
        return (float)$response->returnval;
    }

    public function getObjectSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getObjectSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function getType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getType', array((array)$request));
        return new FsObjType ($this->connection, $response->returnval);
    }

    public function getUID()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getUID', array((array)$request));
        return (float)$response->returnval;
    }

    public function getUserFlags()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getUserFlags', array((array)$request));
        return (float)$response->returnval;
    }

    public function getUserName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IFsObjInfo_getUserName', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IFsObjInfoCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IFsObjInfo";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuestFsObjInfo extends IFsObjInfo
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestFsObjInfoCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuestFsObjInfo";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuest extends VBox_ManagedObject
{

    public function internalGetStatistics()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_internalGetStatistics', array((array)$request));
        return array((float)$response->cpuUser, (float)$response->cpuKernel, (float)$response->cpuIdle, (float)$response->memTotal, (float)$response->memFree, (float)$response->memBalloon, (float)$response->memShared, (float)$response->memCache, (float)$response->pagedTotal, (float)$response->memAllocTotal, (float)$response->memFreeTotal, (float)$response->memBalloonTotal, (float)$response->memSharedTotal);
    }

    public function getFacilityStatus($arg_facility)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->facility = $arg_facility;
        $response = $this->connection->__soapCall('IGuest_getFacilityStatus', array((array)$request));
        return array(new AdditionsFacilityStatus ($this->connection, $response->returnval), (float)$response->timestamp);
    }

    public function getAdditionsStatus($arg_level)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->level = $arg_level;
        $response = $this->connection->__soapCall('IGuest_getAdditionsStatus', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setCredentials($arg_userName, $arg_password, $arg_domain, $arg_allowInteractiveLogon)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->userName = $arg_userName;
        $request->password = $arg_password;
        $request->domain = $arg_domain;
        $request->allowInteractiveLogon = $arg_allowInteractiveLogon;
        $response = $this->connection->__soapCall('IGuest_setCredentials', array((array)$request));
        return ;
    }

    public function dragHGEnter($arg_screenId, $arg_y, $arg_x, $arg_defaultAction, $arg_allowedActions, $arg_formats)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $request->y = $arg_y;
        $request->x = $arg_x;
        $request->defaultAction = $arg_defaultAction;
        $request->allowedActions = $arg_allowedActions;
        $request->formats = $arg_formats;
        $response = $this->connection->__soapCall('IGuest_dragHGEnter', array((array)$request));
        return new DragAndDropAction ($this->connection, $response->returnval);
    }

    public function dragHGMove($arg_screenId, $arg_x, $arg_y, $arg_defaultAction, $arg_allowedActions, $arg_formats)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $request->x = $arg_x;
        $request->y = $arg_y;
        $request->defaultAction = $arg_defaultAction;
        $request->allowedActions = $arg_allowedActions;
        $request->formats = $arg_formats;
        $response = $this->connection->__soapCall('IGuest_dragHGMove', array((array)$request));
        return new DragAndDropAction ($this->connection, $response->returnval);
    }

    public function dragHGLeave($arg_screenId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $response = $this->connection->__soapCall('IGuest_dragHGLeave', array((array)$request));
        return ;
    }

    public function dragHGDrop($arg_screenId, $arg_x, $arg_y, $arg_defaultAction, $arg_allowedActions, $arg_formats)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $request->x = $arg_x;
        $request->y = $arg_y;
        $request->defaultAction = $arg_defaultAction;
        $request->allowedActions = $arg_allowedActions;
        $request->formats = $arg_formats;
        $response = $this->connection->__soapCall('IGuest_dragHGDrop', array((array)$request));
        return array(new DragAndDropAction ($this->connection, $response->returnval), (string)$response->format);
    }

    public function dragHGPutData($arg_screenId, $arg_format, $arg_data)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $request->format = $arg_format;
        $request->data = $arg_data;
        $response = $this->connection->__soapCall('IGuest_dragHGPutData', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function dragGHPending($arg_screenId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $response = $this->connection->__soapCall('IGuest_dragGHPending', array((array)$request));
        return array(new DragAndDropAction ($this->connection, $response->returnval), (array)$response->format, new DragAndDropActionCollection ($this->connection, (array)$response->allowedActions));
    }

    public function dragGHDropped($arg_format, $arg_action)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->format = $arg_format;
        $request->action = $arg_action;
        $response = $this->connection->__soapCall('IGuest_dragGHDropped', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function dragGHGetData()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_dragGHGetData', array((array)$request));
        return (array)$response->returnval;
    }

    public function createSession($arg_user, $arg_password, $arg_domain, $arg_sessionName)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->user = $arg_user;
        $request->password = $arg_password;
        $request->domain = $arg_domain;
        $request->sessionName = $arg_sessionName;
        $response = $this->connection->__soapCall('IGuest_createSession', array((array)$request));
        return new IGuestSession ($this->connection, $response->returnval);
    }

    public function findSession($arg_sessionName)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->sessionName = $arg_sessionName;
        $response = $this->connection->__soapCall('IGuest_findSession', array((array)$request));
        return new IGuestSessionCollection ($this->connection, (array)$response->returnval);
    }

    public function updateGuestAdditions($arg_source, $arg_flags)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->source = $arg_source;
        $request->flags = $arg_flags;
        $response = $this->connection->__soapCall('IGuest_updateGuestAdditions', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function getOSTypeId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_getOSTypeId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getAdditionsRunLevel()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_getAdditionsRunLevel', array((array)$request));
        return new AdditionsRunLevelType ($this->connection, $response->returnval);
    }

    public function getAdditionsVersion()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_getAdditionsVersion', array((array)$request));
        return (string)$response->returnval;
    }

    public function getAdditionsRevision()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_getAdditionsRevision', array((array)$request));
        return (float)$response->returnval;
    }

    public function getFacilities()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_getFacilities', array((array)$request));
        return new IAdditionsFacilityCollection ($this->connection, (array)$response->returnval);
    }

    public function getSessions()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_getSessions', array((array)$request));
        return new IGuestSessionCollection ($this->connection, (array)$response->returnval);
    }

    public function getMemoryBalloonSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_getMemoryBalloonSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function setMemoryBalloonSize($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->memoryBalloonSize = $value;
        }
        else
        {
            $request->memoryBalloonSize = $value->handle;
        }
        $this->connection->__soapCall('IGuest_setMemoryBalloonSize', array((array)$request));
    }

    public function getStatisticsUpdateInterval()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuest_getStatisticsUpdateInterval', array((array)$request));
        return (float)$response->returnval;
    }

    public function setStatisticsUpdateInterval($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->statisticsUpdateInterval = $value;
        }
        else
        {
            $request->statisticsUpdateInterval = $value->handle;
        }
        $this->connection->__soapCall('IGuest_setStatisticsUpdateInterval', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuest";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IProgress extends VBox_ManagedObject
{

    public function setCurrentOperationProgress($arg_percent)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->percent = $arg_percent;
        $response = $this->connection->__soapCall('IProgress_setCurrentOperationProgress', array((array)$request));
        return ;
    }

    public function setNextOperation($arg_nextOperationDescription, $arg_nextOperationsWeight)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->nextOperationDescription = $arg_nextOperationDescription;
        $request->nextOperationsWeight = $arg_nextOperationsWeight;
        $response = $this->connection->__soapCall('IProgress_setNextOperation', array((array)$request));
        return ;
    }

    public function waitForCompletion($arg_timeout)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->timeout = $arg_timeout;
        $response = $this->connection->__soapCall('IProgress_waitForCompletion', array((array)$request));
        return ;
    }

    public function waitForOperationCompletion($arg_operation, $arg_timeout)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->operation = $arg_operation;
        $request->timeout = $arg_timeout;
        $response = $this->connection->__soapCall('IProgress_waitForOperationCompletion', array((array)$request));
        return ;
    }

    public function waitForAsyncProgressCompletion($arg_pProgressAsync)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->pProgressAsync = $arg_pProgressAsync;
        $response = $this->connection->__soapCall('IProgress_waitForAsyncProgressCompletion', array((array)$request));
        return ;
    }

    public function cancel()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_cancel', array((array)$request));
        return ;
    }

    public function getId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getDescription()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getDescription', array((array)$request));
        return (string)$response->returnval;
    }

    public function getInitiator()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getInitiator', array((array)$request));
        return new VBox_ManagedObject ($this->connection, $response->returnval);
    }

    public function getCancelable()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getCancelable', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getPercent()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getPercent', array((array)$request));
        return (float)$response->returnval;
    }

    public function getTimeRemaining()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getTimeRemaining', array((array)$request));
        return (int)$response->returnval;
    }

    public function getCompleted()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getCompleted', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getCanceled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getCanceled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getResultCode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getResultCode', array((array)$request));
        return (int)$response->returnval;
    }

    public function getErrorInfo()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getErrorInfo', array((array)$request));
        return new IVirtualBoxErrorInfo ($this->connection, $response->returnval);
    }

    public function getOperationCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getOperationCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getOperation()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getOperation', array((array)$request));
        return (float)$response->returnval;
    }

    public function getOperationDescription()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getOperationDescription', array((array)$request));
        return (string)$response->returnval;
    }

    public function getOperationPercent()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getOperationPercent', array((array)$request));
        return (float)$response->returnval;
    }

    public function getOperationWeight()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getOperationWeight', array((array)$request));
        return (float)$response->returnval;
    }

    public function getTimeout()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IProgress_getTimeout', array((array)$request));
        return (float)$response->returnval;
    }

    public function setTimeout($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->timeout = $value;
        }
        else
        {
            $request->timeout = $value->handle;
        }
        $this->connection->__soapCall('IProgress_setTimeout', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IProgressCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IProgress";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISnapshot extends VBox_ManagedObject
{

    public function getChildrenCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshot_getChildrenCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshot_getId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshot_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function setName($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->name = $value;
        }
        else
        {
            $request->name = $value->handle;
        }
        $this->connection->__soapCall('ISnapshot_setName', array((array)$request));
    }

    public function getDescription()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshot_getDescription', array((array)$request));
        return (string)$response->returnval;
    }

    public function setDescription($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->description = $value;
        }
        else
        {
            $request->description = $value->handle;
        }
        $this->connection->__soapCall('ISnapshot_setDescription', array((array)$request));
    }

    public function getTimeStamp()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshot_getTimeStamp', array((array)$request));
        return (float)$response->returnval;
    }

    public function getOnline()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshot_getOnline', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getMachine()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshot_getMachine', array((array)$request));
        return new IMachine ($this->connection, $response->returnval);
    }

    public function getParent()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshot_getParent', array((array)$request));
        return new ISnapshot ($this->connection, $response->returnval);
    }

    public function getChildren()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshot_getChildren', array((array)$request));
        return new ISnapshotCollection ($this->connection, (array)$response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISnapshotCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISnapshot";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMedium extends VBox_ManagedObject
{

    public function setIds($arg_setImageId, $arg_imageId, $arg_setParentId, $arg_parentId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->setImageId = $arg_setImageId;
        $request->imageId = $arg_imageId;
        $request->setParentId = $arg_setParentId;
        $request->parentId = $arg_parentId;
        $response = $this->connection->__soapCall('IMedium_setIds', array((array)$request));
        return ;
    }

    public function refreshState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_refreshState', array((array)$request));
        return new MediumState ($this->connection, $response->returnval);
    }

    public function getSnapshotIds($arg_machineId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->machineId = $arg_machineId;
        $response = $this->connection->__soapCall('IMedium_getSnapshotIds', array((array)$request));
        return (array)$response->returnval;
    }

    public function lockRead()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_lockRead', array((array)$request));
        return new MediumState ($this->connection, $response->returnval);
    }

    public function unlockRead()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_unlockRead', array((array)$request));
        return new MediumState ($this->connection, $response->returnval);
    }

    public function lockWrite()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_lockWrite', array((array)$request));
        return new MediumState ($this->connection, $response->returnval);
    }

    public function unlockWrite()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_unlockWrite', array((array)$request));
        return new MediumState ($this->connection, $response->returnval);
    }

    public function close()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_close', array((array)$request));
        return ;
    }

    public function getProperty($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IMedium_getProperty', array((array)$request));
        return (string)$response->returnval;
    }

    public function setProperty($arg_name, $arg_value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->value = $arg_value;
        $response = $this->connection->__soapCall('IMedium_setProperty', array((array)$request));
        return ;
    }

    public function getProperties($arg_names)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->names = $arg_names;
        $response = $this->connection->__soapCall('IMedium_getProperties', array((array)$request));
        return array((array)$response->returnval, (array)$response->returnNames);
    }

    public function setProperties($arg_names, $arg_values)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->names = $arg_names;
        $request->values = $arg_values;
        $response = $this->connection->__soapCall('IMedium_setProperties', array((array)$request));
        return ;
    }

    public function createBaseStorage($arg_logicalSize, $arg_variant)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->logicalSize = $arg_logicalSize;
        $request->variant = $arg_variant;
        $response = $this->connection->__soapCall('IMedium_createBaseStorage', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function deleteStorage()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_deleteStorage', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function createDiffStorage($arg_target, $arg_variant)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->target = $arg_target;
        $request->variant = $arg_variant;
        $response = $this->connection->__soapCall('IMedium_createDiffStorage', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function mergeTo($arg_target)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->target = $arg_target;
        $response = $this->connection->__soapCall('IMedium_mergeTo', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function cloneTo($arg_target, $arg_variant, $arg_parent)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->target = $arg_target;
        $request->variant = $arg_variant;
        $request->parent = $arg_parent;
        $response = $this->connection->__soapCall('IMedium_cloneTo', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function cloneToBase($arg_target, $arg_variant)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->target = $arg_target;
        $request->variant = $arg_variant;
        $response = $this->connection->__soapCall('IMedium_cloneToBase', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function compact()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_compact', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function resize($arg_logicalSize)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->logicalSize = $arg_logicalSize;
        $response = $this->connection->__soapCall('IMedium_resize', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function reset()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_reset', array((array)$request));
        return new IProgress ($this->connection, $response->returnval);
    }

    public function getId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getDescription()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getDescription', array((array)$request));
        return (string)$response->returnval;
    }

    public function setDescription($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->description = $value;
        }
        else
        {
            $request->description = $value->handle;
        }
        $this->connection->__soapCall('IMedium_setDescription', array((array)$request));
    }

    public function getState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getState', array((array)$request));
        return new MediumState ($this->connection, $response->returnval);
    }

    public function getVariant()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getVariant', array((array)$request));
        return (float)$response->returnval;
    }

    public function getLocation()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getLocation', array((array)$request));
        return (string)$response->returnval;
    }

    public function setLocation($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->location = $value;
        }
        else
        {
            $request->location = $value->handle;
        }
        $this->connection->__soapCall('IMedium_setLocation', array((array)$request));
    }

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getDeviceType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getDeviceType', array((array)$request));
        return new DeviceType ($this->connection, $response->returnval);
    }

    public function getHostDrive()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getHostDrive', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function getFormat()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getFormat', array((array)$request));
        return (string)$response->returnval;
    }

    public function getMediumFormat()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getMediumFormat', array((array)$request));
        return new IMediumFormat ($this->connection, $response->returnval);
    }

    public function getType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getType', array((array)$request));
        return new MediumType ($this->connection, $response->returnval);
    }

    public function setType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->type = $value;
        }
        else
        {
            $request->type = $value->handle;
        }
        $this->connection->__soapCall('IMedium_setType', array((array)$request));
    }

    public function getAllowedTypes()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getAllowedTypes', array((array)$request));
        return new MediumTypeCollection ($this->connection, (array)$response->returnval);
    }

    public function getParent()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getParent', array((array)$request));
        return new IMedium ($this->connection, $response->returnval);
    }

    public function getChildren()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getChildren', array((array)$request));
        return new IMediumCollection ($this->connection, (array)$response->returnval);
    }

    public function getBase()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getBase', array((array)$request));
        return new IMedium ($this->connection, $response->returnval);
    }

    public function getReadOnly()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getReadOnly', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getLogicalSize()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getLogicalSize', array((array)$request));
        return (float)$response->returnval;
    }

    public function getAutoReset()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getAutoReset', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setAutoReset($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->autoReset = $value;
        }
        else
        {
            $request->autoReset = $value->handle;
        }
        $this->connection->__soapCall('IMedium_setAutoReset', array((array)$request));
    }

    public function getLastAccessError()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getLastAccessError', array((array)$request));
        return (string)$response->returnval;
    }

    public function getMachineIds()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMedium_getMachineIds', array((array)$request));
        return (array)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMediumCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMedium";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMediumFormat extends VBox_ManagedObject
{

    public function describeFileExtensions()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMediumFormat_describeFileExtensions', array((array)$request));
        return array((array)$response->extensions, new DeviceTypeCollection ($this->connection, (array)$response->type));
    }

    public function describeProperties()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMediumFormat_describeProperties', array((array)$request));
        return array((array)$response->names, (array)$response->description, new DataTypeCollection ($this->connection, (array)$response->types), (array)$response->flags, (array)$response->defaults);
    }

    public function getId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMediumFormat_getId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMediumFormat_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getCapabilities()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMediumFormat_getCapabilities', array((array)$request));
        return (float)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMediumFormatCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMediumFormat";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IKeyboard extends VBox_ManagedObject
{

    public function putScancode($arg_scancode)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->scancode = $arg_scancode;
        $response = $this->connection->__soapCall('IKeyboard_putScancode', array((array)$request));
        return ;
    }

    public function putScancodes($arg_scancodes)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->scancodes = $arg_scancodes;
        $response = $this->connection->__soapCall('IKeyboard_putScancodes', array((array)$request));
        return (float)$response->returnval;
    }

    public function putCAD()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IKeyboard_putCAD', array((array)$request));
        return ;
    }

    public function getEventSource()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IKeyboard_getEventSource', array((array)$request));
        return new IEventSource ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IKeyboardCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IKeyboard";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMouse extends VBox_ManagedObject
{

    public function putMouseEvent($arg_dx, $arg_dy, $arg_dz, $arg_dw, $arg_buttonState)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->dx = $arg_dx;
        $request->dy = $arg_dy;
        $request->dz = $arg_dz;
        $request->dw = $arg_dw;
        $request->buttonState = $arg_buttonState;
        $response = $this->connection->__soapCall('IMouse_putMouseEvent', array((array)$request));
        return ;
    }

    public function putMouseEventAbsolute($arg_x, $arg_y, $arg_dz, $arg_dw, $arg_buttonState)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->x = $arg_x;
        $request->y = $arg_y;
        $request->dz = $arg_dz;
        $request->dw = $arg_dw;
        $request->buttonState = $arg_buttonState;
        $response = $this->connection->__soapCall('IMouse_putMouseEventAbsolute', array((array)$request));
        return ;
    }

    public function getAbsoluteSupported()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMouse_getAbsoluteSupported', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getRelativeSupported()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMouse_getRelativeSupported', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getNeedsHostCursor()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMouse_getNeedsHostCursor', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getEventSource()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMouse_getEventSource', array((array)$request));
        return new IEventSource ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMouseCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMouse";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IDisplay extends VBox_ManagedObject
{

    public function getScreenResolution($arg_screenId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $response = $this->connection->__soapCall('IDisplay_getScreenResolution', array((array)$request));
        return array((float)$response->width, (float)$response->height, (float)$response->bitsPerPixel);
    }

    public function setVideoModeHint($arg_display, $arg_enabled, $arg_changeOrigin, $arg_originX, $arg_originY, $arg_width, $arg_height, $arg_bitsPerPixel)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->display = $arg_display;
        $request->enabled = $arg_enabled;
        $request->changeOrigin = $arg_changeOrigin;
        $request->originX = $arg_originX;
        $request->originY = $arg_originY;
        $request->width = $arg_width;
        $request->height = $arg_height;
        $request->bitsPerPixel = $arg_bitsPerPixel;
        $response = $this->connection->__soapCall('IDisplay_setVideoModeHint', array((array)$request));
        return ;
    }

    public function setSeamlessMode($arg_enabled)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->enabled = $arg_enabled;
        $response = $this->connection->__soapCall('IDisplay_setSeamlessMode', array((array)$request));
        return ;
    }

    public function takeScreenShotToArray($arg_screenId, $arg_width, $arg_height)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $request->width = $arg_width;
        $request->height = $arg_height;
        $response = $this->connection->__soapCall('IDisplay_takeScreenShotToArray', array((array)$request));
        return (array)$response->returnval;
    }

    public function takeScreenShotPNGToArray($arg_screenId, $arg_width, $arg_height)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $request->width = $arg_width;
        $request->height = $arg_height;
        $response = $this->connection->__soapCall('IDisplay_takeScreenShotPNGToArray', array((array)$request));
        return (array)$response->returnval;
    }

    public function invalidateAndUpdate()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDisplay_invalidateAndUpdate', array((array)$request));
        return ;
    }

    public function resizeCompleted($arg_screenId)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $response = $this->connection->__soapCall('IDisplay_resizeCompleted', array((array)$request));
        return ;
    }

    public function viewportChanged($arg_screenId, $arg_x, $arg_y, $arg_width, $arg_height)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->screenId = $arg_screenId;
        $request->x = $arg_x;
        $request->y = $arg_y;
        $request->width = $arg_width;
        $request->height = $arg_height;
        $response = $this->connection->__soapCall('IDisplay_viewportChanged', array((array)$request));
        return ;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IDisplayCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IDisplay";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class INetworkAdapter extends VBox_ManagedObject
{

    public function getProperty($arg_key)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->key = $arg_key;
        $response = $this->connection->__soapCall('INetworkAdapter_getProperty', array((array)$request));
        return (string)$response->returnval;
    }

    public function setProperty($arg_key, $arg_value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->key = $arg_key;
        $request->value = $arg_value;
        $response = $this->connection->__soapCall('INetworkAdapter_setProperty', array((array)$request));
        return ;
    }

    public function getProperties($arg_names)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->names = $arg_names;
        $response = $this->connection->__soapCall('INetworkAdapter_getProperties', array((array)$request));
        return array((array)$response->returnval, (array)$response->returnNames);
    }

    public function getAdapterType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getAdapterType', array((array)$request));
        return new NetworkAdapterType ($this->connection, $response->returnval);
    }

    public function setAdapterType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->adapterType = $value;
        }
        else
        {
            $request->adapterType = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setAdapterType', array((array)$request));
    }

    public function getSlot()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getSlot', array((array)$request));
        return (float)$response->returnval;
    }

    public function getEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->enabled = $value;
        }
        else
        {
            $request->enabled = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setEnabled', array((array)$request));
    }

    public function getMACAddress()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getMACAddress', array((array)$request));
        return (string)$response->returnval;
    }

    public function setMACAddress($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->MACAddress = $value;
        }
        else
        {
            $request->MACAddress = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setMACAddress', array((array)$request));
    }

    public function getAttachmentType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getAttachmentType', array((array)$request));
        return new NetworkAttachmentType ($this->connection, $response->returnval);
    }

    public function setAttachmentType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->attachmentType = $value;
        }
        else
        {
            $request->attachmentType = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setAttachmentType', array((array)$request));
    }

    public function getBridgedInterface()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getBridgedInterface', array((array)$request));
        return (string)$response->returnval;
    }

    public function setBridgedInterface($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->bridgedInterface = $value;
        }
        else
        {
            $request->bridgedInterface = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setBridgedInterface', array((array)$request));
    }

    public function getHostOnlyInterface()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getHostOnlyInterface', array((array)$request));
        return (string)$response->returnval;
    }

    public function setHostOnlyInterface($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->hostOnlyInterface = $value;
        }
        else
        {
            $request->hostOnlyInterface = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setHostOnlyInterface', array((array)$request));
    }

    public function getInternalNetwork()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getInternalNetwork', array((array)$request));
        return (string)$response->returnval;
    }

    public function setInternalNetwork($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->internalNetwork = $value;
        }
        else
        {
            $request->internalNetwork = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setInternalNetwork', array((array)$request));
    }

    public function getNATNetwork()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getNATNetwork', array((array)$request));
        return (string)$response->returnval;
    }

    public function setNATNetwork($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->NATNetwork = $value;
        }
        else
        {
            $request->NATNetwork = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setNATNetwork', array((array)$request));
    }

    public function getGenericDriver()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getGenericDriver', array((array)$request));
        return (string)$response->returnval;
    }

    public function setGenericDriver($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->genericDriver = $value;
        }
        else
        {
            $request->genericDriver = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setGenericDriver', array((array)$request));
    }

    public function getCableConnected()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getCableConnected', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setCableConnected($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->cableConnected = $value;
        }
        else
        {
            $request->cableConnected = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setCableConnected', array((array)$request));
    }

    public function getLineSpeed()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getLineSpeed', array((array)$request));
        return (float)$response->returnval;
    }

    public function setLineSpeed($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->lineSpeed = $value;
        }
        else
        {
            $request->lineSpeed = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setLineSpeed', array((array)$request));
    }

    public function getPromiscModePolicy()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getPromiscModePolicy', array((array)$request));
        return new NetworkAdapterPromiscModePolicy ($this->connection, $response->returnval);
    }

    public function setPromiscModePolicy($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->promiscModePolicy = $value;
        }
        else
        {
            $request->promiscModePolicy = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setPromiscModePolicy', array((array)$request));
    }

    public function getTraceEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getTraceEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setTraceEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->traceEnabled = $value;
        }
        else
        {
            $request->traceEnabled = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setTraceEnabled', array((array)$request));
    }

    public function getTraceFile()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getTraceFile', array((array)$request));
        return (string)$response->returnval;
    }

    public function setTraceFile($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->traceFile = $value;
        }
        else
        {
            $request->traceFile = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setTraceFile', array((array)$request));
    }

    public function getNATEngine()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getNATEngine', array((array)$request));
        return new INATEngine ($this->connection, $response->returnval);
    }

    public function getBootPriority()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getBootPriority', array((array)$request));
        return (float)$response->returnval;
    }

    public function setBootPriority($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->bootPriority = $value;
        }
        else
        {
            $request->bootPriority = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setBootPriority', array((array)$request));
    }

    public function getBandwidthGroup()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapter_getBandwidthGroup', array((array)$request));
        return new IBandwidthGroup ($this->connection, $response->returnval);
    }

    public function setBandwidthGroup($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->bandwidthGroup = $value;
        }
        else
        {
            $request->bandwidthGroup = $value->handle;
        }
        $this->connection->__soapCall('INetworkAdapter_setBandwidthGroup', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class INetworkAdapterCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "INetworkAdapter";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISerialPort extends VBox_ManagedObject
{

    public function getSlot()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISerialPort_getSlot', array((array)$request));
        return (float)$response->returnval;
    }

    public function getEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISerialPort_getEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->enabled = $value;
        }
        else
        {
            $request->enabled = $value->handle;
        }
        $this->connection->__soapCall('ISerialPort_setEnabled', array((array)$request));
    }

    public function getIOBase()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISerialPort_getIOBase', array((array)$request));
        return (float)$response->returnval;
    }

    public function setIOBase($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->IOBase = $value;
        }
        else
        {
            $request->IOBase = $value->handle;
        }
        $this->connection->__soapCall('ISerialPort_setIOBase', array((array)$request));
    }

    public function getIRQ()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISerialPort_getIRQ', array((array)$request));
        return (float)$response->returnval;
    }

    public function setIRQ($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->IRQ = $value;
        }
        else
        {
            $request->IRQ = $value->handle;
        }
        $this->connection->__soapCall('ISerialPort_setIRQ', array((array)$request));
    }

    public function getHostMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISerialPort_getHostMode', array((array)$request));
        return new PortMode ($this->connection, $response->returnval);
    }

    public function setHostMode($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->hostMode = $value;
        }
        else
        {
            $request->hostMode = $value->handle;
        }
        $this->connection->__soapCall('ISerialPort_setHostMode', array((array)$request));
    }

    public function getServer()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISerialPort_getServer', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setServer($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->server = $value;
        }
        else
        {
            $request->server = $value->handle;
        }
        $this->connection->__soapCall('ISerialPort_setServer', array((array)$request));
    }

    public function getPath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISerialPort_getPath', array((array)$request));
        return (string)$response->returnval;
    }

    public function setPath($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->path = $value;
        }
        else
        {
            $request->path = $value->handle;
        }
        $this->connection->__soapCall('ISerialPort_setPath', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISerialPortCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISerialPort";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IParallelPort extends VBox_ManagedObject
{

    public function getSlot()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IParallelPort_getSlot', array((array)$request));
        return (float)$response->returnval;
    }

    public function getEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IParallelPort_getEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->enabled = $value;
        }
        else
        {
            $request->enabled = $value->handle;
        }
        $this->connection->__soapCall('IParallelPort_setEnabled', array((array)$request));
    }

    public function getIOBase()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IParallelPort_getIOBase', array((array)$request));
        return (float)$response->returnval;
    }

    public function setIOBase($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->IOBase = $value;
        }
        else
        {
            $request->IOBase = $value->handle;
        }
        $this->connection->__soapCall('IParallelPort_setIOBase', array((array)$request));
    }

    public function getIRQ()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IParallelPort_getIRQ', array((array)$request));
        return (float)$response->returnval;
    }

    public function setIRQ($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->IRQ = $value;
        }
        else
        {
            $request->IRQ = $value->handle;
        }
        $this->connection->__soapCall('IParallelPort_setIRQ', array((array)$request));
    }

    public function getPath()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IParallelPort_getPath', array((array)$request));
        return (string)$response->returnval;
    }

    public function setPath($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->path = $value;
        }
        else
        {
            $request->path = $value->handle;
        }
        $this->connection->__soapCall('IParallelPort_setPath', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IParallelPortCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IParallelPort";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IUSBController extends VBox_ManagedObject
{

    public function createDeviceFilter($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IUSBController_createDeviceFilter', array((array)$request));
        return new IUSBDeviceFilter ($this->connection, $response->returnval);
    }

    public function insertDeviceFilter($arg_position, $arg_filter)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->position = $arg_position;
        $request->filter = $arg_filter;
        $response = $this->connection->__soapCall('IUSBController_insertDeviceFilter', array((array)$request));
        return ;
    }

    public function removeDeviceFilter($arg_position)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->position = $arg_position;
        $response = $this->connection->__soapCall('IUSBController_removeDeviceFilter', array((array)$request));
        return new IUSBDeviceFilter ($this->connection, $response->returnval);
    }

    public function getEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBController_getEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->enabled = $value;
        }
        else
        {
            $request->enabled = $value->handle;
        }
        $this->connection->__soapCall('IUSBController_setEnabled', array((array)$request));
    }

    public function getEnabledEHCI()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBController_getEnabledEHCI', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEnabledEHCI($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->enabledEHCI = $value;
        }
        else
        {
            $request->enabledEHCI = $value->handle;
        }
        $this->connection->__soapCall('IUSBController_setEnabledEHCI', array((array)$request));
    }

    public function getProxyAvailable()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBController_getProxyAvailable', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getUSBStandard()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBController_getUSBStandard', array((array)$request));
        return (int)$response->returnval;
    }

    public function getDeviceFilters()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBController_getDeviceFilters', array((array)$request));
        return new IUSBDeviceFilterCollection ($this->connection, (array)$response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IUSBControllerCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IUSBController";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IUSBDevice extends VBox_ManagedObject
{

    public function getId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getVendorId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getVendorId', array((array)$request));
        return (int)$response->returnval;
    }

    public function getProductId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getProductId', array((array)$request));
        return (int)$response->returnval;
    }

    public function getRevision()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getRevision', array((array)$request));
        return (int)$response->returnval;
    }

    public function getManufacturer()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getManufacturer', array((array)$request));
        return (string)$response->returnval;
    }

    public function getProduct()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getProduct', array((array)$request));
        return (string)$response->returnval;
    }

    public function getSerialNumber()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getSerialNumber', array((array)$request));
        return (string)$response->returnval;
    }

    public function getAddress()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getAddress', array((array)$request));
        return (string)$response->returnval;
    }

    public function getPort()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getPort', array((array)$request));
        return (int)$response->returnval;
    }

    public function getVersion()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getVersion', array((array)$request));
        return (int)$response->returnval;
    }

    public function getPortVersion()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getPortVersion', array((array)$request));
        return (int)$response->returnval;
    }

    public function getRemote()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDevice_getRemote', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IUSBDeviceCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IUSBDevice";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IUSBDeviceFilter extends VBox_ManagedObject
{

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function setName($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->name = $value;
        }
        else
        {
            $request->name = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setName', array((array)$request));
    }

    public function getActive()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getActive', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setActive($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->active = $value;
        }
        else
        {
            $request->active = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setActive', array((array)$request));
    }

    public function getVendorId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getVendorId', array((array)$request));
        return (string)$response->returnval;
    }

    public function setVendorId($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->vendorId = $value;
        }
        else
        {
            $request->vendorId = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setVendorId', array((array)$request));
    }

    public function getProductId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getProductId', array((array)$request));
        return (string)$response->returnval;
    }

    public function setProductId($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->productId = $value;
        }
        else
        {
            $request->productId = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setProductId', array((array)$request));
    }

    public function getRevision()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getRevision', array((array)$request));
        return (string)$response->returnval;
    }

    public function setRevision($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->revision = $value;
        }
        else
        {
            $request->revision = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setRevision', array((array)$request));
    }

    public function getManufacturer()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getManufacturer', array((array)$request));
        return (string)$response->returnval;
    }

    public function setManufacturer($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->manufacturer = $value;
        }
        else
        {
            $request->manufacturer = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setManufacturer', array((array)$request));
    }

    public function getProduct()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getProduct', array((array)$request));
        return (string)$response->returnval;
    }

    public function setProduct($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->product = $value;
        }
        else
        {
            $request->product = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setProduct', array((array)$request));
    }

    public function getSerialNumber()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getSerialNumber', array((array)$request));
        return (string)$response->returnval;
    }

    public function setSerialNumber($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->serialNumber = $value;
        }
        else
        {
            $request->serialNumber = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setSerialNumber', array((array)$request));
    }

    public function getPort()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getPort', array((array)$request));
        return (string)$response->returnval;
    }

    public function setPort($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->port = $value;
        }
        else
        {
            $request->port = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setPort', array((array)$request));
    }

    public function getRemote()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getRemote', array((array)$request));
        return (string)$response->returnval;
    }

    public function setRemote($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->remote = $value;
        }
        else
        {
            $request->remote = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setRemote', array((array)$request));
    }

    public function getMaskedInterfaces()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceFilter_getMaskedInterfaces', array((array)$request));
        return (float)$response->returnval;
    }

    public function setMaskedInterfaces($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->maskedInterfaces = $value;
        }
        else
        {
            $request->maskedInterfaces = $value->handle;
        }
        $this->connection->__soapCall('IUSBDeviceFilter_setMaskedInterfaces', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IUSBDeviceFilterCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IUSBDeviceFilter";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IHostUSBDevice extends IUSBDevice
{

    public function getState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostUSBDevice_getState', array((array)$request));
        return new USBDeviceState ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IHostUSBDeviceCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IHostUSBDevice";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IHostUSBDeviceFilter extends IUSBDeviceFilter
{

    public function getAction()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostUSBDeviceFilter_getAction', array((array)$request));
        return new USBDeviceFilterAction ($this->connection, $response->returnval);
    }

    public function setAction($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->action = $value;
        }
        else
        {
            $request->action = $value->handle;
        }
        $this->connection->__soapCall('IHostUSBDeviceFilter_setAction', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IHostUSBDeviceFilterCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IHostUSBDeviceFilter";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IAudioAdapter extends VBox_ManagedObject
{

    public function getEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IAudioAdapter_getEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->enabled = $value;
        }
        else
        {
            $request->enabled = $value->handle;
        }
        $this->connection->__soapCall('IAudioAdapter_setEnabled', array((array)$request));
    }

    public function getAudioController()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IAudioAdapter_getAudioController', array((array)$request));
        return new AudioControllerType ($this->connection, $response->returnval);
    }

    public function setAudioController($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->audioController = $value;
        }
        else
        {
            $request->audioController = $value->handle;
        }
        $this->connection->__soapCall('IAudioAdapter_setAudioController', array((array)$request));
    }

    public function getAudioDriver()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IAudioAdapter_getAudioDriver', array((array)$request));
        return new AudioDriverType ($this->connection, $response->returnval);
    }

    public function setAudioDriver($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->audioDriver = $value;
        }
        else
        {
            $request->audioDriver = $value->handle;
        }
        $this->connection->__soapCall('IAudioAdapter_setAudioDriver', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IAudioAdapterCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IAudioAdapter";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IVRDEServer extends VBox_ManagedObject
{

    public function setVRDEProperty($arg_key, $arg_value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->key = $arg_key;
        $request->value = $arg_value;
        $response = $this->connection->__soapCall('IVRDEServer_setVRDEProperty', array((array)$request));
        return ;
    }

    public function getVRDEProperty($arg_key)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->key = $arg_key;
        $response = $this->connection->__soapCall('IVRDEServer_getVRDEProperty', array((array)$request));
        return (string)$response->returnval;
    }

    public function getEnabled()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVRDEServer_getEnabled', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setEnabled($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->enabled = $value;
        }
        else
        {
            $request->enabled = $value->handle;
        }
        $this->connection->__soapCall('IVRDEServer_setEnabled', array((array)$request));
    }

    public function getAuthType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVRDEServer_getAuthType', array((array)$request));
        return new AuthType ($this->connection, $response->returnval);
    }

    public function setAuthType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->authType = $value;
        }
        else
        {
            $request->authType = $value->handle;
        }
        $this->connection->__soapCall('IVRDEServer_setAuthType', array((array)$request));
    }

    public function getAuthTimeout()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVRDEServer_getAuthTimeout', array((array)$request));
        return (float)$response->returnval;
    }

    public function setAuthTimeout($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->authTimeout = $value;
        }
        else
        {
            $request->authTimeout = $value->handle;
        }
        $this->connection->__soapCall('IVRDEServer_setAuthTimeout', array((array)$request));
    }

    public function getAllowMultiConnection()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVRDEServer_getAllowMultiConnection', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setAllowMultiConnection($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->allowMultiConnection = $value;
        }
        else
        {
            $request->allowMultiConnection = $value->handle;
        }
        $this->connection->__soapCall('IVRDEServer_setAllowMultiConnection', array((array)$request));
    }

    public function getReuseSingleConnection()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVRDEServer_getReuseSingleConnection', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setReuseSingleConnection($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->reuseSingleConnection = $value;
        }
        else
        {
            $request->reuseSingleConnection = $value->handle;
        }
        $this->connection->__soapCall('IVRDEServer_setReuseSingleConnection', array((array)$request));
    }

    public function getVRDEExtPack()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVRDEServer_getVRDEExtPack', array((array)$request));
        return (string)$response->returnval;
    }

    public function setVRDEExtPack($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->VRDEExtPack = $value;
        }
        else
        {
            $request->VRDEExtPack = $value->handle;
        }
        $this->connection->__soapCall('IVRDEServer_setVRDEExtPack', array((array)$request));
    }

    public function getAuthLibrary()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVRDEServer_getAuthLibrary', array((array)$request));
        return (string)$response->returnval;
    }

    public function setAuthLibrary($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->authLibrary = $value;
        }
        else
        {
            $request->authLibrary = $value->handle;
        }
        $this->connection->__soapCall('IVRDEServer_setAuthLibrary', array((array)$request));
    }

    public function getVRDEProperties()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVRDEServer_getVRDEProperties', array((array)$request));
        return (array)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IVRDEServerCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IVRDEServer";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISession extends VBox_ManagedObject
{

    public function unlockMachine()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISession_unlockMachine', array((array)$request));
        return ;
    }

    public function getState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISession_getState', array((array)$request));
        return new SessionState ($this->connection, $response->returnval);
    }

    public function getType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISession_getType', array((array)$request));
        return new SessionType ($this->connection, $response->returnval);
    }

    public function getMachine()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISession_getMachine', array((array)$request));
        return new IMachine ($this->connection, $response->returnval);
    }

    public function getConsole()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISession_getConsole', array((array)$request));
        return new IConsole ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISessionCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISession";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IStorageController extends VBox_ManagedObject
{

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getMaxDevicesPerPortCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getMaxDevicesPerPortCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMinPortCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getMinPortCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxPortCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getMaxPortCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getInstance()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getInstance', array((array)$request));
        return (float)$response->returnval;
    }

    public function setInstance($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->instance = $value;
        }
        else
        {
            $request->instance = $value->handle;
        }
        $this->connection->__soapCall('IStorageController_setInstance', array((array)$request));
    }

    public function getPortCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getPortCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function setPortCount($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->portCount = $value;
        }
        else
        {
            $request->portCount = $value->handle;
        }
        $this->connection->__soapCall('IStorageController_setPortCount', array((array)$request));
    }

    public function getBus()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getBus', array((array)$request));
        return new StorageBus ($this->connection, $response->returnval);
    }

    public function getControllerType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getControllerType', array((array)$request));
        return new StorageControllerType ($this->connection, $response->returnval);
    }

    public function setControllerType($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->controllerType = $value;
        }
        else
        {
            $request->controllerType = $value->handle;
        }
        $this->connection->__soapCall('IStorageController_setControllerType', array((array)$request));
    }

    public function getUseHostIOCache()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getUseHostIOCache', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setUseHostIOCache($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->useHostIOCache = $value;
        }
        else
        {
            $request->useHostIOCache = $value->handle;
        }
        $this->connection->__soapCall('IStorageController_setUseHostIOCache', array((array)$request));
    }

    public function getBootable()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageController_getBootable', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IStorageControllerCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IStorageController";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IManagedObjectRef extends VBox_ManagedObject
{

    public function getInterfaceName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IManagedObjectRef_getInterfaceName', array((array)$request));
        return (string)$response->returnval;
    }

    public function release()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IManagedObjectRef_release', array((array)$request));
        return ;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IManagedObjectRefCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IManagedObjectRef";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IWebsessionManager extends VBox_ManagedObject
{

    public function logon($arg_username, $arg_password)
    {
        $request = new stdClass();

        $request->username = $arg_username;
        $request->password = $arg_password;
        $response = $this->connection->__soapCall('IWebsessionManager_logon', array((array)$request));
        return new IVirtualBox ($this->connection, $response->returnval);
    }

    public function getSessionObject($arg_refIVirtualBox)
    {
        $request = new stdClass();

        $request->refIVirtualBox = $arg_refIVirtualBox;
        $response = $this->connection->__soapCall('IWebsessionManager_getSessionObject', array((array)$request));
        return new ISession ($this->connection, $response->returnval);
    }

    public function logoff($arg_refIVirtualBox)
    {
        $request = new stdClass();

        $request->refIVirtualBox = $arg_refIVirtualBox;
        $response = $this->connection->__soapCall('IWebsessionManager_logoff', array((array)$request));
        return ;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IWebsessionManagerCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IWebsessionManager";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IPerformanceMetric extends VBox_ManagedObject
{

    public function getMetricName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IPerformanceMetric_getMetricName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getObject()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IPerformanceMetric_getObject', array((array)$request));
        return new VBox_ManagedObject ($this->connection, $response->returnval);
    }

    public function getDescription()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IPerformanceMetric_getDescription', array((array)$request));
        return (string)$response->returnval;
    }

    public function getPeriod()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IPerformanceMetric_getPeriod', array((array)$request));
        return (float)$response->returnval;
    }

    public function getCount()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IPerformanceMetric_getCount', array((array)$request));
        return (float)$response->returnval;
    }

    public function getUnit()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IPerformanceMetric_getUnit', array((array)$request));
        return (string)$response->returnval;
    }

    public function getMinimumValue()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IPerformanceMetric_getMinimumValue', array((array)$request));
        return (int)$response->returnval;
    }

    public function getMaximumValue()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IPerformanceMetric_getMaximumValue', array((array)$request));
        return (int)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IPerformanceMetricCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IPerformanceMetric";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IPerformanceCollector extends VBox_ManagedObject
{

    public function getMetrics($arg_metricNames, $arg_objects)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->metricNames = $arg_metricNames;
        $request->objects = $arg_objects;
        $response = $this->connection->__soapCall('IPerformanceCollector_getMetrics', array((array)$request));
        return new IPerformanceMetricCollection ($this->connection, (array)$response->returnval);
    }

    public function setupMetrics($arg_metricNames, $arg_objects, $arg_period, $arg_count)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->metricNames = $arg_metricNames;
        $request->objects = $arg_objects;
        $request->period = $arg_period;
        $request->count = $arg_count;
        $response = $this->connection->__soapCall('IPerformanceCollector_setupMetrics', array((array)$request));
        return new IPerformanceMetricCollection ($this->connection, (array)$response->returnval);
    }

    public function enableMetrics($arg_metricNames, $arg_objects)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->metricNames = $arg_metricNames;
        $request->objects = $arg_objects;
        $response = $this->connection->__soapCall('IPerformanceCollector_enableMetrics', array((array)$request));
        return new IPerformanceMetricCollection ($this->connection, (array)$response->returnval);
    }

    public function disableMetrics($arg_metricNames, $arg_objects)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->metricNames = $arg_metricNames;
        $request->objects = $arg_objects;
        $response = $this->connection->__soapCall('IPerformanceCollector_disableMetrics', array((array)$request));
        return new IPerformanceMetricCollection ($this->connection, (array)$response->returnval);
    }

    public function queryMetricsData($arg_metricNames, $arg_objects)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->metricNames = $arg_metricNames;
        $request->objects = $arg_objects;
        $response = $this->connection->__soapCall('IPerformanceCollector_queryMetricsData', array((array)$request));
        return array((array)$response->returnval, (array)$response->returnMetricNames, new VBox_ManagedObjectCollection ($this->connection, (array)$response->returnObjects), (array)$response->returnUnits, (array)$response->returnScales, (array)$response->returnSequenceNumbers, (array)$response->returnDataIndices, (array)$response->returnDataLengths);
    }

    public function getMetricNames()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IPerformanceCollector_getMetricNames', array((array)$request));
        return (array)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IPerformanceCollectorCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IPerformanceCollector";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class INATEngine extends VBox_ManagedObject
{

    public function setNetworkSettings($arg_mtu, $arg_sockSnd, $arg_sockRcv, $arg_TcpWndSnd, $arg_TcpWndRcv)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->mtu = $arg_mtu;
        $request->sockSnd = $arg_sockSnd;
        $request->sockRcv = $arg_sockRcv;
        $request->TcpWndSnd = $arg_TcpWndSnd;
        $request->TcpWndRcv = $arg_TcpWndRcv;
        $response = $this->connection->__soapCall('INATEngine_setNetworkSettings', array((array)$request));
        return ;
    }

    public function getNetworkSettings()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getNetworkSettings', array((array)$request));
        return array((float)$response->mtu, (float)$response->sockSnd, (float)$response->sockRcv, (float)$response->TcpWndSnd, (float)$response->TcpWndRcv);
    }

    public function addRedirect($arg_name, $arg_proto, $arg_hostIP, $arg_hostPort, $arg_guestIP, $arg_guestPort)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->proto = $arg_proto;
        $request->hostIP = $arg_hostIP;
        $request->hostPort = $arg_hostPort;
        $request->guestIP = $arg_guestIP;
        $request->guestPort = $arg_guestPort;
        $response = $this->connection->__soapCall('INATEngine_addRedirect', array((array)$request));
        return ;
    }

    public function removeRedirect($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('INATEngine_removeRedirect', array((array)$request));
        return ;
    }

    public function getNetwork()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getNetwork', array((array)$request));
        return (string)$response->returnval;
    }

    public function setNetwork($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->network = $value;
        }
        else
        {
            $request->network = $value->handle;
        }
        $this->connection->__soapCall('INATEngine_setNetwork', array((array)$request));
    }

    public function getHostIP()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getHostIP', array((array)$request));
        return (string)$response->returnval;
    }

    public function setHostIP($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->hostIP = $value;
        }
        else
        {
            $request->hostIP = $value->handle;
        }
        $this->connection->__soapCall('INATEngine_setHostIP', array((array)$request));
    }

    public function getTFTPPrefix()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getTFTPPrefix', array((array)$request));
        return (string)$response->returnval;
    }

    public function setTFTPPrefix($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->TFTPPrefix = $value;
        }
        else
        {
            $request->TFTPPrefix = $value->handle;
        }
        $this->connection->__soapCall('INATEngine_setTFTPPrefix', array((array)$request));
    }

    public function getTFTPBootFile()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getTFTPBootFile', array((array)$request));
        return (string)$response->returnval;
    }

    public function setTFTPBootFile($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->TFTPBootFile = $value;
        }
        else
        {
            $request->TFTPBootFile = $value->handle;
        }
        $this->connection->__soapCall('INATEngine_setTFTPBootFile', array((array)$request));
    }

    public function getTFTPNextServer()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getTFTPNextServer', array((array)$request));
        return (string)$response->returnval;
    }

    public function setTFTPNextServer($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->TFTPNextServer = $value;
        }
        else
        {
            $request->TFTPNextServer = $value->handle;
        }
        $this->connection->__soapCall('INATEngine_setTFTPNextServer', array((array)$request));
    }

    public function getAliasMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getAliasMode', array((array)$request));
        return (float)$response->returnval;
    }

    public function setAliasMode($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->aliasMode = $value;
        }
        else
        {
            $request->aliasMode = $value->handle;
        }
        $this->connection->__soapCall('INATEngine_setAliasMode', array((array)$request));
    }

    public function getDNSPassDomain()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getDNSPassDomain', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setDNSPassDomain($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->DNSPassDomain = $value;
        }
        else
        {
            $request->DNSPassDomain = $value->handle;
        }
        $this->connection->__soapCall('INATEngine_setDNSPassDomain', array((array)$request));
    }

    public function getDNSProxy()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getDNSProxy', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setDNSProxy($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->DNSProxy = $value;
        }
        else
        {
            $request->DNSProxy = $value->handle;
        }
        $this->connection->__soapCall('INATEngine_setDNSProxy', array((array)$request));
    }

    public function getDNSUseHostResolver()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getDNSUseHostResolver', array((array)$request));
        return (bool)$response->returnval;
    }

    public function setDNSUseHostResolver($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->DNSUseHostResolver = $value;
        }
        else
        {
            $request->DNSUseHostResolver = $value->handle;
        }
        $this->connection->__soapCall('INATEngine_setDNSUseHostResolver', array((array)$request));
    }

    public function getRedirects()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATEngine_getRedirects', array((array)$request));
        return (array)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class INATEngineCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "INATEngine";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IBandwidthGroup extends VBox_ManagedObject
{

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBandwidthGroup_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBandwidthGroup_getType', array((array)$request));
        return new BandwidthGroupType ($this->connection, $response->returnval);
    }

    public function getReference()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBandwidthGroup_getReference', array((array)$request));
        return (float)$response->returnval;
    }

    public function getMaxBytesPerSec()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBandwidthGroup_getMaxBytesPerSec', array((array)$request));
        return (float)$response->returnval;
    }

    public function setMaxBytesPerSec($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->maxBytesPerSec = $value;
        }
        else
        {
            $request->maxBytesPerSec = $value->handle;
        }
        $this->connection->__soapCall('IBandwidthGroup_setMaxBytesPerSec', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IBandwidthGroupCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IBandwidthGroup";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IBandwidthControl extends VBox_ManagedObject
{

    public function createBandwidthGroup($arg_name, $arg_type, $arg_maxBytesPerSec)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $request->type = $arg_type;
        $request->maxBytesPerSec = $arg_maxBytesPerSec;
        $response = $this->connection->__soapCall('IBandwidthControl_createBandwidthGroup', array((array)$request));
        return ;
    }

    public function deleteBandwidthGroup($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IBandwidthControl_deleteBandwidthGroup', array((array)$request));
        return ;
    }

    public function getBandwidthGroup($arg_name)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->name = $arg_name;
        $response = $this->connection->__soapCall('IBandwidthControl_getBandwidthGroup', array((array)$request));
        return new IBandwidthGroup ($this->connection, $response->returnval);
    }

    public function getAllBandwidthGroups()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBandwidthControl_getAllBandwidthGroups', array((array)$request));
        return new IBandwidthGroupCollection ($this->connection, (array)$response->returnval);
    }

    public function getNumGroups()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBandwidthControl_getNumGroups', array((array)$request));
        return (float)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IBandwidthControlCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IBandwidthControl";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IEventSource extends VBox_ManagedObject
{

    public function createListener()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IEventSource_createListener', array((array)$request));
        return new IEventListener ($this->connection, $response->returnval);
    }

    public function createAggregator($arg_subordinates)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->subordinates = $arg_subordinates;
        $response = $this->connection->__soapCall('IEventSource_createAggregator', array((array)$request));
        return new IEventSource ($this->connection, $response->returnval);
    }

    public function registerListener($arg_listener, $arg_interesting, $arg_active)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->listener = $arg_listener;
        $request->interesting = $arg_interesting;
        $request->active = $arg_active;
        $response = $this->connection->__soapCall('IEventSource_registerListener', array((array)$request));
        return ;
    }

    public function unregisterListener($arg_listener)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->listener = $arg_listener;
        $response = $this->connection->__soapCall('IEventSource_unregisterListener', array((array)$request));
        return ;
    }

    public function fireEvent($arg_event, $arg_timeout)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->event = $arg_event;
        $request->timeout = $arg_timeout;
        $response = $this->connection->__soapCall('IEventSource_fireEvent', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getEvent($arg_listener, $arg_timeout)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->listener = $arg_listener;
        $request->timeout = $arg_timeout;
        $response = $this->connection->__soapCall('IEventSource_getEvent', array((array)$request));
        return new IEvent ($this->connection, $response->returnval);
    }

    public function eventProcessed($arg_listener, $arg_event)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->listener = $arg_listener;
        $request->event = $arg_event;
        $response = $this->connection->__soapCall('IEventSource_eventProcessed', array((array)$request));
        return ;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IEventSourceCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IEventSource";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IEventListener extends VBox_ManagedObject
{

    public function handleEvent($arg_event)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->event = $arg_event;
        $response = $this->connection->__soapCall('IEventListener_handleEvent', array((array)$request));
        return ;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IEventListenerCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IEventListener";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IEvent extends VBox_ManagedObject
{

    public function setProcessed()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IEvent_setProcessed', array((array)$request));
        return ;
    }

    public function waitProcessed($arg_timeout)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->timeout = $arg_timeout;
        $response = $this->connection->__soapCall('IEvent_waitProcessed', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IEvent_getType', array((array)$request));
        return new VBoxEventType ($this->connection, $response->returnval);
    }

    public function getSource()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IEvent_getSource', array((array)$request));
        return new IEventSource ($this->connection, $response->returnval);
    }

    public function getWaitable()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IEvent_getWaitable', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IReusableEvent extends IEvent
{

    public function reuse()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IReusableEvent_reuse', array((array)$request));
        return ;
    }

    public function getGeneration()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IReusableEvent_getGeneration', array((array)$request));
        return (float)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IReusableEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IReusableEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMachineEvent extends IEvent
{

    public function getMachineId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachineEvent_getMachineId', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMachineEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMachineEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMachineStateChangedEvent extends IMachineEvent
{

    public function getState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachineStateChangedEvent_getState', array((array)$request));
        return new MachineState ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMachineStateChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMachineStateChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMachineDataChangedEvent extends IMachineEvent
{

    public function getTemporary()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachineDataChangedEvent_getTemporary', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMachineDataChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMachineDataChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMediumRegisteredEvent extends IEvent
{

    public function getMediumId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMediumRegisteredEvent_getMediumId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getMediumType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMediumRegisteredEvent_getMediumType', array((array)$request));
        return new DeviceType ($this->connection, $response->returnval);
    }

    public function getRegistered()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMediumRegisteredEvent_getRegistered', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMediumRegisteredEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMediumRegisteredEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMachineRegisteredEvent extends IMachineEvent
{

    public function getRegistered()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMachineRegisteredEvent_getRegistered', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMachineRegisteredEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMachineRegisteredEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISessionStateChangedEvent extends IMachineEvent
{

    public function getState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISessionStateChangedEvent_getState', array((array)$request));
        return new SessionState ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISessionStateChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISessionStateChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuestPropertyChangedEvent extends IMachineEvent
{

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestPropertyChangedEvent_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getValue()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestPropertyChangedEvent_getValue', array((array)$request));
        return (string)$response->returnval;
    }

    public function getFlags()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestPropertyChangedEvent_getFlags', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestPropertyChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuestPropertyChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISnapshotEvent extends IMachineEvent
{

    public function getSnapshotId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISnapshotEvent_getSnapshotId', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISnapshotEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISnapshotEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISnapshotTakenEvent extends ISnapshotEvent
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISnapshotTakenEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISnapshotTakenEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISnapshotDeletedEvent extends ISnapshotEvent
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISnapshotDeletedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISnapshotDeletedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISnapshotChangedEvent extends ISnapshotEvent
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISnapshotChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISnapshotChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMousePointerShapeChangedEvent extends IEvent
{

    public function getVisible()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMousePointerShapeChangedEvent_getVisible', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getAlpha()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMousePointerShapeChangedEvent_getAlpha', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getXhot()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMousePointerShapeChangedEvent_getXhot', array((array)$request));
        return (float)$response->returnval;
    }

    public function getYhot()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMousePointerShapeChangedEvent_getYhot', array((array)$request));
        return (float)$response->returnval;
    }

    public function getWidth()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMousePointerShapeChangedEvent_getWidth', array((array)$request));
        return (float)$response->returnval;
    }

    public function getHeight()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMousePointerShapeChangedEvent_getHeight', array((array)$request));
        return (float)$response->returnval;
    }

    public function getShape()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMousePointerShapeChangedEvent_getShape', array((array)$request));
        return (array)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMousePointerShapeChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMousePointerShapeChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMouseCapabilityChangedEvent extends IEvent
{

    public function getSupportsAbsolute()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMouseCapabilityChangedEvent_getSupportsAbsolute', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getSupportsRelative()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMouseCapabilityChangedEvent_getSupportsRelative', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getNeedsHostCursor()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMouseCapabilityChangedEvent_getNeedsHostCursor', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMouseCapabilityChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMouseCapabilityChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IKeyboardLedsChangedEvent extends IEvent
{

    public function getNumLock()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IKeyboardLedsChangedEvent_getNumLock', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getCapsLock()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IKeyboardLedsChangedEvent_getCapsLock', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getScrollLock()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IKeyboardLedsChangedEvent_getScrollLock', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IKeyboardLedsChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IKeyboardLedsChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IStateChangedEvent extends IEvent
{

    public function getState()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStateChangedEvent_getState', array((array)$request));
        return new MachineState ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IStateChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IStateChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IAdditionsStateChangedEvent extends IEvent
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IAdditionsStateChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IAdditionsStateChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class INetworkAdapterChangedEvent extends IEvent
{

    public function getNetworkAdapter()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INetworkAdapterChangedEvent_getNetworkAdapter', array((array)$request));
        return new INetworkAdapter ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class INetworkAdapterChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "INetworkAdapterChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISerialPortChangedEvent extends IEvent
{

    public function getSerialPort()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISerialPortChangedEvent_getSerialPort', array((array)$request));
        return new ISerialPort ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISerialPortChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISerialPortChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IParallelPortChangedEvent extends IEvent
{

    public function getParallelPort()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IParallelPortChangedEvent_getParallelPort', array((array)$request));
        return new IParallelPort ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IParallelPortChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IParallelPortChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IStorageControllerChangedEvent extends IEvent
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IStorageControllerChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IStorageControllerChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IMediumChangedEvent extends IEvent
{

    public function getMediumAttachment()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IMediumChangedEvent_getMediumAttachment', array((array)$request));
        return new IMediumAttachment ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IMediumChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IMediumChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IClipboardModeChangedEvent extends IEvent
{

    public function getClipboardMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IClipboardModeChangedEvent_getClipboardMode', array((array)$request));
        return new ClipboardMode ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IClipboardModeChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IClipboardModeChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IDragAndDropModeChangedEvent extends IEvent
{

    public function getDragAndDropMode()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IDragAndDropModeChangedEvent_getDragAndDropMode', array((array)$request));
        return new DragAndDropMode ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IDragAndDropModeChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IDragAndDropModeChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ICPUChangedEvent extends IEvent
{

    public function getCPU()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ICPUChangedEvent_getCPU', array((array)$request));
        return (float)$response->returnval;
    }

    public function getAdd()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ICPUChangedEvent_getAdd', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ICPUChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ICPUChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ICPUExecutionCapChangedEvent extends IEvent
{

    public function getExecutionCap()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ICPUExecutionCapChangedEvent_getExecutionCap', array((array)$request));
        return (float)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ICPUExecutionCapChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ICPUExecutionCapChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuestKeyboardEvent extends IEvent
{

    public function getScancodes()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestKeyboardEvent_getScancodes', array((array)$request));
        return (array)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestKeyboardEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuestKeyboardEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuestMouseEvent extends IReusableEvent
{

    public function getAbsolute()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMouseEvent_getAbsolute', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getX()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMouseEvent_getX', array((array)$request));
        return (int)$response->returnval;
    }

    public function getY()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMouseEvent_getY', array((array)$request));
        return (int)$response->returnval;
    }

    public function getZ()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMouseEvent_getZ', array((array)$request));
        return (int)$response->returnval;
    }

    public function getW()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMouseEvent_getW', array((array)$request));
        return (int)$response->returnval;
    }

    public function getButtons()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMouseEvent_getButtons', array((array)$request));
        return (int)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestMouseEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuestMouseEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IVRDEServerChangedEvent extends IEvent
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IVRDEServerChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IVRDEServerChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IVRDEServerInfoChangedEvent extends IEvent
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IVRDEServerInfoChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IVRDEServerInfoChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IUSBControllerChangedEvent extends IEvent
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IUSBControllerChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IUSBControllerChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IUSBDeviceStateChangedEvent extends IEvent
{

    public function getDevice()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceStateChangedEvent_getDevice', array((array)$request));
        return new IUSBDevice ($this->connection, $response->returnval);
    }

    public function getAttached()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceStateChangedEvent_getAttached', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getError()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IUSBDeviceStateChangedEvent_getError', array((array)$request));
        return new IVirtualBoxErrorInfo ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IUSBDeviceStateChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IUSBDeviceStateChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ISharedFolderChangedEvent extends IEvent
{

    public function getScope()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('ISharedFolderChangedEvent_getScope', array((array)$request));
        return new Scope ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ISharedFolderChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ISharedFolderChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IRuntimeErrorEvent extends IEvent
{

    public function getFatal()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IRuntimeErrorEvent_getFatal', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IRuntimeErrorEvent_getId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getMessage()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IRuntimeErrorEvent_getMessage', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IRuntimeErrorEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IRuntimeErrorEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IEventSourceChangedEvent extends IEvent
{

    public function getListener()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IEventSourceChangedEvent_getListener', array((array)$request));
        return new IEventListener ($this->connection, $response->returnval);
    }

    public function getAdd()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IEventSourceChangedEvent_getAdd', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IEventSourceChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IEventSourceChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IExtraDataChangedEvent extends IEvent
{

    public function getMachineId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IExtraDataChangedEvent_getMachineId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getKey()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IExtraDataChangedEvent_getKey', array((array)$request));
        return (string)$response->returnval;
    }

    public function getValue()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IExtraDataChangedEvent_getValue', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IExtraDataChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IExtraDataChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IVetoEvent extends IEvent
{

    public function addVeto($arg_reason)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $request->reason = $arg_reason;
        $response = $this->connection->__soapCall('IVetoEvent_addVeto', array((array)$request));
        return ;
    }

    public function isVetoed()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVetoEvent_isVetoed', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getVetos()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVetoEvent_getVetos', array((array)$request));
        return (array)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IVetoEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IVetoEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IExtraDataCanChangeEvent extends IVetoEvent
{

    public function getMachineId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IExtraDataCanChangeEvent_getMachineId', array((array)$request));
        return (string)$response->returnval;
    }

    public function getKey()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IExtraDataCanChangeEvent_getKey', array((array)$request));
        return (string)$response->returnval;
    }

    public function getValue()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IExtraDataCanChangeEvent_getValue', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IExtraDataCanChangeEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IExtraDataCanChangeEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class ICanShowWindowEvent extends IVetoEvent
{
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class ICanShowWindowEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "ICanShowWindowEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IShowWindowEvent extends IEvent
{

    public function getWinId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IShowWindowEvent_getWinId', array((array)$request));
        return (float)$response->returnval;
    }

    public function setWinId($value)
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        if (is_null($value) || is_scalar($value))
        {
            $request->winId = $value;
        }
        else
        {
            $request->winId = $value->handle;
        }
        $this->connection->__soapCall('IShowWindowEvent_setWinId', array((array)$request));
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IShowWindowEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IShowWindowEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class INATRedirectEvent extends IMachineEvent
{

    public function getSlot()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATRedirectEvent_getSlot', array((array)$request));
        return (float)$response->returnval;
    }

    public function getRemove()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATRedirectEvent_getRemove', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getName()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATRedirectEvent_getName', array((array)$request));
        return (string)$response->returnval;
    }

    public function getProto()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATRedirectEvent_getProto', array((array)$request));
        return new NATProtocol ($this->connection, $response->returnval);
    }

    public function getHostIP()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATRedirectEvent_getHostIP', array((array)$request));
        return (string)$response->returnval;
    }

    public function getHostPort()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATRedirectEvent_getHostPort', array((array)$request));
        return (int)$response->returnval;
    }

    public function getGuestIP()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATRedirectEvent_getGuestIP', array((array)$request));
        return (string)$response->returnval;
    }

    public function getGuestPort()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('INATRedirectEvent_getGuestPort', array((array)$request));
        return (int)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class INATRedirectEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "INATRedirectEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IHostPCIDevicePlugEvent extends IMachineEvent
{

    public function getPlugged()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostPCIDevicePlugEvent_getPlugged', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getSuccess()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostPCIDevicePlugEvent_getSuccess', array((array)$request));
        return (bool)$response->returnval;
    }

    public function getAttachment()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostPCIDevicePlugEvent_getAttachment', array((array)$request));
        return new IPCIDeviceAttachment ($this->connection, $response->returnval);
    }

    public function getMessage()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IHostPCIDevicePlugEvent_getMessage', array((array)$request));
        return (string)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IHostPCIDevicePlugEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IHostPCIDevicePlugEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IVBoxSVCAvailabilityChangedEvent extends IEvent
{

    public function getAvailable()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IVBoxSVCAvailabilityChangedEvent_getAvailable', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IVBoxSVCAvailabilityChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IVBoxSVCAvailabilityChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IBandwidthGroupChangedEvent extends IEvent
{

    public function getBandwidthGroup()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IBandwidthGroupChangedEvent_getBandwidthGroup', array((array)$request));
        return new IBandwidthGroup ($this->connection, $response->returnval);
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IBandwidthGroupChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IBandwidthGroupChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IGuestMonitorChangedEvent extends IEvent
{

    public function getChangeType()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMonitorChangedEvent_getChangeType', array((array)$request));
        return new GuestMonitorChangedEventType ($this->connection, $response->returnval);
    }

    public function getScreenId()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMonitorChangedEvent_getScreenId', array((array)$request));
        return (float)$response->returnval;
    }

    public function getOriginX()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMonitorChangedEvent_getOriginX', array((array)$request));
        return (float)$response->returnval;
    }

    public function getOriginY()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMonitorChangedEvent_getOriginY', array((array)$request));
        return (float)$response->returnval;
    }

    public function getWidth()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMonitorChangedEvent_getWidth', array((array)$request));
        return (float)$response->returnval;
    }

    public function getHeight()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IGuestMonitorChangedEvent_getHeight', array((array)$request));
        return (float)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IGuestMonitorChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IGuestMonitorChangedEvent";
}

/**
 * Generated VBoxWebService Interface Wrapper
 */
class IStorageDeviceChangedEvent extends IEvent
{

    public function getStorageDevice()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageDeviceChangedEvent_getStorageDevice', array((array)$request));
        return new IMediumAttachment ($this->connection, $response->returnval);
    }

    public function getRemoved()
    {
        $request = new stdClass();
        $request->_this = $this->handle;
        $response = $this->connection->__soapCall('IStorageDeviceChangedEvent_getRemoved', array((array)$request));
        return (bool)$response->returnval;
    }
}

/**
 * Generated VBoxWebService Managed Object Collection
 */
class IStorageDeviceChangedEventCollection extends VBox_ManagedObjectCollection
{
    protected $_interfaceName = "IStorageDeviceChangedEvent";
}

/**
 * Generated VBoxWebService Struct
 */
class IPCIAddress extends VBox_Struct
{
    protected $bus;
    protected $device;
    protected $devFunction;

    public function __construct($connection, $values)
    {
        $this->connection = $connection;
        $this->bus = $values->bus;
        $this->device = $values->device;
        $this->devFunction = $values->devFunction;
    }

    public function getBus()
    {
        return (int)$this->bus;
    }
    public function getDevice()
    {
        return (int)$this->device;
    }
    public function getDevFunction()
    {
        return (int)$this->devFunction;
    }
}

/**
 * Generated VBoxWebService Struct Collection
 */
class IPCIAddressCollection extends VBox_StructCollection
{
    protected $_interfaceName = "IPCIAddress";
}

/**
 * Generated VBoxWebService Struct
 */
class IPCIDeviceAttachment extends VBox_Struct
{
    protected $name;
    protected $isPhysicalDevice;
    protected $hostAddress;
    protected $guestAddress;

    public function __construct($connection, $values)
    {
        $this->connection = $connection;
        $this->name = $values->name;
        $this->isPhysicalDevice = $values->isPhysicalDevice;
        $this->hostAddress = $values->hostAddress;
        $this->guestAddress = $values->guestAddress;
    }

    public function getName()
    {
        return (string)$this->name;
    }
    public function getIsPhysicalDevice()
    {
        return (bool)$this->isPhysicalDevice;
    }
    public function getHostAddress()
    {
        return (int)$this->hostAddress;
    }
    public function getGuestAddress()
    {
        return (int)$this->guestAddress;
    }
}

/**
 * Generated VBoxWebService Struct Collection
 */
class IPCIDeviceAttachmentCollection extends VBox_StructCollection
{
    protected $_interfaceName = "IPCIDeviceAttachment";
}

/**
 * Generated VBoxWebService Struct
 */
class IVRDEServerInfo extends VBox_Struct
{
    protected $active;
    protected $port;
    protected $numberOfClients;
    protected $beginTime;
    protected $endTime;
    protected $bytesSent;
    protected $bytesSentTotal;
    protected $bytesReceived;
    protected $bytesReceivedTotal;
    protected $user;
    protected $domain;
    protected $clientName;
    protected $clientIP;
    protected $clientVersion;
    protected $encryptionStyle;

    public function __construct($connection, $values)
    {
        $this->connection = $connection;
        $this->active = $values->active;
        $this->port = $values->port;
        $this->numberOfClients = $values->numberOfClients;
        $this->beginTime = $values->beginTime;
        $this->endTime = $values->endTime;
        $this->bytesSent = $values->bytesSent;
        $this->bytesSentTotal = $values->bytesSentTotal;
        $this->bytesReceived = $values->bytesReceived;
        $this->bytesReceivedTotal = $values->bytesReceivedTotal;
        $this->user = $values->user;
        $this->domain = $values->domain;
        $this->clientName = $values->clientName;
        $this->clientIP = $values->clientIP;
        $this->clientVersion = $values->clientVersion;
        $this->encryptionStyle = $values->encryptionStyle;
    }

    public function getActive()
    {
        return (bool)$this->active;
    }
    public function getPort()
    {
        return (int)$this->port;
    }
    public function getNumberOfClients()
    {
        return (float)$this->numberOfClients;
    }
    public function getBeginTime()
    {
        return (float)$this->beginTime;
    }
    public function getEndTime()
    {
        return (float)$this->endTime;
    }
    public function getBytesSent()
    {
        return (float)$this->bytesSent;
    }
    public function getBytesSentTotal()
    {
        return (float)$this->bytesSentTotal;
    }
    public function getBytesReceived()
    {
        return (float)$this->bytesReceived;
    }
    public function getBytesReceivedTotal()
    {
        return (float)$this->bytesReceivedTotal;
    }
    public function getUser()
    {
        return (string)$this->user;
    }
    public function getDomain()
    {
        return (string)$this->domain;
    }
    public function getClientName()
    {
        return (string)$this->clientName;
    }
    public function getClientIP()
    {
        return (string)$this->clientIP;
    }
    public function getClientVersion()
    {
        return (float)$this->clientVersion;
    }
    public function getEncryptionStyle()
    {
        return (float)$this->encryptionStyle;
    }
}

/**
 * Generated VBoxWebService Struct Collection
 */
class IVRDEServerInfoCollection extends VBox_StructCollection
{
    protected $_interfaceName = "IVRDEServerInfo";
}

/**
 * Generated VBoxWebService Struct
 */
class IGuestOSType extends VBox_Struct
{
    protected $familyId;
    protected $familyDescription;
    protected $id;
    protected $description;
    protected $is64Bit;
    protected $recommendedIOAPIC;
    protected $recommendedVirtEx;
    protected $recommendedRAM;
    protected $recommendedVRAM;
    protected $recommended2DVideoAcceleration;
    protected $recommended3DAcceleration;
    protected $recommendedHDD;
    protected $adapterType;
    protected $recommendedPAE;
    protected $recommendedDVDStorageController;
    protected $recommendedDVDStorageBus;
    protected $recommendedHDStorageController;
    protected $recommendedHDStorageBus;
    protected $recommendedFirmware;
    protected $recommendedUSBHID;
    protected $recommendedHPET;
    protected $recommendedUSBTablet;
    protected $recommendedRTCUseUTC;
    protected $recommendedChipset;
    protected $recommendedAudioController;
    protected $recommendedFloppy;
    protected $recommendedUSB;

    public function __construct($connection, $values)
    {
        $this->connection = $connection;
        $this->familyId = $values->familyId;
        $this->familyDescription = $values->familyDescription;
        $this->id = $values->id;
        $this->description = $values->description;
        $this->is64Bit = $values->is64Bit;
        $this->recommendedIOAPIC = $values->recommendedIOAPIC;
        $this->recommendedVirtEx = $values->recommendedVirtEx;
        $this->recommendedRAM = $values->recommendedRAM;
        $this->recommendedVRAM = $values->recommendedVRAM;
        $this->recommended2DVideoAcceleration = $values->recommended2DVideoAcceleration;
        $this->recommended3DAcceleration = $values->recommended3DAcceleration;
        $this->recommendedHDD = $values->recommendedHDD;
        $this->adapterType = $values->adapterType;
        $this->recommendedPAE = $values->recommendedPAE;
        $this->recommendedDVDStorageController = $values->recommendedDVDStorageController;
        $this->recommendedDVDStorageBus = $values->recommendedDVDStorageBus;
        $this->recommendedHDStorageController = $values->recommendedHDStorageController;
        $this->recommendedHDStorageBus = $values->recommendedHDStorageBus;
        $this->recommendedFirmware = $values->recommendedFirmware;
        $this->recommendedUSBHID = $values->recommendedUSBHID;
        $this->recommendedHPET = $values->recommendedHPET;
        $this->recommendedUSBTablet = $values->recommendedUSBTablet;
        $this->recommendedRTCUseUTC = $values->recommendedRTCUseUTC;
        $this->recommendedChipset = $values->recommendedChipset;
        $this->recommendedAudioController = $values->recommendedAudioController;
        $this->recommendedFloppy = $values->recommendedFloppy;
        $this->recommendedUSB = $values->recommendedUSB;
    }

    public function getFamilyId()
    {
        return (string)$this->familyId;
    }
    public function getFamilyDescription()
    {
        return (string)$this->familyDescription;
    }
    public function getId()
    {
        return (string)$this->id;
    }
    public function getDescription()
    {
        return (string)$this->description;
    }
    public function getIs64Bit()
    {
        return (bool)$this->is64Bit;
    }
    public function getRecommendedIOAPIC()
    {
        return (bool)$this->recommendedIOAPIC;
    }
    public function getRecommendedVirtEx()
    {
        return (bool)$this->recommendedVirtEx;
    }
    public function getRecommendedRAM()
    {
        return (float)$this->recommendedRAM;
    }
    public function getRecommendedVRAM()
    {
        return (float)$this->recommendedVRAM;
    }
    public function getRecommended2DVideoAcceleration()
    {
        return (bool)$this->recommended2DVideoAcceleration;
    }
    public function getRecommended3DAcceleration()
    {
        return (bool)$this->recommended3DAcceleration;
    }
    public function getRecommendedHDD()
    {
        return (float)$this->recommendedHDD;
    }
    public function getAdapterType()
    {
        return new NetworkAdapterType ($this->connection, $this->adapterType);
    }
    public function getRecommendedPAE()
    {
        return (bool)$this->recommendedPAE;
    }
    public function getRecommendedDVDStorageController()
    {
        return new StorageControllerType ($this->connection, $this->recommendedDVDStorageController);
    }
    public function getRecommendedDVDStorageBus()
    {
        return new StorageBus ($this->connection, $this->recommendedDVDStorageBus);
    }
    public function getRecommendedHDStorageController()
    {
        return new StorageControllerType ($this->connection, $this->recommendedHDStorageController);
    }
    public function getRecommendedHDStorageBus()
    {
        return new StorageBus ($this->connection, $this->recommendedHDStorageBus);
    }
    public function getRecommendedFirmware()
    {
        return new FirmwareType ($this->connection, $this->recommendedFirmware);
    }
    public function getRecommendedUSBHID()
    {
        return (bool)$this->recommendedUSBHID;
    }
    public function getRecommendedHPET()
    {
        return (bool)$this->recommendedHPET;
    }
    public function getRecommendedUSBTablet()
    {
        return (bool)$this->recommendedUSBTablet;
    }
    public function getRecommendedRTCUseUTC()
    {
        return (bool)$this->recommendedRTCUseUTC;
    }
    public function getRecommendedChipset()
    {
        return new ChipsetType ($this->connection, $this->recommendedChipset);
    }
    public function getRecommendedAudioController()
    {
        return new AudioControllerType ($this->connection, $this->recommendedAudioController);
    }
    public function getRecommendedFloppy()
    {
        return (bool)$this->recommendedFloppy;
    }
    public function getRecommendedUSB()
    {
        return (bool)$this->recommendedUSB;
    }
}

/**
 * Generated VBoxWebService Struct Collection
 */
class IGuestOSTypeCollection extends VBox_StructCollection
{
    protected $_interfaceName = "IGuestOSType";
}

/**
 * Generated VBoxWebService Struct
 */
class IAdditionsFacility extends VBox_Struct
{
    protected $classType;
    protected $lastUpdated;
    protected $name;
    protected $status;
    protected $type;

    public function __construct($connection, $values)
    {
        $this->connection = $connection;
        $this->classType = $values->classType;
        $this->lastUpdated = $values->lastUpdated;
        $this->name = $values->name;
        $this->status = $values->status;
        $this->type = $values->type;
    }

    public function getClassType()
    {
        return new AdditionsFacilityClass ($this->connection, $this->classType);
    }
    public function getLastUpdated()
    {
        return (float)$this->lastUpdated;
    }
    public function getName()
    {
        return (string)$this->name;
    }
    public function getStatus()
    {
        return new AdditionsFacilityStatus ($this->connection, $this->status);
    }
    public function getType()
    {
        return new AdditionsFacilityType ($this->connection, $this->type);
    }
}

/**
 * Generated VBoxWebService Struct Collection
 */
class IAdditionsFacilityCollection extends VBox_StructCollection
{
    protected $_interfaceName = "IAdditionsFacility";
}

/**
 * Generated VBoxWebService Struct
 */
class IMediumAttachment extends VBox_Struct
{
    protected $medium;
    protected $controller;
    protected $port;
    protected $device;
    protected $type;
    protected $passthrough;
    protected $temporaryEject;
    protected $isEjected;
    protected $nonRotational;
    protected $discard;
    protected $bandwidthGroup;

    public function __construct($connection, $values)
    {
        $this->connection = $connection;
        $this->medium = $values->medium;
        $this->controller = $values->controller;
        $this->port = $values->port;
        $this->device = $values->device;
        $this->type = $values->type;
        $this->passthrough = $values->passthrough;
        $this->temporaryEject = $values->temporaryEject;
        $this->isEjected = $values->isEjected;
        $this->nonRotational = $values->nonRotational;
        $this->discard = $values->discard;
        $this->bandwidthGroup = $values->bandwidthGroup;
    }

    public function getMedium()
    {
        return new IMedium ($this->connection, $this->medium);
    }
    public function getController()
    {
        return (string)$this->controller;
    }
    public function getPort()
    {
        return (int)$this->port;
    }
    public function getDevice()
    {
        return (int)$this->device;
    }
    public function getType()
    {
        return new DeviceType ($this->connection, $this->type);
    }
    public function getPassthrough()
    {
        return (bool)$this->passthrough;
    }
    public function getTemporaryEject()
    {
        return (bool)$this->temporaryEject;
    }
    public function getIsEjected()
    {
        return (bool)$this->isEjected;
    }
    public function getNonRotational()
    {
        return (bool)$this->nonRotational;
    }
    public function getDiscard()
    {
        return (bool)$this->discard;
    }
    public function getBandwidthGroup()
    {
        return new IBandwidthGroup ($this->connection, $this->bandwidthGroup);
    }
}

/**
 * Generated VBoxWebService Struct Collection
 */
class IMediumAttachmentCollection extends VBox_StructCollection
{
    protected $_interfaceName = "IMediumAttachment";
}

/**
 * Generated VBoxWebService Struct
 */
class ISharedFolder extends VBox_Struct
{
    protected $name;
    protected $hostPath;
    protected $accessible;
    protected $writable;
    protected $autoMount;
    protected $lastAccessError;

    public function __construct($connection, $values)
    {
        $this->connection = $connection;
        $this->name = $values->name;
        $this->hostPath = $values->hostPath;
        $this->accessible = $values->accessible;
        $this->writable = $values->writable;
        $this->autoMount = $values->autoMount;
        $this->lastAccessError = $values->lastAccessError;
    }

    public function getName()
    {
        return (string)$this->name;
    }
    public function getHostPath()
    {
        return (string)$this->hostPath;
    }
    public function getAccessible()
    {
        return (bool)$this->accessible;
    }
    public function getWritable()
    {
        return (bool)$this->writable;
    }
    public function getAutoMount()
    {
        return (bool)$this->autoMount;
    }
    public function getLastAccessError()
    {
        return (string)$this->lastAccessError;
    }
}

/**
 * Generated VBoxWebService Struct Collection
 */
class ISharedFolderCollection extends VBox_StructCollection
{
    protected $_interfaceName = "ISharedFolder";
}

/**
 * Generated VBoxWebService ENUM
 */
class SettingsVersion extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'v1_0', 2 => 'v1_1', 3 => 'v1_2', 4 => 'v1_3pre', 5 => 'v1_3', 6 => 'v1_4', 7 => 'v1_5', 8 => 'v1_6', 9 => 'v1_7', 10 => 'v1_8', 11 => 'v1_9', 12 => 'v1_10', 13 => 'v1_11', 14 => 'v1_12', 15 => 'v1_13', 99999 => 'Future');
    public $ValueMap = array('Null' => 0, 'v1_0' => 1, 'v1_1' => 2, 'v1_2' => 3, 'v1_3pre' => 4, 'v1_3' => 5, 'v1_4' => 6, 'v1_5' => 7, 'v1_6' => 8, 'v1_7' => 9, 'v1_8' => 10, 'v1_9' => 11, 'v1_10' => 12, 'v1_11' => 13, 'v1_12' => 14, 'v1_13' => 15, 'Future' => 99999);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class SettingsVersionCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "SettingsVersion";
}

/**
 * Generated VBoxWebService ENUM
 */
class AccessMode extends VBox_Enum
{
    public $NameMap = array(1 => 'ReadOnly', 2 => 'ReadWrite');
    public $ValueMap = array('ReadOnly' => 1, 'ReadWrite' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AccessModeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AccessMode";
}

/**
 * Generated VBoxWebService ENUM
 */
class MachineState extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'PoweredOff', 2 => 'Saved', 3 => 'Teleported', 4 => 'Aborted', 5 => 'Running', 6 => 'Paused', 7 => 'Stuck', 8 => 'Teleporting', 9 => 'LiveSnapshotting', 10 => 'Starting', 11 => 'Stopping', 12 => 'Saving', 13 => 'Restoring', 14 => 'TeleportingPausedVM', 15 => 'TeleportingIn', 16 => 'FaultTolerantSyncing', 17 => 'DeletingSnapshotOnline', 18 => 'DeletingSnapshotPaused', 19 => 'RestoringSnapshot', 20 => 'DeletingSnapshot', 21 => 'SettingUp', );
    public $ValueMap = array('Null' => 0, 'PoweredOff' => 1, 'Saved' => 2, 'Teleported' => 3, 'Aborted' => 4, 'Running' => 5, 'Paused' => 6, 'Stuck' => 7, 'Teleporting' => 8, 'LiveSnapshotting' => 9, 'Starting' => 10, 'Stopping' => 11, 'Saving' => 12, 'Restoring' => 13, 'TeleportingPausedVM' => 14, 'TeleportingIn' => 15, 'FaultTolerantSyncing' => 16, 'DeletingSnapshotOnline' => 17, 'DeletingSnapshotPaused' => 18, 'RestoringSnapshot' => 19, 'DeletingSnapshot' => 20, 'SettingUp' => 21, );
}

/**
 * Generated VBoxWebService Enum Collection
 */
class MachineStateCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "MachineState";
}

/**
 * Generated VBoxWebService ENUM
 */
class SessionState extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'Unlocked', 2 => 'Locked', 3 => 'Spawning', 4 => 'Unlocking');
    public $ValueMap = array('Null' => 0, 'Unlocked' => 1, 'Locked' => 2, 'Spawning' => 3, 'Unlocking' => 4);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class SessionStateCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "SessionState";
}

/**
 * Generated VBoxWebService ENUM
 */
class CPUPropertyType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'PAE', 2 => 'Synthetic');
    public $ValueMap = array('Null' => 0, 'PAE' => 1, 'Synthetic' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class CPUPropertyTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "CPUPropertyType";
}

/**
 * Generated VBoxWebService ENUM
 */
class HWVirtExPropertyType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'Enabled', 2 => 'Exclusive', 3 => 'VPID', 4 => 'NestedPaging', 5 => 'LargePages', 6 => 'Force');
    public $ValueMap = array('Null' => 0, 'Enabled' => 1, 'Exclusive' => 2, 'VPID' => 3, 'NestedPaging' => 4, 'LargePages' => 5, 'Force' => 6);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class HWVirtExPropertyTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "HWVirtExPropertyType";
}

/**
 * Generated VBoxWebService ENUM
 */
class FaultToleranceState extends VBox_Enum
{
    public $NameMap = array(1 => 'Inactive', 2 => 'Master', 3 => 'Standby');
    public $ValueMap = array('Inactive' => 1, 'Master' => 2, 'Standby' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class FaultToleranceStateCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "FaultToleranceState";
}

/**
 * Generated VBoxWebService ENUM
 */
class LockType extends VBox_Enum
{
    public $NameMap = array(2 => 'Write', 1 => 'Shared', 3 => 'VM');
    public $ValueMap = array('Write' => 2, 'Shared' => 1, 'VM' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class LockTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "LockType";
}

/**
 * Generated VBoxWebService ENUM
 */
class SessionType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'WriteLock', 2 => 'Remote', 3 => 'Shared');
    public $ValueMap = array('Null' => 0, 'WriteLock' => 1, 'Remote' => 2, 'Shared' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class SessionTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "SessionType";
}

/**
 * Generated VBoxWebService ENUM
 */
class DeviceType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'Floppy', 2 => 'DVD', 3 => 'HardDisk', 4 => 'Network', 5 => 'USB', 6 => 'SharedFolder');
    public $ValueMap = array('Null' => 0, 'Floppy' => 1, 'DVD' => 2, 'HardDisk' => 3, 'Network' => 4, 'USB' => 5, 'SharedFolder' => 6);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class DeviceTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "DeviceType";
}

/**
 * Generated VBoxWebService ENUM
 */
class DeviceActivity extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'Idle', 2 => 'Reading', 3 => 'Writing');
    public $ValueMap = array('Null' => 0, 'Idle' => 1, 'Reading' => 2, 'Writing' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class DeviceActivityCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "DeviceActivity";
}

/**
 * Generated VBoxWebService ENUM
 */
class ClipboardMode extends VBox_Enum
{
    public $NameMap = array(0 => 'Disabled', 1 => 'HostToGuest', 2 => 'GuestToHost', 3 => 'Bidirectional');
    public $ValueMap = array('Disabled' => 0, 'HostToGuest' => 1, 'GuestToHost' => 2, 'Bidirectional' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ClipboardModeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ClipboardMode";
}

/**
 * Generated VBoxWebService ENUM
 */
class DragAndDropMode extends VBox_Enum
{
    public $NameMap = array(0 => 'Disabled', 1 => 'HostToGuest', 2 => 'GuestToHost', 3 => 'Bidirectional');
    public $ValueMap = array('Disabled' => 0, 'HostToGuest' => 1, 'GuestToHost' => 2, 'Bidirectional' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class DragAndDropModeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "DragAndDropMode";
}

/**
 * Generated VBoxWebService ENUM
 */
class Scope extends VBox_Enum
{
    public $NameMap = array(0 => 'Global', 1 => 'Machine', 2 => 'Session');
    public $ValueMap = array('Global' => 0, 'Machine' => 1, 'Session' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ScopeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "Scope";
}

/**
 * Generated VBoxWebService ENUM
 */
class BIOSBootMenuMode extends VBox_Enum
{
    public $NameMap = array(0 => 'Disabled', 1 => 'MenuOnly', 2 => 'MessageAndMenu');
    public $ValueMap = array('Disabled' => 0, 'MenuOnly' => 1, 'MessageAndMenu' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class BIOSBootMenuModeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "BIOSBootMenuMode";
}

/**
 * Generated VBoxWebService ENUM
 */
class ProcessorFeature extends VBox_Enum
{
    public $NameMap = array(0 => 'HWVirtEx', 1 => 'PAE', 2 => 'LongMode', 3 => 'NestedPaging');
    public $ValueMap = array('HWVirtEx' => 0, 'PAE' => 1, 'LongMode' => 2, 'NestedPaging' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ProcessorFeatureCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ProcessorFeature";
}

/**
 * Generated VBoxWebService ENUM
 */
class FirmwareType extends VBox_Enum
{
    public $NameMap = array(1 => 'BIOS', 2 => 'EFI', 3 => 'EFI32', 4 => 'EFI64', 5 => 'EFIDUAL');
    public $ValueMap = array('BIOS' => 1, 'EFI' => 2, 'EFI32' => 3, 'EFI64' => 4, 'EFIDUAL' => 5);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class FirmwareTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "FirmwareType";
}

/**
 * Generated VBoxWebService ENUM
 */
class PointingHIDType extends VBox_Enum
{
    public $NameMap = array(1 => 'None', 2 => 'PS2Mouse', 3 => 'USBMouse', 4 => 'USBTablet', 5 => 'ComboMouse');
    public $ValueMap = array('None' => 1, 'PS2Mouse' => 2, 'USBMouse' => 3, 'USBTablet' => 4, 'ComboMouse' => 5);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class PointingHIDTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "PointingHIDType";
}

/**
 * Generated VBoxWebService ENUM
 */
class KeyboardHIDType extends VBox_Enum
{
    public $NameMap = array(1 => 'None', 2 => 'PS2Keyboard', 3 => 'USBKeyboard', 4 => 'ComboKeyboard');
    public $ValueMap = array('None' => 1, 'PS2Keyboard' => 2, 'USBKeyboard' => 3, 'ComboKeyboard' => 4);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class KeyboardHIDTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "KeyboardHIDType";
}

/**
 * Generated VBoxWebService ENUM
 */
class VFSType extends VBox_Enum
{
    public $NameMap = array(1 => 'File', 2 => 'Cloud', 3 => 'S3', 4 => 'WebDav');
    public $ValueMap = array('File' => 1, 'Cloud' => 2, 'S3' => 3, 'WebDav' => 4);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class VFSTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "VFSType";
}

/**
 * Generated VBoxWebService ENUM
 */
class VFSFileType extends VBox_Enum
{
    public $NameMap = array(1 => 'Unknown', 2 => 'Fifo', 3 => 'DevChar', 4 => 'Directory', 5 => 'DevBlock', 6 => 'File', 7 => 'SymLink', 8 => 'Socket', 9 => 'WhiteOut');
    public $ValueMap = array('Unknown' => 1, 'Fifo' => 2, 'DevChar' => 3, 'Directory' => 4, 'DevBlock' => 5, 'File' => 6, 'SymLink' => 7, 'Socket' => 8, 'WhiteOut' => 9);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class VFSFileTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "VFSFileType";
}

/**
 * Generated VBoxWebService ENUM
 */
class ImportOptions extends VBox_Enum
{
    public $NameMap = array(1 => 'KeepAllMACs', 2 => 'KeepNATMACs');
    public $ValueMap = array('KeepAllMACs' => 1, 'KeepNATMACs' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ImportOptionsCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ImportOptions";
}

/**
 * Generated VBoxWebService ENUM
 */
class VirtualSystemDescriptionType extends VBox_Enum
{
    public $NameMap = array(1 => 'Ignore', 2 => 'OS', 3 => 'Name', 4 => 'Product', 5 => 'Vendor', 6 => 'Version', 7 => 'ProductUrl', 8 => 'VendorUrl', 9 => 'Description', 10 => 'License', 11 => 'Miscellaneous', 12 => 'CPU', 13 => 'Memory', 14 => 'HardDiskControllerIDE', 15 => 'HardDiskControllerSATA', 16 => 'HardDiskControllerSCSI', 17 => 'HardDiskControllerSAS', 18 => 'HardDiskImage', 19 => 'Floppy', 20 => 'CDROM', 21 => 'NetworkAdapter', 22 => 'USBController', 23 => 'SoundCard', 24 => 'SettingsFile');
    public $ValueMap = array('Ignore' => 1, 'OS' => 2, 'Name' => 3, 'Product' => 4, 'Vendor' => 5, 'Version' => 6, 'ProductUrl' => 7, 'VendorUrl' => 8, 'Description' => 9, 'License' => 10, 'Miscellaneous' => 11, 'CPU' => 12, 'Memory' => 13, 'HardDiskControllerIDE' => 14, 'HardDiskControllerSATA' => 15, 'HardDiskControllerSCSI' => 16, 'HardDiskControllerSAS' => 17, 'HardDiskImage' => 18, 'Floppy' => 19, 'CDROM' => 20, 'NetworkAdapter' => 21, 'USBController' => 22, 'SoundCard' => 23, 'SettingsFile' => 24);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class VirtualSystemDescriptionTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "VirtualSystemDescriptionType";
}

/**
 * Generated VBoxWebService ENUM
 */
class VirtualSystemDescriptionValueType extends VBox_Enum
{
    public $NameMap = array(1 => 'Reference', 2 => 'Original', 3 => 'Auto', 4 => 'ExtraConfig');
    public $ValueMap = array('Reference' => 1, 'Original' => 2, 'Auto' => 3, 'ExtraConfig' => 4);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class VirtualSystemDescriptionValueTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "VirtualSystemDescriptionValueType";
}

/**
 * Generated VBoxWebService ENUM
 */
class CleanupMode extends VBox_Enum
{
    public $NameMap = array(1 => 'UnregisterOnly', 2 => 'DetachAllReturnNone', 3 => 'DetachAllReturnHardDisksOnly', 4 => 'Full');
    public $ValueMap = array('UnregisterOnly' => 1, 'DetachAllReturnNone' => 2, 'DetachAllReturnHardDisksOnly' => 3, 'Full' => 4);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class CleanupModeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "CleanupMode";
}

/**
 * Generated VBoxWebService ENUM
 */
class CloneMode extends VBox_Enum
{
    public $NameMap = array(1 => 'MachineState', 2 => 'MachineAndChildStates', 3 => 'AllStates');
    public $ValueMap = array('MachineState' => 1, 'MachineAndChildStates' => 2, 'AllStates' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class CloneModeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "CloneMode";
}

/**
 * Generated VBoxWebService ENUM
 */
class CloneOptions extends VBox_Enum
{
    public $NameMap = array(1 => 'Link', 2 => 'KeepAllMACs', 3 => 'KeepNATMACs', 4 => 'KeepDiskNames');
    public $ValueMap = array('Link' => 1, 'KeepAllMACs' => 2, 'KeepNATMACs' => 3, 'KeepDiskNames' => 4);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class CloneOptionsCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "CloneOptions";
}

/**
 * Generated VBoxWebService ENUM
 */
class AutostopType extends VBox_Enum
{
    public $NameMap = array(1 => 'Disabled', 2 => 'SaveState', 3 => 'PowerOff', 4 => 'AcpiShutdown');
    public $ValueMap = array('Disabled' => 1, 'SaveState' => 2, 'PowerOff' => 3, 'AcpiShutdown' => 4);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AutostopTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AutostopType";
}

/**
 * Generated VBoxWebService ENUM
 */
class HostNetworkInterfaceMediumType extends VBox_Enum
{
    public $NameMap = array(0 => 'Unknown', 1 => 'Ethernet', 2 => 'PPP', 3 => 'SLIP');
    public $ValueMap = array('Unknown' => 0, 'Ethernet' => 1, 'PPP' => 2, 'SLIP' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class HostNetworkInterfaceMediumTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "HostNetworkInterfaceMediumType";
}

/**
 * Generated VBoxWebService ENUM
 */
class HostNetworkInterfaceStatus extends VBox_Enum
{
    public $NameMap = array(0 => 'Unknown', 1 => 'Up', 2 => 'Down');
    public $ValueMap = array('Unknown' => 0, 'Up' => 1, 'Down' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class HostNetworkInterfaceStatusCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "HostNetworkInterfaceStatus";
}

/**
 * Generated VBoxWebService ENUM
 */
class HostNetworkInterfaceType extends VBox_Enum
{
    public $NameMap = array(1 => 'Bridged', 2 => 'HostOnly');
    public $ValueMap = array('Bridged' => 1, 'HostOnly' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class HostNetworkInterfaceTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "HostNetworkInterfaceType";
}

/**
 * Generated VBoxWebService ENUM
 */
class AdditionsFacilityType extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 20 => 'VBoxGuestDriver', 90 => 'AutoLogon', 100 => 'VBoxService', 101 => 'VBoxTrayClient', 1000 => 'Seamless', 1100 => 'Graphics', 2147483646 => 'All');
    public $ValueMap = array('None' => 0, 'VBoxGuestDriver' => 20, 'AutoLogon' => 90, 'VBoxService' => 100, 'VBoxTrayClient' => 101, 'Seamless' => 1000, 'Graphics' => 1100, 'All' => 2147483646);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AdditionsFacilityTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AdditionsFacilityType";
}

/**
 * Generated VBoxWebService ENUM
 */
class AdditionsFacilityClass extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 10 => 'Driver', 30 => 'Service', 50 => 'Program', 100 => 'Feature', 999 => 'ThirdParty', 2147483646 => 'All');
    public $ValueMap = array('None' => 0, 'Driver' => 10, 'Service' => 30, 'Program' => 50, 'Feature' => 100, 'ThirdParty' => 999, 'All' => 2147483646);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AdditionsFacilityClassCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AdditionsFacilityClass";
}

/**
 * Generated VBoxWebService ENUM
 */
class AdditionsFacilityStatus extends VBox_Enum
{
    public $NameMap = array(0 => 'Inactive', 1 => 'Paused', 20 => 'PreInit', 30 => 'Init', 50 => 'Active', 100 => 'Terminating', 101 => 'Terminated', 800 => 'Failed', 999 => 'Unknown');
    public $ValueMap = array('Inactive' => 0, 'Paused' => 1, 'PreInit' => 20, 'Init' => 30, 'Active' => 50, 'Terminating' => 100, 'Terminated' => 101, 'Failed' => 800, 'Unknown' => 999);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AdditionsFacilityStatusCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AdditionsFacilityStatus";
}

/**
 * Generated VBoxWebService ENUM
 */
class AdditionsRunLevelType extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'System', 2 => 'Userland', 3 => 'Desktop');
    public $ValueMap = array('None' => 0, 'System' => 1, 'Userland' => 2, 'Desktop' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AdditionsRunLevelTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AdditionsRunLevelType";
}

/**
 * Generated VBoxWebService ENUM
 */
class AdditionsUpdateFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'WaitForUpdateStartOnly');
    public $ValueMap = array('None' => 0, 'WaitForUpdateStartOnly' => 1);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AdditionsUpdateFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AdditionsUpdateFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class FileSeekType extends VBox_Enum
{
    public $NameMap = array(0 => 'Set', 1 => 'Current');
    public $ValueMap = array('Set' => 0, 'Current' => 1);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class FileSeekTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "FileSeekType";
}

/**
 * Generated VBoxWebService ENUM
 */
class ProcessInputFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'EndOfFile');
    public $ValueMap = array('None' => 0, 'EndOfFile' => 1);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ProcessInputFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ProcessInputFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class ProcessOutputFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'StdErr');
    public $ValueMap = array('None' => 0, 'StdErr' => 1);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ProcessOutputFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ProcessOutputFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class ProcessWaitForFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'Start', 2 => 'Terminate', 4 => 'StdIn', 8 => 'StdOut', 16 => 'StdErr');
    public $ValueMap = array('None' => 0, 'Start' => 1, 'Terminate' => 2, 'StdIn' => 4, 'StdOut' => 8, 'StdErr' => 16);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ProcessWaitForFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ProcessWaitForFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class ProcessWaitResult extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'Start', 2 => 'Terminate', 3 => 'Status', 4 => 'Error', 5 => 'Timeout', 6 => 'StdIn', 7 => 'StdOut', 8 => 'StdErr', 9 => 'WaitFlagNotSupported');
    public $ValueMap = array('None' => 0, 'Start' => 1, 'Terminate' => 2, 'Status' => 3, 'Error' => 4, 'Timeout' => 5, 'StdIn' => 6, 'StdOut' => 7, 'StdErr' => 8, 'WaitFlagNotSupported' => 9);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ProcessWaitResultCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ProcessWaitResult";
}

/**
 * Generated VBoxWebService ENUM
 */
class CopyFileFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'Recursive', 2 => 'Update', 4 => 'FollowLinks');
    public $ValueMap = array('None' => 0, 'Recursive' => 1, 'Update' => 2, 'FollowLinks' => 4);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class CopyFileFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "CopyFileFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class DirectoryCreateFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'Parents');
    public $ValueMap = array('None' => 0, 'Parents' => 1);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class DirectoryCreateFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "DirectoryCreateFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class DirectoryRemoveRecFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'ContentAndDir', 2 => 'ContentOnly');
    public $ValueMap = array('None' => 0, 'ContentAndDir' => 1, 'ContentOnly' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class DirectoryRemoveRecFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "DirectoryRemoveRecFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class PathRenameFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'NoReplace', 2 => 'Replace', 4 => 'NoSymlinks');
    public $ValueMap = array('None' => 0, 'NoReplace' => 1, 'Replace' => 2, 'NoSymlinks' => 4);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class PathRenameFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "PathRenameFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class ProcessCreateFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'WaitForProcessStartOnly', 2 => 'IgnoreOrphanedProcesses', 4 => 'Hidden', 8 => 'NoProfile', 16 => 'WaitForStdOut', 32 => 'WaitForStdErr', 64 => 'ExpandArguments');
    public $ValueMap = array('None' => 0, 'WaitForProcessStartOnly' => 1, 'IgnoreOrphanedProcesses' => 2, 'Hidden' => 4, 'NoProfile' => 8, 'WaitForStdOut' => 16, 'WaitForStdErr' => 32, 'ExpandArguments' => 64);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ProcessCreateFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ProcessCreateFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class ProcessPriority extends VBox_Enum
{
    public $NameMap = array(0 => 'Invalid', 1 => 'Default');
    public $ValueMap = array('Invalid' => 0, 'Default' => 1);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ProcessPriorityCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ProcessPriority";
}

/**
 * Generated VBoxWebService ENUM
 */
class SymlinkType extends VBox_Enum
{
    public $NameMap = array(0 => 'Unknown', 1 => 'Directory', 2 => 'File');
    public $ValueMap = array('Unknown' => 0, 'Directory' => 1, 'File' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class SymlinkTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "SymlinkType";
}

/**
 * Generated VBoxWebService ENUM
 */
class SymlinkReadFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'NoSymlinks');
    public $ValueMap = array('None' => 0, 'NoSymlinks' => 1);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class SymlinkReadFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "SymlinkReadFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class ProcessStatus extends VBox_Enum
{
    public $NameMap = array(0 => 'Undefined', 10 => 'Starting', 100 => 'Started', 110 => 'Paused', 480 => 'Terminating', 500 => 'TerminatedNormally', 510 => 'TerminatedSignal', 511 => 'TerminatedAbnormally', 512 => 'TimedOutKilled', 513 => 'TimedOutAbnormally', 600 => 'Down', 800 => 'Error');
    public $ValueMap = array('Undefined' => 0, 'Starting' => 10, 'Started' => 100, 'Paused' => 110, 'Terminating' => 480, 'TerminatedNormally' => 500, 'TerminatedSignal' => 510, 'TerminatedAbnormally' => 511, 'TimedOutKilled' => 512, 'TimedOutAbnormally' => 513, 'Down' => 600, 'Error' => 800);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ProcessStatusCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ProcessStatus";
}

/**
 * Generated VBoxWebService ENUM
 */
class FsObjType extends VBox_Enum
{
    public $NameMap = array(0 => 'Undefined', 1 => 'FIFO', 10 => 'DevChar', 11 => 'DevBlock', 50 => 'Directory', 80 => 'File', 100 => 'Symlink', 200 => 'Socket', 400 => 'Whiteout');
    public $ValueMap = array('Undefined' => 0, 'FIFO' => 1, 'DevChar' => 10, 'DevBlock' => 11, 'Directory' => 50, 'File' => 80, 'Symlink' => 100, 'Socket' => 200, 'Whiteout' => 400);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class FsObjTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "FsObjType";
}

/**
 * Generated VBoxWebService ENUM
 */
class DragAndDropAction extends VBox_Enum
{
    public $NameMap = array(0 => 'Ignore', 1 => 'Copy', 2 => 'Move', 3 => 'Link');
    public $ValueMap = array('Ignore' => 0, 'Copy' => 1, 'Move' => 2, 'Link' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class DragAndDropActionCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "DragAndDropAction";
}

/**
 * Generated VBoxWebService ENUM
 */
class DirectoryOpenFlag extends VBox_Enum
{
    public $NameMap = array(0 => 'None', 1 => 'NoSymlinks');
    public $ValueMap = array('None' => 0, 'NoSymlinks' => 1);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class DirectoryOpenFlagCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "DirectoryOpenFlag";
}

/**
 * Generated VBoxWebService ENUM
 */
class MediumState extends VBox_Enum
{
    public $NameMap = array(0 => 'NotCreated', 1 => 'Created', 2 => 'LockedRead', 3 => 'LockedWrite', 4 => 'Inaccessible', 5 => 'Creating', 6 => 'Deleting');
    public $ValueMap = array('NotCreated' => 0, 'Created' => 1, 'LockedRead' => 2, 'LockedWrite' => 3, 'Inaccessible' => 4, 'Creating' => 5, 'Deleting' => 6);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class MediumStateCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "MediumState";
}

/**
 * Generated VBoxWebService ENUM
 */
class MediumType extends VBox_Enum
{
    public $NameMap = array(0 => 'Normal', 1 => 'Immutable', 2 => 'Writethrough', 3 => 'Shareable', 4 => 'Readonly', 5 => 'MultiAttach');
    public $ValueMap = array('Normal' => 0, 'Immutable' => 1, 'Writethrough' => 2, 'Shareable' => 3, 'Readonly' => 4, 'MultiAttach' => 5);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class MediumTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "MediumType";
}

/**
 * Generated VBoxWebService ENUM
 */
class MediumVariant extends VBox_Enum
{
    public $NameMap = array(0 => 'Standard', 0x01 => 'VmdkSplit2G', 0x02 => 'VmdkRawDisk', 0x04 => 'VmdkStreamOptimized', 0x08 => 'VmdkESX', 0x10000 => 'Fixed', 0x20000 => 'Diff', 0x40000000 => 'NoCreateDir');
    public $ValueMap = array('Standard' => 0, 'VmdkSplit2G' => 0x01, 'VmdkRawDisk' => 0x02, 'VmdkStreamOptimized' => 0x04, 'VmdkESX' => 0x08, 'Fixed' => 0x10000, 'Diff' => 0x20000, 'NoCreateDir' => 0x40000000);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class MediumVariantCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "MediumVariant";
}

/**
 * Generated VBoxWebService ENUM
 */
class DataType extends VBox_Enum
{
    public $NameMap = array(0 => 'Int32', 1 => 'Int8', 2 => 'String');
    public $ValueMap = array('Int32' => 0, 'Int8' => 1, 'String' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class DataTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "DataType";
}

/**
 * Generated VBoxWebService ENUM
 */
class DataFlags extends VBox_Enum
{
    public $NameMap = array(0x00 => 'None', 0x01 => 'Mandatory', 0x02 => 'Expert', 0x04 => 'Array', 0x07 => 'FlagMask');
    public $ValueMap = array('None' => 0x00, 'Mandatory' => 0x01, 'Expert' => 0x02, 'Array' => 0x04, 'FlagMask' => 0x07);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class DataFlagsCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "DataFlags";
}

/**
 * Generated VBoxWebService ENUM
 */
class MediumFormatCapabilities extends VBox_Enum
{
    public $NameMap = array(0x01 => 'Uuid', 0x02 => 'CreateFixed', 0x04 => 'CreateDynamic', 0x08 => 'CreateSplit2G', 0x10 => 'Differencing', 0x20 => 'Asynchronous', 0x40 => 'File', 0x80 => 'Properties', 0x100 => 'TcpNetworking', 0x200 => 'VFS', 0x3FF => 'CapabilityMask');
    public $ValueMap = array('Uuid' => 0x01, 'CreateFixed' => 0x02, 'CreateDynamic' => 0x04, 'CreateSplit2G' => 0x08, 'Differencing' => 0x10, 'Asynchronous' => 0x20, 'File' => 0x40, 'Properties' => 0x80, 'TcpNetworking' => 0x100, 'VFS' => 0x200, 'CapabilityMask' => 0x3FF);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class MediumFormatCapabilitiesCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "MediumFormatCapabilities";
}

/**
 * Generated VBoxWebService ENUM
 */
class MouseButtonState extends VBox_Enum
{
    public $NameMap = array(0x01 => 'LeftButton', 0x02 => 'RightButton', 0x04 => 'MiddleButton', 0x08 => 'WheelUp', 0x10 => 'WheelDown', 0x20 => 'XButton1', 0x40 => 'XButton2', 0x7F => 'MouseStateMask');
    public $ValueMap = array('LeftButton' => 0x01, 'RightButton' => 0x02, 'MiddleButton' => 0x04, 'WheelUp' => 0x08, 'WheelDown' => 0x10, 'XButton1' => 0x20, 'XButton2' => 0x40, 'MouseStateMask' => 0x7F);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class MouseButtonStateCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "MouseButtonState";
}

/**
 * Generated VBoxWebService ENUM
 */
class FramebufferPixelFormat extends VBox_Enum
{
    public $NameMap = array(0 => 'Opaque', 0x32424752 => 'FOURCC_RGB');
    public $ValueMap = array('Opaque' => 0, 'FOURCC_RGB' => 0x32424752);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class FramebufferPixelFormatCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "FramebufferPixelFormat";
}

/**
 * Generated VBoxWebService ENUM
 */
class NetworkAttachmentType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'NAT', 2 => 'Bridged', 3 => 'Internal', 4 => 'HostOnly', 5 => 'Generic');
    public $ValueMap = array('Null' => 0, 'NAT' => 1, 'Bridged' => 2, 'Internal' => 3, 'HostOnly' => 4, 'Generic' => 5);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class NetworkAttachmentTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "NetworkAttachmentType";
}

/**
 * Generated VBoxWebService ENUM
 */
class NetworkAdapterType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'Am79C970A', 2 => 'Am79C973', 3 => 'I82540EM', 4 => 'I82543GC', 5 => 'I82545EM', 6 => 'Virtio');
    public $ValueMap = array('Null' => 0, 'Am79C970A' => 1, 'Am79C973' => 2, 'I82540EM' => 3, 'I82543GC' => 4, 'I82545EM' => 5, 'Virtio' => 6);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class NetworkAdapterTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "NetworkAdapterType";
}

/**
 * Generated VBoxWebService ENUM
 */
class NetworkAdapterPromiscModePolicy extends VBox_Enum
{
    public $NameMap = array(1 => 'Deny', 2 => 'AllowNetwork', 3 => 'AllowAll');
    public $ValueMap = array('Deny' => 1, 'AllowNetwork' => 2, 'AllowAll' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class NetworkAdapterPromiscModePolicyCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "NetworkAdapterPromiscModePolicy";
}

/**
 * Generated VBoxWebService ENUM
 */
class PortMode extends VBox_Enum
{
    public $NameMap = array(0 => 'Disconnected', 1 => 'HostPipe', 2 => 'HostDevice', 3 => 'RawFile');
    public $ValueMap = array('Disconnected' => 0, 'HostPipe' => 1, 'HostDevice' => 2, 'RawFile' => 3);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class PortModeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "PortMode";
}

/**
 * Generated VBoxWebService ENUM
 */
class USBDeviceState extends VBox_Enum
{
    public $NameMap = array(0 => 'NotSupported', 1 => 'Unavailable', 2 => 'Busy', 3 => 'Available', 4 => 'Held', 5 => 'Captured');
    public $ValueMap = array('NotSupported' => 0, 'Unavailable' => 1, 'Busy' => 2, 'Available' => 3, 'Held' => 4, 'Captured' => 5);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class USBDeviceStateCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "USBDeviceState";
}

/**
 * Generated VBoxWebService ENUM
 */
class USBDeviceFilterAction extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'Ignore', 2 => 'Hold');
    public $ValueMap = array('Null' => 0, 'Ignore' => 1, 'Hold' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class USBDeviceFilterActionCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "USBDeviceFilterAction";
}

/**
 * Generated VBoxWebService ENUM
 */
class AudioDriverType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'WinMM', 2 => 'OSS', 3 => 'ALSA', 4 => 'DirectSound', 5 => 'CoreAudio', 6 => 'MMPM', 7 => 'Pulse', 8 => 'SolAudio');
    public $ValueMap = array('Null' => 0, 'WinMM' => 1, 'OSS' => 2, 'ALSA' => 3, 'DirectSound' => 4, 'CoreAudio' => 5, 'MMPM' => 6, 'Pulse' => 7, 'SolAudio' => 8);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AudioDriverTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AudioDriverType";
}

/**
 * Generated VBoxWebService ENUM
 */
class AudioControllerType extends VBox_Enum
{
    public $NameMap = array(0 => 'AC97', 1 => 'SB16', 2 => 'HDA');
    public $ValueMap = array('AC97' => 0, 'SB16' => 1, 'HDA' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AudioControllerTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AudioControllerType";
}

/**
 * Generated VBoxWebService ENUM
 */
class AuthType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'External', 2 => 'Guest');
    public $ValueMap = array('Null' => 0, 'External' => 1, 'Guest' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class AuthTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "AuthType";
}

/**
 * Generated VBoxWebService ENUM
 */
class StorageBus extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'IDE', 2 => 'SATA', 3 => 'SCSI', 4 => 'Floppy', 5 => 'SAS');
    public $ValueMap = array('Null' => 0, 'IDE' => 1, 'SATA' => 2, 'SCSI' => 3, 'Floppy' => 4, 'SAS' => 5);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class StorageBusCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "StorageBus";
}

/**
 * Generated VBoxWebService ENUM
 */
class StorageControllerType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'LsiLogic', 2 => 'BusLogic', 3 => 'IntelAhci', 4 => 'PIIX3', 5 => 'PIIX4', 6 => 'ICH6', 7 => 'I82078', 8 => 'LsiLogicSas');
    public $ValueMap = array('Null' => 0, 'LsiLogic' => 1, 'BusLogic' => 2, 'IntelAhci' => 3, 'PIIX3' => 4, 'PIIX4' => 5, 'ICH6' => 6, 'I82078' => 7, 'LsiLogicSas' => 8);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class StorageControllerTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "StorageControllerType";
}

/**
 * Generated VBoxWebService ENUM
 */
class ChipsetType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'PIIX3', 2 => 'ICH9');
    public $ValueMap = array('Null' => 0, 'PIIX3' => 1, 'ICH9' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class ChipsetTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "ChipsetType";
}

/**
 * Generated VBoxWebService ENUM
 */
class NATAliasMode extends VBox_Enum
{
    public $NameMap = array(0x1 => 'AliasLog', 0x02 => 'AliasProxyOnly', 0x04 => 'AliasUseSamePorts');
    public $ValueMap = array('AliasLog' => 0x1, 'AliasProxyOnly' => 0x02, 'AliasUseSamePorts' => 0x04);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class NATAliasModeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "NATAliasMode";
}

/**
 * Generated VBoxWebService ENUM
 */
class NATProtocol extends VBox_Enum
{
    public $NameMap = array(0 => 'UDP', 1 => 'TCP');
    public $ValueMap = array('UDP' => 0, 'TCP' => 1);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class NATProtocolCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "NATProtocol";
}

/**
 * Generated VBoxWebService ENUM
 */
class BandwidthGroupType extends VBox_Enum
{
    public $NameMap = array(0 => 'Null', 1 => 'Disk', 2 => 'Network');
    public $ValueMap = array('Null' => 0, 'Disk' => 1, 'Network' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class BandwidthGroupTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "BandwidthGroupType";
}

/**
 * Generated VBoxWebService ENUM
 */
class VBoxEventType extends VBox_Enum
{
    public $NameMap = array(0 => 'Invalid', 1 => 'Any', 2 => 'Vetoable', 3 => 'MachineEvent', 4 => 'SnapshotEvent', 5 => 'InputEvent', 31 => 'LastWildcard', 32 => 'OnMachineStateChanged', 33 => 'OnMachineDataChanged', 34 => 'OnExtraDataChanged', 35 => 'OnExtraDataCanChange', 36 => 'OnMediumRegistered', 37 => 'OnMachineRegistered', 38 => 'OnSessionStateChanged', 39 => 'OnSnapshotTaken', 40 => 'OnSnapshotDeleted', 41 => 'OnSnapshotChanged', 42 => 'OnGuestPropertyChanged', 43 => 'OnMousePointerShapeChanged', 44 => 'OnMouseCapabilityChanged', 45 => 'OnKeyboardLedsChanged', 46 => 'OnStateChanged', 47 => 'OnAdditionsStateChanged', 48 => 'OnNetworkAdapterChanged', 49 => 'OnSerialPortChanged', 50 => 'OnParallelPortChanged', 51 => 'OnStorageControllerChanged', 52 => 'OnMediumChanged', 53 => 'OnVRDEServerChanged', 54 => 'OnUSBControllerChanged', 55 => 'OnUSBDeviceStateChanged', 56 => 'OnSharedFolderChanged', 57 => 'OnRuntimeError', 58 => 'OnCanShowWindow', 59 => 'OnShowWindow', 60 => 'OnCPUChanged', 61 => 'OnVRDEServerInfoChanged', 62 => 'OnEventSourceChanged', 63 => 'OnCPUExecutionCapChanged', 64 => 'OnGuestKeyboard', 65 => 'OnGuestMouse', 66 => 'OnNATRedirect', 67 => 'OnHostPCIDevicePlug', 68 => 'OnVBoxSVCAvailabilityChanged', 69 => 'OnBandwidthGroupChanged', 70 => 'OnGuestMonitorChanged', 71 => 'OnStorageDeviceChanged', 72 => 'OnClipboardModeChanged', 73 => 'OnDragAndDropModeChanged', 74 => 'Last');
    public $ValueMap = array('Invalid' => 0, 'Any' => 1, 'Vetoable' => 2, 'MachineEvent' => 3, 'SnapshotEvent' => 4, 'InputEvent' => 5, 'LastWildcard' => 31, 'OnMachineStateChanged' => 32, 'OnMachineDataChanged' => 33, 'OnExtraDataChanged' => 34, 'OnExtraDataCanChange' => 35, 'OnMediumRegistered' => 36, 'OnMachineRegistered' => 37, 'OnSessionStateChanged' => 38, 'OnSnapshotTaken' => 39, 'OnSnapshotDeleted' => 40, 'OnSnapshotChanged' => 41, 'OnGuestPropertyChanged' => 42, 'OnMousePointerShapeChanged' => 43, 'OnMouseCapabilityChanged' => 44, 'OnKeyboardLedsChanged' => 45, 'OnStateChanged' => 46, 'OnAdditionsStateChanged' => 47, 'OnNetworkAdapterChanged' => 48, 'OnSerialPortChanged' => 49, 'OnParallelPortChanged' => 50, 'OnStorageControllerChanged' => 51, 'OnMediumChanged' => 52, 'OnVRDEServerChanged' => 53, 'OnUSBControllerChanged' => 54, 'OnUSBDeviceStateChanged' => 55, 'OnSharedFolderChanged' => 56, 'OnRuntimeError' => 57, 'OnCanShowWindow' => 58, 'OnShowWindow' => 59, 'OnCPUChanged' => 60, 'OnVRDEServerInfoChanged' => 61, 'OnEventSourceChanged' => 62, 'OnCPUExecutionCapChanged' => 63, 'OnGuestKeyboard' => 64, 'OnGuestMouse' => 65, 'OnNATRedirect' => 66, 'OnHostPCIDevicePlug' => 67, 'OnVBoxSVCAvailabilityChanged' => 68, 'OnBandwidthGroupChanged' => 69, 'OnGuestMonitorChanged' => 70, 'OnStorageDeviceChanged' => 71, 'OnClipboardModeChanged' => 72, 'OnDragAndDropModeChanged' => 73, 'Last' => 74);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class VBoxEventTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "VBoxEventType";
}

/**
 * Generated VBoxWebService ENUM
 */
class GuestMonitorChangedEventType extends VBox_Enum
{
    public $NameMap = array(0 => 'Enabled', 1 => 'Disabled', 2 => 'NewOrigin');
    public $ValueMap = array('Enabled' => 0, 'Disabled' => 1, 'NewOrigin' => 2);
}

/**
 * Generated VBoxWebService Enum Collection
 */
class GuestMonitorChangedEventTypeCollection extends VBox_EnumCollection
{
    protected $_interfaceName = "GuestMonitorChangedEventType";
}
