#ifdef SEMASTART
__SEMASTART = DIAG_START_SEMA,
#undef SEMASTART
#endif

DIAG(err_abstract_type_in_decl, CLASS_ERROR, diag::MAP_ERROR, "%select{return|parameter|variable|field|instance variable}0 type %1 is an abstract class", 0, true, false, false, false, 2)
DIAG(err_access, CLASS_ERROR, diag::MAP_ERROR, "%1 is a %select{private|protected}0 member of %3", 0, true, true, false, false, 2)
DIAG(err_access_base_ctor, CLASS_ERROR, diag::MAP_ERROR, "%select{base class|inherited virtual base class}0 %1 has %select{private|protected}3 %select{default |copy |move |*ERROR* |*ERROR* |*ERROR*|}2constructor", 0, true, true, false, false, 2)
DIAG(err_access_ctor, CLASS_ERROR, diag::MAP_ERROR, "calling a %select{private|protected}0 constructor of class %2", 0, true, true, false, false, 2)
DIAG(err_access_dtor, CLASS_ERROR, diag::MAP_ERROR, "calling a %select{private|protected}1 destructor of class %0", 0, true, true, false, false, 2)
DIAG(err_access_dtor_base, CLASS_ERROR, diag::MAP_ERROR, "base class %0 has %select{private|protected}1 destructor", 0, true, true, false, false, 2)
DIAG(err_access_dtor_exception, CLASS_ERROR, diag::MAP_ERROR, "exception object of type %0 has %select{private|protected}1 destructor", 0, true, true, false, false, 2)
DIAG(err_access_dtor_field, CLASS_ERROR, diag::MAP_ERROR, "field of type %1 has %select{private|protected}2 destructor", 0, true, true, false, false, 2)
DIAG(err_access_dtor_ivar, CLASS_ERROR, diag::MAP_ERROR, "instance variable of type %0 has %select{private|protected}1 destructor", 0, true, true, false, false, 2)
DIAG(err_access_dtor_temp, CLASS_ERROR, diag::MAP_ERROR, "temporary of type %0 has %select{private|protected}1 destructor", 0, true, true, false, false, 2)
DIAG(err_access_dtor_var, CLASS_ERROR, diag::MAP_ERROR, "variable of type %1 has %select{private|protected}2 destructor", 0, true, true, false, false, 2)
DIAG(err_access_dtor_vbase, CLASS_ERROR, diag::MAP_ERROR, "inherited virtual base class %0 has %select{private|protected}1 destructor", 0, true, true, false, false, 2)
DIAG(err_access_field_ctor, CLASS_ERROR, diag::MAP_ERROR, "field of type %0 has %select{private|protected}2 %select{default |copy |move |*ERROR* |*ERROR* |*ERROR* |}1constructor", 0, true, true, false, false, 2)
DIAG(err_access_friend_function, CLASS_ERROR, diag::MAP_ERROR, "friend function %1 is a %select{private|protected}0 member of %3", 0, true, true, false, false, 2)
DIAG(err_access_lambda_capture, CLASS_ERROR, diag::MAP_ERROR, "capture of variable '%0' as type %1 calls %select{private|protected}3 %select{default |copy |move |*ERROR* |*ERROR* |*ERROR* |}2constructor", 0, true, true, false, false, 3)
DIAG(err_addr_ovl_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 is ambiguous", 0, true, false, false, false, 2)
DIAG(err_addr_ovl_no_qualifier, CLASS_ERROR, diag::MAP_ERROR, "can't form member pointer of type %0 without '&' and class name", 0, true, false, false, false, 2)
DIAG(err_addr_ovl_no_viable, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 does not match required type %1", 0, true, false, false, false, 2)
DIAG(err_addr_ovl_not_func_ptrref, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 cannot be converted to type %1", 0, true, false, false, false, 2)
DIAG(err_address_space_qualified_delete, CLASS_ERROR, diag::MAP_ERROR, "'delete' cannot delete objects of type %0 in address space '%1'", 0, true, false, false, false, 2)
DIAG(err_address_space_qualified_new, CLASS_ERROR, diag::MAP_ERROR, "'new' cannot allocate objects of type %0 in address space '%1'", 0, true, false, false, false, 2)
DIAG(err_alias_not_supported_on_darwin, CLASS_ERROR, diag::MAP_ERROR, "only weak aliases are supported on darwin", 0, true, false, false, false, 2)
DIAG(err_alias_template_extra_headers, CLASS_ERROR, diag::MAP_ERROR, "extraneous template parameter list in alias template declaration", 0, true, false, false, false, 2)
DIAG(err_aligned_attribute_argument_not_int, CLASS_ERROR, diag::MAP_ERROR, "'aligned' attribute requires integer constant", 0, true, false, false, false, 2)
DIAG(err_allocation_of_abstract_type, CLASS_ERROR, diag::MAP_ERROR, "allocating an object of abstract class type %0", 0, true, false, false, false, 2)
DIAG(err_altivec_empty_initializer, CLASS_ERROR, diag::MAP_ERROR, "expected initializer", 0, true, false, false, false, 2)
DIAG(err_ambiguous_base_to_derived_cast, CLASS_ERROR, diag::MAP_ERROR, "ambiguous cast from base %0 to derived %1:%2", 0, true, false, false, false, 2)
DIAG(err_ambiguous_delete_operand, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion of delete expression of type %0 to a pointer", 0, true, false, false, false, 2)
DIAG(err_ambiguous_derived_to_base_conv, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion from derived class %0 to base class %1:%2", 0, true, false, false, false, 2)
DIAG(err_ambiguous_member_multiple_subobject_types, CLASS_ERROR, diag::MAP_ERROR, "member %0 found in multiple base classes of different types", 0, true, false, false, false, 2)
DIAG(err_ambiguous_member_multiple_subobjects, CLASS_ERROR, diag::MAP_ERROR, "non-static member %0 found in multiple base-class subobjects of type %1:%2", 0, true, false, false, false, 2)
DIAG(err_ambiguous_memptr_conv, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion from pointer to member of %select{base|derived}0 class %1 to pointer to member of %select{derived|base}0 class %2:%3", 0, true, false, false, false, 2)
DIAG(err_ambiguous_reference, CLASS_ERROR, diag::MAP_ERROR, "reference to %0 is ambiguous", 0, true, false, false, false, 2)
DIAG(err_ambiguous_suitable_delete_member_function_found, CLASS_ERROR, diag::MAP_ERROR, "multiple suitable %0 functions in %1", 0, true, false, false, false, 2)
DIAG(err_ambiguous_tag_hiding, CLASS_ERROR, diag::MAP_ERROR, "a type named %0 is hidden by a declaration in a different namespace", 0, true, false, false, false, 2)
DIAG(err_anon_bitfield_has_negative_width, CLASS_ERROR, diag::MAP_ERROR, "anonymous bit-field has negative width (%0)", 0, true, false, false, false, 2)
DIAG(err_anon_bitfield_width_exceeds_type_size, CLASS_ERROR, diag::MAP_ERROR, "size of anonymous bit-field (%0 bits) exceeds size of its type (%1 bits)", 0, true, false, false, false, 2)
DIAG(err_anonymous_record_bad_member, CLASS_ERROR, diag::MAP_ERROR, "anonymous %select{struct|union}0 can only contain non-static data members", 0, true, false, false, false, 2)
DIAG(err_anonymous_record_nonpublic_member, CLASS_ERROR, diag::MAP_ERROR, "anonymous %select{struct|union}0 cannot contain a %select{private|protected}1 data member", 0, true, false, false, false, 2)
DIAG(err_anonymous_record_with_function, CLASS_ERROR, diag::MAP_ERROR, "functions cannot be declared in an anonymous %select{struct|union}0", 0, true, false, false, false, 2)
DIAG(err_anonymous_record_with_static, CLASS_ERROR, diag::MAP_ERROR, "static members cannot be declared in an anonymous %select{struct|union}0", 0, true, false, false, false, 2)
DIAG(err_anonymous_record_with_type, CLASS_ERROR, diag::MAP_ERROR, "types cannot be declared in an anonymous %select{struct|union}0", 0, true, false, false, false, 2)
DIAG(err_anonymous_struct_member_redecl, CLASS_ERROR, diag::MAP_ERROR, "member of anonymous struct redeclares %0", 0, true, false, false, false, 2)
DIAG(err_anonymous_struct_not_member, CLASS_ERROR, diag::MAP_ERROR, "anonymous %select{structs|structs and classes}0 must be %select{struct or union|class}0 members", 0, true, false, false, false, 2)
DIAG(err_anonymous_union_member_redecl, CLASS_ERROR, diag::MAP_ERROR, "member of anonymous union redeclares %0", 0, true, false, false, false, 2)
DIAG(err_anonymous_union_not_static, CLASS_ERROR, diag::MAP_ERROR, "anonymous unions at namespace or global scope must be declared 'static'", 0, true, false, false, false, 2)
DIAG(err_anonymous_union_with_storage_spec, CLASS_ERROR, diag::MAP_ERROR, "anonymous union at class scope must not have a storage specifier", 0, true, false, false, false, 2)
DIAG(err_arc_array_param_no_ownership, CLASS_ERROR, diag::MAP_ERROR, "must explicitly describe intended ownership of an object array parameter", 0, true, false, false, false, 5)
DIAG(err_arc_assign_property_ownership, CLASS_ERROR, diag::MAP_ERROR, "existing instance variable %1 for property %0 with %select{unsafe_unretained| assign}2 attribute must be __unsafe_unretained", 0, true, false, false, false, 6)
DIAG(err_arc_atomic_ownership, CLASS_ERROR, diag::MAP_ERROR, "cannot perform atomic operation on a pointer to type %0: type has non-trivial ownership", 0, true, false, false, false, 5)
DIAG(err_arc_autoreleasing_capture, CLASS_ERROR, diag::MAP_ERROR, "cannot capture __autoreleasing variable in a %select{block|lambda by copy}0", 0, true, false, false, false, 5)
DIAG(err_arc_autoreleasing_var, CLASS_ERROR, diag::MAP_ERROR, "%select{__block variables|global variables|fields|instance variables}0 cannot have __autoreleasing ownership", 0, true, false, false, false, 5)
DIAG(err_arc_bridge_cast_incompatible, CLASS_ERROR, diag::MAP_ERROR, "incompatible types casting %0 to %1 with a %select{__bridge|__bridge_transfer|__bridge_retained}2 cast", 0, true, false, false, false, 7)
DIAG(err_arc_bridge_cast_wrong_kind, CLASS_ERROR, diag::MAP_ERROR, "cast of %select{Objective-C|block|C}0 pointer type %1 to %select{Objective-C|block|C}2 pointer type %3 cannot use %select{__bridge|__bridge_transfer|__bridge_retained}4", 0, true, false, false, false, 7)
DIAG(err_arc_cast_requires_bridge, CLASS_ERROR, diag::MAP_ERROR, "%select{cast|implicit conversion}0 of %select{Objective-C|block|C}1 pointer type %2 to %select{Objective-C|block|C}3 pointer type %4 requires a bridged cast", 0, true, false, false, false, 7)
DIAG(err_arc_collection_forward, CLASS_ERROR, diag::MAP_ERROR, "collection expression type %0 is a forward declaration", 0, true, false, false, false, 5)
DIAG(err_arc_convesion_of_weak_unavailable, CLASS_ERROR, diag::MAP_ERROR, "%select{implicit conversion|cast}0 of weak-unavailable object of type %1 to a __weak object of type %2", 0, true, false, false, false, 9)
DIAG(err_arc_gained_method_convention, CLASS_ERROR, diag::MAP_ERROR, "method implementation does not match its declaration", 0, true, false, false, false, 5)
DIAG(err_arc_illegal_explicit_message, CLASS_ERROR, diag::MAP_ERROR, "ARC forbids explicit message send of %0", 0, true, false, false, false, 10)
DIAG(err_arc_illegal_method_def, CLASS_ERROR, diag::MAP_ERROR, "ARC forbids implementation of %0", 0, true, false, false, false, 10)
DIAG(err_arc_illegal_selector, CLASS_ERROR, diag::MAP_ERROR, "ARC forbids use of %0 in a @selector", 0, true, false, false, false, 10)
DIAG(err_arc_inconsistent_property_ownership, CLASS_ERROR, diag::MAP_ERROR, "%select{|unsafe_unretained|strong|weak}1 property %0 may not also be declared %select{|__unsafe_unretained|__strong|__weak|__autoreleasing}2", 0, true, false, false, false, 6)
DIAG(err_arc_indirect_no_ownership, CLASS_ERROR, diag::MAP_ERROR, "%select{pointer|reference}1 to non-const type %0 with no explicit ownership", 0, true, false, false, false, 5)
DIAG(err_arc_init_method_unrelated_result_type, CLASS_ERROR, diag::MAP_ERROR, "init methods must return a type related to the receiver type", 0, true, false, false, false, 5)
DIAG(err_arc_lost_method_convention, CLASS_ERROR, diag::MAP_ERROR, "method was declared as %select{an 'alloc'|a 'copy'|an 'init'|a 'new'}0 method, but its implementation doesn't match because %select{its result type is not an object pointer|its result type is unrelated to its receiver type}1", 0, true, false, false, false, 5)
DIAG(err_arc_may_not_respond, CLASS_ERROR, diag::MAP_ERROR, "no visible @interface for %0 declares the selector %1", 0, true, false, false, false, 5)
DIAG(err_arc_method_not_found, CLASS_ERROR, diag::MAP_ERROR, "no known %select{instance|class}1 method for selector %0", 0, true, false, false, false, 5)
DIAG(err_arc_mismatched_cast, CLASS_ERROR, diag::MAP_ERROR, "%select{implicit conversion|cast}0 of %select{%2|a non-Objective-C pointer type %2|a block pointer|an Objective-C pointer|an indirect pointer to an Objective-C pointer}1 to %3 is disallowed with ARC", 0, true, false, false, false, 10)
DIAG(err_arc_multiple_method_decl, CLASS_ERROR, diag::MAP_ERROR, "multiple methods named %0 found with mismatched result, parameter type or attributes", 0, true, false, false, false, 5)
DIAG(err_arc_new_array_without_ownership, CLASS_ERROR, diag::MAP_ERROR, "'new' cannot allocate an array of %0 with no explicit ownership", 0, true, false, false, false, 5)
DIAG(err_arc_nolifetime_behavior, CLASS_ERROR, diag::MAP_ERROR, "explicit ownership qualifier on cast result has no effect", 0, true, false, false, false, 10)
DIAG(err_arc_nonlocal_writeback, CLASS_ERROR, diag::MAP_ERROR, "passing address of %select{non-local|non-scalar}0 object to __autoreleasing parameter for write-back", 0, true, false, false, false, 5)
DIAG(err_arc_objc_object_in_struct, CLASS_ERROR, diag::MAP_ERROR, "ARC forbids %select{Objective-C objects|blocks}0 in structs or unions", 0, true, false, false, false, 10)
DIAG(err_arc_objc_property_default_assign_on_object, CLASS_ERROR, diag::MAP_ERROR, "ARC forbids synthesizing a property of an Objective-C object with unspecified ownership or storage attribute", 0, true, false, false, false, 10)
DIAG(err_arc_perform_selector_retains, CLASS_ERROR, diag::MAP_ERROR, "performSelector names a selector which retains the object", 0, true, false, false, false, 2)
DIAG(err_arc_pseudo_dtor_inconstant_quals, CLASS_ERROR, diag::MAP_ERROR, "pseudo-destructor destroys object of type %0 with inconsistently-qualified type %1", 0, true, false, false, false, 5)
DIAG(err_arc_receiver_forward_class, CLASS_ERROR, diag::MAP_ERROR, "receiver %0 for class message is a forward declaration", 0, true, false, false, false, 5)
DIAG(err_arc_receiver_forward_instance, CLASS_ERROR, diag::MAP_ERROR, "receiver type %0 for instance message is a forward declaration", 0, true, false, false, false, 5)
DIAG(err_arc_strong_property_ownership, CLASS_ERROR, diag::MAP_ERROR, "existing instance variable %1 for strong property %0 may not be %select{|__unsafe_unretained||__weak}2", 0, true, false, false, false, 6)
DIAG(err_arc_thread_ownership, CLASS_ERROR, diag::MAP_ERROR, "thread-local variable has non-trivial ownership: type is %0", 0, true, false, false, false, 5)
DIAG(err_arc_unsupported_weak_class, CLASS_ERROR, diag::MAP_ERROR, "class is incompatible with __weak references", 0, true, false, false, false, 9)
DIAG(err_arc_unused_init_message, CLASS_ERROR, diag::MAP_ERROR, "the result of a delegate init call must be immediately returned or assigned to 'self'", 0, true, false, false, false, 10)
DIAG(err_arc_weak_no_runtime, CLASS_ERROR, diag::MAP_ERROR, "the current deployment target does not support automated __weak references", 0, true, false, false, false, 9)
DIAG(err_arc_weak_unavailable_assign, CLASS_ERROR, diag::MAP_ERROR, "assignment of a weak-unavailable object to a __weak object", 0, true, false, false, false, 9)
DIAG(err_arc_weak_unavailable_property, CLASS_ERROR, diag::MAP_ERROR, "synthesis of a weak-unavailable property is disallowed because it requires synthesis of an instance variable of the __weak object", 0, true, false, false, false, 9)
DIAG(err_arg_with_address_space, CLASS_ERROR, diag::MAP_ERROR, "parameter may not be qualified with an address space", 0, true, false, false, false, 2)
DIAG(err_argument_invalid_range, CLASS_ERROR, diag::MAP_ERROR, "argument should be a value from %0 to %1", 0, true, false, false, false, 2)
DIAG(err_arithmetic_nonfragile_interface, CLASS_ERROR, diag::MAP_ERROR, "arithmetic on pointer to interface %0, which is not a constant size for this architecture and platform", 0, true, false, false, false, 2)
DIAG(err_array_designator_empty_range, CLASS_ERROR, diag::MAP_ERROR, "array designator range [%0, %1] is empty", 0, true, false, false, false, 2)
DIAG(err_array_designator_negative, CLASS_ERROR, diag::MAP_ERROR, "array designator value '%0' is negative", 0, true, false, false, false, 2)
DIAG(err_array_designator_non_array, CLASS_ERROR, diag::MAP_ERROR, "array designator cannot initialize non-array type %0", 0, true, false, false, false, 2)
DIAG(err_array_designator_too_large, CLASS_ERROR, diag::MAP_ERROR, "array designator index (%0) exceeds array bounds (%1)", 0, true, false, false, false, 2)
DIAG(err_array_init_different_type, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize array %diff{of type $ with array of type $|with different type of array}0,1", 0, true, false, false, false, 2)
DIAG(err_array_init_non_constant_array, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize array %diff{of type $ with non-constant array of type $|with different type of array}0,1", 0, true, false, false, false, 2)
DIAG(err_array_init_not_init_list, CLASS_ERROR, diag::MAP_ERROR, "array initializer must be an initializer list%select{| or string literal}0", 0, true, false, false, false, 2)
DIAG(err_array_new_needs_size, CLASS_ERROR, diag::MAP_ERROR, "array size must be specified in new expressions", 0, true, false, false, false, 2)
DIAG(err_array_of_abstract_type, CLASS_ERROR, diag::MAP_ERROR, "array of abstract class type %0", 0, true, false, false, false, 2)
DIAG(err_array_size_ambiguous_conversion, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion of array size expression of type %0 to an integral or enumeration type", 0, true, false, false, false, 2)
DIAG(err_array_size_explicit_conversion, CLASS_ERROR, diag::MAP_ERROR, "array size expression of type %0 requires explicit conversion to type %1", 0, true, false, false, false, 2)
DIAG(err_array_size_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "array size expression has incomplete class type %0", 0, true, false, false, false, 2)
DIAG(err_array_size_non_int, CLASS_ERROR, diag::MAP_ERROR, "size of array has non-integer type %0", 0, true, false, false, false, 2)
DIAG(err_array_size_not_integral, CLASS_ERROR, diag::MAP_ERROR, "array size expression must have integral or %select{|unscoped }0enumeration type, not %1", 0, true, false, false, false, 2)
DIAG(err_array_star_in_function_definition, CLASS_ERROR, diag::MAP_ERROR, "variable length array must be bound in function definition", 0, true, false, false, false, 2)
DIAG(err_array_star_outside_prototype, CLASS_ERROR, diag::MAP_ERROR, "star modifier used outside of function prototype", 0, true, false, false, false, 2)
DIAG(err_array_static_not_outermost, CLASS_ERROR, diag::MAP_ERROR, "%0 used in non-outermost array type derivation", 0, true, false, false, false, 2)
DIAG(err_array_static_outside_prototype, CLASS_ERROR, diag::MAP_ERROR, "%0 used in array declarator outside of function prototype", 0, true, false, false, false, 2)
DIAG(err_array_too_large, CLASS_ERROR, diag::MAP_ERROR, "array is too large (%0 elements)", 0, true, false, false, false, 2)
DIAG(err_as_qualified_auto_decl, CLASS_ERROR, diag::MAP_ERROR, "automatic variable qualified with an address space", 0, true, false, false, false, 2)
DIAG(err_asm_empty, CLASS_ERROR, diag::MAP_ERROR, "__asm used with no assembly instructions", 0, true, false, false, false, 11)
DIAG(err_asm_invalid_input_constraint, CLASS_ERROR, diag::MAP_ERROR, "invalid input constraint '%0' in asm", 0, true, false, false, false, 11)
DIAG(err_asm_invalid_lvalue_in_input, CLASS_ERROR, diag::MAP_ERROR, "invalid lvalue in asm input for constraint '%0'", 0, true, false, false, false, 11)
DIAG(err_asm_invalid_lvalue_in_output, CLASS_ERROR, diag::MAP_ERROR, "invalid lvalue in asm output", 0, true, false, false, false, 11)
DIAG(err_asm_invalid_output_constraint, CLASS_ERROR, diag::MAP_ERROR, "invalid output constraint '%0' in asm", 0, true, false, false, false, 11)
DIAG(err_asm_invalid_type_in_input, CLASS_ERROR, diag::MAP_ERROR, "invalid type %0 in asm input for constraint '%1'", 0, true, false, false, false, 11)
DIAG(err_asm_tying_incompatible_types, CLASS_ERROR, diag::MAP_ERROR, "unsupported inline asm: input with type %diff{$ matching output with type $|}0,1", 0, true, false, false, false, 11)
DIAG(err_asm_unknown_register_name, CLASS_ERROR, diag::MAP_ERROR, "unknown register name '%0' in asm", 0, true, false, false, false, 11)
DIAG(err_asm_wide_character, CLASS_ERROR, diag::MAP_ERROR, "wide string is invalid in 'asm'", 0, true, false, false, false, 11)
DIAG(err_assoc_compatible_types, CLASS_ERROR, diag::MAP_ERROR, "type %0 in generic association compatible with previously specified type %1", 0, true, false, false, false, 2)
DIAG(err_assoc_type_incomplete, CLASS_ERROR, diag::MAP_ERROR, "type %0 in generic association incomplete", 0, true, false, false, false, 2)
DIAG(err_assoc_type_nonobject, CLASS_ERROR, diag::MAP_ERROR, "type %0 in generic association not an object type", 0, true, false, false, false, 2)
DIAG(err_assoc_type_variably_modified, CLASS_ERROR, diag::MAP_ERROR, "type %0 in generic association is a variably modified type", 0, true, false, false, false, 2)
DIAG(err_atdef_nonfragile_interface, CLASS_ERROR, diag::MAP_ERROR, "use of @defs is not supported on this architecture and platform", 0, true, false, false, false, 2)
DIAG(err_atomic_builtin_must_be_pointer, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic builtin must be a pointer (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_atomic_builtin_must_be_pointer_intptr, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic builtin must be a pointer to integer or pointer (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_atomic_builtin_pointer_size, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic builtin must be a pointer to 1,2,4,8 or 16 byte type (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_atomic_op_bitwise_needs_atomic_int, CLASS_ERROR, diag::MAP_ERROR, "first argument to bitwise atomic operation must be a pointer to %select{|atomic }0integer (%1 invalid)", 0, true, false, false, false, 2)
DIAG(err_atomic_op_needs_atomic, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic operation must be a pointer to _Atomic type (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_atomic_op_needs_atomic_int_or_ptr, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic operation must be a pointer to %select{|atomic }0integer or pointer (%1 invalid)", 0, true, false, false, false, 2)
DIAG(err_atomic_op_needs_non_const_atomic, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic operation must be a pointer to non-const _Atomic type (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_atomic_op_needs_trivial_copy, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic operation must be a pointer to a trivially-copyable type (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_atomic_property_nontrivial_assign_op, CLASS_ERROR, diag::MAP_ERROR, "atomic property of reference type %0 cannot have non-trivial assignment operator", 0, true, false, false, false, 2)
DIAG(err_atomic_specifier_bad_type, CLASS_ERROR, diag::MAP_ERROR, "_Atomic cannot be applied to %select{incomplete |array |function |reference |atomic |qualified |}0type %1 %select{||||||which is not trivially copyable}0", 0, true, false, false, false, 2)
DIAG(err_attr_objc_ownership_redundant, CLASS_ERROR, diag::MAP_ERROR, "the type %0 is already explicitly ownership-qualified", 0, true, false, false, false, 2)
DIAG(err_attr_tlsmodel_arg, CLASS_ERROR, diag::MAP_ERROR, "tls_model must be \"global-dynamic\", \"local-dynamic\", \"initial-exec\" or \"local-exec\"", 0, true, false, false, false, 2)
DIAG(err_attr_wrong_decl, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute invalid on this declaration, requires typedef or value", 0, true, false, false, false, 2)
DIAG(err_attribute_address_function_type, CLASS_ERROR, diag::MAP_ERROR, "function type may not be qualified with an address space", 0, true, false, false, false, 2)
DIAG(err_attribute_address_multiple_qualifiers, CLASS_ERROR, diag::MAP_ERROR, "multiple address spaces specified for type", 0, true, false, false, false, 2)
DIAG(err_attribute_address_space_negative, CLASS_ERROR, diag::MAP_ERROR, "address space is negative", 0, true, false, false, false, 2)
DIAG(err_attribute_address_space_not_int, CLASS_ERROR, diag::MAP_ERROR, "address space attribute requires an integer constant", 0, true, false, false, false, 2)
DIAG(err_attribute_address_space_too_high, CLASS_ERROR, diag::MAP_ERROR, "address space is larger than the maximum supported (%0)", 0, true, false, false, false, 2)
DIAG(err_attribute_aligned_greater_than_8192, CLASS_ERROR, diag::MAP_ERROR, "requested alignment must be 8192 bytes or smaller", 0, true, false, false, false, 2)
DIAG(err_attribute_aligned_not_power_of_two, CLASS_ERROR, diag::MAP_ERROR, "requested alignment is not a power of 2", 0, true, false, false, false, 2)
DIAG(err_attribute_argument_n_not_identifier, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute requires parameter %1 to be an identifier", 0, true, false, false, false, 2)
DIAG(err_attribute_argument_n_not_int, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute requires parameter %1 to be an integer constant", 0, true, false, false, false, 2)
DIAG(err_attribute_argument_n_not_string, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute requires parameter %1 to be a string", 0, true, false, false, false, 2)
DIAG(err_attribute_argument_not_class, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute requires arguments that are class type or point to class type", 0, true, false, false, false, 2)
DIAG(err_attribute_argument_not_int, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute requires integer constant", 0, true, false, false, false, 2)
DIAG(err_attribute_argument_out_of_bounds, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute parameter %1 is out of bounds", 0, true, false, false, false, 2)
DIAG(err_attribute_argument_out_of_range, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute parameter %1 is out of bounds: %plural{0:no parameters to index into|1:can only be 1, since there is one parameter|:must be between 1 and %2}2", 0, true, false, false, false, 2)
DIAG(err_attribute_argument_outof_range, CLASS_ERROR, diag::MAP_ERROR, "init_priority attribute requires integer constant between 101 and 65535 inclusive", 0, true, false, false, false, 2)
DIAG(err_attribute_bad_neon_vector_size, CLASS_ERROR, diag::MAP_ERROR, "Neon vector size must be 64 or 128 bits", 0, true, false, false, false, 2)
DIAG(err_attribute_can_be_applied_only_to_symbol_declaration, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute can be applied only to symbol declaration", 0, true, false, false, false, 2)
DIAG(err_attribute_can_be_applied_only_to_value_decl, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute can only be applied to value declarations", 0, true, false, false, false, 2)
DIAG(err_attribute_cleanup_arg_not_found, CLASS_ERROR, diag::MAP_ERROR, "'cleanup' argument %0 not found", 0, true, false, false, false, 2)
DIAG(err_attribute_cleanup_arg_not_function, CLASS_ERROR, diag::MAP_ERROR, "'cleanup' argument %0 is not a function", 0, true, false, false, false, 2)
DIAG(err_attribute_cleanup_func_arg_incompatible_type, CLASS_ERROR, diag::MAP_ERROR, "'cleanup' function %0 parameter has %diff{type $ which is incompatible with type $|incompatible type}1,2", 0, true, false, false, false, 2)
DIAG(err_attribute_cleanup_func_must_take_one_arg, CLASS_ERROR, diag::MAP_ERROR, "'cleanup' function %0 must take 1 parameter", 0, true, false, false, false, 2)
DIAG(err_attribute_first_argument_not_int_or_bool, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute first argument must be of int or bool type", 0, true, false, false, false, 2)
DIAG(err_attribute_invalid_implicit_this_argument, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute is invalid for the implicit this argument", 0, true, false, false, false, 2)
DIAG(err_attribute_invalid_size, CLASS_ERROR, diag::MAP_ERROR, "vector size not an integral multiple of component size", 0, true, false, false, false, 2)
DIAG(err_attribute_invalid_vector_type, CLASS_ERROR, diag::MAP_ERROR, "invalid vector element type %0", 0, true, false, false, false, 2)
DIAG(err_attribute_missing_parameter_name, CLASS_ERROR, diag::MAP_ERROR, "attribute requires unquoted parameter", 0, true, false, false, false, 2)
DIAG(err_attribute_multiple_objc_gc, CLASS_ERROR, diag::MAP_ERROR, "multiple garbage collection attributes specified for type", 0, true, false, false, false, 2)
DIAG(err_attribute_not_string, CLASS_ERROR, diag::MAP_ERROR, "argument to %0 attribute was not a string literal", 0, true, false, false, false, 2)
DIAG(err_attribute_overloadable_missing, CLASS_ERROR, diag::MAP_ERROR, "%select{overloaded function|redeclaration of}0 %1 must have the 'overloadable' attribute", 0, true, false, false, false, 2)
DIAG(err_attribute_overloadable_no_prototype, CLASS_ERROR, diag::MAP_ERROR, "'overloadable' function %0 must have a prototype", 0, true, false, false, false, 2)
DIAG(err_attribute_overloadable_not_function, CLASS_ERROR, diag::MAP_ERROR, "'overloadable' attribute can only be applied to a function", 0, true, false, false, false, 2)
DIAG(err_attribute_pointers_only, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute only applies to pointer arguments", 0, true, false, false, false, 2)
DIAG(err_attribute_regparm_invalid_number, CLASS_ERROR, diag::MAP_ERROR, "'regparm' parameter must be between 0 and %0 inclusive", 0, true, false, false, false, 2)
DIAG(err_attribute_regparm_wrong_platform, CLASS_ERROR, diag::MAP_ERROR, "'regparm' is not valid on this platform", 0, true, false, false, false, 2)
DIAG(err_attribute_requires_objc_interface, CLASS_ERROR, diag::MAP_ERROR, "attribute may only be applied to an Objective-C interface", 0, true, false, false, false, 2)
DIAG(err_attribute_section_invalid_for_target, CLASS_ERROR, diag::MAP_ERROR, "argument to 'section' attribute is not valid for this target: %0", 0, true, false, false, false, 2)
DIAG(err_attribute_section_local_variable, CLASS_ERROR, diag::MAP_ERROR, "'section' attribute is not valid on local variables", 0, true, false, false, false, 2)
DIAG(err_attribute_sentinel_less_than_zero, CLASS_ERROR, diag::MAP_ERROR, "'sentinel' parameter 1 less than zero", 0, true, false, false, false, 2)
DIAG(err_attribute_sentinel_not_zero_or_one, CLASS_ERROR, diag::MAP_ERROR, "'sentinel' parameter 2 not 0 or 1", 0, true, false, false, false, 2)
DIAG(err_attribute_too_few_arguments, CLASS_ERROR, diag::MAP_ERROR, "attribute takes at least %0 argument%s0", 0, true, false, false, false, 2)
DIAG(err_attribute_too_many_arguments, CLASS_ERROR, diag::MAP_ERROR, "attribute takes no more than %0 argument%s0", 0, true, false, false, false, 2)
DIAG(err_attribute_uuid_malformed_guid, CLASS_ERROR, diag::MAP_ERROR, "uuid attribute contains a malformed GUID", 0, true, false, false, false, 2)
DIAG(err_attribute_vecreturn_only_pod_record, CLASS_ERROR, diag::MAP_ERROR, "the vecreturn attribute can only be used on a POD (plain old data) class or structure (i.e. no virtual functions)", 0, true, false, false, false, 2)
DIAG(err_attribute_vecreturn_only_vector_member, CLASS_ERROR, diag::MAP_ERROR, "the vecreturn attribute can only be used on a class or structure with one member, which must be a vector", 0, true, false, false, false, 2)
DIAG(err_attribute_weak_static, CLASS_ERROR, diag::MAP_ERROR, "weak declaration cannot have internal linkage", 0, true, false, false, false, 2)
DIAG(err_attribute_weakref_not_global_context, CLASS_ERROR, diag::MAP_ERROR, "weakref declaration of '%0' must be in a global context", 0, true, false, false, false, 2)
DIAG(err_attribute_weakref_not_static, CLASS_ERROR, diag::MAP_ERROR, "weakref declaration must have internal linkage", 0, true, false, false, false, 2)
DIAG(err_attribute_weakref_without_alias, CLASS_ERROR, diag::MAP_ERROR, "weakref declaration of '%0' must also have an alias attribute", 0, true, false, false, false, 2)
DIAG(err_attribute_wrong_decl_type, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute only applies to %select{functions|unions|variables and functions|functions and methods|parameters|functions, methods and blocks|functions, methods, and parameters|classes|variables|methods|variables, functions and labels|fields and global variables|structs|thread-local variables}1", 0, true, false, false, false, 2)
DIAG(err_attribute_wrong_number_arguments, CLASS_ERROR, diag::MAP_ERROR, "attribute %plural{0:takes no arguments|1:takes one argument|:requires exactly %0 arguments}0", 0, true, false, false, false, 2)
DIAG(err_attribute_zero_size, CLASS_ERROR, diag::MAP_ERROR, "zero vector size", 0, true, false, false, false, 2)
DIAG(err_attributes_are_not_compatible, CLASS_ERROR, diag::MAP_ERROR, "%0 and %1 attributes are not compatible", 0, true, false, false, false, 2)
DIAG(err_auto_different_deductions, CLASS_ERROR, diag::MAP_ERROR, "'auto' deduced as %0 in declaration of %1 and deduced as %2 in declaration of %3", 0, true, false, false, false, 2)
DIAG(err_auto_missing_trailing_return, CLASS_ERROR, diag::MAP_ERROR, "'auto' return without trailing return type", 0, true, false, false, false, 2)
DIAG(err_auto_new_ctor_multiple_expressions, CLASS_ERROR, diag::MAP_ERROR, "new expression for type %0 contains multiple constructor arguments", 0, true, false, false, false, 2)
DIAG(err_auto_new_deduction_failure, CLASS_ERROR, diag::MAP_ERROR, "new expression for type %0 has incompatible constructor argument of type %1", 0, true, false, false, false, 2)
DIAG(err_auto_new_requires_ctor_arg, CLASS_ERROR, diag::MAP_ERROR, "new expression for type %0 requires a constructor argument", 0, true, false, false, false, 2)
DIAG(err_auto_new_requires_parens, CLASS_ERROR, diag::MAP_ERROR, "new expression for type %0 cannot use list-initialization", 0, true, false, false, false, 2)
DIAG(err_auto_not_allowed, CLASS_ERROR, diag::MAP_ERROR, "'auto' not allowed %select{in function prototype|in non-static struct member|in non-static union member|in non-static class member|in interface member|in exception declaration|in template parameter|in block literal|in template argument|in typedef|in type alias|in function return type|here}0", 0, true, false, false, false, 2)
DIAG(err_auto_var_deduction_failure, CLASS_ERROR, diag::MAP_ERROR, "variable %0 with type %1 has incompatible initializer of type %2", 0, true, false, false, false, 2)
DIAG(err_auto_var_deduction_failure_from_init_list, CLASS_ERROR, diag::MAP_ERROR, "cannot deduce actual type for variable %0 with type %1 from initializer list", 0, true, false, false, false, 2)
DIAG(err_auto_var_init_multiple_expressions, CLASS_ERROR, diag::MAP_ERROR, "initializer for variable %0 with type %1 contains multiple expressions", 0, true, false, false, false, 2)
DIAG(err_auto_var_init_no_expression, CLASS_ERROR, diag::MAP_ERROR, "initializer for variable %0 with type %1 is empty", 0, true, false, false, false, 2)
DIAG(err_auto_var_requires_init, CLASS_ERROR, diag::MAP_ERROR, "declaration of variable %0 with type %1 requires an initializer", 0, true, false, false, false, 2)
DIAG(err_auto_variable_cannot_appear_in_own_initializer, CLASS_ERROR, diag::MAP_ERROR, "variable %0 declared with 'auto' type cannot appear in its own initializer", 0, true, false, false, false, 2)
DIAG(err_bad_const_cast_dest, CLASS_ERROR, diag::MAP_ERROR, "%select{const_cast||||C-style cast|functional-style cast}0 to %2, which is not a reference, pointer-to-object, or pointer-to-data-member", 0, true, false, false, false, 2)
DIAG(err_bad_cstyle_cast_overload, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 cannot be cast to type %1", 0, true, false, false, false, 2)
DIAG(err_bad_cxx_cast_generic, CLASS_ERROR, diag::MAP_ERROR, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 is not allowed", 0, true, false, false, false, 2)
DIAG(err_bad_cxx_cast_member_pointer_size, CLASS_ERROR, diag::MAP_ERROR, "cannot %select{||reinterpret_cast||C-style cast|}0 from member pointer type %1 to member pointer type %2 of different size", 0, true, false, false, false, 2)
DIAG(err_bad_cxx_cast_qualifiers_away, CLASS_ERROR, diag::MAP_ERROR, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 casts away qualifiers", 0, true, false, false, false, 2)
DIAG(err_bad_cxx_cast_rvalue, CLASS_ERROR, diag::MAP_ERROR, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from rvalue to reference type %2", 0, true, false, false, false, 2)
DIAG(err_bad_cxx_cast_scalar_to_vector_different_size, CLASS_ERROR, diag::MAP_ERROR, "%select{||reinterpret_cast||C-style cast|}0 from scalar %1 to vector %2 of different size", 0, true, false, false, false, 2)
DIAG(err_bad_cxx_cast_vector_to_scalar_different_size, CLASS_ERROR, diag::MAP_ERROR, "%select{||reinterpret_cast||C-style cast|}0 from vector %1 to scalar %2 of different size", 0, true, false, false, false, 2)
DIAG(err_bad_cxx_cast_vector_to_vector_different_size, CLASS_ERROR, diag::MAP_ERROR, "%select{||reinterpret_cast||C-style cast|}0 from vector %1 to vector %2 of different size", 0, true, false, false, false, 2)
DIAG(err_bad_dynamic_cast_incomplete, CLASS_ERROR, diag::MAP_ERROR, "%0 is an incomplete type", 0, true, false, false, false, 2)
DIAG(err_bad_dynamic_cast_not_class, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a class", 0, true, false, false, false, 2)
DIAG(err_bad_dynamic_cast_not_polymorphic, CLASS_ERROR, diag::MAP_ERROR, "%0 is not polymorphic", 0, true, false, false, false, 2)
DIAG(err_bad_dynamic_cast_not_ptr, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a pointer", 0, true, false, false, false, 2)
DIAG(err_bad_dynamic_cast_not_ref_or_ptr, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a reference or pointer", 0, true, false, false, false, 2)
DIAG(err_bad_language, CLASS_ERROR, diag::MAP_ERROR, "unknown linkage language", 0, true, false, false, false, 2)
DIAG(err_bad_lvalue_to_rvalue_cast, CLASS_ERROR, diag::MAP_ERROR, "cannot cast from lvalue of type %1 to rvalue reference type %2; types are not compatible", 0, true, false, false, false, 2)
DIAG(err_bad_memptr_lhs, CLASS_ERROR, diag::MAP_ERROR, "left hand operand to %0 must be a %select{|pointer to }1class compatible with the right hand operand, but is %2", 0, true, false, false, false, 2)
DIAG(err_bad_memptr_rhs, CLASS_ERROR, diag::MAP_ERROR, "right hand operand to %0 has non pointer-to-member type %1", 0, true, false, false, false, 2)
DIAG(err_bad_new_type, CLASS_ERROR, diag::MAP_ERROR, "cannot allocate %select{function|reference}1 type %0 with new", 0, true, false, false, false, 2)
DIAG(err_bad_parameter_name, CLASS_ERROR, diag::MAP_ERROR, "'%0' cannot be the name of a parameter", 0, true, false, false, false, 2)
DIAG(err_bad_receiver_type, CLASS_ERROR, diag::MAP_ERROR, "bad receiver type %0", 0, true, false, false, false, 2)
DIAG(err_bad_reinterpret_cast_overload, CLASS_ERROR, diag::MAP_ERROR, "reinterpret_cast cannot resolve overloaded function %0 to type %1", 0, true, false, false, false, 2)
DIAG(err_bad_reinterpret_cast_reference, CLASS_ERROR, diag::MAP_ERROR, "reinterpret_cast of a %0 to %1 needs its address which is not allowed", 0, true, false, false, false, 2)
DIAG(err_bad_reinterpret_cast_small_int, CLASS_ERROR, diag::MAP_ERROR, "cast from pointer to smaller type %2 loses information", 0, true, false, false, false, 2)
DIAG(err_bad_static_cast_member_pointer_nonmp, CLASS_ERROR, diag::MAP_ERROR, "cannot cast from type %1 to member pointer type %2", 0, true, false, false, false, 2)
DIAG(err_bad_static_cast_overload, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 cannot be static_cast to type %1", 0, true, false, false, false, 2)
DIAG(err_bad_static_cast_pointer_nonpointer, CLASS_ERROR, diag::MAP_ERROR, "cannot cast from type %1 to pointer type %2", 0, true, false, false, false, 2)
DIAG(err_bad_variable_name, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot be the name of a variable or data member", 0, true, false, false, false, 2)
DIAG(err_base_clause_on_union, CLASS_ERROR, diag::MAP_ERROR, "unions cannot have base classes", 0, true, false, false, false, 2)
DIAG(err_base_init_direct_and_virtual, CLASS_ERROR, diag::MAP_ERROR, "base class initializer %0 names both a direct base class and an inherited virtual base class", 0, true, false, false, false, 2)
DIAG(err_base_init_does_not_name_class, CLASS_ERROR, diag::MAP_ERROR, "constructor initializer %0 does not name a class", 0, true, false, false, false, 2)
DIAG(err_base_must_be_class, CLASS_ERROR, diag::MAP_ERROR, "base specifier must name a class", 0, true, false, false, false, 2)
DIAG(err_bitfield_has_negative_width, CLASS_ERROR, diag::MAP_ERROR, "bit-field %0 has negative width (%1)", 0, true, false, false, false, 2)
DIAG(err_bitfield_has_zero_width, CLASS_ERROR, diag::MAP_ERROR, "named bit-field %0 has zero width", 0, true, false, false, false, 2)
DIAG(err_bitfield_width_exceeds_type_size, CLASS_ERROR, diag::MAP_ERROR, "size of bit-field %0 (%1 bits) exceeds size of its type (%2 bits)", 0, true, false, false, false, 2)
DIAG(err_block_decl_ref_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "variable is not assignable (missing __block type specifier)", 0, true, false, false, false, 2)
DIAG(err_block_extern_cant_init, CLASS_ERROR, diag::MAP_ERROR, "'extern' variable cannot have an initializer", 0, true, false, false, false, 2)
DIAG(err_block_on_nonlocal, CLASS_ERROR, diag::MAP_ERROR, "__block attribute not allowed, only allowed on local variables", 0, true, false, false, false, 2)
DIAG(err_block_on_vm, CLASS_ERROR, diag::MAP_ERROR, "__block attribute not allowed on declaration with a variably modified type", 0, true, false, false, false, 2)
DIAG(err_block_return_missing_expr, CLASS_ERROR, diag::MAP_ERROR, "non-void block should return a value", 0, true, false, false, false, 2)
DIAG(err_block_returning_array_function, CLASS_ERROR, diag::MAP_ERROR, "block cannot return %select{array|function}0 type %1", 0, true, false, false, false, 2)
DIAG(err_blocks_disable, CLASS_ERROR, diag::MAP_ERROR, "blocks support disabled - compile with -fblocks or pick a deployment target that supports them", 0, true, false, false, false, 2)
DIAG(err_bound_member_function, CLASS_ERROR, diag::MAP_ERROR, "reference to non-static member function must be called%select{|; did you mean to call it with no arguments?}0", 0, true, false, false, false, 2)
DIAG(err_box_literal_collection, CLASS_ERROR, diag::MAP_ERROR, "%select{string|character|boolean|numeric}0 literal must be prefixed by '@' in a collection", 0, true, false, false, false, 2)
DIAG(err_break_not_in_loop_or_switch, CLASS_ERROR, diag::MAP_ERROR, "'break' statement not in loop or switch statement", 0, true, false, false, false, 2)
DIAG(err_builtin_annotation_first_arg, CLASS_ERROR, diag::MAP_ERROR, "first argument to __builtin_annotation must be an integer", 0, true, false, false, false, 2)
DIAG(err_builtin_annotation_second_arg, CLASS_ERROR, diag::MAP_ERROR, "second argument to __builtin_annotation must be a non-wide string constant", 0, true, false, false, false, 2)
DIAG(err_builtin_definition, CLASS_ERROR, diag::MAP_ERROR, "definition of builtin function %0", 0, true, false, false, false, 2)
DIAG(err_builtin_fn_use, CLASS_ERROR, diag::MAP_ERROR, "builtin functions must be directly called", 0, true, false, false, false, 2)
DIAG(err_builtin_func_cast_more_than_one_arg, CLASS_ERROR, diag::MAP_ERROR, "function-style cast to a builtin type can only take one argument", 0, true, false, false, false, 2)
DIAG(err_builtin_longjmp_invalid_val, CLASS_ERROR, diag::MAP_ERROR, "argument to __builtin_longjmp must be a constant 1", 0, true, false, false, false, 2)
DIAG(err_c99_array_usage_cxx, CLASS_ERROR, diag::MAP_ERROR, "%select{qualifier in |static |}0array size %select{||'[*] '}0is a C99 feature, not permitted in C++", 0, true, false, false, false, 2)
DIAG(err_call_function_incomplete_return, CLASS_ERROR, diag::MAP_ERROR, "calling %0 with incomplete return type %1", 0, true, false, false, false, 2)
DIAG(err_call_incomplete_argument, CLASS_ERROR, diag::MAP_ERROR, "argument type %0 is incomplete", 0, true, false, false, false, 2)
DIAG(err_call_incomplete_return, CLASS_ERROR, diag::MAP_ERROR, "calling function with incomplete return type %0", 0, true, false, false, false, 2)
DIAG(err_cannot_form_pointer_to_member_of_reference_type, CLASS_ERROR, diag::MAP_ERROR, "cannot form a pointer-to-member to member %0 of reference type %1", 0, true, false, false, false, 2)
DIAG(err_cannot_pass_objc_interface_to_vararg, CLASS_ERROR, diag::MAP_ERROR, "cannot pass object with interface type %0 by value through variadic %select{function|block|method|constructor}1", 0, true, false, false, false, 2)
DIAG(err_cannot_pass_objc_interface_to_vararg_format, CLASS_ERROR, diag::MAP_ERROR, "cannot pass object with interface type %1 by value to variadic %select{function|block|method|constructor}2; expected type from format string was %3", 0, true, false, false, false, 2)
DIAG(err_capture_does_not_name_variable, CLASS_ERROR, diag::MAP_ERROR, "%0 in capture list does not name a variable", 0, true, false, false, false, 3)
DIAG(err_capture_more_than_once, CLASS_ERROR, diag::MAP_ERROR, "%0 can appear only once in a capture list", 0, true, false, false, false, 3)
DIAG(err_capture_non_automatic_variable, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot be captured because it does not have automatic storage duration", 0, true, false, false, false, 3)
DIAG(err_case_not_in_switch, CLASS_ERROR, diag::MAP_ERROR, "'case' statement not in switch statement", 0, true, false, false, false, 2)
DIAG(err_cast_pointer_from_non_pointer_int, CLASS_ERROR, diag::MAP_ERROR, "operand of type %0 cannot be cast to a pointer type", 0, true, false, false, false, 2)
DIAG(err_cast_pointer_to_non_pointer_int, CLASS_ERROR, diag::MAP_ERROR, "pointer cannot be cast to type %0", 0, true, false, false, false, 2)
DIAG(err_cast_selector_expr, CLASS_ERROR, diag::MAP_ERROR, "cannot type cast @selector expression", 0, true, false, false, false, 2)
DIAG(err_catch_incomplete, CLASS_ERROR, diag::MAP_ERROR, "cannot catch incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_catch_incomplete_ptr, CLASS_ERROR, diag::MAP_ERROR, "cannot catch pointer to incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_catch_incomplete_ref, CLASS_ERROR, diag::MAP_ERROR, "cannot catch reference to incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_catch_param_not_objc_type, CLASS_ERROR, diag::MAP_ERROR, "@catch parameter is not a pointer to an interface type", 0, true, false, false, false, 2)
DIAG(err_catch_rvalue_ref, CLASS_ERROR, diag::MAP_ERROR, "cannot catch exceptions by rvalue reference", 0, true, false, false, false, 2)
DIAG(err_category_forward_interface, CLASS_ERROR, diag::MAP_ERROR, "cannot define %select{category|class extension}0 for undefined class %1", 0, true, false, false, false, 2)
DIAG(err_cce_narrowing, CLASS_EXTENSION, diag::MAP_ERROR, "%select{case value|enumerator value|non-type template argument}0 %select{cannot be narrowed from type %2 to %3|evaluates to %2, which cannot be narrowed to type %3}1", 54, true, false, false, false, 2)
DIAG(err_cce_narrowing_sfinae, CLASS_ERROR, diag::MAP_ERROR, "%select{case value|enumerator value|non-type template argument}0 %select{cannot be narrowed from type %2 to %3|evaluates to %2, which cannot be narrowed to type %3}1", 0, true, false, false, false, 2)
DIAG(err_cconv_change, CLASS_ERROR, diag::MAP_ERROR, "function declared '%0' here was previously declared %select{'%2'|without calling convention}1", 0, true, false, false, false, 2)
DIAG(err_cconv_knr, CLASS_ERROR, diag::MAP_ERROR, "function with no prototype cannot use %0 calling convention", 0, true, false, false, false, 2)
DIAG(err_cconv_varargs, CLASS_ERROR, diag::MAP_ERROR, "variadic function cannot use %0 calling convention", 0, true, false, false, false, 2)
DIAG(err_cfstring_literal_not_string_constant, CLASS_ERROR, diag::MAP_ERROR, "CFString literal is not a string constant", 0, true, false, false, false, 2)
DIAG(err_circular_inheritance, CLASS_ERROR, diag::MAP_ERROR, "circular inheritance between %0 and %1", 0, true, false, false, false, 2)
DIAG(err_class_extension_after_impl, CLASS_ERROR, diag::MAP_ERROR, "cannot declare class extension for %0 after class implementation", 0, true, false, false, false, 2)
DIAG(err_class_marked_final_used_as_base, CLASS_ERROR, diag::MAP_ERROR, "base %0 is marked 'final'", 0, true, false, false, false, 2)
DIAG(err_class_redeclared_with_different_access, CLASS_ERROR, diag::MAP_ERROR, "%0 redeclared with '%1' access", 0, true, false, false, false, 2)
DIAG(err_collection_expr_type, CLASS_ERROR, diag::MAP_ERROR, "the type %0 is not a pointer to a fast-enumerable object", 0, true, false, false, false, 2)
DIAG(err_compound_qualified_function_type, CLASS_ERROR, diag::MAP_ERROR, "%select{block pointer|pointer|reference}0 to function type %select{%2 |}1cannot have '%3' qualifier", 0, true, false, false, false, 2)
DIAG(err_cond_voidptr_arc, CLASS_ERROR, diag::MAP_ERROR, "operands to conditional of types%diff{ $ and $|}0,1 are incompatible in ARC mode", 0, true, false, false, false, 2)
DIAG(err_conditional_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "conditional expression is ambiguous; %diff{$ can be converted to $ and vice versa|types can be convert to each other}0,1", 0, true, false, false, false, 2)
DIAG(err_conditional_ambiguous_ovl, CLASS_ERROR, diag::MAP_ERROR, "conditional expression is ambiguous; %diff{$ and $|types}0,1 can be converted to several common types", 0, true, false, false, false, 2)
DIAG(err_conditional_void_nonvoid, CLASS_ERROR, diag::MAP_ERROR, "%select{left|right}1 operand to ? is void, but %select{right|left}1 operand is of type %0", 0, true, false, false, false, 2)
DIAG(err_config_scalar_return, CLASS_ERROR, diag::MAP_ERROR, "CUDA special function 'cudaConfigureCall' must have scalar return type", 0, true, false, false, false, 2)
DIAG(err_conflicting_aliasing_type, CLASS_ERROR, diag::MAP_ERROR, "conflicting types for alias %0", 0, true, false, false, false, 2)
DIAG(err_conflicting_ivar_bitwidth, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 has conflicting bit-field width", 0, true, false, false, false, 2)
DIAG(err_conflicting_ivar_name, CLASS_ERROR, diag::MAP_ERROR, "conflicting instance variable names: %0 vs %1", 0, true, false, false, false, 2)
DIAG(err_conflicting_ivar_type, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 has conflicting type%diff{: $ vs $|}1,2", 0, true, false, false, false, 2)
DIAG(err_conflicting_super_class, CLASS_ERROR, diag::MAP_ERROR, "conflicting super class name %0", 0, true, false, false, false, 2)
DIAG(err_conflicting_types, CLASS_ERROR, diag::MAP_ERROR, "conflicting types for %0", 0, true, false, false, false, 2)
DIAG(err_constant_integer_arg_type, CLASS_ERROR, diag::MAP_ERROR, "argument to %0 must be a constant integer", 0, true, false, false, false, 2)
DIAG(err_constexpr_body_invalid_stmt, CLASS_ERROR, diag::MAP_ERROR, "statement not allowed in constexpr %select{function|constructor}0", 0, true, false, false, false, 2)
DIAG(err_constexpr_body_multiple_return, CLASS_ERROR, diag::MAP_ERROR, "multiple return statements in constexpr function", 0, true, false, false, false, 2)
DIAG(err_constexpr_body_no_return, CLASS_ERROR, diag::MAP_ERROR, "no return statement in constexpr function", 0, true, false, false, false, 2)
DIAG(err_constexpr_ctor_missing_init, CLASS_ERROR, diag::MAP_ERROR, "constexpr constructor must initialize all members", 0, true, false, false, false, 2)
DIAG(err_constexpr_dtor, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be marked constexpr", 0, true, false, false, false, 2)
DIAG(err_constexpr_function_never_constant_expr, CLASS_EXTENSION, diag::MAP_ERROR, "constexpr %select{function|constructor}0 never produces a constant expression", 164, true, false, false, false, 2)
DIAG(err_constexpr_function_try_block, CLASS_ERROR, diag::MAP_ERROR, "function try block not allowed in constexpr %select{function|constructor}0", 0, true, false, false, false, 2)
DIAG(err_constexpr_main, CLASS_ERROR, diag::MAP_ERROR, "'main' is not allowed to be declared constexpr", 0, true, false, false, false, 2)
DIAG(err_constexpr_method_non_literal, CLASS_ERROR, diag::MAP_ERROR, "non-literal type %0 cannot have constexpr members", 0, true, false, false, false, 2)
DIAG(err_constexpr_no_declarators, CLASS_ERROR, diag::MAP_ERROR, "constexpr can only be used in variable and function declarations", 0, true, false, false, false, 2)
DIAG(err_constexpr_non_literal_param, CLASS_ERROR, diag::MAP_ERROR, "constexpr %select{function|constructor}1's %ordinal0 parameter type %2 is not a literal type", 0, true, false, false, false, 2)
DIAG(err_constexpr_non_literal_return, CLASS_ERROR, diag::MAP_ERROR, "constexpr function's return type %0 is not a literal type", 0, true, false, false, false, 2)
DIAG(err_constexpr_redecl_mismatch, CLASS_ERROR, diag::MAP_ERROR, "%select{non-constexpr declaration of %0 follows constexpr declaration|constexpr declaration of %0 follows non-constexpr declaration}1", 0, true, false, false, false, 2)
DIAG(err_constexpr_static_mem_var_requires_init, CLASS_ERROR, diag::MAP_ERROR, "declaration of constexpr static data member %0 requires an initializer", 0, true, false, false, false, 2)
DIAG(err_constexpr_tag, CLASS_ERROR, diag::MAP_ERROR, "%select{class|struct|interface|union|enum}0 cannot be marked constexpr", 0, true, false, false, false, 2)
DIAG(err_constexpr_type_definition, CLASS_ERROR, diag::MAP_ERROR, "types cannot be defined in a constexpr %select{function|constructor}0", 0, true, false, false, false, 2)
DIAG(err_constexpr_union_ctor_no_init, CLASS_ERROR, diag::MAP_ERROR, "constexpr union constructor does not initialize any member", 0, true, false, false, false, 2)
DIAG(err_constexpr_var_declaration, CLASS_ERROR, diag::MAP_ERROR, "variables cannot be declared in a constexpr %select{function|constructor}0", 0, true, false, false, false, 2)
DIAG(err_constexpr_var_non_literal, CLASS_ERROR, diag::MAP_ERROR, "constexpr variable cannot have non-literal type %0", 0, true, false, false, false, 2)
DIAG(err_constexpr_var_requires_const_init, CLASS_ERROR, diag::MAP_ERROR, "constexpr variable %0 must be initialized by a constant expression", 0, true, false, false, false, 2)
DIAG(err_constexpr_virtual, CLASS_ERROR, diag::MAP_ERROR, "virtual function cannot be constexpr", 0, true, false, false, false, 2)
DIAG(err_constexpr_virtual_base, CLASS_ERROR, diag::MAP_ERROR, "constexpr %select{member function|constructor}0 not allowed in %select{struct|interface|class}1 with virtual base %plural{1:class|:classes}2", 0, true, false, false, false, 2)
DIAG(err_constexpr_vla, CLASS_ERROR, diag::MAP_ERROR, "variably-modified type %0 cannot be used in a constexpr %select{function|constructor}1", 0, true, false, false, false, 2)
DIAG(err_constructor_byvalue_arg, CLASS_ERROR, diag::MAP_ERROR, "copy constructor must pass its first argument by reference", 0, true, false, false, false, 2)
DIAG(err_constructor_cannot_be, CLASS_ERROR, diag::MAP_ERROR, "constructor cannot be declared '%0'", 0, true, false, false, false, 2)
DIAG(err_constructor_redeclared, CLASS_ERROR, diag::MAP_ERROR, "constructor cannot be redeclared", 0, true, false, false, false, 2)
DIAG(err_constructor_return_type, CLASS_ERROR, diag::MAP_ERROR, "constructor cannot have a return type", 0, true, false, false, false, 2)
DIAG(err_continuation_class, CLASS_ERROR, diag::MAP_ERROR, "class extension has no primary class", 0, true, false, false, false, 2)
DIAG(err_continue_not_in_loop, CLASS_ERROR, diag::MAP_ERROR, "'continue' statement not in loop statement", 0, true, false, false, false, 2)
DIAG(err_conv_function_not_member, CLASS_ERROR, diag::MAP_ERROR, "conversion function must be a non-static member function", 0, true, false, false, false, 2)
DIAG(err_conv_function_redeclared, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot be redeclared", 0, true, false, false, false, 2)
DIAG(err_conv_function_return_type, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot have a return type", 0, true, false, false, false, 2)
DIAG(err_conv_function_to_array, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot convert to an array type", 0, true, false, false, false, 2)
DIAG(err_conv_function_to_function, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot convert to a function type", 0, true, false, false, false, 2)
DIAG(err_conv_function_variadic, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot be variadic", 0, true, false, false, false, 2)
DIAG(err_conv_function_with_complex_decl, CLASS_ERROR, diag::MAP_ERROR, "must use a typedef to declare a conversion to %0", 0, true, false, false, false, 2)
DIAG(err_conv_function_with_params, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot have any parameters", 0, true, false, false, false, 2)
DIAG(err_copy_capture_with_copy_default, CLASS_ERROR, diag::MAP_ERROR, "'&' must precede a capture when the capture default is '='", 0, true, false, false, false, 3)
DIAG(err_covariant_return_ambiguous_derived_to_base_conv, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %3 is not covariant with the return type of the function it overrides (ambiguous conversion from derived class %0 to base class %1:%2)", 0, true, false, false, false, 2)
DIAG(err_covariant_return_inaccessible_base, CLASS_ERROR, diag::MAP_ERROR, "invalid covariant return for virtual function: %1 is a %select{private|protected}2 base class of %0", 0, true, true, false, false, 2)
DIAG(err_covariant_return_incomplete, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %0 is not covariant with the return type of the function it overrides (%1 is incomplete)", 0, true, false, false, false, 2)
DIAG(err_covariant_return_not_derived, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %0 is not covariant with the return type of the function it overrides (%1 is not derived from %2)", 0, true, false, false, false, 2)
DIAG(err_covariant_return_type_class_type_more_qualified, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %0 is not covariant with the return type of the function it overrides (class type %1 is more qualified than class type %2", 0, true, false, false, false, 2)
DIAG(err_covariant_return_type_different_qualifications, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %0 is not covariant with the return type of the function it overrides (%1 has different qualifiers than %2)", 0, true, false, false, false, 2)
DIAG(err_decimal_unsupported, CLASS_ERROR, diag::MAP_ERROR, "GNU decimal type extension not supported", 0, true, false, false, false, 2)
DIAG(err_decl_negative_array_size, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as an array with a negative size", 0, true, false, false, false, 2)
DIAG(err_declarator_need_ident, CLASS_ERROR, diag::MAP_ERROR, "declarator requires an identifier", 0, true, false, false, false, 2)
DIAG(err_decltype_in_declarator, CLASS_ERROR, diag::MAP_ERROR, "'decltype' cannot be used to name a declaration", 0, true, false, false, false, 2)
DIAG(err_decrement_bool, CLASS_ERROR, diag::MAP_ERROR, "cannot decrement expression of type bool", 0, true, false, false, false, 2)
DIAG(err_deduced_non_type_template_arg_type_mismatch, CLASS_ERROR, diag::MAP_ERROR, "deduced non-type template argument does not have the same type as the its corresponding template parameter%diff{ ($ vs $)|}0,1", 0, true, false, false, false, 2)
DIAG(err_deep_exception_specs_differ, CLASS_ERROR, diag::MAP_ERROR, "exception specifications of %select{return|argument}0 types differ", 0, true, false, false, false, 2)
DIAG(err_default_arg_in_partial_spec, CLASS_ERROR, diag::MAP_ERROR, "default template argument in a class template partial specialization", 0, true, false, false, false, 2)
DIAG(err_default_init_const, CLASS_ERROR, diag::MAP_ERROR, "default initialization of an object of const type %0%select{| requires a user-provided default constructor}1", 0, true, false, false, false, 2)
DIAG(err_default_not_in_switch, CLASS_ERROR, diag::MAP_ERROR, "'default' statement not in switch statement", 0, true, false, false, false, 2)
DIAG(err_defaulted_copy_assign_not_ref, CLASS_ERROR, diag::MAP_ERROR, "the parameter for an explicitly-defaulted copy assignment operator must be an lvalue reference type", 0, true, false, false, false, 2)
DIAG(err_defaulted_special_member_copy_const_param, CLASS_ERROR, diag::MAP_ERROR, "the parameter for this explicitly-defaulted copy %select{constructor|assignment operator}0 is const, but a member or base requires it to be non-const", 0, true, false, false, false, 2)
DIAG(err_defaulted_special_member_copy_non_const_param, CLASS_ERROR, diag::MAP_ERROR, "explicitly-defaulted copy %select{constructor|assignment operator}0 with a non-const parameter must be defaulted outside the class, unless a base or member requires the parameter to be non-const", 0, true, false, false, false, 2)
DIAG(err_defaulted_special_member_move_const_param, CLASS_ERROR, diag::MAP_ERROR, "the parameter for an explicitly-defaulted move %select{constructor|assignment operator}0 may not be const", 0, true, false, false, false, 2)
DIAG(err_defaulted_special_member_params, CLASS_ERROR, diag::MAP_ERROR, "an explicitly-defaulted %select{|copy |move }0constructor cannot have default arguments", 0, true, false, false, false, 2)
DIAG(err_defaulted_special_member_quals, CLASS_ERROR, diag::MAP_ERROR, "an explicitly-defaulted %select{copy|move}0 assignment operator may not have 'const', 'constexpr' or 'volatile' qualifiers", 0, true, false, false, false, 2)
DIAG(err_defaulted_special_member_return_type, CLASS_ERROR, diag::MAP_ERROR, "explicitly-defaulted %select{copy|move}0 assignment operator must return %1", 0, true, false, false, false, 2)
DIAG(err_defaulted_special_member_volatile_param, CLASS_ERROR, diag::MAP_ERROR, "the parameter for an explicitly-defaulted %select{<<ERROR>>|copy constructor|move constructor|copy assignment operator|move assignment operator|<<ERROR>>}0 may not be volatile", 0, true, false, false, false, 2)
DIAG(err_definition_of_explicitly_defaulted_member, CLASS_ERROR, diag::MAP_ERROR, "definition of explicitly defaulted %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0", 0, true, false, false, false, 2)
DIAG(err_definition_of_implicitly_declared_member, CLASS_ERROR, diag::MAP_ERROR, "definition of implicitly declared %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}1", 0, true, false, false, false, 2)
DIAG(err_delegating_ctor, CLASS_ERROR, diag::MAP_ERROR, "delegating constructors are permitted only in C++11", 0, true, false, false, false, 2)
DIAG(err_delegating_initializer_alone, CLASS_ERROR, diag::MAP_ERROR, "an initializer for a delegating constructor must appear alone", 0, true, false, false, false, 2)
DIAG(err_delete_incomplete_class_type, CLASS_ERROR, diag::MAP_ERROR, "deleting incomplete class type %0; no conversions to pointer type", 0, true, false, false, false, 2)
DIAG(err_delete_operand, CLASS_ERROR, diag::MAP_ERROR, "cannot delete expression of type %0", 0, true, false, false, false, 2)
DIAG(err_deleted_decl_not_first, CLASS_ERROR, diag::MAP_ERROR, "deleted definition must be first declaration", 0, true, false, false, false, 2)
DIAG(err_deleted_function_use, CLASS_ERROR, diag::MAP_ERROR, "attempt to use a deleted function", 0, true, false, false, false, 2)
DIAG(err_deleted_override, CLASS_ERROR, diag::MAP_ERROR, "deleted function %0 cannot override a non-deleted function", 0, true, false, false, false, 2)
DIAG(err_dependent_nested_name_spec, CLASS_ERROR, diag::MAP_ERROR, "nested name specifier for a declaration cannot depend on a template parameter", 0, true, false, false, false, 2)
DIAG(err_dependent_non_type_arg_in_partial_spec, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument depends on a template parameter of the partial specialization", 0, true, false, false, false, 2)
DIAG(err_dependent_tag_decl, CLASS_ERROR, diag::MAP_ERROR, "%select{declaration|definition}0 of %select{struct|interface|union|class|enum}1 in a dependent scope", 0, true, false, false, false, 2)
DIAG(err_dependent_typed_non_type_arg_in_partial_spec, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument specializes a template parameter with dependent type %0", 0, true, false, false, false, 2)
DIAG(err_designator_for_scalar_init, CLASS_ERROR, diag::MAP_ERROR, "designator in initializer for scalar type %0", 0, true, false, false, false, 2)
DIAG(err_designator_into_flexible_array_member, CLASS_ERROR, diag::MAP_ERROR, "designator into flexible array member subobject", 0, true, false, false, false, 2)
DIAG(err_destructor_cannot_be, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be declared '%0'", 0, true, false, false, false, 2)
DIAG(err_destructor_class_name, CLASS_ERROR, diag::MAP_ERROR, "expected the class name after '~' to name a destructor", 0, true, false, false, false, 2)
DIAG(err_destructor_expr_type_mismatch, CLASS_ERROR, diag::MAP_ERROR, "destructor type %0 in object destruction expression does not match the type %1 of the object being destroyed", 0, true, false, false, false, 2)
DIAG(err_destructor_name, CLASS_ERROR, diag::MAP_ERROR, "expected the class name after '~' to name the enclosing class", 0, true, false, false, false, 2)
DIAG(err_destructor_not_member, CLASS_ERROR, diag::MAP_ERROR, "destructor must be a non-static member function", 0, true, false, false, false, 2)
DIAG(err_destructor_redeclared, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be redeclared", 0, true, false, false, false, 2)
DIAG(err_destructor_return_type, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot have a return type", 0, true, false, false, false, 2)
DIAG(err_destructor_template, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be declared as a template", 0, true, false, false, false, 2)
DIAG(err_destructor_typedef_name, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be declared using a %select{typedef|type alias}1 %0 of the class name", 0, true, false, false, false, 2)
DIAG(err_destructor_variadic, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be variadic", 0, true, false, false, false, 2)
DIAG(err_destructor_with_params, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot have any parameters", 0, true, false, false, false, 2)
DIAG(err_different_return_type_for_overriding_virtual_function, CLASS_ERROR, diag::MAP_ERROR, "virtual function %0 has a different return type %diff{($) than the function it overrides (which has return type $)|than the function it overrides}1,2", 0, true, false, false, false, 2)
DIAG(err_dimension_expr_not_constant_integer, CLASS_ERROR, diag::MAP_ERROR, "dimension expression does not evaluate to a constant unsigned int", 0, true, false, false, false, 2)
DIAG(err_distant_exception_spec, CLASS_ERROR, diag::MAP_ERROR, "exception specifications are not allowed beyond a single level of indirection", 0, true, false, false, false, 2)
DIAG(err_double_requires_fp64, CLASS_ERROR, diag::MAP_ERROR, "use of type 'double' requires cl_khr_fp64 extension to be enabled", 0, true, false, false, false, 2)
DIAG(err_downcast_from_inaccessible_base, CLASS_ERROR, diag::MAP_ERROR, "cannot cast %select{private|protected}2 base class %1 to %0", 0, true, false, false, false, 2)
DIAG(err_dtor_expr_without_call, CLASS_ERROR, diag::MAP_ERROR, "%select{destructor reference|pseudo-destructor expression}0 must be called immediately with '()'", 0, true, false, false, false, 2)
DIAG(err_dup_implementation_category, CLASS_ERROR, diag::MAP_ERROR, "reimplementation of category %1 for class %0", 0, true, false, false, false, 2)
DIAG(err_dup_implementation_class, CLASS_ERROR, diag::MAP_ERROR, "reimplementation of class %0", 0, true, false, false, false, 2)
DIAG(err_duplicate_base_class, CLASS_ERROR, diag::MAP_ERROR, "base class %0 specified more than once as a direct base class", 0, true, false, false, false, 2)
DIAG(err_duplicate_case, CLASS_ERROR, diag::MAP_ERROR, "duplicate case value '%0'", 0, true, false, false, false, 2)
DIAG(err_duplicate_case_differing_expr, CLASS_ERROR, diag::MAP_ERROR, "duplicate case value: '%0' and '%1' both equal '%2'", 0, true, false, false, false, 2)
DIAG(err_duplicate_class_def, CLASS_ERROR, diag::MAP_ERROR, "duplicate interface definition for class %0", 0, true, false, false, false, 2)
DIAG(err_duplicate_ivar_declaration, CLASS_ERROR, diag::MAP_ERROR, "instance variable is already declared", 0, true, false, false, false, 2)
DIAG(err_duplicate_member, CLASS_ERROR, diag::MAP_ERROR, "duplicate member %0", 0, true, false, false, false, 2)
DIAG(err_duplicate_method_decl, CLASS_ERROR, diag::MAP_ERROR, "duplicate declaration of method %0", 0, true, false, false, false, 2)
DIAG(err_duplicate_property, CLASS_ERROR, diag::MAP_ERROR, "property has a previous declaration", 0, true, false, false, false, 2)
DIAG(err_early_catch_all, CLASS_ERROR, diag::MAP_ERROR, "catch-all handler must come last", 0, true, false, false, false, 2)
DIAG(err_ellipsis_first_arg, CLASS_ERROR, diag::MAP_ERROR, "ISO C requires a named argument before '...'", 0, true, false, false, false, 2)
DIAG(err_ellipsis_in_declarator_not_parameter, CLASS_ERROR, diag::MAP_ERROR, "only function and template parameters can be parameter packs", 0, true, false, false, false, 2)
DIAG(err_empty_scalar_initializer, CLASS_ERROR, diag::MAP_ERROR, "scalar initializer cannot be empty", 0, true, false, false, false, 2)
DIAG(err_enum_class_reference, CLASS_ERROR, diag::MAP_ERROR, "reference to %select{|scoped }0enumeration must use 'enum' not 'enum class'", 0, true, false, false, false, 2)
DIAG(err_enum_invalid_underlying, CLASS_ERROR, diag::MAP_ERROR, "non-integral type %0 is an invalid underlying type", 0, true, false, false, false, 2)
DIAG(err_enum_redeclare_fixed_mismatch, CLASS_ERROR, diag::MAP_ERROR, "enumeration previously declared with %select{non|}0fixed underlying type", 0, true, false, false, false, 2)
DIAG(err_enum_redeclare_scoped_mismatch, CLASS_ERROR, diag::MAP_ERROR, "enumeration previously declared as %select{un|}0scoped", 0, true, false, false, false, 2)
DIAG(err_enum_redeclare_type_mismatch, CLASS_ERROR, diag::MAP_ERROR, "enumeration redeclared with different underlying type %0 (was %1)", 0, true, false, false, false, 2)
DIAG(err_enumerator_does_not_exist, CLASS_ERROR, diag::MAP_ERROR, "enumerator %0 does not exist in instantiation of %1", 0, true, false, false, false, 2)
DIAG(err_enumerator_too_large, CLASS_ERROR, diag::MAP_ERROR, "enumerator value is not representable in the underlying type %0", 0, true, false, false, false, 2)
DIAG(err_enumerator_wrapped, CLASS_ERROR, diag::MAP_ERROR, "enumerator value %0 is not representable in the underlying type %1", 0, true, false, false, false, 2)
DIAG(err_exception_spec_in_typedef, CLASS_ERROR, diag::MAP_ERROR, "exception specifications are not allowed in %select{typedefs|type aliases}0", 0, true, false, false, false, 2)
DIAG(err_exceptions_disabled, CLASS_ERROR, diag::MAP_ERROR, "cannot use '%0' with exceptions disabled", 0, true, false, false, false, 2)
DIAG(err_excess_initializers, CLASS_ERROR, diag::MAP_ERROR, "excess elements in %select{array|vector|scalar|union|struct}0 initializer", 0, true, false, false, false, 2)
DIAG(err_excess_initializers_in_char_array_initializer, CLASS_ERROR, diag::MAP_ERROR, "excess elements in char array initializer", 0, true, false, false, false, 2)
DIAG(err_expected_class, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a class%select{ or namespace|, namespace, or scoped enumeration}1", 0, true, false, false, false, 2)
DIAG(err_expected_class_or_namespace, CLASS_ERROR, diag::MAP_ERROR, "expected a class or namespace", 0, true, false, false, false, 2)
DIAG(err_expected_ident_or_lparen, CLASS_ERROR, diag::MAP_ERROR, "expected identifier or '('", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "partial ordering for explicit instantiation of %0 is ambiguous", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_constexpr, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation cannot be 'constexpr'", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_data_member_not_instantiated, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation refers to static data member %q0 that is not an instantiation", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_declaration_after_definition, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation declaration (with 'extern') follows explicit instantiation definition (without 'extern')", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_duplicate, CLASS_ERROR, diag::MAP_ERROR, "duplicate explicit instantiation of %0", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_in_class, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %0 in class scope", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_inline, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation cannot be 'inline'", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_member_function_not_instantiated, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation refers to member function %q0 that is not an instantiation", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_must_be_global, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %0 must occur at global scope", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_nontemplate_type, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of non-templated type %0", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_not_known, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %0 does not refer to a function template, member function, member class, or static data member", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_of_typedef, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of typedef %0", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_out_of_scope, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %0 not in a namespace enclosing %1", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_requires_name, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation declaration requires a name", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_storage_class, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation cannot have a storage class", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_undefined_func_template, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of undefined function template %0", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_undefined_member, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of undefined %select{member class|member function|static data member}0 %1 of class template %2", 0, true, false, false, false, 2)
DIAG(err_explicit_instantiation_unqualified_wrong_namespace, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %q0 must occur in namespace %1", 0, true, false, false, false, 2)
DIAG(err_explicit_non_ctor_or_conv_function, CLASS_ERROR, diag::MAP_ERROR, "'explicit' can only be applied to a constructor or conversion function", 0, true, false, false, false, 2)
DIAG(err_explicit_non_function, CLASS_ERROR, diag::MAP_ERROR, "'explicit' can only appear on non-static member functions", 0, true, false, false, false, 2)
DIAG(err_explicit_out_of_class, CLASS_ERROR, diag::MAP_ERROR, "'explicit' can only be specified inside the class definition", 0, true, false, false, false, 2)
DIAG(err_explicit_specialization_inconsistent_storage_class, CLASS_ERROR, diag::MAP_ERROR, "explicit specialization has extraneous, inconsistent storage class '%select{none|extern|static|__private_extern__|auto|register}0'", 0, true, false, false, false, 2)
DIAG(err_expr_not_cce, CLASS_ERROR, diag::MAP_ERROR, "%select{case value|enumerator value|non-type template argument}0 is not a constant expression", 0, true, false, false, false, 2)
DIAG(err_expr_not_ice, CLASS_ERROR, diag::MAP_ERROR, "expression is not an %select{integer|integral}0 constant expression", 0, true, false, false, false, 2)
DIAG(err_ext_vector_component_exceeds_length, CLASS_ERROR, diag::MAP_ERROR, "vector component access exceeds type %0", 0, true, false, false, false, 2)
DIAG(err_ext_vector_component_name_illegal, CLASS_ERROR, diag::MAP_ERROR, "illegal vector component name '%0'", 0, true, false, false, false, 2)
DIAG(err_extern_non_extern, CLASS_ERROR, diag::MAP_ERROR, "extern declaration of %0 follows non-extern declaration", 0, true, false, false, false, 2)
DIAG(err_falloff_nonvoid_block, CLASS_ERROR, diag::MAP_ERROR, "control reaches end of non-void block", 0, true, false, false, false, 2)
DIAG(err_fallthrough_attr_outside_switch, CLASS_ERROR, diag::MAP_ERROR, "fallthrough annotation is outside switch statement", 0, true, false, false, false, 2)
DIAG(err_fallthrough_attr_wrong_target, CLASS_ERROR, diag::MAP_ERROR, "clang::fallthrough attribute is only allowed on empty statements", 0, true, false, false, false, 2)
DIAG(err_field_declared_as_function, CLASS_ERROR, diag::MAP_ERROR, "field %0 declared as a function", 0, true, false, false, false, 2)
DIAG(err_field_designator_non_aggr, CLASS_ERROR, diag::MAP_ERROR, "field designator cannot initialize a %select{non-struct, non-union|non-class}0 type %1", 0, true, false, false, false, 2)
DIAG(err_field_designator_nonfield, CLASS_ERROR, diag::MAP_ERROR, "field designator %0 does not refer to a non-static data member", 0, true, false, false, false, 2)
DIAG(err_field_designator_unknown, CLASS_ERROR, diag::MAP_ERROR, "field designator %0 does not refer to any field in type %1", 0, true, false, false, false, 2)
DIAG(err_field_designator_unknown_suggest, CLASS_ERROR, diag::MAP_ERROR, "field designator %0 does not refer to any field in type %1; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_field_incomplete, CLASS_ERROR, diag::MAP_ERROR, "field has incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_field_instantiates_to_function, CLASS_ERROR, diag::MAP_ERROR, "data member instantiated with function type %0", 0, true, false, false, false, 2)
DIAG(err_filter_expression_integral, CLASS_ERROR, diag::MAP_ERROR, "filter expression type should be an integral value not %0", 0, true, false, false, false, 2)
DIAG(err_final_function_overridden, CLASS_ERROR, diag::MAP_ERROR, "declaration of %0 overrides a 'final' function", 0, true, false, false, false, 2)
DIAG(err_first_argument_to_va_arg_not_of_type_va_list, CLASS_ERROR, diag::MAP_ERROR, "first argument to 'va_arg' is of type %0 and not 'va_list'", 0, true, false, false, false, 2)
DIAG(err_flexible_array_empty_struct, CLASS_ERROR, diag::MAP_ERROR, "flexible array %0 not allowed in otherwise empty struct", 0, true, false, false, false, 2)
DIAG(err_flexible_array_has_nonpod_type, CLASS_ERROR, diag::MAP_ERROR, "flexible array member %0 of non-POD element type %1", 0, true, false, false, false, 2)
DIAG(err_flexible_array_init, CLASS_ERROR, diag::MAP_ERROR, "initialization of flexible array member is not allowed", 0, true, false, false, false, 2)
DIAG(err_flexible_array_init_needs_braces, CLASS_ERROR, diag::MAP_ERROR, "flexible array requires brace-enclosed initializer", 0, true, false, false, false, 2)
DIAG(err_for_range_begin_end_types_differ, CLASS_ERROR, diag::MAP_ERROR, "'begin' and 'end' must return the same type (got %0 and %1)", 0, true, false, false, false, 2)
DIAG(err_for_range_decl_must_be_var, CLASS_ERROR, diag::MAP_ERROR, "for range declaration must declare a variable", 0, true, false, false, false, 2)
DIAG(err_for_range_deduction_failure, CLASS_ERROR, diag::MAP_ERROR, "cannot use type %0 as a range", 0, true, false, false, false, 2)
DIAG(err_for_range_dereference, CLASS_ERROR, diag::MAP_ERROR, "invalid range expression of type %0; did you mean to dereference it with '*'?", 0, true, false, false, false, 2)
DIAG(err_for_range_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "cannot use incomplete type %0 as a range", 0, true, false, false, false, 2)
DIAG(err_for_range_invalid, CLASS_ERROR, diag::MAP_ERROR, "invalid range expression of type %0; no viable '%select{begin|end}1' function available", 0, true, false, false, false, 2)
DIAG(err_for_range_iter_deduction_failure, CLASS_ERROR, diag::MAP_ERROR, "cannot use type %0 as an iterator", 0, true, false, false, false, 2)
DIAG(err_for_range_member_begin_end_mismatch, CLASS_ERROR, diag::MAP_ERROR, "range type %0 has '%select{begin|end}1' member but no '%select{end|begin}1' member", 0, true, false, false, false, 2)
DIAG(err_for_range_storage_class, CLASS_ERROR, diag::MAP_ERROR, "loop variable %0 may not be declared %select{'extern'|'static'|'__private_extern__'|'auto'|'register'|'constexpr'}1", 0, true, false, false, false, 2)
DIAG(err_format_attribute_implicit_this_format_string, CLASS_ERROR, diag::MAP_ERROR, "format attribute cannot specify the implicit this argument as the format string", 0, true, false, false, false, 2)
DIAG(err_format_attribute_not, CLASS_ERROR, diag::MAP_ERROR, "format argument not %0", 0, true, false, false, false, 2)
DIAG(err_format_attribute_requires_variadic, CLASS_ERROR, diag::MAP_ERROR, "format attribute requires variadic function", 0, true, false, false, false, 2)
DIAG(err_format_attribute_result_not, CLASS_ERROR, diag::MAP_ERROR, "function does not return %0", 0, true, false, false, false, 2)
DIAG(err_format_strftime_third_parameter, CLASS_ERROR, diag::MAP_ERROR, "strftime format attribute requires 3rd parameter to be 0", 0, true, false, false, false, 2)
DIAG(err_forward_ref_enum, CLASS_ERROR, diag::MAP_ERROR, "ISO C++ forbids forward references to 'enum' types", 0, true, false, false, false, 2)
DIAG(err_forward_superclass, CLASS_ERROR, diag::MAP_ERROR, "attempting to use the forward class %0 as superclass of %1", 0, true, false, false, false, 2)
DIAG(err_friend_decl_does_not_match, CLASS_ERROR, diag::MAP_ERROR, "friend declaration of %0 does not match any declaration in %1", 0, true, false, false, false, 2)
DIAG(err_friend_def_in_local_class, CLASS_ERROR, diag::MAP_ERROR, "friend function cannot be defined in a local class", 0, true, false, false, false, 2)
DIAG(err_friend_is_member, CLASS_ERROR, diag::MAP_ERROR, "friends cannot be members of the declaring class", 0, true, false, false, false, 2)
DIAG(err_friend_not_first_in_declaration, CLASS_ERROR, diag::MAP_ERROR, "'friend' must appear first in a non-function declaration", 0, true, false, false, false, 2)
DIAG(err_func_def_incomplete_result, CLASS_ERROR, diag::MAP_ERROR, "incomplete result type %0 in function definition", 0, true, false, false, false, 2)
DIAG(err_func_returning_array_function, CLASS_ERROR, diag::MAP_ERROR, "function cannot return %select{array|function}0 type %1", 0, true, false, false, false, 2)
DIAG(err_function_marked_override_not_overriding, CLASS_ERROR, diag::MAP_ERROR, "%0 marked 'override' but does not override any member functions", 0, true, false, false, false, 2)
DIAG(err_function_parameter_pack_without_parameter_packs, CLASS_ERROR, diag::MAP_ERROR, "type %0 of function parameter pack does not contain any unexpanded parameter packs", 0, true, false, false, false, 2)
DIAG(err_function_specialization_in_class, CLASS_ERROR, diag::MAP_ERROR, "cannot specialize a function %0 within class scope", 0, true, false, false, false, 2)
DIAG(err_function_template_partial_spec, CLASS_ERROR, diag::MAP_ERROR, "function template partial specialization is not allowed", 0, true, false, false, false, 2)
DIAG(err_function_template_spec_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "function template specialization %0 ambiguously refers to more than one function template; explicitly specify%select{| additional}1 template arguments to identify a particular function template", 0, true, false, false, false, 2)
DIAG(err_function_template_spec_no_match, CLASS_ERROR, diag::MAP_ERROR, "no function template matches function template specialization %0", 0, true, false, false, false, 2)
DIAG(err_gc_weak_property_strong_type, CLASS_ERROR, diag::MAP_ERROR, "weak attribute declared on a __strong type property in GC mode", 0, true, false, false, false, 2)
DIAG(err_generic_sel_multi_match, CLASS_ERROR, diag::MAP_ERROR, "controlling expression type %0 compatible with %1 generic association types", 0, true, false, false, false, 2)
DIAG(err_generic_sel_no_match, CLASS_ERROR, diag::MAP_ERROR, "controlling expression type %0 not compatible with any generic association type", 0, true, false, false, false, 2)
DIAG(err_getter_not_found, CLASS_ERROR, diag::MAP_ERROR, "expected getter method not found on object of type %0", 0, true, false, false, false, 2)
DIAG(err_global_call_not_config, CLASS_ERROR, diag::MAP_ERROR, "call to global function %0 not configured", 0, true, false, false, false, 2)
DIAG(err_goto_into_protected_scope, CLASS_ERROR, diag::MAP_ERROR, "goto into protected scope", 0, true, false, false, false, 2)
DIAG(err_iboutletcollection_type, CLASS_ERROR, diag::MAP_ERROR, "invalid type %0 as argument of iboutletcollection attribute", 0, true, false, false, false, 2)
DIAG(err_ice_ambiguous_conversion, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion from type %0 to an integral or unscoped enumeration type", 0, true, false, false, false, 2)
DIAG(err_ice_explicit_conversion, CLASS_ERROR, diag::MAP_ERROR, "integral constant expression requires explicit conversion from %0 to %1", 0, true, false, false, false, 2)
DIAG(err_ice_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "integral constant expression has incomplete class type %0", 0, true, false, false, false, 2)
DIAG(err_ice_not_integral, CLASS_ERROR, diag::MAP_ERROR, "integral constant expression must have integral or unscoped enumeration type, not %0", 0, true, false, false, false, 2)
DIAG(err_ident_in_dtor_not_a_type, CLASS_ERROR, diag::MAP_ERROR, "identifier %0 in object destruction expression does not name a type", 0, true, false, false, false, 2)
DIAG(err_ident_list_in_fn_declaration, CLASS_ERROR, diag::MAP_ERROR, "a parameter list without types is only allowed in a function definition", 0, true, false, false, false, 2)
DIAG(err_illegal_container_subscripting_op, CLASS_ERROR, diag::MAP_ERROR, "illegal operation on Objective-C container subscripting", 0, true, false, false, false, 2)
DIAG(err_illegal_decl_array_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "array has incomplete element type %0", 0, true, false, false, false, 2)
DIAG(err_illegal_decl_array_of_auto, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as array of %1", 0, true, false, false, false, 2)
DIAG(err_illegal_decl_array_of_functions, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as array of functions of type %1", 0, true, false, false, false, 2)
DIAG(err_illegal_decl_array_of_references, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as array of references of type %1", 0, true, false, false, false, 2)
DIAG(err_illegal_decl_mempointer_in_nonclass, CLASS_ERROR, diag::MAP_ERROR, "'%0' does not point into a class", 0, true, false, false, false, 2)
DIAG(err_illegal_decl_mempointer_to_reference, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as a member pointer to a reference of type %1", 0, true, false, false, false, 2)
DIAG(err_illegal_decl_mempointer_to_void, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as a member pointer to void", 0, true, false, false, false, 2)
DIAG(err_illegal_decl_pointer_to_reference, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as a pointer to a reference of type %1", 0, true, false, false, false, 2)
DIAG(err_illegal_initializer, CLASS_ERROR, diag::MAP_ERROR, "illegal initializer (only variables can be initialized)", 0, true, false, false, false, 2)
DIAG(err_illegal_initializer_type, CLASS_ERROR, diag::MAP_ERROR, "illegal initializer type %0", 0, true, false, false, false, 2)
DIAG(err_illegal_message_expr_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "Objective-C message has incomplete result type %0", 0, true, false, false, false, 2)
DIAG(err_illegal_qualifiers_on_catch_parm, CLASS_ERROR, diag::MAP_ERROR, "illegal qualifiers on @catch parameter", 0, true, false, false, false, 2)
DIAG(err_illegal_union_or_anon_struct_member, CLASS_ERROR, diag::MAP_ERROR, "%select{anonymous struct|union}0 member %1 has a non-trivial %select{constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}2", 0, true, false, false, false, 2)
DIAG(err_imaginary_not_supported, CLASS_ERROR, diag::MAP_ERROR, "imaginary types are not supported", 0, true, false, false, false, 2)
DIAG(err_implicit_empty_initializer, CLASS_ERROR, diag::MAP_ERROR, "initializer for aggregate with no elements requires explicit braces", 0, true, false, false, false, 2)
DIAG(err_implicit_instantiate_member_undefined, CLASS_ERROR, diag::MAP_ERROR, "implicit instantiation of undefined member %0", 0, true, false, false, false, 2)
DIAG(err_implicit_object_parameter_init, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize object parameter of type %0 with an expression of type %1", 0, true, false, false, false, 2)
DIAG(err_implied_std_initializer_list_not_found, CLASS_ERROR, diag::MAP_ERROR, "cannot deduce type of initializer list because std::initializer_list was not found; include <initializer_list>", 0, true, false, false, false, 2)
DIAG(err_in_class_initializer_bad_type, CLASS_ERROR, diag::MAP_ERROR, "static data member of type %0 must be initialized out of line", 0, true, false, false, false, 2)
DIAG(err_in_class_initializer_literal_type, CLASS_ERROR, diag::MAP_ERROR, "in-class initializer for static data member of type %0 requires 'constexpr' specifier", 0, true, false, false, false, 2)
DIAG(err_in_class_initializer_non_const, CLASS_ERROR, diag::MAP_ERROR, "non-const static data member must be initialized out of line", 0, true, false, false, false, 2)
DIAG(err_in_class_initializer_non_constant, CLASS_ERROR, diag::MAP_ERROR, "in-class initializer for static data member is not a constant expression", 0, true, false, false, false, 2)
DIAG(err_in_class_initializer_references_def_ctor, CLASS_ERROR, diag::MAP_ERROR, "defaulted default constructor of %0 cannot be used by non-static data member initializer which appears before end of class definition", 0, true, false, false, false, 2)
DIAG(err_in_class_initializer_volatile, CLASS_ERROR, diag::MAP_ERROR, "static const volatile data member must be initialized out of line", 0, true, false, false, false, 2)
DIAG(err_incompatible_exception_specs, CLASS_ERROR, diag::MAP_ERROR, "target exception specification is not superset of source", 0, true, false, false, false, 2)
DIAG(err_incomplete_base_class, CLASS_ERROR, diag::MAP_ERROR, "base class has incomplete type", 0, true, false, false, false, 2)
DIAG(err_incomplete_in_exception_spec, CLASS_ERROR, diag::MAP_ERROR, "%select{|pointer to |reference to }0incomplete type %1 is not allowed in exception specification", 0, true, false, false, false, 2)
DIAG(err_incomplete_member_access, CLASS_ERROR, diag::MAP_ERROR, "member access into incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_incomplete_nested_name_spec, CLASS_ERROR, diag::MAP_ERROR, "incomplete type %0 named in nested name specifier", 0, true, false, false, false, 2)
DIAG(err_incomplete_object_call, CLASS_ERROR, diag::MAP_ERROR, "incomplete type in call to object of type %0", 0, true, false, false, false, 2)
DIAG(err_incomplete_synthesized_property, CLASS_ERROR, diag::MAP_ERROR, "cannot synthesize property %0 with incomplete type %1", 0, true, false, false, false, 2)
DIAG(err_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "incomplete type %0 where a complete type is required", 0, true, false, false, false, 2)
DIAG(err_incomplete_type_objc_at_encode, CLASS_ERROR, diag::MAP_ERROR, "'@encode' of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_incomplete_type_used_in_type_trait_expr, CLASS_ERROR, diag::MAP_ERROR, "incomplete type %0 used in type trait expression", 0, true, false, false, false, 2)
DIAG(err_incomplete_typeid, CLASS_ERROR, diag::MAP_ERROR, "'typeid' of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_inconsistant_ivar_count, CLASS_ERROR, diag::MAP_ERROR, "inconsistent number of instance variables specified", 0, true, false, false, false, 2)
DIAG(err_incorrect_defaulted_constexpr, CLASS_ERROR, diag::MAP_ERROR, "defaulted definition of %select{default constructor|copy constructor|move constructor}0 is not constexpr", 0, true, false, false, false, 2)
DIAG(err_incorrect_defaulted_exception_spec, CLASS_ERROR, diag::MAP_ERROR, "exception specification of explicitly defaulted %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 does not match the calculated one", 0, true, false, false, false, 2)
DIAG(err_incorrect_number_of_vector_initializers, CLASS_ERROR, diag::MAP_ERROR, "number of elements must be either one or match the size of the vector", 0, true, false, false, false, 2)
DIAG(err_indirect_goto_in_protected_scope, CLASS_ERROR, diag::MAP_ERROR, "indirect goto might cross protected scopes", 0, true, false, false, false, 2)
DIAG(err_indirect_goto_without_addrlabel, CLASS_ERROR, diag::MAP_ERROR, "indirect goto in function with no address-of-label expressions", 0, true, false, false, false, 2)
DIAG(err_init_conversion_failed, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize %select{a variable|a parameter|return object|an exception object|a member subobject|an array element|a new value|a value|a base class|a constructor delegation|a vector element}0 %diff{of type $ with an %select{rvalue|lvalue}2 of type $|with an %select{rvalue|lvalue}2 of incompatible type}1,3%select{|: different classes%diff{ ($ vs $)|}5,6|: different number of parameters (%5 vs %6)|: type mismatch at %ordinal5 parameter%diff{ ($ vs $)|}6,7|: different return type%diff{ ($ vs $)|}5,6|: different qualifiers (%select{none|const|restrict|const and restrict|volatile|const and volatile|volatile and restrict|const, volatile, and restrict}5 vs %select{none|const|restrict|const and restrict|volatile|const and volatile|volatile and restrict|const, volatile, and restrict}6)}4", 0, true, false, false, false, 2)
DIAG(err_init_element_not_constant, CLASS_ERROR, diag::MAP_ERROR, "initializer element is not a compile-time constant", 0, true, false, false, false, 2)
DIAG(err_init_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "initialization of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_init_list_bad_dest_type, CLASS_ERROR, diag::MAP_ERROR, "%select{|non-aggregate }0type %1 cannot be initialized with an initializer list", 0, true, false, false, false, 2)
DIAG(err_init_list_constant_narrowing, CLASS_EXTENSION, diag::MAP_ERROR, "constant expression evaluates to %0 which cannot be narrowed to type %1", 54, true, false, false, false, 2)
DIAG(err_init_list_constant_narrowing_sfinae, CLASS_ERROR, diag::MAP_ERROR, "constant expression evaluates to %0 which cannot be narrowed to type %1", 0, true, false, false, false, 2)
DIAG(err_init_list_type_narrowing, CLASS_EXTENSION, diag::MAP_ERROR, "type %0 cannot be narrowed to %1 in initializer list", 54, true, false, false, false, 2)
DIAG(err_init_list_type_narrowing_sfinae, CLASS_ERROR, diag::MAP_ERROR, "type %0 cannot be narrowed to %1 in initializer list", 0, true, false, false, false, 2)
DIAG(err_init_list_variable_narrowing, CLASS_EXTENSION, diag::MAP_ERROR, "non-constant-expression cannot be narrowed from type %0 to %1 in initializer list", 54, true, false, false, false, 2)
DIAG(err_init_list_variable_narrowing_sfinae, CLASS_ERROR, diag::MAP_ERROR, "non-constant-expression cannot be narrowed from type %0 to %1 in initializer list", 0, true, false, false, false, 2)
DIAG(err_init_method_bad_return_type, CLASS_ERROR, diag::MAP_ERROR, "init methods must return an object pointer type, not %0", 0, true, false, false, false, 2)
DIAG(err_init_non_aggr_init_list, CLASS_ERROR, diag::MAP_ERROR, "initialization of non-aggregate type %0 with an initializer list", 0, true, false, false, false, 2)
DIAG(err_init_objc_class, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize Objective-C class type %0", 0, true, false, false, false, 2)
DIAG(err_init_priority_object_attr, CLASS_ERROR, diag::MAP_ERROR, "can only use 'init_priority' attribute on file-scope definitions of objects of class type", 0, true, false, false, false, 2)
DIAG(err_init_reference_member_uninitialized, CLASS_ERROR, diag::MAP_ERROR, "reference member of type %0 uninitialized", 0, true, false, false, false, 2)
DIAG(err_initializer_string_for_char_array_too_long, CLASS_ERROR, diag::MAP_ERROR, "initializer-string for char array is too long", 0, true, false, false, false, 2)
DIAG(err_inline_declaration_block_scope, CLASS_ERROR, diag::MAP_ERROR, "inline declaration of %0 not allowed in block scope", 0, true, false, false, false, 2)
DIAG(err_inline_main, CLASS_ERROR, diag::MAP_ERROR, "'main' is not allowed to be declared inline", 0, true, false, false, false, 2)
DIAG(err_inline_ms_asm_parsing, CLASS_ERROR, diag::MAP_ERROR, "%0", 0, true, false, false, false, 11)
DIAG(err_inline_namespace_mismatch, CLASS_ERROR, diag::MAP_ERROR, "%select{|non-}0inline namespace cannot be reopened as %select{non-|}0inline", 0, true, false, false, false, 2)
DIAG(err_inline_non_function, CLASS_ERROR, diag::MAP_ERROR, "'inline' can only appear on functions", 0, true, false, false, false, 2)
DIAG(err_int_to_block_pointer, CLASS_ERROR, diag::MAP_ERROR, "invalid block pointer conversion %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2", 0, true, false, false, false, 2)
DIAG(err_introducing_special_friend, CLASS_ERROR, diag::MAP_ERROR, "must use a qualified name when declaring a %select{constructor|destructor|conversion operator}0 as a friend", 0, true, false, false, false, 2)
DIAG(err_invalid_asm_cast_lvalue, CLASS_ERROR, diag::MAP_ERROR, "invalid use of a cast in a inline asm context requiring an l-value: remove the cast or build with -fheinous-gnu-extensions", 0, true, false, false, false, 11)
DIAG(err_invalid_astype_of_different_size, CLASS_ERROR, diag::MAP_ERROR, "invalid reinterpretation: sizes of %0 and %1 must match", 0, true, false, false, false, 2)
DIAG(err_invalid_base_in_interface, CLASS_ERROR, diag::MAP_ERROR, "interface type cannot inherit from %select{'struct|non-public 'interface|'class}0 %1'", 0, true, false, false, false, 2)
DIAG(err_invalid_collection_element, CLASS_ERROR, diag::MAP_ERROR, "collection element of type %0 is not an Objective-C object", 0, true, false, false, false, 2)
DIAG(err_invalid_constexpr, CLASS_ERROR, diag::MAP_ERROR, "%select{function parameter|typedef|non-static data member}0 cannot be constexpr", 0, true, false, false, false, 2)
DIAG(err_invalid_constexpr_var_decl, CLASS_ERROR, diag::MAP_ERROR, "constexpr variable declaration must be a definition", 0, true, false, false, false, 2)
DIAG(err_invalid_conversion_between_ext_vectors, CLASS_ERROR, diag::MAP_ERROR, "invalid conversion between ext-vector type %0 and %1", 0, true, false, false, false, 2)
DIAG(err_invalid_conversion_between_vector_and_integer, CLASS_ERROR, diag::MAP_ERROR, "invalid conversion between vector type %0 and integer type %1 of different size", 0, true, false, false, false, 2)
DIAG(err_invalid_conversion_between_vector_and_scalar, CLASS_ERROR, diag::MAP_ERROR, "invalid conversion between vector type %0 and scalar type %1", 0, true, false, false, false, 2)
DIAG(err_invalid_conversion_between_vectors, CLASS_ERROR, diag::MAP_ERROR, "invalid conversion between vector type%diff{ $ and $|}0,1 of different size", 0, true, false, false, false, 2)
DIAG(err_invalid_declarator_global_scope, CLASS_ERROR, diag::MAP_ERROR, "definition or redeclaration of %0 cannot name the global scope", 0, true, false, false, false, 2)
DIAG(err_invalid_declarator_in_function, CLASS_ERROR, diag::MAP_ERROR, "definition or redeclaration of %0 not allowed inside a function", 0, true, false, false, false, 2)
DIAG(err_invalid_declarator_scope, CLASS_ERROR, diag::MAP_ERROR, "cannot define or redeclare %0 here because namespace %1 does not enclose namespace %2", 0, true, false, false, false, 2)
DIAG(err_invalid_form_pointer_member_function, CLASS_ERROR, diag::MAP_ERROR, "cannot create a non-constant pointer to member function", 0, true, false, false, false, 2)
DIAG(err_invalid_incomplete_type_use, CLASS_ERROR, diag::MAP_ERROR, "invalid use of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_invalid_member_in_interface, CLASS_ERROR, diag::MAP_ERROR, "%select{data member |non-public member function |static member function |user-declared constructor|user-declared destructor|operator |nested class }0%1 is not permitted within an interface type", 0, true, false, false, false, 2)
DIAG(err_invalid_member_use_in_static_method, CLASS_ERROR, diag::MAP_ERROR, "invalid use of member %0 in static member function", 0, true, false, false, false, 2)
DIAG(err_invalid_neon_type_code, CLASS_ERROR, diag::MAP_ERROR, "incompatible constant for this __builtin_neon function", 0, true, false, false, false, 2)
DIAG(err_invalid_non_static_member_use, CLASS_ERROR, diag::MAP_ERROR, "invalid use of non-static data member %0", 0, true, false, false, false, 2)
DIAG(err_invalid_nsnumber_type, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a valid literal type for NSNumber", 0, true, false, false, false, 2)
DIAG(err_invalid_pcs, CLASS_ERROR, diag::MAP_ERROR, "Invalid PCS type", 0, true, false, false, false, 2)
DIAG(err_invalid_property_name, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a valid property name (accessing an object of type %1)", 0, true, false, false, false, 2)
DIAG(err_invalid_protocol_qualifiers, CLASS_ERROR, diag::MAP_ERROR, "invalid protocol qualifiers on non-ObjC type", 0, true, false, false, false, 2)
DIAG(err_invalid_qualified_constructor, CLASS_ERROR, diag::MAP_ERROR, "'%0' qualifier is not allowed on a constructor", 0, true, false, false, false, 2)
DIAG(err_invalid_qualified_destructor, CLASS_ERROR, diag::MAP_ERROR, "'%0' qualifier is not allowed on a destructor", 0, true, false, false, false, 2)
DIAG(err_invalid_qualified_function_type, CLASS_ERROR, diag::MAP_ERROR, "%select{static |non-}0member function %select{of type %2 |}1cannot have '%3' qualifier", 0, true, false, false, false, 2)
DIAG(err_invalid_receiver_class_message, CLASS_ERROR, diag::MAP_ERROR, "receiver type %0 is not an Objective-C class", 0, true, false, false, false, 2)
DIAG(err_invalid_receiver_to_message, CLASS_ERROR, diag::MAP_ERROR, "invalid receiver to message expression", 0, true, false, false, false, 2)
DIAG(err_invalid_receiver_to_message_super, CLASS_ERROR, diag::MAP_ERROR, "'super' is only valid in a method body", 0, true, false, false, false, 2)
DIAG(err_invalid_this_use, CLASS_ERROR, diag::MAP_ERROR, "invalid use of 'this' outside of a non-static member function", 0, true, false, false, false, 2)
DIAG(err_invalid_thread, CLASS_ERROR, diag::MAP_ERROR, "'__thread' is only allowed on variable declarations", 0, true, false, false, false, 2)
DIAG(err_invalid_use_of_array_type, CLASS_ERROR, diag::MAP_ERROR, "an array type is not allowed here", 0, true, false, false, false, 2)
DIAG(err_invalid_use_of_function_type, CLASS_ERROR, diag::MAP_ERROR, "a function type is not allowed here", 0, true, false, false, false, 2)
DIAG(err_ivar_access_using_property_syntax_suggest, CLASS_ERROR, diag::MAP_ERROR, "property %0 not found on object of type %1; did you mean to access instance variable %2?", 0, true, false, false, false, 2)
DIAG(err_ivar_reference_type, CLASS_ERROR, diag::MAP_ERROR, "instance variables cannot be of reference type", 0, true, false, false, false, 2)
DIAG(err_kern_call_not_global_function, CLASS_ERROR, diag::MAP_ERROR, "kernel call to non-global function %0", 0, true, false, false, false, 2)
DIAG(err_kern_type_not_void_return, CLASS_ERROR, diag::MAP_ERROR, "kernel function type %0 must have void return type", 0, true, false, false, false, 2)
DIAG(err_lambda_capture_anonymous_var, CLASS_ERROR, diag::MAP_ERROR, "unnamed variable cannot be implicitly captured in a lambda expression", 0, true, false, false, false, 3)
DIAG(err_lambda_capture_block, CLASS_ERROR, diag::MAP_ERROR, "__block variable %0 cannot be captured in a lambda expression", 0, true, false, false, false, 3)
DIAG(err_lambda_capture_default_arg, CLASS_ERROR, diag::MAP_ERROR, "lambda expression in default argument cannot capture any entity", 0, true, false, false, false, 3)
DIAG(err_lambda_capture_vm_type, CLASS_ERROR, diag::MAP_ERROR, "variable %0 with variably modified type cannot be captured in a lambda expression", 0, true, false, false, false, 3)
DIAG(err_lambda_decl_ref_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "cannot assign to a variable captured by copy in a non-mutable lambda", 0, true, false, false, false, 2)
DIAG(err_lambda_impcap, CLASS_ERROR, diag::MAP_ERROR, "variable %0 cannot be implicitly captured in a lambda with no capture-default specified", 0, true, false, false, false, 3)
DIAG(err_lambda_incomplete_result, CLASS_ERROR, diag::MAP_ERROR, "incomplete result type %0 in lambda expression", 0, true, false, false, false, 3)
DIAG(err_lambda_objc_object_result, CLASS_ERROR, diag::MAP_ERROR, "non-pointer Objective-C class type %0 in lambda expression result", 0, true, false, false, false, 3)
DIAG(err_lambda_return_init_list, CLASS_ERROR, diag::MAP_ERROR, "cannot deduce lambda return type from initializer list", 0, true, false, false, false, 3)
DIAG(err_lambda_unevaluated_operand, CLASS_ERROR, diag::MAP_ERROR, "lambda expression in an unevaluated operand", 0, true, false, false, false, 3)
DIAG(err_lambda_unexpanded_pack, CLASS_ERROR, diag::MAP_ERROR, "unexpanded function parameter pack capture is unsupported", 0, true, false, false, false, 3)
DIAG(err_literal_operator_default_argument, CLASS_ERROR, diag::MAP_ERROR, "literal operator cannot have a default argument", 0, true, false, false, false, 2)
DIAG(err_literal_operator_extern_c, CLASS_ERROR, diag::MAP_ERROR, "literal operator must have C++ linkage", 0, true, false, false, false, 2)
DIAG(err_literal_operator_outside_namespace, CLASS_ERROR, diag::MAP_ERROR, "literal operator %0 must be in a namespace or global scope", 0, true, false, false, false, 2)
DIAG(err_literal_operator_params, CLASS_ERROR, diag::MAP_ERROR, "parameter declaration for literal operator %0 is not valid", 0, true, false, false, false, 2)
DIAG(err_local_cant_init, CLASS_ERROR, diag::MAP_ERROR, "'__local' variable cannot have an initializer", 0, true, false, false, false, 2)
DIAG(err_lvalue_reference_bind_to_initlist, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 lvalue reference to type %1 cannot bind to an initializer list temporary", 0, true, false, false, false, 2)
DIAG(err_lvalue_reference_bind_to_temporary, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 lvalue reference %diff{to type $ cannot bind to a temporary of type $|cannot bind to incompatible temporary}1,2", 0, true, false, false, false, 2)
DIAG(err_lvalue_reference_bind_to_unrelated, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 lvalue reference %diff{to type $ cannot bind to a value of unrelated type $|cannot bind to a value of unrelated type}1,2", 0, true, false, false, false, 2)
DIAG(err_lvalue_to_rvalue_ref, CLASS_ERROR, diag::MAP_ERROR, "rvalue reference %diff{to type $ cannot bind to lvalue of type $|cannot bind to incompatible lvalue}0,1", 0, true, false, false, false, 2)
DIAG(err_main_arg_wrong, CLASS_ERROR, diag::MAP_ERROR, "%select{first|second|third|fourth}0 parameter of 'main' (%select{argument count|argument array|environment|platform-specific data}0) must be of type %1", 0, true, false, false, false, 2)
DIAG(err_main_returns_nonint, CLASS_ERROR, diag::MAP_ERROR, "'main' must return 'int'", 0, true, false, false, false, 2)
DIAG(err_main_surplus_args, CLASS_ERROR, diag::MAP_ERROR, "too many parameters (%0) for 'main': must be 0, 2, or 3", 0, true, false, false, false, 2)
DIAG(err_main_template_decl, CLASS_ERROR, diag::MAP_ERROR, "'main' cannot be a template", 0, true, false, false, false, 2)
DIAG(err_malformed_std_initializer_list, CLASS_ERROR, diag::MAP_ERROR, "std::initializer_list must be a class template with a single type parameter", 0, true, false, false, false, 2)
DIAG(err_maybe_falloff_nonvoid_block, CLASS_ERROR, diag::MAP_ERROR, "control may reach end of non-void block", 0, true, false, false, false, 2)
DIAG(err_mem_init_not_member_or_class, CLASS_ERROR, diag::MAP_ERROR, "member initializer %0 does not name a non-static data member or base class", 0, true, false, false, false, 2)
DIAG(err_mem_init_not_member_or_class_suggest, CLASS_ERROR, diag::MAP_ERROR, "initializer %0 does not name a non-static data member or base class; did you mean the %select{base class|member}1 %2?", 0, true, false, false, false, 2)
DIAG(err_member_call_without_object, CLASS_ERROR, diag::MAP_ERROR, "call to non-static member function without an object argument", 0, true, false, false, false, 2)
DIAG(err_member_def_does_not_match, CLASS_ERROR, diag::MAP_ERROR, "out-of-line definition of %0 does not match any declaration in %1", 0, true, false, false, false, 2)
DIAG(err_member_def_does_not_match_ret_type, CLASS_ERROR, diag::MAP_ERROR, "out-of-line definition of %q0 differs from the declaration in the return type", 0, true, false, false, false, 2)
DIAG(err_member_def_does_not_match_suggest, CLASS_ERROR, diag::MAP_ERROR, "out-of-line definition of %0 does not match any declaration in %1; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_member_def_undefined_record, CLASS_ERROR, diag::MAP_ERROR, "out-of-line definition of %0 from class %1 without definition", 0, true, false, false, false, 2)
DIAG(err_member_extra_qualification, CLASS_ERROR, diag::MAP_ERROR, "extra qualification on member %0", 0, true, false, false, false, 2)
DIAG(err_member_function_call_bad_cvr, CLASS_ERROR, diag::MAP_ERROR, "member function %0 not viable: 'this' argument has type %1, but function is not marked %select{const|restrict|const or restrict|volatile|const or volatile|volatile or restrict|const, volatile, or restrict}2", 0, true, false, false, false, 2)
DIAG(err_member_function_initialization, CLASS_ERROR, diag::MAP_ERROR, "initializer on function does not look like a pure-specifier", 0, true, false, false, false, 2)
DIAG(err_member_name_of_class, CLASS_ERROR, diag::MAP_ERROR, "member %0 has the same name as its class", 0, true, false, false, false, 2)
DIAG(err_member_not_yet_instantiated, CLASS_ERROR, diag::MAP_ERROR, "no member %0 in %1; it has not yet been instantiated", 0, true, false, false, false, 2)
DIAG(err_member_qualification, CLASS_ERROR, diag::MAP_ERROR, "non-friend class member %0 cannot have a qualified name", 0, true, false, false, false, 2)
DIAG(err_member_redeclared, CLASS_ERROR, diag::MAP_ERROR, "class member cannot be redeclared", 0, true, false, false, false, 2)
DIAG(err_member_redeclared_in_instantiation, CLASS_ERROR, diag::MAP_ERROR, "multiple overloads of %0 instantiate to the same signature %1", 0, true, false, false, false, 2)
DIAG(err_member_reference_needs_call, CLASS_ERROR, diag::MAP_ERROR, "base of member reference is a function; perhaps you meant to call it%select{| with no arguments}0?", 0, true, false, false, false, 2)
DIAG(err_mempointer_in_nonclass_type, CLASS_ERROR, diag::MAP_ERROR, "member pointer refers into non-class type %0", 0, true, false, false, false, 2)
DIAG(err_memptr_conv_via_virtual, CLASS_ERROR, diag::MAP_ERROR, "conversion from pointer to member of class %0 to pointer to member of class %1 via virtual base %2 is not allowed", 0, true, false, false, false, 2)
DIAG(err_mismatched_exception_spec, CLASS_ERROR, diag::MAP_ERROR, "exception specification in declaration does not match previous declaration", 0, true, false, false, false, 2)
DIAG(err_mismatched_visibility, CLASS_ERROR, diag::MAP_ERROR, "visibility does not match previous declaration", 0, true, false, false, false, 2)
DIAG(err_misplaced_ivar, CLASS_ERROR, diag::MAP_ERROR, "instance variables may not be placed in %select{categories|class extension}0", 0, true, false, false, false, 2)
DIAG(err_missing_braces, CLASS_ERROR, diag::MAP_ERROR, "cannot omit braces around initialization of subobject when using direct list-initialization", 0, true, false, false, false, 2)
DIAG(err_missing_default_ctor, CLASS_ERROR, diag::MAP_ERROR, "%select{|implicit default }0constructor for %1 must explicitly initialize the %select{base class|member}2 %3 which does not have a default constructor", 0, true, false, false, false, 2)
DIAG(err_missing_open_square_message_send, CLASS_ERROR, diag::MAP_ERROR, "missing '[' at start of message send expression", 0, true, false, false, false, 2)
DIAG(err_missing_type_specifier, CLASS_ERROR, diag::MAP_ERROR, "C++ requires a type specifier for all declarations", 0, true, false, false, false, 2)
DIAG(err_mode_not_primitive, CLASS_ERROR, diag::MAP_ERROR, "mode attribute only supported for integer and floating-point types", 0, true, false, false, false, 2)
DIAG(err_mode_wrong_type, CLASS_ERROR, diag::MAP_ERROR, "type of machine mode does not match type of base type", 0, true, false, false, false, 2)
DIAG(err_module_private_definition, CLASS_ERROR, diag::MAP_ERROR, "definition of %0 must be imported before it is required", 0, true, false, false, false, 12)
DIAG(err_module_private_local, CLASS_ERROR, diag::MAP_ERROR, "%select{local variable|parameter|typedef}0 %1 cannot be declared __module_private__", 0, true, false, false, false, 12)
DIAG(err_module_private_local_class, CLASS_ERROR, diag::MAP_ERROR, "local %select{struct|interface|union|class|enum}0 cannot be declared __module_private__", 0, true, false, false, false, 12)
DIAG(err_module_private_specialization, CLASS_ERROR, diag::MAP_ERROR, "%select{template|partial|member}0 specialization cannot be declared __module_private__", 0, true, false, false, false, 12)
DIAG(err_multiple_base_initialization, CLASS_ERROR, diag::MAP_ERROR, "multiple initializations given for base %0", 0, true, false, false, false, 2)
DIAG(err_multiple_default_labels_defined, CLASS_ERROR, diag::MAP_ERROR, "multiple default labels in one switch", 0, true, false, false, false, 2)
DIAG(err_multiple_final_overriders, CLASS_ERROR, diag::MAP_ERROR, "virtual function %q0 has more than one final overrider in %1", 0, true, false, false, false, 2)
DIAG(err_multiple_mem_initialization, CLASS_ERROR, diag::MAP_ERROR, "multiple initializations given for non-static member %0", 0, true, false, false, false, 2)
DIAG(err_multiple_mem_union_initialization, CLASS_ERROR, diag::MAP_ERROR, "initializing multiple members of union", 0, true, false, false, false, 2)
DIAG(err_mutable_const, CLASS_ERROR, diag::MAP_ERROR, "'mutable' and 'const' cannot be mixed", 0, true, false, false, false, 2)
DIAG(err_mutable_function, CLASS_ERROR, diag::MAP_ERROR, "'mutable' cannot be applied to functions", 0, true, false, false, false, 2)
DIAG(err_mutable_nonmember, CLASS_ERROR, diag::MAP_ERROR, "'mutable' can only be applied to member variables", 0, true, false, false, false, 2)
DIAG(err_mutable_reference, CLASS_ERROR, diag::MAP_ERROR, "'mutable' cannot be applied to references", 0, true, false, false, false, 2)
DIAG(err_need_header_before_ms_uuidof, CLASS_ERROR, diag::MAP_ERROR, "you need to include <guiddef.h> before using the '__uuidof' operator", 0, true, false, false, false, 2)
DIAG(err_need_header_before_typeid, CLASS_ERROR, diag::MAP_ERROR, "you need to include <typeinfo> before using the 'typeid' operator", 0, true, false, false, false, 2)
DIAG(err_nested_name_member_ref_lookup_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "lookup of %0 in member access expression is ambiguous", 0, true, false, false, false, 2)
DIAG(err_nested_name_spec_non_tag, CLASS_ERROR, diag::MAP_ERROR, "type %0 cannot be used prior to '::' because it has no members", 0, true, false, false, false, 2)
DIAG(err_nested_non_static_member_use, CLASS_ERROR, diag::MAP_ERROR, "%select{call to non-static member function|use of non-static data member}0 %2 of %1 from nested type %3", 0, true, false, false, false, 2)
DIAG(err_nested_redefinition, CLASS_ERROR, diag::MAP_ERROR, "nested redefinition of %0", 0, true, false, false, false, 2)
DIAG(err_new_array_init_args, CLASS_ERROR, diag::MAP_ERROR, "array 'new' cannot have initialization arguments", 0, true, false, false, false, 2)
DIAG(err_new_array_nonconst, CLASS_ERROR, diag::MAP_ERROR, "only the first dimension of an allocated array may have dynamic size", 0, true, false, false, false, 2)
DIAG(err_new_array_of_auto, CLASS_ERROR, diag::MAP_ERROR, "cannot allocate array of 'auto'", 0, true, false, false, false, 2)
DIAG(err_new_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "allocation of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_no_matching_local_friend, CLASS_ERROR, diag::MAP_ERROR, "no matching function found in local scope", 0, true, false, false, false, 2)
DIAG(err_no_matching_local_friend_suggest, CLASS_ERROR, diag::MAP_ERROR, "no matching function %0 found in local scope; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_no_member, CLASS_ERROR, diag::MAP_ERROR, "no member named %0 in %1", 0, true, false, false, false, 2)
DIAG(err_no_member_overloaded_arrow, CLASS_ERROR, diag::MAP_ERROR, "no member named %0 in %1; did you mean to use '->' instead of '.'?", 0, true, false, false, false, 2)
DIAG(err_no_member_suggest, CLASS_ERROR, diag::MAP_ERROR, "no member named %0 in %1; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_no_member_template_suggest, CLASS_ERROR, diag::MAP_ERROR, "no template named %0 in %1; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_no_nsconstant_string_class, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0", 0, true, false, false, false, 2)
DIAG(err_no_suitable_delete_member_function_found, CLASS_ERROR, diag::MAP_ERROR, "no suitable member %0 in %1", 0, true, false, false, false, 2)
DIAG(err_no_template_suggest, CLASS_ERROR, diag::MAP_ERROR, "no template named %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_no_typeid_with_fno_rtti, CLASS_ERROR, diag::MAP_ERROR, "cannot use typeid with -fno-rtti", 0, true, false, false, false, 2)
DIAG(err_noexcept_needs_constant_expression, CLASS_ERROR, diag::MAP_ERROR, "argument to noexcept specifier must be a constant expression", 0, true, false, false, false, 2)
DIAG(err_nogetter_property_compound_assignment, CLASS_ERROR, diag::MAP_ERROR, "a getter method is needed to perform a compound assignment on a property", 0, true, false, false, false, 2)
DIAG(err_nogetter_property_incdec, CLASS_ERROR, diag::MAP_ERROR, "no getter method %1 for %select{increment|decrement}0 of property", 0, true, false, false, false, 2)
DIAG(err_non_deleted_override, CLASS_ERROR, diag::MAP_ERROR, "non-deleted function %0 cannot override a deleted function", 0, true, false, false, false, 2)
DIAG(err_non_extern_extern, CLASS_ERROR, diag::MAP_ERROR, "non-extern declaration of %0 follows extern declaration", 0, true, false, false, false, 2)
DIAG(err_non_static_static, CLASS_ERROR, diag::MAP_ERROR, "non-static declaration of %0 follows static declaration", 0, true, false, false, false, 2)
DIAG(err_non_thread_thread, CLASS_ERROR, diag::MAP_ERROR, "non-thread-local declaration of %0 follows thread-local declaration", 0, true, false, false, false, 2)
DIAG(err_non_type_template_in_nested_name_specifier, CLASS_ERROR, diag::MAP_ERROR, "qualified name refers into a specialization of function template '%0'", 0, true, false, false, false, 2)
DIAG(err_non_variable_decl_in_for, CLASS_ERROR, diag::MAP_ERROR, "declaration of non-local variable in 'for' loop", 0, true, false, false, false, 2)
DIAG(err_non_virtual_pure, CLASS_ERROR, diag::MAP_ERROR, "%0 is not virtual and cannot be declared pure", 0, true, false, false, false, 2)
DIAG(err_nonfunction_block_type, CLASS_ERROR, diag::MAP_ERROR, "block pointer to non-function type is invalid", 0, true, false, false, false, 2)
DIAG(err_nonstatic_member_out_of_line, CLASS_ERROR, diag::MAP_ERROR, "non-static data member defined out-of-line", 0, true, false, false, false, 2)
DIAG(err_noreturn_block_has_return_expr, CLASS_ERROR, diag::MAP_ERROR, "block declared 'noreturn' should not return", 0, true, false, false, false, 2)
DIAG(err_noreturn_lambda_has_return_expr, CLASS_ERROR, diag::MAP_ERROR, "lambda declared 'noreturn' should not return", 0, true, false, false, false, 3)
DIAG(err_nosetter_property_assignment, CLASS_ERROR, diag::MAP_ERROR, "%select{assignment to readonly property|no setter method %1 for assignment to property}0", 0, true, false, false, false, 2)
DIAG(err_nosetter_property_incdec, CLASS_ERROR, diag::MAP_ERROR, "%select{%select{increment|decrement}1 of readonly property|no setter method %2 for %select{increment|decrement}1 of property}0", 0, true, false, false, false, 2)
DIAG(err_not_class_template_specialization, CLASS_ERROR, diag::MAP_ERROR, "cannot specialize a %select{dependent template|template template parameter}0", 0, true, false, false, false, 2)
DIAG(err_not_direct_base_or_virtual, CLASS_ERROR, diag::MAP_ERROR, "type %0 is not a direct or virtual base of %1", 0, true, false, false, false, 2)
DIAG(err_not_found_by_two_phase_lookup, CLASS_ERROR, diag::MAP_ERROR, "call to function %0 that is neither visible in the template definition nor found by argument-dependent lookup", 0, true, false, false, false, 2)
DIAG(err_not_integral_type_anon_bitfield, CLASS_ERROR, diag::MAP_ERROR, "anonymous bit-field has non-integral type %0", 0, true, false, false, false, 2)
DIAG(err_not_integral_type_bitfield, CLASS_ERROR, diag::MAP_ERROR, "bit-field %0 has non-integral type %1", 0, true, false, false, false, 2)
DIAG(err_not_tag_in_scope, CLASS_ERROR, diag::MAP_ERROR, "no %select{struct|interface|union|class|enum}0 named %1 in %2", 0, true, false, false, false, 2)
DIAG(err_ns_bridged_not_interface, CLASS_ERROR, diag::MAP_ERROR, "parameter of 'ns_bridged' attribute does not name an Objective-C class", 0, true, false, false, false, 2)
DIAG(err_nsconsumed_attribute_mismatch, CLASS_ERROR, diag::MAP_ERROR, "overriding method has mismatched ns_consumed attribute on its parameter", 0, true, false, false, false, 2)
DIAG(err_nsobject_attribute, CLASS_ERROR, diag::MAP_ERROR, "__attribute ((NSObject)) is for pointer types only", 0, true, false, false, false, 2)
DIAG(err_nsreturns_retained_attribute_mismatch, CLASS_ERROR, diag::MAP_ERROR, "overriding method has mismatched ns_returns_%select{not_retained|retained}0 attributes", 0, true, false, false, false, 2)
DIAG(err_objc_array_of_interfaces, CLASS_ERROR, diag::MAP_ERROR, "array of interface %0 is invalid (probably should be an array of pointers)", 0, true, false, false, false, 2)
DIAG(err_objc_decls_may_only_appear_in_global_scope, CLASS_ERROR, diag::MAP_ERROR, "Objective-C declarations may only appear in global scope", 0, true, false, false, false, 2)
DIAG(err_objc_exceptions_disabled, CLASS_ERROR, diag::MAP_ERROR, "cannot use '%0' with Objective-C exceptions disabled", 0, true, false, false, false, 2)
DIAG(err_objc_illegal_boxed_expression_type, CLASS_ERROR, diag::MAP_ERROR, "illegal type %0 used in a boxed expression", 0, true, false, false, false, 2)
DIAG(err_objc_incomplete_boxed_expression_type, CLASS_ERROR, diag::MAP_ERROR, "incomplete type %0 used in a boxed expression", 0, true, false, false, false, 2)
DIAG(err_objc_index_incomplete_class_type, CLASS_ERROR, diag::MAP_ERROR, "Objective-C index expression has incomplete class type %0", 0, true, false, false, false, 2)
DIAG(err_objc_indexing_method_result_type, CLASS_ERROR, diag::MAP_ERROR, "method for accessing %select{dictionary|array}1 element must have Objective-C object return type instead of %0", 0, true, false, false, false, 2)
DIAG(err_objc_literal_method_sig, CLASS_ERROR, diag::MAP_ERROR, "literal construction method %0 has incompatible signature", 0, true, false, false, false, 2)
DIAG(err_objc_multiple_subscript_type_conversion, CLASS_ERROR, diag::MAP_ERROR, "indexing expression is invalid because subscript type %0 has multiple type conversion functions", 0, true, false, false, false, 2)
DIAG(err_objc_object_assignment, CLASS_ERROR, diag::MAP_ERROR, "cannot assign to class object (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_objc_object_catch, CLASS_ERROR, diag::MAP_ERROR, "can't catch an Objective-C object by value", 0, true, false, false, false, 2)
DIAG(err_objc_precise_lifetime_bad_type, CLASS_ERROR, diag::MAP_ERROR, "objc_precise_lifetime only applies to retainable types; type here is %0", 0, true, false, false, false, 2)
DIAG(err_objc_property_attr_mutually_exclusive, CLASS_ERROR, diag::MAP_ERROR, "property attributes '%0' and '%1' are mutually exclusive", 0, true, false, false, false, 2)
DIAG(err_objc_property_requires_object, CLASS_ERROR, diag::MAP_ERROR, "property with '%0' attribute must be of object type", 0, true, false, false, false, 2)
DIAG(err_objc_root_class_subclass, CLASS_ERROR, diag::MAP_ERROR, "objc_root_class attribute may only be specified on a root class declaration", 0, true, false, false, false, 2)
DIAG(err_objc_subscript_base_type, CLASS_ERROR, diag::MAP_ERROR, "%select{dictionary|array}1 subscript base type %0 is not an Objective-C object", 0, true, false, false, false, 2)
DIAG(err_objc_subscript_dic_object_type, CLASS_ERROR, diag::MAP_ERROR, "method object parameter type %0 is not object type", 0, true, false, false, false, 2)
DIAG(err_objc_subscript_index_type, CLASS_ERROR, diag::MAP_ERROR, "method index parameter type %0 is not integral type", 0, true, false, false, false, 2)
DIAG(err_objc_subscript_key_type, CLASS_ERROR, diag::MAP_ERROR, "method key parameter type %0 is not object type", 0, true, false, false, false, 2)
DIAG(err_objc_subscript_method_not_found, CLASS_ERROR, diag::MAP_ERROR, "expected method to %select{read|write}1 %select{dictionary|array}2 element not found on object of type %0", 0, true, false, false, false, 2)
DIAG(err_objc_subscript_object_type, CLASS_ERROR, diag::MAP_ERROR, "cannot assign to this %select{dictionary|array}1 because assigning method's 2nd parameter of type %0 is not an Objective-C pointer type", 0, true, false, false, false, 2)
DIAG(err_objc_subscript_pointer, CLASS_ERROR, diag::MAP_ERROR, "indexing expression is invalid because subscript type %0 is not an Objective-C pointer", 0, true, false, false, false, 2)
DIAG(err_objc_subscript_type_conversion, CLASS_ERROR, diag::MAP_ERROR, "indexing expression is invalid because subscript type %0 is not an integral or Objective-C pointer type", 0, true, false, false, false, 2)
DIAG(err_objc_var_decl_inclass, CLASS_ERROR, diag::MAP_ERROR, "cannot declare variable inside @interface or @protocol", 0, true, false, false, false, 2)
DIAG(err_object_cannot_be_passed_returned_by_value, CLASS_ERROR, diag::MAP_ERROR, "interface type %1 cannot be %select{returned|passed}0 by value; did you forget * in %1?", 0, true, false, false, false, 2)
DIAG(err_offsetof_array_type, CLASS_ERROR, diag::MAP_ERROR, "offsetof requires array type, %0 invalid", 0, true, false, false, false, 2)
DIAG(err_offsetof_bitfield, CLASS_ERROR, diag::MAP_ERROR, "cannot compute offset of bit-field %0", 0, true, false, false, false, 2)
DIAG(err_offsetof_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "offsetof of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_offsetof_record_type, CLASS_ERROR, diag::MAP_ERROR, "offsetof requires struct, union, or class type, %0 invalid", 0, true, false, false, false, 2)
DIAG(err_only_annotate_after_access_spec, CLASS_ERROR, diag::MAP_ERROR, "access specifier can only have annotation attributes", 0, true, false, false, false, 2)
DIAG(err_only_constructors_take_base_inits, CLASS_ERROR, diag::MAP_ERROR, "only constructors take base initializers", 0, true, false, false, false, 2)
DIAG(err_only_enums_have_underlying_types, CLASS_ERROR, diag::MAP_ERROR, "only enumeration types have underlying types", 0, true, false, false, false, 2)
DIAG(err_operator_arrow_circular, CLASS_ERROR, diag::MAP_ERROR, "circular pointer delegation detected", 0, true, false, false, false, 2)
DIAG(err_operator_delete_dependent_param_type, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot take a dependent type as first parameter; use %1 instead", 0, true, false, false, false, 2)
DIAG(err_operator_delete_param_type, CLASS_ERROR, diag::MAP_ERROR, "first parameter of %0 must have type %1", 0, true, false, false, false, 2)
DIAG(err_operator_new_default_arg, CLASS_ERROR, diag::MAP_ERROR, "parameter of %0 cannot have a default argument", 0, true, false, false, false, 2)
DIAG(err_operator_new_delete_declared_in_namespace, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot be declared inside a namespace", 0, true, false, false, false, 2)
DIAG(err_operator_new_delete_declared_static, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot be declared static in global scope", 0, true, false, false, false, 2)
DIAG(err_operator_new_delete_dependent_result_type, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot have a dependent return type; use %1 instead", 0, true, false, false, false, 2)
DIAG(err_operator_new_delete_invalid_result_type, CLASS_ERROR, diag::MAP_ERROR, "%0 must return type %1", 0, true, false, false, false, 2)
DIAG(err_operator_new_delete_template_too_few_parameters, CLASS_ERROR, diag::MAP_ERROR, "%0 template must have at least two parameters", 0, true, false, false, false, 2)
DIAG(err_operator_new_delete_too_few_parameters, CLASS_ERROR, diag::MAP_ERROR, "%0 must have at least one parameter", 0, true, false, false, false, 2)
DIAG(err_operator_new_dependent_param_type, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot take a dependent type as first parameter; use size_t (%1) instead", 0, true, false, false, false, 2)
DIAG(err_operator_new_param_type, CLASS_ERROR, diag::MAP_ERROR, "%0 takes type size_t (%1) as first parameter", 0, true, false, false, false, 2)
DIAG(err_operator_overload_default_arg, CLASS_ERROR, diag::MAP_ERROR, "parameter of overloaded %0 cannot have a default argument", 0, true, false, false, false, 2)
DIAG(err_operator_overload_must_be, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 must be a %select{unary|binary|unary or binary}2 operator (has %1 parameter%s1)", 0, true, false, false, false, 2)
DIAG(err_operator_overload_must_be_member, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 must be a non-static member function", 0, true, false, false, false, 2)
DIAG(err_operator_overload_needs_class_or_enum, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 must have at least one parameter of class or enumeration type", 0, true, false, false, false, 2)
DIAG(err_operator_overload_post_incdec_must_be_int, CLASS_ERROR, diag::MAP_ERROR, "parameter of overloaded post-%select{increment|decrement}1 operator must have type 'int' (not %0)", 0, true, false, false, false, 2)
DIAG(err_operator_overload_static, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 cannot be a static member function", 0, true, false, false, false, 2)
DIAG(err_operator_overload_variadic, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 cannot be variadic", 0, true, false, false, false, 2)
DIAG(err_out_of_line_default_deletes, CLASS_ERROR, diag::MAP_ERROR, "defaulting this %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 would delete it after its first declaration", 0, true, false, false, false, 2)
DIAG(err_override_exception_spec, CLASS_ERROR, diag::MAP_ERROR, "exception specification of overriding function is more lax than base version", 0, true, false, false, false, 2)
DIAG(err_ovl_ambiguous_call, CLASS_ERROR, diag::MAP_ERROR, "call to %0 is ambiguous", 0, true, false, false, false, 2)
DIAG(err_ovl_ambiguous_conversion_in_cast, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion for %select{|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2", 0, true, false, false, false, 2)
DIAG(err_ovl_ambiguous_init, CLASS_ERROR, diag::MAP_ERROR, "call to constructor of %0 is ambiguous", 0, true, false, false, false, 2)
DIAG(err_ovl_ambiguous_member_call, CLASS_ERROR, diag::MAP_ERROR, "call to member function %0 is ambiguous", 0, true, false, false, false, 2)
DIAG(err_ovl_ambiguous_object_call, CLASS_ERROR, diag::MAP_ERROR, "call to object of type %0 is ambiguous", 0, true, false, false, false, 2)
DIAG(err_ovl_ambiguous_oper_binary, CLASS_ERROR, diag::MAP_ERROR, "use of overloaded operator '%0' is ambiguous (with operand types %1 and %2)", 0, true, false, false, false, 2)
DIAG(err_ovl_ambiguous_oper_unary, CLASS_ERROR, diag::MAP_ERROR, "use of overloaded operator '%0' is ambiguous (operand type %1)", 0, true, false, false, false, 2)
DIAG(err_ovl_deleted_call, CLASS_ERROR, diag::MAP_ERROR, "call to %select{unavailable|deleted}0 function %1%2", 0, true, false, false, false, 2)
DIAG(err_ovl_deleted_conversion_in_cast, CLASS_ERROR, diag::MAP_ERROR, "%select{|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 uses deleted function", 0, true, false, false, false, 2)
DIAG(err_ovl_deleted_init, CLASS_ERROR, diag::MAP_ERROR, "call to %select{unavailable|deleted}0 constructor of %1", 0, true, false, false, false, 2)
DIAG(err_ovl_deleted_member_call, CLASS_ERROR, diag::MAP_ERROR, "call to %select{unavailable|deleted}0 member function %1%2", 0, true, false, false, false, 2)
DIAG(err_ovl_deleted_object_call, CLASS_ERROR, diag::MAP_ERROR, "call to %select{unavailable|deleted}0 function call operator in type %1%2", 0, true, false, false, false, 2)
DIAG(err_ovl_deleted_oper, CLASS_ERROR, diag::MAP_ERROR, "overload resolution selected %select{unavailable|deleted}0 operator '%1'%2", 0, true, false, false, false, 2)
DIAG(err_ovl_deleted_special_init, CLASS_ERROR, diag::MAP_ERROR, "call to implicitly-deleted %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor|function}0 of %1", 0, true, false, false, false, 2)
DIAG(err_ovl_deleted_special_oper, CLASS_ERROR, diag::MAP_ERROR, "overload resolution selected implicitly-deleted %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor|'%1'}0%2", 0, true, false, false, false, 2)
DIAG(err_ovl_diff_return_type, CLASS_ERROR, diag::MAP_ERROR, "functions that differ only in their return type cannot be overloaded", 0, true, false, false, false, 2)
DIAG(err_ovl_no_conversion_in_cast, CLASS_ERROR, diag::MAP_ERROR, "cannot convert %1 to %2 without a conversion operator", 0, true, false, false, false, 2)
DIAG(err_ovl_no_oper, CLASS_ERROR, diag::MAP_ERROR, "type %0 does not provide a %select{subscript|call}1 operator", 0, true, false, false, false, 2)
DIAG(err_ovl_no_viable_conversion_in_cast, CLASS_ERROR, diag::MAP_ERROR, "no matching conversion for %select{|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2", 0, true, false, false, false, 2)
DIAG(err_ovl_no_viable_function_in_call, CLASS_ERROR, diag::MAP_ERROR, "no matching function for call to %0", 0, true, false, false, false, 2)
DIAG(err_ovl_no_viable_function_in_init, CLASS_ERROR, diag::MAP_ERROR, "no matching constructor for initialization of %0", 0, true, false, false, false, 2)
DIAG(err_ovl_no_viable_literal_operator, CLASS_ERROR, diag::MAP_ERROR, "no matching literal operator for call to %0%select{| with argument of type %2| with arguments of types %2 and %3}1%select{| or 'const char *', and no matching literal operator template}4", 0, true, false, false, false, 2)
DIAG(err_ovl_no_viable_member_function_in_call, CLASS_ERROR, diag::MAP_ERROR, "no matching member function for call to %0", 0, true, false, false, false, 2)
DIAG(err_ovl_no_viable_object_call, CLASS_ERROR, diag::MAP_ERROR, "no matching function for call to object of type %0", 0, true, false, false, false, 2)
DIAG(err_ovl_no_viable_oper, CLASS_ERROR, diag::MAP_ERROR, "no viable overloaded '%0'", 0, true, false, false, false, 2)
DIAG(err_ovl_no_viable_subscript, CLASS_ERROR, diag::MAP_ERROR, "no viable overloaded operator[] for type %0", 0, true, false, false, false, 2)
DIAG(err_ovl_static_nonstatic_member, CLASS_ERROR, diag::MAP_ERROR, "static and non-static member functions with the same parameter types cannot be overloaded", 0, true, false, false, false, 2)
DIAG(err_ovl_unresolvable, CLASS_ERROR, diag::MAP_ERROR, "reference to overloaded function could not be resolved; did you mean to call it%select{| with no arguments}0?", 0, true, false, false, false, 2)
DIAG(err_ownership_type, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute only applies to %1 arguments", 0, true, false, false, false, 2)
DIAG(err_ownin_getter_rule, CLASS_ERROR, diag::MAP_ERROR, "property's synthesized getter follows Cocoa naming convention for returning 'owned' objects", 0, true, false, false, false, 2)
DIAG(err_pack_expansion_length_conflict, CLASS_ERROR, diag::MAP_ERROR, "pack expansion contains parameter packs %0 and %1 that have different lengths (%2 vs. %3)", 0, true, false, false, false, 2)
DIAG(err_pack_expansion_length_conflict_multilevel, CLASS_ERROR, diag::MAP_ERROR, "pack expansion contains parameter pack %0 that has a different length (%1 vs. %2) from outer parameter packs", 0, true, false, false, false, 2)
DIAG(err_pack_expansion_member_init, CLASS_ERROR, diag::MAP_ERROR, "pack expansion for initialization of member %0", 0, true, false, false, false, 2)
DIAG(err_pack_expansion_without_parameter_packs, CLASS_ERROR, diag::MAP_ERROR, "pack expansion does not contain any unexpanded parameter packs", 0, true, false, false, false, 2)
DIAG(err_param_default_argument, CLASS_ERROR, diag::MAP_ERROR, "C does not support default arguments", 0, true, false, false, false, 2)
DIAG(err_param_default_argument_member_template_redecl, CLASS_ERROR, diag::MAP_ERROR, "default arguments cannot be added to an out-of-line definition of a member of a %select{class template|class template partial specialization|nested class in a template}0", 0, true, false, false, false, 2)
DIAG(err_param_default_argument_missing, CLASS_ERROR, diag::MAP_ERROR, "missing default argument on parameter", 0, true, false, false, false, 2)
DIAG(err_param_default_argument_missing_name, CLASS_ERROR, diag::MAP_ERROR, "missing default argument on parameter %0", 0, true, false, false, false, 2)
DIAG(err_param_default_argument_nonfunc, CLASS_ERROR, diag::MAP_ERROR, "default arguments can only be specified for parameters in a function declaration", 0, true, false, false, false, 2)
DIAG(err_param_default_argument_redefinition, CLASS_ERROR, diag::MAP_ERROR, "redefinition of default argument", 0, true, false, false, false, 2)
DIAG(err_param_default_argument_references_local, CLASS_ERROR, diag::MAP_ERROR, "default argument references local variable %0 of enclosing function", 0, true, false, false, false, 2)
DIAG(err_param_default_argument_references_param, CLASS_ERROR, diag::MAP_ERROR, "default argument references parameter %0", 0, true, false, false, false, 2)
DIAG(err_param_default_argument_references_this, CLASS_ERROR, diag::MAP_ERROR, "default argument references 'this'", 0, true, false, false, false, 2)
DIAG(err_param_default_argument_template_redecl, CLASS_ERROR, diag::MAP_ERROR, "default arguments cannot be added to a function template that has already been declared", 0, true, false, false, false, 2)
DIAG(err_param_typedef_of_void, CLASS_ERROR, diag::MAP_ERROR, "empty parameter list defined with a %select{typedef|type alias}0 of 'void' not allowed%select{ in C++|}0", 0, true, false, false, false, 2)
DIAG(err_param_with_void_type, CLASS_ERROR, diag::MAP_ERROR, "argument may not have 'void' type", 0, true, false, false, false, 2)
DIAG(err_parameter_name_omitted, CLASS_ERROR, diag::MAP_ERROR, "parameter name omitted", 0, true, false, false, false, 2)
DIAG(err_parameters_retval_cannot_have_fp16_type, CLASS_ERROR, diag::MAP_ERROR, "%select{parameters|function return value}0 cannot have __fp16 type; did you forget * ?", 0, true, false, false, false, 2)
DIAG(err_parens_pointer_member_function, CLASS_ERROR, diag::MAP_ERROR, "cannot parenthesize the name of a method when forming a member pointer", 0, true, false, false, false, 2)
DIAG(err_partial_spec_args_match_primary_template, CLASS_ERROR, diag::MAP_ERROR, "class template partial specialization does not specialize any template argument; to %select{declare|define}0 the primary template, remove the template argument list", 0, true, false, false, false, 2)
DIAG(err_partial_spec_fully_specialized, CLASS_ERROR, diag::MAP_ERROR, "partial specialization of %0 does not use any of its template parameters", 0, true, false, false, false, 2)
DIAG(err_partial_spec_ordering_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "ambiguous partial specializations of %0", 0, true, false, false, false, 2)
DIAG(err_partial_spec_redeclared, CLASS_ERROR, diag::MAP_ERROR, "class template partial specialization %0 cannot be redeclared", 0, true, false, false, false, 2)
DIAG(err_partial_specialization_friend, CLASS_ERROR, diag::MAP_ERROR, "partial specialization cannot be declared as a friend", 0, true, false, false, false, 2)
DIAG(err_placement_new_non_placement_delete, CLASS_ERROR, diag::MAP_ERROR, "'new' expression with placement arguments refers to non-placement 'operator delete'", 0, true, false, false, false, 2)
DIAG(err_pointer_to_member_call_drops_quals, CLASS_ERROR, diag::MAP_ERROR, "call to pointer to member function of type %0 drops '%1' qualifier%s2", 0, true, false, false, false, 2)
DIAG(err_pointer_to_member_oper_value_classify, CLASS_ERROR, diag::MAP_ERROR, "pointer-to-member function type %0 can only be called on an %select{rvalue|lvalue}1", 0, true, false, false, false, 2)
DIAG(err_pointer_to_member_type, CLASS_ERROR, diag::MAP_ERROR, "invalid use of pointer to member type after %select{.*|->*}0", 0, true, false, false, false, 2)
DIAG(err_pragma_options_align_mac68k_target_unsupported, CLASS_ERROR, diag::MAP_ERROR, "mac68k alignment pragma is not supported on this target", 0, true, false, false, false, 2)
DIAG(err_pragma_pop_visibility_mismatch, CLASS_ERROR, diag::MAP_ERROR, "#pragma visibility pop with no matching #pragma visibility push", 0, true, false, false, false, 2)
DIAG(err_pragma_push_visibility_mismatch, CLASS_ERROR, diag::MAP_ERROR, "#pragma visibility push with no matching #pragma visibility pop", 0, true, false, false, false, 2)
DIAG(err_property_found_suggest, CLASS_ERROR, diag::MAP_ERROR, "property %0 found on object of type %1; did you mean to access it with the \".\" operator?", 0, true, false, false, false, 2)
DIAG(err_property_not_as_forward_class, CLASS_ERROR, diag::MAP_ERROR, "property %0 refers to an incomplete Objective-C class %1 (with no @interface available)", 0, true, false, false, false, 2)
DIAG(err_property_not_found, CLASS_ERROR, diag::MAP_ERROR, "property %0 not found on object of type %1", 0, true, false, false, false, 2)
DIAG(err_property_not_found_forward_class, CLASS_ERROR, diag::MAP_ERROR, "property %0 cannot be found in forward class object %1", 0, true, false, false, false, 2)
DIAG(err_property_not_found_suggest, CLASS_ERROR, diag::MAP_ERROR, "property %0 not found on object of type %1; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_property_type, CLASS_ERROR, diag::MAP_ERROR, "property cannot have array or function type %0", 0, true, false, false, false, 2)
DIAG(err_protocol_has_circular_dependency, CLASS_ERROR, diag::MAP_ERROR, "protocol has circular dependency", 0, true, false, false, false, 2)
DIAG(err_pseudo_dtor_base_not_scalar, CLASS_ERROR, diag::MAP_ERROR, "object expression of non-scalar type %0 cannot be used in a pseudo-destructor expression", 0, true, false, false, false, 2)
DIAG(err_pseudo_dtor_call_with_args, CLASS_ERROR, diag::MAP_ERROR, "call to pseudo-destructor cannot have any arguments", 0, true, false, false, false, 2)
DIAG(err_pseudo_dtor_destructor_non_type, CLASS_ERROR, diag::MAP_ERROR, "%0 does not refer to a type name in pseudo-destructor expression; expected the name of type %1", 0, true, false, false, false, 2)
DIAG(err_pseudo_dtor_type_mismatch, CLASS_ERROR, diag::MAP_ERROR, "the type of object expression %diff{($) does not match the type being destroyed ($)|does not match the type being destroyed}0,1 in pseudo-destructor expression", 0, true, false, false, false, 2)
DIAG(err_qualified_catch_declarator, CLASS_ERROR, diag::MAP_ERROR, "exception declarator cannot be qualified", 0, true, false, false, false, 2)
DIAG(err_qualified_friend_def, CLASS_ERROR, diag::MAP_ERROR, "friend function definition cannot be qualified with '%0'", 0, true, false, false, false, 2)
DIAG(err_qualified_friend_not_found, CLASS_ERROR, diag::MAP_ERROR, "no function named %0 with type %1 was found in the specified scope", 0, true, false, false, false, 2)
DIAG(err_qualified_member_nonclass, CLASS_ERROR, diag::MAP_ERROR, "qualified member access refers to a member in %0", 0, true, false, false, false, 2)
DIAG(err_qualified_member_of_unrelated, CLASS_ERROR, diag::MAP_ERROR, "%q0 is not a member of class %1", 0, true, false, false, false, 2)
DIAG(err_qualified_objc_access, CLASS_ERROR, diag::MAP_ERROR, "%select{property|instance variable}0 access cannot be qualified with '%1'", 0, true, false, false, false, 2)
DIAG(err_qualified_objc_catch_parm, CLASS_ERROR, diag::MAP_ERROR, "@catch parameter declarator cannot be qualified", 0, true, false, false, false, 2)
DIAG(err_qualified_param_declarator, CLASS_ERROR, diag::MAP_ERROR, "parameter declarator cannot be qualified", 0, true, false, false, false, 2)
DIAG(err_qualified_typedef_declarator, CLASS_ERROR, diag::MAP_ERROR, "typedef declarator cannot be qualified", 0, true, false, false, false, 2)
DIAG(err_realimag_invalid_type, CLASS_ERROR, diag::MAP_ERROR, "invalid type %0 to %1 operator", 0, true, false, false, false, 2)
DIAG(err_recursive_superclass, CLASS_ERROR, diag::MAP_ERROR, "trying to recursively use %0 as superclass of %1", 0, true, false, false, false, 2)
DIAG(err_redefinition, CLASS_ERROR, diag::MAP_ERROR, "redefinition of %0", 0, true, false, false, false, 2)
DIAG(err_redefinition_different_kind, CLASS_ERROR, diag::MAP_ERROR, "redefinition of %0 as different kind of symbol", 0, true, false, false, false, 2)
DIAG(err_redefinition_different_type, CLASS_ERROR, diag::MAP_ERROR, "redefinition of %0 with a different type%diff{: $ vs $|}1,2", 0, true, false, false, false, 2)
DIAG(err_redefinition_different_typedef, CLASS_ERROR, diag::MAP_ERROR, "%select{typedef|type alias|type alias template}0 redefinition with different types%diff{ ($ vs $)|}1,2", 0, true, false, false, false, 2)
DIAG(err_redefinition_extern_inline, CLASS_ERROR, diag::MAP_ERROR, "redefinition of a 'extern inline' function %0 is not supported in %select{C99 mode|C++}1", 0, true, false, false, false, 2)
DIAG(err_redefinition_of_enumerator, CLASS_ERROR, diag::MAP_ERROR, "redefinition of enumerator %0", 0, true, false, false, false, 2)
DIAG(err_redefinition_of_label, CLASS_ERROR, diag::MAP_ERROR, "redefinition of label %0", 0, true, false, false, false, 2)
DIAG(err_redefinition_variably_modified_typedef, CLASS_ERROR, diag::MAP_ERROR, "redefinition of %select{typedef|type alias}0 for variably-modified type %1", 0, true, false, false, false, 2)
DIAG(err_ref_array_type, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to declaration with an array type inside block", 0, true, false, false, false, 2)
DIAG(err_ref_bad_target, CLASS_ERROR, diag::MAP_ERROR, "reference to %select{__device__|__global__|__host__|__host__ __device__}0 function %1 in %select{__device__|__global__|__host__|__host__ __device__}2 function", 0, true, false, false, false, 2)
DIAG(err_ref_init_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "reference initialization of type %0 with initializer of type %1 is ambiguous", 0, true, false, false, false, 2)
DIAG(err_ref_non_value, CLASS_ERROR, diag::MAP_ERROR, "%0 does not refer to a value", 0, true, false, false, false, 2)
DIAG(err_ref_qualifier_constructor, CLASS_ERROR, diag::MAP_ERROR, "ref-qualifier '%select{&&|&}0' is not allowed on a constructor", 0, true, false, false, false, 2)
DIAG(err_ref_qualifier_destructor, CLASS_ERROR, diag::MAP_ERROR, "ref-qualifier '%select{&&|&}0' is not allowed on a destructor", 0, true, false, false, false, 2)
DIAG(err_ref_qualifier_overload, CLASS_ERROR, diag::MAP_ERROR, "cannot overload a member function %select{without a ref-qualifier|with ref-qualifier '&'|with ref-qualifier '&&'}0 with a member function %select{without a ref-qualifier|with ref-qualifier '&'|with ref-qualifier '&&'}1", 0, true, false, false, false, 2)
DIAG(err_ref_vm_type, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to declaration with a variably modified type inside block", 0, true, false, false, false, 2)
DIAG(err_reference_bind_drops_quals, CLASS_ERROR, diag::MAP_ERROR, "binding of reference %diff{to type $ to a value of type $ drops qualifiers|drops qualifiers}0,1", 0, true, false, false, false, 2)
DIAG(err_reference_bind_failed, CLASS_ERROR, diag::MAP_ERROR, "reference %diff{to type $ could not bind to an %select{rvalue|lvalue}1 of type $|could not bind to %select{rvalue|lvalue}1 of incompatible type}0,2", 0, true, false, false, false, 2)
DIAG(err_reference_bind_init_list, CLASS_ERROR, diag::MAP_ERROR, "reference to type %0 cannot bind to an initializer list", 0, true, false, false, false, 2)
DIAG(err_reference_bind_to_bitfield, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 reference cannot bind to bit-field %1", 0, true, false, false, false, 2)
DIAG(err_reference_bind_to_vector_element, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 reference cannot bind to vector element", 0, true, false, false, false, 2)
DIAG(err_reference_capture_with_reference_default, CLASS_ERROR, diag::MAP_ERROR, "'&' cannot precede a capture when the capture default is '&'", 0, true, false, false, false, 3)
DIAG(err_reference_has_multiple_inits, CLASS_ERROR, diag::MAP_ERROR, "reference cannot be initialized with multiple values", 0, true, false, false, false, 2)
DIAG(err_reference_to_local_var_in_enclosing_block, CLASS_ERROR, diag::MAP_ERROR, "reference to local variable %0 declared in enclosing block literal", 0, true, false, false, false, 2)
DIAG(err_reference_to_local_var_in_enclosing_context, CLASS_ERROR, diag::MAP_ERROR, "reference to local variable %0 declared in enclosing context", 0, true, false, false, false, 2)
DIAG(err_reference_to_local_var_in_enclosing_function, CLASS_ERROR, diag::MAP_ERROR, "reference to local variable %0 declared in enclosing function %1", 0, true, false, false, false, 2)
DIAG(err_reference_to_local_var_in_enclosing_lambda, CLASS_ERROR, diag::MAP_ERROR, "reference to local variable %0 declared in enclosing lambda expression", 0, true, false, false, false, 2)
DIAG(err_reference_to_void, CLASS_ERROR, diag::MAP_ERROR, "cannot form a reference to 'void'", 0, true, false, false, false, 2)
DIAG(err_reference_var_requires_init, CLASS_ERROR, diag::MAP_ERROR, "declaration of reference variable %0 requires an initializer", 0, true, false, false, false, 2)
DIAG(err_reference_without_init, CLASS_ERROR, diag::MAP_ERROR, "reference to type %0 requires an initializer", 0, true, false, false, false, 2)
DIAG(err_regparm_mismatch, CLASS_ERROR, diag::MAP_ERROR, "function declared with with regparm(%0) attribute was previously declared %plural{0:without the regparm|:with the regparm(%1)}1 attribute", 0, true, false, false, false, 2)
DIAG(err_repeat_attribute, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute cannot be repeated", 0, true, false, false, false, 2)
DIAG(err_ret_local_block, CLASS_ERROR, diag::MAP_ERROR, "returning block that lives on the local stack", 0, true, false, false, false, 2)
DIAG(err_return_block_has_expr, CLASS_ERROR, diag::MAP_ERROR, "void block should not return a value", 0, true, false, false, false, 2)
DIAG(err_return_in_constructor_handler, CLASS_ERROR, diag::MAP_ERROR, "return in the catch of a function try block of a constructor is illegal", 0, true, false, false, false, 2)
DIAG(err_return_init_list, CLASS_ERROR, diag::MAP_ERROR, "%select{void function|void method|constructor|destructor}1 %0 must not return a value", 0, true, false, false, false, 2)
DIAG(err_returns_retained_mismatch, CLASS_ERROR, diag::MAP_ERROR, "function declared with the ns_returns_retained attribute was previously declared without the ns_returns_retained attribute", 0, true, false, false, false, 2)
DIAG(err_second_parameter_to_va_arg_abstract, CLASS_ERROR, diag::MAP_ERROR, "second argument to 'va_arg' is of abstract type %0", 0, true, false, false, false, 2)
DIAG(err_second_parameter_to_va_arg_incomplete, CLASS_ERROR, diag::MAP_ERROR, "second argument to 'va_arg' is of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_selected_explicit_constructor, CLASS_ERROR, diag::MAP_ERROR, "chosen constructor is explicit in copy-initialization", 0, true, false, false, false, 2)
DIAG(err_selector_element_not_lvalue, CLASS_ERROR, diag::MAP_ERROR, "selector element is not a valid lvalue", 0, true, false, false, false, 2)
DIAG(err_selector_element_type, CLASS_ERROR, diag::MAP_ERROR, "selector element type %0 is not a valid object", 0, true, false, false, false, 2)
DIAG(err_setter_type_void, CLASS_ERROR, diag::MAP_ERROR, "type of setter must be void", 0, true, false, false, false, 2)
DIAG(err_shufflevector_argument_too_large, CLASS_ERROR, diag::MAP_ERROR, "index for __builtin_shufflevector must be less than the total number of vector elements", 0, true, false, false, false, 2)
DIAG(err_shufflevector_incompatible_vector, CLASS_ERROR, diag::MAP_ERROR, "first two arguments to __builtin_shufflevector must have the same type", 0, true, false, false, false, 2)
DIAG(err_shufflevector_non_vector, CLASS_ERROR, diag::MAP_ERROR, "first two arguments to __builtin_shufflevector must be vectors", 0, true, false, false, false, 2)
DIAG(err_shufflevector_nonconstant_argument, CLASS_ERROR, diag::MAP_ERROR, "index for __builtin_shufflevector must be a constant integer", 0, true, false, false, false, 2)
DIAG(err_sizeof_alignof_bitfield, CLASS_ERROR, diag::MAP_ERROR, "invalid application of '%select{sizeof|__alignof}0' to bit-field", 0, true, false, false, false, 2)
DIAG(err_sizeof_alignof_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "invalid application of '%select{sizeof|__alignof|vec_step}0' to an incomplete type %1", 0, true, false, false, false, 2)
DIAG(err_sizeof_nonfragile_interface, CLASS_ERROR, diag::MAP_ERROR, "application of '%select{alignof|sizeof}1' to interface %0 is not supported on this architecture and platform", 0, true, false, false, false, 2)
DIAG(err_sizeof_pack_no_pack_name, CLASS_ERROR, diag::MAP_ERROR, "%0 does not refer to the name of a parameter pack", 0, true, false, false, false, 2)
DIAG(err_sizeof_pack_no_pack_name_suggest, CLASS_ERROR, diag::MAP_ERROR, "%0 does not refer to the name of a parameter pack; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_spec_member_not_instantiated, CLASS_ERROR, diag::MAP_ERROR, "specialization of member %q0 does not specialize an instantiated member", 0, true, false, false, false, 2)
DIAG(err_specialization_after_instantiation, CLASS_ERROR, diag::MAP_ERROR, "explicit specialization of %0 after instantiation", 0, true, false, false, false, 2)
DIAG(err_specialize_member_of_template, CLASS_ERROR, diag::MAP_ERROR, "cannot specialize (with 'template<>') a member of an unspecialized template", 0, true, false, false, false, 2)
DIAG(err_static_assert_expression_is_not_constant, CLASS_ERROR, diag::MAP_ERROR, "static_assert expression is not an integral constant expression", 0, true, false, false, false, 2)
DIAG(err_static_assert_failed, CLASS_ERROR, diag::MAP_ERROR, "static_assert failed %0", 0, true, false, false, false, 2)
DIAG(err_static_block_func, CLASS_ERROR, diag::MAP_ERROR, "function declared in block scope cannot have 'static' storage class", 0, true, false, false, false, 2)
DIAG(err_static_data_member_not_allowed_in_anon_struct, CLASS_ERROR, diag::MAP_ERROR, "static data member %0 not allowed in anonymous struct", 0, true, false, false, false, 2)
DIAG(err_static_data_member_not_allowed_in_local_class, CLASS_ERROR, diag::MAP_ERROR, "static data member %0 not allowed in local class %1", 0, true, false, false, false, 2)
DIAG(err_static_downcast_via_virtual, CLASS_ERROR, diag::MAP_ERROR, "cannot cast %0 to %1 via virtual base %2", 0, true, false, false, false, 2)
DIAG(err_static_function_scope, CLASS_ERROR, diag::MAP_ERROR, "variables in function scope cannot be declared static", 0, true, false, false, false, 2)
DIAG(err_static_illegal_in_new, CLASS_ERROR, diag::MAP_ERROR, "the 'static' modifier for the array size is not legal in new expressions", 0, true, false, false, false, 2)
DIAG(err_static_kernel, CLASS_ERROR, diag::MAP_ERROR, "kernel functions cannot be declared static", 0, true, false, false, false, 2)
DIAG(err_static_main, CLASS_ERROR, diag::MAP_ERROR, "'main' is not allowed to be declared static", 0, true, false, false, false, 2)
DIAG(err_static_non_static, CLASS_ERROR, diag::MAP_ERROR, "static declaration of %0 follows non-static declaration", 0, true, false, false, false, 2)
DIAG(err_static_not_bitfield, CLASS_ERROR, diag::MAP_ERROR, "static member %0 cannot be a bit-field", 0, true, false, false, false, 2)
DIAG(err_static_out_of_line, CLASS_ERROR, diag::MAP_ERROR, "'static' can only be specified inside the class definition", 0, true, false, false, false, 2)
DIAG(err_static_overrides_virtual, CLASS_ERROR, diag::MAP_ERROR, "'static' member function %0 overrides a virtual function in a base class", 0, true, false, false, false, 2)
DIAG(err_statically_allocated_object, CLASS_ERROR, diag::MAP_ERROR, "interface type cannot be statically allocated", 0, true, false, false, false, 2)
DIAG(err_stmtexpr_file_scope, CLASS_ERROR, diag::MAP_ERROR, "statement expression not allowed at file scope", 0, true, false, false, false, 2)
DIAG(err_storage_spec_on_catch_parm, CLASS_ERROR, diag::MAP_ERROR, "@catch parameter cannot have storage specifier %select{|'typedef'|'extern'|'static'|'auto'|'register'|'__private_extern__'|'mutable'}0", 0, true, false, false, false, 2)
DIAG(err_storageclass_invalid_for_member, CLASS_ERROR, diag::MAP_ERROR, "storage class specified for a member declaration", 0, true, false, false, false, 2)
DIAG(err_subscript_function_type, CLASS_ERROR, diag::MAP_ERROR, "subscript of pointer to function type %0", 0, true, false, false, false, 2)
DIAG(err_subscript_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "subscript of pointer to incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_subscript_nonfragile_interface, CLASS_ERROR, diag::MAP_ERROR, "subscript requires size of interface %0, which is not constant for this architecture and platform", 0, true, false, false, false, 2)
DIAG(err_suppress_autosynthesis, CLASS_ERROR, diag::MAP_ERROR, "objc_requires_property_definitions attribute may only be specified on a classto a class declaration", 0, true, false, false, false, 2)
DIAG(err_switch_explicit_conversion, CLASS_ERROR, diag::MAP_ERROR, "switch condition type %0 requires explicit conversion to %1", 0, true, false, false, false, 2)
DIAG(err_switch_incomplete_class_type, CLASS_ERROR, diag::MAP_ERROR, "switch condition has incomplete class type %0", 0, true, false, false, false, 2)
DIAG(err_switch_into_protected_scope, CLASS_ERROR, diag::MAP_ERROR, "switch case is in protected scope", 0, true, false, false, false, 2)
DIAG(err_switch_multiple_conversions, CLASS_ERROR, diag::MAP_ERROR, "multiple conversions from switch condition type %0 to an integral or enumeration type", 0, true, false, false, false, 2)
DIAG(err_tag_definition_of_typedef, CLASS_ERROR, diag::MAP_ERROR, "definition of type %0 conflicts with %select{typedef|type alias}1 of the same name", 0, true, false, false, false, 2)
DIAG(err_tag_reference_conflict, CLASS_ERROR, diag::MAP_ERROR, "implicit declaration introduced by elaborated type conflicts with %select{a declaration|a typedef|a type alias|a template}0 of the same name", 0, true, false, false, false, 2)
DIAG(err_tag_reference_non_tag, CLASS_ERROR, diag::MAP_ERROR, "elaborated type refers to %select{a non-tag type|a typedef|a type alias|a template|a type alias template}0", 0, true, false, false, false, 2)
DIAG(err_tagless_friend_type_template, CLASS_ERROR, diag::MAP_ERROR, "friend type templates must use an elaborated type", 0, true, false, false, false, 2)
DIAG(err_temp_copy_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "ambiguous constructor call when %select{copying variable|copying parameter|returning object|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element|capturing value}0 of type %1", 0, true, false, false, false, 2)
DIAG(err_temp_copy_deleted, CLASS_ERROR, diag::MAP_ERROR, "%select{copying variable|copying parameter|returning object|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element|capturing value}0 of type %1 invokes deleted constructor", 0, true, false, false, false, 2)
DIAG(err_temp_copy_incomplete, CLASS_ERROR, diag::MAP_ERROR, "copying a temporary object of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_temp_copy_no_viable, CLASS_ERROR, diag::MAP_ERROR, "no viable constructor %select{copying variable|copying parameter|returning object|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element|capturing value}0 of type %1", 0, true, false, false, false, 2)
DIAG(err_template_arg_address_of_non_pointer, CLASS_ERROR, diag::MAP_ERROR, "address taken in non-type template argument for template parameter of reference type %0", 0, true, false, false, false, 2)
DIAG(err_template_arg_field, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument refers to non-static data member %0", 0, true, false, false, false, 2)
DIAG(err_template_arg_list_different_arity, CLASS_ERROR, diag::MAP_ERROR, "%select{too few|too many}0 template arguments for %select{class template|function template|template template parameter|template}1 %2", 0, true, false, false, false, 2)
DIAG(err_template_arg_method, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument refers to non-static member function %0", 0, true, false, false, false, 2)
DIAG(err_template_arg_must_be_expr, CLASS_ERROR, diag::MAP_ERROR, "template argument for non-type template parameter must be an expression", 0, true, false, false, false, 2)
DIAG(err_template_arg_must_be_template, CLASS_ERROR, diag::MAP_ERROR, "template argument for template template parameter must be a class template%select{| or type alias template}0", 0, true, false, false, false, 2)
DIAG(err_template_arg_must_be_type, CLASS_ERROR, diag::MAP_ERROR, "template argument for template type parameter must be a type", 0, true, false, false, false, 2)
DIAG(err_template_arg_must_be_type_suggest, CLASS_ERROR, diag::MAP_ERROR, "template argument for template type parameter must be a type; did you forget 'typename'?", 0, true, false, false, false, 2)
DIAG(err_template_arg_no_ref_bind, CLASS_ERROR, diag::MAP_ERROR, "non-type template parameter of reference type %diff{$ cannot bind to template argument of type $|cannot bind to template of incompatible argument type}0,1", 0, true, false, false, false, 2)
DIAG(err_template_arg_nontype_ambig, CLASS_ERROR, diag::MAP_ERROR, "template argument for non-type template parameter is treated as type %0", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_address_constant, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument of type %0 is not a constant expression", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_address_of, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument for template parameter of pointer type %0 must have its address taken", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_class_template, CLASS_ERROR, diag::MAP_ERROR, "template argument does not refer to a class template or template template parameter", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_convertible, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument of type %0 cannot be converted to a value of type %1", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_decl_ref, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument does not refer to any declaration", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_ice, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument of type %0 is not an integral constant expression", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_integral_or_enumeral, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument of type %0 must have an integral or enumeration type", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_object_or_func, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument does not refer to an object or function", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_object_or_func_form, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument does not directly refer to an object or function", 0, true, false, false, false, 2)
DIAG(err_template_arg_not_pointer_to_member_form, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument is not a pointer to member constant", 0, true, false, false, false, 2)
DIAG(err_template_arg_object_no_linkage, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument refers to %select{function|object}0 %1 that does not have linkage", 0, true, false, false, false, 2)
DIAG(err_template_arg_overload_type, CLASS_ERROR, diag::MAP_ERROR, "template argument is the type of an unresolved overloaded function", 0, true, false, false, false, 2)
DIAG(err_template_arg_ref_bind_ignores_quals, CLASS_ERROR, diag::MAP_ERROR, "reference binding of non-type template parameter %diff{of type $ to template argument of type $|to template argument}0,1 ignores qualifiers", 0, true, false, false, false, 2)
DIAG(err_template_arg_reference_var, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument of reference type %0 is not an object", 0, true, false, false, false, 2)
DIAG(err_template_arg_template_params_mismatch, CLASS_ERROR, diag::MAP_ERROR, "template template argument has different template parameters than its corresponding template template parameter", 0, true, false, false, false, 2)
DIAG(err_template_arg_thread_local, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument refers to thread-local object", 0, true, false, false, false, 2)
DIAG(err_template_arg_untyped_null_constant, CLASS_ERROR, diag::MAP_ERROR, "null non-type template argument must be cast to template parameter type %0", 0, true, false, false, false, 2)
DIAG(err_template_arg_wrongtype_null_constant, CLASS_ERROR, diag::MAP_ERROR, "null non-type template argument of type %0 does not match template parameter of type %1", 0, true, false, false, false, 2)
DIAG(err_template_decl_ref, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to class template %0 without a template argument list", 0, true, false, false, false, 2)
DIAG(err_template_id_not_a_type, CLASS_ERROR, diag::MAP_ERROR, "template name refers to non-type template '%0'", 0, true, false, false, false, 2)
DIAG(err_template_instantiate_undefined, CLASS_ERROR, diag::MAP_ERROR, "%select{implicit|explicit}0 instantiation of undefined template %1", 0, true, false, false, false, 2)
DIAG(err_template_instantiate_within_definition, CLASS_ERROR, diag::MAP_ERROR, "%select{implicit|explicit}0 instantiation of template %1 within its own definition", 0, true, false, false, false, 2)
DIAG(err_template_kw_missing, CLASS_ERROR, diag::MAP_ERROR, "missing 'template' keyword prior to dependent template name '%0%1'", 0, true, false, false, false, 2)
DIAG(err_template_kw_refers_to_class_template, CLASS_ERROR, diag::MAP_ERROR, "'%0%1' instantiated to a class template, not a function template", 0, true, false, false, false, 2)
DIAG(err_template_kw_refers_to_non_template, CLASS_ERROR, diag::MAP_ERROR, "%0 following the 'template' keyword does not refer to a template", 0, true, false, false, false, 2)
DIAG(err_template_linkage, CLASS_ERROR, diag::MAP_ERROR, "templates must have C++ linkage", 0, true, false, false, false, 2)
DIAG(err_template_member, CLASS_ERROR, diag::MAP_ERROR, "member %0 declared as a template", 0, true, false, false, false, 2)
DIAG(err_template_member_noparams, CLASS_ERROR, diag::MAP_ERROR, "extraneous 'template<>' in declaration of member %0", 0, true, false, false, false, 2)
DIAG(err_template_missing_args, CLASS_ERROR, diag::MAP_ERROR, "use of class template %0 requires template arguments", 0, true, false, false, false, 2)
DIAG(err_template_nontype_parm_bad_type, CLASS_ERROR, diag::MAP_ERROR, "a non-type template parameter cannot have type %0", 0, true, false, false, false, 2)
DIAG(err_template_nontype_parm_different_type, CLASS_ERROR, diag::MAP_ERROR, "template non-type parameter has a different type %0 in template %select{|template parameter }1redeclaration", 0, true, false, false, false, 2)
DIAG(err_template_outside_namespace_or_class_scope, CLASS_ERROR, diag::MAP_ERROR, "templates can only be declared in namespace or class scope", 0, true, false, false, false, 2)
DIAG(err_template_param_default_arg_missing, CLASS_ERROR, diag::MAP_ERROR, "template parameter missing a default argument", 0, true, false, false, false, 2)
DIAG(err_template_param_default_arg_redefinition, CLASS_ERROR, diag::MAP_ERROR, "template parameter redefines default argument", 0, true, false, false, false, 2)
DIAG(err_template_param_different_kind, CLASS_ERROR, diag::MAP_ERROR, "template parameter has a different kind in template %select{|template parameter }0redeclaration", 0, true, false, false, false, 2)
DIAG(err_template_param_list_different_arity, CLASS_ERROR, diag::MAP_ERROR, "%select{too few|too many}0 template parameters in template %select{|template parameter }1redeclaration", 0, true, false, false, false, 2)
DIAG(err_template_param_list_matches_nontemplate, CLASS_ERROR, diag::MAP_ERROR, "template parameter list matching the non-templated nested type %0 should be empty ('template<>')", 0, true, false, false, false, 2)
DIAG(err_template_param_pack_default_arg, CLASS_ERROR, diag::MAP_ERROR, "template parameter pack cannot have a default argument", 0, true, false, false, false, 2)
DIAG(err_template_param_pack_must_be_last_template_parameter, CLASS_ERROR, diag::MAP_ERROR, "template parameter pack must be the last template parameter", 0, true, false, false, false, 2)
DIAG(err_template_param_shadow, CLASS_ERROR, diag::MAP_ERROR, "declaration of %0 shadows template parameter", 0, true, false, false, false, 2)
DIAG(err_template_parameter_default_friend_template, CLASS_ERROR, diag::MAP_ERROR, "default template argument not permitted on a friend template", 0, true, false, false, false, 2)
DIAG(err_template_parameter_default_template_member, CLASS_ERROR, diag::MAP_ERROR, "cannot add a default template argument to the definition of a member of a class template", 0, true, false, false, false, 2)
DIAG(err_template_parameter_pack_non_pack, CLASS_ERROR, diag::MAP_ERROR, "%select{template type|non-type template|template template}0 parameter%select{| pack}1 conflicts with previous %select{template type|non-type template|template template}0 parameter%select{ pack|}1", 0, true, false, false, false, 2)
DIAG(err_template_qualified_declarator_no_match, CLASS_ERROR, diag::MAP_ERROR, "nested name specifier '%0' for declaration does not refer into a class, class template or class template partial specialization", 0, true, false, false, false, 2)
DIAG(err_template_recursion_depth_exceeded, CLASS_ERROR, diag::MAP_FATAL, "recursive template instantiation exceeded maximum depth of %0", 0, false, false, false, false, 2)
DIAG(err_template_spec_decl_class_scope, CLASS_ERROR, diag::MAP_ERROR, "explicit specialization of %0 in class scope", 0, true, false, false, false, 2)
DIAG(err_template_spec_decl_friend, CLASS_ERROR, diag::MAP_ERROR, "cannot declare an explicit specialization in a friend", 0, true, false, false, false, 2)
DIAG(err_template_spec_decl_function_scope, CLASS_ERROR, diag::MAP_ERROR, "explicit specialization of %0 in function scope", 0, true, false, false, false, 2)
DIAG(err_template_spec_decl_out_of_scope, CLASS_ERROR, diag::MAP_ERROR, "%select{class template|class template partial|function template|member function|static data member|member class|member enumeration}0 specialization of %1 must originally be declared in namespace %2", 0, true, false, false, false, 2)
DIAG(err_template_spec_decl_out_of_scope_global, CLASS_ERROR, diag::MAP_ERROR, "%select{class template|class template partial|function template|member function|static data member|member class|member enumeration}0 specialization of %1 must originally be declared in the global scope", 0, true, false, false, false, 2)
DIAG(err_template_spec_default_arg, CLASS_ERROR, diag::MAP_ERROR, "default argument not permitted on an explicit %select{instantiation|specialization}0 of function %1", 0, true, false, false, false, 2)
DIAG(err_template_spec_extra_headers, CLASS_ERROR, diag::MAP_ERROR, "extraneous template parameter list in template specialization or out-of-line template definition", 0, true, false, false, false, 2)
DIAG(err_template_spec_friend, CLASS_ERROR, diag::MAP_ERROR, "template specialization declaration cannot be a friend", 0, true, false, false, false, 2)
DIAG(err_template_spec_needs_header, CLASS_ERROR, diag::MAP_ERROR, "template specialization requires 'template<>'", 0, true, false, false, false, 2)
DIAG(err_template_spec_needs_template_parameters, CLASS_ERROR, diag::MAP_ERROR, "template specialization or definition requires a template parameter list corresponding to the nested type %0", 0, true, false, false, false, 2)
DIAG(err_template_spec_redecl_global_scope, CLASS_ERROR, diag::MAP_ERROR, "%select{class template|class template partial|function template|member function|static data member|member class|member enumeration}0 specialization of %1 must occur at global scope", 0, true, false, false, false, 2)
DIAG(err_template_spec_redecl_out_of_scope, CLASS_ERROR, diag::MAP_ERROR, "%select{class template|class template partial|function template|member function|static data member|member class|member enumeration}0 specialization of %1 not in a namespace enclosing %2", 0, true, false, false, false, 2)
DIAG(err_template_spec_unknown_kind, CLASS_ERROR, diag::MAP_ERROR, "can only provide an explicit specialization for a class template, function template, or a member function, static data member, %select{or member class|member class, or member enumeration}0 of a class template", 0, true, false, false, false, 2)
DIAG(err_template_tag_noparams, CLASS_ERROR, diag::MAP_ERROR, "extraneous 'template<>' in declaration of %0 %1", 0, true, false, false, false, 2)
DIAG(err_template_template_parm_no_parms, CLASS_ERROR, diag::MAP_ERROR, "template template parameter must have its own template parameters", 0, true, false, false, false, 2)
DIAG(err_template_typedef, CLASS_ERROR, diag::MAP_ERROR, "a typedef cannot be a template", 0, true, false, false, false, 2)
DIAG(err_template_unnamed_class, CLASS_ERROR, diag::MAP_ERROR, "cannot declare a class template with no name", 0, true, false, false, false, 2)
DIAG(err_template_variable, CLASS_ERROR, diag::MAP_ERROR, "variable %0 declared as a template", 0, true, false, false, false, 2)
DIAG(err_template_variable_noparams, CLASS_ERROR, diag::MAP_ERROR, "extraneous 'template<>' in declaration of variable %0", 0, true, false, false, false, 2)
DIAG(err_tentative_def_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "tentative definition has type %0 that is never completed", 0, true, false, false, false, 2)
DIAG(err_tentative_def_incomplete_type_arr, CLASS_ERROR, diag::MAP_ERROR, "tentative definition has array of type %0 that is never completed", 0, true, false, false, false, 2)
DIAG(err_this_capture, CLASS_ERROR, diag::MAP_ERROR, "'this' cannot be %select{implicitly |}0captured in this context", 0, true, false, false, false, 3)
DIAG(err_this_capture_with_copy_default, CLASS_ERROR, diag::MAP_ERROR, "'this' cannot be explicitly captured when the capture default is '='", 0, true, false, false, false, 3)
DIAG(err_this_static_member_func, CLASS_ERROR, diag::MAP_ERROR, "'this' cannot be%select{| implicitly}0 used in a static member function declaration", 0, true, false, false, false, 2)
DIAG(err_thread_non_global, CLASS_ERROR, diag::MAP_ERROR, "'__thread' variables must have global storage", 0, true, false, false, false, 2)
DIAG(err_thread_non_thread, CLASS_ERROR, diag::MAP_ERROR, "thread-local declaration of %0 follows non-thread-local declaration", 0, true, false, false, false, 2)
DIAG(err_thread_unsupported, CLASS_ERROR, diag::MAP_ERROR, "thread-local storage is unsupported for the current target", 0, true, false, false, false, 2)
DIAG(err_throw_abstract_type, CLASS_ERROR, diag::MAP_ERROR, "cannot throw an object of abstract type %0", 0, true, false, false, false, 2)
DIAG(err_throw_incomplete, CLASS_ERROR, diag::MAP_ERROR, "cannot throw object of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_throw_incomplete_ptr, CLASS_ERROR, diag::MAP_ERROR, "cannot throw pointer to object of incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_toomany_element_decls, CLASS_ERROR, diag::MAP_ERROR, "only one element declaration is allowed", 0, true, false, false, false, 2)
DIAG(err_trailing_return_in_parens, CLASS_ERROR, diag::MAP_ERROR, "trailing return type may not be nested within parentheses", 0, true, false, false, false, 2)
DIAG(err_trailing_return_without_auto, CLASS_ERROR, diag::MAP_ERROR, "function with trailing return type must specify return type 'auto', not %0", 0, true, false, false, false, 2)
DIAG(err_type_defined_in_alias_template, CLASS_ERROR, diag::MAP_ERROR, "%0 can not be defined in a type alias template", 0, true, false, false, false, 2)
DIAG(err_type_defined_in_condition, CLASS_ERROR, diag::MAP_ERROR, "types may not be defined in conditions", 0, true, false, false, false, 2)
DIAG(err_type_defined_in_for_range, CLASS_ERROR, diag::MAP_ERROR, "types may not be defined in a for range declaration", 0, true, false, false, false, 2)
DIAG(err_type_defined_in_param_type, CLASS_ERROR, diag::MAP_ERROR, "%0 can not be defined in a parameter type", 0, true, false, false, false, 2)
DIAG(err_type_defined_in_result_type, CLASS_ERROR, diag::MAP_ERROR, "%0 can not be defined in the result type of a function", 0, true, false, false, false, 2)
DIAG(err_type_defined_in_type_specifier, CLASS_ERROR, diag::MAP_ERROR, "%0 can not be defined in a type specifier", 0, true, false, false, false, 2)
DIAG(err_type_mismatch_continuation_class, CLASS_ERROR, diag::MAP_ERROR, "type of property %0 in class extension does not match property type in primary class", 0, true, false, false, false, 2)
DIAG(err_type_tag_for_datatype_not_ice, CLASS_ERROR, diag::MAP_ERROR, "'type_tag_for_datatype' attribute requires the initializer to be an %select{integer|integral}0 constant expression", 0, true, false, false, false, 2)
DIAG(err_type_tag_for_datatype_too_large, CLASS_ERROR, diag::MAP_ERROR, "'type_tag_for_datatype' attribute requires the initializer to be an %select{integer|integral}0 constant expression that can be represented by a 64 bit integer", 0, true, false, false, false, 2)
DIAG(err_type_trait_arity, CLASS_ERROR, diag::MAP_ERROR, "type trait requires %0%select{| or more}1 argument%select{|s}2; have %3 argument%s3", 0, true, false, false, false, 2)
DIAG(err_typecheck_address_of, CLASS_ERROR, diag::MAP_ERROR, "address of %select{bit-field|vector element|property expression|register variable}0 requested", 0, true, false, false, false, 2)
DIAG(err_typecheck_addrof_class_temporary, CLASS_ERROR, diag::MAP_ERROR, "taking the address of a temporary object of type %0", 0, true, false, false, false, 2)
DIAG(err_typecheck_ambiguous_condition, CLASS_ERROR, diag::MAP_ERROR, "conversion %diff{from $ to $|between types}0,1 is ambiguous", 0, true, false, false, false, 2)
DIAG(err_typecheck_arc_assign_self, CLASS_ERROR, diag::MAP_ERROR, "cannot assign to 'self' outside of a method in the init family", 0, true, false, false, false, 5)
DIAG(err_typecheck_arc_assign_self_class_method, CLASS_ERROR, diag::MAP_ERROR, "cannot assign to 'self' in a class method", 0, true, false, false, false, 5)
DIAG(err_typecheck_arithmetic_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "arithmetic on a pointer to an incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_typecheck_arr_assign_enumeration, CLASS_ERROR, diag::MAP_ERROR, "fast enumeration variables can't be modified in ARC by default; declare the variable __strong to allow this", 0, true, false, false, false, 5)
DIAG(err_typecheck_array_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "array type %0 is not assignable", 0, true, false, false, false, 2)
DIAG(err_typecheck_assign_const, CLASS_ERROR, diag::MAP_ERROR, "read-only variable is not assignable", 0, true, false, false, false, 2)
DIAG(err_typecheck_bool_condition, CLASS_ERROR, diag::MAP_ERROR, "value of type %0 is not contextually convertible to 'bool'", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_invalid_ordered_compare, CLASS_ERROR, diag::MAP_ERROR, "ordered compare requires two args of floating point type%diff{ ($ and $)|}0,1", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_invalid_unary_fp, CLASS_ERROR, diag::MAP_ERROR, "floating point classification requires argument of floating point type (passed in %0)", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_not_function, CLASS_ERROR, diag::MAP_ERROR, "called object type %0 is not a function or function pointer", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_too_few_args, CLASS_ERROR, diag::MAP_ERROR, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected %1, have %2", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_too_few_args_at_least, CLASS_ERROR, diag::MAP_ERROR, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected at least %1, have %2", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_too_few_args_at_least_one, CLASS_ERROR, diag::MAP_ERROR, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, at least argument %1 must be specified", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_too_few_args_one, CLASS_ERROR, diag::MAP_ERROR, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, single argument %1 was not specified", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_too_many_args, CLASS_ERROR, diag::MAP_ERROR, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected %1, have %2", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_too_many_args_at_most, CLASS_ERROR, diag::MAP_ERROR, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected at most %1, have %2", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_too_many_args_at_most_one, CLASS_ERROR, diag::MAP_ERROR, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected at most single argument %1, have %2 arguments", 0, true, false, false, false, 2)
DIAG(err_typecheck_call_too_many_args_one, CLASS_ERROR, diag::MAP_ERROR, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected single argument %1, have %2 arguments", 0, true, false, false, false, 2)
DIAG(err_typecheck_cast_to_incomplete, CLASS_ERROR, diag::MAP_ERROR, "cast to incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_typecheck_cast_to_union_no_type, CLASS_ERROR, diag::MAP_ERROR, "cast to union type from type %0 not present in union", 0, true, false, false, false, 2)
DIAG(err_typecheck_choose_expr_requires_constant, CLASS_ERROR, diag::MAP_ERROR, "'__builtin_choose_expr' requires a constant expression", 0, true, false, false, false, 2)
DIAG(err_typecheck_comparison_of_distinct_blocks, CLASS_ERROR, diag::MAP_ERROR, "comparison of distinct block types%diff{ ($ and $)|}0,1", 0, true, false, false, false, 2)
DIAG(err_typecheck_comparison_of_distinct_pointers, CLASS_ERROR, diag::MAP_ERROR, "comparison of distinct pointer types%diff{ ($ and $)|}0,1", 0, true, false, false, false, 2)
DIAG(err_typecheck_comparison_of_fptr_to_void, CLASS_ERROR, diag::MAP_ERROR, "equality comparison between function pointer and void pointer (%0 and %1)", 0, true, false, false, false, 2)
DIAG(err_typecheck_comparison_of_pointer_integer, CLASS_ERROR, diag::MAP_ERROR, "comparison between pointer and integer (%0 and %1)", 0, true, false, false, false, 2)
DIAG(err_typecheck_cond_expect_scalar, CLASS_ERROR, diag::MAP_ERROR, "used type %0 where arithmetic or pointer type is required", 0, true, false, false, false, 2)
DIAG(err_typecheck_cond_expect_scalar_or_vector, CLASS_ERROR, diag::MAP_ERROR, "used type %0 where arithmetic, pointer, or vector type is required", 0, true, false, false, false, 2)
DIAG(err_typecheck_cond_incompatible_operands, CLASS_ERROR, diag::MAP_ERROR, "incompatible operand types%diff{ ($ and $)|}0,1", 0, true, false, false, false, 2)
DIAG(err_typecheck_cond_incompatible_operands_null, CLASS_ERROR, diag::MAP_ERROR, "non-pointer operand type %0 incompatible with %select{NULL|nullptr}1", 0, true, false, false, false, 2)
DIAG(err_typecheck_convert_incompatible, CLASS_ERROR, diag::MAP_ERROR, "%select{%diff{assigning to $ from incompatible type $|assigning to type from incompatible type}0,1|%diff{passing $ to parameter of incompatible type $|passing type to parameter of incompatible type}0,1|%diff{returning $ from a function with incompatible result type $|returning type from a function with incompatible result type}0,1|%diff{converting $ to incompatible type $|converting type to incompatible type}0,1|%diff{initializing $ with an expression of incompatible type $|initializing type with an expression of incompatible type}0,1|%diff{sending $ to parameter of incompatible type $|sending type to parameter of incompatible type}0,1|%diff{casting $ to incompatible type $|casting type to incompatible type}0,1}2%select{|; dereference with *|; take the address with &|; remove *|; remove &}3%select{|: different classes%diff{ ($ vs $)|}5,6|: different number of parameters (%5 vs %6)|: type mismatch at %ordinal5 parameter%diff{ ($ vs $)|}6,7|: different return type%diff{ ($ vs $)|}5,6|: different qualifiers (%select{none|const|restrict|const and restrict|volatile|const and volatile|volatile and restrict|const, volatile, and restrict}5 vs %select{none|const|restrict|const and restrict|volatile|const and volatile|volatile and restrict|const, volatile, and restrict}6)}4", 0, true, false, false, false, 2)
DIAG(err_typecheck_convert_incompatible_block_pointer, CLASS_ERROR, diag::MAP_ERROR, "incompatible block pointer types %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2", 0, true, false, false, false, 2)
DIAG(err_typecheck_converted_constant_expression, CLASS_ERROR, diag::MAP_ERROR, "value of type %0 is not implicitly convertible to %1", 0, true, false, false, false, 2)
DIAG(err_typecheck_converted_constant_expression_disallowed, CLASS_ERROR, diag::MAP_ERROR, "conversion from %0 to %1 is not allowed in a converted constant expression", 0, true, false, false, false, 2)
DIAG(err_typecheck_decl_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "variable has incomplete type %0", 0, true, false, false, false, 2)
DIAG(err_typecheck_deleted_function, CLASS_ERROR, diag::MAP_ERROR, "conversion function %diff{from $ to $|between types}0,1 invokes a deleted function", 0, true, false, false, false, 2)
DIAG(err_typecheck_duplicate_vector_components_not_mlvalue, CLASS_ERROR, diag::MAP_ERROR, "vector is not assignable (contains duplicate components)", 0, true, false, false, false, 2)
DIAG(err_typecheck_expect_scalar_operand, CLASS_ERROR, diag::MAP_ERROR, "operand of type %0 where arithmetic or pointer type is required", 0, true, false, false, false, 2)
DIAG(err_typecheck_expression_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "expression is not assignable", 0, true, false, false, false, 2)
DIAG(err_typecheck_ext_vector_not_typedef, CLASS_ERROR, diag::MAP_ERROR, "ext_vector_type only applies to types, not variables", 0, true, false, false, false, 2)
DIAG(err_typecheck_field_variable_size, CLASS_ERROR, diag::MAP_ERROR, "fields must have a constant size: 'variable length array in structure' extension will never be supported", 0, true, false, false, false, 2)
DIAG(err_typecheck_illegal_increment_decrement, CLASS_ERROR, diag::MAP_ERROR, "cannot %select{decrement|increment}1 value of type %0", 0, true, false, false, false, 2)
DIAG(err_typecheck_incompatible_address_space, CLASS_ERROR, diag::MAP_ERROR, "%select{%diff{assigning $ to $|assigning to different types}1,0|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 changes address space of pointer", 0, true, false, false, false, 2)
DIAG(err_typecheck_incompatible_ownership, CLASS_ERROR, diag::MAP_ERROR, "%select{%diff{assigning $ to $|assigning to different types}1,0|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 changes retain/release properties of pointer", 0, true, false, false, false, 2)
DIAG(err_typecheck_incomplete_array_needs_initializer, CLASS_ERROR, diag::MAP_ERROR, "definition of variable with array type needs an explicit size or an initializer", 0, true, false, false, false, 2)
DIAG(err_typecheck_incomplete_tag, CLASS_ERROR, diag::MAP_ERROR, "incomplete definition of type %0", 0, true, false, false, false, 2)
DIAG(err_typecheck_incomplete_type_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "incomplete type %0 is not assignable", 0, true, false, false, false, 2)
DIAG(err_typecheck_indirection_requires_pointer, CLASS_ERROR, diag::MAP_ERROR, "indirection requires pointer operand (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_typecheck_invalid_lvalue_addrof, CLASS_ERROR, diag::MAP_ERROR, "address expression must be an lvalue or a function designator", 0, true, false, false, false, 2)
DIAG(err_typecheck_invalid_operands, CLASS_ERROR, diag::MAP_ERROR, "invalid operands to binary expression (%0 and %1)", 0, true, false, false, false, 2)
DIAG(err_typecheck_invalid_restrict_invalid_pointee, CLASS_ERROR, diag::MAP_ERROR, "pointer to function type %0 may not be 'restrict' qualified", 0, true, false, false, false, 2)
DIAG(err_typecheck_invalid_restrict_not_pointer, CLASS_ERROR, diag::MAP_ERROR, "restrict requires a pointer or reference (%0 is invalid)", 0, true, false, false, false, 2)
DIAG(err_typecheck_invalid_restrict_not_pointer_noarg, CLASS_ERROR, diag::MAP_ERROR, "restrict requires a pointer or reference", 0, true, false, false, false, 2)
DIAG(err_typecheck_ivar_variable_size, CLASS_ERROR, diag::MAP_ERROR, "instance variables must have a constant size", 0, true, false, false, false, 2)
DIAG(err_typecheck_lvalue_casts_not_supported, CLASS_ERROR, diag::MAP_ERROR, "assignment to cast is illegal, lvalue casts are not supported", 0, true, false, false, false, 2)
DIAG(err_typecheck_member_reference_arrow, CLASS_ERROR, diag::MAP_ERROR, "member reference type %0 is not a pointer", 0, true, false, false, false, 2)
DIAG(err_typecheck_member_reference_ivar, CLASS_ERROR, diag::MAP_ERROR, "%0 does not have a member named %1", 0, true, false, false, false, 2)
DIAG(err_typecheck_member_reference_ivar_suggest, CLASS_ERROR, diag::MAP_ERROR, "%0 does not have a member named %1; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_typecheck_member_reference_struct_union, CLASS_ERROR, diag::MAP_ERROR, "member reference base type %0 is not a structure or union", 0, true, false, false, false, 2)
DIAG(err_typecheck_member_reference_suggestion, CLASS_ERROR, diag::MAP_ERROR, "member reference type %0 is %select{a|not a}1 pointer; maybe you meant to use '%select{->|.}1'?", 0, true, false, false, false, 2)
DIAG(err_typecheck_member_reference_type, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to type member %0 in %1 with '%select{.|->}2'", 0, true, false, false, false, 2)
DIAG(err_typecheck_member_reference_unknown, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to member %0 in %1 with '%select{.|->}2'", 0, true, false, false, false, 2)
DIAG(err_typecheck_missing_return_type_incompatible, CLASS_ERROR, diag::MAP_ERROR, "%diff{return type $ must match previous return type $|return type must match previous return type}0,1 when %select{block literal|lambda expression}2 has unspecified explicit return type", 0, true, false, false, false, 2)
DIAG(err_typecheck_negative_array_size, CLASS_ERROR, diag::MAP_ERROR, "array size is negative", 0, true, false, false, false, 2)
DIAG(err_typecheck_non_object_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "non-object type %0 is not assignable", 0, true, false, false, false, 2)
DIAG(err_typecheck_nonviable_condition, CLASS_ERROR, diag::MAP_ERROR, "no viable conversion%diff{ from $ to $|}0,1", 0, true, false, false, false, 2)
DIAG(err_typecheck_pointer_arith_function_type, CLASS_ERROR, diag::MAP_ERROR, "arithmetic on%select{ a|}0 pointer%select{|s}0 to%select{ the|}2 function type%select{|s}2 %1%select{| and %3}2", 0, true, false, false, false, 2)
DIAG(err_typecheck_pointer_arith_void_type, CLASS_ERROR, diag::MAP_ERROR, "arithmetic on%select{ a|}0 pointer%select{|s}0 to void", 0, true, false, false, false, 2)
DIAG(err_typecheck_sclass_fscope, CLASS_ERROR, diag::MAP_ERROR, "illegal storage class on file-scoped variable", 0, true, false, false, false, 2)
DIAG(err_typecheck_sclass_func, CLASS_ERROR, diag::MAP_ERROR, "illegal storage class on function", 0, true, false, false, false, 2)
DIAG(err_typecheck_statement_requires_integer, CLASS_ERROR, diag::MAP_ERROR, "statement requires expression of integer type (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_typecheck_statement_requires_scalar, CLASS_ERROR, diag::MAP_ERROR, "statement requires expression of scalar type (%0 invalid)", 0, true, false, false, false, 2)
DIAG(err_typecheck_sub_ptr_compatible, CLASS_ERROR, diag::MAP_ERROR, "%diff{$ and $ are not pointers to compatible types|pointers to incompatible types}0,1", 0, true, false, false, false, 2)
DIAG(err_typecheck_subscript_not_integer, CLASS_ERROR, diag::MAP_ERROR, "array subscript is not an integer", 0, true, false, false, false, 2)
DIAG(err_typecheck_subscript_value, CLASS_ERROR, diag::MAP_ERROR, "subscripted value is not an array, pointer, or vector", 0, true, false, false, false, 2)
DIAG(err_typecheck_unary_expr, CLASS_ERROR, diag::MAP_ERROR, "invalid argument type %0 to unary expression", 0, true, false, false, false, 2)
DIAG(err_typecheck_vector_not_convertable, CLASS_ERROR, diag::MAP_ERROR, "can't convert between vector values of different size (%0 and %1)", 0, true, false, false, false, 2)
DIAG(err_typecheck_zero_array_size, CLASS_ERROR, diag::MAP_ERROR, "zero-length arrays are not permitted in C++", 0, true, false, false, false, 2)
DIAG(err_typedef_not_bitfield, CLASS_ERROR, diag::MAP_ERROR, "typedef member %0 cannot be a bit-field", 0, true, false, false, false, 2)
DIAG(err_typedef_not_identifier, CLASS_ERROR, diag::MAP_ERROR, "typedef name must be an identifier", 0, true, false, false, false, 2)
DIAG(err_typename_missing, CLASS_ERROR, diag::MAP_ERROR, "missing 'typename' prior to dependent type name '%0%1'", 0, true, false, false, false, 2)
DIAG(err_typename_nested_not_found, CLASS_ERROR, diag::MAP_ERROR, "no type named %0 in %1", 0, true, false, false, false, 2)
DIAG(err_typename_nested_not_found_enable_if, CLASS_ERROR, diag::MAP_ERROR, "no type named 'type' in %0; 'enable_if' cannot be used to disable this declaration", 0, true, false, false, false, 2)
DIAG(err_typename_nested_not_type, CLASS_ERROR, diag::MAP_ERROR, "typename specifier refers to non-type member %0 in %1", 0, true, false, false, false, 2)
DIAG(err_typename_refers_to_using_value_decl, CLASS_ERROR, diag::MAP_ERROR, "typename specifier refers to a dependent using declaration for a value %0 in %1", 0, true, false, false, false, 2)
DIAG(err_types_compatible_p_in_cplusplus, CLASS_ERROR, diag::MAP_ERROR, "__builtin_types_compatible_p is not valid in C++", 0, true, false, false, false, 2)
DIAG(err_unavailable, CLASS_ERROR, diag::MAP_ERROR, "%0 is unavailable", 0, true, false, false, false, 2)
DIAG(err_unavailable_message, CLASS_ERROR, diag::MAP_ERROR, "%0 is unavailable: %1", 0, true, false, false, false, 2)
DIAG(err_uncasted_call_of_unknown_any, CLASS_ERROR, diag::MAP_ERROR, "%0 has unknown return type; cast the call to its declared return type", 0, true, false, false, false, 2)
DIAG(err_uncasted_send_to_unknown_any_method, CLASS_ERROR, diag::MAP_ERROR, "no known method %select{%objcinstance1|%objcclass1}0; cast the message send to the method's return type", 0, true, false, false, false, 2)
DIAG(err_uncasted_use_of_unknown_any, CLASS_ERROR, diag::MAP_ERROR, "%0 has unknown type; cast it to its declared type to use it", 0, true, false, false, false, 2)
DIAG(err_undeclared_boxing_method, CLASS_ERROR, diag::MAP_ERROR, "declaration of %0 is missing in %1 class", 0, true, false, false, false, 2)
DIAG(err_undeclared_label_use, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared label %0", 0, true, false, false, false, 2)
DIAG(err_undeclared_nsarray, CLASS_ERROR, diag::MAP_ERROR, "NSArray must be available to use Objective-C array literals", 0, true, false, false, false, 2)
DIAG(err_undeclared_nsdictionary, CLASS_ERROR, diag::MAP_ERROR, "NSDictionary must be available to use Objective-C dictionary literals", 0, true, false, false, false, 2)
DIAG(err_undeclared_nsnumber, CLASS_ERROR, diag::MAP_ERROR, "NSNumber must be available to use Objective-C literals", 0, true, false, false, false, 2)
DIAG(err_undeclared_nsstring, CLASS_ERROR, diag::MAP_ERROR, "cannot box a string value because NSString has not been declared", 0, true, false, false, false, 2)
DIAG(err_undeclared_protocol, CLASS_ERROR, diag::MAP_ERROR, "cannot find protocol declaration for %0", 0, true, false, false, false, 2)
DIAG(err_undeclared_protocol_suggest, CLASS_ERROR, diag::MAP_ERROR, "cannot find protocol declaration for %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_undeclared_use, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared %0", 0, true, false, false, false, 2)
DIAG(err_undeclared_use_suggest, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_undeclared_var_use, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared identifier %0", 0, true, false, false, false, 2)
DIAG(err_undeclared_var_use_suggest, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared identifier %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_undef_interface, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0", 0, true, false, false, false, 2)
DIAG(err_undef_interface_suggest, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_undef_superclass, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0, superclass of %1", 0, true, false, false, false, 2)
DIAG(err_undef_superclass_suggest, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0, superclass of %1; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_unexpanded_parameter_pack_0, CLASS_ERROR, diag::MAP_ERROR, "%select{expression|base type|declaration type|data member type|bit-field size|static assertion|fixed underlying type|enumerator value|using declaration|friend declaration|qualifier|initializer|default argument|non-type template parameter type|exception type|partial specialization|__if_exists name|__if_not_exists name|lambda|block}0 contains an unexpanded parameter pack", 0, true, false, false, false, 2)
DIAG(err_unexpanded_parameter_pack_1, CLASS_ERROR, diag::MAP_ERROR, "%select{expression|base type|declaration type|data member type|bit-field size|static assertion|fixed underlying type|enumerator value|using declaration|friend declaration|qualifier|initializer|default argument|non-type template parameter type|exception type|partial specialization|__if_exists name|__if_not_exists name|lambda|block}0 contains unexpanded parameter pack %1", 0, true, false, false, false, 2)
DIAG(err_unexpanded_parameter_pack_2, CLASS_ERROR, diag::MAP_ERROR, "%select{expression|base type|declaration type|data member type|bit-field size|static assertion|fixed underlying type|enumerator value|using declaration|friend declaration|qualifier|initializer|default argument|non-type template parameter type|exception type|partial specialization|__if_exists name|__if_not_exists name|lambda|block}0 contains unexpanded parameter packs %1 and %2", 0, true, false, false, false, 2)
DIAG(err_unexpanded_parameter_pack_3_or_more, CLASS_ERROR, diag::MAP_ERROR, "%select{expression|base type|declaration type|data member type|bit-field size|static assertion|fixed underlying type|enumerator value|using declaration|friend declaration|qualifier|initializer|default argument|non-type template parameter type|exception type|partial specialization|__if_exists name|__if_not_exists name|lambda|block}0 contains unexpanded parameter packs %1, %2, ...", 0, true, false, false, false, 2)
DIAG(err_unexpected_friend, CLASS_ERROR, diag::MAP_ERROR, "friends can only be classes or functions", 0, true, false, false, false, 2)
DIAG(err_unexpected_interface, CLASS_ERROR, diag::MAP_ERROR, "unexpected interface name %0: expected expression", 0, true, false, false, false, 2)
DIAG(err_unexpected_namespace, CLASS_ERROR, diag::MAP_ERROR, "unexpected namespace name %0: expected expression", 0, true, false, false, false, 2)
DIAG(err_unexpected_typedef, CLASS_ERROR, diag::MAP_ERROR, "unexpected type name %0: expected expression", 0, true, false, false, false, 2)
DIAG(err_uninitialized_member_for_assign, CLASS_ERROR, diag::MAP_ERROR, "cannot define the implicit default assignment operator for %0, because non-static %select{reference|const}1 member %2 can't use default assignment operator", 0, true, false, false, false, 2)
DIAG(err_uninitialized_member_in_ctor, CLASS_ERROR, diag::MAP_ERROR, "%select{|implicit default }0constructor for %1 must explicitly initialize the %select{reference|const}2 member %3", 0, true, false, false, false, 2)
DIAG(err_union_as_base_class, CLASS_ERROR, diag::MAP_ERROR, "unions cannot be base classes", 0, true, false, false, false, 2)
DIAG(err_union_member_of_reference_type, CLASS_ERROR, diag::MAP_ERROR, "union member %0 has reference type %1", 0, true, false, false, false, 2)
DIAG(err_unknown_any_addrof, CLASS_ERROR, diag::MAP_ERROR, "the address of a declaration with unknown type can only be cast to a pointer type", 0, true, false, false, false, 2)
DIAG(err_unknown_any_function, CLASS_ERROR, diag::MAP_ERROR, "function %0 with unknown type must be given a function type", 0, true, false, false, false, 2)
DIAG(err_unknown_any_var_function_type, CLASS_ERROR, diag::MAP_ERROR, "variable %0 with unknown type cannot be given a function type", 0, true, false, false, false, 2)
DIAG(err_unknown_machine_mode, CLASS_ERROR, diag::MAP_ERROR, "unknown machine mode %0", 0, true, false, false, false, 2)
DIAG(err_unknown_nested_typename_suggest, CLASS_ERROR, diag::MAP_ERROR, "no type named %0 in %1; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_unknown_receiver_suggest, CLASS_ERROR, diag::MAP_ERROR, "unknown receiver %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_unknown_type_or_class_name_suggest, CLASS_ERROR, diag::MAP_ERROR, "unknown %select{type|class}2 name %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_unknown_typename_suggest, CLASS_ERROR, diag::MAP_ERROR, "unknown type name %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_unqualified_pointer_member_function, CLASS_ERROR, diag::MAP_ERROR, "must explicitly qualify name of member function when taking its address", 0, true, false, false, false, 2)
DIAG(err_unsupported_global_register, CLASS_ERROR, diag::MAP_ERROR, "global register variables are not supported", 0, true, false, false, false, 2)
DIAG(err_unsupported_machine_mode, CLASS_ERROR, diag::MAP_ERROR, "unsupported machine mode %0", 0, true, false, false, false, 2)
DIAG(err_unsupported_unknown_any_call, CLASS_ERROR, diag::MAP_ERROR, "call to unsupported expression with unknown type", 0, true, false, false, false, 2)
DIAG(err_unsupported_unknown_any_decl, CLASS_ERROR, diag::MAP_ERROR, "%0 has unknown type, which is unsupported for this kind of declaration", 0, true, false, false, false, 2)
DIAG(err_unsupported_unknown_any_expr, CLASS_ERROR, diag::MAP_ERROR, "unsupported expression with unknown type", 0, true, false, false, false, 2)
DIAG(err_upcast_to_inaccessible_base, CLASS_ERROR, diag::MAP_ERROR, "cannot cast %0 to its %select{private|protected}2 base class %1", 0, true, false, false, false, 2)
DIAG(err_use_continuation_class, CLASS_ERROR, diag::MAP_ERROR, "illegal redeclaration of property in class extension %0 (attribute must be 'readwrite', while its primary must be 'readonly')", 0, true, false, false, false, 2)
DIAG(err_use_continuation_class_redeclaration_readwrite, CLASS_ERROR, diag::MAP_ERROR, "illegal redeclaration of 'readwrite' property in class extension %0 (perhaps you intended this to be a 'readwrite' redeclaration of a 'readonly' public property?)", 0, true, false, false, false, 2)
DIAG(err_use_of_default_argument_to_function_declared_later, CLASS_ERROR, diag::MAP_ERROR, "use of default argument to function %0 that is declared later in class %1", 0, true, false, false, false, 2)
DIAG(err_use_with_wrong_tag, CLASS_ERROR, diag::MAP_ERROR, "use of %0 with tag type that does not match previous declaration", 0, true, false, false, false, 2)
DIAG(err_using_decl_can_not_refer_to_class_member, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to class member", 0, true, false, false, false, 2)
DIAG(err_using_decl_can_not_refer_to_namespace, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to namespace", 0, true, false, false, false, 2)
DIAG(err_using_decl_conflict, CLASS_ERROR, diag::MAP_ERROR, "target of using declaration conflicts with declaration already in scope", 0, true, false, false, false, 2)
DIAG(err_using_decl_conflict_reverse, CLASS_ERROR, diag::MAP_ERROR, "declaration conflicts with target of using declaration already in scope", 0, true, false, false, false, 2)
DIAG(err_using_decl_constructor, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to a constructor", 0, true, false, false, false, 2)
DIAG(err_using_decl_constructor_conflict, CLASS_ERROR, diag::MAP_ERROR, "can not inherit constructor, already inherited constructor with the same signature", 0, true, false, false, false, 2)
DIAG(err_using_decl_constructor_not_in_direct_base, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a direct base of %1, can not inherit constructors", 0, true, false, false, false, 2)
DIAG(err_using_decl_constructor_unsupported, CLASS_ERROR, diag::MAP_ERROR, "inheriting constructors are not supported", 0, true, false, false, false, 2)
DIAG(err_using_decl_destructor, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to a destructor", 0, true, false, false, false, 2)
DIAG(err_using_decl_nested_name_specifier_is_current_class, CLASS_ERROR, diag::MAP_ERROR, "using declaration refers to its own class", 0, true, false, false, false, 2)
DIAG(err_using_decl_nested_name_specifier_is_not_base_class, CLASS_ERROR, diag::MAP_ERROR, "using declaration refers into '%0', which is not a base class of %1", 0, true, false, false, false, 2)
DIAG(err_using_decl_nested_name_specifier_is_not_class, CLASS_ERROR, diag::MAP_ERROR, "using declaration in class refers into '%0', which is not a class", 0, true, false, false, false, 2)
DIAG(err_using_decl_redeclaration, CLASS_ERROR, diag::MAP_ERROR, "redeclaration of using decl", 0, true, false, false, false, 2)
DIAG(err_using_decl_template_id, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to a template specialization", 0, true, false, false, false, 2)
DIAG(err_using_dependent_value_is_type, CLASS_ERROR, diag::MAP_ERROR, "dependent using declaration resolved to type without 'typename'", 0, true, false, false, false, 2)
DIAG(err_using_directive_member_suggest, CLASS_ERROR, diag::MAP_ERROR, "no namespace named %0 in %1; did you mean %2?", 0, true, false, false, false, 2)
DIAG(err_using_directive_suggest, CLASS_ERROR, diag::MAP_ERROR, "no namespace named %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(err_using_requires_qualname, CLASS_ERROR, diag::MAP_ERROR, "using declaration requires a qualified name", 0, true, false, false, false, 2)
DIAG(err_using_typename_non_type, CLASS_ERROR, diag::MAP_ERROR, "'typename' keyword used on a non-type", 0, true, false, false, false, 2)
DIAG(err_uuidof_without_guid, CLASS_ERROR, diag::MAP_ERROR, "cannot call operator __uuidof on a type with no GUID", 0, true, false, false, false, 2)
DIAG(err_va_start_used_in_non_variadic_function, CLASS_ERROR, diag::MAP_ERROR, "'va_start' used in function with fixed args", 0, true, false, false, false, 2)
DIAG(err_value_init_for_array_type, CLASS_ERROR, diag::MAP_ERROR, "array types cannot be value-initialized", 0, true, false, false, false, 2)
DIAG(err_variable_instantiates_to_function, CLASS_ERROR, diag::MAP_ERROR, "%select{variable|static data member}0 instantiated with function type %1", 0, true, false, false, false, 2)
DIAG(err_variable_object_no_init, CLASS_ERROR, diag::MAP_ERROR, "variable-sized object may not be initialized", 0, true, false, false, false, 2)
DIAG(err_variably_modified_new_type, CLASS_ERROR, diag::MAP_ERROR, "'new' cannot allocate object of variably modified type %0", 0, true, false, false, false, 2)
DIAG(err_variably_modified_nontype_template_param, CLASS_ERROR, diag::MAP_ERROR, "non-type template parameter of variably modified type %0", 0, true, false, false, false, 2)
DIAG(err_variably_modified_template_arg, CLASS_ERROR, diag::MAP_ERROR, "variably modified type %0 cannot be used as a template argument", 0, true, false, false, false, 2)
DIAG(err_vecstep_non_scalar_vector_type, CLASS_ERROR, diag::MAP_ERROR, "'vec_step' requires built-in scalar or vector type, %0 invalid", 0, true, false, false, false, 2)
DIAG(err_vector_incorrect_num_initializers, CLASS_ERROR, diag::MAP_ERROR, "%select{too many|too few}0 elements in vector initialization (expected %1 elements, have %2)", 0, true, false, false, false, 2)
DIAG(err_virtual_member_function_template, CLASS_ERROR, diag::MAP_ERROR, "'virtual' can not be specified on member function templates", 0, true, false, false, false, 2)
DIAG(err_virtual_non_function, CLASS_ERROR, diag::MAP_ERROR, "'virtual' can only appear on non-static member functions", 0, true, false, false, false, 2)
DIAG(err_virtual_out_of_class, CLASS_ERROR, diag::MAP_ERROR, "'virtual' can only be specified inside the class definition", 0, true, false, false, false, 2)
DIAG(err_vla_decl_has_extern_linkage, CLASS_ERROR, diag::MAP_ERROR, "variable length array declaration can not have 'extern' linkage", 0, true, false, false, false, 2)
DIAG(err_vla_decl_has_static_storage, CLASS_ERROR, diag::MAP_ERROR, "variable length array declaration can not have 'static' storage duration", 0, true, false, false, false, 2)
DIAG(err_vla_decl_in_file_scope, CLASS_ERROR, diag::MAP_ERROR, "variable length array declaration not allowed at file scope", 0, true, false, false, false, 2)
DIAG(err_vla_in_sfinae, CLASS_ERROR, diag::MAP_ERROR, "variable length array cannot be formed during template argument deduction", 0, true, false, false, false, 2)
DIAG(err_vla_non_pod, CLASS_ERROR, diag::MAP_ERROR, "variable length array of non-POD element type %0", 0, true, false, false, false, 2)
DIAG(err_vm_decl_has_extern_linkage, CLASS_ERROR, diag::MAP_ERROR, "variably modified type declaration can not have 'extern' linkage", 0, true, false, false, false, 2)
DIAG(err_vm_decl_in_file_scope, CLASS_ERROR, diag::MAP_ERROR, "variably modified type declaration not allowed at file scope", 0, true, false, false, false, 2)
DIAG(err_vm_func_decl, CLASS_ERROR, diag::MAP_ERROR, "function declaration cannot have variably modified type", 0, true, false, false, false, 2)
DIAG(err_void_only_param, CLASS_ERROR, diag::MAP_ERROR, "'void' must be the first and only parameter if specified", 0, true, false, false, false, 2)
DIAG(err_void_param_qualified, CLASS_ERROR, diag::MAP_ERROR, "'void' as parameter must not have type qualifiers", 0, true, false, false, false, 2)
DIAG(error_arc_weak_ivar_access, CLASS_ERROR, diag::MAP_ERROR, "dereferencing a __weak pointer is not allowed due to possible null value caused by race condition, assign it to strong variable first", 0, true, false, false, false, 2)
DIAG(error_bad_category_property_decl, CLASS_ERROR, diag::MAP_ERROR, "property implementation must have its declaration in the category %0", 0, true, false, false, false, 2)
DIAG(error_bad_property_context, CLASS_ERROR, diag::MAP_ERROR, "property implementation must be in a class or category implementation", 0, true, false, false, false, 2)
DIAG(error_bad_property_decl, CLASS_ERROR, diag::MAP_ERROR, "property implementation must have its declaration in interface %0", 0, true, false, false, false, 2)
DIAG(error_category_property, CLASS_ERROR, diag::MAP_ERROR, "property declared in category %0 cannot be implemented in class implementation", 0, true, false, false, false, 2)
DIAG(error_dealloc_bad_result_type, CLASS_ERROR, diag::MAP_ERROR, "dealloc return type must be correctly specified as 'void' under ARC, instead of %0", 0, true, false, false, false, 2)
DIAG(error_duplicate_ivar_use, CLASS_ERROR, diag::MAP_ERROR, "synthesized properties %0 and %1 both claim instance variable %2", 0, true, false, false, false, 2)
DIAG(error_dynamic_property_ivar_decl, CLASS_ERROR, diag::MAP_ERROR, "dynamic property can not have instance variable specification", 0, true, false, false, false, 2)
DIAG(error_implicit_ivar_access, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 cannot be accessed because 'self' has been redeclared", 0, true, false, false, false, 2)
DIAG(error_ivar_in_superclass_use, CLASS_ERROR, diag::MAP_ERROR, "property %0 attempting to use instance variable %1 declared in super class %2", 0, true, false, false, false, 2)
DIAG(error_ivar_use_in_class_method, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 accessed in class method", 0, true, false, false, false, 2)
DIAG(error_missing_method_context, CLASS_ERROR, diag::MAP_ERROR, "missing context for method declaration", 0, true, false, false, false, 2)
DIAG(error_missing_property_context, CLASS_ERROR, diag::MAP_ERROR, "missing context for property implementation declaration", 0, true, false, false, false, 2)
DIAG(error_missing_property_interface, CLASS_ERROR, diag::MAP_ERROR, "property implementation in a category with no category declaration", 0, true, false, false, false, 2)
DIAG(error_missing_property_ivar_decl, CLASS_ERROR, diag::MAP_ERROR, "synthesized property %0 must either be named the same as a compatible instance variable or must explicitly name an instance variable", 0, true, false, false, false, 2)
DIAG(error_no_subobject_property_setting, CLASS_ERROR, diag::MAP_ERROR, "expression is not assignable", 0, true, false, false, false, 2)
DIAG(error_no_super_class_message, CLASS_ERROR, diag::MAP_ERROR, "no @interface declaration found in class messaging of %0", 0, true, false, false, false, 2)
DIAG(error_objc_synchronized_expects_object, CLASS_ERROR, diag::MAP_ERROR, "@synchronized requires an Objective-C object type (%0 invalid)", 0, true, false, false, false, 2)
DIAG(error_objc_throw_expects_object, CLASS_ERROR, diag::MAP_ERROR, "@throw requires an Objective-C object type (%0 invalid)", 0, true, false, false, false, 2)
DIAG(error_private_ivar_access, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 is private", 0, true, true, false, false, 2)
DIAG(error_property_accessor_type, CLASS_ERROR, diag::MAP_ERROR, "type of property %0 (%1) does not match type of accessor %2 (%3)", 0, true, false, false, false, 2)
DIAG(error_property_implemented, CLASS_ERROR, diag::MAP_ERROR, "property %0 is already implemented", 0, true, false, false, false, 2)
DIAG(error_property_ivar_type, CLASS_ERROR, diag::MAP_ERROR, "type of property %0 (%1) does not match type of instance variable %2 (%3)", 0, true, false, false, false, 2)
DIAG(error_property_setter_ambiguous_use, CLASS_ERROR, diag::MAP_ERROR, "synthesized properties '%0' and '%1' both claim setter %2 - use of this setter will cause unexpected behavior", 0, true, false, false, false, 2)
DIAG(error_protected_ivar_access, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 is protected", 0, true, true, false, false, 2)
DIAG(error_readonly_message_assignment, CLASS_ERROR, diag::MAP_ERROR, "assigning to 'readonly' return result of an Objective-C message not allowed", 0, true, false, false, false, 2)
DIAG(error_reference_property, CLASS_ERROR, diag::MAP_ERROR, "property of reference type is not supported", 0, true, false, false, false, 2)
DIAG(error_rethrow_used_outside_catch, CLASS_ERROR, diag::MAP_ERROR, "@throw (rethrow) used outside of a @catch block", 0, true, false, false, false, 2)
DIAG(error_root_class_cannot_use_super, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot use 'super' because it is a root class", 0, true, false, false, false, 2)
DIAG(error_strong_property, CLASS_ERROR, diag::MAP_ERROR, "existing instance variable %1 for strong property %0 may not be __weak", 0, true, false, false, false, 2)
DIAG(error_synthesize_category_decl, CLASS_ERROR, diag::MAP_ERROR, "@synthesize not allowed in a category's implementation", 0, true, false, false, false, 2)
DIAG(error_synthesize_weak_non_arc_or_gc, CLASS_ERROR, diag::MAP_ERROR, "@synthesize of 'weak' property is only allowed in ARC or GC mode", 0, true, false, false, false, 2)
DIAG(error_weak_property, CLASS_ERROR, diag::MAP_ERROR, "existing instance variable %1 for __weak property %0 must be __weak", 0, true, false, false, false, 2)
DIAG(ext_anonymous_record_with_type, CLASS_EXTENSION, diag::MAP_IGNORE, "types declared in an anonymous %select{struct|union}0 are a Microsoft extension", 186, true, false, false, false, 2)
DIAG(ext_anonymous_struct_union_qualified, CLASS_EXTENSION, diag::MAP_IGNORE, "anonymous %select{struct|union}0 cannot be '%select{const|volatile|restrict}1'", 250, true, false, false, false, 2)
DIAG(ext_anonymous_union, CLASS_EXTENSION, diag::MAP_IGNORE, "anonymous unions are a C11 extension", 60, true, false, false, false, 2)
DIAG(ext_array_init_copy, CLASS_EXTENSION, diag::MAP_IGNORE, "initialization of an array %diff{of type $ from a compound literal of type $|from a compound literal}0,1 is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_array_init_parens, CLASS_EXTENSION, diag::MAP_ERROR, "parenthesized initialization of a member array is a GNU extension", 138, true, false, false, false, 2)
DIAG(ext_array_size_conversion, CLASS_EXTENSION, diag::MAP_IGNORE, "implicit conversion from array size expression of type %0 to %select{integral|enumeration}1 type %2 is a C++11 extension", 51, true, false, false, false, 2)
DIAG(ext_c11_anonymous_struct, CLASS_EXTENSION, diag::MAP_IGNORE, "anonymous structs are a C11 extension", 60, true, false, false, false, 2)
DIAG(ext_c99_array_usage, CLASS_EXTENSION, diag::MAP_IGNORE, "%select{qualifier in |static |}0array size %select{||'[*] '}0is a C99 feature", 61, true, false, false, false, 2)
DIAG(ext_cast_fn_obj, CLASS_EXTENSION, diag::MAP_IGNORE, "cast between pointer-to-function and pointer-to-object is an extension", 250, true, false, false, false, 2)
DIAG(ext_complex_component_init, CLASS_EXTENSION, diag::MAP_IGNORE, "complex initialization specifying real and imaginary components is an extension", 70, true, false, false, false, 2)
DIAG(ext_delete_void_ptr_operand, CLASS_EXTENSION, diag::MAP_WARNING, "cannot delete expression with pointer-to-'void' type %0", 0, true, false, false, false, 2)
DIAG(ext_designated_init, CLASS_EXTENSION, diag::MAP_IGNORE, "designated initializers are a C99 feature", 61, true, false, false, false, 2)
DIAG(ext_enum_friend, CLASS_EXTENSION, diag::MAP_WARNING, "enumeration type %0 cannot be a friend", 0, true, false, false, false, 2)
DIAG(ext_enum_value_not_int, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C restricts enumerator values to range of 'int' (%0 is too %select{small|large}1)", 250, true, false, false, false, 2)
DIAG(ext_enumerator_too_large, CLASS_EXTENSION, diag::MAP_WARNING, "enumerator value is not representable in the underlying type %0", 186, true, false, false, false, 2)
DIAG(ext_explicit_conversion_functions, CLASS_EXTENSION, diag::MAP_WARNING, "explicit conversion functions are a C++11 extension", 51, true, false, false, false, 2)
DIAG(ext_explicit_instantiation_after_specialization, CLASS_EXTENSION, diag::MAP_IGNORE, "explicit instantiation of %0 that occurs after an explicit specialization will be ignored (C++11 extension)", 51, true, false, false, false, 2)
DIAG(ext_explicit_instantiation_without_qualified_id, CLASS_EXTENSION, diag::MAP_IGNORE, "qualifier in explicit instantiation of %q0 requires a template-id (a typedef is not permitted)", 250, true, false, false, false, 2)
DIAG(ext_explicit_specialization_storage_class, CLASS_EXTENSION, diag::MAP_WARNING, "explicit specialization cannot have a storage class", 0, true, false, false, false, 2)
DIAG(ext_expr_not_ice, CLASS_EXTENSION, diag::MAP_IGNORE, "expression is not an %select{integer|integral}0 constant expression; folding it to a constant is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_flexible_array_empty_aggregate_gnu, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array member %0 in otherwise empty %select{struct|interface|union|class|enum}1 is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_flexible_array_empty_aggregate_ms, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array member %0 in otherwise empty %select{struct|interface|union|class|enum}1 is a Microsoft extension", 186, true, false, false, false, 2)
DIAG(ext_flexible_array_in_array, CLASS_EXTENSION, diag::MAP_IGNORE, "%0 may not be used as an array element due to flexible array member", 123, true, false, false, false, 2)
DIAG(ext_flexible_array_in_struct, CLASS_EXTENSION, diag::MAP_IGNORE, "%0 may not be nested in a struct due to flexible array member", 123, true, false, false, false, 2)
DIAG(ext_flexible_array_init, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array initialization is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_flexible_array_union_gnu, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array member %0 in a union is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_flexible_array_union_ms, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array member %0 in a union is a Microsoft extension", 186, true, false, false, false, 2)
DIAG(ext_forward_ref_enum, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C forbids forward references to 'enum' types", 250, true, false, false, false, 2)
DIAG(ext_forward_ref_enum_def, CLASS_EXTENSION, diag::MAP_IGNORE, "redeclaration of already-defined enum %0 is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_freestanding_complex, CLASS_EXTENSION, diag::MAP_IGNORE, "complex numbers are an extension in a freestanding C99 implementation", 250, true, false, false, false, 2)
DIAG(ext_function_specialization_in_class, CLASS_EXTENSION, diag::MAP_WARNING, "explicit specialization of %0 within class scope is a Microsoft extension", 186, true, false, false, false, 2)
DIAG(ext_gnu_anonymous_struct, CLASS_EXTENSION, diag::MAP_IGNORE, "anonymous structs are a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_gnu_ptr_func_arith, CLASS_EXTENSION, diag::MAP_IGNORE, "arithmetic on%select{ a|}0 pointer%select{|s}0 to%select{ the|}2 function type%select{|s}2 %1%select{| and %3}2 is a GNU extension", 251, true, false, false, false, 2)
DIAG(ext_gnu_subscript_void_type, CLASS_EXTENSION, diag::MAP_IGNORE, "subscript of a pointer to void is a GNU extension", 251, true, false, false, false, 2)
DIAG(ext_gnu_void_ptr, CLASS_EXTENSION, diag::MAP_IGNORE, "arithmetic on%select{ a|}0 pointer%select{|s}0 to void is a GNU extension", 251, true, false, false, false, 2)
DIAG(ext_implicit_exception_spec_mismatch, CLASS_EXTENSION, diag::MAP_WARNING, "function previously declared with an %select{explicit|implicit}0 exception specification redeclared with an %select{implicit|explicit}0 exception specification", 147, true, false, false, false, 2)
DIAG(ext_implicit_function_decl, CLASS_EXTENSION, diag::MAP_WARNING, "implicit declaration of function %0 is invalid in C99", 150, true, false, false, false, 2)
DIAG(ext_implicit_lib_function_decl, CLASS_EXTENSION, diag::MAP_WARNING, "implicitly declaring library function '%0' with type %1", 0, true, false, false, false, 2)
DIAG(ext_in_class_initializer_float_type, CLASS_EXTENSION, diag::MAP_WARNING, "in-class initializer for static data member of type %0 is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_in_class_initializer_non_constant, CLASS_EXTENSION, diag::MAP_IGNORE, "in-class initializer for static data member is not a constant expression; folding it to a constant is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_integer_complement_complex, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C does not support '~' for complex conjugation of %0", 250, true, false, false, false, 2)
DIAG(ext_integer_increment_complex, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C does not support '++'/'--' on complex integer type %0", 250, true, false, false, false, 2)
DIAG(ext_internal_in_extern_inline, CLASS_EXTENSION, diag::MAP_IGNORE, "static %select{function|variable}0 %1 is used in an inline function with external linkage", 293, true, false, false, false, 2)
DIAG(ext_invalid_sign_spec, CLASS_EXTENSION, diag::MAP_IGNORE, "'%0' cannot be signed or unsigned", 250, true, false, false, false, 2)
DIAG(ext_lambda_default_arguments, CLASS_EXTENSION, diag::MAP_WARNING, "C++11 forbids default arguments for lambda expressions", 173, true, false, false, false, 3)
DIAG(ext_main_returns_nonint, CLASS_EXTENSION, diag::MAP_WARNING, "return type of 'main' is not 'int'", 183, true, false, false, false, 2)
DIAG(ext_missing_declspec, CLASS_EXTENSION, diag::MAP_WARNING, "declaration specifier missing, defaulting to 'int'", 0, true, false, false, false, 2)
DIAG(ext_missing_type_specifier, CLASS_EXTENSION, diag::MAP_WARNING, "type specifier missing, defaults to 'int'", 151, true, false, false, false, 2)
DIAG(ext_mixed_decls_code, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C90 forbids mixing declarations and code", 83, true, false, false, false, 2)
DIAG(ext_ms_anonymous_struct, CLASS_EXTENSION, diag::MAP_WARNING, "anonymous structs are a Microsoft extension", 186, true, false, false, false, 2)
DIAG(ext_ms_explicit_constructor_call, CLASS_EXTENSION, diag::MAP_WARNING, "explicit constructor calls are a Microsoft extension", 186, true, false, false, false, 2)
DIAG(ext_ms_forward_ref_enum, CLASS_EXTENSION, diag::MAP_IGNORE, "forward references to 'enum' types are a Microsoft extension", 186, true, false, false, false, 2)
DIAG(ext_ms_using_declaration_inaccessible, CLASS_EXTENSION, diag::MAP_WARNING, "using declaration referring to inaccessible member '%0' (which refers to accessible member '%1') is a Microsoft compatibility extension", 186, true, true, false, false, 2)
DIAG(ext_nested_name_member_ref_lookup_ambiguous, CLASS_EXTENSION, diag::MAP_WARNING, "lookup of %0 in member access expression is ambiguous; using member of %1", 13, true, false, false, false, 2)
DIAG(ext_nested_pointer_qualifier_mismatch, CLASS_EXTENSION, diag::MAP_WARNING, "%select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 discards qualifiers in nested pointer types", 155, true, false, false, false, 2)
DIAG(ext_new_paren_array_nonconst, CLASS_EXTENSION, diag::MAP_WARNING, "when type is in parentheses, array cannot have dynamic size", 0, true, false, false, false, 2)
DIAG(ext_nonclass_type_friend, CLASS_EXTENSION, diag::MAP_WARNING, "non-class friend type %0 is a C++11 extension", 51, true, false, false, false, 2)
DIAG(ext_offsetof_extended_field_designator, CLASS_EXTENSION, diag::MAP_IGNORE, "using extended field designator is an extension", 118, true, false, false, false, 2)
DIAG(ext_out_of_line_declaration, CLASS_EXTENSION, diag::MAP_ERROR, "out-of-line declaration of a member must be a definition", 240, true, false, false, false, 2)
DIAG(ext_param_not_declared, CLASS_EXTENSION, diag::MAP_IGNORE, "parameter %0 was not declared, defaulting to type 'int'", 250, true, false, false, false, 2)
DIAG(ext_param_promoted_not_compatible_with_prototype, CLASS_EXTENSION, diag::MAP_WARNING, "%diff{promoted type $ of K&R function parameter is not compatible with the parameter type $|promoted type of K&R function parameter is not compatible with parameter type}0,1 declared in a previous prototype", 172, true, false, false, false, 2)
DIAG(ext_predef_outside_function, CLASS_WARNING, diag::MAP_WARNING, "predefined identifier is only valid inside function", 255, true, false, false, false, 2)
DIAG(ext_pseudo_dtor_on_void, CLASS_EXTENSION, diag::MAP_WARNING, "pseudo-destructors on type void are a Microsoft extension", 186, true, false, false, false, 2)
DIAG(ext_return_has_expr, CLASS_EXTENSION, diag::MAP_ERROR, "%select{void function|void method|constructor|destructor}1 %0 should not return a value", 268, true, false, false, false, 2)
DIAG(ext_return_has_void_expr, CLASS_EXTENSION, diag::MAP_IGNORE, "void %select{function|method|block}1 %0 should not return void expression", 250, true, false, false, false, 2)
DIAG(ext_return_missing_expr, CLASS_EXTENSION, diag::MAP_ERROR, "non-void %select{function|method}1 %0 should return a value", 268, true, false, false, false, 2)
DIAG(ext_rvalue_to_reference_access_ctor, CLASS_EXTENSION, diag::MAP_WARNING, "C++98 requires an accessible copy constructor for class %2 when binding a reference to a temporary; was %select{private|protected}0", 39, true, true, false, false, 2)
DIAG(ext_rvalue_to_reference_temp_copy_no_viable, CLASS_EXTENSION, diag::MAP_WARNING, "no viable constructor %select{copying variable|copying parameter|returning object|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element|capturing value}0 of type %1; C++98 requires a copy constructor when binding a reference to a temporary", 39, true, false, false, false, 2)
DIAG(ext_sizeof_function_type, CLASS_EXTENSION, diag::MAP_IGNORE, "invalid application of 'sizeof' to a function type", 251, true, false, false, false, 2)
DIAG(ext_sizeof_void_type, CLASS_EXTENSION, diag::MAP_IGNORE, "invalid application of '%select{sizeof|__alignof|vec_step}0' to a void type", 251, true, false, false, false, 2)
DIAG(ext_static_data_member_in_union, CLASS_EXTENSION, diag::MAP_WARNING, "static data member %0 in union is a C++11 extension", 51, true, false, false, false, 2)
DIAG(ext_subscript_non_lvalue, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C90 does not allow subscripting non-lvalue array", 250, true, false, false, false, 2)
DIAG(ext_template_arg_extra_parens, CLASS_EXTENSION, diag::MAP_WARNING, "address non-type template argument cannot be surrounded by parentheses", 0, true, false, false, false, 2)
DIAG(ext_template_arg_local_type, CLASS_EXTENSION, diag::MAP_WARNING, "template argument uses local type %0", 178, true, false, false, false, 2)
DIAG(ext_template_arg_object_internal, CLASS_EXTENSION, diag::MAP_WARNING, "non-type template argument referring to %select{function|object}0 %1 with internal linkage is a C++11 extension", 51, true, false, false, false, 2)
DIAG(ext_template_arg_unnamed_type, CLASS_EXTENSION, diag::MAP_WARNING, "template argument uses unnamed type", 337, true, false, false, false, 2)
DIAG(ext_template_outside_of_template, CLASS_EXTENSION, diag::MAP_WARNING, "'template' keyword outside of a template", 51, true, false, false, false, 2)
DIAG(ext_template_parameter_default_in_function_template, CLASS_EXTENSION, diag::MAP_WARNING, "default template arguments for a function template are a C++11 extension", 51, true, false, false, false, 2)
DIAG(ext_template_spec_decl_out_of_scope, CLASS_EXTENSION, diag::MAP_WARNING, "first declaration of %select{class template|class template partial|function template|member function|static data member|member class|member enumeration}0 specialization of %1 outside namespace %2 is a C++11 extension", 51, true, false, false, false, 2)
DIAG(ext_typecheck_addrof_class_temporary, CLASS_EXTENSION, diag::MAP_ERROR, "taking the address of a temporary object of type %0", 9, true, false, false, false, 2)
DIAG(ext_typecheck_addrof_void, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C forbids taking the address of an expression of type 'void'", 250, true, false, false, false, 2)
DIAG(ext_typecheck_base_super, CLASS_WARNING, diag::MAP_IGNORE, "method parameter type %diff{$ does not match super class method parameter type $|does not match super class method parameter type}0,1", 312, true, false, false, false, 2)
DIAG(ext_typecheck_cast_nonscalar, CLASS_EXTENSION, diag::MAP_IGNORE, "C99 forbids casting nonscalar type %0 to the same type", 250, true, false, false, false, 2)
DIAG(ext_typecheck_cast_to_union, CLASS_EXTENSION, diag::MAP_IGNORE, "cast to union type is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_typecheck_comparison_of_distinct_pointers, CLASS_EXTENSION, diag::MAP_WARNING, "comparison of distinct pointer types%diff{ ($ and $)|}0,1", 69, true, false, false, false, 2)
DIAG(ext_typecheck_comparison_of_distinct_pointers_nonstandard, CLASS_EXTENSION, diag::MAP_WARNING, "comparison of distinct pointer types (%0 and %1) uses non-standard composite pointer type %2", 69, true, false, false, false, 2)
DIAG(ext_typecheck_comparison_of_fptr_to_void, CLASS_EXTENSION, diag::MAP_IGNORE, "equality comparison between function pointer and void pointer (%0 and %1)", 250, true, false, false, false, 2)
DIAG(ext_typecheck_comparison_of_pointer_integer, CLASS_EXTENSION, diag::MAP_WARNING, "comparison between pointer and integer (%0 and %1)", 0, true, false, false, false, 2)
DIAG(ext_typecheck_cond_incompatible_operands, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible operand types (%0 and %1)", 0, true, false, false, false, 2)
DIAG(ext_typecheck_cond_incompatible_operands_nonstandard, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible operand types%diff{ ($ and $)|}0,1 use non-standard composite pointer type %2", 0, true, false, false, false, 2)
DIAG(ext_typecheck_cond_one_void, CLASS_EXTENSION, diag::MAP_IGNORE, "C99 forbids conditional expressions with only one void side", 250, true, false, false, false, 2)
DIAG(ext_typecheck_convert_discards_qualifiers, CLASS_EXTENSION, diag::MAP_WARNING, "%select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 discards qualifiers", 155, true, false, false, false, 2)
DIAG(ext_typecheck_convert_incompatible_pointer, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible pointer types %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2%select{|; dereference with *|; take the address with &|; remove *|; remove &}3", 155, true, false, false, false, 2)
DIAG(ext_typecheck_convert_incompatible_pointer_sign, CLASS_EXTENSION, diag::MAP_WARNING, "%select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 converts between pointers to integer types with different sign", 252, true, false, false, false, 2)
DIAG(ext_typecheck_convert_int_pointer, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible integer to pointer conversion %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2%select{|; dereference with *|; take the address with &|; remove *|; remove &}3", 161, true, false, false, false, 14)
DIAG(ext_typecheck_convert_pointer_int, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible pointer to integer conversion %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2%select{|; dereference with *|; take the address with &|; remove *|; remove &}3", 161, true, false, false, false, 14)
DIAG(ext_typecheck_convert_pointer_void_func, CLASS_EXTENSION, diag::MAP_IGNORE, "%select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 converts between void pointer and function pointer", 250, true, false, false, false, 2)
DIAG(ext_typecheck_decl_incomplete_type, CLASS_EXTENSION, diag::MAP_WARNING, "tentative definition of variable with internal linkage has incomplete non-array type %0", 319, true, false, false, false, 2)
DIAG(ext_typecheck_ordered_comparison_of_function_pointers, CLASS_EXTENSION, diag::MAP_WARNING, "ordered comparison of function pointers (%0 and %1)", 0, true, false, false, false, 2)
DIAG(ext_typecheck_ordered_comparison_of_pointer_and_zero, CLASS_EXTENSION, diag::MAP_IGNORE, "ordered comparison between pointer and zero (%0 and %1) is an extension", 250, true, false, false, false, 2)
DIAG(ext_typecheck_ordered_comparison_of_pointer_integer, CLASS_EXTENSION, diag::MAP_WARNING, "ordered comparison between pointer and integer (%0 and %1)", 0, true, false, false, false, 2)
DIAG(ext_typecheck_zero_array_size, CLASS_EXTENSION, diag::MAP_IGNORE, "zero size arrays are an extension", 369, true, false, false, false, 2)
DIAG(ext_typedef_without_a_name, CLASS_EXTENSION, diag::MAP_WARNING, "typedef requires a name", 193, true, false, false, false, 2)
DIAG(ext_typename_outside_of_template, CLASS_EXTENSION, diag::MAP_WARNING, "'typename' occurs outside of a template", 51, true, false, false, false, 2)
DIAG(ext_unelaborated_friend_type, CLASS_EXTENSION, diag::MAP_WARNING, "unelaborated friend declaration is a C++11 extension; specify '%select{struct|interface|union|class|enum}0' to befriend %1", 51, true, false, false, false, 2)
DIAG(ext_using_undefined_std, CLASS_EXTENSION, diag::MAP_WARNING, "using directive refers to implicitly-defined namespace 'std'", 0, true, false, false, false, 2)
DIAG(ext_variable_sized_type_in_struct, CLASS_EXTENSION, diag::MAP_WARNING, "field %0 with variable sized type %1 not at the end of a struct or class is a GNU extension", 137, true, false, false, false, 2)
DIAG(ext_vla, CLASS_EXTENSION, diag::MAP_IGNORE, "variable length arrays are a C99 feature", 364, true, false, false, false, 2)
DIAG(ext_vla_folded_to_constant, CLASS_EXTENSION, diag::MAP_IGNORE, "variable length array folded to constant array as an extension", 250, true, false, false, false, 2)
DIAG(not_conv_function_declared_at, CLASS_NOTE, diag::MAP_FATAL, "type conversion function declared here", 0, true, false, false, false, 2)
DIAG(note_access_constrained_by_path, CLASS_NOTE, diag::MAP_FATAL, "constrained by %select{|implicitly }1%select{private|protected}0 inheritance here", 0, true, false, false, false, 2)
DIAG(note_access_natural, CLASS_NOTE, diag::MAP_FATAL, "%select{|implicitly }1declared %select{private|protected}0 here", 0, true, false, false, false, 2)
DIAG(note_access_protected_restricted_ctordtor, CLASS_NOTE, diag::MAP_FATAL, "protected %select{constructor|destructor}0 can only be used to %select{construct|destroy}0 a base class subobject", 0, true, false, false, false, 2)
DIAG(note_access_protected_restricted_noobject, CLASS_NOTE, diag::MAP_FATAL, "must name member using the type of the current context %0", 0, true, false, false, false, 2)
DIAG(note_access_protected_restricted_object, CLASS_NOTE, diag::MAP_FATAL, "can only access this member on an object of type %0", 0, true, false, false, false, 2)
DIAG(note_additional_parens_for_variable_declaration, CLASS_NOTE, diag::MAP_FATAL, "add a pair of parentheses to declare a variable", 0, true, false, false, false, 2)
DIAG(note_ambig_member_ref_object_type, CLASS_NOTE, diag::MAP_FATAL, "lookup in the object type %0 refers here", 0, true, false, false, false, 2)
DIAG(note_ambig_member_ref_scope, CLASS_NOTE, diag::MAP_FATAL, "lookup from the current scope refers here", 0, true, false, false, false, 2)
DIAG(note_ambiguous_candidate, CLASS_NOTE, diag::MAP_FATAL, "candidate found by name lookup is %q0", 0, true, false, false, false, 2)
DIAG(note_ambiguous_member_found, CLASS_NOTE, diag::MAP_FATAL, "member found by ambiguous name lookup", 0, true, false, false, false, 2)
DIAG(note_ambiguous_type_conversion, CLASS_NOTE, diag::MAP_FATAL, "because of ambiguity in conversion %diff{of $ to $|between types}0,1", 0, true, false, false, false, 2)
DIAG(note_arc_assign_to_strong, CLASS_NOTE, diag::MAP_FATAL, "assign the value to a strong variable to keep the object alive during use", 0, true, false, false, false, 2)
DIAG(note_arc_bridge, CLASS_NOTE, diag::MAP_FATAL, "use __bridge to convert directly (no change in ownership)", 0, true, false, false, false, 7)
DIAG(note_arc_bridge_retained, CLASS_NOTE, diag::MAP_FATAL, "use %select{__bridge_retained|CFBridgingRetain call}1 to make an ARC object available as a +1 %0", 0, true, false, false, false, 7)
DIAG(note_arc_bridge_transfer, CLASS_NOTE, diag::MAP_FATAL, "use %select{__bridge_transfer|CFBridgingRelease call}1 to transfer ownership of a +1 %0 into ARC", 0, true, false, false, false, 7)
DIAG(note_arc_gained_method_convention, CLASS_NOTE, diag::MAP_FATAL, "declaration in interface is not in the '%select{alloc|copy|init|new}0' family because %select{its result type is not an object pointer|its result type is unrelated to its receiver type}1", 0, true, false, false, false, 5)
DIAG(note_arc_lost_method_convention, CLASS_NOTE, diag::MAP_FATAL, "declaration in interface", 0, true, false, false, false, 5)
DIAG(note_arc_retain_cycle_owner, CLASS_NOTE, diag::MAP_FATAL, "block will be retained by %select{the captured object|an object strongly retained by the captured object}0", 0, true, false, false, false, 16)
DIAG(note_arc_weak_also_accessed_here, CLASS_NOTE, diag::MAP_FATAL, "also accessed here", 0, true, false, false, false, 2)
DIAG(note_array_index_out_of_bounds, CLASS_NOTE, diag::MAP_FATAL, "array %0 declared here", 0, true, false, false, false, 2)
DIAG(note_array_size_conversion, CLASS_NOTE, diag::MAP_FATAL, "conversion to %select{integral|enumeration}0 type %1 declared here", 0, true, false, false, false, 2)
DIAG(note_atomic_property_fixup_suggest, CLASS_NOTE, diag::MAP_FATAL, "setter and getter must both be synthesized, or both be user defined,or the property must be nonatomic", 0, true, false, false, false, 2)
DIAG(note_attribute_overloadable_prev_overload, CLASS_NOTE, diag::MAP_FATAL, "previous overload of function is here", 0, true, false, false, false, 2)
DIAG(note_auto_readonly_iboutlet_fixup_suggest, CLASS_NOTE, diag::MAP_FATAL, "readonly IBOutlet property should be changed to be readwrite", 0, true, false, false, false, 2)
DIAG(note_bad_memaccess_silence, CLASS_NOTE, diag::MAP_FATAL, "explicitly cast the pointer to silence this warning", 0, true, false, false, false, 2)
DIAG(note_base_class_specified_here, CLASS_NOTE, diag::MAP_FATAL, "base class %0 specified here", 0, true, false, false, false, 2)
DIAG(note_bitfield_decl, CLASS_NOTE, diag::MAP_FATAL, "bit-field is declared here", 0, true, false, false, false, 2)
DIAG(note_block_var_fixit_add_initialization, CLASS_NOTE, diag::MAP_FATAL, "maybe you meant to use __block %0", 0, true, false, false, false, 2)
DIAG(note_callee_decl, CLASS_NOTE, diag::MAP_FATAL, "%0 declared here", 0, true, false, false, false, 2)
DIAG(note_callee_static_array, CLASS_NOTE, diag::MAP_FATAL, "callee declares array parameter as static here", 0, true, false, false, false, 2)
DIAG(note_class_declared, CLASS_NOTE, diag::MAP_FATAL, "class is declared here", 0, true, false, false, false, 2)
DIAG(note_compat_assoc, CLASS_NOTE, diag::MAP_FATAL, "compatible type %0 specified here", 0, true, false, false, false, 2)
DIAG(note_condition_assign_silence, CLASS_NOTE, diag::MAP_FATAL, "place parentheses around the assignment to silence this warning", 0, true, false, false, false, 2)
DIAG(note_condition_assign_to_comparison, CLASS_NOTE, diag::MAP_FATAL, "use '==' to turn this assignment into an equality comparison", 0, true, false, false, false, 2)
DIAG(note_condition_or_assign_to_comparison, CLASS_NOTE, diag::MAP_FATAL, "use '!=' to turn this compound assignment into an inequality comparison", 0, true, false, false, false, 2)
DIAG(note_constexpr_body_previous_return, CLASS_NOTE, diag::MAP_FATAL, "previous return statement is here", 0, true, false, false, false, 2)
DIAG(note_constexpr_ctor_missing_init, CLASS_NOTE, diag::MAP_FATAL, "member not initialized by constructor", 0, true, false, false, false, 2)
DIAG(note_constexpr_virtual_base_here, CLASS_NOTE, diag::MAP_FATAL, "virtual base class declared here", 0, true, false, false, false, 2)
DIAG(note_constructor_declared_here, CLASS_NOTE, diag::MAP_FATAL, "constructor declared here", 0, true, false, false, false, 2)
DIAG(note_convert_inline_to_static, CLASS_NOTE, diag::MAP_FATAL, "use 'static' to give inline function %0 internal linkage", 0, true, false, false, false, 2)
DIAG(note_default_arg_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of default argument for '%0' required here", 0, true, false, false, false, 2)
DIAG(note_default_argument_declared_here, CLASS_NOTE, diag::MAP_FATAL, "default argument declared here", 0, true, false, false, false, 2)
DIAG(note_default_function_arg_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of default function argument expression for '%0' required here", 0, true, false, false, false, 2)
DIAG(note_defined_here, CLASS_NOTE, diag::MAP_FATAL, "%0 defined here", 0, true, false, false, false, 2)
DIAG(note_deleted_assign_field, CLASS_NOTE, diag::MAP_FATAL, "%select{copy|move}0 assignment operator of %1 is implicitly deleted because field %2 is of %select{reference|const-qualified}4 type %3", 0, true, false, false, false, 2)
DIAG(note_deleted_copy_ctor_rvalue_reference, CLASS_NOTE, diag::MAP_FATAL, "copy constructor of %0 is implicitly deleted because field %1 is of rvalue reference type %2", 0, true, false, false, false, 2)
DIAG(note_deleted_copy_user_declared_move, CLASS_NOTE, diag::MAP_FATAL, "copy %select{constructor|assignment operator}0 is implicitly deleted because %1 has a user-declared move %select{constructor|assignment operator}2", 0, true, false, false, false, 2)
DIAG(note_deleted_default_ctor_all_const, CLASS_NOTE, diag::MAP_FATAL, "default constructor of %0 is implicitly deleted because all %select{data members|data members of an anonymous union member}1 are const-qualified", 0, true, false, false, false, 2)
DIAG(note_deleted_default_ctor_uninit_field, CLASS_NOTE, diag::MAP_FATAL, "default constructor of %0 is implicitly deleted because field %1 of %select{reference|const-qualified}3 type %2 would not be initialized", 0, true, false, false, false, 2)
DIAG(note_deleted_dtor_no_operator_delete, CLASS_NOTE, diag::MAP_FATAL, "virtual destructor requires an unambiguous, accessible 'operator delete'", 0, true, false, false, false, 2)
DIAG(note_deleted_special_member_class_subobject, CLASS_NOTE, diag::MAP_FATAL, "%select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 of %1 is implicitly deleted because %select{base class %3|%select{||||variant }4field %3}2 has %select{no|a deleted|multiple|an inaccessible|a non-trivial}4 %select{%select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0|destructor}5%select{||s||}4", 0, true, false, false, false, 2)
DIAG(note_dependent_var_use, CLASS_NOTE, diag::MAP_FATAL, "must qualify identifier to find this declaration in dependent base class", 0, true, false, false, false, 2)
DIAG(note_destructor_type_here, CLASS_NOTE, diag::MAP_FATAL, "type %0 is declared here", 0, true, false, false, false, 2)
DIAG(note_empty_body_on_separate_line, CLASS_NOTE, diag::MAP_FATAL, "put the semicolon on a separate line to silence this warning", 0, true, false, false, false, 2)
DIAG(note_empty_parens_default_ctor, CLASS_NOTE, diag::MAP_FATAL, "remove parentheses to declare a variable", 0, true, false, false, false, 2)
DIAG(note_empty_parens_function_call, CLASS_NOTE, diag::MAP_FATAL, "change this ',' to a ';' to call %0", 0, true, false, false, false, 2)
DIAG(note_empty_parens_zero_initialize, CLASS_NOTE, diag::MAP_FATAL, "replace parentheses with an initializer to declare a variable", 0, true, false, false, false, 2)
DIAG(note_enters_block_captures_cxx_obj, CLASS_NOTE, diag::MAP_FATAL, "jump enters lifetime of block which captures a destructible C++ object", 0, true, false, false, false, 2)
DIAG(note_enters_block_captures_strong, CLASS_NOTE, diag::MAP_FATAL, "jump enters lifetime of block which strongly captures a variable", 0, true, false, false, false, 2)
DIAG(note_enters_block_captures_weak, CLASS_NOTE, diag::MAP_FATAL, "jump enters lifetime of block which weakly captures a variable", 0, true, false, false, false, 2)
DIAG(note_enum_specialized_here, CLASS_NOTE, diag::MAP_FATAL, "enum %0 was explicitly specialized here", 0, true, false, false, false, 2)
DIAG(note_equality_comparison_silence, CLASS_NOTE, diag::MAP_FATAL, "remove extraneous parentheses around the comparison to silence this warning", 0, true, false, false, false, 2)
DIAG(note_equality_comparison_to_assign, CLASS_NOTE, diag::MAP_FATAL, "use '=' to turn this equality comparison into an assignment", 0, true, false, false, false, 2)
DIAG(note_exits___block, CLASS_NOTE, diag::MAP_FATAL, "jump exits scope of __block variable", 0, true, false, false, false, 2)
DIAG(note_exits_block_captures_cxx_obj, CLASS_NOTE, diag::MAP_FATAL, "jump exits lifetime of block which captures a destructible C++ object", 0, true, false, false, false, 2)
DIAG(note_exits_block_captures_strong, CLASS_NOTE, diag::MAP_FATAL, "jump exits lifetime of block which strongly captures a variable", 0, true, false, false, false, 2)
DIAG(note_exits_block_captures_weak, CLASS_NOTE, diag::MAP_FATAL, "jump exits lifetime of block which weakly captures a variable", 0, true, false, false, false, 2)
DIAG(note_exits_cleanup, CLASS_NOTE, diag::MAP_FATAL, "jump exits scope of variable with __attribute__((cleanup))", 0, true, false, false, false, 2)
DIAG(note_exits_cxx_catch, CLASS_NOTE, diag::MAP_FATAL, "jump exits catch block", 0, true, false, false, false, 2)
DIAG(note_exits_cxx_try, CLASS_NOTE, diag::MAP_FATAL, "jump exits try block", 0, true, false, false, false, 2)
DIAG(note_exits_dtor, CLASS_NOTE, diag::MAP_FATAL, "jump exits scope of variable with non-trivial destructor", 0, true, false, false, false, 2)
DIAG(note_exits_objc_autoreleasepool, CLASS_NOTE, diag::MAP_FATAL, "jump exits autoreleasepool block", 0, true, false, false, false, 2)
DIAG(note_exits_objc_catch, CLASS_NOTE, diag::MAP_FATAL, "jump exits @catch block", 0, true, false, false, false, 2)
DIAG(note_exits_objc_finally, CLASS_NOTE, diag::MAP_FATAL, "jump exits @finally block", 0, true, false, false, false, 2)
DIAG(note_exits_objc_ownership, CLASS_NOTE, diag::MAP_FATAL, "jump exits scope of retaining variable", 0, true, false, false, false, 2)
DIAG(note_exits_objc_synchronized, CLASS_NOTE, diag::MAP_FATAL, "jump exits @synchronized block", 0, true, false, false, false, 2)
DIAG(note_exits_objc_try, CLASS_NOTE, diag::MAP_FATAL, "jump exits @try block", 0, true, false, false, false, 2)
DIAG(note_explicit_instantiation_candidate, CLASS_NOTE, diag::MAP_FATAL, "explicit instantiation candidate function template here %0", 0, true, false, false, false, 2)
DIAG(note_explicit_instantiation_definition_here, CLASS_NOTE, diag::MAP_FATAL, "explicit instantiation definition is here", 0, true, false, false, false, 2)
DIAG(note_explicit_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "explicit instantiation refers here", 0, true, false, false, false, 2)
DIAG(note_explicit_template_arg_substitution_here, CLASS_NOTE, diag::MAP_FATAL, "while substituting explicitly-specified template arguments into function template %0 %1", 0, true, false, false, false, 2)
DIAG(note_explicit_template_spec_does_not_need_header, CLASS_NOTE, diag::MAP_FATAL, "'template<>' header not required for explicitly-specialized class %0 declared here", 0, true, false, false, false, 2)
DIAG(note_fallthrough_insert_semi_fixit, CLASS_NOTE, diag::MAP_FATAL, "did you forget ';'?", 0, true, false, false, false, 2)
DIAG(note_field_decl, CLASS_NOTE, diag::MAP_FATAL, "member is declared here", 0, true, false, false, false, 2)
DIAG(note_field_designator_found, CLASS_NOTE, diag::MAP_FATAL, "field designator refers here", 0, true, false, false, false, 2)
DIAG(note_final_overrider, CLASS_NOTE, diag::MAP_FATAL, "final overrider of %q0 in %1", 0, true, false, false, false, 2)
DIAG(note_flexible_array_member, CLASS_NOTE, diag::MAP_FATAL, "initialized flexible array member %0 is here", 0, true, false, false, false, 2)
DIAG(note_for_range_begin_end, CLASS_NOTE, diag::MAP_FATAL, "selected '%select{begin|end}0' %select{function|template }1%2 with iterator type %3", 0, true, false, false, false, 2)
DIAG(note_for_range_invalid_iterator, CLASS_NOTE, diag::MAP_FATAL, "in implicit call to 'operator%select{!=|*|++}0' for iterator of type %1", 0, true, false, false, false, 2)
DIAG(note_format_fix_specifier, CLASS_NOTE, diag::MAP_FATAL, "did you mean to use '%0'?", 0, true, false, false, false, 2)
DIAG(note_format_string_defined, CLASS_NOTE, diag::MAP_FATAL, "format string is defined here", 0, true, false, false, false, 2)
DIAG(note_forward_class, CLASS_NOTE, diag::MAP_FATAL, "forward declaration of class here", 0, true, false, false, false, 2)
DIAG(note_found_mutex_near_match, CLASS_NOTE, diag::MAP_FATAL, "found near match '%0'", 0, true, false, false, false, 2)
DIAG(note_function_suggestion, CLASS_NOTE, diag::MAP_FATAL, "did you mean %0?", 0, true, false, false, false, 2)
DIAG(note_function_template_deduction_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "while substituting deduced template arguments into function template %0 %1", 0, true, false, false, false, 2)
DIAG(note_function_template_spec_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of function template specialization %q0 requested here", 0, true, false, false, false, 2)
DIAG(note_function_template_spec_matched, CLASS_NOTE, diag::MAP_FATAL, "function template matches specialization %0", 0, true, false, false, false, 2)
DIAG(note_function_to_bool_call, CLASS_NOTE, diag::MAP_FATAL, "suffix with parentheses to turn this into a function call", 0, true, false, false, false, 2)
DIAG(note_function_to_bool_silence, CLASS_NOTE, diag::MAP_FATAL, "prefix with the address-of operator to silence this warning", 0, true, false, false, false, 2)
DIAG(note_function_with_incomplete_return_type_declared_here, CLASS_NOTE, diag::MAP_FATAL, "%0 declared here", 0, true, false, false, false, 2)
DIAG(note_getter_unavailable, CLASS_NOTE, diag::MAP_FATAL, "or because setter is declared here, but no getter method %0 is found", 0, true, false, false, false, 2)
DIAG(note_hidden_overloaded_virtual_declared_here, CLASS_NOTE, diag::MAP_FATAL, "hidden overloaded virtual function %q0 declared here", 0, true, false, false, false, 2)
DIAG(note_hidden_tag, CLASS_NOTE, diag::MAP_FATAL, "type declaration hidden", 0, true, false, false, false, 2)
DIAG(note_hiding_object, CLASS_NOTE, diag::MAP_FATAL, "declaration hides type", 0, true, false, false, false, 2)
DIAG(note_ice_conversion_here, CLASS_NOTE, diag::MAP_FATAL, "conversion to %select{integral|enumeration}0 type %1 declared here", 0, true, false, false, false, 2)
DIAG(note_implementation_declared, CLASS_NOTE, diag::MAP_FATAL, "class implementation is declared here", 0, true, false, false, false, 2)
DIAG(note_implicitly_deleted, CLASS_NOTE, diag::MAP_FATAL, "explicitly defaulted function was implicitly deleted here", 0, true, false, false, false, 2)
DIAG(note_in_class_initializer_float_type_constexpr, CLASS_NOTE, diag::MAP_FATAL, "use 'constexpr' specifier to silence this warning", 0, true, false, false, false, 2)
DIAG(note_in_for_range, CLASS_NOTE, diag::MAP_FATAL, "when looking up '%select{begin|end}0' function for range expression of type %1", 0, true, false, false, false, 2)
DIAG(note_indirect_goto_target, CLASS_NOTE, diag::MAP_FATAL, "possible target of indirect goto", 0, true, false, false, false, 2)
DIAG(note_indirection_through_null, CLASS_NOTE, diag::MAP_FATAL, "consider using __builtin_trap() or qualifying pointer with 'volatile'", 0, true, false, false, false, 2)
DIAG(note_inequality_comparison_to_or_assign, CLASS_NOTE, diag::MAP_FATAL, "use '|=' to turn this inequality comparison into an or-assignment", 0, true, false, false, false, 2)
DIAG(note_init_list_narrowing_override, CLASS_NOTE, diag::MAP_FATAL, "override this message by inserting an explicit cast", 0, true, false, false, false, 2)
DIAG(note_insert_break_fixit, CLASS_NOTE, diag::MAP_FATAL, "insert 'break;' to avoid fall-through", 0, true, false, false, false, 2)
DIAG(note_insert_fallthrough_fixit, CLASS_NOTE, diag::MAP_FATAL, "insert '%0;' to silence this warning", 0, true, false, false, false, 2)
DIAG(note_instantiation_contexts_suppressed, CLASS_NOTE, diag::MAP_FATAL, "(skipping %0 context%s0 in backtrace; use -ftemplate-backtrace-limit=0 to see all)", 0, true, false, false, false, 2)
DIAG(note_instantiation_required_here, CLASS_NOTE, diag::MAP_FATAL, "%select{implicit|explicit}0 instantiation first required here", 0, true, false, false, false, 2)
DIAG(note_internal_decl_declared_here, CLASS_NOTE, diag::MAP_FATAL, "%0 declared here", 0, true, false, false, false, 2)
DIAG(note_it_delegates_to, CLASS_NOTE, diag::MAP_FATAL, "it delegates to", 0, true, false, false, false, 2)
DIAG(note_ivar_decl, CLASS_NOTE, diag::MAP_FATAL, "instance variable is declared here", 0, true, false, false, false, 2)
DIAG(note_lambda_decl, CLASS_NOTE, diag::MAP_FATAL, "lambda expression begins here", 0, true, false, false, false, 3)
DIAG(note_lambda_to_block_conv, CLASS_NOTE, diag::MAP_FATAL, "implicit capture of lambda object due to conversion to block pointer here", 0, true, false, false, false, 3)
DIAG(note_local_variable_declared_here, CLASS_NOTE, diag::MAP_FATAL, "%0 declared here", 0, true, false, false, false, 2)
DIAG(note_lock_exclusive_and_shared, CLASS_NOTE, diag::MAP_FATAL, "the other lock of mutex '%0' is here", 0, true, false, false, false, 2)
DIAG(note_locked_here, CLASS_NOTE, diag::MAP_FATAL, "mutex acquired here", 0, true, false, false, false, 2)
DIAG(note_logical_instead_of_bitwise_change_operator, CLASS_NOTE, diag::MAP_FATAL, "use '%0' for a bitwise operation", 0, true, false, false, false, 2)
DIAG(note_logical_instead_of_bitwise_remove_constant, CLASS_NOTE, diag::MAP_FATAL, "remove constant to silence this warning", 0, true, false, false, false, 2)
DIAG(note_member_declared_here, CLASS_NOTE, diag::MAP_FATAL, "member %0 declared here", 0, true, false, false, false, 2)
DIAG(note_member_def_close_const_match, CLASS_NOTE, diag::MAP_FATAL, "member declaration does not match because it %select{is|is not}0 const qualified", 0, true, false, false, false, 2)
DIAG(note_member_def_close_match, CLASS_NOTE, diag::MAP_FATAL, "member declaration nearly matches", 0, true, false, false, false, 2)
DIAG(note_member_def_close_param_match, CLASS_NOTE, diag::MAP_FATAL, "type of %ordinal0 parameter of member declaration does not match definition%diff{ ($ vs $)|}1,2", 0, true, false, false, false, 2)
DIAG(note_member_of_template_here, CLASS_NOTE, diag::MAP_FATAL, "member is declared here", 0, true, false, false, false, 2)
DIAG(note_member_synthesized_at, CLASS_NOTE, diag::MAP_FATAL, "implicit default %select{constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 for %1 first required here", 0, true, false, false, false, 2)
DIAG(note_method_declared_at, CLASS_NOTE, diag::MAP_FATAL, "method %0 declared here", 0, true, false, false, false, 2)
DIAG(note_method_sent_forward_class, CLASS_NOTE, diag::MAP_FATAL, "method %0 is used for the forward class", 0, true, false, false, false, 2)
DIAG(note_namespace_defined_here, CLASS_NOTE, diag::MAP_FATAL, "namespace %0 defined here", 0, true, false, false, false, 2)
DIAG(note_non_instantiated_member_here, CLASS_NOTE, diag::MAP_FATAL, "not-yet-instantiated member is declared here", 0, true, false, false, false, 2)
DIAG(note_non_literal_base_class, CLASS_NOTE, diag::MAP_FATAL, "%0 is not literal because it has base class %1 of non-literal type", 0, true, false, false, false, 2)
DIAG(note_non_literal_field, CLASS_NOTE, diag::MAP_FATAL, "%0 is not literal because it has data member %1 of %select{non-literal|volatile}3 type %2", 0, true, false, false, false, 2)
DIAG(note_non_literal_incomplete, CLASS_NOTE, diag::MAP_FATAL, "incomplete type %0 is not a literal type", 0, true, false, false, false, 2)
DIAG(note_non_literal_no_constexpr_ctors, CLASS_NOTE, diag::MAP_FATAL, "%0 is not literal because it is not an aggregate and has no constexpr constructors other than copy or move constructors", 0, true, false, false, false, 2)
DIAG(note_non_literal_nontrivial_dtor, CLASS_NOTE, diag::MAP_FATAL, "%0 is not literal because it has a non-trivial destructor", 0, true, false, false, false, 2)
DIAG(note_non_literal_user_provided_dtor, CLASS_NOTE, diag::MAP_FATAL, "%0 is not literal because it has a user-provided destructor", 0, true, false, false, false, 2)
DIAG(note_non_literal_virtual_base, CLASS_NOTE, diag::MAP_FATAL, "%select{struct|interface|class}0 with virtual base %plural{1:class|:classes}1 is not a literal type", 0, true, false, false, false, 2)
DIAG(note_nontemplate_decl_here, CLASS_NOTE, diag::MAP_FATAL, "non-templated declaration is here", 0, true, false, false, false, 2)
DIAG(note_nontrivial_has_nontrivial, CLASS_NOTE, diag::MAP_FATAL, "because type %0 has a %select{member|base class}1 with a non-trivial %select{constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}2", 0, true, false, false, false, 2)
DIAG(note_nontrivial_has_virtual, CLASS_NOTE, diag::MAP_FATAL, "because type %0 has a virtual %select{member function|base class}1", 0, true, false, false, false, 2)
DIAG(note_nontrivial_objc_ownership, CLASS_NOTE, diag::MAP_FATAL, "because type %0 has %select{no|no|__strong|__weak|__autoreleasing}1 ownership", 0, true, false, false, false, 5)
DIAG(note_nontrivial_user_defined, CLASS_NOTE, diag::MAP_FATAL, "because type %0 has a user-declared %select{constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}1", 0, true, false, false, false, 2)
DIAG(note_not_found_by_two_phase_lookup, CLASS_NOTE, diag::MAP_FATAL, "%0 should be declared prior to the call site%select{| or in %2| or in an associated namespace of one of its arguments}1", 0, true, false, false, false, 2)
DIAG(note_objc_literal_comparison_isequal, CLASS_NOTE, diag::MAP_FATAL, "use 'isEqual:' instead", 0, true, false, false, false, 2)
DIAG(note_objc_literal_method_param, CLASS_NOTE, diag::MAP_FATAL, "%select{first|second|third}0 parameter has unexpected type %1 (should be %2)", 0, true, false, false, false, 2)
DIAG(note_objc_literal_method_return, CLASS_NOTE, diag::MAP_FATAL, "method returns unexpected type %0 (should be an object type)", 0, true, false, false, false, 2)
DIAG(note_objc_needs_superclass, CLASS_NOTE, diag::MAP_FATAL, "add a super class to fix this problem", 0, true, false, false, false, 2)
DIAG(note_overridden_virtual_function, CLASS_NOTE, diag::MAP_FATAL, "overridden virtual function is here", 0, true, false, false, false, 2)
DIAG(note_ovl_builtin_binary_candidate, CLASS_NOTE, diag::MAP_FATAL, "built-in candidate %0", 0, true, false, false, false, 2)
DIAG(note_ovl_builtin_unary_candidate, CLASS_NOTE, diag::MAP_FATAL, "built-in candidate %0", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |is the implicit default constructor|is the implicit copy constructor|is the implicit move constructor|is the implicit copy assignment operator|is the implicit move assignment operator|is an inherited constructor}0%1%select{| has different class%diff{ (expected $ but has $)|}3,4| has different number of parameters (expected %3 but has %4)| has type mismatch at %ordinal3 parameter%diff{ (expected $ but has $)|}4,5| has different return type%diff{ ($ expected but has $)|}3,4| has different qualifiers (expected %select{none|const|restrict|const and restrict|volatile|const and volatile|volatile and restrict|const, volatile, and restrict}3 but found %select{none|const|restrict|const and restrict|volatile|const and volatile|volatile and restrict|const, volatile, and restrict}4)}2", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_arity, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function|function|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0 %select{|template }1not viable: requires%select{ at least| at most|}2 %3 argument%s3, but %4 %plural{1:was|:were}4 provided", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_arity_one, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function|function|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0 %select{|template }1not viable: %select{requires at least|allows at most single|requires single}2 argument %3, but %plural{0:no|:%4}4 arguments were provided", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_addrspace, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: %select{%ordinal6|'this'}5 argument (%2) is in address space %3, but parameter must be in address space %4", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_arc_conv, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: cannot implicitly convert argument %diff{of type $ to $|type to parameter type}2,3 for %select{%ordinal5 argument|object argument}4 under ARC", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_base_to_derived_conv, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: cannot %select{convert from|convert from|bind}2 %select{base class pointer|superclass|base class object of type}2 %3 to %select{derived class pointer|subclass|derived class reference}2 %4 for %ordinal5 argument", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_conv, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: no known conversion %diff{from $ to $|from argument type to parameter type}2,3 for %select{%ordinal5 argument|object argument}4%select{|; dereference the argument with *|; take the address of the argument with &|; remove *|; remove &}6", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_conv_incomplete, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: cannot convert argument of incomplete type %diff{$ to $|to parameter type}2,3", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_cvr, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: %ordinal4 argument (%2) would lose %select{const|restrict|const and restrict|volatile|const and volatile|volatile and restrict|const, volatile, and restrict}3 qualifier%select{||s||s|s|s}3", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_cvr_this, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{|function|||function|||||function (the implicit copy assignment operator)|function (the implicit move assignment operator)|}0 not viable: 'this' argument has type %2, but method is not marked %select{const|restrict|const or restrict|volatile|const or volatile|volatile or restrict|const, volatile, or restrict}3", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_deduction, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: failed template argument deduction", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_gc, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: %select{%ordinal6|'this'}5 argument (%2) has %select{no|__weak|__strong}3 ownership, but parameter has %select{no|__weak|__strong}4 ownership", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_list_argument, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: cannot convert initializer list argument to %3", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_lvalue, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: expects an l-value for %select{%ordinal3 argument|object argument}2", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_overload, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: no overload of %3 matching %2 for %ordinal4 argument", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_ownership, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 not viable: %select{%ordinal6|'this'}5 argument (%2) has %select{no|__unsafe_unretained|__strong|__weak|__autoreleasing}3 ownership, but parameter has %select{no|__unsafe_unretained|__strong|__weak|__autoreleasing}4 ownership", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_bad_target, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0 not viable: call to %select{__device__|__global__|__host__|__host__ __device__}1 function from %select{__device__|__global__|__host__|__host__ __device__}2 function", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_deleted, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|constructor (inherited)}0%1 has been %select{explicitly made unavailable|explicitly deleted|implicitly deleted}2", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_disabled_by_enable_if, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: disabled by %0%1", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_explicit_arg_mismatch_named, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: invalid explicitly-specified argument for template parameter %0", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_explicit_arg_mismatch_unnamed, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: invalid explicitly-specified argument for %ordinal0 template parameter", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_incomplete_deduction, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: couldn't infer template argument %0", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_inconsistent_deduction, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: deduced conflicting %select{types|values|templates}0 for parameter %1%diff{ ($ vs. $)|}2,3", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_inherited_constructor, CLASS_NOTE, diag::MAP_FATAL, "inherited from here", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_instantiation_depth, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: substitution exceeded maximum template instantiation depth", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_substitution_failure, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: substitution failure%0%1", 0, true, false, false, false, 2)
DIAG(note_ovl_candidate_underqualified, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: can't deduce a type for %0 which would make %2 equal %1", 0, true, false, false, false, 2)
DIAG(note_ovl_surrogate_cand, CLASS_NOTE, diag::MAP_FATAL, "conversion candidate of type %0", 0, true, false, false, false, 2)
DIAG(note_ovl_too_many_candidates, CLASS_NOTE, diag::MAP_FATAL, "remaining %0 candidate%s0 omitted; pass -fshow-overloads=all to show them", 0, true, false, false, false, 2)
DIAG(note_parameter_here, CLASS_NOTE, diag::MAP_FATAL, "passing argument to parameter here", 0, true, false, false, false, 2)
DIAG(note_parameter_named_here, CLASS_NOTE, diag::MAP_FATAL, "passing argument to parameter %0 here", 0, true, false, false, false, 2)
DIAG(note_parameter_pack_here, CLASS_NOTE, diag::MAP_FATAL, "parameter pack %0 declared here", 0, true, false, false, false, 2)
DIAG(note_parameter_type, CLASS_NOTE, diag::MAP_FATAL, "parameter of type %0 is declared here", 0, true, false, false, false, 2)
DIAG(note_partial_spec_deduct_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "during template argument deduction for class template partial specialization %0 %1", 0, true, false, false, false, 2)
DIAG(note_partial_spec_match, CLASS_NOTE, diag::MAP_FATAL, "partial specialization matches %0", 0, true, false, false, false, 2)
DIAG(note_partial_spec_unused_parameter, CLASS_NOTE, diag::MAP_FATAL, "non-deducible template parameter %0", 0, true, false, false, false, 2)
DIAG(note_please_include_header, CLASS_NOTE, diag::MAP_FATAL, "please include the header <%0> or explicitly provide a declaration for '%1'", 0, true, false, false, false, 2)
DIAG(note_possible_target_of_call, CLASS_NOTE, diag::MAP_FATAL, "possible target for call", 0, true, false, false, false, 2)
DIAG(note_precedence_bitwise_first, CLASS_NOTE, diag::MAP_FATAL, "place parentheses around the %0 expression to evaluate it first", 0, true, false, false, false, 2)
DIAG(note_precedence_conditional_first, CLASS_NOTE, diag::MAP_FATAL, "place parentheses around the '?:' expression to evaluate it first", 0, true, false, false, false, 2)
DIAG(note_precedence_silence, CLASS_NOTE, diag::MAP_FATAL, "place parentheses around the '%0' expression to silence this warning", 0, true, false, false, false, 2)
DIAG(note_prev_partial_spec_here, CLASS_NOTE, diag::MAP_FATAL, "previous declaration of class template partial specialization %0 is here", 0, true, false, false, false, 2)
DIAG(note_previous_access_declaration, CLASS_NOTE, diag::MAP_FATAL, "previously declared '%1' here", 0, true, false, false, false, 2)
DIAG(note_previous_attribute, CLASS_NOTE, diag::MAP_FATAL, "previous attribute is here", 0, true, false, false, false, 2)
DIAG(note_previous_builtin_declaration, CLASS_NOTE, diag::MAP_FATAL, "%0 is a builtin with type %1", 0, true, false, false, false, 2)
DIAG(note_previous_decl, CLASS_NOTE, diag::MAP_FATAL, "%0 declared here", 0, true, false, false, false, 2)
DIAG(note_previous_declaration_special, CLASS_NOTE, diag::MAP_FATAL, "previous declaration was %select{*ERROR*|a copy constructor|a move constructor|*ERROR*|*ERROR*|*ERROR*|not a special member function}0", 0, true, false, false, false, 2)
DIAG(note_previous_exception_handler, CLASS_NOTE, diag::MAP_FATAL, "for type %0", 0, true, false, false, false, 2)
DIAG(note_previous_explicit_instantiation, CLASS_NOTE, diag::MAP_FATAL, "previous explicit instantiation is here", 0, true, false, false, false, 2)
DIAG(note_previous_initializer, CLASS_NOTE, diag::MAP_FATAL, "previous initialization %select{|with side effects }0is here%select{| (side effects may not occur at run time)}0", 0, true, false, false, false, 2)
DIAG(note_previous_template_specialization, CLASS_NOTE, diag::MAP_FATAL, "previous template specialization is here", 0, true, false, false, false, 2)
DIAG(note_printf_c_str, CLASS_NOTE, diag::MAP_FATAL, "did you mean to call the %0 method?", 0, true, false, false, false, 2)
DIAG(note_prior_template_arg_substitution, CLASS_NOTE, diag::MAP_FATAL, "while substituting prior template arguments into %select{non-type|template}0 template parameter%1 %2", 0, true, false, false, false, 2)
DIAG(note_private_extern, CLASS_NOTE, diag::MAP_FATAL, "use __attribute__((visibility(\"hidden\"))) attribute instead", 0, true, false, false, false, 2)
DIAG(note_property_attribute, CLASS_NOTE, diag::MAP_FATAL, "property %0 is declared %select{deprecated|unavailable}1 here", 0, true, false, false, false, 2)
DIAG(note_property_declare, CLASS_NOTE, diag::MAP_FATAL, "property declared here", 0, true, false, false, false, 2)
DIAG(note_protected_by___block, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses setup of __block variable", 0, true, false, false, false, 2)
DIAG(note_protected_by_cleanup, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of variable with __attribute__((cleanup))", 0, true, false, false, false, 2)
DIAG(note_protected_by_cxx_catch, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of catch block", 0, true, false, false, false, 2)
DIAG(note_protected_by_cxx_try, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of try block", 0, true, false, false, false, 2)
DIAG(note_protected_by_objc_autoreleasepool, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses auto release push of @autoreleasepool block", 0, true, false, false, false, 2)
DIAG(note_protected_by_objc_catch, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of @catch block", 0, true, false, false, false, 2)
DIAG(note_protected_by_objc_finally, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of @finally block", 0, true, false, false, false, 2)
DIAG(note_protected_by_objc_ownership, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of retaining variable", 0, true, false, false, false, 2)
DIAG(note_protected_by_objc_synchronized, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of @synchronized block", 0, true, false, false, false, 2)
DIAG(note_protected_by_objc_try, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of @try block", 0, true, false, false, false, 2)
DIAG(note_protected_by_variable_init, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses variable initialization", 0, true, false, false, false, 2)
DIAG(note_protected_by_variable_non_pod, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of non-POD variable", 0, true, false, false, false, 2)
DIAG(note_protected_by_variable_nontriv_destructor, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses variable with a non-trivial destructor", 0, true, false, false, false, 2)
DIAG(note_protected_by_vla, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of variable length array", 0, true, false, false, false, 2)
DIAG(note_protected_by_vla_type_alias, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of VLA type alias", 0, true, false, false, false, 2)
DIAG(note_protected_by_vla_typedef, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of VLA typedef", 0, true, false, false, false, 2)
DIAG(note_protocol_decl, CLASS_NOTE, diag::MAP_FATAL, "protocol is declared here", 0, true, false, false, false, 2)
DIAG(note_pure_virtual_function, CLASS_NOTE, diag::MAP_FATAL, "unimplemented pure virtual method %0 in %1", 0, true, false, false, false, 2)
DIAG(note_receiver_is_id, CLASS_NOTE, diag::MAP_FATAL, "receiver is treated with 'id' type for purpose of method lookup", 0, true, false, false, false, 2)
DIAG(note_ref_or_ptr_member_declared_here, CLASS_NOTE, diag::MAP_FATAL, "%select{reference|pointer}0 member declared here", 0, true, false, false, false, 2)
DIAG(note_ref_var_local_bind, CLASS_NOTE, diag::MAP_FATAL, "binding reference variable %0 here", 0, true, false, false, false, 2)
DIAG(note_refconst_member_not_initialized, CLASS_NOTE, diag::MAP_FATAL, "%select{const|reference}0 member %1 will never be initialized", 0, true, false, false, false, 2)
DIAG(note_referenced_class_template, CLASS_ERROR, diag::MAP_ERROR, "class template declared here", 0, true, false, false, false, 2)
DIAG(note_related_result_type_inferred, CLASS_NOTE, diag::MAP_FATAL, "%select{class|instance}0 method %1 is assumed to return an instance of its receiver type (%2)", 0, true, false, false, false, 17)
DIAG(note_related_result_type_overridden, CLASS_NOTE, diag::MAP_FATAL, "overridden method returns an instance of its class type", 0, true, false, false, false, 17)
DIAG(note_related_result_type_overridden_family, CLASS_NOTE, diag::MAP_FATAL, "overridden method is part of the '%select{|alloc|copy|init|mutableCopy|new|autorelease|dealloc|finalize|release|retain|retainCount|self}0' method family", 0, true, false, false, false, 17)
DIAG(note_required_for_protocol_at, CLASS_NOTE, diag::MAP_FATAL, "required for direct or indirect protocol %0", 0, true, false, false, false, 2)
DIAG(note_sentinel_here, CLASS_NOTE, diag::MAP_FATAL, "%select{function|method|block}0 has been explicitly marked sentinel here", 0, true, false, false, false, 2)
DIAG(note_specialized_decl, CLASS_NOTE, diag::MAP_FATAL, "attempt to specialize declaration here", 0, true, false, false, false, 2)
DIAG(note_specialized_entity, CLASS_NOTE, diag::MAP_FATAL, "explicitly specialized declaration is here", 0, true, false, false, false, 2)
DIAG(note_string_plus_int_silence, CLASS_NOTE, diag::MAP_FATAL, "use array indexing to silence this warning", 0, true, false, false, false, 2)
DIAG(note_strlcpycat_wrong_size, CLASS_NOTE, diag::MAP_FATAL, "change size argument to be the size of the destination", 0, true, false, false, false, 2)
DIAG(note_strncat_wrong_size, CLASS_NOTE, diag::MAP_FATAL, "change the argument to be the free space in the destination buffer minus the terminating null byte", 0, true, false, false, false, 2)
DIAG(note_struct_class_suggestion, CLASS_NOTE, diag::MAP_FATAL, "did you mean %select{struct|interface|class}0 here?", 0, true, false, false, false, 2)
DIAG(note_suppressed_class_declare, CLASS_NOTE, diag::MAP_FATAL, "class with specified objc_requires_property_definitions attribute is declared here", 0, true, false, false, false, 2)
DIAG(note_surrounding_namespace_ends_here, CLASS_NOTE, diag::MAP_FATAL, "surrounding namespace with visibility attribute ends here", 0, true, false, false, false, 2)
DIAG(note_surrounding_namespace_starts_here, CLASS_NOTE, diag::MAP_FATAL, "surrounding namespace with visibility attribute starts here", 0, true, false, false, false, 2)
DIAG(note_switch_conversion, CLASS_NOTE, diag::MAP_FATAL, "conversion to %select{integral|enumeration}0 type %1", 0, true, false, false, false, 2)
DIAG(note_template_arg_internal_object, CLASS_NOTE, diag::MAP_FATAL, "non-type template argument refers to %select{function|object}0 here", 0, true, false, false, false, 2)
DIAG(note_template_arg_refers_here, CLASS_NOTE, diag::MAP_FATAL, "non-type template argument refers here", 0, true, false, false, false, 2)
DIAG(note_template_arg_refers_here_func, CLASS_NOTE, diag::MAP_FATAL, "template argument refers to function template %0, here", 0, true, false, false, false, 2)
DIAG(note_template_class_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of template class %0 requested here", 0, true, false, false, false, 2)
DIAG(note_template_decl_here, CLASS_NOTE, diag::MAP_FATAL, "template is declared here", 0, true, false, false, false, 2)
DIAG(note_template_declared_here, CLASS_NOTE, diag::MAP_FATAL, "%select{function template|class template|type alias template|template template parameter}0 %1 declared here", 0, true, false, false, false, 2)
DIAG(note_template_default_arg_checking, CLASS_NOTE, diag::MAP_FATAL, "while checking a default template argument used here", 0, true, false, false, false, 2)
DIAG(note_template_enum_def_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of enumeration %q0 requested here", 0, true, false, false, false, 2)
DIAG(note_template_exception_spec_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of exception specification for %0 requested here", 0, true, false, false, false, 2)
DIAG(note_template_member_class_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of member class %0 requested here", 0, true, false, false, false, 2)
DIAG(note_template_member_function_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of member function %q0 requested here", 0, true, false, false, false, 2)
DIAG(note_template_nontype_parm_different_type, CLASS_NOTE, diag::MAP_FATAL, "template non-type parameter has a different type %0 in template argument", 0, true, false, false, false, 2)
DIAG(note_template_nontype_parm_prev_declaration, CLASS_NOTE, diag::MAP_FATAL, "previous non-type template parameter with type %0 is here", 0, true, false, false, false, 2)
DIAG(note_template_param_different_kind, CLASS_NOTE, diag::MAP_FATAL, "template parameter has a different kind in template argument", 0, true, false, false, false, 2)
DIAG(note_template_param_here, CLASS_NOTE, diag::MAP_FATAL, "template parameter is declared here", 0, true, false, false, false, 2)
DIAG(note_template_param_list_different_arity, CLASS_NOTE, diag::MAP_FATAL, "%select{too few|too many}0 template parameters in template template argument", 0, true, false, false, false, 2)
DIAG(note_template_param_prev_default_arg, CLASS_NOTE, diag::MAP_FATAL, "previous default template argument defined here", 0, true, false, false, false, 2)
DIAG(note_template_parameter_pack_here, CLASS_NOTE, diag::MAP_FATAL, "previous %select{template type|non-type template|template template}0 parameter%select{| pack}1 declared here", 0, true, false, false, false, 2)
DIAG(note_template_parameter_pack_non_pack, CLASS_NOTE, diag::MAP_FATAL, "%select{template type|non-type template|template template}0 parameter%select{| pack}1 does not match %select{template type|non-type template|template template}0 parameter%select{ pack|}1 in template argument", 0, true, false, false, false, 2)
DIAG(note_template_prev_declaration, CLASS_NOTE, diag::MAP_FATAL, "previous template %select{declaration|template parameter}0 is here", 0, true, false, false, false, 2)
DIAG(note_template_recursion_depth, CLASS_NOTE, diag::MAP_FATAL, "use -ftemplate-depth=N to increase recursive template instantiation depth", 0, true, false, false, false, 2)
DIAG(note_template_static_data_member_def_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of static data member %q0 requested here", 0, true, false, false, false, 2)
DIAG(note_template_type_alias_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of template type alias %0 requested here", 0, true, false, false, false, 2)
DIAG(note_template_unnamed_type_here, CLASS_NOTE, diag::MAP_FATAL, "unnamed type used in template argument was declared here", 0, true, false, false, false, 2)
DIAG(note_transparent_union_first_field_size_align, CLASS_NOTE, diag::MAP_FATAL, "%select{alignment|size}0 of first field is %1 bits", 0, true, false, false, false, 2)
DIAG(note_typename_refers_here, CLASS_NOTE, diag::MAP_FATAL, "referenced member %0 is declared here", 0, true, false, false, false, 2)
DIAG(note_unavailable_here, CLASS_NOTE, diag::MAP_FATAL, "%select{declaration|function}0 has been explicitly marked %select{unavailable|deleted|deprecated}1 here", 0, true, false, false, false, 2)
DIAG(note_undef_method_impl, CLASS_NOTE, diag::MAP_FATAL, "method definition for %0 not found", 0, true, false, false, false, 2)
DIAG(note_uninit_fixit_remove_cond, CLASS_NOTE, diag::MAP_FATAL, "remove the %select{'%1' if its condition|condition if it}0 is always %select{false|true}2", 0, true, false, false, false, 2)
DIAG(note_uninit_reference_member, CLASS_NOTE, diag::MAP_FATAL, "uninitialized reference member is here", 0, true, false, false, false, 2)
DIAG(note_uninit_var_def, CLASS_NOTE, diag::MAP_FATAL, "variable %0 is declared here", 0, true, false, false, false, 2)
DIAG(note_uninit_var_use, CLASS_NOTE, diag::MAP_FATAL, "%select{uninitialized use occurs|variable is captured by block}0 here", 0, true, false, false, false, 2)
DIAG(note_used_here, CLASS_NOTE, diag::MAP_FATAL, "used here", 0, true, false, false, false, 2)
DIAG(note_using_decl, CLASS_NOTE, diag::MAP_FATAL, "%select{|previous }0using declaration", 0, true, false, false, false, 2)
DIAG(note_using_decl_conflict, CLASS_NOTE, diag::MAP_FATAL, "conflicting declaration", 0, true, false, false, false, 2)
DIAG(note_using_decl_constructor_conflict_current_ctor, CLASS_NOTE, diag::MAP_FATAL, "conflicting constructor", 0, true, false, false, false, 2)
DIAG(note_using_decl_constructor_conflict_previous_ctor, CLASS_NOTE, diag::MAP_FATAL, "previous constructor", 0, true, false, false, false, 2)
DIAG(note_using_decl_constructor_conflict_previous_using, CLASS_NOTE, diag::MAP_FATAL, "previously inherited here", 0, true, false, false, false, 2)
DIAG(note_using_decl_target, CLASS_NOTE, diag::MAP_FATAL, "target of using declaration", 0, true, false, false, false, 2)
DIAG(note_using_value_decl_missing_typename, CLASS_NOTE, diag::MAP_FATAL, "add 'typename' to treat this using declaration as a type", 0, true, false, false, false, 2)
DIAG(note_var_fixit_add_initialization, CLASS_NOTE, diag::MAP_FATAL, "initialize the variable %0 to silence this warning", 0, true, false, false, false, 2)
DIAG(note_which_delegates_to, CLASS_NOTE, diag::MAP_FATAL, "which delegates to", 0, true, false, false, false, 2)
DIAG(note_while_in_implementation, CLASS_NOTE, diag::MAP_FATAL, "detected while default synthesizing properties in class implementation", 0, true, false, false, false, 2)
DIAG(override_keyword_only_allowed_on_virtual_member_functions, CLASS_ERROR, diag::MAP_ERROR, "only virtual member functions can be marked '%0'", 0, true, false, false, false, 2)
DIAG(warn_abstract_final_class, CLASS_WARNING, diag::MAP_WARNING, "abstract class is marked 'final'", 6, true, false, false, false, 2)
DIAG(warn_access_decl_deprecated, CLASS_WARNING, diag::MAP_WARNING, "access declarations are deprecated; use using declarations instead", 88, true, false, false, false, 19)
DIAG(warn_accessor_property_type_mismatch, CLASS_WARNING, diag::MAP_WARNING, "type of property %0 does not match type of accessor %1", 0, true, false, false, false, 2)
DIAG(warn_addition_in_bitshift, CLASS_WARNING, diag::MAP_WARNING, "operator '%0' has lower precedence than '%1'; '%1' will be evaluated first", 282, true, false, false, false, 2)
DIAG(warn_anon_bitfield_width_exceeds_type_size, CLASS_WARNING, diag::MAP_WARNING, "size of anonymous bit-field (%0 bits) exceeds size of its type; value will be truncated to %1 bits", 0, true, false, false, false, 2)
DIAG(warn_arc_object_memaccess, CLASS_WARNING, diag::MAP_WARNING, "%select{destination for|source of}0 this %1 call is a pointer to ownership-qualified type %2", 19, true, false, false, false, 5)
DIAG(warn_arc_perform_selector_leaks, CLASS_WARNING, diag::MAP_WARNING, "performSelector may cause a leak because its selector is unknown", 20, true, false, false, false, 2)
DIAG(warn_arc_possible_repeated_use_of_weak, CLASS_WARNING, diag::MAP_IGNORE, "weak %select{variable|property|implicit property|instance variable}0 %1 may be accessed multiple times in this %select{function|method|block|lambda}2 and may be unpredictably set to nil; assign to a strong variable to keep the object alive", 18, true, false, false, false, 2)
DIAG(warn_arc_repeated_use_of_weak, CLASS_WARNING, diag::MAP_IGNORE, "weak %select{variable|property|implicit property|instance variable}0 %1 is accessed multiple times in this %select{function|method|block|lambda}2 but may be unpredictably set to nil; assign to a strong variable to keep the object alive", 21, true, false, false, false, 2)
DIAG(warn_arc_retain_cycle, CLASS_WARNING, diag::MAP_WARNING, "capturing %0 strongly in this block is likely to lead to a retain cycle", 22, true, false, false, false, 16)
DIAG(warn_arc_retained_assign, CLASS_WARNING, diag::MAP_WARNING, "assigning retained object to %select{weak|unsafe_unretained}0 %select{property|variable}1; object will be released after assignment", 23, true, false, false, false, 5)
DIAG(warn_arc_retained_property_assign, CLASS_WARNING, diag::MAP_WARNING, "assigning retained object to unsafe property; object will be released after assignment", 23, true, false, false, false, 5)
DIAG(warn_arc_strong_pointer_objc_pointer, CLASS_WARNING, diag::MAP_IGNORE, "method parameter of type %0 with no explicit ownership", 117, true, false, false, false, 10)
DIAG(warn_array_index_exceeds_bounds, CLASS_WARNING, diag::MAP_WARNING, "array index %0 is past the end of the array (which contains %1 element%s2)", 24, true, false, false, false, 2)
DIAG(warn_array_index_precedes_bounds, CLASS_WARNING, diag::MAP_WARNING, "array index %0 is before the beginning of the array", 24, true, false, false, false, 2)
DIAG(warn_array_new_too_large, CLASS_WARNING, diag::MAP_WARNING, "array is too large (%0 elements)", 37, true, false, false, false, 2)
DIAG(warn_asm_label_on_auto_decl, CLASS_WARNING, diag::MAP_WARNING, "ignored asm label '%0' on automatic variable", 0, true, false, false, false, 11)
DIAG(warn_asm_mismatched_size_modifier, CLASS_WARNING, diag::MAP_WARNING, "the size being stored is truncated, use a modifier to specify the size", 27, true, false, false, false, 11)
DIAG(warn_atomic_property_rule, CLASS_WARNING, diag::MAP_WARNING, "writable atomic property %0 cannot pair a synthesized %select{getter|setter}1 with a user defined %select{getter|setter}2", 30, true, false, false, false, 2)
DIAG(warn_attribute_after_definition_ignored, CLASS_WARNING, diag::MAP_WARNING, "attribute %0 after definition is ignored", 142, true, false, false, false, 2)
DIAG(warn_attribute_ibaction, CLASS_WARNING, diag::MAP_WARNING, "ibaction attribute can only be applied to Objective-C instance methods", 142, true, false, false, false, 2)
DIAG(warn_attribute_iboutlet, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute can only be applied to instance variables or properties", 142, true, false, false, false, 2)
DIAG(warn_attribute_ignored, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute ignored", 142, true, false, false, false, 2)
DIAG(warn_attribute_ignored_for_field_of_type, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute ignored for field of type %1", 142, true, false, false, false, 2)
DIAG(warn_attribute_invalid_on_stmt, CLASS_WARNING, diag::MAP_WARNING, "attribute %0 cannot be specified on a statement", 142, true, false, false, false, 2)
DIAG(warn_attribute_malloc_pointer_only, CLASS_WARNING, diag::MAP_WARNING, "'malloc' attribute only applies to functions returning a pointer type", 142, true, false, false, false, 2)
DIAG(warn_attribute_method_def, CLASS_WARNING, diag::MAP_WARNING, "attributes on method implementation and its declaration must match", 188, true, false, false, false, 2)
DIAG(warn_attribute_nonnull_no_pointers, CLASS_WARNING, diag::MAP_WARNING, "'nonnull' attribute applied to function with no pointer arguments", 142, true, false, false, false, 2)
DIAG(warn_attribute_not_on_decl, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute ignored when parsing type", 0, true, false, false, false, 2)
DIAG(warn_attribute_precede_definition, CLASS_WARNING, diag::MAP_WARNING, "attribute declaration must precede definition", 142, true, false, false, false, 2)
DIAG(warn_attribute_protected_visibility, CLASS_WARNING, diag::MAP_WARNING, "target does not support 'protected' visibility; using 'default'", 341, true, false, false, false, 2)
DIAG(warn_attribute_requires_functions_or_static_globals, CLASS_WARNING, diag::MAP_WARNING, "%0 only applies to variables with static storage duration and functions", 142, true, false, false, false, 2)
DIAG(warn_attribute_sentinel_named_arguments, CLASS_WARNING, diag::MAP_WARNING, "'sentinel' attribute requires named arguments", 142, true, false, false, false, 2)
DIAG(warn_attribute_sentinel_not_variadic, CLASS_WARNING, diag::MAP_WARNING, "'sentinel' attribute only supported for variadic %select{functions|blocks}0", 142, true, false, false, false, 2)
DIAG(warn_attribute_type_not_supported, CLASS_WARNING, diag::MAP_WARNING, "'%0' attribute argument not supported: %1", 142, true, false, false, false, 2)
DIAG(warn_attribute_unknown_visibility, CLASS_WARNING, diag::MAP_WARNING, "unknown visibility '%0'", 142, true, false, false, false, 2)
DIAG(warn_attribute_void_function_method, CLASS_WARNING, diag::MAP_WARNING, "attribute %0 cannot be applied to %select{functions|Objective-C method}1 without return value", 142, true, false, false, false, 2)
DIAG(warn_attribute_weak_import_invalid_on_definition, CLASS_WARNING, diag::MAP_WARNING, "'weak_import' attribute cannot be specified on a definition", 142, true, false, false, false, 2)
DIAG(warn_attribute_weak_on_field, CLASS_WARNING, diag::MAP_WARNING, "__weak attribute cannot be specified on a field declaration", 142, true, false, false, false, 2)
DIAG(warn_attribute_weak_on_local, CLASS_WARNING, diag::MAP_WARNING, "__weak attribute cannot be specified on an automatic variable when ARC is not enabled", 142, true, false, false, false, 2)
DIAG(warn_attribute_wrong_decl_type, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute only applies to %select{functions|unions|variables and functions|functions and methods|parameters|functions, methods and blocks|functions, methods, and parameters|classes|variables|methods|variables, functions and labels|fields and global variables|structs|variables, functions and tag types|thread-local variables}1", 142, true, false, false, false, 2)
DIAG(warn_auto_implicit_atomic_property, CLASS_WARNING, diag::MAP_IGNORE, "property is assumed atomic when auto-synthesizing the property", 145, true, false, false, false, 2)
DIAG(warn_auto_readonly_iboutlet_property, CLASS_WARNING, diag::MAP_WARNING, "readonly IBOutlet property when auto-synthesized may not work correctly with 'nib' loader", 258, true, false, false, false, 2)
DIAG(warn_auto_synthesizing_protocol_property, CLASS_WARNING, diag::MAP_WARNING, "auto property synthesis will not synthesize property declared in a protocol", 232, true, false, false, false, 2)
DIAG(warn_auto_var_is_id, CLASS_WARNING, diag::MAP_WARNING, "'auto' deduced as 'id' in declaration of %0", 34, true, false, false, false, 2)
DIAG(warn_autosynthesis_property_ivar_match, CLASS_WARNING, diag::MAP_WARNING, "autosynthesized property %0 will use %select{|synthesized}1 instance variable %2, not existing instance variable %3", 218, true, false, false, false, 2)
DIAG(warn_availability_unknown_platform, CLASS_WARNING, diag::MAP_WARNING, "unknown platform %0 in availability macro", 35, true, false, false, false, 2)
DIAG(warn_availability_version_ordering, CLASS_WARNING, diag::MAP_WARNING, "feature cannot be %select{introduced|deprecated|obsoleted}0 in %1 version %2 before it was %select{introduced|deprecated|obsoleted}3 in version %4; attribute ignored", 35, true, false, false, false, 2)
DIAG(warn_bad_function_cast, CLASS_WARNING, diag::MAP_IGNORE, "cast from function call of type %0 to non-matching type %1", 38, true, false, false, false, 2)
DIAG(warn_bad_receiver_type, CLASS_WARNING, diag::MAP_WARNING, "receiver type %0 is not 'id' or interface pointer, consider casting it to 'id'", 260, true, false, false, false, 2)
DIAG(warn_bind_ref_member_to_parameter, CLASS_WARNING, diag::MAP_WARNING, "binding reference member %0 to stack allocated parameter %1", 81, true, false, false, false, 2)
DIAG(warn_bind_ref_member_to_temporary, CLASS_WARNING, diag::MAP_WARNING, "binding reference member %0 to a temporary value", 81, true, false, false, false, 2)
DIAG(warn_bitfield_width_exceeds_type_size, CLASS_WARNING, diag::MAP_WARNING, "size of bit-field %0 (%1 bits) exceeds the size of its type; value will be truncated to %2 bits", 0, true, false, false, false, 2)
DIAG(warn_bitwise_and_in_bitwise_or, CLASS_WARNING, diag::MAP_WARNING, "'&' within '|'", 40, true, false, false, false, 2)
DIAG(warn_bool_switch_condition, CLASS_WARNING, diag::MAP_WARNING, "switch condition has boolean value", 0, true, false, false, false, 2)
DIAG(warn_braces_around_scalar_init, CLASS_WARNING, diag::MAP_WARNING, "braces around scalar initializer", 0, true, false, false, false, 2)
DIAG(warn_builtin_unknown, CLASS_WARNING, diag::MAP_ERROR, "use of unknown builtin %0", 150, true, false, false, false, 2)
DIAG(warn_call_to_pure_virtual_member_function_from_ctor_dtor, CLASS_WARNING, diag::MAP_WARNING, "call to pure virtual member function %0; overrides of %0 in subclasses are not available in the %select{constructor|destructor}1 of %2", 0, true, false, false, false, 2)
DIAG(warn_call_wrong_number_of_arguments, CLASS_WARNING, diag::MAP_WARNING, "too %select{few|many}0 arguments in call to %1", 0, true, false, false, false, 2)
DIAG(warn_cannot_pass_non_pod_arg_to_vararg, CLASS_WARNING, diag::MAP_ERROR, "cannot pass object of %select{non-POD|non-trivial}0 type %1 through variadic %select{function|block|method|constructor}2; call will abort at runtime", 210, true, false, false, false, 2)
DIAG(warn_cannot_resolve_lock, CLASS_WARNING, diag::MAP_IGNORE, "cannot resolve lock expression", 321, true, false, false, false, 2)
DIAG(warn_case_empty_range, CLASS_WARNING, diag::MAP_WARNING, "empty case range specified", 0, true, false, false, false, 2)
DIAG(warn_case_value_overflow, CLASS_WARNING, diag::MAP_WARNING, "overflow converting case value to switch condition type (%0 to %1)", 313, true, false, false, false, 2)
DIAG(warn_cast_align, CLASS_WARNING, diag::MAP_IGNORE, "cast from %0 to %1 increases required alignment from %2 to %3", 62, true, false, false, false, 2)
DIAG(warn_cast_pointer_from_sel, CLASS_WARNING, diag::MAP_WARNING, "cast of type %0 to %1 is deprecated; use sel_getName instead", 63, true, false, false, false, 2)
DIAG(warn_category_method_impl_match, CLASS_WARNING, diag::MAP_WARNING, "category is implementing a method which will also be implemented by its primary class", 231, true, false, false, false, 2)
DIAG(warn_cconv_ignored, CLASS_WARNING, diag::MAP_WARNING, "calling convention %0 ignored for this target", 142, true, false, false, false, 2)
DIAG(warn_cfstring_truncated, CLASS_WARNING, diag::MAP_WARNING, "input conversion stopped due to an input byte that does not belong to the input codeset UTF-8", 3, true, false, false, false, 2)
DIAG(warn_class_method_not_found, CLASS_WARNING, diag::MAP_WARNING, "class method %objcclass0 not found (return type defaults to 'id')", 223, true, false, false, false, 2)
DIAG(warn_collection_expr_type, CLASS_WARNING, diag::MAP_WARNING, "collection expression type %0 may not respond to %1", 0, true, false, false, false, 2)
DIAG(warn_comparison_always, CLASS_WARNING, diag::MAP_WARNING, "%select{self-|array }0comparison always evaluates to %select{false|true|a constant}1", 317, true, false, false, false, 2)
DIAG(warn_comparison_of_mixed_enum_types, CLASS_WARNING, diag::MAP_WARNING, "comparison of two values with different enumeration types%diff{ ($ and $)|}0,1", 114, true, false, false, false, 2)
DIAG(warn_condition_is_assignment, CLASS_WARNING, diag::MAP_WARNING, "using the result of an assignment as a condition without parentheses", 248, true, false, false, false, 2)
DIAG(warn_condition_is_idiomatic_assignment, CLASS_WARNING, diag::MAP_IGNORE, "using the result of an assignment as a condition without parentheses", 141, true, false, false, false, 2)
DIAG(warn_conflicting_overriding_param_modifiers, CLASS_WARNING, diag::MAP_IGNORE, "conflicting distributed object modifiers on parameter type in declaration of %0", 245, true, false, false, false, 2)
DIAG(warn_conflicting_overriding_param_types, CLASS_WARNING, diag::MAP_IGNORE, "conflicting parameter types in declaration of %0%diff{: $ vs $|}1,2", 245, true, false, false, false, 2)
DIAG(warn_conflicting_overriding_ret_type_modifiers, CLASS_WARNING, diag::MAP_IGNORE, "conflicting distributed object modifiers on return type in declaration of %0", 245, true, false, false, false, 2)
DIAG(warn_conflicting_overriding_ret_types, CLASS_WARNING, diag::MAP_IGNORE, "conflicting return type in declaration of %0%diff{: $ vs $|}1,2", 245, true, false, false, false, 2)
DIAG(warn_conflicting_overriding_variadic, CLASS_WARNING, diag::MAP_IGNORE, "conflicting variadic declaration of method and its implementation", 245, true, false, false, false, 2)
DIAG(warn_conflicting_param_modifiers, CLASS_WARNING, diag::MAP_WARNING, "conflicting distributed object modifiers on parameter type in implementation of %0", 97, true, false, false, false, 2)
DIAG(warn_conflicting_param_types, CLASS_WARNING, diag::MAP_WARNING, "conflicting parameter types in implementation of %0%diff{: $ vs $|}1,2", 189, true, false, false, false, 2)
DIAG(warn_conflicting_ret_type_modifiers, CLASS_WARNING, diag::MAP_WARNING, "conflicting distributed object modifiers on return type in implementation of %0", 97, true, false, false, false, 2)
DIAG(warn_conflicting_ret_types, CLASS_WARNING, diag::MAP_WARNING, "conflicting return type in implementation of %0%diff{: $ vs $|}1,2", 190, true, false, false, false, 2)
DIAG(warn_conflicting_variadic, CLASS_WARNING, diag::MAP_WARNING, "conflicting variadic declaration of method and its implementation", 0, true, false, false, false, 2)
DIAG(warn_conv_to_base_not_used, CLASS_WARNING, diag::MAP_WARNING, "conversion function converting %0 to its base class %1 will never be used", 0, true, false, false, false, 2)
DIAG(warn_conv_to_self_not_used, CLASS_WARNING, diag::MAP_WARNING, "conversion function converting %0 to itself will never be used", 0, true, false, false, false, 2)
DIAG(warn_conv_to_void_not_used, CLASS_WARNING, diag::MAP_WARNING, "conversion function converting %0 to %1 will never be used", 0, true, false, false, false, 2)
DIAG(warn_cxx98_compat_array_size_conversion, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion from array size expression of type %0 to %select{integral|enumeration}1 type %2 is incompatible with C++98", 58, true, false, false, false, 2)
DIAG(warn_cxx98_compat_auto_type_specifier, CLASS_WARNING, diag::MAP_IGNORE, "'auto' type specifier is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_cast_fn_obj, CLASS_WARNING, diag::MAP_IGNORE, "cast between pointer-to-function and pointer-to-object is incompatible with C++98", 58, true, false, false, false, 2)
DIAG(warn_cxx98_compat_constexpr, CLASS_WARNING, diag::MAP_IGNORE, "'constexpr' specifier is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_ctor_list_init, CLASS_WARNING, diag::MAP_IGNORE, "constructor call from initializer list is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_delegating_ctor, CLASS_WARNING, diag::MAP_IGNORE, "delegating constructors are incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_empty_scalar_initializer, CLASS_WARNING, diag::MAP_IGNORE, "scalar initialized from empty initializer list is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_enum_friend, CLASS_WARNING, diag::MAP_IGNORE, "befriending enumeration type %0 is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_enum_nested_name_spec, CLASS_WARNING, diag::MAP_IGNORE, "enumeration type in nested name specifier is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_explicit_conversion_functions, CLASS_WARNING, diag::MAP_IGNORE, "explicit conversion functions are incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_explicit_instantiation_after_specialization, CLASS_WARNING, diag::MAP_IGNORE, "explicit instantiation of %0 that occurs after an explicit specialization is incompatible with C++98", 58, true, false, false, false, 2)
DIAG(warn_cxx98_compat_friend_is_member, CLASS_WARNING, diag::MAP_IGNORE, "friend declaration naming a member of the declaring class is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_friend_redefinition, CLASS_WARNING, diag::MAP_IGNORE, "friend function %0 would be implicitly redefined in C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_goto_into_protected_scope, CLASS_WARNING, diag::MAP_IGNORE, "goto would jump into protected scope in C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_indirect_goto_in_protected_scope, CLASS_WARNING, diag::MAP_IGNORE, "indirect goto might cross protected scopes in C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_initializer_list_init, CLASS_WARNING, diag::MAP_IGNORE, "initialization of initializer_list object is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_non_static_member_use, CLASS_WARNING, diag::MAP_IGNORE, "use of non-static data member %0 in an unevaluated context is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_nonclass_type_friend, CLASS_WARNING, diag::MAP_IGNORE, "non-class friend type %0 is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_nontrivial_union_or_anon_struct_member, CLASS_WARNING, diag::MAP_IGNORE, "%select{anonymous struct|union}0 member %1 with a non-trivial %select{constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}2 is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_pass_non_pod_arg_to_vararg, CLASS_WARNING, diag::MAP_IGNORE, "passing object of trivial but non-POD type %0 through variadic %select{function|block|method|constructor}1 is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_reference_list_init, CLASS_WARNING, diag::MAP_IGNORE, "reference initialized from initializer list is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_sfinae_access_control, CLASS_WARNING, diag::MAP_IGNORE, "substitution failure due to access control is incompatible with C++98", 55, false, false, false, false, 2)
DIAG(warn_cxx98_compat_static_data_member_in_union, CLASS_WARNING, diag::MAP_IGNORE, "static data member %0 in union is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_switch_into_protected_scope, CLASS_WARNING, diag::MAP_IGNORE, "switch case would be in a protected scope in C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_temp_copy, CLASS_WARNING, diag::MAP_IGNORE, "%select{copying variable|copying parameter|returning object|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element}1 of type %2 when binding a reference to a temporary would %select{invoke an inaccessible constructor|find no viable constructor|find ambiguous constructors|invoke a deleted constructor}0 in C++98", 56, true, false, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_extra_parens, CLASS_WARNING, diag::MAP_IGNORE, "redundant parentheses surrounding address non-type template argument are incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_local_type, CLASS_WARNING, diag::MAP_IGNORE, "local type %0 as template argument is incompatible with C++98", 57, true, false, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_null, CLASS_WARNING, diag::MAP_IGNORE, "use of null pointer as non-type template argument is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_object_internal, CLASS_WARNING, diag::MAP_IGNORE, "non-type template argument referring to %select{function|object}0 %1 with internal linkage is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_unnamed_type, CLASS_WARNING, diag::MAP_IGNORE, "unnamed type as template argument is incompatible with C++98", 59, true, false, false, false, 2)
DIAG(warn_cxx98_compat_template_outside_of_template, CLASS_WARNING, diag::MAP_IGNORE, "use of 'template' keyword outside of a template is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_template_parameter_default_in_function_template, CLASS_WARNING, diag::MAP_IGNORE, "default template arguments for a function template are incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_template_spec_decl_out_of_scope, CLASS_WARNING, diag::MAP_IGNORE, "%select{class template|class template partial|function template|member function|static data member|member class|member enumeration}0 specialization of %1 outside namespace %2 is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_typename_outside_of_template, CLASS_WARNING, diag::MAP_IGNORE, "use of 'typename' outside of a template is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_unelaborated_friend_type, CLASS_WARNING, diag::MAP_IGNORE, "befriending %1 without '%select{struct|interface|union|class|enum}0' keyword is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_cxx98_compat_unicode_type, CLASS_WARNING, diag::MAP_IGNORE, "'%0' type specifier is incompatible with C++98", 55, true, false, false, false, 2)
DIAG(warn_dangling_std_initializer_list, CLASS_WARNING, diag::MAP_WARNING, "array backing the initializer list will be destroyed at the end of %select{the full-expression|the constructor}0", 82, true, false, false, false, 2)
DIAG(warn_decl_in_param_list, CLASS_WARNING, diag::MAP_WARNING, "declaration of %0 will not be visible outside of this function", 363, true, false, false, false, 2)
DIAG(warn_decl_shadow, CLASS_WARNING, diag::MAP_IGNORE, "declaration shadows a %select{local variable|variable in %2|static data member of %2|field of %2}1", 278, true, false, false, false, 2)
DIAG(warn_declspec_attribute_ignored, CLASS_WARNING, diag::MAP_WARNING, "attribute %0 is ignored, place it after \"%select{class|struct|union|interface|enum}1\" to apply attribute to type declaration", 142, true, false, false, false, 2)
DIAG(warn_def_missing_case1, CLASS_WARNING, diag::MAP_IGNORE, "enumeration value %0 not explicitly handled in switch", 315, true, false, false, false, 2)
DIAG(warn_def_missing_case2, CLASS_WARNING, diag::MAP_IGNORE, "enumeration values %0 and %1 not explicitly handled in switch", 315, true, false, false, false, 2)
DIAG(warn_def_missing_case3, CLASS_WARNING, diag::MAP_IGNORE, "enumeration values %0, %1, and %2 not explicitly handled in switch", 315, true, false, false, false, 2)
DIAG(warn_def_missing_cases, CLASS_WARNING, diag::MAP_IGNORE, "%0 enumeration values not explicitly handled in switch: %1, %2, %3...", 315, true, false, false, false, 2)
DIAG(warn_default_arg_makes_ctor_special, CLASS_WARNING, diag::MAP_WARNING, "addition of default argument on redeclaration makes this constructor a %select{default|copy|move}0 constructor", 84, true, false, false, false, 2)
DIAG(warn_default_atomic_custom_getter_setter, CLASS_WARNING, diag::MAP_IGNORE, "atomic by default property %0 has a user defined %select{getter|setter}1 (property should be marked 'atomic' if this is intended)", 79, true, false, false, false, 2)
DIAG(warn_delegating_ctor_cycle, CLASS_WARNING, diag::MAP_ERROR, "constructor for %0 creates a delegation cycle", 85, true, false, false, false, 2)
DIAG(warn_delete_abstract_non_virtual_dtor, CLASS_WARNING, diag::MAP_WARNING, "delete called on %0 that is abstract but has non-virtual destructor", 87, true, false, false, false, 2)
DIAG(warn_delete_array_type, CLASS_WARNING, diag::MAP_WARNING, "'delete' applied to a pointer-to-array type %0 treated as delete[]", 0, true, false, false, false, 2)
DIAG(warn_delete_incomplete, CLASS_WARNING, diag::MAP_WARNING, "deleting pointer to incomplete type %0 may cause undefined behaviour", 86, true, false, false, false, 2)
DIAG(warn_delete_non_virtual_dtor, CLASS_WARNING, diag::MAP_IGNORE, "delete called on %0 that has virtual functions but non-virtual destructor", 87, true, false, false, false, 2)
DIAG(warn_deprecated, CLASS_WARNING, diag::MAP_WARNING, "%0 is deprecated", 89, true, false, false, false, 19)
DIAG(warn_deprecated_def, CLASS_WARNING, diag::MAP_IGNORE, "Implementing deprecated %select{method|class|category}0", 90, true, false, false, false, 2)
DIAG(warn_deprecated_fwdclass_message, CLASS_WARNING, diag::MAP_WARNING, "%0 maybe deprecated because receiver type is unknown", 89, true, false, false, false, 19)
DIAG(warn_deprecated_message, CLASS_WARNING, diag::MAP_WARNING, "%0 is deprecated: %1", 89, true, false, false, false, 19)
DIAG(warn_deprecated_string_literal_conversion, CLASS_WARNING, diag::MAP_WARNING, "conversion from string literal to %0 is deprecated", 92, true, false, false, false, 2)
DIAG(warn_direct_ivar_access, CLASS_WARNING, diag::MAP_IGNORE, "instance variable %0 is being directly accessed", 93, true, false, false, false, 2)
DIAG(warn_division_by_zero, CLASS_WARNING, diag::MAP_WARNING, "division by zero is undefined", 99, true, false, false, false, 2)
DIAG(warn_double_const_requires_fp64, CLASS_WARNING, diag::MAP_WARNING, "double precision constant requires cl_khr_fp64, casting to single precision", 0, true, false, false, false, 2)
DIAG(warn_double_lock, CLASS_WARNING, diag::MAP_IGNORE, "locking '%0' that is already locked", 321, true, false, false, false, 2)
DIAG(warn_dup_category_def, CLASS_WARNING, diag::MAP_WARNING, "duplicate definition of category %1 on interface %0", 0, true, false, false, false, 2)
DIAG(warn_duplicate_attribute, CLASS_WARNING, diag::MAP_WARNING, "attribute %0 is already applied with different parameters", 142, true, false, false, false, 2)
DIAG(warn_duplicate_method_decl, CLASS_WARNING, diag::MAP_IGNORE, "multiple declarations of method %0 found and ignored", 107, true, false, false, false, 2)
DIAG(warn_duplicate_protocol_def, CLASS_WARNING, diag::MAP_WARNING, "duplicate protocol definition of %0 is ignored", 0, true, false, false, false, 2)
DIAG(warn_dyn_class_memaccess, CLASS_WARNING, diag::MAP_WARNING, "%select{destination for|source of|first operand of|second operand of}0 this %1 call is a pointer to dynamic class %2; vtable pointer will be %select{overwritten|copied|moved|compared}3", 108, true, false, false, false, 2)
DIAG(warn_empty_for_body, CLASS_WARNING, diag::MAP_WARNING, "for loop has empty body", 111, true, false, false, false, 2)
DIAG(warn_empty_format_string, CLASS_WARNING, diag::MAP_WARNING, "format string is empty", 132, true, false, false, false, 20)
DIAG(warn_empty_if_body, CLASS_WARNING, diag::MAP_WARNING, "if statement has empty body", 111, true, false, false, false, 2)
DIAG(warn_empty_parens_are_function_decl, CLASS_WARNING, diag::MAP_WARNING, "empty parentheses interpreted as a function declaration", 362, true, false, false, false, 2)
DIAG(warn_empty_range_based_for_body, CLASS_WARNING, diag::MAP_WARNING, "range-based for loop has empty body", 111, true, false, false, false, 2)
DIAG(warn_empty_switch_body, CLASS_WARNING, diag::MAP_WARNING, "switch statement has empty body", 111, true, false, false, false, 2)
DIAG(warn_empty_while_body, CLASS_WARNING, diag::MAP_WARNING, "while loop has empty body", 111, true, false, false, false, 2)
DIAG(warn_enum_too_large, CLASS_WARNING, diag::MAP_WARNING, "enumeration values exceed range of largest integer", 0, true, false, false, false, 2)
DIAG(warn_enum_value_overflow, CLASS_WARNING, diag::MAP_WARNING, "overflow in enumeration value", 0, true, false, false, false, 2)
DIAG(warn_enumerator_too_large, CLASS_WARNING, diag::MAP_WARNING, "enumerator value %0 is not representable in the largest integer type", 0, true, false, false, false, 2)
DIAG(warn_equality_with_extra_parens, CLASS_WARNING, diag::MAP_WARNING, "equality comparison with extraneous parentheses", 249, true, false, false, false, 2)
DIAG(warn_exception_caught_by_earlier_handler, CLASS_WARNING, diag::MAP_WARNING, "exception of type %0 will be caught by earlier handler", 0, true, false, false, false, 2)
DIAG(warn_excess_initializers, CLASS_EXTENSION, diag::MAP_WARNING, "excess elements in %select{array|vector|scalar|union|struct}0 initializer", 0, true, false, false, false, 2)
DIAG(warn_excess_initializers_in_char_array_initializer, CLASS_EXTENSION, diag::MAP_WARNING, "excess elements in char array initializer", 0, true, false, false, false, 2)
DIAG(warn_exit_time_destructor, CLASS_WARNING, diag::MAP_IGNORE, "declaration requires an exit-time destructor", 116, true, false, false, false, 2)
DIAG(warn_expecting_lock_held_on_loop, CLASS_WARNING, diag::MAP_IGNORE, "expecting mutex '%0' to be locked at start of each loop", 321, true, false, false, false, 2)
DIAG(warn_expecting_locked, CLASS_WARNING, diag::MAP_IGNORE, "expecting mutex '%0' to be locked at the end of function", 321, true, false, false, false, 2)
DIAG(warn_explicit_instantiation_inline_0x, CLASS_WARNING, diag::MAP_IGNORE, "explicit instantiation cannot be 'inline'", 49, true, false, false, false, 2)
DIAG(warn_explicit_instantiation_must_be_global_0x, CLASS_WARNING, diag::MAP_IGNORE, "explicit instantiation of %0 must occur at global scope", 49, true, false, false, false, 2)
DIAG(warn_explicit_instantiation_out_of_scope_0x, CLASS_WARNING, diag::MAP_IGNORE, "explicit instantiation of %0 not in a namespace enclosing %1", 49, true, false, false, false, 2)
DIAG(warn_explicit_instantiation_unqualified_wrong_namespace_0x, CLASS_WARNING, diag::MAP_IGNORE, "explicit instantiation of %q0 must occur in namespace %1", 49, true, false, false, false, 2)
DIAG(warn_extern_init, CLASS_WARNING, diag::MAP_WARNING, "'extern' variable has an initializer", 119, true, false, false, false, 2)
DIAG(warn_falloff_nonvoid_function, CLASS_WARNING, diag::MAP_WARNING, "control reaches end of non-void function", 268, true, false, false, false, 2)
DIAG(warn_falloff_nonvoid_lambda, CLASS_WARNING, diag::MAP_WARNING, "control reaches end of non-void lambda", 268, true, false, false, false, 3)
DIAG(warn_falloff_noreturn_function, CLASS_WARNING, diag::MAP_WARNING, "function declared 'noreturn' should not return", 166, true, false, false, false, 2)
DIAG(warn_fallthrough_attr_invalid_placement, CLASS_WARNING, diag::MAP_WARNING, "fallthrough annotation does not directly precede switch label", 148, true, false, false, false, 2)
DIAG(warn_fallthrough_attr_unreachable, CLASS_WARNING, diag::MAP_WARNING, "fallthrough annotation in unreachable code", 148, true, false, false, false, 2)
DIAG(warn_field_is_uninit, CLASS_WARNING, diag::MAP_WARNING, "field %0 is uninitialized when used here", 334, true, false, false, false, 2)
DIAG(warn_float_overflow, CLASS_WARNING, diag::MAP_WARNING, "magnitude of floating-point constant too large for type %0; maximum is %1", 177, true, false, false, false, 2)
DIAG(warn_float_underflow, CLASS_WARNING, diag::MAP_WARNING, "magnitude of floating-point constant too small for type %0; minimum is %1", 177, true, false, false, false, 2)
DIAG(warn_floatingpoint_eq, CLASS_WARNING, diag::MAP_IGNORE, "comparing floating point with == or != is unsafe", 124, true, false, false, false, 2)
DIAG(warn_format_argument_needs_cast, CLASS_WARNING, diag::MAP_WARNING, "values of type '%0' should not be used as format arguments; add an explicit cast to %1 instead", 125, true, false, false, false, 20)
DIAG(warn_format_invalid_conversion, CLASS_WARNING, diag::MAP_WARNING, "invalid conversion specifier '%0'", 127, true, false, false, false, 20)
DIAG(warn_format_invalid_positional_specifier, CLASS_WARNING, diag::MAP_WARNING, "invalid position specified for %select{field width|field precision}0", 125, true, false, false, false, 20)
DIAG(warn_format_mix_positional_nonpositional_args, CLASS_WARNING, diag::MAP_WARNING, "cannot mix positional and non-positional arguments in format string", 125, true, false, false, false, 20)
DIAG(warn_format_non_standard, CLASS_EXTENSION, diag::MAP_IGNORE, "'%0' %select{length modifier|conversion specifier}1 is not supported by ISO C", 128, true, false, false, false, 2)
DIAG(warn_format_non_standard_conversion_spec, CLASS_EXTENSION, diag::MAP_IGNORE, "using length modifier '%0' with conversion specifier '%1' is not supported by ISO C", 128, true, false, false, false, 2)
DIAG(warn_format_non_standard_positional_arg, CLASS_EXTENSION, diag::MAP_IGNORE, "positional arguments are not supported by ISO C", 128, true, false, false, false, 2)
DIAG(warn_format_nonliteral, CLASS_WARNING, diag::MAP_IGNORE, "format string is not a string literal", 129, true, false, false, false, 2)
DIAG(warn_format_nonliteral_noargs, CLASS_WARNING, diag::MAP_WARNING, "format string is not a string literal (potentially insecure)", 130, true, false, false, false, 20)
DIAG(warn_format_nonsensical_length, CLASS_WARNING, diag::MAP_WARNING, "length modifier '%0' results in undefined behavior or no effect with '%1' conversion specifier", 125, true, false, false, false, 20)
DIAG(warn_format_string_is_wide_literal, CLASS_WARNING, diag::MAP_WARNING, "format string should not be a wide string", 125, true, false, false, false, 20)
DIAG(warn_format_zero_positional_specifier, CLASS_WARNING, diag::MAP_WARNING, "position arguments in format strings start counting at 1 (not 0)", 125, true, false, false, false, 20)
DIAG(warn_forward_class_redefinition, CLASS_WARNING, diag::MAP_WARNING, "redefinition of forward class %0 of a typedef name of an object type is ignored", 220, true, false, false, false, 2)
DIAG(warn_found_via_dependent_bases_lookup, CLASS_EXTENSION, diag::MAP_WARNING, "use of identifier %0 found via unqualified lookup into dependent bases of class templates is a Microsoft extension", 186, true, false, false, false, 2)
DIAG(warn_fun_excludes_mutex, CLASS_WARNING, diag::MAP_IGNORE, "cannot call function '%0' while mutex '%1' is locked", 321, true, false, false, false, 2)
DIAG(warn_fun_requires_lock, CLASS_WARNING, diag::MAP_IGNORE, "calling function '%0' requires %select{shared|exclusive}2 lock on '%1'", 321, true, false, false, false, 2)
DIAG(warn_fun_requires_lock_precise, CLASS_WARNING, diag::MAP_IGNORE, "calling function '%0' requires %select{shared|exclusive}2 lock on '%1'", 323, true, false, false, false, 2)
DIAG(warn_function_attribute_wrong_type, CLASS_WARNING, diag::MAP_WARNING, "'%0' only applies to function types; type here is %1", 142, true, false, false, false, 2)
DIAG(warn_gc_attribute_weak_on_local, CLASS_WARNING, diag::MAP_WARNING, "Objective-C GC does not allow weak variables on the stack", 142, true, false, false, false, 2)
DIAG(warn_global_constructor, CLASS_WARNING, diag::MAP_IGNORE, "declaration requires a global constructor", 136, true, false, false, false, 2)
DIAG(warn_global_destructor, CLASS_WARNING, diag::MAP_IGNORE, "declaration requires a global destructor", 136, true, false, false, false, 2)
DIAG(warn_gnu_inline_attribute_requires_inline, CLASS_WARNING, diag::MAP_WARNING, "'gnu_inline' attribute requires function to be marked 'inline', attribute ignored", 142, true, false, false, false, 2)
DIAG(warn_goto_into_protected_scope, CLASS_EXTENSION, diag::MAP_WARNING, "goto into protected scope", 186, true, false, false, false, 2)
DIAG(warn_iboutlet_object_type, CLASS_WARNING, diag::MAP_WARNING, "%select{instance variable|property}2 with %0 attribute must be an object type (invalid %1)", 165, true, false, false, false, 2)
DIAG(warn_identity_field_assign, CLASS_WARNING, diag::MAP_WARNING, "assigning %select{field|instance variable}0 to itself", 273, true, false, false, false, 2)
DIAG(warn_illegal_constant_array_size, CLASS_EXTENSION, diag::MAP_IGNORE, "size of static array must be an integer constant expression", 250, true, false, false, false, 2)
DIAG(warn_impcast_bitfield_precision_constant, CLASS_WARNING, diag::MAP_WARNING, "implicit truncation from %2 to bitfield changes value from %0 to %1", 73, true, false, false, false, 14)
DIAG(warn_impcast_bool_to_null_pointer, CLASS_WARNING, diag::MAP_WARNING, "initialization of pointer of type %0 to null from a constant boolean expression", 41, true, false, false, false, 14)
DIAG(warn_impcast_complex_scalar, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion discards imaginary component: %0 to %1", 75, true, false, false, false, 2)
DIAG(warn_impcast_different_enum_types, CLASS_WARNING, diag::MAP_WARNING, "implicit conversion from enumeration type %0 to different enumeration type %1", 115, true, false, false, false, 14)
DIAG(warn_impcast_float_integer, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion turns floating-point number into integer: %0 to %1", 75, true, false, false, false, 2)
DIAG(warn_impcast_float_precision, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion loses floating-point precision: %0 to %1", 75, true, false, false, false, 2)
DIAG(warn_impcast_floating_point_to_bool, CLASS_WARNING, diag::MAP_WARNING, "implicit conversion turns floating-point number into bool: %0 to %1", 146, true, false, false, false, 2)
DIAG(warn_impcast_function_to_bool, CLASS_WARNING, diag::MAP_WARNING, "address of function %q0 will always evaluate to 'true'", 41, true, false, false, false, 14)
DIAG(warn_impcast_integer_64_32, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion loses integer precision: %0 to %1", 285, true, false, false, false, 14)
DIAG(warn_impcast_integer_precision, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion loses integer precision: %0 to %1", 75, true, false, false, false, 2)
DIAG(warn_impcast_integer_precision_constant, CLASS_WARNING, diag::MAP_WARNING, "implicit conversion from %2 to %3 changes value from %0 to %1", 73, true, false, false, false, 14)
DIAG(warn_impcast_integer_sign, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion changes signedness: %0 to %1", 287, true, false, false, false, 14)
DIAG(warn_impcast_integer_sign_conditional, CLASS_WARNING, diag::MAP_IGNORE, "operand of ? changes signedness: %0 to %1", 287, true, false, false, false, 14)
DIAG(warn_impcast_literal_float_to_integer, CLASS_WARNING, diag::MAP_WARNING, "implicit conversion from %0 to %1 changes value from %2 to %3", 176, true, false, false, false, 14)
DIAG(warn_impcast_null_pointer_to_integer, CLASS_WARNING, diag::MAP_WARNING, "implicit conversion of NULL constant to %0", 216, true, false, false, false, 14)
DIAG(warn_impcast_string_literal_to_bool, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion turns string literal into bool: %0 to %1", 308, true, false, false, false, 14)
DIAG(warn_impcast_vector_scalar, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion turns vector to scalar: %0 to %1", 75, true, false, false, false, 2)
DIAG(warn_implements_nscopying, CLASS_WARNING, diag::MAP_WARNING, "default assign attribute on property %0 which implements NSCopying protocol is not appropriate with -fobjc-gc[-only]", 0, true, false, false, false, 2)
DIAG(warn_implicit_atomic_property, CLASS_WARNING, diag::MAP_IGNORE, "property is assumed atomic by default", 145, true, false, false, false, 2)
DIAG(warn_implicit_decl_requires_setjmp, CLASS_WARNING, diag::MAP_WARNING, "declaration of built-in function '%0' requires inclusion of the header <setjmp.h>", 44, true, false, false, false, 2)
DIAG(warn_implicit_decl_requires_stdio, CLASS_WARNING, diag::MAP_WARNING, "declaration of built-in function '%0' requires inclusion of the header <stdio.h>", 44, true, false, false, false, 2)
DIAG(warn_implicit_decl_requires_ucontext, CLASS_WARNING, diag::MAP_WARNING, "declaration of built-in function '%0' requires inclusion of the header <ucontext.h>", 44, true, false, false, false, 2)
DIAG(warn_implicit_function_decl, CLASS_WARNING, diag::MAP_IGNORE, "implicit declaration of function %0", 150, true, false, false, false, 2)
DIAG(warn_implicitly_retains_self, CLASS_WARNING, diag::MAP_IGNORE, "block implicitly retains 'self'; explicitly mention 'self' to indicate this is intended behavior", 152, true, false, false, false, 2)
DIAG(warn_incompatible_qualified_id, CLASS_WARNING, diag::MAP_WARNING, "%select{%diff{assigning to $ from incompatible type $|assigning to type from incompatible type}0,1|%diff{passing $ to parameter of incompatible type $|passing type to parameter of incompatible type}0,1|%diff{returning $ from a function with incompatible result type $|returning type from a function with incompatible result type}0,1|%diff{converting $ to incompatible type $|converting type to incompatible type}0,1|%diff{initializing $ with an expression of incompatible type $|initializing type with an expression of incompatible type}0,1|%diff{sending $ to parameter of incompatible type $|sending type to parameter of incompatible type}0,1|%diff{casting $ to incompatible type $|casting type to incompatible type}0,1}2", 0, true, false, false, false, 2)
DIAG(warn_incompatible_vectors, CLASS_WARNING, diag::MAP_IGNORE, "incompatible vector types %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2", 360, true, false, false, false, 2)
DIAG(warn_incomplete_impl, CLASS_WARNING, diag::MAP_WARNING, "incomplete implementation", 156, true, false, false, false, 2)
DIAG(warn_increment_bool, CLASS_WARNING, diag::MAP_WARNING, "incrementing expression of type bool is deprecated", 88, true, false, false, false, 19)
DIAG(warn_indirection_through_null, CLASS_WARNING, diag::MAP_WARNING, "indirection of non-volatile null pointer will be deleted, not trap", 217, true, false, false, false, 2)
DIAG(warn_init_list_constant_narrowing, CLASS_WARNING, diag::MAP_IGNORE, "constant expression evaluates to %0 which cannot be narrowed to type %1 in C++11", 54, true, false, false, false, 2)
DIAG(warn_init_list_type_narrowing, CLASS_WARNING, diag::MAP_IGNORE, "type %0 cannot be narrowed to %1 in initializer list in C++11", 54, true, false, false, false, 2)
DIAG(warn_init_list_variable_narrowing, CLASS_WARNING, diag::MAP_IGNORE, "non-constant-expression cannot be narrowed from type %0 to %1 in initializer list in C++11", 54, true, false, false, false, 2)
DIAG(warn_init_ptr_member_to_parameter_addr, CLASS_WARNING, diag::MAP_WARNING, "initializing pointer member %0 with the stack address of parameter %1", 81, true, false, false, false, 2)
DIAG(warn_initializer_out_of_order, CLASS_WARNING, diag::MAP_IGNORE, "%select{field|base class}0 %1 will be initialized after %select{field|base}2 %3", 264, true, false, false, false, 2)
DIAG(warn_initializer_overrides, CLASS_WARNING, diag::MAP_WARNING, "initializer overrides prior initialization of this subobject", 159, true, false, false, false, 2)
DIAG(warn_initializer_string_for_char_array_too_long, CLASS_EXTENSION, diag::MAP_WARNING, "initializer-string for char array is too long", 0, true, false, false, false, 2)
DIAG(warn_inline_namespace_reopened_noninline, CLASS_WARNING, diag::MAP_WARNING, "inline namespace cannot be reopened as a non-inline namespace", 0, true, false, false, false, 2)
DIAG(warn_inst_method_not_found, CLASS_WARNING, diag::MAP_WARNING, "instance method %objcinstance0 not found (return type defaults to 'id')", 223, true, false, false, false, 2)
DIAG(warn_instance_method_on_class_found, CLASS_WARNING, diag::MAP_WARNING, "instance method %0 found instead of class method %1", 223, true, false, false, false, 2)
DIAG(warn_int_to_pointer_cast, CLASS_WARNING, diag::MAP_WARNING, "cast to %1 from smaller integer type %0", 163, true, false, false, false, 2)
DIAG(warn_internal_in_extern_inline, CLASS_EXTENSION, diag::MAP_WARNING, "static %select{function|variable}0 %1 is used in an inline function with external linkage", 293, true, false, false, false, 2)
DIAG(warn_invalid_asm_cast_lvalue, CLASS_WARNING, diag::MAP_WARNING, "invalid use of a cast in an inline asm context requiring an l-value: accepted due to -fheinous-gnu-extensions, but clang may remove support for this in the future", 0, true, false, false, false, 11)
DIAG(warn_ivar_use_hidden, CLASS_WARNING, diag::MAP_WARNING, "local declaration of %0 hides instance variable", 279, true, false, false, false, 2)
DIAG(warn_ivars_in_interface, CLASS_WARNING, diag::MAP_IGNORE, "declaration of instance variables in the interface is deprecated", 221, true, false, false, false, 2)
DIAG(warn_lock_exclusive_and_shared, CLASS_WARNING, diag::MAP_IGNORE, "mutex '%0' is locked exclusively and shared in the same scope", 321, true, false, false, false, 2)
DIAG(warn_lock_some_predecessors, CLASS_WARNING, diag::MAP_IGNORE, "mutex '%0' is not locked on every path through here", 321, true, false, false, false, 2)
DIAG(warn_logical_and_in_logical_or, CLASS_WARNING, diag::MAP_WARNING, "'&&' within '||'", 179, true, false, false, false, 2)
DIAG(warn_logical_instead_of_bitwise, CLASS_WARNING, diag::MAP_WARNING, "use of logical '%0' with constant operand", 74, true, false, false, false, 2)
DIAG(warn_lunsigned_always_true_comparison, CLASS_WARNING, diag::MAP_WARNING, "comparison of unsigned%select{| enum}2 expression %0 is always %1", 317, true, false, false, false, 2)
DIAG(warn_main_one_arg, CLASS_WARNING, diag::MAP_WARNING, "only one parameter on 'main' declaration", 182, true, false, false, false, 2)
DIAG(warn_many_braces_around_scalar_init, CLASS_EXTENSION, diag::MAP_WARNING, "too many braces around scalar initializer", 0, true, false, false, false, 2)
DIAG(warn_maybe_falloff_nonvoid_function, CLASS_WARNING, diag::MAP_WARNING, "control may reach end of non-void function", 268, true, false, false, false, 2)
DIAG(warn_maybe_falloff_nonvoid_lambda, CLASS_WARNING, diag::MAP_WARNING, "control may reach end of non-void lambda", 268, true, false, false, false, 3)
DIAG(warn_maybe_uninit_var, CLASS_WARNING, diag::MAP_IGNORE, "variable %0 may be uninitialized when %select{used here|captured by block}1", 72, true, false, false, false, 2)
DIAG(warn_maynot_respond, CLASS_WARNING, diag::MAP_WARNING, "%0 may not respond to %1", 0, true, false, false, false, 2)
DIAG(warn_member_extra_qualification, CLASS_WARNING, diag::MAP_WARNING, "extra qualification on member %0", 186, true, false, false, false, 2)
DIAG(warn_mismatched_availability, CLASS_WARNING, diag::MAP_WARNING, "availability does not match previous declaration", 35, true, false, false, false, 2)
DIAG(warn_mismatched_exception_spec, CLASS_EXTENSION, diag::MAP_WARNING, "exception specification in declaration does not match previous declaration", 0, true, false, false, false, 2)
DIAG(warn_mismatched_section, CLASS_WARNING, diag::MAP_WARNING, "section does not match previous declaration", 270, true, false, false, false, 2)
DIAG(warn_missing_braces, CLASS_WARNING, diag::MAP_IGNORE, "suggest braces around initialization of subobject", 192, true, false, false, false, 2)
DIAG(warn_missing_case1, CLASS_WARNING, diag::MAP_WARNING, "enumeration value %0 not handled in switch", 313, true, false, false, false, 2)
DIAG(warn_missing_case2, CLASS_WARNING, diag::MAP_WARNING, "enumeration values %0 and %1 not handled in switch", 313, true, false, false, false, 2)
DIAG(warn_missing_case3, CLASS_WARNING, diag::MAP_WARNING, "enumeration values %0, %1, and %2 not handled in switch", 313, true, false, false, false, 2)
DIAG(warn_missing_case_for_condition, CLASS_WARNING, diag::MAP_WARNING, "no case matching constant switch condition '%0'", 0, true, false, false, false, 2)
DIAG(warn_missing_cases, CLASS_WARNING, diag::MAP_WARNING, "%0 enumeration values not handled in switch: %1, %2, %3...", 313, true, false, false, false, 2)
DIAG(warn_missing_exception_specification, CLASS_WARNING, diag::MAP_WARNING, "%0 is missing exception specification '%1'", 0, true, false, false, false, 2)
DIAG(warn_missing_explicit_synthesis, CLASS_WARNING, diag::MAP_IGNORE, "auto property synthesis is synthesizing property not explicitly synthesized", 224, true, false, false, false, 2)
DIAG(warn_missing_field_initializers, CLASS_WARNING, diag::MAP_IGNORE, "missing field '%0' initializer", 194, true, false, false, false, 2)
DIAG(warn_missing_format_string, CLASS_WARNING, diag::MAP_WARNING, "format string missing", 125, true, false, false, false, 20)
DIAG(warn_missing_method_return_type, CLASS_WARNING, diag::MAP_IGNORE, "method has no return type specified; defaults to 'id'", 197, true, false, false, false, 2)
DIAG(warn_missing_prototype, CLASS_WARNING, diag::MAP_IGNORE, "no previous prototype for function %0", 199, true, false, false, false, 2)
DIAG(warn_missing_sentinel, CLASS_WARNING, diag::MAP_WARNING, "missing sentinel in %select{function call|method dispatch|block call}0", 275, true, false, false, false, 2)
DIAG(warn_missing_variable_declarations, CLASS_WARNING, diag::MAP_IGNORE, "no previous extern declaration for non-static variable %0", 201, true, false, false, false, 2)
DIAG(warn_mixed_sign_comparison, CLASS_WARNING, diag::MAP_IGNORE, "comparison of integers of different signs: %0 and %1", 286, true, false, false, false, 2)
DIAG(warn_multiple_method_decl, CLASS_WARNING, diag::MAP_WARNING, "multiple methods named %0 found", 0, true, false, false, false, 2)
DIAG(warn_no_constructor_for_refconst, CLASS_WARNING, diag::MAP_WARNING, "%select{struct|interface|union|class|enum}0 %1 does not declare any constructor to initialize its non-modifiable members", 0, true, false, false, false, 2)
DIAG(warn_no_unlock, CLASS_WARNING, diag::MAP_IGNORE, "mutex '%0' is still locked at the end of function", 321, true, false, false, false, 2)
DIAG(warn_non_contravariant_overriding_param_types, CLASS_WARNING, diag::MAP_IGNORE, "conflicting parameter types in declaration of %0: %1 vs %2", 245, true, false, false, false, 2)
DIAG(warn_non_contravariant_param_types, CLASS_WARNING, diag::MAP_IGNORE, "conflicting parameter types in implementation of %0: %1 vs %2", 185, true, false, false, false, 2)
DIAG(warn_non_covariant_overriding_ret_types, CLASS_WARNING, diag::MAP_IGNORE, "conflicting return type in declaration of %0: %1 vs %2", 245, true, false, false, false, 2)
DIAG(warn_non_covariant_ret_types, CLASS_WARNING, diag::MAP_IGNORE, "conflicting return type in implementation of %0: %1 vs %2", 185, true, false, false, false, 2)
DIAG(warn_non_literal_null_pointer, CLASS_WARNING, diag::MAP_WARNING, "expression which evaluates to zero treated as a null pointer constant of type %0", 209, true, false, false, false, 14)
DIAG(warn_non_pod_vararg_with_format_string, CLASS_WARNING, diag::MAP_ERROR, "cannot pass %select{non-POD|non-trivial}0 object of type %1 to variadic %select{function|block|method|constructor}2; expected type from format string was %3", 210, true, false, false, false, 2)
DIAG(warn_non_virtual_dtor, CLASS_WARNING, diag::MAP_IGNORE, "%0 has virtual functions but non-virtual destructor", 211, true, false, false, false, 2)
DIAG(warn_nonnull_pointers_only, CLASS_WARNING, diag::MAP_WARNING, "nonnull attribute only applies to pointer arguments", 0, true, false, false, false, 2)
DIAG(warn_noreturn_function_has_return_expr, CLASS_WARNING, diag::MAP_WARNING, "function %0 declared 'noreturn' should not return", 166, true, false, false, false, 2)
DIAG(warn_not_a_doxygen_trailing_member_comment, CLASS_WARNING, diag::MAP_IGNORE, "not a Doxygen trailing comment", 100, true, false, false, false, 15)
DIAG(warn_not_compound_assign, CLASS_WARNING, diag::MAP_WARNING, "use of unary operator that may be intended as compound assignment (%0=)", 0, true, false, false, false, 2)
DIAG(warn_not_enough_argument, CLASS_WARNING, diag::MAP_WARNING, "not enough variable arguments in %0 declaration to fit a sentinel", 275, true, false, false, false, 2)
DIAG(warn_not_in_enum, CLASS_WARNING, diag::MAP_WARNING, "case value not in enumerated type %0", 313, true, false, false, false, 2)
DIAG(warn_not_in_enum_assignement, CLASS_WARNING, diag::MAP_IGNORE, "integer constant not in range of enumerated type %0", 28, true, false, false, false, 2)
DIAG(warn_ns_attribute_wrong_parameter_type, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute only applies to %select{Objective-C object|pointer}1 parameters", 142, true, false, false, false, 2)
DIAG(warn_ns_attribute_wrong_return_type, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute only applies to %select{functions|methods}1 that return %select{an Objective-C object|a pointer|a non-retainable pointer}2", 142, true, false, false, false, 2)
DIAG(warn_nsobject_attribute, CLASS_WARNING, diag::MAP_WARNING, "__attribute ((NSObject)) may be put on a typedef only, attribute is ignored", 4, true, false, false, false, 2)
DIAG(warn_null_arg, CLASS_WARNING, diag::MAP_WARNING, "null passed to a callee which requires a non-null argument", 212, true, false, false, false, 20)
DIAG(warn_null_in_arithmetic_operation, CLASS_WARNING, diag::MAP_WARNING, "use of NULL in arithmetic operation", 214, true, false, false, false, 2)
DIAG(warn_null_in_comparison_operation, CLASS_WARNING, diag::MAP_WARNING, "comparison between NULL and non-pointer %select{(%1 and NULL)|(NULL and %1)}0", 214, true, false, false, false, 2)
DIAG(warn_objc_isa_use, CLASS_WARNING, diag::MAP_WARNING, "direct access to objective-c's isa is deprecated in favor of object_setClass() and object_getClass()", 91, true, false, false, false, 2)
DIAG(warn_objc_literal_comparison, CLASS_WARNING, diag::MAP_WARNING, "direct comparison of %select{an array literal|a dictionary literal|a numeric literal|a boxed expression|}0 has undefined behavior", 222, true, false, false, false, 2)
DIAG(warn_objc_missing_super_call, CLASS_WARNING, diag::MAP_WARNING, "method possibly missing a [super %0] call", 225, true, false, false, false, 2)
DIAG(warn_objc_object_attribute_wrong_type, CLASS_WARNING, diag::MAP_WARNING, "'%0' only applies to Objective-C object or block pointer types; type here is %1", 142, true, false, false, false, 2)
DIAG(warn_objc_pointer_cxx_catch_fragile, CLASS_WARNING, diag::MAP_WARNING, "can not catch an exception thrown with @throw in C++ in the non-unified exception model", 227, true, false, false, false, 2)
DIAG(warn_objc_precise_lifetime_meaningless, CLASS_ERROR, diag::MAP_ERROR, "objc_precise_lifetime is not meaningful for %select{__unsafe_unretained|__autoreleasing}0 objects", 0, true, false, false, false, 2)
DIAG(warn_objc_property_attr_mutually_exclusive, CLASS_WARNING, diag::MAP_IGNORE, "property attributes '%0' and '%1' are mutually exclusive", 259, true, false, false, false, 2)
DIAG(warn_objc_property_copy_missing_on_block, CLASS_WARNING, diag::MAP_WARNING, "'copy' attribute must be specified for the block property when -fobjc-gc-only is specified", 0, true, false, false, false, 2)
DIAG(warn_objc_property_default_assign_on_object, CLASS_WARNING, diag::MAP_WARNING, "default property attribute 'assign' not appropriate for non-GC object", 230, true, false, false, false, 2)
DIAG(warn_objc_property_no_assignment_attribute, CLASS_WARNING, diag::MAP_WARNING, "no 'assign', 'retain', or 'copy' attribute is specified - 'assign' is assumed", 230, true, false, false, false, 2)
DIAG(warn_objc_property_retain_of_block, CLASS_WARNING, diag::MAP_WARNING, "retain'ed block property does not copy the block - use copy attribute instead", 226, true, false, false, false, 2)
DIAG(warn_objc_readonly_property_has_setter, CLASS_WARNING, diag::MAP_WARNING, "setter cannot be specified for a readonly property", 233, true, false, false, false, 2)
DIAG(warn_objc_redundant_literal_use, CLASS_WARNING, diag::MAP_WARNING, "using %0 with a literal is redundant", 235, true, false, false, false, 21)
DIAG(warn_objc_requires_super_protocol, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute cannot be applied to %select{methods in protocols|dealloc}1", 265, true, false, false, false, 2)
DIAG(warn_objc_root_class_missing, CLASS_WARNING, diag::MAP_WARNING, "class %0 defined without specifying a base class", 236, true, false, false, false, 2)
DIAG(warn_objc_string_literal_comparison, CLASS_WARNING, diag::MAP_WARNING, "direct comparison of a string literal has undefined behavior", 237, true, false, false, false, 2)
DIAG(warn_offsetof_non_pod_type, CLASS_EXTENSION, diag::MAP_WARNING, "offset of on non-POD type %0", 167, true, false, false, false, 2)
DIAG(warn_offsetof_non_standardlayout_type, CLASS_EXTENSION, diag::MAP_WARNING, "offset of on non-standard-layout type %0", 167, true, false, false, false, 2)
DIAG(warn_on_superclass_use, CLASS_WARNING, diag::MAP_WARNING, "class implementation may not have super class", 0, true, false, false, false, 2)
DIAG(warn_out_of_range_compare, CLASS_WARNING, diag::MAP_WARNING, "comparison of constant %0 with expression of type %1 is always %select{false|true}2", 318, true, false, false, false, 2)
DIAG(warn_overaligned_type, CLASS_WARNING, diag::MAP_IGNORE, "type %0 requires %1 bytes of alignment and the default allocator only guarantees %2 bytes", 241, true, false, false, false, 2)
DIAG(warn_overloaded_virtual, CLASS_WARNING, diag::MAP_IGNORE, "%q0 hides overloaded virtual %select{function|functions}1", 244, true, false, false, false, 2)
DIAG(warn_override_exception_spec, CLASS_EXTENSION, diag::MAP_WARNING, "exception specification of overriding function is more lax than base version", 186, true, false, false, false, 2)
DIAG(warn_owning_getter_rule, CLASS_WARNING, diag::MAP_WARNING, "property's synthesized getter follows Cocoa naming convention for returning 'owned' objects", 229, true, false, false, false, 2)
DIAG(warn_padded_struct_anon_field, CLASS_WARNING, diag::MAP_IGNORE, "padding %select{struct|interface|class}0 %1 with %2 %select{byte|bit}3%select{|s}4 to align anonymous bit-field", 247, true, false, false, false, 2)
DIAG(warn_padded_struct_field, CLASS_WARNING, diag::MAP_IGNORE, "padding %select{struct|interface|class}0 %1 with %2 %select{byte|bit}3%select{|s}4 to align %5", 247, true, false, false, false, 2)
DIAG(warn_padded_struct_size, CLASS_WARNING, diag::MAP_IGNORE, "padding size of %0 with %1 %select{byte|bit}2%select{|s}3 to alignment boundary", 247, true, false, false, false, 2)
DIAG(warn_param_default_argument_redefinition, CLASS_EXTENSION, diag::MAP_WARNING, "redefinition of default argument", 0, true, false, false, false, 2)
DIAG(warn_parameter_size, CLASS_WARNING, diag::MAP_WARNING, "%0 is a large (%1 bytes) pass-by-value argument; pass it by reference instead ?", 175, true, false, false, false, 2)
DIAG(warn_parens_disambiguated_as_function_declaration, CLASS_WARNING, diag::MAP_WARNING, "parentheses were disambiguated as a function declaration", 362, true, false, false, false, 2)
DIAG(warn_partial_specs_not_deducible, CLASS_WARNING, diag::MAP_WARNING, "class template partial specialization contains %select{a template parameter|template parameters}0 that can not be deduced; this partial specialization will never be used", 0, true, false, false, false, 2)
DIAG(warn_pointer_attribute_wrong_type, CLASS_WARNING, diag::MAP_WARNING, "'%0' only applies to pointer types; type here is %1", 142, true, false, false, false, 2)
DIAG(warn_pointer_indirection_from_incompatible_type, CLASS_WARNING, diag::MAP_IGNORE, "dereference of type %1 that was reinterpret_cast from type %0 has undefined behavior", 332, true, false, false, false, 2)
DIAG(warn_pragma_options_align_reset_failed, CLASS_WARNING, diag::MAP_WARNING, "#pragma options align=reset failed: %0", 0, true, false, false, false, 2)
DIAG(warn_pragma_pack_invalid_alignment, CLASS_WARNING, diag::MAP_WARNING, "expected #pragma pack parameter to be '1', '2', '4', '8', or '16'", 0, true, false, false, false, 2)
DIAG(warn_pragma_pack_pop_failed, CLASS_WARNING, diag::MAP_WARNING, "#pragma pack(pop, ...) failed: %0", 0, true, false, false, false, 2)
DIAG(warn_pragma_pack_pop_identifer_and_alignment, CLASS_WARNING, diag::MAP_WARNING, "specifying both a name and alignment to 'pop' is undefined", 0, true, false, false, false, 2)
DIAG(warn_pragma_pack_show, CLASS_WARNING, diag::MAP_WARNING, "value of #pragma pack(show) == %0", 0, true, false, false, false, 2)
DIAG(warn_pragma_unused_expected_var_arg, CLASS_WARNING, diag::MAP_WARNING, "only variables can be arguments to '#pragma unused'", 0, true, false, false, false, 2)
DIAG(warn_pragma_unused_undeclared_var, CLASS_WARNING, diag::MAP_WARNING, "undeclared variable %0 used as an argument for '#pragma unused'", 0, true, false, false, false, 2)
DIAG(warn_precedence_bitwise_rel, CLASS_WARNING, diag::MAP_WARNING, "%0 has lower precedence than %1; %1 will be evaluated first", 248, true, false, false, false, 2)
DIAG(warn_precedence_conditional, CLASS_WARNING, diag::MAP_WARNING, "operator '?:' has lower precedence than '%0'; '%0' will be evaluated first", 248, true, false, false, false, 2)
DIAG(warn_previous_alias_decl, CLASS_WARNING, diag::MAP_WARNING, "previously declared alias is ignored", 0, true, false, false, false, 2)
DIAG(warn_printf_asterisk_missing_arg, CLASS_WARNING, diag::MAP_WARNING, "'%select{*|.*}0' specified field %select{width|precision}0 is missing a matching 'int' argument", 125, true, false, false, false, 20)
DIAG(warn_printf_asterisk_wrong_type, CLASS_WARNING, diag::MAP_WARNING, "field %select{width|precision}0 should have type %1, but argument has type %2", 125, true, false, false, false, 20)
DIAG(warn_printf_conversion_argument_type_mismatch, CLASS_WARNING, diag::MAP_WARNING, "format specifies type %0 but the argument has type %1", 125, true, false, false, false, 20)
DIAG(warn_printf_data_arg_not_used, CLASS_WARNING, diag::MAP_WARNING, "data argument not used by format string", 126, true, false, false, false, 20)
DIAG(warn_printf_format_string_contains_null_char, CLASS_WARNING, diag::MAP_WARNING, "format string contains '\\0' within the string body", 125, true, false, false, false, 20)
DIAG(warn_printf_ignored_flag, CLASS_WARNING, diag::MAP_WARNING, "flag '%0' is ignored when flag '%1' is present", 125, true, false, false, false, 20)
DIAG(warn_printf_incomplete_specifier, CLASS_WARNING, diag::MAP_WARNING, "incomplete format specifier", 125, true, false, false, false, 20)
DIAG(warn_printf_insufficient_data_args, CLASS_WARNING, diag::MAP_WARNING, "more '%%' conversions than data arguments", 125, true, false, false, false, 20)
DIAG(warn_printf_nonsensical_flag, CLASS_WARNING, diag::MAP_WARNING, "flag '%0' results in undefined behavior with '%1' conversion specifier", 125, true, false, false, false, 20)
DIAG(warn_printf_nonsensical_optional_amount, CLASS_WARNING, diag::MAP_WARNING, "%select{field width|precision}0 used with '%1' conversion specifier, resulting in undefined behavior", 125, true, false, false, false, 20)
DIAG(warn_printf_positional_arg_exceeds_data_args, CLASS_WARNING, diag::MAP_WARNING, "data argument position '%0' exceeds the number of data arguments (%1)", 125, true, false, false, false, 20)
DIAG(warn_private_extern, CLASS_WARNING, diag::MAP_WARNING, "use of __private_extern__ on a declaration may not produce external symbol private to the linkage unit and is deprecated", 256, true, false, false, false, 2)
DIAG(warn_property_attr_mismatch, CLASS_WARNING, diag::MAP_WARNING, "property attribute in class extension does not match the primary class", 0, true, false, false, false, 2)
DIAG(warn_property_attribute, CLASS_WARNING, diag::MAP_WARNING, "property %0 '%1' attribute does not match the property inherited from %2", 0, true, false, false, false, 2)
DIAG(warn_property_getter_owning_mismatch, CLASS_WARNING, diag::MAP_WARNING, "property declared as returning non-retained objects; getter returning retained objects", 0, true, false, false, false, 2)
DIAG(warn_property_types_are_incompatible, CLASS_WARNING, diag::MAP_WARNING, "property type %0 is incompatible with type %1 inherited from %2", 0, true, false, false, false, 2)
DIAG(warn_ptr_arith_exceeds_bounds, CLASS_WARNING, diag::MAP_IGNORE, "the pointer incremented by %0 refers past the end of the array (that contains %1 element%s2)", 25, true, false, false, false, 2)
DIAG(warn_ptr_arith_precedes_bounds, CLASS_WARNING, diag::MAP_IGNORE, "the pointer decremented by %0 refers before the beginning of the array", 25, true, false, false, false, 2)
DIAG(warn_pure_function_definition, CLASS_EXTENSION, diag::MAP_WARNING, "function definition with pure-specifier is a Microsoft extension", 186, true, false, false, false, 2)
DIAG(warn_qual_return_type, CLASS_WARNING, diag::MAP_IGNORE, "'%0' type qualifier%s1 on return type %plural{1:has|:have}1 no effect", 143, true, false, false, false, 2)
DIAG(warn_readonly_property, CLASS_WARNING, diag::MAP_WARNING, "attribute 'readonly' of property %0 restricts attribute 'readwrite' of property inherited from %1", 0, true, false, false, false, 2)
DIAG(warn_receiver_forward_class, CLASS_WARNING, diag::MAP_WARNING, "receiver %0 is a forward class and corresponding @interface may not exist", 261, true, false, false, false, 2)
DIAG(warn_receiver_forward_instance, CLASS_WARNING, diag::MAP_IGNORE, "receiver type %0 for instance message is a forward declaration", 261, true, false, false, false, 5)
DIAG(warn_receiver_is_weak, CLASS_WARNING, diag::MAP_IGNORE, "weak %select{receiver|property|implicit property}0 may be unpredictably set to nil", 262, true, false, false, false, 2)
DIAG(warn_redecl_library_builtin, CLASS_WARNING, diag::MAP_WARNING, "incompatible redeclaration of library function %0", 0, true, false, false, false, 2)
DIAG(warn_redeclaration_without_attribute_prev_attribute_ignored, CLASS_WARNING, diag::MAP_WARNING, "'%0' redeclared without %1 attribute: previous %1 ignored", 0, true, false, false, false, 2)
DIAG(warn_redefinition_in_param_list, CLASS_WARNING, diag::MAP_WARNING, "redefinition of %0 will not be visible outside of this function", 363, true, false, false, false, 2)
DIAG(warn_redefinition_of_typedef, CLASS_EXTENSION, diag::MAP_WARNING, "redefinition of typedef %0 is a C11 feature", 327, true, false, false, false, 2)
DIAG(warn_reference_field_is_uninit, CLASS_WARNING, diag::MAP_WARNING, "reference %0 is not yet bound to a value when used here", 334, true, false, false, false, 2)
DIAG(warn_register_objc_catch_parm, CLASS_WARNING, diag::MAP_WARNING, "'register' storage specifier on @catch parameter will be ignored", 0, true, false, false, false, 2)
DIAG(warn_related_result_type_compatibility_class, CLASS_WARNING, diag::MAP_WARNING, "method is expected to return an instance of its class type %diff{$, but is declared to return $|, but is declared to return different type}0,1", 0, true, false, false, false, 17)
DIAG(warn_related_result_type_compatibility_protocol, CLASS_WARNING, diag::MAP_WARNING, "protocol method is expected to return an instance of the implementing class, but is declared to return %0", 0, true, false, false, false, 17)
DIAG(warn_remainder_by_zero, CLASS_WARNING, diag::MAP_WARNING, "remainder by zero is undefined", 99, true, false, false, false, 2)
DIAG(warn_ret_addr_label, CLASS_WARNING, diag::MAP_WARNING, "returning address of label, which is local", 267, true, false, false, false, 2)
DIAG(warn_ret_local_temp_addr, CLASS_WARNING, diag::MAP_WARNING, "returning address of local temporary object", 267, true, false, false, false, 2)
DIAG(warn_ret_local_temp_ref, CLASS_WARNING, diag::MAP_WARNING, "returning reference to local temporary object", 267, true, false, false, false, 2)
DIAG(warn_ret_stack_addr, CLASS_WARNING, diag::MAP_WARNING, "address of stack memory associated with local variable %0 returned", 267, true, false, false, false, 2)
DIAG(warn_ret_stack_ref, CLASS_WARNING, diag::MAP_WARNING, "reference to stack memory associated with local variable %0 returned", 267, true, false, false, false, 2)
DIAG(warn_return_missing_expr, CLASS_WARNING, diag::MAP_ERROR, "non-void %select{function|method}1 %0 should return a value", 268, true, false, false, false, 2)
DIAG(warn_return_value_size, CLASS_WARNING, diag::MAP_WARNING, "return value of %0 is a large (%1 bytes) pass-by-value object; pass it by reference instead ?", 175, true, false, false, false, 2)
DIAG(warn_return_value_udt, CLASS_WARNING, diag::MAP_WARNING, "%0 has C-linkage specified, but returns user-defined type %1 which is incompatible with C", 269, true, false, false, false, 2)
DIAG(warn_return_value_udt_incomplete, CLASS_WARNING, diag::MAP_WARNING, "%0 has C-linkage specified, but returns incomplete type %1 which could be incompatible with C", 269, true, false, false, false, 2)
DIAG(warn_root_inst_method_not_found, CLASS_WARNING, diag::MAP_WARNING, "instance method %0 is being used on 'Class' which is not in the root class", 223, true, false, false, false, 2)
DIAG(warn_runsigned_always_true_comparison, CLASS_WARNING, diag::MAP_WARNING, "comparison of %0 unsigned%select{| enum}2 expression is always %1", 317, true, false, false, false, 2)
DIAG(warn_scanf_nonzero_width, CLASS_WARNING, diag::MAP_WARNING, "zero field width in scanf format string is unused", 125, true, false, false, false, 20)
DIAG(warn_scanf_scanlist_incomplete, CLASS_WARNING, diag::MAP_WARNING, "no closing ']' for '%%[' in scanf format string", 125, true, false, false, false, 20)
DIAG(warn_second_parameter_of_va_start_not_last_named_argument, CLASS_WARNING, diag::MAP_WARNING, "second parameter of 'va_start' not last named argument", 0, true, false, false, false, 2)
DIAG(warn_second_parameter_to_va_arg_never_compatible, CLASS_WARNING, diag::MAP_WARNING, "second argument to 'va_arg' is of promotable type %0; this va_arg has undefined behavior because arguments will be promoted to %1", 0, true, false, false, false, 2)
DIAG(warn_second_parameter_to_va_arg_not_pod, CLASS_WARNING, diag::MAP_ERROR, "second argument to 'va_arg' is of non-POD type %0", 210, true, false, false, false, 2)
DIAG(warn_second_parameter_to_va_arg_ownership_qualified, CLASS_WARNING, diag::MAP_ERROR, "second argument to 'va_arg' is of ARC ownership-qualified type %0", 210, true, false, false, false, 2)
DIAG(warn_self_assignment, CLASS_WARNING, diag::MAP_IGNORE, "explicitly assigning a variable of type %0 to itself", 272, true, false, false, false, 2)
DIAG(warn_setter_getter_impl_required, CLASS_WARNING, diag::MAP_WARNING, "property %0 requires method %1 to be defined - use @synthesize, @dynamic or provide a method implementation in this class implementation", 228, true, false, false, false, 2)
DIAG(warn_setter_getter_impl_required_in_category, CLASS_WARNING, diag::MAP_WARNING, "property %0 requires method %1 to be defined - use @dynamic or provide a method implementation in this category", 228, true, false, false, false, 2)
DIAG(warn_shift_gt_typewidth, CLASS_WARNING, diag::MAP_WARNING, "shift count >= width of type", 281, true, false, false, false, 2)
DIAG(warn_shift_negative, CLASS_WARNING, diag::MAP_WARNING, "shift count is negative", 280, true, false, false, false, 2)
DIAG(warn_shift_result_gt_typewidth, CLASS_WARNING, diag::MAP_WARNING, "signed shift result (%0) requires %1 bits to represent, but %2 only has %3 bits", 283, true, false, false, false, 2)
DIAG(warn_shift_result_sets_sign_bit, CLASS_WARNING, diag::MAP_IGNORE, "signed shift result (%0) sets the sign bit of the shift expression's type (%1) and becomes negative", 284, true, false, false, false, 2)
DIAG(warn_sizeof_array_param, CLASS_WARNING, diag::MAP_WARNING, "sizeof on array function parameter will return size of %0 instead of %1", 289, true, false, false, false, 2)
DIAG(warn_sizeof_pointer_expr_memaccess, CLASS_WARNING, diag::MAP_WARNING, "'%0' call operates on objects of type %1 while the size is based on a different type %2", 290, true, false, false, false, 2)
DIAG(warn_sizeof_pointer_expr_memaccess_note, CLASS_NOTE, diag::MAP_FATAL, "did you mean to %select{dereference the argument to 'sizeof' (and multiply it by the number of elements)|remove the addressof in the argument to 'sizeof' (and multiply it by the number of elements)|provide an explicit length}0?", 0, true, false, false, false, 2)
DIAG(warn_sizeof_pointer_type_memaccess, CLASS_WARNING, diag::MAP_WARNING, "argument to 'sizeof' in %0 call is the same pointer type %1 as the %select{destination|source}2; expected %3 or an explicit length", 290, true, false, false, false, 2)
DIAG(warn_sometimes_uninit_var, CLASS_WARNING, diag::MAP_IGNORE, "variable %0 is %select{used|captured}1 uninitialized whenever %select{'%3' condition is %select{true|false}4|'%3' loop %select{is entered|exits because its condition is false}4|'%3' loop %select{condition is true|exits because its condition is false}4|switch %3 is taken}2", 291, true, false, false, false, 2)
DIAG(warn_standalone_specifier, CLASS_WARNING, diag::MAP_WARNING, "'%0' ignored on this declaration", 0, true, false, false, false, 2)
DIAG(warn_static_array_too_small, CLASS_WARNING, diag::MAP_WARNING, "array argument is too small; contains %0 elements, callee requires at least %1", 24, true, false, false, false, 2)
DIAG(warn_static_main, CLASS_WARNING, diag::MAP_WARNING, "'main' should not be declared static", 182, true, false, false, false, 2)
DIAG(warn_static_non_static, CLASS_EXTENSION, diag::MAP_WARNING, "static declaration of %0 follows non-static declaration", 0, true, false, false, false, 2)
DIAG(warn_strict_multiple_method_decl, CLASS_WARNING, diag::MAP_IGNORE, "multiple methods named %0 found", 306, true, false, false, false, 2)
DIAG(warn_string_plus_int, CLASS_WARNING, diag::MAP_WARNING, "adding %0 to a string does not append to the string", 309, true, false, false, false, 2)
DIAG(warn_stringcompare, CLASS_WARNING, diag::MAP_WARNING, "result of comparison against %select{a string literal|@encode}0 is unspecified (use strncmp instead)", 307, true, false, false, false, 2)
DIAG(warn_strlcpycat_wrong_size, CLASS_WARNING, diag::MAP_WARNING, "size argument in %0 call appears to be size of the source; expected the size of the destination", 310, true, false, false, false, 2)
DIAG(warn_strncat_large_size, CLASS_WARNING, diag::MAP_WARNING, "the value of the size argument in 'strncat' is too large, might lead to a buffer overflow", 311, true, false, false, false, 2)
DIAG(warn_strncat_src_size, CLASS_WARNING, diag::MAP_WARNING, "size argument in 'strncat' call appears to be size of the source", 311, true, false, false, false, 2)
DIAG(warn_strncat_wrong_size, CLASS_WARNING, diag::MAP_WARNING, "the value of the size argument to 'strncat' is wrong", 311, true, false, false, false, 2)
DIAG(warn_struct_class_previous_tag_mismatch, CLASS_WARNING, diag::MAP_IGNORE, "%2 defined as %select{a struct|an interface|a class}0%select{| template}1 here but previously declared as %select{a struct|an interface|a class}3%select{| template}1", 191, true, false, false, false, 2)
DIAG(warn_struct_class_tag_mismatch, CLASS_WARNING, diag::MAP_IGNORE, "%select{struct|interface|class}0%select{| template}1 %2 was previously declared as a %select{struct|interface|class}3%select{| template}1", 191, true, false, false, false, 2)
DIAG(warn_subobject_initializer_overrides, CLASS_WARNING, diag::MAP_WARNING, "subobject initialization overrides initialization of other fields within its enclosing subobject", 159, true, false, false, false, 2)
DIAG(warn_subscript_is_char, CLASS_WARNING, diag::MAP_IGNORE, "array subscript is of type 'char'", 66, true, false, false, false, 2)
DIAG(warn_suggest_noreturn_block, CLASS_WARNING, diag::MAP_IGNORE, "block could be declared with attribute 'noreturn'", 198, true, false, false, false, 2)
DIAG(warn_suggest_noreturn_function, CLASS_WARNING, diag::MAP_IGNORE, "%select{function|method}0 %1 could be declared with attribute 'noreturn'", 198, true, false, false, false, 2)
DIAG(warn_template_arg_negative, CLASS_WARNING, diag::MAP_IGNORE, "non-type template argument with value '%0' converted to '%1' for unsigned template parameter of type %2", 75, true, false, false, false, 14)
DIAG(warn_template_arg_too_large, CLASS_WARNING, diag::MAP_IGNORE, "non-type template argument value '%0' truncated to '%1' for template parameter of type %2", 75, true, false, false, false, 14)
DIAG(warn_template_export_unsupported, CLASS_WARNING, diag::MAP_WARNING, "exported templates are unsupported", 0, true, false, false, false, 2)
DIAG(warn_template_spec_extra_headers, CLASS_WARNING, diag::MAP_WARNING, "extraneous template parameter list in template specialization", 0, true, false, false, false, 2)
DIAG(warn_temporary_array_to_pointer_decay, CLASS_WARNING, diag::MAP_WARNING, "pointer is initialized by a temporary array, which will be destroyed at the end of the full-expression", 8, true, false, false, false, 2)
DIAG(warn_tentative_incomplete_array, CLASS_WARNING, diag::MAP_WARNING, "tentative array definition assumed to have one element", 0, true, false, false, false, 2)
DIAG(warn_thread_attribute_argument_not_class, CLASS_WARNING, diag::MAP_IGNORE, "%0 attribute requires arguments that are class type or point to class type; type here is '%1'", 322, true, false, false, false, 2)
DIAG(warn_thread_attribute_argument_not_lockable, CLASS_WARNING, diag::MAP_IGNORE, "%0 attribute requires arguments whose type is annotated with 'lockable' attribute; type here is '%1'", 322, true, false, false, false, 2)
DIAG(warn_thread_attribute_decl_not_lockable, CLASS_WARNING, diag::MAP_IGNORE, "%0 attribute can only be applied in a context annotated with 'lockable' attribute", 322, true, false, false, false, 2)
DIAG(warn_thread_attribute_decl_not_pointer, CLASS_WARNING, diag::MAP_IGNORE, "'%0' only applies to pointer types; type here is %1", 322, true, false, false, false, 2)
DIAG(warn_thread_attribute_ignored, CLASS_WARNING, diag::MAP_IGNORE, "ignoring %0 attribute because its argument is invalid", 322, true, false, false, false, 2)
DIAG(warn_thread_attribute_wrong_decl_type, CLASS_WARNING, diag::MAP_IGNORE, "%0 attribute only applies to %select{fields and global variables|functions and methods|classes and structs}1", 322, true, false, false, false, 2)
DIAG(warn_transparent_union_attribute_field_size_align, CLASS_WARNING, diag::MAP_WARNING, "%select{alignment|size}0 of field %1 (%2 bits) does not match the %select{alignment|size}0 of the first field in transparent union; transparent_union attribute ignored", 142, true, false, false, false, 2)
DIAG(warn_transparent_union_attribute_floating, CLASS_WARNING, diag::MAP_WARNING, "first field of a transparent union cannot have %select{floating point|vector}0 type %1; transparent_union attribute ignored", 142, true, false, false, false, 2)
DIAG(warn_transparent_union_attribute_not_definition, CLASS_WARNING, diag::MAP_WARNING, "transparent_union attribute can only be applied to a union definition; attribute ignored", 142, true, false, false, false, 2)
DIAG(warn_transparent_union_attribute_zero_fields, CLASS_WARNING, diag::MAP_WARNING, "transparent union definition must contain at least one field; transparent_union attribute ignored", 142, true, false, false, false, 2)
DIAG(warn_type_safety_null_pointer_required, CLASS_WARNING, diag::MAP_WARNING, "specified %0 type tag requires a null pointer", 326, true, false, false, false, 2)
DIAG(warn_type_safety_type_mismatch, CLASS_WARNING, diag::MAP_WARNING, "argument type %0 doesn't match specified '%1' type tag %select{that requires %3|}2", 326, true, false, false, false, 2)
DIAG(warn_type_tag_for_datatype_wrong_kind, CLASS_WARNING, diag::MAP_WARNING, "this type tag was not designed to be used with this function", 326, true, false, false, false, 2)
DIAG(warn_typecheck_cond_incompatible_pointers, CLASS_EXTENSION, diag::MAP_WARNING, "pointer type mismatch%diff{ ($ and $)|}0,1", 254, true, false, false, false, 2)
DIAG(warn_typecheck_cond_pointer_integer_mismatch, CLASS_EXTENSION, diag::MAP_WARNING, "pointer/integer type mismatch in conditional expression%diff{ ($ and $)|}0,1", 71, true, false, false, false, 2)
DIAG(warn_typecheck_function_qualifiers, CLASS_WARNING, diag::MAP_WARNING, "qualifier on function type %0 has unspecified behavior", 0, true, false, false, false, 2)
DIAG(warn_typecheck_negative_array_new_size, CLASS_WARNING, diag::MAP_WARNING, "array size is negative", 37, true, false, false, false, 2)
DIAG(warn_typecheck_zero_static_array_size, CLASS_WARNING, diag::MAP_WARNING, "'static' has no effect on zero-length arrays", 24, true, false, false, false, 2)
DIAG(warn_typename_missing, CLASS_EXTENSION, diag::MAP_WARNING, "missing 'typename' prior to dependent type name '%0%1'", 328, true, false, false, false, 2)
DIAG(warn_unannotated_fallthrough, CLASS_WARNING, diag::MAP_IGNORE, "unannotated fall-through between switch labels", 148, true, false, false, false, 2)
DIAG(warn_unannotated_fallthrough_per_function, CLASS_WARNING, diag::MAP_IGNORE, "unannotated fall-through between switch labels in partly-annotated function", 149, true, false, false, false, 2)
DIAG(warn_unavailable_fwdclass_message, CLASS_WARNING, diag::MAP_WARNING, "%0 maybe unavailable because receiver type is unknown", 0, true, false, false, false, 2)
DIAG(warn_undeclared_selector, CLASS_WARNING, diag::MAP_IGNORE, "undeclared selector %0", 329, true, false, false, false, 2)
DIAG(warn_undef_interface, CLASS_WARNING, diag::MAP_WARNING, "cannot find interface declaration for %0", 0, true, false, false, false, 2)
DIAG(warn_undef_interface_suggest, CLASS_WARNING, diag::MAP_WARNING, "cannot find interface declaration for %0; did you mean %1?", 0, true, false, false, false, 2)
DIAG(warn_undef_protocolref, CLASS_WARNING, diag::MAP_WARNING, "cannot find protocol definition for %0", 0, true, false, false, false, 2)
DIAG(warn_undefined_internal, CLASS_WARNING, diag::MAP_WARNING, "%select{function|variable}0 %q1 has internal linkage but is not defined", 0, true, false, false, false, 2)
DIAG(warn_undefined_reinterpret_cast, CLASS_WARNING, diag::MAP_IGNORE, "reinterpret_cast from %0 to %1 has undefined behavior", 332, true, false, false, false, 2)
DIAG(warn_unhandled_ms_attribute_ignored, CLASS_WARNING, diag::MAP_WARNING, "__declspec attribute %0 is not supported", 142, true, false, false, false, 2)
DIAG(warn_unimplemented_protocol_method, CLASS_WARNING, diag::MAP_WARNING, "method %0 in protocol not implemented", 257, true, false, false, false, 2)
DIAG(warn_unimplemented_selector, CLASS_WARNING, diag::MAP_IGNORE, "unimplemented selector %0", 271, true, false, false, false, 2)
DIAG(warn_uninit_byref_blockvar_captured_by_block, CLASS_WARNING, diag::MAP_IGNORE, "block pointer variable %0 is uninitialized when captured by block", 334, true, false, false, false, 2)
DIAG(warn_uninit_self_reference_in_init, CLASS_WARNING, diag::MAP_WARNING, "variable %0 is uninitialized when used within its own initialization", 334, true, false, false, false, 2)
DIAG(warn_uninit_self_reference_in_reference_init, CLASS_WARNING, diag::MAP_WARNING, "reference %0 is not yet bound to a value when used within its own initialization", 334, true, false, false, false, 2)
DIAG(warn_uninit_var, CLASS_WARNING, diag::MAP_IGNORE, "variable %0 is uninitialized when %select{used here|captured by block}1", 334, true, false, false, false, 2)
DIAG(warn_unknown_attribute_ignored, CLASS_WARNING, diag::MAP_WARNING, "unknown attribute %0 ignored", 31, true, false, false, false, 2)
DIAG(warn_unknown_method_family, CLASS_WARNING, diag::MAP_WARNING, "unrecognized method family", 0, true, false, false, false, 2)
DIAG(warn_unlock_but_no_lock, CLASS_WARNING, diag::MAP_IGNORE, "unlocking '%0' that was not locked", 321, true, false, false, false, 2)
DIAG(warn_unnecessary_packed, CLASS_WARNING, diag::MAP_IGNORE, "packed attribute is unnecessary for %0", 246, true, false, false, false, 2)
DIAG(warn_unneeded_internal_decl, CLASS_WARNING, diag::MAP_IGNORE, "%select{function|variable}0 %1 is not needed and will not be emitted", 338, true, false, false, false, 23)
DIAG(warn_unneeded_member_function, CLASS_WARNING, diag::MAP_IGNORE, "member function %0 is not needed and will not be emitted", 339, true, false, false, false, 2)
DIAG(warn_unneeded_static_internal_decl, CLASS_WARNING, diag::MAP_IGNORE, "'static' function %0 declared in header file should be declared 'static inline'", 338, true, false, false, false, 23)
DIAG(warn_unreachable, CLASS_WARNING, diag::MAP_IGNORE, "will never be executed", 340, true, false, false, false, 2)
DIAG(warn_unreachable_default, CLASS_WARNING, diag::MAP_IGNORE, "default label in switch which covers all enumeration values", 77, true, false, false, false, 2)
DIAG(warn_unused_call, CLASS_WARNING, diag::MAP_WARNING, "ignoring return value of function declared with %0 attribute", 354, true, false, false, false, 23)
DIAG(warn_unused_comparison, CLASS_WARNING, diag::MAP_WARNING, "%select{equality|inequality}0 comparison result unused", 345, true, false, false, false, 23)
DIAG(warn_unused_container_subscript_expr, CLASS_WARNING, diag::MAP_WARNING, "container access result unused - container access should not be used for side effects", 354, true, false, false, false, 23)
DIAG(warn_unused_exception_param, CLASS_WARNING, diag::MAP_IGNORE, "unused exception parameter %0", 346, true, false, false, false, 2)
DIAG(warn_unused_expr, CLASS_WARNING, diag::MAP_WARNING, "expression result unused", 354, true, false, false, false, 23)
DIAG(warn_unused_function, CLASS_WARNING, diag::MAP_IGNORE, "unused function %0", 347, true, false, false, false, 23)
DIAG(warn_unused_label, CLASS_WARNING, diag::MAP_IGNORE, "unused label %0", 348, true, false, false, false, 23)
DIAG(warn_unused_member_function, CLASS_WARNING, diag::MAP_IGNORE, "unused member function %0", 350, true, false, false, false, 2)
DIAG(warn_unused_parameter, CLASS_WARNING, diag::MAP_IGNORE, "unused parameter %0", 351, true, false, false, false, 2)
DIAG(warn_unused_private_field, CLASS_WARNING, diag::MAP_IGNORE, "private field %0 is not used", 352, true, false, false, false, 23)
DIAG(warn_unused_property_expr, CLASS_WARNING, diag::MAP_WARNING, "property access result unused - getters should not be used for side effects", 354, true, false, false, false, 23)
DIAG(warn_unused_result, CLASS_WARNING, diag::MAP_WARNING, "ignoring return value of function declared with warn_unused_result attribute", 353, true, false, false, false, 2)
DIAG(warn_unused_variable, CLASS_WARNING, diag::MAP_IGNORE, "unused variable %0", 355, true, false, false, false, 23)
DIAG(warn_unused_voidptr, CLASS_WARNING, diag::MAP_WARNING, "expression result unused; should this cast be to 'void'?", 354, true, false, false, false, 23)
DIAG(warn_unused_volatile, CLASS_WARNING, diag::MAP_WARNING, "expression result unused; assign into a variable to force a volatile load", 356, true, false, false, false, 2)
DIAG(warn_use_out_of_scope_declaration, CLASS_WARNING, diag::MAP_WARNING, "use of out-of-scope declaration of %0", 0, true, false, false, false, 2)
DIAG(warn_used_but_marked_unused, CLASS_WARNING, diag::MAP_IGNORE, "%0 was marked unused but was used", 357, true, false, false, false, 2)
DIAG(warn_user_literal_reserved, CLASS_WARNING, diag::MAP_WARNING, "user-defined literal suffixes not starting with '_' are reserved; no literal will invoke this operator", 358, true, false, false, false, 2)
DIAG(warn_using_directive_in_header, CLASS_WARNING, diag::MAP_IGNORE, "using namespace directive in global context in header", 140, true, false, false, false, 2)
DIAG(warn_var_deref_requires_any_lock, CLASS_WARNING, diag::MAP_IGNORE, "%select{reading|writing}1 the value pointed to by '%0' requires locking %select{any mutex|any mutex exclusively}1", 321, true, false, false, false, 2)
DIAG(warn_var_deref_requires_lock, CLASS_WARNING, diag::MAP_IGNORE, "%select{reading|writing}2 the value pointed to by '%0' requires locking %select{'%1'|'%1' exclusively}2", 321, true, false, false, false, 2)
DIAG(warn_var_deref_requires_lock_precise, CLASS_WARNING, diag::MAP_IGNORE, "%select{reading|writing}2 the value pointed to by '%0' requires locking %select{'%1'|'%1' exclusively}2", 323, true, false, false, false, 2)
DIAG(warn_variable_requires_any_lock, CLASS_WARNING, diag::MAP_IGNORE, "%select{reading|writing}1 variable '%0' requires locking %select{any mutex|any mutex exclusively}1", 321, true, false, false, false, 2)
DIAG(warn_variable_requires_lock, CLASS_WARNING, diag::MAP_IGNORE, "%select{reading|writing}2 variable '%0' requires locking %select{'%1'|'%1' exclusively}2", 321, true, false, false, false, 2)
DIAG(warn_variable_requires_lock_precise, CLASS_WARNING, diag::MAP_IGNORE, "%select{reading|writing}2 variable '%0' requires locking %select{'%1'|'%1' exclusively}2", 323, true, false, false, false, 2)
DIAG(warn_variables_not_in_loop_body, CLASS_WARNING, diag::MAP_IGNORE, "variable%select{s| %1|s %1 and %2|s %1, %2, and %3|s %1, %2, %3, and %4}0 used in loop condition not modified in loop body", 181, true, false, false, false, 2)
DIAG(warn_weak_identifier_undeclared, CLASS_WARNING, diag::MAP_WARNING, "weak identifier %0 never declared", 0, true, false, false, false, 2)
DIAG(warn_weak_import, CLASS_WARNING, diag::MAP_WARNING, "an already-declared variable is made a weak_import declaration %0", 0, true, false, false, false, 2)
DIAG(warn_weak_template_vtable, CLASS_WARNING, diag::MAP_IGNORE, "explicit template instantiation %0 will emit a vtable in every translation unit", 366, true, false, false, false, 2)
DIAG(warn_weak_vtable, CLASS_WARNING, diag::MAP_IGNORE, "%0 has no out-of-line virtual method definitions; its vtable will be emitted in every translation unit", 367, true, false, false, false, 2)
