<?php
/*
 * @version $Id: includes.php 19747 2012-11-29 13:15:33Z moyo $
 -------------------------------------------------------------------------
 GLPI - Gestionnaire Libre de Parc Informatique
 Copyright (C) 2003-2012 by the INDEPNET Development Team.

 http://indepnet.net/   http://glpi-project.org
 -------------------------------------------------------------------------

 LICENSE

 This file is part of GLPI.

 GLPI is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 GLPI is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with GLPI. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
 */

// ----------------------------------------------------------------------
// Original Author of file:
// Purpose of file:
// ----------------------------------------------------------------------

if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access directly to this file");
}

include_once (GLPI_ROOT . "/inc/autoload.function.php");

// Init Timer to compute time of display
$TIMER_DEBUG = new Timer();
$TIMER_DEBUG->start();

/// TODO try to remove them if possible
include_once (GLPI_ROOT . "/inc/db.function.php");

// Standard includes
include_once (GLPI_ROOT . "/config/config.php");


// Security of PHP_SELF
$_SERVER['PHP_SELF'] = Html::cleanParametersURL($_SERVER['PHP_SELF']);




// Load Language file
Session::loadLanguage();

if (isset($_SESSION['glpi_use_mode'])
   && $_SESSION['glpi_use_mode'] == Session::DEBUG_MODE) {
   $SQL_TOTAL_REQUEST=0;
   $DEBUG_SQL["queries"]=array();
   $DEBUG_SQL["errors"]=array();
   $DEBUG_SQL["times"]=array();
   $DEBUG_AUTOLOAD=array();
}

// Security system
if (isset($_POST)) {
   if (Toolbox::get_magic_quotes_gpc()) {
      $_POST = array_map(array('Toolbox', 'stripslashes_deep'), $_POST);
   }

   $_POST = array_map(array('Toolbox','addslashes_deep'), $_POST);
   $_POST = array_map(array('Toolbox', 'clean_cross_side_scripting_deep'), $_POST);
}
if (isset($_GET)) {
   if (Toolbox::get_magic_quotes_gpc()) {
      $_GET = array_map(array('Toolbox', 'stripslashes_deep'), $_GET);
   }
   $_GET = array_map(array('Toolbox','addslashes_deep'), $_GET);
   $_GET = array_map(array('Toolbox', 'clean_cross_side_scripting_deep'), $_GET);
}

// Mark if Header is loaded or not :
$HEADER_LOADED=false;
$FOOTER_LOADED=false;
if (isset($AJAX_INCLUDE)) {
   $HEADER_LOADED=true;
}

/* On startup, register all plugins configured for use. */
if (!isset($AJAX_INCLUDE) && !isset($PLUGINS_INCLUDED)) {
   // PLugin already included
   $PLUGINS_INCLUDED=1;
   $LOADED_PLUGINS=array();
   $plugin = new Plugin();
   if (!isset($_SESSION["glpi_plugins"])) {
      $plugin->init();
   }
   if (isset($_SESSION["glpi_plugins"]) && is_array($_SESSION["glpi_plugins"])) {
      //Plugin::doHook("config");
      if (count($_SESSION["glpi_plugins"])) {
         foreach ($_SESSION["glpi_plugins"] as $name) {
            Plugin::load($name);
         }
      }
      // For plugins which require action after all plugin init
      Plugin::doHook("post_init");
   }
}


if (!isset($_SESSION["MESSAGE_AFTER_REDIRECT"])) {
   $_SESSION["MESSAGE_AFTER_REDIRECT"]="";
}

// Manage force tab
if (isset($_REQUEST['forcetab'])) {
   if (preg_match('/([a-zA-Z]+).form.php/',$_SERVER['PHP_SELF'],$matches)) {
      $itemtype=$matches[1];
      Session::setActiveTab($matches[1],$_REQUEST['forcetab']);
   }
}
// Manage tabs
if (isset($_REQUEST['glpi_tab']) && isset($_REQUEST['itemtype'])) {
   Session::setActiveTab($_REQUEST['itemtype'],$_REQUEST['glpi_tab']);
}
// Override list-limit if choosen
if (isset($_REQUEST['glpilist_limit'])) {
   $_SESSION['glpilist_limit']=$_REQUEST['glpilist_limit'];
}

// Security : Check HTTP_REFERRER : need to be in GLPI.
if (!defined('DO_NOT_CHECK_HTTP_REFERER') && !isCommandLine()
   && isset($_POST) && is_array($_POST) && count($_POST)) {
   // Do not applyed for plugins on 0.83
   if (strstr($_SERVER['REQUEST_URI'],$CFG_GLPI['root_doc'].'/plugins/') === FALSE) {
      if (!isset($_SERVER['HTTP_REFERER'])
          || !is_array($url=parse_url($_SERVER['HTTP_REFERER']))
          || !isset($url['host'])
          || (($url['host'] != $_SERVER['SERVER_NAME'])
	      && (!isset($_SERVER['HTTP_X_FORWARDED_SERVER']) || ($url['host'] != $_SERVER['HTTP_X_FORWARDED_SERVER'])))
          || !isset($url['path'])
          || (!empty($CFG_GLPI['root_doc']) && strpos($url['path'], $CFG_GLPI['root_doc'])!==0)) {
         Html::displayErrorAndDie("Error calling the previous page from forbidden one.", true);
      }
   }
}

// Security : check CSRF token
// No CSRF check if a plugin is not compliant
if (GLPI_USE_CSRF_CHECK
   && isset($_POST) && is_array($_POST) && count($_POST)
   && Plugin::isAllPluginsCSRFCompliant()) {
   // No ajax pages
   if (!preg_match(':'.$CFG_GLPI['root_doc'].'(/plugins/[^/]*|)/ajax/:', $_SERVER['REQUEST_URI'])) {
      if (!Session::validateCSRF($_POST)) {
         Html::displayErrorAndDie("The action you have requested is not allowed. Reload previous page before doing action again.", true);
      }
   }
}
// SET new global Token
$CURRENTCSRFTOKEN = '';
?>
