/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UpdateUnitListener;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnitCategoryTableModel
extends AbstractTableModel {
    private static final String EXPAND_STATE = "ExpandState";
    private List<Unit> unitData = Collections.emptyList();
    private List<Unit> featuretData = Collections.emptyList();
    private List<Unit> standAloneModules = Collections.emptyList();
    private List<UpdateUnitListener> listeners = new ArrayList<UpdateUnitListener>();
    private String filter = "";
    private Comparator<Unit> unitCmp;
    private Boolean isExpanded = null;

    List<Unit> getUnits() {
        return this.unitData;
    }

    static Map<String, Boolean> captureState(List<Unit> list) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (Unit unit : list) {
            hashMap.put(unit.updateUnit.getCodeName(), unit.isMarked());
        }
        return hashMap;
    }

    static void restoreState(List<Unit> list, Map<String, Boolean> map, boolean bl) {
        for (Unit unit : list) {
            Boolean bl2 = map.get(unit.updateUnit.getCodeName());
            if (bl2 != null) {
                if (bl2.booleanValue() && !unit.isMarked() && unit.canBeMarked()) {
                    unit.setMarked(true);
                    continue;
                }
                if (bl2.booleanValue() || !unit.isMarked() || !unit.canBeMarked()) continue;
                unit.setMarked(false);
                continue;
            }
            if (!bl || unit.isMarked() || !unit.canBeMarked()) continue;
            unit.setMarked(true);
        }
    }

    public static boolean isMarkedAsDefault(Type type) {
        return type.equals((Object)Type.LOCAL) || type.equals((Object)Type.UPDATE);
    }

    protected final boolean isMarkedAsDefault() {
        return UnitCategoryTableModel.isMarkedAsDefault(this.getType());
    }

    @Override
    public abstract Object getValueAt(int var1, int var2);

    public abstract Class getColumnClass(int var1);

    public abstract Type getType();

    public abstract boolean isSortAllowed(Object var1);

    public abstract int getDownloadSize();

    public abstract boolean needsRestart();

    protected abstract Comparator<Unit> getComparator(Object var1, boolean var2);

    public abstract void setUnits(List<UpdateUnit> var1);

    public String getTabTooltipText() {
        return null;
    }

    public abstract String getTabTitle();

    public final String getDecoratedTabTitle() {
        int n;
        int n2 = this.getItemCount();
        String string = n2 == (n = this.getRawItemCount()) ? String.valueOf(n) : NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_Tabs_CountFormat", (Object)n2, (Object)n);
        String string2 = NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_Tabs_NameFormat", (Object)this.getTabTitle(), (Object)string);
        return n == 0 ? this.getTabTitle() : string2;
    }

    public boolean canBePrimaryTab() {
        return true;
    }

    public abstract int getTabIndex();

    public boolean isTabEnabled() {
        return true;
    }

    public String getToolTipText(int n, int n2) {
        String string = null;
        if (n2 == 0) {
            string = this.getTooltipForCheckBox(n);
        } else if (n2 == 1) {
            string = (String)this.getValueAt(n, 1);
        }
        return string;
    }

    public int getMinWidth(JTableHeader jTableHeader, int n) {
        return jTableHeader.getHeaderRect((int)n).width;
    }

    public abstract int getPreferredWidth(JTableHeader var1, int var2);

    protected Comparator<Unit> getDefaultComparator() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit unit, Unit unit2) {
                return Unit.compareCategories(unit, unit2);
            }
        };
    }

    public final void sort(Object object, boolean bl) {
        if (object == null) {
            this.setUnitComparator(this.getDefaultComparator());
        } else {
            this.setUnitComparator(this.getComparator(object, bl));
        }
        this.fireTableDataChanged();
    }

    private String getTooltipForCheckBox(int n) {
        String string = null;
        switch (this.getType()) {
            case INSTALLED: {
                string = "UnitTab_TooltipCheckBox_INSTALLED";
                break;
            }
            case UPDATE: {
                string = "UnitTab_TooltipCheckBox_UPDATE";
                break;
            }
            case AVAILABLE: {
                string = "UnitTab_TooltipCheckBox_AVAILABLE";
                break;
            }
            case LOCAL: {
                string = "UnitTab_TooltipCheckBox_LOCAL";
            }
        }
        return string != null ? NbBundle.getMessage(UnitCategoryTableModel.class, (String)string, (Object)((String)this.getValueAt(n, 1))) : null;
    }

    private final void setData(List<UnitCategory> list, Comparator<Unit> comparator) {
        this.unitCmp = comparator != null ? comparator : this.getDefaultComparator();
        this.featuretData = null;
        if (list != null) {
            this.unitData = Collections.emptyList();
            this.unitData = new ArrayList<Unit>();
            for (UnitCategory object : list) {
                this.unitData.addAll(object.getUnits());
            }
            this.standAloneModules = new ArrayList<Unit>();
            for (Unit unit : this.unitData) {
                if (!UpdateManager.TYPE.STANDALONE_MODULE.equals((Object)unit.updateUnit.getType())) continue;
                this.standAloneModules.add(unit);
            }
            this.computeExtensionState();
        } else assert (this.unitData != null);
        if (comparator != null) {
            Collections.sort(this.unitData, comparator);
        }
        this.fireTableDataChanged();
    }

    private void computeExtensionState() {
        boolean bl = UnitCategoryTableModel.isExpandableType(this.getType()) && !Utilities.modulesOnly() && !this.getVisibleUnits(this.getFeatureList(), this.getFilter(), false).isEmpty() && !this.getVisibleUnits(this.standAloneModules, this.getFilter(), false).isEmpty();
        this.isExpanded = bl ? Boolean.valueOf(NbPreferences.forModule(UnitCategoryTableModel.class).getBoolean(EXPAND_STATE, false)) : null;
    }

    public void setUnitComparator(Comparator<Unit> comparator) {
        this.setData(null, comparator);
    }

    public final void setData(List<UnitCategory> list) {
        this.setData(list, this.unitCmp);
    }

    public void setFilter(final String string, final Runnable runnable) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<UnitCategoryTableModel> clazz = UnitCategoryTableModel.class;
                synchronized (UnitCategoryTableModel.class) {
                    UnitCategoryTableModel.this.filter = string.toLowerCase();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    UnitCategoryTableModel.this.computeExtensionState();
                    UnitCategoryTableModel.this.fireFilterChange();
                    if (runnable != null) {
                        runnable.run();
                    }
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilter() {
        Class<UnitCategoryTableModel> clazz = UnitCategoryTableModel.class;
        synchronized (UnitCategoryTableModel.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.filter == null ? "" : this.filter;
        }
    }

    public void addUpdateUnitListener(UpdateUnitListener updateUnitListener) {
        this.listeners.add(updateUnitListener);
    }

    public void removeUpdateUnitListener(UpdateUnitListener updateUnitListener) {
        this.listeners.remove(updateUnitListener);
    }

    void fireUpdataUnitChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (UpdateUnitListener updateUnitListener : this.listeners) {
            updateUnitListener.updateUnitsChanged();
        }
    }

    void fireButtonsChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (UpdateUnitListener updateUnitListener : this.listeners) {
            updateUnitListener.buttonsChanged();
        }
    }

    void fireFilterChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (UpdateUnitListener updateUnitListener : this.listeners) {
            updateUnitListener.filterChanged();
        }
    }

    List<Unit> getVisibleUnits() {
        return this.getVisibleUnits(this.getUnits(), this.getFilter(), true);
    }

    private List<Unit> getVisibleUnits(List<Unit> list, String string, boolean bl) {
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        for (Unit unit : list) {
            if (bl) {
                if (!unit.isVisible(string) || this.isExpandable() && !this.isExpanded() && !UpdateManager.TYPE.FEATURE.equals((Object)unit.updateUnit.getType())) continue;
                arrayList.add(unit);
                continue;
            }
            if (!unit.isVisible(string)) continue;
            arrayList.add(unit);
        }
        return arrayList;
    }

    @Override
    public int getRowCount() {
        int n = this.getVisibleUnits().size();
        return this.isExpansionControlPresent() ? n + 1 : n;
    }

    public int getRawItemCount() {
        return this.unitData.size();
    }

    public int getItemCount() {
        return this.getVisibleUnits().size();
    }

    public Collection<Unit> getMarkedUnits() {
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        List<Unit> list = this.getUnits();
        for (Unit unit : list) {
            if (!unit.isMarked()) continue;
            arrayList.add(unit);
        }
        return arrayList;
    }

    public Unit getUnitAtRow(int n) {
        return this.getVisibleUnits().size() <= n ? null : this.getVisibleUnits().get(n);
    }

    public boolean isExpansionControlAtRow(int n) {
        return n + 1 == this.getRowCount() && this.isExpansionControlPresent();
    }

    public String getExpansionControlText() {
        assert (this.isExpansionControlPresent());
        String string = this.isExpanded() ? "Less_Command_Text" : "More_Command_Text";
        return NbBundle.getMessage(UnitCategoryTableModel.class, (String)string, (Object)this.getVisibleUnits(this.getStandAloneModules(), this.getFilter(), false).size());
    }

    public boolean isExpandable() {
        return this.isExpanded != null;
    }

    public boolean isExpansionControlPresent() {
        return this.isExpandable() && !this.getFeatureList().isEmpty() && !this.getVisibleUnits(this.getStandAloneModules(), this.getFilter(), false).isEmpty();
    }

    public void setExpanded(Boolean bl) {
        this.isExpanded = bl;
        this.featuretData = null;
        if (bl != null) {
            NbPreferences.forModule(UnitCategoryTableModel.class).putBoolean(EXPAND_STATE, bl);
        }
    }

    public boolean isExpanded() {
        boolean bl = this.isExpandable();
        if (bl) {
            bl = this.isExpanded != null && this.isExpanded != false;
        }
        return bl;
    }

    public boolean isCollapsed() {
        boolean bl = this.isExpandable();
        if (bl) {
            bl = this.isExpanded != null && this.isExpanded == false;
        }
        return bl;
    }

    private List<Unit> getFeatureList() {
        if (this.featuretData == null) {
            this.featuretData = new ArrayList<Unit>(this.unitData);
            this.featuretData.removeAll(this.getStandAloneModules());
            if (this.unitCmp != null) {
                Collections.sort(this.featuretData, this.unitCmp);
            }
        }
        return this.featuretData;
    }

    List<Unit> getStandAloneModules() {
        List<Unit> list = this.standAloneModules;
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public static boolean isExpandableType(Type type) {
        return type.equals((Object)Type.AVAILABLE) || type.equals((Object)Type.UPDATE);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.isExpansionControlAtRow(n)) {
            return false;
        }
        RequestProcessor.Task task = PluginManagerUI.getRunningTask();
        return (task == null || task.isFinished()) && n2 == 0 && Boolean.class.equals((Object)this.getColumnClass(n2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INSTALLED,
        UPDATE,
        AVAILABLE,
        LOCAL;

    }
}

