/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.primavera.Record;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.utility.BooleanUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimaveraReader {
    private ProjectFile m_project;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ProjectCalendar> m_calMap = new HashMap<Integer, ProjectCalendar>();
    private DateFormat m_calendarTimeFormat = new SimpleDateFormat("HH:mm");
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, TaskType> TASK_TYPE_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final Map<String, CurrencySymbolPosition> CURRENCY_SYMBOL_POSITION_MAP;

    public PrimaveraReader() {
        this.m_project = new ProjectFile();
        this.m_project.setAutoTaskUniqueID(false);
        this.m_project.setAutoResourceUniqueID(false);
        this.m_project.setAutoCalendarUniqueID(true);
        this.m_project.setAutoAssignmentUniqueID(false);
        this.m_project.setAutoWBS(false);
        this.m_project.setTaskFieldAlias(TaskField.DATE1, "Suspend Date");
        this.m_project.setTaskFieldAlias(TaskField.DATE2, "Resume Date");
        this.m_project.setTaskFieldAlias(TaskField.TEXT1, "Code");
        this.m_project.setResourceFieldAlias(ResourceField.NUMBER1, "Parent Resource Unique ID");
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public void processProjectHeader(List<Row> list) {
        if (!list.isEmpty()) {
            Row row = list.get(0);
            ProjectHeader projectHeader = this.m_project.getProjectHeader();
            projectHeader.setCreationDate(row.getDate("create_date"));
            projectHeader.setFinishDate(row.getDate("plan_end_date"));
            projectHeader.setName(row.getString("proj_short_name"));
            projectHeader.setStartDate(row.getDate("plan_start_date"));
            projectHeader.setProjectTitle(row.getString("proj_short_name"));
            projectHeader.setDefaultTaskType(TASK_TYPE_MAP.get(row.getString("def_duration_type")));
        }
    }

    public void processCalendars(List<Row> list) {
        for (Row row : list) {
            String string = row.getString("clndr_type");
            ProjectCalendar projectCalendar = string != null && string.toUpperCase().equals("CA_RSRC") ? this.m_project.addResourceCalendar() : this.m_project.addBaseCalendar();
            Integer n = row.getInteger("clndr_id");
            this.m_calMap.put(n, projectCalendar);
            projectCalendar.setName(row.getString("clndr_name"));
            String string2 = row.getString("clndr_data");
            if (string2 != null && !string2.isEmpty()) {
                Object object;
                Record record = new Record(string2);
                Record record2 = record.getChild("DaysOfWeek");
                if (record2 != null) {
                    object = record2.getChildren().iterator();
                    while (object.hasNext()) {
                        Record record3 = (Record)object.next();
                        Day day = Day.getInstance(Integer.parseInt(record3.getField()));
                        List<Record> list2 = record3.getChildren();
                        if (list2.size() == 0) {
                            projectCalendar.setWorkingDay(day, false);
                            continue;
                        }
                        projectCalendar.setWorkingDay(day, true);
                        ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
                        for (Record record4 : list2) {
                            if (record4.getValue() == null) continue;
                            String[] stringArray = record4.getValue().split("\\|");
                            try {
                                Date date = this.m_calendarTimeFormat.parse(stringArray[1]);
                                Date date2 = this.m_calendarTimeFormat.parse(stringArray[3]);
                                projectCalendarHours.addRange(new DateRange(date, date2));
                            }
                            catch (ParseException parseException) {}
                        }
                    }
                }
                if ((object = record.getChild("Exceptions")) == null) continue;
                for (Record record5 : ((Record)object).getChildren()) {
                    int n2 = Integer.parseInt(record5.getValue().split("\\|")[1]);
                    int n3 = n2 - 25567 - 2;
                    Date date = new Date((long)n3 * 24L * 60L * 60L * 1000L);
                    projectCalendar.addCalendarException(date, date);
                }
            }
            this.m_project.fireCalendarReadEvent(projectCalendar);
        }
    }

    public void processResources(List<Row> list) {
        for (Row row : list) {
            ProjectCalendar projectCalendar;
            Resource resource = this.m_project.addResource();
            resource.setUniqueID(row.getInteger("rsrc_id"));
            resource.setName(row.getString("rsrc_name"));
            resource.setCode(row.getString("employee_code"));
            resource.setEmailAddress(row.getString("email_addr"));
            resource.setNotes(row.getString("rsrc_notes"));
            resource.setCreationDate(row.getDate("create_date"));
            resource.setType(RESOURCE_TYPE_MAP.get(row.getString("rsrc_type")));
            resource.setInitials(row.getString("rsrc_short_name"));
            resource.setNumber1(row.getInteger("parent_rsrc_id"));
            Integer n = row.getInteger("clndr_id");
            if (n != null && (projectCalendar = this.m_calMap.get(n)) != null) {
                ProjectCalendar projectCalendar2;
                if (!projectCalendar.isDerived()) {
                    projectCalendar2 = this.m_project.addResourceCalendar();
                    projectCalendar2.setParent(projectCalendar);
                    projectCalendar2.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                    resource.setResourceCalendar(projectCalendar2);
                } else if (projectCalendar.getResource() == null) {
                    resource.setResourceCalendar(projectCalendar);
                } else {
                    projectCalendar2 = this.m_project.addResourceCalendar();
                    projectCalendar2.copy(projectCalendar);
                    resource.setResourceCalendar(projectCalendar2);
                }
            }
            this.m_project.fireResourceReadEvent(resource);
        }
    }

    public void processTasks(List<Row> list, List<Row> list2) {
        Comparable<Integer> comparable;
        HashSet<Comparable<Integer>> hashSet = new HashSet<Comparable<Integer>>();
        for (Row object2 : list) {
            Task task = this.m_project.addTask();
            comparable = object2.getInteger("wbs_id");
            hashSet.add(comparable);
            task.setUniqueID((Integer)comparable);
            task.setName(object2.getString("wbs_name"));
            task.setBaselineCost(object2.getDouble("orig_cost"));
            task.setRemainingCost(object2.getDouble("indep_remain_total_cost"));
            task.setRemainingWork(object2.getDuration("indep_remain_work_qty"));
            task.setStart(object2.getDate("anticip_start_date"));
            task.setFinish(object2.getDate("anticip_end_date"));
            task.setDate1(object2.getDate("suspend_date"));
            task.setDate2(object2.getDate("resume_date"));
            task.setText1(object2.getString("task_code"));
            task.setWBS(object2.getString("wbs_short_name"));
        }
        this.m_project.getChildTasks().clear();
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("wbs_id"));
            comparable = this.m_project.getTaskByUniqueID(row.getInteger("parent_wbs_id"));
            if (comparable == null) {
                this.m_project.getChildTasks().add(task);
                continue;
            }
            this.m_project.getChildTasks().remove(task);
            ((Task)comparable).getChildTasks().add(task);
            task.setWBS(((Task)comparable).getWBS() + "." + task.getWBS());
        }
        int n = 1;
        this.m_clashMap.clear();
        for (Row row : list2) {
            Comparable<Integer> comparable2;
            comparable = row.getInteger("task_id");
            if (hashSet.contains(comparable)) {
                while (hashSet.contains(n)) {
                    ++n;
                }
                comparable2 = n;
                this.m_clashMap.put((Integer)comparable, (Integer)comparable2);
                comparable = comparable2;
            }
            hashSet.add(comparable);
            Integer n2 = row.getInteger("wbs_id");
            Task task = this.m_project.getTaskByUniqueID(n2);
            comparable2 = task == null ? this.m_project.addTask() : task.addTask();
            ((Task)comparable2).setUniqueID((Integer)comparable);
            ((Task)comparable2).setPercentageComplete(row.getDouble("phys_complete_pct"));
            ((Task)comparable2).setName(row.getString("task_name"));
            ((Task)comparable2).setRemainingDuration(row.getDuration("remain_drtn_hr_cnt"));
            ((Task)comparable2).setActualWork(row.getDuration("act_work_qty"));
            ((Task)comparable2).setRemainingWork(row.getDuration("remain_work_qty"));
            ((Task)comparable2).setBaselineWork(row.getDuration("target_work_qty"));
            ((Task)comparable2).setBaselineDuration(row.getDuration("target_drtn_hr_cnt"));
            ((Task)comparable2).setConstraintDate(row.getDate("cstr_date"));
            ((Task)comparable2).setActualStart(row.getDate("act_start_date"));
            ((Task)comparable2).setActualFinish(row.getDate("act_end_date"));
            ((Task)comparable2).setLateStart(row.getDate("late_start_date"));
            ((Task)comparable2).setLateFinish(row.getDate("late_end_date"));
            ((Task)comparable2).setFinish(row.getDate("expect_end_date"));
            ((Task)comparable2).setEarlyStart(row.getDate("early_start_date"));
            ((Task)comparable2).setEarlyFinish(row.getDate("early_end_date"));
            ((Task)comparable2).setBaselineStart(row.getDate("target_start_date"));
            ((Task)comparable2).setBaselineFinish(row.getDate("target_end_date"));
            ((Task)comparable2).setConstraintType(CONSTRAINT_TYPE_MAP.get(row.getString("cstr_type")));
            ((Task)comparable2).setPriority(PRIORITY_MAP.get(row.getString("priority_type")));
            ((Task)comparable2).setCreateDate(row.getDate("create_date"));
            ((Task)comparable2).setType(TASK_TYPE_MAP.get(row.getString("duration_type")));
            ((Task)comparable2).setMilestone(BooleanUtility.getBoolean(MILESTONE_MAP.get(row.getString("task_type"))));
            ((Task)comparable2).setFreeSlack(row.getDuration("free_float_hr_cnt"));
            ((Task)comparable2).setTotalSlack(row.getDuration("total_float_hr_cnt"));
            Integer n3 = row.getInteger("clndr_id");
            ProjectCalendar projectCalendar = this.m_calMap.get(n3);
            ((Task)comparable2).setCalendar(projectCalendar);
            this.populateField((FieldContainer)((Object)comparable2), TaskField.START, TaskField.BASELINE_START, TaskField.ACTUAL_START);
            this.populateField((FieldContainer)((Object)comparable2), TaskField.FINISH, TaskField.BASELINE_FINISH, TaskField.ACTUAL_FINISH);
            this.populateField((FieldContainer)((Object)comparable2), TaskField.WORK, TaskField.BASELINE_WORK, TaskField.ACTUAL_WORK);
            this.m_project.fireTaskReadEvent((Task)comparable2);
        }
        this.updateStructure();
    }

    private void populateField(FieldContainer fieldContainer, FieldType fieldType, FieldType fieldType2, FieldType fieldType3) {
        Object object = fieldContainer.getCachedValue(fieldType3);
        if (object == null) {
            object = fieldContainer.getCachedValue(fieldType2);
        }
        fieldContainer.set(fieldType, object);
    }

    private void updateStructure() {
        int n = 1;
        Integer n2 = 1;
        for (Task task : this.m_project.getChildTasks()) {
            n = this.updateStructure(n, task, n2);
        }
    }

    private int updateStructure(int n, Task task, Integer n2) {
        task.setID(n++);
        task.setOutlineLevel(n2);
        n2 = n2 + 1;
        for (Task task2 : task.getChildTasks()) {
            n = this.updateStructure(n, task2, n2);
        }
        return n;
    }

    public void processPredecessors(List<Row> list) {
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("task_id")));
            Task task2 = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("pred_task_id")));
            if (task == null || task2 == null) continue;
            RelationType relationType = RELATION_TYPE_MAP.get(row.getString("pred_type"));
            Duration duration = row.getDuration("lag_hr_cnt");
            Relation relation = task.addPredecessor(task2, relationType, duration);
            this.m_project.fireRelationReadEvent(relation);
        }
    }

    public void processAssignments(List<Row> list) {
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("task_id")));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("rsrc_id"));
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setUniqueID(row.getInteger("taskrsrc_id"));
            resourceAssignment.setRemainingWork(row.getDuration("remain_qty"));
            resourceAssignment.setBaselineWork(row.getDuration("target_qty"));
            resourceAssignment.setActualWork(row.getDuration("act_reg_qty"));
            resourceAssignment.setBaselineCost(row.getDouble("target_cost"));
            resourceAssignment.setActualCost(row.getDouble("act_reg_cost"));
            resourceAssignment.setActualStart(row.getDate("act_start_date"));
            resourceAssignment.setActualFinish(row.getDate("act_end_date"));
            resourceAssignment.setBaselineStart(row.getDate("target_start_date"));
            resourceAssignment.setBaselineFinish(row.getDate("target_end_date"));
            resourceAssignment.setDelay(row.getDuration("target_lag_drtn_hr_cnt"));
            this.populateField(resourceAssignment, AssignmentField.WORK, AssignmentField.BASELINE_WORK, AssignmentField.ACTUAL_WORK);
            this.populateField(resourceAssignment, AssignmentField.COST, AssignmentField.BASELINE_COST, AssignmentField.ACTUAL_COST);
            this.populateField(resourceAssignment, AssignmentField.START, AssignmentField.BASELINE_START, AssignmentField.ACTUAL_START);
            this.populateField(resourceAssignment, AssignmentField.FINISH, AssignmentField.BASELINE_FINISH, AssignmentField.ACTUAL_FINISH);
            this.m_project.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    public void processDefaultCurrency(Row row) {
        ProjectHeader projectHeader = this.m_project.getProjectHeader();
        projectHeader.setCurrencySymbol(row.getString("curr_symbol"));
        projectHeader.setSymbolPosition(CURRENCY_SYMBOL_POSITION_MAP.get(row.getString("pos_curr_fmt_type")));
        projectHeader.setCurrencyDigits(row.getInteger("decimal_digit_cnt"));
        projectHeader.setThousandsSeparator(row.getString("digit_group_symbol").charAt(0));
        projectHeader.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
    }

    private Integer mapTaskID(Integer n) {
        Integer n2 = this.m_clashMap.get(n);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    static {
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Mat", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("RT_Equip", ResourceType.WORK);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("CS_MSO", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MSOB", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MSOA", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEO", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MEOB", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEOA", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_ALAP", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("CS_MANDSTART", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MANDFIN", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("PT_Top", Priority.getInstance(900));
        PRIORITY_MAP.put("PT_High", Priority.getInstance(600));
        PRIORITY_MAP.put("PT_Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("PT_Low", Priority.getInstance(400));
        PRIORITY_MAP.put("PT_Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("PR_FS", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("PR_FF", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("PR_SS", RelationType.START_START);
        RELATION_TYPE_MAP.put("PR_SF", RelationType.START_FINISH);
        TASK_TYPE_MAP = new HashMap<String, TaskType>();
        TASK_TYPE_MAP.put("DT_FixedDrtn", TaskType.FIXED_DURATION);
        TASK_TYPE_MAP.put("DT_FixedQty", TaskType.FIXED_UNITS);
        TASK_TYPE_MAP.put("DT_FixedDUR2", TaskType.FIXED_WORK);
        TASK_TYPE_MAP.put("DT_FixedRate", TaskType.FIXED_WORK);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("TT_Task", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Rsrc", Boolean.FALSE);
        MILESTONE_MAP.put("TT_LOE", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Mile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_FinMile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_WBS", Boolean.FALSE);
        CURRENCY_SYMBOL_POSITION_MAP = new HashMap<String, CurrencySymbolPosition>();
        CURRENCY_SYMBOL_POSITION_MAP.put("#1.1", CurrencySymbolPosition.BEFORE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1#", CurrencySymbolPosition.AFTER);
        CURRENCY_SYMBOL_POSITION_MAP.put("# 1.1", CurrencySymbolPosition.BEFORE_WITH_SPACE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1 #", CurrencySymbolPosition.AFTER_WITH_SPACE);
    }
}

