/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.List;
import java.util.Set;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SplitTaskFactory;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkData;
import net.sf.mpxj.TimephasedWorkNormaliser;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPTimephasedBaselineCostNormaliser;
import net.sf.mpxj.mpp.MPPTimephasedBaselineWorkNormaliser;
import net.sf.mpxj.mpp.MPPTimephasedWorkNormaliser;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.TimephasedDataFactory;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.RTFUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAssignmentFactory {
    private static final Integer MPP9_CREATION_DATA = 138;

    public void process(ProjectFile projectFile, FieldMap fieldMap, boolean bl, boolean bl2, VarMeta varMeta, Var2Data var2Data, FixedMeta fixedMeta, FixedData fixedData, FixedData fixedData2) {
        Set<Integer> set = varMeta.getUniqueIdentifierSet();
        int n = fixedMeta.getItemCount();
        TimephasedDataFactory timephasedDataFactory = new TimephasedDataFactory();
        SplitTaskFactory splitTaskFactory = new SplitTaskFactory();
        MPPTimephasedWorkNormaliser mPPTimephasedWorkNormaliser = new MPPTimephasedWorkNormaliser();
        MPPTimephasedBaselineWorkNormaliser mPPTimephasedBaselineWorkNormaliser = new MPPTimephasedBaselineWorkNormaliser();
        MPPTimephasedBaselineCostNormaliser mPPTimephasedBaselineCostNormaliser = new MPPTimephasedBaselineCostNormaliser();
        ProjectCalendar projectCalendar = projectFile.getBaselineCalendar();
        RTFUtility rTFUtility = new RTFUtility();
        for (int i = 0; i < n; ++i) {
            Task task;
            Object object;
            int n2;
            Integer n3;
            int n4;
            byte[] byArray;
            byte[] byArray2 = fixedMeta.getByteArrayValue(i);
            if (byArray2[0] != 0 || (byArray = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(n4 = MPPUtility.getInt(byArray2, 4)))) == null) continue;
            if (byArray.length <= fieldMap.getMaxFixedDataOffset(0)) {
                byte[] byArray3 = new byte[fieldMap.getMaxFixedDataOffset(0) + 8];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                byArray = byArray3;
            }
            if (!set.contains(n3 = Integer.valueOf(n2 = MPPUtility.getInt(byArray, fieldMap.getFixedDataOffset(AssignmentField.UNIQUE_ID))))) continue;
            byte[] byArray4 = null;
            if (fixedData2 != null) {
                byArray4 = fixedData2.getByteArrayValue(i);
            }
            ResourceAssignment resourceAssignment = new ResourceAssignment(projectFile);
            resourceAssignment.disableEvents();
            fieldMap.populateContainer(resourceAssignment, n3, new byte[][]{byArray, byArray4}, var2Data);
            resourceAssignment.enableEvents();
            if (fieldMap.getFieldLocation(AssignmentField.FLAG1) != FieldMap.FieldLocation.VAR_DATA) {
                resourceAssignment.setFlag(1, (byArray2[28] & 0x80) != 0);
                resourceAssignment.setFlag(2, (byArray2[29] & 1) != 0);
                resourceAssignment.setFlag(3, (byArray2[29] & 2) != 0);
                resourceAssignment.setFlag(4, (byArray2[29] & 4) != 0);
                resourceAssignment.setFlag(5, (byArray2[29] & 8) != 0);
                resourceAssignment.setFlag(6, (byArray2[29] & 0x10) != 0);
                resourceAssignment.setFlag(7, (byArray2[29] & 0x20) != 0);
                resourceAssignment.setFlag(8, (byArray2[29] & 0x40) != 0);
                resourceAssignment.setFlag(9, (byArray2[29] & 0x80) != 0);
                resourceAssignment.setFlag(10, (byArray2[30] & 1) != 0);
                resourceAssignment.setFlag(11, (byArray2[30] & 2) != 0);
                resourceAssignment.setFlag(12, (byArray2[30] & 4) != 0);
                resourceAssignment.setFlag(13, (byArray2[30] & 8) != 0);
                resourceAssignment.setFlag(14, (byArray2[30] & 0x10) != 0);
                resourceAssignment.setFlag(15, (byArray2[30] & 0x20) != 0);
                resourceAssignment.setFlag(16, (byArray2[30] & 0x40) != 0);
                resourceAssignment.setFlag(17, (byArray2[30] & 0x80) != 0);
                resourceAssignment.setFlag(18, (byArray2[31] & 1) != 0);
                resourceAssignment.setFlag(19, (byArray2[31] & 2) != 0);
                resourceAssignment.setFlag(20, (byArray2[31] & 4) != 0);
            }
            if (fieldMap.getFieldLocation(AssignmentField.CONFIRMED) != FieldMap.FieldLocation.VAR_DATA) {
                resourceAssignment.setConfirmed((byArray2[8] & 0x80) != 0);
            }
            if (fieldMap.getFieldLocation(AssignmentField.RESPONSE_PENDING) != FieldMap.FieldLocation.VAR_DATA) {
                resourceAssignment.setResponsePending((byArray2[9] & 1) != 0);
            }
            if (fieldMap.getFieldLocation(AssignmentField.TEAM_STATUS_PENDING) != FieldMap.FieldLocation.VAR_DATA) {
                resourceAssignment.setTeamStatusPending((byArray2[10] & 2) != 0);
            }
            this.processHyperlinkData(resourceAssignment, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.HYPERLINK_DATA)));
            if (projectFile.getMppFileType() == 9 && resourceAssignment.getCreateDate() == null && (object = (Object)var2Data.getByteArray(n3, MPP9_CREATION_DATA)) != null && ((Object)object).length >= 28) {
                resourceAssignment.setCreateDate(MPPUtility.getTimestamp((byte[])object, 24));
            }
            if ((object = resourceAssignment.getNotes()) != null) {
                if (!bl2) {
                    object = rTFUtility.strip((String)object);
                }
                resourceAssignment.setNotes((String)object);
            }
            if ((task = projectFile.getTaskByUniqueID(resourceAssignment.getTaskUniqueID())) == null) continue;
            task.addResourceAssignment(resourceAssignment);
            Resource resource = projectFile.getResourceByUniqueID(resourceAssignment.getResourceUniqueID());
            ProjectCalendar projectCalendar2 = null;
            if (resource != null) {
                projectCalendar2 = resource.getResourceCalendar();
            }
            if (projectCalendar2 == null || task.getIgnoreResourceCalendar()) {
                projectCalendar2 = task.getCalendar();
            }
            if (projectCalendar2 == null) {
                projectCalendar2 = projectFile.getCalendar();
            }
            resourceAssignment.setTimephasedBaselineWork(0, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(1, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE1_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(2, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE2_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(3, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE3_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(4, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE4_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(5, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE5_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(6, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE6_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(7, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE7_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(8, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE8_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(9, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE9_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineWork(10, timephasedDataFactory.getBaselineWork(resourceAssignment, projectCalendar, mPPTimephasedBaselineWorkNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE10_WORK)), !bl));
            resourceAssignment.setTimephasedBaselineCost(0, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(1, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE1_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(2, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE2_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(3, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE3_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(4, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE4_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(5, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE5_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(6, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE6_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(7, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE7_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(8, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE8_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(9, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE9_COST)), !bl));
            resourceAssignment.setTimephasedBaselineCost(10, timephasedDataFactory.getBaselineCost(projectCalendar, mPPTimephasedBaselineCostNormaliser, var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE10_COST)), !bl));
            byte[] byArray5 = var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_ACTUAL_WORK));
            byte[] byArray6 = var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_WORK));
            byte[] byArray7 = var2Data.getByteArray(n3, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_ACTUAL_OVERTIME_WORK));
            List<TimephasedWork> list = timephasedDataFactory.getCompleteWork(projectCalendar2, resourceAssignment.getStart(), byArray5);
            List<TimephasedWork> list2 = timephasedDataFactory.getPlannedWork(projectCalendar2, resourceAssignment.getStart(), resourceAssignment.getUnits().doubleValue(), byArray6, list);
            List<TimephasedWork> list3 = timephasedDataFactory.getCompleteWork(projectCalendar2, resourceAssignment.getStart(), byArray7);
            resourceAssignment.setActualStart(list.isEmpty() ? null : resourceAssignment.getStart());
            resourceAssignment.setActualFinish(resourceAssignment.getRemainingWork().getDuration() == 0.0 && resource != null ? resourceAssignment.getFinish() : null);
            if (task.getSplits() != null && task.getSplits().isEmpty()) {
                splitTaskFactory.processSplitData(task, list, list2);
            }
            this.createTimephasedData(projectFile, resourceAssignment, list2, list);
            resourceAssignment.setTimephasedWork(new TimephasedWorkData(projectCalendar2, mPPTimephasedWorkNormaliser, list2, !bl));
            resourceAssignment.setTimephasedActualWork(new TimephasedWorkData(projectCalendar2, mPPTimephasedWorkNormaliser, list, !bl));
            resourceAssignment.setTimephasedActualOvertimeWork(new TimephasedWorkData(projectCalendar2, mPPTimephasedWorkNormaliser, list3, !bl));
            if (byArray6 != null) {
                if (timephasedDataFactory.getWorkModified(list2)) {
                    resourceAssignment.setWorkContour(WorkContour.CONTOURED);
                } else if (byArray6.length >= 30) {
                    resourceAssignment.setWorkContour(WorkContour.getInstance(MPPUtility.getShort(byArray6, 28)));
                } else {
                    resourceAssignment.setWorkContour(WorkContour.FLAT);
                }
            }
            projectFile.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    private void processHyperlinkData(ResourceAssignment resourceAssignment, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string3.length() + 1) * 2;
            String string4 = MPPUtility.getUnicodeString(byArray, n += 12);
            resourceAssignment.setHyperlink(string);
            resourceAssignment.setHyperlinkAddress(string2);
            resourceAssignment.setHyperlinkSubAddress(string3);
            resourceAssignment.setHyperlinkScreenTip(string4);
        }
    }

    private void createTimephasedData(ProjectFile projectFile, ResourceAssignment resourceAssignment, List<TimephasedWork> list, List<TimephasedWork> list2) {
        if (list.isEmpty() && list2.isEmpty()) {
            Duration duration;
            Duration duration2 = resourceAssignment.getWork().convertUnits(TimeUnit.MINUTES, projectFile.getProjectHeader());
            if (resourceAssignment.getResource() == null || resourceAssignment.getResource().getType() == ResourceType.WORK) {
                duration = duration2.getDuration() == 0.0 ? duration2 : TimephasedWorkNormaliser.DEFAULT_NORMALIZER_WORK_PER_DAY;
                int n = NumberUtility.getInt(resourceAssignment.getUnits());
                if (n != 100) {
                    duration = Duration.getInstance(duration.getDuration() * (double)n / 100.0, duration.getUnits());
                }
            } else if (resourceAssignment.getVariableRateUnits() == null) {
                Duration duration3 = resourceAssignment.getCalendar().getWork(resourceAssignment.getStart(), resourceAssignment.getFinish(), TimeUnit.DAYS);
                double d = NumberUtility.getDouble(resourceAssignment.getUnits());
                double d2 = d * 60.0 / (duration3.getDuration() * 100.0);
                duration = Duration.getInstance(d2, TimeUnit.MINUTES);
            } else {
                double d = NumberUtility.getDouble(resourceAssignment.getUnits());
                duration = TimephasedWorkNormaliser.DEFAULT_NORMALIZER_WORK_PER_DAY;
                Duration duration4 = duration.convertUnits(TimeUnit.HOURS, projectFile.getProjectHeader());
                double d3 = d * duration4.getDuration() / 100.0;
                double d4 = d3 * 60.0;
                duration = Duration.getInstance(d4, TimeUnit.MINUTES);
            }
            Duration duration5 = resourceAssignment.getOvertimeWork();
            if (duration5 != null && duration5.getDuration() != 0.0) {
                Duration duration6 = duration5.convertUnits(TimeUnit.MINUTES, projectFile.getProjectHeader());
                duration2 = Duration.getInstance(duration2.getDuration() - duration6.getDuration(), TimeUnit.MINUTES);
            }
            TimephasedWork timephasedWork = new TimephasedWork();
            timephasedWork.setStart(resourceAssignment.getStart());
            timephasedWork.setAmountPerDay(duration);
            timephasedWork.setModified(false);
            timephasedWork.setFinish(resourceAssignment.getFinish());
            timephasedWork.setTotalAmount(duration2);
            list.add(timephasedWork);
        }
    }
}

