/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.View;
import net.sf.mpxj.mpp.AvailabilityFactory;
import net.sf.mpxj.mpp.CostRateTableFactory;
import net.sf.mpxj.mpp.EncryptedDocumentInputStream;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FieldMap9;
import net.sf.mpxj.mpp.FilterReader9;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GraphicalIndicatorReader;
import net.sf.mpxj.mpp.GroupReader9;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.ProjectHeaderReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props9;
import net.sf.mpxj.mpp.PropsBlock;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.ResourceAssignmentFactory;
import net.sf.mpxj.mpp.TableFactory;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta9;
import net.sf.mpxj.mpp.ViewFactory9;
import net.sf.mpxj.mpp.ViewStateReader9;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Pair;
import net.sf.mpxj.utility.RTFUtility;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MPP9Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private DirectoryEntry m_root;
    private HashMap<Integer, ProjectCalendar> m_resourceMap;
    private Var2Data m_outlineCodeVarData;
    private Props9 m_projectProps;
    private Map<Integer, FontBase> m_fontBases;
    private Map<Integer, SubProject> m_taskSubProjects;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private int m_highestEmptyTaskID;
    private static final int SUBPROJECT_LISTEND = 771;
    private static final int SUBPROJECT_TASKUNIQUEID0 = 0;
    private static final int SUBPROJECT_TASKUNIQUEID1 = 187957248;
    private static final int SUBPROJECT_TASKUNIQUEID2 = 0xABB0000;
    private static final int SUBPROJECT_TASKUNIQUEID3 = 94437376;
    private static final int SUBPROJECT_TASKUNIQUEID4 = 49741824;
    private static final int SUBPROJECT_TASKUNIQUEID5 = 0x7010000;
    private static final Integer CALENDAR_NAME = 1;
    private static final Integer CALENDAR_DATA = 3;
    private static final Integer TABLE_COLUMN_DATA_STANDARD = 1;
    private static final Integer TABLE_COLUMN_DATA_ENTERPRISE = 2;
    private static final Integer TABLE_COLUMN_DATA_BASELINE = null;
    private static final Integer OUTLINECODE_DATA = 1;
    private static final int DURATION_CONFIRMED_MASK = 32;
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};

    MPP9Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws MPXJException, IOException {
        try {
            Object object;
            Props9 props9 = new Props9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Props9")));
            projectFile.setProjectFilePath(props9.getUnicodeString(Props.PROJECT_FILE_PATH));
            projectFile.setEncoded(props9.getByte(Props.PASSWORD_FLAG) != 0);
            projectFile.setEncryptionCode(props9.getByte(Props.ENCRYPTION_CODE));
            if (!((props9.getByte(Props.PASSWORD_FLAG) & 1) == 0 || (object = MPPUtility.decodePassword(props9.getByteArray(Props.PROTECTION_PASSWORD_HASH), projectFile.getEncryptionCode())) == null || ((String)object).length() <= 0 || mPPReader.getReadPassword() != null && mPPReader.getReadPassword().matches((String)object))) {
                throw new MPXJException("File is password protected. Please enter password.");
            }
            this.m_reader = mPPReader;
            this.m_file = projectFile;
            this.m_root = directoryEntry;
            this.m_resourceMap = new HashMap();
            this.m_projectDir = (DirectoryEntry)directoryEntry.getEntry("   19");
            this.m_viewDir = (DirectoryEntry)directoryEntry.getEntry("   29");
            object = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
            VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)object.getEntry("VarMeta")));
            this.m_outlineCodeVarData = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)object.getEntry("Var2Data")));
            this.m_projectProps = new Props9(this.getEncryptableInputStream(this.m_projectDir, "Props"));
            this.m_fontBases = new HashMap<Integer, FontBase>();
            this.m_taskSubProjects = new HashMap<Integer, SubProject>();
            this.m_file.setMppFileType(9);
            this.m_file.setAutoFilter(props9.getBoolean(Props.AUTO_FILTER));
            this.processPropertyData();
            this.processCalendarData();
            this.processResourceData();
            this.processTaskData();
            this.processConstraintData();
            this.processAssignmentData();
            this.validateTaskIDs();
            if (mPPReader.getReadPresentationData()) {
                this.processViewPropertyData();
                this.processTableData();
                this.processViewData();
                this.processFilterData();
                this.processGroupData();
                this.processSavedViewState();
            }
            Object var8_7 = null;
            this.m_reader = null;
            this.m_file = null;
            this.m_root = null;
            this.m_resourceMap = null;
            this.m_projectDir = null;
            this.m_viewDir = null;
            this.m_outlineCodeVarData = null;
            this.m_fontBases = null;
            this.m_taskSubProjects = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.m_reader = null;
            this.m_file = null;
            this.m_root = null;
            this.m_resourceMap = null;
            this.m_projectDir = null;
            this.m_viewDir = null;
            this.m_outlineCodeVarData = null;
            this.m_fontBases = null;
            this.m_taskSubProjects = null;
            throw throwable;
        }
    }

    private void processPropertyData() throws IOException, MPXJException {
        ProjectHeaderReader projectHeaderReader = new ProjectHeaderReader();
        projectHeaderReader.process(this.m_file, this.m_projectProps, this.m_root);
        this.processTaskFieldNameAliases(this.m_projectProps.getByteArray(Props.TASK_FIELD_NAME_ALIASES));
        this.processResourceFieldNameAliases(this.m_projectProps.getByteArray(Props.RESOURCE_FIELD_NAME_ALIASES));
        this.processTaskFieldCustomValueLists(this.m_file, this.m_projectProps.getByteArray(Props.TASK_FIELD_ATTRIBUTES));
        this.processSubProjectData();
        GraphicalIndicatorReader graphicalIndicatorReader = new GraphicalIndicatorReader();
        graphicalIndicatorReader.process(this.m_file, this.m_projectProps);
    }

    private void processSubProjectData() {
        byte[] byArray = this.m_projectProps.getByteArray(Props.SUBPROJECT_DATA);
        if (byArray != null) {
            int n = 0;
            int n2 = 0;
            byte[] byArray2 = new byte[20];
            n2 += 4;
            int n3 = MPPUtility.getInt(byArray, n2 += 4);
            n2 += 4;
            block17: while (n2 < n3) {
                ++n;
                int n4 = MPPUtility.getShort(byArray, n2);
                n2 += 4;
                MPPUtility.getByteArray(byArray, n4, byArray2.length, byArray2, 0);
                byte by = byArray2[16];
                switch (by) {
                    case 0: {
                        n2 += 8;
                        continue block17;
                    }
                    case -103: 
                    case 9: 
                    case 13: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        n2 += 4;
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block17;
                    }
                    case -111: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block17;
                    }
                    case 3: 
                    case 17: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block17;
                    }
                    case -127: 
                    case 65: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block17;
                    }
                    case 1: 
                    case 8: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block17;
                    }
                    case -64: {
                        int n5 = n4;
                        int n6 = MPPUtility.getShort(byArray, n2);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block17;
                    }
                    case 5: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        this.m_file.setResourceSubProject(subProject);
                        continue block17;
                    }
                    case 69: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        this.m_file.setResourceSubProject(subProject);
                        continue block17;
                    }
                    case 2: 
                    case 4: {
                        int n6 = MPPUtility.getShort(byArray, n2);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, -1, n6, n7, n);
                        if (by != 4) continue block17;
                        this.m_file.setResourceSubProject(subProject);
                        continue block17;
                    }
                    case -115: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 8);
                        int n7 = MPPUtility.getShort(byArray, n2 += 8);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block17;
                    }
                    case 10: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, n5, n6, n7, n);
                        continue block17;
                    }
                    case -128: {
                        n2 += 12;
                        continue block17;
                    }
                    case 16: {
                        n2 += 8;
                        continue block17;
                    }
                    case 68: {
                        int n6 = MPPUtility.getShort(byArray, n2);
                        n2 += 4;
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        SubProject subProject = this.readSubProject(byArray, -1, n6, n7, n);
                        this.m_file.setResourceSubProject(subProject);
                        continue block17;
                    }
                }
                n2 += 12;
            }
        }
    }

    private SubProject readSubProject(byte[] byArray, int n, int n2, int n3, int n4) {
        try {
            int n5;
            SubProject subProject = new SubProject();
            if (n != -1) {
                n5 = 0;
                int n6 = MPPUtility.getInt(byArray, n);
                while (n6 != 771) {
                    switch (n6) {
                        case 0: 
                        case 49741824: 
                        case 94437376: 
                        case 0x7010000: 
                        case 0xABB0000: 
                        case 187957248: {
                            subProject.setTaskUniqueID(n5);
                            this.m_taskSubProjects.put(subProject.getTaskUniqueID(), subProject);
                            n5 = 0;
                            break;
                        }
                        default: {
                            if (n5 != 0) {
                                subProject.addExternalTaskUniqueID(n5);
                                this.m_taskSubProjects.put(n5, subProject);
                            }
                            n5 = n6;
                        }
                    }
                    n6 = MPPUtility.getInt(byArray, n += 4);
                }
                if (n5 != 0) {
                    subProject.addExternalTaskUniqueID(n5);
                    this.m_taskSubProjects.put(n5, subProject);
                }
                n6 = 0x800000 + (n4 - 1) * 0x400000;
                subProject.setUniqueIDOffset(n6);
            }
            n2 += 18;
            subProject.setDosFullPath(MPPUtility.getString(byArray, n2 += 4));
            n2 += subProject.getDosFullPath().length() + 1;
            n5 = MPPUtility.getInt(byArray, n2 += 24);
            n2 += 4;
            if (n5 == 0) {
                subProject.setFullPath(subProject.getDosFullPath());
            } else {
                n5 = MPPUtility.getInt(byArray, n2);
                n2 += 4;
                subProject.setFullPath(MPPUtility.getUnicodeString(byArray, n2 += 2, n5));
            }
            n3 += 18;
            subProject.setDosFileName(MPPUtility.getString(byArray, n3 += 4));
            n3 += subProject.getDosFileName().length() + 1;
            n5 = MPPUtility.getInt(byArray, n3 += 24);
            n3 += 4;
            if (n5 == 0) {
                subProject.setFileName(subProject.getDosFileName());
            } else {
                n5 = MPPUtility.getInt(byArray, n3);
                n3 += 4;
                subProject.setFileName(MPPUtility.getUnicodeString(byArray, n3 += 2, n5));
            }
            this.m_file.addSubProject(subProject);
            return subProject;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private void processViewPropertyData() throws IOException {
        Props9 props9 = new Props9(this.getEncryptableInputStream(this.m_viewDir, "Props"));
        byte[] byArray = props9.getByteArray(Props.FONT_BASES);
        if (byArray != null) {
            this.processBaseFonts(byArray);
        }
        ProjectHeader projectHeader = this.m_file.getProjectHeader();
        projectHeader.setShowProjectSummaryTask(props9.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processBaseFonts(byte[] byArray) {
        int n = 0;
        int n2 = MPPUtility.getShort(byArray, 0);
        n += 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = MPPUtility.getShort(byArray, n += 2);
            String string = MPPUtility.getUnicodeString(byArray, n += 2);
            n += 64;
            if (string.length() == 0) continue;
            FontBase fontBase = new FontBase(i, string, n3);
            this.m_fontBases.put(fontBase.getIndex(), fontBase);
        }
    }

    private void processTaskFieldNameAliases(byte[] byArray) {
        if (byArray != null) {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>(300);
            for (int i = 0; i < byArray.length; i += (string.length() + 1) * 2) {
                string = MPPUtility.getUnicodeString(byArray, i);
                arrayList.add(string);
            }
            this.m_file.setTaskFieldAlias(TaskField.TEXT1, (String)arrayList.get(118));
            this.m_file.setTaskFieldAlias(TaskField.TEXT2, (String)arrayList.get(119));
            this.m_file.setTaskFieldAlias(TaskField.TEXT3, (String)arrayList.get(120));
            this.m_file.setTaskFieldAlias(TaskField.TEXT4, (String)arrayList.get(121));
            this.m_file.setTaskFieldAlias(TaskField.TEXT5, (String)arrayList.get(122));
            this.m_file.setTaskFieldAlias(TaskField.TEXT6, (String)arrayList.get(123));
            this.m_file.setTaskFieldAlias(TaskField.TEXT7, (String)arrayList.get(124));
            this.m_file.setTaskFieldAlias(TaskField.TEXT8, (String)arrayList.get(125));
            this.m_file.setTaskFieldAlias(TaskField.TEXT9, (String)arrayList.get(126));
            this.m_file.setTaskFieldAlias(TaskField.TEXT10, (String)arrayList.get(127));
            this.m_file.setTaskFieldAlias(TaskField.START1, (String)arrayList.get(128));
            this.m_file.setTaskFieldAlias(TaskField.FINISH1, (String)arrayList.get(129));
            this.m_file.setTaskFieldAlias(TaskField.START2, (String)arrayList.get(130));
            this.m_file.setTaskFieldAlias(TaskField.FINISH2, (String)arrayList.get(131));
            this.m_file.setTaskFieldAlias(TaskField.START3, (String)arrayList.get(132));
            this.m_file.setTaskFieldAlias(TaskField.FINISH3, (String)arrayList.get(133));
            this.m_file.setTaskFieldAlias(TaskField.START4, (String)arrayList.get(134));
            this.m_file.setTaskFieldAlias(TaskField.FINISH4, (String)arrayList.get(135));
            this.m_file.setTaskFieldAlias(TaskField.START5, (String)arrayList.get(136));
            this.m_file.setTaskFieldAlias(TaskField.FINISH5, (String)arrayList.get(137));
            this.m_file.setTaskFieldAlias(TaskField.START6, (String)arrayList.get(138));
            this.m_file.setTaskFieldAlias(TaskField.FINISH6, (String)arrayList.get(139));
            this.m_file.setTaskFieldAlias(TaskField.START7, (String)arrayList.get(140));
            this.m_file.setTaskFieldAlias(TaskField.FINISH7, (String)arrayList.get(141));
            this.m_file.setTaskFieldAlias(TaskField.START8, (String)arrayList.get(142));
            this.m_file.setTaskFieldAlias(TaskField.FINISH8, (String)arrayList.get(143));
            this.m_file.setTaskFieldAlias(TaskField.START9, (String)arrayList.get(144));
            this.m_file.setTaskFieldAlias(TaskField.FINISH9, (String)arrayList.get(145));
            this.m_file.setTaskFieldAlias(TaskField.START10, (String)arrayList.get(146));
            this.m_file.setTaskFieldAlias(TaskField.FINISH10, (String)arrayList.get(147));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER1, (String)arrayList.get(149));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER2, (String)arrayList.get(150));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER3, (String)arrayList.get(151));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER4, (String)arrayList.get(152));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER5, (String)arrayList.get(153));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER6, (String)arrayList.get(154));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER7, (String)arrayList.get(155));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER8, (String)arrayList.get(156));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER9, (String)arrayList.get(157));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER10, (String)arrayList.get(158));
            this.m_file.setTaskFieldAlias(TaskField.DURATION1, (String)arrayList.get(159));
            this.m_file.setTaskFieldAlias(TaskField.DURATION2, (String)arrayList.get(161));
            this.m_file.setTaskFieldAlias(TaskField.DURATION3, (String)arrayList.get(163));
            this.m_file.setTaskFieldAlias(TaskField.DURATION4, (String)arrayList.get(165));
            this.m_file.setTaskFieldAlias(TaskField.DURATION5, (String)arrayList.get(167));
            this.m_file.setTaskFieldAlias(TaskField.DURATION6, (String)arrayList.get(169));
            this.m_file.setTaskFieldAlias(TaskField.DURATION7, (String)arrayList.get(171));
            this.m_file.setTaskFieldAlias(TaskField.DURATION8, (String)arrayList.get(173));
            this.m_file.setTaskFieldAlias(TaskField.DURATION9, (String)arrayList.get(175));
            this.m_file.setTaskFieldAlias(TaskField.DURATION10, (String)arrayList.get(177));
            this.m_file.setTaskFieldAlias(TaskField.DATE1, (String)arrayList.get(184));
            this.m_file.setTaskFieldAlias(TaskField.DATE2, (String)arrayList.get(185));
            this.m_file.setTaskFieldAlias(TaskField.DATE3, (String)arrayList.get(186));
            this.m_file.setTaskFieldAlias(TaskField.DATE4, (String)arrayList.get(187));
            this.m_file.setTaskFieldAlias(TaskField.DATE5, (String)arrayList.get(188));
            this.m_file.setTaskFieldAlias(TaskField.DATE6, (String)arrayList.get(189));
            this.m_file.setTaskFieldAlias(TaskField.DATE7, (String)arrayList.get(190));
            this.m_file.setTaskFieldAlias(TaskField.DATE8, (String)arrayList.get(191));
            this.m_file.setTaskFieldAlias(TaskField.DATE9, (String)arrayList.get(192));
            this.m_file.setTaskFieldAlias(TaskField.DATE10, (String)arrayList.get(193));
            this.m_file.setTaskFieldAlias(TaskField.TEXT11, (String)arrayList.get(194));
            this.m_file.setTaskFieldAlias(TaskField.TEXT12, (String)arrayList.get(195));
            this.m_file.setTaskFieldAlias(TaskField.TEXT13, (String)arrayList.get(196));
            this.m_file.setTaskFieldAlias(TaskField.TEXT14, (String)arrayList.get(197));
            this.m_file.setTaskFieldAlias(TaskField.TEXT15, (String)arrayList.get(198));
            this.m_file.setTaskFieldAlias(TaskField.TEXT16, (String)arrayList.get(199));
            this.m_file.setTaskFieldAlias(TaskField.TEXT17, (String)arrayList.get(200));
            this.m_file.setTaskFieldAlias(TaskField.TEXT18, (String)arrayList.get(201));
            this.m_file.setTaskFieldAlias(TaskField.TEXT19, (String)arrayList.get(202));
            this.m_file.setTaskFieldAlias(TaskField.TEXT20, (String)arrayList.get(203));
            this.m_file.setTaskFieldAlias(TaskField.TEXT21, (String)arrayList.get(204));
            this.m_file.setTaskFieldAlias(TaskField.TEXT22, (String)arrayList.get(205));
            this.m_file.setTaskFieldAlias(TaskField.TEXT23, (String)arrayList.get(206));
            this.m_file.setTaskFieldAlias(TaskField.TEXT24, (String)arrayList.get(207));
            this.m_file.setTaskFieldAlias(TaskField.TEXT25, (String)arrayList.get(208));
            this.m_file.setTaskFieldAlias(TaskField.TEXT26, (String)arrayList.get(209));
            this.m_file.setTaskFieldAlias(TaskField.TEXT27, (String)arrayList.get(210));
            this.m_file.setTaskFieldAlias(TaskField.TEXT28, (String)arrayList.get(211));
            this.m_file.setTaskFieldAlias(TaskField.TEXT29, (String)arrayList.get(212));
            this.m_file.setTaskFieldAlias(TaskField.TEXT30, (String)arrayList.get(213));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER11, (String)arrayList.get(214));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER12, (String)arrayList.get(215));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER13, (String)arrayList.get(216));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER14, (String)arrayList.get(217));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER15, (String)arrayList.get(218));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER16, (String)arrayList.get(219));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER17, (String)arrayList.get(220));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER18, (String)arrayList.get(221));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER19, (String)arrayList.get(222));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER20, (String)arrayList.get(223));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE1, (String)arrayList.get(227));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE2, (String)arrayList.get(228));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE3, (String)arrayList.get(229));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE4, (String)arrayList.get(230));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE5, (String)arrayList.get(231));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE6, (String)arrayList.get(232));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE7, (String)arrayList.get(233));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE8, (String)arrayList.get(234));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE9, (String)arrayList.get(235));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE10, (String)arrayList.get(236));
            this.m_file.setTaskFieldAlias(TaskField.FLAG1, (String)arrayList.get(237));
            this.m_file.setTaskFieldAlias(TaskField.FLAG2, (String)arrayList.get(238));
            this.m_file.setTaskFieldAlias(TaskField.FLAG3, (String)arrayList.get(239));
            this.m_file.setTaskFieldAlias(TaskField.FLAG4, (String)arrayList.get(240));
            this.m_file.setTaskFieldAlias(TaskField.FLAG5, (String)arrayList.get(241));
            this.m_file.setTaskFieldAlias(TaskField.FLAG6, (String)arrayList.get(242));
            this.m_file.setTaskFieldAlias(TaskField.FLAG7, (String)arrayList.get(243));
            this.m_file.setTaskFieldAlias(TaskField.FLAG8, (String)arrayList.get(244));
            this.m_file.setTaskFieldAlias(TaskField.FLAG9, (String)arrayList.get(245));
            this.m_file.setTaskFieldAlias(TaskField.FLAG10, (String)arrayList.get(246));
            this.m_file.setTaskFieldAlias(TaskField.FLAG11, (String)arrayList.get(247));
            this.m_file.setTaskFieldAlias(TaskField.FLAG12, (String)arrayList.get(248));
            this.m_file.setTaskFieldAlias(TaskField.FLAG13, (String)arrayList.get(249));
            this.m_file.setTaskFieldAlias(TaskField.FLAG14, (String)arrayList.get(250));
            this.m_file.setTaskFieldAlias(TaskField.FLAG15, (String)arrayList.get(251));
            this.m_file.setTaskFieldAlias(TaskField.FLAG16, (String)arrayList.get(252));
            this.m_file.setTaskFieldAlias(TaskField.FLAG17, (String)arrayList.get(253));
            this.m_file.setTaskFieldAlias(TaskField.FLAG18, (String)arrayList.get(254));
            this.m_file.setTaskFieldAlias(TaskField.FLAG19, (String)arrayList.get(255));
            this.m_file.setTaskFieldAlias(TaskField.FLAG20, (String)arrayList.get(256));
            this.m_file.setTaskFieldAlias(TaskField.COST1, (String)arrayList.get(278));
            this.m_file.setTaskFieldAlias(TaskField.COST2, (String)arrayList.get(279));
            this.m_file.setTaskFieldAlias(TaskField.COST3, (String)arrayList.get(280));
            this.m_file.setTaskFieldAlias(TaskField.COST4, (String)arrayList.get(281));
            this.m_file.setTaskFieldAlias(TaskField.COST5, (String)arrayList.get(282));
            this.m_file.setTaskFieldAlias(TaskField.COST6, (String)arrayList.get(283));
            this.m_file.setTaskFieldAlias(TaskField.COST7, (String)arrayList.get(284));
            this.m_file.setTaskFieldAlias(TaskField.COST8, (String)arrayList.get(285));
            this.m_file.setTaskFieldAlias(TaskField.COST9, (String)arrayList.get(286));
            this.m_file.setTaskFieldAlias(TaskField.COST10, (String)arrayList.get(287));
        }
    }

    private void processTaskFieldCustomValueLists(ProjectFile projectFile, byte[] byArray) {
        if (byArray != null) {
            int n = 0;
            int n2 = MPPUtility.getInt(byArray, n);
            int n3 = MPPUtility.getInt(byArray, n += 4);
            n += 4;
            int n4 = 0;
            for (int i = 0; i < n3 && n < n2; ++i) {
                TaskField taskField = MPPTaskField.getInstance(MPPUtility.getShort(byArray, n));
                n += 2;
                n4 = MPPUtility.getInt(byArray, n += 2);
                n += 4;
                if (n4 >= byArray.length) continue;
                int n5 = n4;
                int n6 = MPPUtility.getInt(byArray, n5 += 8) + n4;
                int n7 = MPPUtility.getInt(byArray, n5 += 4) + n4;
                int n8 = MPPUtility.getInt(byArray, n5 += 4) + n4;
                int n9 = n7 - n6;
                byte[] byArray2 = new byte[n9];
                MPPUtility.getByteArray(byArray, n6, n9, byArray2, 0);
                projectFile.setTaskFieldValueList(taskField, this.getTaskFieldValues(projectFile, taskField, byArray2));
                int n10 = n8 - n7;
                byte[] byArray3 = new byte[n10];
                MPPUtility.getByteArray(byArray, n7, n10, byArray3, 0);
                projectFile.setTaskFieldDescriptionList(taskField, this.getTaskFieldDescriptions(byArray3));
            }
        }
    }

    public List<String> getTaskFieldDescriptions(byte[] byArray) {
        String string;
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < byArray.length; i += string.length() * 2 + 2) {
            string = MPPUtility.getUnicodeString(byArray, i);
            linkedList.add(string);
        }
        return linkedList;
    }

    public List<Object> getTaskFieldValues(ProjectFile projectFile, TaskField taskField, byte[] byArray) {
        if (taskField == null || byArray == null || byArray.length == 0) {
            return null;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        switch (taskField.getDataType()) {
            case DATE: {
                int n;
                while (n + 4 <= byArray.length) {
                    Date date = MPPUtility.getTimestamp(byArray, n);
                    linkedList.add(date);
                    n += 4;
                }
                break;
            }
            case CURRENCY: {
                int n;
                while (n + 8 <= byArray.length) {
                    Double d = NumberUtility.getDouble(MPPUtility.getDouble(byArray, n) / 100.0);
                    linkedList.add(d);
                    n += 8;
                }
                break;
            }
            case NUMERIC: {
                int n;
                while (n + 8 <= byArray.length) {
                    Double d = NumberUtility.getDouble(MPPUtility.getDouble(byArray, n));
                    linkedList.add(d);
                    n += 8;
                }
                break;
            }
            case DURATION: {
                int n;
                while (n + 6 <= byArray.length) {
                    Duration duration = MPPUtility.getAdjustedDuration(projectFile, MPPUtility.getInt(byArray, n), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, n + 4)));
                    linkedList.add(duration);
                    n += 6;
                }
                break;
            }
            case STRING: {
                String string;
                int n;
                for (n = 0; n < byArray.length; n += string.length() * 2 + 2) {
                    string = MPPUtility.getUnicodeString(byArray, n);
                    linkedList.add(string);
                }
                break;
            }
            case BOOLEAN: {
                int n;
                while (n + 2 <= byArray.length) {
                    boolean bl = MPPUtility.getShort(byArray, n) == 1;
                    linkedList.add(bl);
                    n += 2;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return linkedList;
    }

    private void processResourceFieldNameAliases(byte[] byArray) {
        if (byArray != null) {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>(250);
            for (int i = 0; i < byArray.length; i += (string.length() + 1) * 2) {
                string = MPPUtility.getUnicodeString(byArray, i);
                arrayList.add(string);
            }
            this.m_file.setResourceFieldAlias(ResourceField.TEXT1, (String)arrayList.get(52));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT2, (String)arrayList.get(53));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT3, (String)arrayList.get(54));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT4, (String)arrayList.get(55));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT5, (String)arrayList.get(56));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT6, (String)arrayList.get(57));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT7, (String)arrayList.get(58));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT8, (String)arrayList.get(59));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT9, (String)arrayList.get(60));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT10, (String)arrayList.get(61));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT11, (String)arrayList.get(62));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT12, (String)arrayList.get(63));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT13, (String)arrayList.get(64));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT14, (String)arrayList.get(65));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT15, (String)arrayList.get(66));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT16, (String)arrayList.get(67));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT17, (String)arrayList.get(68));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT18, (String)arrayList.get(69));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT19, (String)arrayList.get(70));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT20, (String)arrayList.get(71));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT21, (String)arrayList.get(72));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT22, (String)arrayList.get(73));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT23, (String)arrayList.get(74));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT24, (String)arrayList.get(75));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT25, (String)arrayList.get(76));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT26, (String)arrayList.get(77));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT27, (String)arrayList.get(78));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT28, (String)arrayList.get(79));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT29, (String)arrayList.get(80));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT30, (String)arrayList.get(81));
            this.m_file.setResourceFieldAlias(ResourceField.START1, (String)arrayList.get(82));
            this.m_file.setResourceFieldAlias(ResourceField.START2, (String)arrayList.get(83));
            this.m_file.setResourceFieldAlias(ResourceField.START3, (String)arrayList.get(84));
            this.m_file.setResourceFieldAlias(ResourceField.START4, (String)arrayList.get(85));
            this.m_file.setResourceFieldAlias(ResourceField.START5, (String)arrayList.get(86));
            this.m_file.setResourceFieldAlias(ResourceField.START6, (String)arrayList.get(87));
            this.m_file.setResourceFieldAlias(ResourceField.START7, (String)arrayList.get(88));
            this.m_file.setResourceFieldAlias(ResourceField.START8, (String)arrayList.get(89));
            this.m_file.setResourceFieldAlias(ResourceField.START9, (String)arrayList.get(90));
            this.m_file.setResourceFieldAlias(ResourceField.START10, (String)arrayList.get(91));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH1, (String)arrayList.get(92));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH2, (String)arrayList.get(93));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH3, (String)arrayList.get(94));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH4, (String)arrayList.get(95));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH5, (String)arrayList.get(96));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH6, (String)arrayList.get(97));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH7, (String)arrayList.get(98));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH8, (String)arrayList.get(99));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH9, (String)arrayList.get(100));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH10, (String)arrayList.get(101));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER1, (String)arrayList.get(102));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER2, (String)arrayList.get(103));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER3, (String)arrayList.get(104));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER4, (String)arrayList.get(105));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER5, (String)arrayList.get(106));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER6, (String)arrayList.get(107));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER7, (String)arrayList.get(108));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER8, (String)arrayList.get(109));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER9, (String)arrayList.get(110));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER10, (String)arrayList.get(111));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER11, (String)arrayList.get(112));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER12, (String)arrayList.get(113));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER13, (String)arrayList.get(114));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER14, (String)arrayList.get(115));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER15, (String)arrayList.get(116));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER16, (String)arrayList.get(117));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER17, (String)arrayList.get(118));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER18, (String)arrayList.get(119));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER19, (String)arrayList.get(120));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER20, (String)arrayList.get(121));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION1, (String)arrayList.get(122));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION2, (String)arrayList.get(123));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION3, (String)arrayList.get(124));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION4, (String)arrayList.get(125));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION5, (String)arrayList.get(126));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION6, (String)arrayList.get(127));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION7, (String)arrayList.get(128));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION8, (String)arrayList.get(129));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION9, (String)arrayList.get(130));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION10, (String)arrayList.get(131));
            this.m_file.setResourceFieldAlias(ResourceField.DATE1, (String)arrayList.get(145));
            this.m_file.setResourceFieldAlias(ResourceField.DATE2, (String)arrayList.get(146));
            this.m_file.setResourceFieldAlias(ResourceField.DATE3, (String)arrayList.get(147));
            this.m_file.setResourceFieldAlias(ResourceField.DATE4, (String)arrayList.get(148));
            this.m_file.setResourceFieldAlias(ResourceField.DATE5, (String)arrayList.get(149));
            this.m_file.setResourceFieldAlias(ResourceField.DATE6, (String)arrayList.get(150));
            this.m_file.setResourceFieldAlias(ResourceField.DATE7, (String)arrayList.get(151));
            this.m_file.setResourceFieldAlias(ResourceField.DATE8, (String)arrayList.get(152));
            this.m_file.setResourceFieldAlias(ResourceField.DATE9, (String)arrayList.get(153));
            this.m_file.setResourceFieldAlias(ResourceField.DATE10, (String)arrayList.get(154));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE1, (String)arrayList.get(155));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE2, (String)arrayList.get(156));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE3, (String)arrayList.get(157));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE4, (String)arrayList.get(158));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE5, (String)arrayList.get(159));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE6, (String)arrayList.get(160));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE7, (String)arrayList.get(161));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE8, (String)arrayList.get(162));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE9, (String)arrayList.get(163));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE10, (String)arrayList.get(164));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG10, (String)arrayList.get(165));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG1, (String)arrayList.get(166));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG2, (String)arrayList.get(167));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG3, (String)arrayList.get(168));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG4, (String)arrayList.get(169));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG5, (String)arrayList.get(170));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG6, (String)arrayList.get(171));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG7, (String)arrayList.get(172));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG8, (String)arrayList.get(173));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG9, (String)arrayList.get(174));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG11, (String)arrayList.get(175));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG12, (String)arrayList.get(176));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG13, (String)arrayList.get(177));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG14, (String)arrayList.get(178));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG15, (String)arrayList.get(179));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG16, (String)arrayList.get(180));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG17, (String)arrayList.get(181));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG18, (String)arrayList.get(182));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG19, (String)arrayList.get(183));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG20, (String)arrayList.get(184));
            this.m_file.setResourceFieldAlias(ResourceField.COST1, (String)arrayList.get(207));
            this.m_file.setResourceFieldAlias(ResourceField.COST2, (String)arrayList.get(208));
            this.m_file.setResourceFieldAlias(ResourceField.COST3, (String)arrayList.get(209));
            this.m_file.setResourceFieldAlias(ResourceField.COST4, (String)arrayList.get(210));
            this.m_file.setResourceFieldAlias(ResourceField.COST5, (String)arrayList.get(211));
            this.m_file.setResourceFieldAlias(ResourceField.COST6, (String)arrayList.get(212));
            this.m_file.setResourceFieldAlias(ResourceField.COST7, (String)arrayList.get(213));
            this.m_file.setResourceFieldAlias(ResourceField.COST8, (String)arrayList.get(214));
            this.m_file.setResourceFieldAlias(ResourceField.COST9, (String)arrayList.get(215));
            this.m_file.setResourceFieldAlias(ResourceField.COST10, (String)arrayList.get(216));
        }
    }

    private TreeMap<Integer, Integer> createTaskMap(FieldMap fieldMap, FixedMeta fixedMeta, FixedData fixedData) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = fixedMeta.getItemCount();
        this.m_highestEmptyTaskID = -1;
        int n2 = -1;
        for (int i = 3; i < n; ++i) {
            Integer n3;
            int n4;
            byte[] byArray = fixedData.getByteArrayValue(i);
            if (byArray == null) continue;
            byte[] byArray2 = fixedMeta.getByteArrayValue(i);
            int n5 = MPPUtility.getInt(byArray2, 0);
            if (n5 == 2 || n5 == 6) {
                n4 = MPPUtility.getShort(byArray, 0);
                n3 = n4;
                if (treeMap.containsKey(n3)) continue;
                treeMap.put(n3, null);
                continue;
            }
            if (n5 == 4) {
                n2 = MPPUtility.getInt(byArray, 4);
                if (this.m_highestEmptyTaskID >= n2) continue;
                this.m_highestEmptyTaskID = n2;
                continue;
            }
            if (byArray.length != 8 && byArray.length <= fieldMap.getMaxFixedDataOffset(0) || treeMap.containsKey(n3 = Integer.valueOf(n4 = MPPUtility.getInt(byArray, 0)))) continue;
            treeMap.put(n3, i);
        }
        return treeMap;
    }

    private TreeMap<Integer, Integer> createResourceMap(FieldMap fieldMap, FixedMeta fixedMeta, FixedData fixedData) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = fixedMeta.getItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedData.getByteArrayValue(i);
            if (byArray == null || byArray.length <= fieldMap.getMaxFixedDataOffset(0)) continue;
            Integer n2 = MPPUtility.getShort(byArray, 0);
            treeMap.put(n2, i);
        }
        return treeMap;
    }

    private void processCalendarData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCal");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, this.getEncryptableInputStream(directoryEntry, "FixedData"), 12);
        HashMap<Integer, ProjectCalendar> hashMap = new HashMap<Integer, ProjectCalendar>();
        int n = fixedData.getItemCount();
        LinkedList<Pair<ProjectCalendar, Integer>> linkedList = new LinkedList<Pair<ProjectCalendar, Integer>>();
        byte[] byArray = this.m_projectProps.getByteArray(Props.DEFAULT_CALENDAR_HOURS);
        ProjectCalendar projectCalendar = new ProjectCalendar(this.m_file);
        this.processCalendarHours(byArray, null, projectCalendar, true);
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = fixedData.getByteArrayValue(i);
            if (byArray2 == null || byArray2.length < 8) continue;
            int n2 = 0;
            while (n2 + 12 <= byArray2.length) {
                Integer n3 = MPPUtility.getInt(byArray2, n2 + 0);
                int n4 = MPPUtility.getInt(byArray2, n2 + 4);
                if (n3 != -1 && n3 != 0 && n4 != 0 && !hashMap.containsKey(n3)) {
                    ProjectCalendar projectCalendar2;
                    byte[] byArray3 = var2Data.getByteArray(n3, CALENDAR_DATA);
                    if (n4 == -1) {
                        if (byArray3 != null || byArray != null) {
                            projectCalendar2 = this.m_file.addBaseCalendar();
                            if (byArray3 == null) {
                                byArray3 = byArray;
                            }
                        } else {
                            projectCalendar2 = this.m_file.addDefaultBaseCalendar();
                        }
                        projectCalendar2.setName(var2Data.getUnicodeString(n3, CALENDAR_NAME));
                    } else {
                        projectCalendar2 = byArray3 != null ? this.m_file.addResourceCalendar() : this.m_file.getDefaultResourceCalendar();
                        linkedList.add(new Pair<ProjectCalendar, Integer>(projectCalendar2, n4));
                        Integer n5 = MPPUtility.getInt(byArray2, n2 + 8);
                        this.m_resourceMap.put(n5, projectCalendar2);
                    }
                    projectCalendar2.setUniqueID(n3);
                    if (byArray3 != null) {
                        this.processCalendarHours(byArray3, projectCalendar, projectCalendar2, n4 == -1);
                        this.processCalendarExceptions(byArray3, projectCalendar2);
                    }
                    hashMap.put(n3, projectCalendar2);
                    this.m_file.fireCalendarReadEvent(projectCalendar2);
                }
                n2 += 12;
            }
        }
        this.updateBaseCalendarNames(linkedList, hashMap);
    }

    private void processCalendarHours(byte[] byArray, ProjectCalendar projectCalendar, ProjectCalendar projectCalendar2, boolean bl) {
        for (int i = 0; i < 7; ++i) {
            ProjectCalendarHours projectCalendarHours;
            int n = 4 + 60 * i;
            int n2 = byArray == null ? 1 : MPPUtility.getShort(byArray, n);
            Day day = Day.getInstance(i + 1);
            if (n2 == 1) {
                if (bl) {
                    if (projectCalendar == null) {
                        projectCalendar2.setWorkingDay(day, DEFAULT_WORKING_WEEK[i]);
                        if (!projectCalendar2.isWorkingDay(day)) continue;
                        projectCalendarHours = projectCalendar2.addCalendarHours(Day.getInstance(i + 1));
                        projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                        projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
                        continue;
                    }
                    boolean bl2 = projectCalendar.isWorkingDay(day);
                    projectCalendar2.setWorkingDay(day, bl2);
                    if (!bl2) continue;
                    projectCalendarHours = projectCalendar2.addCalendarHours(Day.getInstance(i + 1));
                    for (DateRange dateRange : projectCalendar.getHours(day)) {
                        projectCalendarHours.addRange(dateRange);
                    }
                    continue;
                }
                projectCalendar2.setWorkingDay(day, DayType.DEFAULT);
                continue;
            }
            int n3 = MPPUtility.getShort(byArray, n + 2);
            if (n3 == 0) {
                projectCalendar2.setWorkingDay(day, false);
                continue;
            }
            projectCalendar2.setWorkingDay(day, true);
            projectCalendarHours = projectCalendar2.addCalendarHours(Day.getInstance(i + 1));
            for (int j = 0; j < n3; ++j) {
                Date date = MPPUtility.getTime(byArray, n + 8 + j * 2);
                long l = MPPUtility.getDuration(byArray, n + 20 + j * 4);
                projectCalendarHours.addRange(new DateRange(date, new Date(date.getTime() + l)));
            }
        }
    }

    private void processCalendarExceptions(byte[] byArray, ProjectCalendar projectCalendar) {
        int n = MPPUtility.getShort(byArray, 0);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                int n2 = 424 + i * 64;
                Date date = MPPUtility.getDate(byArray, n2);
                Date date2 = MPPUtility.getDate(byArray, n2 + 2);
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
                int n3 = MPPUtility.getShort(byArray, n2 + 6);
                if (n3 == 0) continue;
                for (int j = 0; j < n3; ++j) {
                    Date date3 = MPPUtility.getTime(byArray, n2 + 12 + j * 2);
                    long l = MPPUtility.getDuration(byArray, n2 + 24 + j * 4);
                    projectCalendarException.addRange(new DateRange(date3, new Date(date3.getTime() + l)));
                }
            }
        }
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> list, HashMap<Integer, ProjectCalendar> hashMap) {
        for (Pair<ProjectCalendar, Integer> pair : list) {
            ProjectCalendar projectCalendar = pair.getFirst();
            Integer n = pair.getSecond();
            ProjectCalendar projectCalendar2 = hashMap.get(n);
            if (projectCalendar2 != null && projectCalendar2.getName() != null) {
                projectCalendar.setParent(projectCalendar2);
                continue;
            }
            this.m_file.removeCalendar(projectCalendar);
        }
    }

    private void processTaskData() throws IOException {
        FieldMap9 fieldMap9 = new FieldMap9(this.m_file);
        fieldMap9.createTaskFieldMap(this.m_projectProps);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 47);
        FixedData fixedData = new FixedData(fixedMeta, this.getEncryptableInputStream(directoryEntry, "FixedData"), 768, fieldMap9.getMaxFixedDataOffset(0));
        TreeMap<Integer, Integer> treeMap = this.createTaskMap(fieldMap9, fixedMeta, fixedData);
        Object[] objectArray = treeMap.keySet().toArray();
        boolean bl = true;
        LinkedList<Task> linkedList = new LinkedList<Task>();
        RecurringTaskReader recurringTaskReader = null;
        RTFUtility rTFUtility = new RTFUtility();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Integer n;
            String string;
            Task task;
            Integer n2 = (Integer)objectArray[i];
            Integer n3 = treeMap.get(n2);
            if (!fixedData.isValidOffset(n3)) continue;
            byte[] byArray = fixedData.getByteArrayValue(n3);
            if (byArray.length == 8) {
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(n2);
                task.setID(MPPUtility.getInt(byArray, 4));
                continue;
            }
            if (byArray.length < fieldMap9.getMaxFixedDataOffset(0) || n2 != 0 && !varMeta9.containsKey(n2)) continue;
            byte[] byArray2 = fixedMeta.getByteArrayValue(n3);
            byte[] byArray3 = var2Data.getByteArray(n2, fieldMap9.getVarDataKey(TaskField.RECURRING_DATA));
            Task task2 = this.m_file.getTaskByID(MPPUtility.getInt(byArray, 4));
            if (task2 != null) {
                if (!varMeta9.getUniqueIdentifierSet().contains(n2)) continue;
                if (task2.getName() == null) {
                    this.m_file.removeTask(task2);
                }
            }
            task = this.m_file.addTask();
            task.disableEvents();
            fieldMap9.populateContainer(task, n2, new byte[][]{byArray}, var2Data);
            task.enableEvents();
            task.setEffortDriven((byArray2[11] & 0x10) != 0);
            task.setEstimated(this.getDurationEstimated(MPPUtility.getShort(byArray, fieldMap9.getFixedDataOffset(TaskField.ACTUAL_DURATION_UNITS))));
            task.setExpanded((byArray2[12] & 2) == 0);
            Integer n4 = task.getSubprojectTaskID();
            if (n4 != null && n4 != 0) {
                task.setSubprojectTaskID(n4);
                task.setExternalTask(true);
                linkedList.add(task);
            }
            task.setFlag1((byArray2[37] & 0x20) != 0);
            task.setFlag2((byArray2[37] & 0x40) != 0);
            task.setFlag3((byArray2[37] & 0x80) != 0);
            task.setFlag4((byArray2[38] & 1) != 0);
            task.setFlag5((byArray2[38] & 2) != 0);
            task.setFlag6((byArray2[38] & 4) != 0);
            task.setFlag7((byArray2[38] & 8) != 0);
            task.setFlag8((byArray2[38] & 0x10) != 0);
            task.setFlag9((byArray2[38] & 0x20) != 0);
            task.setFlag10((byArray2[38] & 0x40) != 0);
            task.setFlag11((byArray2[38] & 0x80) != 0);
            task.setFlag12((byArray2[39] & 1) != 0);
            task.setFlag13((byArray2[39] & 2) != 0);
            task.setFlag14((byArray2[39] & 4) != 0);
            task.setFlag15((byArray2[39] & 8) != 0);
            task.setFlag16((byArray2[39] & 0x10) != 0);
            task.setFlag17((byArray2[39] & 0x20) != 0);
            task.setFlag18((byArray2[39] & 0x40) != 0);
            task.setFlag19((byArray2[39] & 0x80) != 0);
            task.setFlag20((byArray2[40] & 1) != 0);
            task.setHideBar((byArray2[10] & 0x80) != 0);
            this.processHyperlinkData(task, var2Data.getByteArray(n2, fieldMap9.getVarDataKey(TaskField.HYPERLINK_DATA)));
            task.setID(MPPUtility.getInt(byArray, 4));
            task.setIgnoreResourceCalendar((byArray2[10] & 2) != 0);
            task.setLevelAssignments((byArray2[13] & 4) != 0);
            task.setLevelingCanSplit((byArray2[13] & 2) != 0);
            task.setMarked((byArray2[9] & 0x40) != 0);
            task.setMilestone((byArray2[8] & 0x20) != 0);
            task.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE1_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE2_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE3_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE4_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE5_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE6_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE7_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE8_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE9_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE10_INDEX), OUTLINECODE_DATA));
            task.setRollup((byArray2[10] & 8) != 0);
            task.setUniqueID(n2);
            switch (task.getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    if (DateUtility.compare(task.getStart(), task.getLateStart()) < 0) {
                        task.setStart(task.getLateStart());
                    }
                    if (DateUtility.compare(task.getFinish(), task.getLateFinish()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
                case START_NO_LATER_THAN: 
                case FINISH_NO_LATER_THAN: {
                    if (DateUtility.compare(task.getFinish(), task.getStart()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
            }
            if (byArray3 != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file);
                }
                recurringTaskReader.processRecurringTask(task, byArray3);
                task.setRecurring(true);
            }
            if ((string = task.getNotes()) != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    string = rTFUtility.strip(string);
                }
                task.setNotes(string);
            }
            if ((n = (Integer)task.getCachedValue(TaskField.CALENDAR_UNIQUE_ID)) != null && n != -1 && (object = this.m_file.getBaseCalendarByUniqueID(n)) != null) {
                task.setCalendar((ProjectCalendar)object);
            }
            object = this.m_taskSubProjects.get(task.getUniqueID());
            task.setSubProject((SubProject)object);
            if (object != null) {
                task.setExternalTask(((SubProject)object).isExternalTask(task.getUniqueID()));
                if (task.getExternalTask()) {
                    task.setExternalTaskProject(((SubProject)object).getFullPath());
                }
            }
            if (task.getWBS() != null) {
                bl = false;
            }
            if ((byArray2[9] & 0x80) == 0) {
                task.setSplits(new LinkedList<DateRange>());
            }
            if (task.getName() == null && (task.getStart() == null || task.getStart().getTime() == MPPUtility.getEpochDate().getTime() || task.getFinish() == null || task.getFinish().getTime() == MPPUtility.getEpochDate().getTime() || task.getCreateDate() == null || task.getCreateDate().getTime() == MPPUtility.getEpochDate().getTime())) {
                this.m_file.removeTask(task);
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(n2);
                task.setID(MPPUtility.getInt(byArray, 4));
                continue;
            }
            this.processTaskEnterpriseColumns(fieldMap9, task, var2Data);
            this.m_file.fireTaskReadEvent(task);
        }
        this.m_file.setAutoWBS(bl);
        if (!linkedList.isEmpty()) {
            this.processExternalTasks(linkedList);
        }
    }

    private void processTaskEnterpriseColumns(FieldMap fieldMap, Task task, Var2Data var2Data) {
        byte[] byArray = null;
        Integer n = fieldMap.getVarDataKey(TaskField.ENTERPRISE_DATA);
        if (n != null) {
            byArray = var2Data.getByteArray(task.getUniqueID(), n);
        }
        if (byArray != null) {
            PropsBlock propsBlock = new PropsBlock(byArray);
            for (Integer n2 : propsBlock.keySet()) {
                int n3 = n2 - 0xB400000;
                TaskField taskField = MPPTaskField.getInstance(n3);
                if (taskField == null) continue;
                Object object = null;
                switch (taskField.getDataType()) {
                    case CURRENCY: {
                        object = propsBlock.getDouble(n2) / 100.0;
                        break;
                    }
                    case DATE: {
                        object = propsBlock.getTimestamp(n2);
                        break;
                    }
                    case WORK: {
                        double d = MPPUtility.getDouble(propsBlock.getByteArray(n2)) / 60000.0;
                        object = Duration.getInstance(d, TimeUnit.HOURS);
                        break;
                    }
                    case DURATION: {
                        byte[] byArray2 = propsBlock.getByteArray(n2);
                        double d = (double)MPPUtility.getInt(byArray2, 0) / 600.0;
                        TimeUnit timeUnit = byArray2.length < 6 ? TimeUnit.DAYS : MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 4));
                        Duration duration = Duration.getInstance(d, TimeUnit.HOURS);
                        object = duration.convertUnits(timeUnit, this.m_file.getProjectHeader());
                        break;
                    }
                    case BOOLEAN: {
                        taskField = null;
                        int n4 = propsBlock.getInt(n2);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG1, (n4 & 2) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG2, (n4 & 4) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG3, (n4 & 8) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG4, (n4 & 0x10) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG5, (n4 & 0x20) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG6, (n4 & 0x40) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG7, (n4 & 0x80) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG8, (n4 & 0x100) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG9, (n4 & 0x200) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG10, (n4 & 0x400) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG11, (n4 & 0x800) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG12, (n4 & 0x1000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG13, (n4 & 0x2000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG14, (n4 & 0x4000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG15, (n4 & 0x8000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG16, (n4 & 0x10000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG17, (n4 & 0x20000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG18, (n4 & 0x40000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG19, (n4 & 0x80000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG20, (n4 & 0x100000) != 0 ? 1 : 0);
                        break;
                    }
                    case NUMERIC: {
                        object = propsBlock.getDouble(n2);
                        break;
                    }
                    case STRING: {
                        object = propsBlock.getUnicodeString(n2);
                        break;
                    }
                    case PERCENTAGE: {
                        object = propsBlock.getShort(n2);
                        break;
                    }
                }
                task.set((FieldType)taskField, object);
            }
        }
    }

    private void processResourceEnterpriseColumns(FieldMap fieldMap, Resource resource, Var2Data var2Data) {
        byte[] byArray = null;
        Integer n = fieldMap.getVarDataKey(ResourceField.ENTERPRISE_DATA);
        if (n != null) {
            byArray = var2Data.getByteArray(resource.getUniqueID(), n);
        }
        if (byArray != null) {
            PropsBlock propsBlock = new PropsBlock(byArray);
            resource.setCreationDate(propsBlock.getTimestamp(Props.RESOURCE_CREATION_DATE));
            for (Integer n2 : propsBlock.keySet()) {
                int n3 = n2 - 0xC400000;
                ResourceField resourceField = MPPResourceField.getInstance(n3);
                if (resourceField == null) continue;
                Object object = null;
                switch (resourceField.getDataType()) {
                    case CURRENCY: {
                        object = propsBlock.getDouble(n2) / 100.0;
                        break;
                    }
                    case DATE: {
                        object = propsBlock.getTimestamp(n2);
                        break;
                    }
                    case DURATION: {
                        byte[] byArray2 = propsBlock.getByteArray(n2);
                        double d = (double)MPPUtility.getInt(byArray2, 0) / 600.0;
                        TimeUnit timeUnit = byArray2.length < 6 ? TimeUnit.DAYS : MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 4));
                        Duration duration = Duration.getInstance(d, TimeUnit.HOURS);
                        object = duration.convertUnits(timeUnit, this.m_file.getProjectHeader());
                        break;
                    }
                    case BOOLEAN: {
                        resourceField = null;
                        int n4 = propsBlock.getInt(n2);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG1, (n4 & 2) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG2, (n4 & 4) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG3, (n4 & 8) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG4, (n4 & 0x10) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG5, (n4 & 0x20) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG6, (n4 & 0x40) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG7, (n4 & 0x80) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG8, (n4 & 0x100) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG9, (n4 & 0x200) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG10, (n4 & 0x400) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG11, (n4 & 0x800) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG12, (n4 & 0x1000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG13, (n4 & 0x2000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG14, (n4 & 0x4000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG15, (n4 & 0x8000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG16, (n4 & 0x10000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG17, (n4 & 0x20000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG18, (n4 & 0x40000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG19, (n4 & 0x80000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG20, (n4 & 0x100000) != 0 ? 1 : 0);
                        break;
                    }
                    case NUMERIC: {
                        object = propsBlock.getDouble(n2);
                        break;
                    }
                    case STRING: {
                        object = propsBlock.getUnicodeString(n2);
                        break;
                    }
                }
                resource.set((FieldType)resourceField, object);
            }
        }
    }

    private void processExternalTasks(List<Task> list) {
        Collections.sort(list);
        SubProject subProject = null;
        for (Task task : list) {
            SubProject subProject2 = task.getSubProject();
            if (subProject2 == null) {
                task.setSubProject(subProject);
                if (subProject != null) {
                    task.setExternalTaskProject(subProject.getFullPath());
                }
            } else {
                subProject = subProject2;
            }
            if (subProject == null) continue;
            task.setProject(subProject.getFullPath());
        }
    }

    private void processHyperlinkData(Task task, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            task.setHyperlink(string);
            task.setHyperlinkAddress(string2);
            task.setHyperlinkSubAddress(string3);
        }
    }

    private void processHyperlinkData(Resource resource, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            resource.setHyperlink(string);
            resource.setHyperlinkAddress(string2);
            resource.setHyperlinkSubAddress(string3);
        }
    }

    private void processConstraintData() throws IOException {
        DirectoryEntry directoryEntry;
        try {
            directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCons");
        }
        catch (FileNotFoundException fileNotFoundException) {
            directoryEntry = null;
        }
        if (directoryEntry != null) {
            FixedMeta fixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
            FixedData fixedData = new FixedData(fixedMeta, 20, this.getEncryptableInputStream(directoryEntry, "FixedData"));
            int n = fixedMeta.getItemCount();
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                int n3;
                byte[] byArray;
                int n4;
                int n5;
                byte[] byArray2 = fixedMeta.getByteArrayValue(i);
                if (MPPUtility.getShort(byArray2, 0) != 0 || (n5 = fixedData.getIndexFromOffset(MPPUtility.getInt(byArray2, 4))) == -1 || (n4 = MPPUtility.getInt(byArray = fixedData.getByteArrayValue(n5), 0)) <= n2) continue;
                n2 = n4;
                int n6 = MPPUtility.getInt(byArray, 4);
                if (n6 == (n3 = MPPUtility.getInt(byArray, 8))) continue;
                Task task = this.m_file.getTaskByUniqueID(n6);
                Task task2 = this.m_file.getTaskByUniqueID(n3);
                if (task == null || task2 == null) continue;
                RelationType relationType = RelationType.getInstance(MPPUtility.getShort(byArray, 12));
                TimeUnit timeUnit = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, 14));
                Duration duration = MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(byArray, 16), timeUnit);
                Relation relation = task2.addPredecessor(task, relationType, duration);
                this.m_file.fireRelationReadEvent(relation);
            }
        }
    }

    private void processResourceData() throws IOException {
        FieldMap9 fieldMap9 = new FieldMap9(this.m_file);
        fieldMap9.createResourceFieldMap(this.m_projectProps);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 37);
        FixedData fixedData = new FixedData(fixedMeta, this.getEncryptableInputStream(directoryEntry, "FixedData"));
        TreeMap<Integer, Integer> treeMap = this.createResourceMap(fieldMap9, fixedMeta, fixedData);
        Integer[] integerArray = varMeta9.getUniqueIdentifierArray();
        RTFUtility rTFUtility = new RTFUtility();
        for (int i = 0; i < integerArray.length; ++i) {
            Integer n = integerArray[i];
            Integer n2 = treeMap.get(n);
            if (n2 == null) continue;
            byte[] byArray = fixedData.getByteArrayValue(n2);
            Resource resource = this.m_file.addResource();
            resource.disableEvents();
            fieldMap9.populateContainer(resource, n, new byte[][]{byArray}, var2Data);
            resource.enableEvents();
            this.processHyperlinkData(resource, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.HYPERLINK_DATA)));
            resource.setID(MPPUtility.getInt(byArray, 4));
            resource.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE1_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE2_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE3_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE4_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE5_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE6_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE7_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE8_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE9_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE10_INDEX), OUTLINECODE_DATA));
            resource.setType(MPPUtility.getShort(byArray, fieldMap9.getFixedDataOffset(ResourceField.WORKGROUP)) == 0 ? ResourceType.WORK : ResourceType.MATERIAL);
            resource.setUniqueID(n);
            byte[] byArray2 = fixedMeta.getByteArrayValue(n2);
            resource.setFlag1((byArray2[28] & 0x40) != 0);
            resource.setFlag2((byArray2[28] & 0x80) != 0);
            resource.setFlag3((byArray2[29] & 1) != 0);
            resource.setFlag4((byArray2[29] & 2) != 0);
            resource.setFlag5((byArray2[29] & 4) != 0);
            resource.setFlag6((byArray2[29] & 8) != 0);
            resource.setFlag7((byArray2[29] & 0x10) != 0);
            resource.setFlag8((byArray2[29] & 0x20) != 0);
            resource.setFlag9((byArray2[29] & 0x40) != 0);
            resource.setFlag10((byArray2[28] & 0x20) != 0);
            resource.setFlag11((byArray2[29] & 0x20) != 0);
            resource.setFlag12((byArray2[30] & 1) != 0);
            resource.setFlag13((byArray2[30] & 2) != 0);
            resource.setFlag14((byArray2[30] & 4) != 0);
            resource.setFlag15((byArray2[30] & 8) != 0);
            resource.setFlag16((byArray2[30] & 0x10) != 0);
            resource.setFlag17((byArray2[30] & 0x20) != 0);
            resource.setFlag18((byArray2[30] & 0x40) != 0);
            resource.setFlag19((byArray2[30] & 0x80) != 0);
            resource.setFlag20((byArray2[31] & 1) != 0);
            String string = resource.getNotes();
            if (string != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    string = rTFUtility.strip(string);
                }
                resource.setNotes(string);
            }
            resource.setResourceCalendar(this.m_resourceMap.get(n));
            this.processResourceEnterpriseColumns(fieldMap9, resource, var2Data);
            CostRateTableFactory costRateTableFactory = new CostRateTableFactory();
            costRateTableFactory.process(resource, 0, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_A)));
            costRateTableFactory.process(resource, 1, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_B)));
            costRateTableFactory.process(resource, 2, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_C)));
            costRateTableFactory.process(resource, 3, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_D)));
            costRateTableFactory.process(resource, 4, var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.COST_RATE_E)));
            AvailabilityFactory availabilityFactory = new AvailabilityFactory();
            availabilityFactory.process(resource.getAvailability(), var2Data.getByteArray(n, fieldMap9.getVarDataKey(ResourceField.AVAILABILITY_DATA)));
            this.m_file.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        FieldMap9 fieldMap9 = new FieldMap9(this.m_file);
        fieldMap9.createAssignmentFieldMap(this.m_projectProps);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 34);
        FixedData fixedData = new FixedData(142, this.getEncryptableInputStream(directoryEntry, "FixedData"));
        if (fixedData.getItemCount() != fixedMeta.getItemCount()) {
            fixedData = new FixedData(fixedMeta, this.getEncryptableInputStream(directoryEntry, "FixedData"));
        }
        ResourceAssignmentFactory resourceAssignmentFactory = new ResourceAssignmentFactory();
        resourceAssignmentFactory.process(this.m_file, fieldMap9, this.m_reader.getUseRawTimephasedData(), this.m_reader.getPreserveNoteFormatting(), varMeta9, var2Data, fixedMeta, fixedData, null);
    }

    private boolean getDurationEstimated(int n) {
        return (n & 0x20) != 0;
    }

    private void processViewData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(122, this.getEncryptableInputStream(directoryEntry, "FixedData"));
        int n = fixedMeta.getItemCount();
        ViewFactory9 viewFactory9 = new ViewFactory9();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedMeta.getByteArrayValue(i);
            int n3 = MPPUtility.getShort(byArray, 4);
            if (n3 <= n2) continue;
            byte[] byArray2 = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(n3));
            if (byArray2 != null) {
                View view = viewFactory9.createView(this.m_file, byArray, byArray2, var2Data, this.m_fontBases);
                this.m_file.addView(view);
            }
            n2 = n3;
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        FixedData fixedData = new FixedData(110, this.getEncryptableInputStream(directoryEntry, "FixedData"));
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        TableFactory tableFactory = new TableFactory(TABLE_COLUMN_DATA_STANDARD, TABLE_COLUMN_DATA_ENTERPRISE, TABLE_COLUMN_DATA_BASELINE);
        int n = fixedData.getItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedData.getByteArrayValue(i);
            Table table = tableFactory.createTable(this.m_file, byArray, varMeta9, var2Data);
            this.m_file.addTable(table);
        }
    }

    private void processFilterData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CFilter");
        FixedData fixedData = new FixedData(110, this.getEncryptableInputStream(directoryEntry, "FixedData"), true);
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FilterReader9 filterReader9 = new FilterReader9();
        filterReader9.process(this.m_file, fixedData, var2Data);
    }

    private void processGroupData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CGrouping");
        FixedData fixedData = new FixedData(110, this.getEncryptableInputStream(directoryEntry, "FixedData"));
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        GroupReader9 groupReader9 = new GroupReader9();
        groupReader9.process(this.m_file, fixedData, var2Data, this.m_fontBases);
    }

    private void processSavedViewState() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
        VarMeta9 varMeta9 = new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta9, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        InputStream inputStream = this.getEncryptableInputStream(directoryEntry, "FixedData");
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        ViewStateReader9 viewStateReader9 = new ViewStateReader9();
        viewStateReader9.process(this.m_file, var2Data, byArray);
    }

    private InputStream getEncryptableInputStream(DirectoryEntry directoryEntry, String string) throws IOException {
        DocumentEntry documentEntry = (DocumentEntry)directoryEntry.getEntry(string);
        InputStream inputStream = this.m_file.getEncoded() ? new EncryptedDocumentInputStream(documentEntry, this.m_file.getEncryptionCode()) : new DocumentInputStream(documentEntry);
        return inputStream;
    }

    private void validateTaskIDs() {
        List<Task> list = this.m_file.getAllTasks();
        if (list.size() > 1) {
            Collections.sort(list);
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < list.size(); ++i) {
                Task task = list.get(i);
                n = NumberUtility.getInt(task.getID());
                if (!task.getNull() && n2 != -1 && n > n2 + 1 && n > this.m_highestEmptyTaskID + 1) {
                    task.setNull(true);
                    continue;
                }
                n2 = n;
            }
        }
    }
}

