/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.utility.NumberUtility;

abstract class FieldMap {
    private ProjectFile m_file;
    private Map<FieldType, FieldItem> m_map = new HashMap<FieldType, FieldItem>();
    private int[] m_maxFixedDataOffset = new int[2];
    private static final Integer[] TASK_KEYS = new Integer[]{Props.TASK_FIELD_MAP, Props.TASK_FIELD_MAP2};
    private static final Integer[] RESOURCE_KEYS = new Integer[]{Props.RESOURCE_FIELD_MAP, Props.RESOURCE_FIELD_MAP2};
    private static final Integer[] ASSIGNMENT_KEYS = new Integer[]{Props.ASSIGNMENT_FIELD_MAP, Props.ASSIGNMENT_FIELD_MAP2};
    private static final int VALUE_LIST_MASK = 1792;
    private static final int MAX_FIXED_DATA_BLOCKS = 2;

    public FieldMap(ProjectFile projectFile) {
        this.m_file = projectFile;
    }

    private void createFieldMap(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byArray.length; i += 28) {
            int n3;
            Object object;
            FieldType fieldType = this.getFieldType(MPPUtility.getInt(byArray, i + 12));
            int n4 = MPPUtility.getShort(byArray, i + 4);
            int n5 = MPPUtility.getInt(byArray, i + 0);
            if (this.useTypeAsVarDataKey()) {
                object = this.substituteVarDataKey(fieldType);
                if (object == null) {
                    n3 = MPPUtility.getInt(byArray, i + 12) & 0xFFFF;
                } else {
                    n3 = object;
                    n5 = 0;
                }
            } else {
                n3 = MPPUtility.getByte(byArray, i + 6);
            }
            object = n4 != 65535 ? FieldLocation.FIXED_DATA : (n5 != 0 ? FieldLocation.META_DATA : (n3 != 0 ? FieldLocation.VAR_DATA : FieldLocation.UNKNOWN));
            if (object == FieldLocation.FIXED_DATA) {
                if (n4 < n) {
                    ++n2;
                }
                n = n4;
                if (n4 > this.m_maxFixedDataOffset[n2]) {
                    this.m_maxFixedDataOffset[n2] = n4;
                }
            }
            if (fieldType == null) continue;
            this.m_map.put(fieldType, new FieldItem(fieldType, (FieldLocation)((Object)object), n2, n4, n3));
        }
    }

    protected abstract boolean useTypeAsVarDataKey();

    protected abstract FieldItem[] getDefaultTaskData();

    protected abstract FieldItem[] getDefaultResourceData();

    protected abstract FieldItem[] getDefaultAssignmentData();

    protected abstract FieldType getFieldType(int var1);

    protected abstract Integer substituteVarDataKey(FieldType var1);

    public void createTaskFieldMap(Props props) {
        Integer n;
        byte[] byArray = null;
        Integer[] integerArray = TASK_KEYS;
        int n2 = integerArray.length;
        for (int i = 0; i < n2 && (byArray = props.getByteArray(n = integerArray[i])) == null; ++i) {
        }
        if (byArray == null) {
            this.populateDefaultData(this.getDefaultTaskData());
        } else {
            this.createFieldMap(byArray);
        }
    }

    public void createResourceFieldMap(Props props) {
        Integer n;
        byte[] byArray = null;
        Integer[] integerArray = RESOURCE_KEYS;
        int n2 = integerArray.length;
        for (int i = 0; i < n2 && (byArray = props.getByteArray(n = integerArray[i])) == null; ++i) {
        }
        if (byArray == null) {
            this.populateDefaultData(this.getDefaultResourceData());
        } else {
            this.createFieldMap(byArray);
        }
    }

    public void createAssignmentFieldMap(Props props) {
        Integer n;
        byte[] byArray = null;
        Integer[] integerArray = ASSIGNMENT_KEYS;
        int n2 = integerArray.length;
        for (int i = 0; i < n2 && (byArray = props.getByteArray(n = integerArray[i])) == null; ++i) {
        }
        if (byArray == null) {
            this.populateDefaultData(this.getDefaultAssignmentData());
        } else {
            this.createFieldMap(byArray);
        }
    }

    private void populateDefaultData(FieldItem[] fieldItemArray) {
        for (FieldItem fieldItem : fieldItemArray) {
            this.m_map.put(fieldItem.getType(), fieldItem);
        }
    }

    public void populateContainer(FieldContainer fieldContainer, Integer n, byte[][] byArray, Var2Data var2Data) {
        for (FieldItem fieldItem : this.m_map.values()) {
            Object object = fieldItem.read(n, byArray, var2Data);
            fieldContainer.set(fieldItem.getType(), object);
        }
    }

    public int getMaxFixedDataOffset(int n) {
        return this.m_maxFixedDataOffset[n];
    }

    public int getFixedDataOffset(FieldType fieldType) {
        FieldItem fieldItem = this.m_map.get(fieldType);
        int n = fieldItem != null ? fieldItem.getFixedDataOffset() : -1;
        return n;
    }

    public Integer getVarDataKey(FieldType fieldType) {
        Integer n = null;
        FieldItem fieldItem = this.m_map.get(fieldType);
        if (fieldItem != null) {
            n = fieldItem.getVarDataKey();
        }
        return n;
    }

    public FieldType getFieldTypeFromVarDataKey(Integer n) {
        FieldType fieldType = null;
        for (Map.Entry<FieldType, FieldItem> entry : this.m_map.entrySet()) {
            if (entry.getValue().getFieldLocation() != FieldLocation.VAR_DATA || !entry.getValue().getVarDataKey().equals(n)) continue;
            fieldType = entry.getKey();
            break;
        }
        return fieldType;
    }

    public FieldLocation getFieldLocation(FieldType fieldType) {
        FieldLocation fieldLocation = null;
        FieldItem fieldItem = this.m_map.get(fieldType);
        if (fieldItem != null) {
            fieldLocation = fieldItem.getFieldLocation();
        }
        return fieldLocation;
    }

    protected Object getFieldData(Integer n, FieldType fieldType, byte[][] byArray, Var2Data var2Data) {
        Object object = null;
        FieldItem fieldItem = this.m_map.get(fieldType);
        if (fieldItem != null) {
            object = fieldItem.read(n, byArray, var2Data);
        }
        return object;
    }

    protected ProjectFile getProjectFile() {
        return this.m_file;
    }

    public void clear() {
        this.m_map.clear();
        Arrays.fill(this.m_maxFixedDataOffset, 0);
    }

    public void dumpKnownFieldMaps(Props props) {
        for (int i = 50331668; i < 50331674; ++i) {
            byte[] byArray = props.getByteArray(i);
            if (byArray == null) continue;
            System.out.println("KEY: " + i);
            this.createFieldMap(byArray);
            System.out.println(this.toString());
            this.clear();
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<FieldItem> arrayList = new ArrayList<FieldItem>(this.m_map.values());
        Collections.sort(arrayList);
        printWriter.println("[FieldMap");
        for (int i = 0; i < this.m_maxFixedDataOffset.length; ++i) {
            printWriter.print(" MaxFixedOffset (block ");
            printWriter.print(i);
            printWriter.print(")=");
            printWriter.println(this.m_maxFixedDataOffset[i]);
        }
        for (FieldItem fieldItem : arrayList) {
            printWriter.print(" ");
            printWriter.println(fieldItem);
        }
        printWriter.println("]");
        printWriter.close();
        return stringWriter.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FieldItem
    implements Comparable<FieldItem> {
        private FieldType m_type;
        private FieldLocation m_location;
        private int m_fixedDataBlockIndex;
        private int m_fixedDataOffset;
        private Integer m_varDataKey;

        FieldItem(FieldType fieldType, FieldLocation fieldLocation, int n, int n2, int n3) {
            this.m_type = fieldType;
            this.m_location = fieldLocation;
            this.m_fixedDataBlockIndex = n;
            this.m_fixedDataOffset = n2;
            this.m_varDataKey = n3;
        }

        public Object read(Integer n, byte[][] byArray, Var2Data var2Data) {
            Object object = null;
            switch (this.m_location) {
                case FIXED_DATA: {
                    object = this.readFixedData(n, byArray, var2Data);
                    break;
                }
                case VAR_DATA: {
                    object = this.readVarData(n, byArray, var2Data);
                    break;
                }
                case META_DATA: {
                    break;
                }
            }
            return object;
        }

        private Object readFixedData(Integer n, byte[][] byArray, Var2Data var2Data) {
            byte[] byArray2;
            Object object = null;
            if (this.m_fixedDataBlockIndex < byArray.length && (byArray2 = byArray[this.m_fixedDataBlockIndex]) != null && this.m_fixedDataOffset < byArray2.length) {
                switch (this.m_type.getDataType()) {
                    case DATE: {
                        object = MPPUtility.getTimestamp(byArray2, this.m_fixedDataOffset);
                        break;
                    }
                    case INTEGER: {
                        object = MPPUtility.getInt(byArray2, this.m_fixedDataOffset);
                        break;
                    }
                    case DURATION: {
                        FieldType fieldType = this.m_type.getUnitsType();
                        TimeUnit timeUnit = (TimeUnit)FieldMap.this.getFieldData(n, fieldType, byArray, var2Data);
                        if (timeUnit == null) {
                            timeUnit = TimeUnit.HOURS;
                        }
                        object = MPPUtility.getAdjustedDuration(FieldMap.this.getProjectFile(), MPPUtility.getInt(byArray2, this.m_fixedDataOffset), timeUnit);
                        break;
                    }
                    case TIME_UNITS: {
                        object = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, this.m_fixedDataOffset));
                        break;
                    }
                    case CONSTRAINT: {
                        object = ConstraintType.getInstance(MPPUtility.getShort(byArray2, this.m_fixedDataOffset));
                        break;
                    }
                    case PRIORITY: {
                        object = Priority.getInstance(MPPUtility.getShort(byArray2, this.m_fixedDataOffset));
                        break;
                    }
                    case PERCENTAGE: {
                        object = MPPUtility.getPercentage(byArray2, this.m_fixedDataOffset);
                        break;
                    }
                    case TASK_TYPE: {
                        object = TaskType.getInstance(MPPUtility.getShort(byArray2, this.m_fixedDataOffset));
                        break;
                    }
                    case ACCRUE: {
                        object = AccrueType.getInstance(MPPUtility.getShort(byArray2, this.m_fixedDataOffset));
                        break;
                    }
                    case CURRENCY: {
                        object = NumberUtility.getDouble(MPPUtility.getDouble(byArray2, this.m_fixedDataOffset) / 100.0);
                        break;
                    }
                    case UNITS: {
                        object = NumberUtility.getDouble(MPPUtility.getDouble(byArray2, this.m_fixedDataOffset) / 100.0);
                        break;
                    }
                    case RATE: {
                        object = new Rate(MPPUtility.getDouble(byArray2, this.m_fixedDataOffset), TimeUnit.HOURS);
                        break;
                    }
                    case WORK: {
                        object = Duration.getInstance(MPPUtility.getDouble(byArray2, this.m_fixedDataOffset) / 60000.0, TimeUnit.HOURS);
                        break;
                    }
                    case SHORT: {
                        object = MPPUtility.getShort(byArray2, this.m_fixedDataOffset);
                        break;
                    }
                    case BOOLEAN: {
                        object = MPPUtility.getShort(byArray2, this.m_fixedDataOffset) != 0;
                        break;
                    }
                    case DELAY: {
                        object = MPPUtility.getDuration(MPPUtility.getShort(byArray2, this.m_fixedDataOffset), TimeUnit.HOURS);
                        break;
                    }
                    case WORK_UNITS: {
                        int n2 = MPPUtility.getByte(byArray2, this.m_fixedDataOffset);
                        object = n2 == 0 ? null : MPPUtility.getWorkTimeUnits(n2);
                        break;
                    }
                    case WORKGROUP: {
                        object = WorkGroup.getInstance(MPPUtility.getShort(byArray2, this.m_fixedDataOffset));
                        break;
                    }
                    case RATE_UNITS: {
                        object = TimeUnit.getInstance(MPPUtility.getShort(byArray2, this.m_fixedDataOffset) - 1);
                        break;
                    }
                    case GUID: {
                        object = MPPUtility.getGUID(byArray2, this.m_fixedDataOffset);
                        break;
                    }
                }
            }
            return object;
        }

        private Object readVarData(Integer n, byte[][] byArray, Var2Data var2Data) {
            Object object = null;
            switch (this.m_type.getDataType()) {
                case DURATION: {
                    FieldType fieldType = this.m_type.getUnitsType();
                    TimeUnit timeUnit = (TimeUnit)FieldMap.this.getFieldData(n, fieldType, byArray, var2Data);
                    if (timeUnit == null) {
                        timeUnit = TimeUnit.HOURS;
                    }
                    object = this.getCustomFieldDurationValue(var2Data, n, this.m_varDataKey, timeUnit);
                    break;
                }
                case TIME_UNITS: {
                    object = MPPUtility.getDurationTimeUnits(var2Data.getShort(n, this.m_varDataKey));
                    break;
                }
                case CURRENCY: {
                    object = NumberUtility.getDouble(var2Data.getDouble(n, this.m_varDataKey) / 100.0);
                    break;
                }
                case STRING: {
                    object = this.getCustomFieldUnicodeStringValue(var2Data, n, this.m_varDataKey);
                    break;
                }
                case DATE: {
                    object = this.getCustomFieldTimestampValue(var2Data, n, this.m_varDataKey);
                    break;
                }
                case NUMERIC: {
                    object = this.getCustomFieldDoubleValue(var2Data, n, this.m_varDataKey);
                    break;
                }
                case INTEGER: {
                    object = var2Data.getInt(n, this.m_varDataKey);
                    break;
                }
                case WORK: {
                    object = Duration.getInstance(var2Data.getDouble(n, this.m_varDataKey) / 60000.0, TimeUnit.HOURS);
                    break;
                }
                case ASCII_STRING: {
                    object = var2Data.getString(n, this.m_varDataKey);
                    break;
                }
                case DELAY: {
                    object = MPPUtility.getDuration(var2Data.getShort(n, this.m_varDataKey), TimeUnit.HOURS);
                    break;
                }
                case WORK_UNITS: {
                    int n2 = var2Data.getByte(n, this.m_varDataKey);
                    object = n2 == 0 ? null : MPPUtility.getWorkTimeUnits(n2);
                    break;
                }
                case RATE_UNITS: {
                    object = TimeUnit.getInstance(var2Data.getShort(n, this.m_varDataKey) - 1);
                    break;
                }
                case ACCRUE: {
                    object = AccrueType.getInstance(var2Data.getShort(n, this.m_varDataKey));
                    break;
                }
                case SHORT: {
                    object = var2Data.getShort(n, this.m_varDataKey);
                    break;
                }
                case BOOLEAN: {
                    object = var2Data.getShort(n, this.m_varDataKey) != 0;
                    break;
                }
                case WORKGROUP: {
                    object = WorkGroup.getInstance(var2Data.getShort(n, this.m_varDataKey));
                    break;
                }
                case GUID: {
                    object = MPPUtility.getGUID(var2Data.getByteArray(n, this.m_varDataKey), 0);
                    break;
                }
                case BINARY: {
                    break;
                }
            }
            return object;
        }

        private Object getCustomFieldTimestampValue(Var2Data var2Data, Integer n, Integer n2) {
            Object object = null;
            int n3 = var2Data.getShort(n, n2);
            if ((n3 & 0xFF00) != 1792) {
                byte[] byArray = var2Data.getByteArray(n, n2);
                if (byArray != null) {
                    if (byArray.length == 512) {
                        object = MPPUtility.getUnicodeString(byArray);
                    } else if (byArray.length >= 4) {
                        object = MPPUtility.getTimestamp(byArray);
                    }
                }
            } else {
                int n4 = var2Data.getInt(n, 2, n2);
                CustomFieldValueItem customFieldValueItem = FieldMap.this.getProjectFile().getCustomFieldValueItem(n4);
                if (customFieldValueItem != null && customFieldValueItem.getValue() != null) {
                    object = MPPUtility.getTimestamp(customFieldValueItem.getValue());
                }
            }
            return object;
        }

        private Object getCustomFieldDurationValue(Var2Data var2Data, Integer n, Integer n2, TimeUnit timeUnit) {
            Object object = null;
            byte[] byArray = var2Data.getByteArray(n, n2);
            if (byArray != null) {
                if (byArray.length == 512) {
                    object = MPPUtility.getUnicodeString(byArray);
                } else if (byArray.length >= 4) {
                    int n3 = MPPUtility.getInt(byArray);
                    object = MPPUtility.getAdjustedDuration(FieldMap.this.getProjectFile(), n3, timeUnit);
                }
            }
            return object;
        }

        private Double getCustomFieldDoubleValue(Var2Data var2Data, Integer n, Integer n2) {
            double d = 0.0;
            int n3 = var2Data.getShort(n, n2);
            if ((n3 & 0xFF00) != 1792) {
                d = var2Data.getDouble(n, n2);
            } else {
                int n4 = var2Data.getInt(n, 2, n2);
                CustomFieldValueItem customFieldValueItem = FieldMap.this.getProjectFile().getCustomFieldValueItem(n4);
                if (customFieldValueItem != null && customFieldValueItem.getValue() != null) {
                    d = MPPUtility.getDouble(customFieldValueItem.getValue());
                }
            }
            return NumberUtility.getDouble(d);
        }

        private String getCustomFieldUnicodeStringValue(Var2Data var2Data, Integer n, Integer n2) {
            String string = null;
            int n3 = var2Data.getShort(n, n2);
            if ((n3 & 0xFF00) != 1792) {
                string = var2Data.getUnicodeString(n, n2);
            } else {
                int n4 = var2Data.getInt(n, 2, n2);
                CustomFieldValueItem customFieldValueItem = FieldMap.this.getProjectFile().getCustomFieldValueItem(n4);
                if (customFieldValueItem != null && customFieldValueItem.getValue() != null) {
                    string = MPPUtility.getUnicodeString(customFieldValueItem.getValue());
                }
            }
            return string;
        }

        public FieldType getType() {
            return this.m_type;
        }

        public int getFixedDataBlockIndex() {
            return this.m_fixedDataBlockIndex;
        }

        public int getFixedDataOffset() {
            return this.m_fixedDataOffset;
        }

        public Integer getVarDataKey() {
            return this.m_varDataKey;
        }

        public FieldLocation getFieldLocation() {
            return this.m_location;
        }

        @Override
        public int compareTo(FieldItem fieldItem) {
            int n = this.m_location.compareTo(fieldItem.m_location);
            if (n == 0) {
                switch (this.m_location) {
                    case FIXED_DATA: {
                        n = this.m_fixedDataBlockIndex - fieldItem.m_fixedDataBlockIndex;
                        if (n != 0) break;
                        n = this.m_fixedDataOffset - fieldItem.m_fixedDataOffset;
                        break;
                    }
                    case VAR_DATA: {
                        n = this.m_varDataKey - fieldItem.m_varDataKey;
                        break;
                    }
                }
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[FieldItem type=");
            stringBuffer.append(this.m_type);
            stringBuffer.append(" location=");
            stringBuffer.append((Object)this.m_location);
            switch (this.m_location) {
                case FIXED_DATA: {
                    stringBuffer.append(" fixedDataBlockIndex=");
                    stringBuffer.append(this.m_fixedDataBlockIndex);
                    stringBuffer.append(" fixedDataBlockOffset=");
                    stringBuffer.append(this.m_fixedDataOffset);
                    break;
                }
                case VAR_DATA: {
                    stringBuffer.append(" varDataKey=");
                    stringBuffer.append(this.m_varDataKey);
                    break;
                }
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FieldLocation {
        FIXED_DATA,
        VAR_DATA,
        META_DATA,
        UNKNOWN;

    }
}

