/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Collections;
import java.util.Date;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Resource;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.utility.NumberUtility;

final class CostRateTableFactory {
    CostRateTableFactory() {
    }

    public void process(Resource resource, int n, byte[] byArray) {
        CostRateTable costRateTable = new CostRateTable();
        if (byArray != null) {
            int n2 = 16;
            while (n2 + 44 <= byArray.length) {
                Rate rate = new Rate(MPPUtility.getDouble(byArray, n2), TimeUnit.HOURS);
                TimeUnit timeUnit = this.getFormat(MPPUtility.getShort(byArray, n2 + 8));
                Rate rate2 = new Rate(MPPUtility.getDouble(byArray, n2 + 16), TimeUnit.HOURS);
                TimeUnit timeUnit2 = this.getFormat(MPPUtility.getShort(byArray, n2 + 24));
                Double d = NumberUtility.getDouble(MPPUtility.getDouble(byArray, n2 + 32) / 100.0);
                Date date = MPPUtility.getTimestampFromTenths(byArray, n2 + 40);
                CostRateTableEntry costRateTableEntry = new CostRateTableEntry(rate, timeUnit, rate2, timeUnit2, d, date);
                costRateTable.add(costRateTableEntry);
                n2 += 44;
            }
            Collections.sort(costRateTable);
        } else if (n == 0) {
            Rate rate = resource.getStandardRate();
            Rate rate3 = resource.getOvertimeRate();
            Number number = resource.getCostPerUse();
            CostRateTableEntry costRateTableEntry = new CostRateTableEntry(rate, rate.getUnits(), rate3, rate3.getUnits(), number, CostRateTableEntry.DEFAULT_ENTRY.getEndDate());
            costRateTable.add(costRateTableEntry);
        } else {
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
        }
        resource.setCostRateTable(n, costRateTable);
    }

    private TimeUnit getFormat(int n) {
        TimeUnit timeUnit = n == 65535 ? TimeUnit.HOURS : MPPUtility.getWorkTimeUnits(n);
        return timeUnit;
    }
}

