/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.utility.DateUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectCalendarException
extends ProjectCalendarDateRanges
implements Comparable<ProjectCalendarException> {
    private Date m_fromDate;
    private Date m_toDate;

    ProjectCalendarException(Date date, Date date2) {
        this.m_fromDate = DateUtility.getDayStartDate(date);
        this.m_toDate = DateUtility.getDayEndDate(date2);
    }

    public Date getFromDate() {
        return this.m_fromDate;
    }

    public Date getToDate() {
        return this.m_toDate;
    }

    public boolean getWorking() {
        return this.getRangeCount() != 0;
    }

    public boolean contains(Date date) {
        boolean bl = false;
        if (date != null) {
            bl = DateUtility.compare(this.getFromDate(), this.getToDate(), date) == 0;
        }
        return bl;
    }

    @Override
    public int compareTo(ProjectCalendarException projectCalendarException) {
        long l;
        long l2 = this.m_fromDate.getTime();
        return l2 < (l = projectCalendarException.m_fromDate.getTime()) ? -1 : (l2 == l ? 0 : 1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ProjectCalendarException");
        stringBuffer.append(" working=" + this.getWorking());
        stringBuffer.append(" fromDate=" + this.m_fromDate);
        stringBuffer.append(" toDate=" + this.m_toDate);
        for (DateRange dateRange : this) {
            stringBuffer.append(dateRange.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

