/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.task;

import com.projity.association.InvalidAssociationException;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.task.Portfolio;
import com.projity.pm.task.Project;
import com.projity.pm.task.ProjectFactory;
import com.projity.pm.task.Task;
import java.util.ArrayList;
import java.util.Iterator;

public class ExternalTaskManager {
    private ArrayList externalTasks = new ArrayList();

    public void add(Task task) {
        this.externalTasks.add(task);
    }

    public void handleExternalTasks(Project project, boolean bl, boolean bl2) {
        Iterator iterator = this.externalTasks.iterator();
        Portfolio portfolio = ProjectFactory.getInstance().getPortfolio();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task.getProjectId() != project.getUniqueId()) continue;
            Task task2 = project.findByUniqueId(task.getUniqueId());
            if (task.getProjectId() == task2.getProjectId()) {
                this.treatOpenedTask(task, task2, bl);
                if (!bl) continue;
                iterator.remove();
                continue;
            }
            task2.copyScheduleTo(task);
            task.setName(task2.getName());
            task.markAllDependentTasksAsNeedingRecalculation(true);
            task.recalculate(this);
        }
    }

    private void treatOpenedTask(Task task, Task task2, boolean bl) {
        task.setExternal(!bl);
        if (bl) {
            Iterator iterator = task.getSuccessorList().iterator();
            task2.invalidateSchedules();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                dependency.fireDeleteEvent(this);
                dependency.replace(task2, true);
                try {
                    dependency.testValid(false);
                }
                catch (InvalidAssociationException invalidAssociationException) {
                    dependency.setDisabled(true);
                    DependencyService.warnCircularCrossProjectLinkMessage(dependency.getPredecessor(), dependency.getSuccessor());
                }
                task2.getSuccessorList().add(dependency);
                dependency.fireCreateEvent(this);
            }
            task.getProject().removeExternal(task);
            if (task.liesInSubproject()) {
                task.getRootProject().removeExternal(task);
            }
            task2.markAllDependentTasksAsNeedingRecalculation(true);
        }
    }
}

