/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.scheduling;

import com.projity.datatype.Duration;
import com.projity.pm.scheduling.Delayable;
import com.projity.server.access.ErrorLogger;

public class DelayableImpl
implements Delayable,
Cloneable {
    private long delay = 0L;
    private long levelingDelay = 0L;
    private static final long DELAY_MAX = 28800000000L;

    public DelayableImpl(Delayable delayable) {
        this.delay = delayable.getDelay();
        this.levelingDelay = delayable.getLevelingDelay();
    }

    public DelayableImpl(long l, long l2) {
        if (l > 28800000000L) {
            ErrorLogger.logOnce("junkDelay", "In invalid delay was read in: " + l, null);
            l = 0L;
        }
        this.delay = l;
        this.levelingDelay = l2;
    }

    public DelayableImpl() {
        this.delay = 0L;
        this.levelingDelay = 0L;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getLevelingDelay() {
        return this.levelingDelay;
    }

    public long calcTotalDelay() {
        return Duration.millis(this.delay) + Duration.millis(this.levelingDelay);
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    public void setLevelingDelay(long l) {
        this.levelingDelay = l;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

