/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog.assignment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.configuration.Settings;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.ButtonPanel;
import com.projity.dialog.assignment.AssignmentEntryPane;
import com.projity.dialog.assignment.CommonAssignmentDialog;
import com.projity.dialog.assignment.ReplaceAssignmentDialog;
import com.projity.dialog.assignment.ResourceAssigner;
import com.projity.document.ObjectEvent;
import com.projity.grouping.core.NodeList;
import com.projity.grouping.core.transform.filtering.NodeFilter;
import com.projity.grouping.core.transform.filtering.NotAssignmentFilter;
import com.projity.help.HelpUtil;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.AssignmentService;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.frames.DocumentSelectedEvent;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.spreadsheet.selection.event.SelectionNodeEvent;
import com.projity.pm.graphic.spreadsheet.selection.event.SelectionNodeListener;
import com.projity.pm.resource.Resource;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import com.projity.preference.GlobalPreferences;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.DataUtils;
import com.projity.util.Environment;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class AssignmentDialog
extends AbstractDialog
implements DocumentSelectedEvent.Listener,
SelectionNodeListener,
ResourceAssigner,
ObjectEvent.Listener,
CommonAssignmentDialog {
    private static final long serialVersionUID = 1L;
    DocumentFrame documentFrame;
    AssignmentEntryPane spreadSheetPane;
    JLabel taskNames;
    JButton assignButton;
    JButton removeButton;
    JButton replaceButton;
    JButton stopEditorButton;
    JButton cancelEditorButton;
    JPanel editorsButtons = null;
    JLabel showingTeamAll = null;
    List selectedTasks = null;
    private static ArrayList emptyList = new ArrayList();
    private static final NodeFilter filter = NotAssignmentFilter.getWritableInstance();

    public AssignmentDialog(DocumentFrame documentFrame) {
        super(documentFrame.getGraphicManager().getFrame(), Messages.getString("Text.AssignResources"), false);
        this.setDocumentFrame(documentFrame);
        DocumentSelectedEvent.addListener(this);
        this.addDocHelp("Assign_Resources");
    }

    protected void initControls() {
        GraphicManager graphicManager = this.documentFrame.getGraphicManager();
        this.spreadSheetPane = new AssignmentEntryPane(this, this.documentFrame.getProject(), this, false, graphicManager.setAssignmentDialogTransformerInitializationClosure());
        this.taskNames = new JLabel();
        Project project = this.documentFrame.getProject();
        this.spreadSheetPane.setProject(project);
        this.setSelectedTasks(graphicManager.getCurrentFrame().getTopSpreadSheet().getSelectedNodes());
        AbstractAction abstractAction = new AbstractAction(Messages.getString("Text.Assign")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                AssignmentDialog.this.assign();
            }
        };
        this.assignButton = new JButton(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(Messages.getString("Text.Remove")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                AssignmentDialog.this.remove();
            }
        };
        this.removeButton = new JButton(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(Messages.getString("Text.Replace") + Settings.ELLIPSIS){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                AssignmentDialog.this.replace();
            }
        };
        this.replaceButton = new JButton(abstractAction3);
        this.stopEditorButton = new JButton(new AbstractAction(null, IconManager.getIcon("dialog.ok")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (AssignmentDialog.this.spreadSheetPane.getSpreadSheet().getCellEditor() != null) {
                    AssignmentDialog.this.spreadSheetPane.getSpreadSheet().getCellEditor().stopCellEditing();
                }
            }
        });
        this.cancelEditorButton = new JButton(new AbstractAction(null, IconManager.getIcon("dialog.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                AssignmentEntryPane.AssignmentSpreadSheet assignmentSpreadSheet = AssignmentDialog.this.spreadSheetPane.getSpreadSheet();
                if (assignmentSpreadSheet.getCellEditor() != null) {
                    assignmentSpreadSheet.getCellEditor().cancelCellEditing();
                }
                assignmentSpreadSheet.clearSelection();
            }
        });
        this.setEditorButtonsVisible(false);
        this.documentFrame.getProject().addObjectListener(this);
        this.documentFrame.getGraphicManager().getPreferences().addObjectListener(this);
    }

    public void setEditorButtonsVisible(boolean bl) {
        this.stopEditorButton.setEnabled(bl);
        this.cancelEditorButton.setEnabled(bl);
    }

    void assign() {
        AssignmentEntryPane.AssignmentSpreadSheet assignmentSpreadSheet = this.spreadSheetPane.getSpreadSheet();
        if (assignmentSpreadSheet.isEditing()) {
            assignmentSpreadSheet.getCellEditor().stopCellEditing();
        }
        this.assign(this.getSelectedResources(), 1.0);
        this.spreadSheetPane.updateTable();
    }

    void assign(List list, double d) {
        if (this.selectedTasks == null) {
            return;
        }
        Iterator iterator = this.selectedTasks.iterator();
        Object var6_4 = null;
        ArrayList<NormalTask> arrayList = new ArrayList<NormalTask>();
        while (iterator.hasNext()) {
            NormalTask normalTask;
            var6_4 = iterator.next();
            if (!(var6_4 instanceof NormalTask) || !(normalTask = (NormalTask)var6_4).isAssignable()) continue;
            arrayList.add(normalTask);
        }
        AssignmentService.getInstance().newAssignments(arrayList, list, d, 0L, this, true);
        this.spreadSheetPane.updateTable();
    }

    public void assign(Resource resource, double d) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.add(resource);
        this.assign(arrayList, d);
    }

    void remove() {
        this.remove(this.getSelectedResources());
    }

    void remove(List list) {
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            this.remove((Resource)iterator.next());
        }
        this.spreadSheetPane.updateTable();
    }

    void remove(Resource resource) {
        for (NormalTask normalTask : this.selectedTasks) {
            Assignment assignment = normalTask.findAssignment(resource);
            if (assignment == null) continue;
            AssignmentService.getInstance().remove(assignment, (Object)this, true);
        }
    }

    void replace() {
        List list = this.spreadSheetPane.getSelectedResources(true);
        if (list.size() > 1) {
            Alert.warn(Messages.getString("Message.onlyReplaceOneResourceAtATime"), this);
            return;
        }
        if (list.size() == 0) {
            return;
        }
        Resource resource = (Resource)list.get(0);
        List list2 = ReplaceAssignmentDialog.getReplacementFromDialog(this.documentFrame, resource);
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        if (!list2.contains(resource)) {
            this.remove(resource);
        } else {
            list2.remove(resource);
        }
        this.assign(list2, 1.0);
    }

    private JLabel getTeamOrAllLabel() {
        if (this.showingTeamAll == null) {
            this.showingTeamAll = new JLabel(Messages.getString("AssignmentDialog.ShowingAllResources"), IconManager.getIcon("menu24.showAllResources"), 2);
        }
        if (this.documentFrame.getGraphicManager().getPreferences().isShowProjectResourcesOnly()) {
            this.showingTeamAll.setIcon(IconManager.getIcon("menu24.showTeamResources"));
            this.showingTeamAll.setText(Messages.getString("AssignmentDialog.ShowingOnlyResourcesOnTheProjectTeam"));
        } else {
            this.showingTeamAll.setIcon(IconManager.getIcon("menu24.showAllResources"));
            this.showingTeamAll.setText(Messages.getString("AssignmentDialog.ShowingAllResources"));
        }
        HelpUtil.addDocHelp(this.showingTeamAll, "Project_Team");
        return this.showingTeamAll;
    }

    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("p, 1dlu, default ,3dlu, default", "p, 3dlu," + (Environment.getStandAlone() ? "" : "p, 3dlu,") + "fill:200dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.taskNames, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), defaultFormBuilder.getColumnCount()));
        defaultFormBuilder.nextLine(2);
        if (!Environment.getStandAlone()) {
            if (!Environment.isExternal()) {
                defaultFormBuilder.add((Component)this.getTeamOrAllLabel(), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), defaultFormBuilder.getColumnCount()));
            }
            defaultFormBuilder.nextLine(2);
        }
        defaultFormBuilder.append(this.spreadSheetPane, (Component)this.createEditorsButtons(), (Component)this.createButtons());
        return defaultFormBuilder.getPanel();
    }

    public JComponent createEditorsButtons() {
        FormLayout formLayout = new FormLayout("20px", "20dlu,20px, 3dlu, 20px");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.nextLine(1);
        defaultFormBuilder.append(this.stopEditorButton);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.cancelEditorButton);
        this.editorsButtons = defaultFormBuilder.getPanel();
        return this.editorsButtons;
    }

    public JComponent createButtons() {
        FormLayout formLayout = new FormLayout("default", "50dlu,p,3dlu,p, 3dlu, p, 3dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.nextLine(1);
        defaultFormBuilder.append(this.assignButton);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.removeButton);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.replaceButton);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(this.getHelpButton());
        return defaultFormBuilder.getPanel();
    }

    public ButtonPanel createButtonPanel() {
        return null;
    }

    public DocumentFrame getDocumentFrame() {
        return this.documentFrame;
    }

    public void setDocumentFrame(DocumentFrame documentFrame) {
        if (documentFrame != null && documentFrame.getProject() != null) {
            documentFrame.getProject().removeObjectListener(this);
        }
        this.documentFrame = documentFrame;
        Project project = documentFrame.getProject();
        project.getResourcePool().addObjectListener(this);
    }

    public void documentSelected(DocumentSelectedEvent documentSelectedEvent) {
        this.setDocumentFrame(documentSelectedEvent.getCurrent());
        this.spreadSheetPane.setProject(this.getDocumentFrame().getProject());
        this.setSelectedTasks(emptyList);
    }

    public void selectionChanged(SelectionNodeEvent selectionNodeEvent) {
        if (selectionNodeEvent.getCategory() != "taskSpreadsheet") {
            return;
        }
        List list = selectionNodeEvent.getNodes();
        this.setSelectedTasks(list);
    }

    private void setSelectedTasks(List list) {
        this.selectedTasks = NodeList.nodeListToImplList(list, filter);
        String string = this.selectedTasks.size() == 0 || !(this.selectedTasks.get(0) instanceof Task) ? Messages.getString("AssignmentDialog.none") : DataUtils.stringListWithMaxAndMessage(this.selectedTasks, Settings.STRING_LIST_LIMIT, Messages.getString("Message.tooManyTasksSelectedToList"));
        this.taskNames.setText(Messages.getString("Text.Tasks") + ": " + string);
        this.spreadSheetPane.setSelectedTasks(this.selectedTasks);
    }

    public List getSelectedResources() {
        return this.spreadSheetPane.getSelectedResources(false);
    }

    public void objectChanged(ObjectEvent objectEvent) {
        if (objectEvent.getObject() instanceof Resource) {
            this.spreadSheetPane.setProject(this.documentFrame.getProject());
        } else if (objectEvent.getObject() instanceof Assignment) {
            this.spreadSheetPane.updateTable();
        } else if (objectEvent.getObject() instanceof GlobalPreferences) {
            this.getTeamOrAllLabel();
        }
    }
}

