/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.association.AssociationList;
import com.projity.configuration.Settings;
import com.projity.dialog.InformationDialog;
import com.projity.dialog.util.FieldComponentMap;
import com.projity.grouping.core.model.NodeModel;
import com.projity.help.HelpUtil;
import com.projity.pm.costing.CostRateTable;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.frames.DocumentSelectedEvent;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.SpreadSheetUtils;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.strings.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ResourceInformationDialog
extends InformationDialog {
    private static final long serialVersionUID = 1L;
    private JTabbedPane resourceTabbedPane;
    private int notesTabIndex;
    private JLabel availabilityLabel;
    private JButton changeWorkingTimeButton;
    protected SpreadSheet assignmentSpreadSheet;
    private JScrollPane assignmentPane;
    private SpreadSheet availabilitySpreadsheet;
    JScrollPane availabilityPane;
    private SpreadSheet[] costTableSpreadsheets = new SpreadSheet[Settings.NUM_COST_RATES];
    JTabbedPane costTabbedPane;

    public static ResourceInformationDialog getInstance(Frame frame, Resource resource) {
        return new ResourceInformationDialog(frame, resource);
    }

    private ResourceInformationDialog(Frame frame, Resource resource) {
        super(frame, Messages.getString("ResourceInformationDialog.ResourceInformation"));
        this.setObjectClass(Resource.class);
        this.setObject(resource);
        this.addDocHelp("Resource_Information_Dialog");
    }

    public JComponent createContentPanel() {
        FormLayout formLayout = new FormLayout("400dlu:grow", "fill:275dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        this.resourceTabbedPane = new JTabbedPane();
        JComponent jComponent = this.createGeneralPanel();
        JComponent jComponent2 = this.createCostsPanel();
        JComponent jComponent3 = this.createAvailabilityPanel();
        this.resourceTabbedPane.addTab(Messages.getString("ResourceInformationDialog.General"), jComponent);
        this.resourceTabbedPane.addTab(Messages.getString("ResourceInformationDialog.Costs"), jComponent2);
        this.resourceTabbedPane.addTab(Messages.getString("ResourceInformationDialog.ResourceAvailability"), jComponent3);
        this.resourceTabbedPane.addTab(Messages.getString("ResourceInformationDialog.Tasks"), this.createTasksPanel());
        String string = Messages.getString("ResourceInformationDialog.Notes");
        this.resourceTabbedPane.addTab(string, this.createNotesPanel());
        this.notesTabIndex = this.resourceTabbedPane.indexOfTab(string);
        defaultFormBuilder.add(this.resourceTabbedPane);
        this.mainComponent = this.resourceTabbedPane;
        return defaultFormBuilder.getPanel();
    }

    public void showNotes() {
        this.resourceTabbedPane.setSelectedIndex(this.notesTabIndex);
    }

    public JComponent createGeneralPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("p, 3dlu, 160dlu, 3dlu, p, 3dlu, p:grow", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,0dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        fieldComponentMap.append(defaultFormBuilder, "Field.name");
        fieldComponentMap.append(defaultFormBuilder, "Field.initials");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.emailAddress");
        fieldComponentMap.append(defaultFormBuilder, "Field.group");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.rbsCode");
        fieldComponentMap.append(defaultFormBuilder, "Field.generic");
        fieldComponentMap.append(defaultFormBuilder, "Field.inactive");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.resourceType");
        fieldComponentMap.appendSometimesReadOnly(defaultFormBuilder, "Field.materialLabel");
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.addLabel(fieldComponentMap.getLabel("Field.baseCalendar") + ":");
        defaultFormBuilder.nextColumn(2);
        this.changeWorkingTimeButton = this.getChangeWorkingTimeButton();
        defaultFormBuilder.append(this.pairedComponents(fieldComponentMap, "Field.baseCalendar", 0, this.changeWorkingTimeButton));
        return defaultFormBuilder.getPanel();
    }

    public JComponent createAvailabilityPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("p:grow", "p,3dlu,p,3dlu,fill:150dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 1));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add((Component)this.createAvailabilitySpreadsheet(), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 1));
        return defaultFormBuilder.getPanel();
    }

    public JComponent createTasksPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("p:grow", "p,3dlu,p,3dlu,fill:150dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 1));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("ResourceInformationDialog.AssignedToTasks"));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add((Component)this.createAssignmentSpreadsheet(), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 1));
        JPanel jPanel = defaultFormBuilder.getPanel();
        HelpUtil.addDocHelp(jPanel, "Assign_Resources");
        return jPanel;
    }

    protected JScrollPane createAssignmentSpreadsheet() {
        this.assignmentSpreadSheet = SpreadSheetUtils.createFilteredSpreadsheet(GraphicManager.getInstance(this).getCurrentFrame(), true, "View.ResourceInformation.Assignments", "taskAssignmentSpreadsheet", "Spreadsheet.Assignment.taskUsage", false, new String[]{"Delete"});
        this.assignmentSpreadSheet.setCanModifyColumns(true);
        this.assignmentSpreadSheet.setCanSelectFieldArray(true);
        this.assignmentSpreadSheet.setActions(new String[]{"Delete"});
        this.updateAssignmentSpreadsheet();
        this.assignmentPane = SpreadSheetUtils.makeSpreadsheetScrollPane(this.assignmentSpreadSheet);
        return this.assignmentPane;
    }

    protected void updateAssignmentSpreadsheet() {
        SpreadSheetUtils.updateFilteredSpreadsheet(this.assignmentSpreadSheet, this.object == null ? new AssociationList() : ((Resource)this.object).getAssignments());
    }

    protected JScrollPane createAvailabilitySpreadsheet() {
        this.availabilitySpreadsheet = new SpreadSheet(){

            protected void doPostExceptionTreatment() {
                ResourceInformationDialog.this.updateAvailabilitySpreadsheet();
                this.requestFocus();
            }
        };
        this.availabilitySpreadsheet.setSpreadSheetCategory("availabilitySpreadsheet");
        this.availabilitySpreadsheet.setCanSelectFieldArray(false);
        ResourceImpl resourceImpl = (ResourceImpl)this.object;
        SpreadSheetUtils.createCollectionSpreadSheet(this.availabilitySpreadsheet, this.object == null ? new LinkedList() : resourceImpl.getAvailabilityTable().getList(), "View.ResourceInformation.Availability", "availabilitySpreadsheet", "Spreadsheet.availability", false, this.object == null ? null : ((ResourceImpl)this.object).getAvailabilityTable(), 1);
        this.availabilityPane = SpreadSheetUtils.makeSpreadsheetScrollPane(this.availabilitySpreadsheet);
        return this.availabilityPane;
    }

    protected void updateAvailabilitySpreadsheet() {
        SpreadSheetUtils.updateCollectionSpreadSheet(this.availabilitySpreadsheet, this.object == null ? new LinkedList() : ((ResourceImpl)this.object).getAvailabilityTable().getList(), this.object == null ? null : ((ResourceImpl)this.object).getAvailabilityTable(), 1);
        if (this.object != null) {
            ResourceImpl resourceImpl = (ResourceImpl)this.object;
            NodeModel nodeModel = ((SpreadSheetModel)this.availabilitySpreadsheet.getModel()).getCache().getModel();
            this.availabilitySpreadsheet.setReadOnly(resourceImpl.isReadOnly());
            this.availabilitySpreadsheet.setEnabled(!resourceImpl.isReadOnly());
            nodeModel.setMaster(resourceImpl.getGlobalResource().isMaster());
            nodeModel.setLocal(resourceImpl.getGlobalResource().isLocal());
        }
    }

    protected SpreadSheet createCostTableSpreadsheet(CostRateTable costRateTable) {
        SpreadSheet spreadSheet = new SpreadSheet(){

            protected void doPostExceptionTreatment() {
                ResourceInformationDialog.this.updateCostTableSpreadsheets();
                this.requestFocus();
            }
        };
        spreadSheet.setSpreadSheetCategory("costRates");
        spreadSheet.setCanSelectFieldArray(false);
        return spreadSheet;
    }

    protected void createCostTableSpreadsheets() {
        ResourceImpl resourceImpl = (ResourceImpl)this.object;
        for (int i = 0; i < Settings.NUM_COST_RATES; ++i) {
            SpreadSheetUtils.createCollectionSpreadSheet(this.costTableSpreadsheets[i], this.object == null ? new LinkedList() : resourceImpl.getCostRateTable(i).getList(), "View.ResourceInformation.CostRate", "costRates", "Spreadsheet.costRates", false, this.object == null ? null : ((Resource)this.object).getCostRateTable(i), 1);
        }
    }

    protected void updateCostTableSpreadsheets() {
        for (int i = 0; i < Settings.NUM_COST_RATES; ++i) {
            SpreadSheetUtils.updateCollectionSpreadSheet(this.costTableSpreadsheets[i], this.object == null ? new LinkedList() : ((Resource)this.object).getCostRateTable(i).getList(), this.object == null ? null : ((Resource)this.object).getCostRateTable(i), 1);
            if (this.object == null) continue;
            ResourceImpl resourceImpl = (ResourceImpl)this.object;
            NodeModel nodeModel = ((SpreadSheetModel)this.costTableSpreadsheets[i].getModel()).getCache().getModel();
            this.costTableSpreadsheets[i].setReadOnly(resourceImpl.isReadOnly());
            this.costTableSpreadsheets[i].setEnabled(!resourceImpl.isReadOnly());
            nodeModel.setMaster(resourceImpl.getGlobalResource().isMaster());
            nodeModel.setLocal(resourceImpl.getGlobalResource().isLocal());
        }
    }

    public JComponent createCostsPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("50dlu,3dlu,50dlu,3dlu,p:grow", "p,3dlu,p,3dlu,fill:p:grow,3dlu,p,3dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 5));
        this.costTabbedPane = new JTabbedPane();
        for (int i = 0; i < 5; ++i) {
            CostRateTable costRateTable = ((Resource)this.object).getCostRateTable(i);
            this.costTableSpreadsheets[i] = this.createCostTableSpreadsheet(costRateTable);
            this.costTableSpreadsheets[i].setPreferredScrollableViewportSize(new Dimension(500, 200));
            JScrollPane jScrollPane = SpreadSheet.createScrollPaneForTable(this.costTableSpreadsheets[i]);
            this.costTabbedPane.addTab(costRateTable.getName(), jScrollPane);
        }
        this.createCostTableSpreadsheets();
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.addSeparator(Messages.getString("Text.CostRateTables"));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add((Component)this.costTabbedPane, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 5));
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.accrueAt");
        return defaultFormBuilder.getPanel();
    }

    protected JComponent createHeaderFieldsPanel(FieldComponentMap fieldComponentMap) {
        FormLayout formLayout = new FormLayout("p, 3dlu, 160dlu", "p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        fieldComponentMap.append(defaultFormBuilder, "Field.name");
        return defaultFormBuilder.getPanel();
    }

    protected void setVisibleAndEnabledState() {
        super.setVisibleAndEnabledState();
        boolean bl = this.object != null && this.object instanceof Resource;
        this.assignmentPane.setVisible(bl);
        this.costTabbedPane.setVisible(bl);
        boolean bl2 = bl && ((Resource)this.object).isLabor();
        this.availabilityPane.setVisible(bl2);
    }

    public void updateAll() {
        this.activateListeners();
        super.updateAll();
        this.updateAssignmentSpreadsheet();
        this.updateCostTableSpreadsheets();
        this.updateAvailabilitySpreadsheet();
        this.changeWorkingTimeButton.setEnabled(this.getObject() != null && !((ResourceImpl)this.getObject()).isReadOnly());
    }

    public void documentSelected(DocumentSelectedEvent documentSelectedEvent) {
        if (this.assignmentSpreadSheet == null) {
            return;
        }
        DocumentFrame documentFrame = documentSelectedEvent.getCurrent();
        if (documentFrame != null) {
            NodeModelCache nodeModelCache = documentFrame.createCache(true, Messages.getString("View.TaskInformation.Assignments"));
            this.assignmentSpreadSheet.setCache(nodeModelCache);
        }
    }

    protected void activateListeners() {
        super.activateListeners();
        for (int i = 0; i < this.costTableSpreadsheets.length; ++i) {
            this.costTableSpreadsheets[i].getCache().setReceiveEvents(true);
        }
        this.availabilitySpreadsheet.getCache().setReceiveEvents(true);
    }

    protected void desactivateListeners() {
        super.desactivateListeners();
        for (int i = 0; i < this.costTableSpreadsheets.length; ++i) {
            this.costTableSpreadsheets[i].getCache().setReceiveEvents(true);
        }
        this.availabilitySpreadsheet.getCache().setReceiveEvents(false);
    }
}

