/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.hierarchy;

import com.projectlibre.core.hierarchy.DefaultHierarchyNode;
import com.projectlibre.core.hierarchy.Hierarchy;
import com.projectlibre.core.hierarchy.HierarchyNode;
import com.projectlibre.core.nodes.DefaultNode;
import com.projectlibre.core.nodes.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class DefaultHierarchy
implements Hierarchy {
    protected HierarchyNode root;
    protected Map<Node, HierarchyNode> reverseIndex = new HashMap<Node, HierarchyNode>();

    public DefaultHierarchy() {
        this.root = new DefaultHierarchyNode(new DefaultNode());
    }

    protected void addIndexEntry(HierarchyNode hierarchyNode) {
        this.reverseIndex.put(hierarchyNode.getNode(), hierarchyNode);
    }

    protected HierarchyNode removeIndexEntry(Node node) {
        return this.reverseIndex.remove(node);
    }

    public HierarchyNode findHierarchyNode(Node node) {
        return this.reverseIndex.get(node);
    }

    public void add(Node node) {
        this.root.add(node);
    }

    public void add(Node node, Node node2) {
        HierarchyNode hierarchyNode = node2 == null ? this.root : this.findHierarchyNode(node2);
        this.add(node, hierarchyNode);
    }

    public void add(Node node, HierarchyNode hierarchyNode) {
        if (hierarchyNode == null) {
            hierarchyNode = this.root;
        }
        this.addIndexEntry((hierarchyNode == null ? this.root : hierarchyNode).add(node));
    }

    public void visit(Hierarchy.Visitor visitor) {
        this.visit(visitor, Hierarchy.VisitType.PRE_ORDER);
    }

    public void visit(Hierarchy.Visitor visitor, Hierarchy.VisitType visitType) {
        this.visit(visitor, visitType, this.root);
    }

    public void visit(Hierarchy.Visitor visitor, Hierarchy.VisitType visitType, HierarchyNode hierarchyNode) {
        this.visitChildren(visitor, hierarchyNode, visitType);
    }

    protected void visitChildren(Hierarchy.Visitor visitor, HierarchyNode hierarchyNode, Hierarchy.VisitType visitType) {
        if (hierarchyNode == null) {
            hierarchyNode = this.root;
        }
        HierarchyNode hierarchyNode2 = hierarchyNode;
        Stack<Integer> stack = new Stack<Integer>();
        while (true) {
            if (hierarchyNode2.hasChildren()) {
                hierarchyNode2 = hierarchyNode2.getChildren().getFirst();
                if (visitType == Hierarchy.VisitType.PRE_ORDER) {
                    visitor.visit(hierarchyNode2);
                }
                stack.push(1);
                continue;
            }
            while (hierarchyNode2 != hierarchyNode) {
                if (visitType == Hierarchy.VisitType.POST_ORDER) {
                    visitor.visit(hierarchyNode2);
                }
                hierarchyNode2 = hierarchyNode2.getParent();
                int n = (Integer)stack.pop();
                if (n >= hierarchyNode2.getChildrenCount()) continue;
                hierarchyNode2 = hierarchyNode2.getChildren().get(n);
                if (visitType == Hierarchy.VisitType.PRE_ORDER) {
                    visitor.visit(hierarchyNode2);
                }
                stack.push(n + 1);
                break;
            }
            if (hierarchyNode2 == hierarchyNode) break;
        }
    }
}

