/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho.parser.text;

import com.sun.star.report.pentaho.parser.ElementReadHandler;
import com.sun.star.report.pentaho.parser.rpt.FixedContentReadHandler;
import com.sun.star.report.pentaho.parser.rpt.FormattedTextReadHandler;
import com.sun.star.report.pentaho.parser.rpt.ImageReadHandler;
import com.sun.star.report.pentaho.parser.rpt.SubDocumentReadHandler;
import com.sun.star.report.pentaho.parser.text.TextContentReadHandler;
import java.util.ArrayList;
import java.util.List;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.structure.StaticText;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NoCDATATextContentReadHandler
extends ElementReadHandler {
    private Section section;
    private List children = new ArrayList();
    private boolean copyType;

    public NoCDATATextContentReadHandler(Section section, boolean bl) {
        this.section = section;
        this.copyType = bl;
    }

    public NoCDATATextContentReadHandler(Section section) {
        this(section, false);
    }

    public NoCDATATextContentReadHandler() {
        this(new Section(), true);
    }

    @Override
    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        Element element = this.getElement();
        if (this.copyType) {
            this.copyElementType(element);
        }
        this.copyAttributes(attributes, element);
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if ("http://openoffice.org/2005/report".equals(string)) {
            if ("fixed-content".equals(string2)) {
                FixedContentReadHandler fixedContentReadHandler = new FixedContentReadHandler();
                this.children.add(fixedContentReadHandler);
                return fixedContentReadHandler;
            }
            if ("formatted-text".equals(string2)) {
                FormattedTextReadHandler formattedTextReadHandler = new FormattedTextReadHandler();
                this.children.add(formattedTextReadHandler);
                return formattedTextReadHandler;
            }
            if ("image".equals(string2)) {
                ImageReadHandler imageReadHandler = new ImageReadHandler();
                this.children.add(imageReadHandler);
                return imageReadHandler;
            }
            if ("sub-document".equals(string2)) {
                SubDocumentReadHandler subDocumentReadHandler = new SubDocumentReadHandler(this.section);
                return subDocumentReadHandler;
            }
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(string)) {
            ElementReadHandler elementReadHandler = "image".equals(string2) ? new ImageReadHandler() : new NoCDATATextContentReadHandler();
            this.children.add(elementReadHandler);
            return elementReadHandler;
        }
        TextContentReadHandler textContentReadHandler = new TextContentReadHandler();
        this.children.add(textContentReadHandler);
        return textContentReadHandler;
    }

    public List getChildren() {
        return this.children;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.children.size(); ++i) {
            Object e = this.children.get(i);
            if (e instanceof ElementReadHandler) {
                ElementReadHandler elementReadHandler = (ElementReadHandler)((Object)e);
                this.section.addNode(elementReadHandler.getElement());
                continue;
            }
            if (!(e instanceof StaticText)) continue;
            this.section.addNode((StaticText)e);
        }
    }

    @Override
    public Element getElement() {
        return this.section;
    }
}

