/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho.model;

import com.sun.star.report.pentaho.model.DataStyle;
import com.sun.star.report.pentaho.model.OfficeStyle;
import com.sun.star.report.pentaho.model.PageLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.report.structure.Element;

public class OfficeStyles
extends Element {
    private final Map pageStyles;
    private final Map dataStyles;
    private final Map styles = new HashMap();
    private final List otherChildren;

    public OfficeStyles() {
        this.dataStyles = new HashMap();
        this.pageStyles = new HashMap();
        this.otherChildren = new ArrayList();
    }

    public OfficeStyle getStyle(String string, String string2) {
        return (OfficeStyle)this.styles.get(new StyleKey(string, string2));
    }

    public void addStyle(OfficeStyle officeStyle) {
        if (officeStyle == null) {
            throw new NullPointerException();
        }
        String string = officeStyle.getStyleFamily();
        if (string == null) {
            throw new NullPointerException();
        }
        if (officeStyle.getStyleName() == null) {
            throw new NullPointerException();
        }
        this.styles.put(new StyleKey(string, officeStyle.getStyleName()), officeStyle);
    }

    public void addPageStyle(PageLayout pageLayout) {
        this.pageStyles.put(pageLayout.getStyleName(), pageLayout);
    }

    public PageLayout getPageStyle(String string) {
        return (PageLayout)this.pageStyles.get(string);
    }

    public void addDataStyle(DataStyle dataStyle) {
        this.dataStyles.put(dataStyle.getStyleName(), dataStyle);
    }

    public DataStyle getDataStyle(String string) {
        return (DataStyle)this.dataStyles.get(string);
    }

    public void addOtherNode(Element element) {
        this.otherChildren.add(element);
    }

    public DataStyle[] getAllDataStyles() {
        return this.dataStyles.values().toArray(new DataStyle[this.dataStyles.size()]);
    }

    public PageLayout[] getAllPageStyles() {
        return this.pageStyles.values().toArray(new PageLayout[this.pageStyles.size()]);
    }

    public OfficeStyle[] getAllStyles() {
        return this.styles.values().toArray(new OfficeStyle[this.styles.size()]);
    }

    public Element[] getOtherStyles() {
        return this.otherChildren.toArray(new Element[this.otherChildren.size()]);
    }

    public boolean containsStyle(String string, String string2) {
        return this.styles.containsKey(new StyleKey(string, string2));
    }

    public boolean containsDataStyle(String string) {
        return this.dataStyles.containsKey(string);
    }

    public static class StyleKey
    implements Serializable {
        private static final long serialVersionUID = 4931878927362887477L;
        private final String family;
        private final String name;

        public StyleKey(String string, String string2) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.family = string;
            this.name = string2;
        }

        public String getFamily() {
            return this.family;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (this != object) {
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                StyleKey styleKey = (StyleKey)object;
                if (!this.family.equals(styleKey.family) || (this.name != null ? !this.name.equals(styleKey.name) : styleKey.name != null)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int n = this.family.hashCode();
            n = 31 * n + (this.name != null ? this.name.hashCode() : 0);
            return n;
        }
    }
}

