/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.dom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.Resources;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMDocument
implements Document {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private org.w3c.dom.Document contentDoc = null;
    private String documentName = null;
    private String fileName = null;
    private String fileExt = null;
    private Resources res = Resources.getInstance();

    public DOMDocument(String string, String string2) {
        this(string, string2, true, false);
    }

    protected String getFileExtension() {
        return this.fileExt;
    }

    public DOMDocument(String string, String string2, boolean bl, boolean bl2) {
        factory.setValidating(bl2);
        factory.setNamespaceAware(bl);
        this.fileExt = string2;
        this.documentName = this.trimDocumentName(string);
        this.fileName = this.documentName + this.getFileExtension();
    }

    private String trimDocumentName(String string) {
        String string2;
        String string3 = string.toLowerCase();
        if (string3.endsWith(string2 = this.getFileExtension())) {
            int n = string.length();
            int n2 = n - string2.length();
            string = string.substring(0, n2);
        }
        return string;
    }

    public org.w3c.dom.Document getContentDOM() {
        return this.contentDoc;
    }

    public void setContentDOM(Node node) {
        this.contentDoc = (org.w3c.dom.Document)node;
    }

    @Override
    public String getName() {
        return this.documentName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
        Debug.log(1, "reading file");
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Error:" + parserConfigurationException);
        }
        try {
            this.contentDoc = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            System.out.println("Error:" + sAXException);
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = this.docToBytes(this.contentDoc);
        outputStream.write(byArray);
    }

    private byte[] docToBytes(org.w3c.dom.Document document) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        block9: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            String string = document.getClass().getName();
            System.err.println("type b " + string);
            try {
                if (string.equals("com.sun.xml.tree.XmlDocument")) {
                    System.out.println("Using JAXP");
                    object = Class.forName("com.sun.xml.tree.XmlDocument");
                    Method method = ((Class)object).getMethod("write", Class.forName("java.io.OutputStream"));
                    method.invoke((Object)document, byteArrayOutputStream);
                    break block9;
                }
                if (string.equals("org.apache.crimson.tree.XmlDocument")) {
                    System.out.println("Using Crimson");
                    object = Class.forName("org.apache.crimson.tree.XmlDocument");
                    Method method = ((Class)object).getMethod("write", Class.forName("java.io.OutputStream"));
                    method.invoke((Object)document, byteArrayOutputStream);
                    break block9;
                }
                if (string.equals("org.apache.xerces.dom.DocumentImpl") || string.equals("org.apache.xerces.dom.DeferredDocumentImpl")) {
                    System.out.println("Using Xerces");
                    object = Class.forName("org.apache.xml.serialize.XMLSerializer");
                    Constructor<?> constructor = ((Class)object).getConstructor(Class.forName("java.io.OutputStream"), Class.forName("org.apache.xml.serialize.OutputFormat"));
                    Method method = ((Class)object).getMethod("serialize", Class.forName("org.w3c.dom.Document"));
                    Object obj = constructor.newInstance(byteArrayOutputStream, null);
                    method.invoke(obj, document);
                    break block9;
                }
                if (string.equals("gnu.xml.dom.DomDocument")) {
                    System.out.println("Using GNU");
                    object = Class.forName("gnu.xml.dom.ls.DomLSSerializer");
                    Method method = ((Class)object).getMethod("serialize", Class.forName("org.w3c.dom.Node"), Class.forName("java.io.OutputStream"));
                    Object t = ((Class)object).newInstance();
                    method.invoke(t, document, byteArrayOutputStream);
                    break block9;
                }
                try {
                    DOMSource dOMSource = new DOMSource(document);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult streamResult = new StreamResult(stringWriter);
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.transform(dOMSource, streamResult);
                    return stringWriter.toString().getBytes();
                }
                catch (Exception exception) {
                    throw new IOException("No appropriate API (JAXP/Xerces) to serialize XML document: " + string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        object = byteArrayOutputStream.toByteArray();
        return object;
    }

    public final void initContentDOM() throws IOException {
        this.contentDoc = this.createDOM("");
    }

    private final org.w3c.dom.Document createDOM(String string) throws IOException {
        Object object;
        org.w3c.dom.Document document = null;
        try {
            object = factory.newDocumentBuilder();
            document = ((DocumentBuilder)object).newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Error:" + parserConfigurationException);
        }
        object = document.createElement(string);
        document.appendChild((Node)object);
        return document;
    }
}

