/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.extensions.compactnotation;

import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.extensions.compactnotation.CompactData;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactConstructor
extends Constructor {
    private static final Pattern FIRST_PATTERN = Pattern.compile("(\\p{Alpha}.*)(\\s*)\\((.*?)\\)");
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("\\s*(\\p{Alpha}\\w*)\\s*=(.+)");

    @Override
    protected Object constructScalar(ScalarNode node) {
        CompactData data = this.getCompactData(node.getValue());
        if (data != null) {
            return this.constructCompactFormat(node, data);
        }
        return super.constructScalar(node);
    }

    protected Object constructCompactFormat(ScalarNode node, CompactData data) {
        try {
            Object obj = this.createInstance(node, data);
            HashMap<String, Object> properties = new HashMap<String, Object>(data.getProperties());
            this.setProperties(obj, properties);
            return obj;
        }
        catch (Exception e) {
            throw new YAMLException(e);
        }
    }

    protected Object createInstance(ScalarNode node, CompactData data) throws Exception {
        Class<?> clazz = this.getClassForName(data.getPrefix());
        Class[] args2 = new Class[data.getArguments().size()];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            args2[i2] = String.class;
        }
        java.lang.reflect.Constructor<?> c = clazz.getDeclaredConstructor(args2);
        c.setAccessible(true);
        return c.newInstance(data.getArguments().toArray());
    }

    protected void setProperties(Object bean, Map<String, Object> data) throws Exception {
        if (data == null) {
            throw new NullPointerException("Data for Compact Object Notation cannot be null.");
        }
        for (String key2 : data.keySet()) {
            Property property = this.getPropertyUtils().getProperty(bean.getClass(), key2);
            try {
                property.set(bean, data.get(key2));
            }
            catch (IllegalArgumentException e) {
                throw new YAMLException("Cannot set property='" + key2 + "' with value='" + data.get(key2) + "' (" + data.get(key2).getClass() + ") in " + bean);
            }
        }
    }

    public CompactData getCompactData(String scalar2) {
        if (!scalar2.endsWith(")")) {
            return null;
        }
        if (scalar2.indexOf(40) < 0) {
            return null;
        }
        Matcher m = FIRST_PATTERN.matcher(scalar2);
        if (m.matches()) {
            String tag2 = m.group(1).trim();
            String content = m.group(3);
            CompactData data = new CompactData(tag2);
            if (content.length() == 0) {
                return data;
            }
            String[] names2 = content.split("\\s*,\\s*");
            for (int i2 = 0; i2 < names2.length; ++i2) {
                String section = names2[i2];
                if (section.indexOf(61) < 0) {
                    data.getArguments().add(section);
                    continue;
                }
                Matcher sm = PROPERTY_NAME_PATTERN.matcher(section);
                if (sm.matches()) {
                    String name2 = sm.group(1);
                    String value2 = sm.group(2).trim();
                    data.getProperties().put(name2, value2);
                    continue;
                }
                return null;
            }
            return data;
        }
        return null;
    }

    @Override
    protected Construct getConstructor(Node node) {
        ScalarNode scalar2;
        CompactData data;
        NodeTuple tuple;
        Node key2;
        MappingNode mnode;
        List<NodeTuple> list2;
        if (node instanceof MappingNode && (list2 = (mnode = (MappingNode)node).getValue()).size() == 1 && (key2 = (tuple = list2.get(0)).getKeyNode()) instanceof ScalarNode && (data = this.getCompactData((scalar2 = (ScalarNode)key2).getValue())) != null) {
            return new ConstructCompactObject();
        }
        return super.getConstructor(node);
    }

    protected void applySequence(Object bean, List<?> value2) {
        try {
            Property property = this.getPropertyUtils().getProperty(bean.getClass(), this.getSequencePropertyName(bean.getClass()));
            property.set(bean, value2);
        }
        catch (Exception e) {
            throw new YAMLException(e);
        }
    }

    protected String getSequencePropertyName(Class<?> bean) throws IntrospectionException {
        Set<Property> properties = this.getPropertyUtils().getProperties(bean);
        Iterator<Property> iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            if (List.class.isAssignableFrom(property.getType())) continue;
            iterator.remove();
        }
        if (properties.size() == 0) {
            throw new YAMLException("No list property found in " + bean);
        }
        if (properties.size() > 1) {
            throw new YAMLException("Many list properties found in " + bean + "; Please override getSequencePropertyName() to specify which property to use.");
        }
        return properties.iterator().next().getName();
    }

    public class ConstructCompactObject
    extends AbstractConstruct {
        public Object construct(Node node) {
            Map map = CompactConstructor.this.constructMapping((MappingNode)node);
            Map.Entry entry = map.entrySet().iterator().next();
            Object result2 = entry.getKey();
            Object value2 = entry.getValue();
            if (value2 instanceof Map) {
                Map properties = (Map)value2;
                try {
                    CompactConstructor.this.setProperties(result2, properties);
                }
                catch (Exception e) {
                    throw new YAMLException(e);
                }
            } else {
                CompactConstructor.this.applySequence(result2, (List)value2);
            }
            return result2;
        }
    }
}

