#!/bin/sh
echo 'name: crypto-api
version: 0.10.2
id: crypto-api-0.10.2-7b007cd3db78fd29c91c1498400296d7

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike) (see AUTHORS)
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: http://trac.haskell.org/crypto-api/wiki
package-url:
synopsis: A generic interface for cryptographic operations
description: A generic interface for cryptographic operations (hashes, ciphers, randomness).
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Crypto.Modes Crypto.Random Crypto.Padding
hidden-modules: Crypto.Util Crypto.CPoly
trusted: False
import-dirs: /usr/local/lib/ghc/crypto-api-0.10.2
library-dirs: /usr/local/lib/ghc/crypto-api-0.10.2
hs-libraries: HScrypto-api-0.10.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.0-4f6c2a594155b0b953c1cf0f54040f61
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         cereal-0.3.5.2-4a36143bb9e4836e68fcbca872fdfe0f
         entropy-0.2.1-e5d282f7531f6aa000696f5415aba45a
         largeword-1.0.0-e78465e0171a6724deb08169632ee18d
         tagged-0.4.4-55c603ce43bd5a4d0399cb94469b9536
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.10.2/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.10.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
