/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.operations;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.WorkbenchMessages;

public final class NonLocalUndoUserApprover
implements IOperationApprover {
    private IUndoContext context;
    private IEditorPart part;
    private Object[] elements;
    private Class affectedObjectsClass;
    private ArrayList elementsAndAdapters;

    public NonLocalUndoUserApprover(IUndoContext context, IEditorPart part, Object[] affectedObjects, Class preferredComparisonClass) {
        this.context = context;
        this.part = part;
        this.affectedObjectsClass = preferredComparisonClass;
        this.elements = affectedObjects;
    }

    public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo) {
        if (!this.requiresApproval(operation, uiInfo)) {
            return Status.OK_STATUS;
        }
        String message = NLS.bind((String)WorkbenchMessages.Operations_nonLocalRedoWarning, (Object)operation.getLabel(), (Object)this.part.getEditorInput().getName());
        return this.proceedWithOperation(operation, message, WorkbenchMessages.Operations_discardRedo);
    }

    public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo) {
        if (!this.requiresApproval(operation, uiInfo)) {
            return Status.OK_STATUS;
        }
        String message = NLS.bind((String)WorkbenchMessages.Operations_nonLocalUndoWarning, (Object)operation.getLabel(), (Object)this.part.getEditorInput().getName());
        return this.proceedWithOperation(operation, message, WorkbenchMessages.Operations_discardUndo);
    }

    private IStatus proceedWithOperation(IUndoableOperation operation, String message, String discardButton) {
        boolean local;
        if (!(operation instanceof IAdvancedUndoableOperation)) {
            return Status.OK_STATUS;
        }
        Object[] modifiedElements = ((IAdvancedUndoableOperation)operation).getAffectedObjects();
        if (modifiedElements == null) {
            local = false;
        } else {
            local = true;
            int i = 0;
            while (i < modifiedElements.length) {
                Object modifiedElement = modifiedElements[i];
                if (!this.elementsContains(modifiedElement)) {
                    local = false;
                    if (this.affectedObjectsClass != null && modifiedElement instanceof IAdaptable && this.elementsContains(((IAdaptable)modifiedElement).getAdapter(this.affectedObjectsClass))) {
                        local = true;
                    }
                    if (!local) break;
                }
                ++i;
            }
        }
        if (local) {
            return Status.OK_STATUS;
        }
        MessageDialog dialog = new MessageDialog(this.part.getSite().getShell(), this.part.getEditorInput().getName(), null, message, 3, new String[]{IDialogConstants.OK_LABEL, discardButton, IDialogConstants.CANCEL_LABEL}, 0);
        int answer = dialog.open();
        switch (answer) {
            case 0: {
                return Status.OK_STATUS;
            }
            case 1: {
                return IOperationHistory.OPERATION_INVALID_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    private boolean requiresApproval(IUndoableOperation operation, IAdaptable uiInfo) {
        IUndoContext originatingContext;
        if (!operation.hasContext(this.context)) {
            return false;
        }
        if (operation.getContexts().length == 1) {
            return false;
        }
        return uiInfo == null || (originatingContext = (IUndoContext)uiInfo.getAdapter(IUndoContext.class)) == null || originatingContext.matches(this.context);
    }

    private boolean elementsContains(Object someObject) {
        int i;
        if (this.elements == null) {
            return false;
        }
        if (this.elementsAndAdapters == null) {
            this.elementsAndAdapters = new ArrayList(this.elements.length);
            i = 0;
            while (i < this.elements.length) {
                Object adapter;
                Object element = this.elements[i];
                this.elementsAndAdapters.add(element);
                if (this.affectedObjectsClass != null && !this.affectedObjectsClass.isInstance(element) && element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(this.affectedObjectsClass)) != null) {
                    this.elementsAndAdapters.add(adapter);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.elementsAndAdapters.size()) {
            if (this.elementsAndAdapters.get(i).equals(someObject)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

