/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import org.eclipse.ui.internal.intro.impl.model.AbstractTextElement;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.url.IntroURL;
import org.eclipse.ui.internal.intro.impl.model.url.IntroURLParser;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IntroLink
extends AbstractTextElement {
    protected static final String TAG_LINK = "link";
    private static final String ATT_LABEL = "label";
    private static final String ATT_URL = "url";
    private static final String TAG_IMG = "img";
    private String label;
    private String url;
    private IntroImage img;
    private IntroURL introURL;

    IntroLink(Element element, Bundle bundle, String base) {
        super(element, bundle);
        NodeList imgElements;
        IntroURLParser parser;
        this.url = this.getAttribute(element, ATT_URL);
        this.label = this.getAttribute(element, ATT_LABEL);
        this.url = ModelUtil.resolveURL(base, this.url, bundle);
        if (this.url != null && (parser = new IntroURLParser(this.url)).hasIntroUrl()) {
            this.introURL = parser.getIntroURL();
        }
        if ((imgElements = element.getElementsByTagName(TAG_IMG)).getLength() > 0) {
            this.img = new IntroImage((Element)imgElements.item(0), this.getBundle(), base);
            this.img.setParent(this);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getUrl() {
        return this.url;
    }

    public IntroURL getIntroURL() {
        return this.introURL;
    }

    public int getType() {
        return 64;
    }

    public IntroImage getImg() {
        return this.img;
    }

    public Object clone() throws CloneNotSupportedException {
        IntroLink clone = (IntroLink)super.clone();
        if (this.img != null) {
            IntroImage cloneIntroImage = (IntroImage)this.img.clone();
            cloneIntroImage.setParent(clone);
            clone.img = cloneIntroImage;
        }
        return clone;
    }
}

