/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditFiltersOperation
extends ClasspathModifierOperation {
    private final IClasspathInformationProvider fCPInformationProvider;
    private final ClasspathModifier.IClasspathModifierListener fListener;

    public EditFiltersOperation(ClasspathModifier.IClasspathModifierListener listener, IClasspathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip, 4);
        this.fListener = listener;
        this.fCPInformationProvider = informationProvider;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        GenerateBuildPathActionGroup.EditFilterAction action = new GenerateBuildPathActionGroup.EditFilterAction();
        IStructuredSelection selection = this.fCPInformationProvider.getSelection();
        Object firstElement = selection.getFirstElement();
        action.selectionChanged(selection);
        action.run();
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(firstElement);
        if (this.fListener != null) {
            List entries = action.getCPListElements();
            this.fListener.classpathEntryChanged(entries);
        }
        this.fCPInformationProvider.handleResult(l, null, 4);
    }

    public boolean isValid(List elements, int[] types) throws JavaModelException {
        if (elements.size() != 1) {
            return false;
        }
        IJavaProject project = this.fInformationProvider.getJavaProject();
        Object element = elements.get(0);
        if (element instanceof IJavaProject) {
            if (EditFiltersOperation.isSourceFolder(project)) {
                return true;
            }
        } else if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getKind() == 1;
        }
        return false;
    }

    public String getDescription(int type) {
        if (type == 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
        }
        if (type == 2) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
        }
        if (type == 14) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Edit;
    }
}

