/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceWithStatusUtil;

public class ResourceWithStatusSorter
extends ViewerSorter {
    private boolean reversed = false;
    private int sortedColumnNumber;
    private static final int NUM_COLUMNS = 4;
    private static final int[][] SORT_ORDERS_BY_COLUMN;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 2;
        nArray3[2] = 1;
        nArray3[3] = 3;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 3;
        nArray4[2] = 1;
        nArray4[3] = 2;
        nArrayArray[3] = nArray4;
        SORT_ORDERS_BY_COLUMN = nArrayArray;
    }

    public ResourceWithStatusSorter(int sortedColumnNumber) {
        this.sortedColumnNumber = sortedColumnNumber;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        IResource r1 = (IResource)e1;
        IResource r2 = (IResource)e2;
        int[] columnSortOrder = SORT_ORDERS_BY_COLUMN[this.sortedColumnNumber];
        int result = 0;
        int i = 0;
        while (i < 4) {
            result = this.compareColumnValue(columnSortOrder[i], r1, r2);
            if (result != 0) break;
            ++i;
        }
        if (this.reversed) {
            result = -result;
        }
        return result;
    }

    private int compareColumnValue(int columnNumber, IResource r1, IResource r2) {
        switch (columnNumber) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.collator.compare(r1.getFullPath().toString(), r2.getFullPath().toString());
            }
            case 2: {
                return this.collator.compare(ResourceWithStatusUtil.getStatus(r1), ResourceWithStatusUtil.getStatus(r2));
            }
            case 3: {
                return this.collator.compare(ResourceWithStatusUtil.getPropertyStatus(r1), ResourceWithStatusUtil.getPropertyStatus(r2));
            }
        }
        return 0;
    }

    public int getColumnNumber() {
        return this.sortedColumnNumber;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean newReversed) {
        this.reversed = newReversed;
    }
}

