/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.DeltaProcessingState;
import org.rubypeople.rdt.internal.core.DeltaProcessor;
import org.rubypeople.rdt.internal.core.ModelUpdater;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyProjectElementInfo;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.builder.RubyBuilder;
import org.rubypeople.rdt.internal.core.util.Util;

public class DeltaProcessor {
    public static final int DEFAULT_CHANGE_EVENT = 0;
    private static final int NON_RUBY_RESOURCE = -1;
    public static boolean DEBUG;
    public static boolean VERBOSE;
    public static boolean PERF;
    private final ModelUpdater modelUpdater = new ModelUpdater();
    private HashSet projectCachesToReset = new HashSet();
    private HashSet refreshedElements;
    private DeltaProcessingState state;
    private RubyModelManager manager;
    private boolean isFiring = true;
    public ArrayList javaModelDeltas = new ArrayList();
    public HashMap reconcileDeltas = new HashMap();
    private Openable currentElement;
    private RubyElementDelta currentDelta;
    public int overridenEventType = -1;

    static {
        PERF = false;
    }

    public DeltaProcessor(DeltaProcessingState deltaProcessingState, RubyModelManager rubyModelManager) {
        this.state = deltaProcessingState;
        this.manager = rubyModelManager;
    }

    public void registerRubyModelDelta(IRubyElementDelta iRubyElementDelta) {
        this.javaModelDeltas.add(iRubyElementDelta);
    }

    public void updateRubyModel(IRubyElementDelta iRubyElementDelta) {
        if (iRubyElementDelta == null) {
            int n = 0;
            int n2 = this.javaModelDeltas.size();
            while (n < n2) {
                IRubyElementDelta iRubyElementDelta2 = (IRubyElementDelta)this.javaModelDeltas.get(n);
                this.modelUpdater.processRubyDelta(iRubyElementDelta2);
                ++n;
            }
        } else {
            this.modelUpdater.processRubyDelta(iRubyElementDelta);
        }
    }

    public void fire(IRubyElementDelta iRubyElementDelta, int n) {
        if (!this.isFiring) {
            return;
        }
        if (DEBUG) {
            System.out.println("-----------------------------------------------------------------------------------------------------------------------");
        }
        IRubyElementDelta iRubyElementDelta2 = iRubyElementDelta == null ? this.mergeDeltas(this.javaModelDeltas) : iRubyElementDelta;
        IElementChangedListener[] iElementChangedListenerArray = this.state.elementChangedListeners;
        int[] nArray = this.state.elementChangedListenerMasks;
        int n2 = this.state.elementChangedListenerCount;
        switch (n) {
            case 0: {
                this.firePostChangeDelta(iRubyElementDelta2, iElementChangedListenerArray, nArray, n2);
                this.fireReconcileDelta(iElementChangedListenerArray, nArray, n2);
                break;
            }
            case 1: {
                this.firePostChangeDelta(iRubyElementDelta2, iElementChangedListenerArray, nArray, n2);
                this.fireReconcileDelta(iElementChangedListenerArray, nArray, n2);
            }
        }
    }

    private IRubyElementDelta mergeDeltas(Collection collection) {
        if (collection.size() == 0) {
            return null;
        }
        if (collection.size() == 1) {
            return (IRubyElementDelta)collection.iterator().next();
        }
        if (VERBOSE) {
            System.out.println("MERGING " + collection.size() + " DELTAS [" + Thread.currentThread() + "]");
        }
        Iterator iterator = collection.iterator();
        RubyElementDelta rubyElementDelta = new RubyElementDelta(this.manager.rubyModel);
        boolean bl = false;
        while (iterator.hasNext()) {
            IRubyElement iRubyElement;
            RubyElementDelta rubyElementDelta2 = (RubyElementDelta)iterator.next();
            if (VERBOSE) {
                System.out.println(rubyElementDelta2.toString());
            }
            if (this.manager.rubyModel.equals(iRubyElement = rubyElementDelta2.getElement())) {
                IRubyElementDelta[] iRubyElementDeltaArray = rubyElementDelta2.getAffectedChildren();
                int n = 0;
                while (n < iRubyElementDeltaArray.length) {
                    RubyElementDelta rubyElementDelta3 = (RubyElementDelta)iRubyElementDeltaArray[n];
                    rubyElementDelta.insertDeltaTree(rubyElementDelta3.getElement(), rubyElementDelta3);
                    bl = true;
                    ++n;
                }
                IResourceDelta[] iResourceDeltaArray = rubyElementDelta2.getResourceDeltas();
                if (iResourceDeltaArray == null) continue;
                int n2 = 0;
                int n3 = iResourceDeltaArray.length;
                while (n2 < n3) {
                    rubyElementDelta.addResourceDelta(iResourceDeltaArray[n2]);
                    bl = true;
                    ++n2;
                }
                continue;
            }
            rubyElementDelta.insertDeltaTree(iRubyElement, rubyElementDelta2);
            bl = true;
        }
        if (bl) {
            return rubyElementDelta;
        }
        return null;
    }

    private void firePostChangeDelta(IRubyElementDelta iRubyElementDelta, IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n) {
        if (DEBUG) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(iRubyElementDelta == null ? "<NONE>" : iRubyElementDelta.toString());
        }
        if (iRubyElementDelta != null) {
            this.flush();
            this.notifyListeners(iRubyElementDelta, 1, iElementChangedListenerArray, nArray, n);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n) {
        IRubyElementDelta iRubyElementDelta = this.mergeDeltas(this.reconcileDeltas.values());
        if (DEBUG) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(iRubyElementDelta == null ? "<NONE>" : iRubyElementDelta.toString());
        }
        if (iRubyElementDelta != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(iRubyElementDelta, 4, iElementChangedListenerArray, nArray, n);
        }
    }

    public void flush() {
        this.javaModelDeltas = new ArrayList();
    }

    private void notifyListeners(IRubyElementDelta iRubyElementDelta, int n, IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n2) {
        final ElementChangedEvent elementChangedEvent = new ElementChangedEvent(iRubyElementDelta, n);
        int n3 = 0;
        while (n3 < n2) {
            if ((nArray[n3] & n) != 0) {
                final IElementChangedListener iElementChangedListener = iElementChangedListenerArray[n3];
                long l = -1L;
                if (VERBOSE) {
                    System.out.print("Listener #" + (n3 + 1) + "=" + iElementChangedListener.toString());
                    l = System.currentTimeMillis();
                }
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable throwable) {
                        Util.log(throwable, "Exception occurred in listener of Java element change notification");
                    }

                    public void run() throws Exception {
                        PerformanceStats performanceStats = null;
                        if (PERF) {
                            performanceStats = PerformanceStats.getStats((String)"org.rubypeople.rdt.core/perf/rubydeltalistener", (Object)iElementChangedListener);
                            performanceStats.startRun();
                        }
                        iElementChangedListener.elementChanged(elementChangedEvent);
                        if (PERF) {
                            performanceStats.endRun();
                        }
                    }
                });
                if (VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - l) + "ms");
                }
            }
            ++n3;
        }
    }

    /*
     * Exception decompiling
     */
    public void resourceChanged(IResourceChangeEvent var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 175->178)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IRubyElementDelta processResourceDelta(IResourceDelta iResourceDelta) {
        RubyModel rubyModel;
        block10: {
            rubyModel = this.manager.getRubyModel();
            if (rubyModel.isOpen()) break block10;
            try {
                rubyModel.open(null);
            }
            catch (RubyModelException rubyModelException) {
                if (VERBOSE) {
                    rubyModelException.printStackTrace();
                }
                IRubyElementDelta iRubyElementDelta = null;
                Object var11_7 = null;
                this.currentDelta = null;
                this.projectCachesToReset.clear();
                return iRubyElementDelta;
            }
        }
        try {
            this.state.initializeRoots();
            this.currentElement = null;
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                IResource iResource = iResourceDelta2.getResource();
                IProject iProject = (IProject)iResource;
                boolean bl = this.manager.getRubyModel().findRubyProject(iProject) != null;
                boolean bl2 = RubyProject.hasRubyNature(iProject);
                int n2 = !bl && !bl2 ? -1 : 1;
                this.traverseDelta(iResourceDelta2, n2);
                if (n2 == -1 || bl != bl2 && iResourceDelta2.getKind() == 4) {
                    try {
                        this.nonRubyResourcesChanged(rubyModel, iResourceDelta2);
                    }
                    catch (RubyModelException rubyModelException) {}
                }
                ++n;
            }
            this.resetProjectCaches();
            RubyElementDelta rubyElementDelta = this.currentDelta;
            Object var11_8 = null;
            this.currentDelta = null;
            this.projectCachesToReset.clear();
            return rubyElementDelta;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.currentDelta = null;
            this.projectCachesToReset.clear();
            throw throwable;
        }
    }

    private RubyElementDelta currentDelta() {
        if (this.currentDelta == null) {
            this.currentDelta = new RubyElementDelta(this.manager.getRubyModel());
        }
        return this.currentDelta;
    }

    private void resetProjectCaches() {
        RubyProject rubyProject;
        Iterator iterator = this.projectCachesToReset.iterator();
        HashMap hashMap = this.state.projectDependencies;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            rubyProject = (RubyProject)iterator.next();
            rubyProject.resetCaches();
            this.addDependentProjects(rubyProject, hashMap, hashSet);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            rubyProject = (RubyProject)iterator.next();
            rubyProject.resetCaches();
        }
    }

    private void addDependentProjects(IRubyProject iRubyProject, HashMap hashMap, HashSet hashSet) {
        IRubyProject[] iRubyProjectArray = (IRubyProject[])hashMap.get(iRubyProject);
        if (iRubyProjectArray == null) {
            return;
        }
        int n = 0;
        int n2 = iRubyProjectArray.length;
        while (n < n2) {
            IRubyProject iRubyProject2 = iRubyProjectArray[n];
            if (!hashSet.contains(iRubyProject2)) {
                hashSet.add(iRubyProject2);
                this.addDependentProjects(iRubyProject2, hashMap, hashSet);
            }
            ++n;
        }
    }

    private void nonRubyResourcesChanged(Openable openable, IResourceDelta iResourceDelta) throws RubyModelException {
        RubyElementDelta rubyElementDelta;
        Object object;
        if (openable.isOpen()) {
            object = (RubyElementInfo)openable.getElementInfo();
            switch (openable.getElementType()) {
                case 0: {
                    ((RubyModelInfo)object).nonRubyResources = null;
                    this.currentDelta().addResourceDelta(iResourceDelta);
                    return;
                }
                case 1: {
                    ((RubyProjectElementInfo)object).setNonRubyResources(null);
                }
            }
        }
        if ((rubyElementDelta = ((RubyElementDelta)(object = this.currentDelta())).find(openable)) == null) {
            rubyElementDelta = ((RubyElementDelta)object).changed(openable, 1);
        }
        rubyElementDelta.addResourceDelta(iResourceDelta);
    }

    private void stopDeltas() {
        this.isFiring = false;
    }

    private void startDeltas() {
        this.isFiring = true;
    }

    private void deleting(IProject iProject) {
        try {
            RubyProject rubyProject = (RubyProject)RubyCore.create(iProject);
            rubyProject.close();
            if (this.state.modelProjectsCache == null) {
                this.state.modelProjectsCache = this.manager.getRubyModel().getRubyProjects();
            }
            this.removeFromParentInfo(rubyProject);
            this.manager.resetProjectPreferences(rubyProject);
        }
        catch (RubyModelException rubyModelException) {}
    }

    private void removeFromParentInfo(Openable openable) {
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen()) {
            try {
                RubyElementInfo rubyElementInfo = (RubyElementInfo)openable2.getElementInfo();
                rubyElementInfo.removeChild(openable);
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    private boolean isAffectedBy(IResourceDelta iResourceDelta) {
        if (iResourceDelta != null) {
            class FoundRelevantDeltaException
            extends RuntimeException {
                private static final long serialVersionUID = 7137113252936111022L;
                final /* synthetic */ DeltaProcessor this$0;

                FoundRelevantDeltaException(DeltaProcessor deltaProcessor) {
                    this.this$0 = deltaProcessor;
                }
            }
            try {
                iResourceDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta iResourceDelta) {
                        switch (iResourceDelta.getKind()) {
                            case 1: 
                            case 2: {
                                throw new FoundRelevantDeltaException(DeltaProcessor.this);
                            }
                            case 4: {
                                if (iResourceDelta.getAffectedChildren().length != 0 || (iResourceDelta.getFlags() & 0xFFFCFFFF) == 0) break;
                                throw new FoundRelevantDeltaException(DeltaProcessor.this);
                            }
                        }
                        return true;
                    }
                });
            }
            catch (FoundRelevantDeltaException foundRelevantDeltaException) {
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private void checkProjectsBeingAddedOrRemoved(IResourceDelta iResourceDelta) {
        IResourceDelta[] iResourceDeltaArray;
        IResource iResource = iResourceDelta.getResource();
        boolean bl = false;
        switch (iResource.getType()) {
            case 8: {
                if (this.state.modelProjectsCache == null) {
                    try {
                        this.state.modelProjectsCache = this.manager.getRubyModel().getRubyProjects();
                    }
                    catch (RubyModelException rubyModelException) {}
                }
                bl = true;
                break;
            }
            case 4: {
                iResourceDeltaArray = (IResourceDelta[])iResource;
                RubyProject rubyProject = (RubyProject)RubyCore.create((IProject)iResourceDeltaArray);
                switch (iResourceDelta.getKind()) {
                    case 1: {
                        if (!RubyProject.hasRubyNature((IProject)iResourceDeltaArray)) break;
                        this.addToParentInfo(rubyProject);
                        break;
                    }
                    case 4: {
                        if ((iResourceDelta.getFlags() & 0x4000) != 0) {
                            if (iResourceDeltaArray.isOpen()) {
                                if (!RubyProject.hasRubyNature((IProject)iResourceDeltaArray)) break;
                                this.addToParentInfo(rubyProject);
                                break;
                            }
                            try {
                                rubyProject.close();
                            }
                            catch (RubyModelException rubyModelException) {}
                            this.removeFromParentInfo(rubyProject);
                            this.manager.removePerProjectInfo(rubyProject);
                            break;
                        }
                        if ((iResourceDelta.getFlags() & 0x80000) != 0) {
                            boolean bl2;
                            boolean bl3 = this.manager.getRubyModel().findRubyProject((IProject)iResourceDeltaArray) != null;
                            if (bl3 != (bl2 = RubyProject.hasRubyNature((IProject)iResourceDeltaArray))) {
                                if (bl2) {
                                    this.addToParentInfo(rubyProject);
                                    break;
                                }
                                this.manager.removePerProjectInfo((RubyProject)RubyCore.create((IProject)iResourceDeltaArray));
                                try {
                                    rubyProject.close();
                                }
                                catch (RubyModelException rubyModelException) {}
                                this.removeFromParentInfo(rubyProject);
                                break;
                            }
                            if (!bl2) break;
                            this.addToParentInfo(rubyProject);
                            bl = true;
                            break;
                        }
                        if (!RubyProject.hasRubyNature((IProject)iResourceDeltaArray)) break;
                        this.addToParentInfo(rubyProject);
                        bl = true;
                        break;
                    }
                    case 2: {
                        this.manager.removePerProjectInfo((RubyProject)RubyCore.create(iResource));
                    }
                }
                this.addForRefresh(rubyProject);
            }
        }
        if (bl) {
            iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                this.checkProjectsBeingAddedOrRemoved(iResourceDeltaArray[n]);
                ++n;
            }
        }
    }

    public void addForRefresh(IRubyElement iRubyElement) {
        if (this.refreshedElements == null) {
            this.refreshedElements = new HashSet();
        }
        this.refreshedElements.add(iRubyElement);
    }

    private void addToParentInfo(Openable openable) {
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen()) {
            try {
                RubyElementInfo rubyElementInfo = (RubyElementInfo)openable2.getElementInfo();
                rubyElementInfo.addChild(openable);
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    private void traverseDelta(IResourceDelta iResourceDelta, int n) {
        IResource iResource = iResourceDelta.getResource();
        boolean bl = true;
        bl = iResource instanceof IProject ? this.updateCurrentDeltaAndIndex(iResourceDelta, n) : true;
        if (bl) {
            IProject iProject;
            RubyProject rubyProject;
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            boolean bl2 = false;
            int n2 = iResourceDeltaArray.length;
            IResourceDelta[] iResourceDeltaArray2 = null;
            if (iResourceDeltaArray2 != null && (bl2 || iResource instanceof IProject) && (rubyProject = (RubyProject)RubyCore.create(iProject = iResource.getProject())) != null && RubyProject.hasRubyNature(iProject)) {
                int n3 = 0;
                while (n3 < n2) {
                    if (iResourceDeltaArray2[n3] != null) {
                        try {
                            this.nonRubyResourcesChanged(rubyProject, iResourceDeltaArray2[n3]);
                        }
                        catch (RubyModelException rubyModelException) {}
                    }
                    ++n3;
                }
            }
        }
    }

    public boolean updateCurrentDeltaAndIndex(IResourceDelta iResourceDelta, int n) {
        switch (iResourceDelta.getKind()) {
            case 1: {
                IResource iResource = iResourceDelta.getResource();
                Openable openable = this.createElement(iResource, n);
                if (openable == null) {
                    return false;
                }
                this.elementAdded(openable, iResourceDelta);
                return false;
            }
            case 2: {
                IResource iResource = iResourceDelta.getResource();
                Openable openable = this.createElement(iResource, n);
                if (openable == null) {
                    return false;
                }
                this.elementRemoved(openable, iResourceDelta);
                if (iResource.getType() == 4 && RubyBuilder.DEBUG) {
                    System.out.println("Clearing last state for removed project : " + iResource);
                }
                return false;
            }
            case 4: {
                int n2 = iResourceDelta.getFlags();
                if ((n2 & 0x100) != 0 || (n2 & 0x100000) != 0) {
                    Openable openable = this.createElement(iResourceDelta.getResource(), n);
                    if (openable == null) {
                        return false;
                    }
                    this.contentChanged(openable);
                } else if (n == 1) {
                    if ((n2 & 0x4000) != 0) {
                        IProject iProject = (IProject)iResourceDelta.getResource();
                        Openable openable = this.createElement((IResource)iProject, n);
                        if (openable == null) {
                            return false;
                        }
                        if (iProject.isOpen()) {
                            if (RubyProject.hasRubyNature(iProject)) {
                                this.addToParentInfo(openable);
                                this.currentDelta().opened(openable);
                                this.projectCachesToReset.add(openable);
                            }
                        } else {
                            boolean bl;
                            RubyModel rubyModel = this.manager.getRubyModel();
                            boolean bl2 = bl = rubyModel.findRubyProject(iProject) != null;
                            if (bl) {
                                this.close(openable);
                                this.removeFromParentInfo(openable);
                                this.currentDelta().closed(openable);
                            }
                        }
                        return false;
                    }
                    if ((n2 & 0x80000) != 0) {
                        boolean bl;
                        IProject iProject = (IProject)iResourceDelta.getResource();
                        RubyModel rubyModel = this.manager.getRubyModel();
                        boolean bl3 = rubyModel.findRubyProject(iProject) != null;
                        if (bl3 != (bl = RubyProject.hasRubyNature(iProject))) {
                            Openable openable = this.createElement((IResource)iProject, n);
                            if (openable == null) {
                                return false;
                            }
                            if (bl) {
                                this.elementAdded(openable, iResourceDelta);
                            } else {
                                this.elementRemoved(openable, iResourceDelta);
                                if (RubyBuilder.DEBUG) {
                                    System.out.println("Clearing last state for project losing Ruby nature: " + iProject);
                                }
                            }
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return true;
    }

    private void close(Openable openable) {
        try {
            openable.close();
        }
        catch (RubyModelException rubyModelException) {}
    }

    private Openable createElement(IResource iResource, int n) {
        if (iResource == null) {
            return null;
        }
        IPath iPath = iResource.getFullPath();
        IRubyElement iRubyElement = null;
        switch (n) {
            case 1: {
                if (!(iResource instanceof IProject)) break;
                this.popUntilPrefixOf(iPath);
                if (this.currentElement != null && this.currentElement.getElementType() == 1 && ((IRubyProject)((Object)this.currentElement)).getProject().equals((Object)iResource)) {
                    return this.currentElement;
                }
                IProject iProject = (IProject)iResource;
                if (RubyProject.hasRubyNature(iProject)) {
                    iRubyElement = RubyCore.create(iProject);
                    break;
                }
                iRubyElement = this.manager.getRubyModel().findRubyProject(iProject);
                break;
            }
            case 2: {
                this.popUntilPrefixOf(iPath);
                iRubyElement = RubyCore.create(iResource);
            }
        }
        if (iRubyElement == null) {
            return null;
        }
        this.currentElement = (Openable)iRubyElement;
        return this.currentElement;
    }

    private void popUntilPrefixOf(IPath iPath) {
        while (this.currentElement != null) {
            IPath iPath2 = null;
            IResource iResource = this.currentElement.getResource();
            if (iResource != null) {
                iPath2 = iResource.getFullPath();
            }
            if (iPath2 != null && iPath2.isPrefixOf(iPath)) {
                return;
            }
            this.currentElement = (Openable)this.currentElement.getParent();
        }
    }

    private void elementAdded(Openable openable, IResourceDelta iResourceDelta) {
        int n = openable.getElementType();
        if (n == 1) {
            if (iResourceDelta != null && RubyProject.hasRubyNature((IProject)iResourceDelta.getResource())) {
                this.addToParentInfo(openable);
                if ((iResourceDelta.getFlags() & 0x1000) != 0) {
                    Openable openable2 = (Openable)((Object)openable.getRubyModel().getRubyProject(iResourceDelta.getMovedFromPath().lastSegment()));
                    this.currentDelta().movedTo(openable, openable2);
                } else {
                    this.currentDelta().added(openable);
                }
                this.projectCachesToReset.add(openable);
            }
        } else if (iResourceDelta == null || (iResourceDelta.getFlags() & 0x1000) == 0) {
            if (this.isPrimaryWorkingCopy(openable, n)) {
                this.currentDelta().changed(openable, 262144);
            } else {
                this.addToParentInfo(openable);
                this.close(openable);
                this.currentDelta().added(openable);
            }
        } else {
            Openable openable3;
            this.addToParentInfo(openable);
            this.close(openable);
            IPath iPath = iResourceDelta.getMovedFromPath();
            IResource iResource = iResourceDelta.getResource();
            Object object = iResource instanceof IFile ? iResource.getWorkspace().getRoot().getFile(iPath) : iResource.getWorkspace().getRoot().getFolder(iPath);
            int n2 = this.elementType((IResource)object, 2, openable.getParent().getElementType());
            this.currentElement = null;
            Openable openable4 = openable3 = n != 1 && n2 == 1 ? null : this.createElement((IResource)object, n2);
            if (openable3 == null) {
                this.currentDelta().added(openable);
            } else {
                this.currentDelta().movedTo(openable, openable3);
            }
        }
    }

    private boolean isPrimaryWorkingCopy(IRubyElement iRubyElement, int n) {
        if (n == 2) {
            RubyScript rubyScript = (RubyScript)iRubyElement;
            return rubyScript.isPrimary() && rubyScript.isWorkingCopy();
        }
        return false;
    }

    private void elementRemoved(Openable openable, IResourceDelta iResourceDelta) {
        int n = openable.getElementType();
        if (iResourceDelta == null || (iResourceDelta.getFlags() & 0x2000) == 0) {
            if (this.isPrimaryWorkingCopy(openable, n)) {
                this.currentDelta().changed(openable, 262144);
            } else {
                this.close(openable);
                this.removeFromParentInfo(openable);
                this.currentDelta().removed(openable);
            }
        } else {
            Openable openable2;
            IFolder iFolder;
            this.close(openable);
            this.removeFromParentInfo(openable);
            IPath iPath = iResourceDelta.getMovedToPath();
            IResource iResource = iResourceDelta.getResource();
            switch (iResource.getType()) {
                case 4: {
                    iFolder = iResource.getWorkspace().getRoot().getProject(iPath.lastSegment());
                    break;
                }
                case 2: {
                    iFolder = iResource.getWorkspace().getRoot().getFolder(iPath);
                    break;
                }
                case 1: {
                    iFolder = iResource.getWorkspace().getRoot().getFile(iPath);
                    break;
                }
                default: {
                    return;
                }
            }
            int n2 = this.elementType((IResource)iFolder, 1, openable.getParent().getElementType());
            this.currentElement = null;
            Openable openable3 = openable2 = n != 1 && n2 == 1 ? null : this.createElement((IResource)iFolder, n2);
            if (openable2 == null) {
                this.currentDelta().removed(openable);
            } else {
                this.currentDelta().movedFrom(openable, openable2);
            }
        }
        switch (n) {
            case 1: {
                this.projectCachesToReset.add(openable);
            }
        }
    }

    private void contentChanged(Openable openable) {
        boolean bl = false;
        boolean bl2 = false;
        if (openable.getElementType() == 2) {
            RubyScript rubyScript = (RubyScript)openable;
            bl = rubyScript.isPrimary();
            boolean bl3 = bl2 = bl && rubyScript.isWorkingCopy();
        }
        if (bl2) {
            this.currentDelta().changed(openable, 262144);
        } else {
            this.close(openable);
            int n = 1;
            if (bl) {
                n |= 0x40000;
            }
            this.currentDelta().changed(openable, n);
        }
    }

    private int elementType(IResource iResource, int n, int n2) {
        switch (n2) {
            case 0: {
                return 1;
            }
            case -1: 
            case 1: {
                if (iResource.getType() == 2) {
                    return -1;
                }
                String string = iResource.getName();
                if (Util.isValidRubyScriptName(string)) {
                    return 2;
                }
                return -1;
            }
        }
        return -1;
    }
}

