/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.model;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.rubypeople.rdt.internal.debug.core.model.RubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;

public class RubyValue
extends PlatformObject
implements IValue {
    private String valueString;
    private String referenceTypeName;
    private boolean hasChildren;
    private RubyVariable owner;
    private RubyVariable[] variables;

    public RubyValue(RubyVariable rubyVariable) {
        this(rubyVariable, "nil", null, false);
    }

    public RubyValue(RubyVariable rubyVariable, String string, String string2, boolean bl) {
        this.valueString = string;
        this.owner = rubyVariable;
        this.hasChildren = bl;
        this.referenceTypeName = string2;
    }

    public String getReferenceTypeName() {
        return this.referenceTypeName;
    }

    public String getValueString() {
        return this.valueString;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public IVariable[] getVariables() throws DebugException {
        if (!this.hasChildren) {
            return new RubyVariable[0];
        }
        if (this.variables == null) {
            this.variables = ((RubyDebugTarget)this.getDebugTarget()).getRubyDebuggerProxy().readInstanceVariables(this.owner);
        }
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return this.hasChildren;
    }

    public String getModelIdentifier() {
        return this.owner.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.owner.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public String toString() {
        if (this.getReferenceTypeName() == null) {
            return this.getValueString();
        }
        return this.getValueString();
    }
}

