/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import java.util.Iterator;

public class UnionResults {
    public static SortedBugCollection union(SortedBugCollection origCollection, SortedBugCollection newCollection) {
        SortedBugCollection result = origCollection.duplicate();
        Iterator<BugInstance> i = newCollection.iterator();
        while (i.hasNext()) {
            BugInstance bugInstance = i.next();
            result.add(bugInstance);
        }
        ProjectStats stats = result.getProjectStats();
        ProjectStats stats2 = newCollection.getProjectStats();
        stats.addStats(stats2);
        return result;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length == 0 || "-help".equals(argv[0])) {
            System.err.println("Usage: " + UnionResults.class.getName() + " <results1> <results2> ... <resultsn>");
            System.exit(1);
        }
        SortedBugCollection results = new SortedBugCollection();
        results.readXML(argv[0], new Project());
        for (int i = 1; i < argv.length; ++i) {
            SortedBugCollection more = new SortedBugCollection();
            more.readXML(argv[i], new Project());
            results = UnionResults.union(results, more);
        }
        results.writeXML(System.out, new Project());
    }

    static {
        DetectorFactoryCollection.instance();
    }
}

