/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IClassFactory;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IClassPathBuilder;
import edu.umd.cs.findbugs.classfile.IClassPathBuilderProgress;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import edu.umd.cs.findbugs.classfile.IScannableCodeBase;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParser;
import edu.umd.cs.findbugs.io.IO;
import edu.umd.cs.findbugs.util.Archive;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathBuilder
implements IClassPathBuilder {
    private static final boolean VERBOSE = SystemProperties.getBoolean("findbugs2.builder.verbose");
    private static final boolean DEBUG = VERBOSE || SystemProperties.getBoolean("findbugs2.builder.debug");
    private static final boolean NO_PARSE_CLASS_NAMES = SystemProperties.getBoolean("findbugs2.builder.noparseclassnames");
    private IClassFactory classFactory;
    private IErrorLogger errorLogger;
    private LinkedList<WorkListItem> projectWorkList;
    private LinkedList<DiscoveredCodeBase> discoveredCodeBaseList;
    private Map<String, DiscoveredCodeBase> discoveredCodeBaseMap;
    private LinkedList<ClassDescriptor> appClassList;
    private boolean scanNestedArchives;

    ClassPathBuilder(IClassFactory classFactory, IErrorLogger errorLogger) {
        this.classFactory = classFactory;
        this.errorLogger = errorLogger;
        this.projectWorkList = new LinkedList();
        this.discoveredCodeBaseList = new LinkedList();
        this.discoveredCodeBaseMap = new HashMap<String, DiscoveredCodeBase>();
        this.appClassList = new LinkedList();
    }

    @Override
    public void addCodeBase(ICodeBaseLocator locator, boolean isApplication) {
        this.addToWorkList(this.projectWorkList, new WorkListItem(locator, isApplication, 0));
    }

    @Override
    public void scanNestedArchives(boolean scanNestedArchives) {
        this.scanNestedArchives = scanNestedArchives;
    }

    @Override
    public void build(IClassPath classPath, IClassPathBuilderProgress progress) throws CheckedAnalysisException, IOException, InterruptedException {
        this.processWorkList(classPath, this.projectWorkList, progress);
        boolean foundJavaLangObject = false;
        for (DiscoveredCodeBase discoveredCodeBase : this.discoveredCodeBaseList) {
            try {
                ICodeBaseEntry entry = discoveredCodeBase.getCodeBase().lookupResource("java/lang/Object.class");
                foundJavaLangObject = true;
            }
            catch (ResourceNotFoundException e) {}
        }
        if (!foundJavaLangObject) {
            this.processWorkList(classPath, this.buildSystemCodebaseList(), progress);
        }
        for (DiscoveredCodeBase discoveredCodeBase : this.discoveredCodeBaseList) {
            classPath.addCodeBase(discoveredCodeBase.getCodeBase());
        }
        HashSet<ClassDescriptor> appClassSet = new HashSet<ClassDescriptor>();
        for (DiscoveredCodeBase discoveredCodeBase : this.discoveredCodeBaseList) {
            if (!discoveredCodeBase.getCodeBase().isApplicationCodeBase()) continue;
            ICodeBaseIterator i = discoveredCodeBase.iterator();
            while (i.hasNext()) {
                ICodeBaseEntry entry = i.next();
                if (!ClassDescriptor.isClassResource(entry.getResourceName())) continue;
                ClassDescriptor classDescriptor = entry.getClassDescriptor();
                if (classDescriptor == null) {
                    throw new IllegalStateException();
                }
                if (appClassSet.contains(classDescriptor)) continue;
                appClassSet.add(classDescriptor);
                this.appClassList.add(classDescriptor);
                classPath.mapResourceNameToCodeBaseEntry(entry.getResourceName(), entry);
            }
        }
        if (DEBUG) {
            System.out.println("Classpath:");
            this.dumpCodeBaseList(classPath.appCodeBaseIterator(), "Application codebases");
            this.dumpCodeBaseList(classPath.auxCodeBaseIterator(), "Auxiliary codebases");
        }
    }

    private void dumpCodeBaseList(Iterator<? extends ICodeBase> i, String desc) throws InterruptedException {
        System.out.println(new StringBuffer().append("  ").append(desc).append(":").toString());
        while (i.hasNext()) {
            ICodeBase codeBase = i.next();
            System.out.println(new StringBuffer().append("    ").append(((Object)codeBase.getCodeBaseLocator()).toString()).toString());
            if (!codeBase.containsSourceFiles()) continue;
            System.out.println("      * contains source files");
        }
    }

    private LinkedList<WorkListItem> buildSystemCodebaseList() {
        LinkedList<WorkListItem> workList = new LinkedList<WorkListItem>();
        String bootClassPath = SystemProperties.getProperty("sun.boot.class.path");
        this.addWorkListItemsForClasspath(workList, bootClassPath);
        String extPath = SystemProperties.getProperty("java.ext.dirs");
        if (extPath != null) {
            StringTokenizer st = new StringTokenizer(extPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String extDir = st.nextToken();
                this.addWorkListItemsForExtDir(workList, extDir);
            }
        }
        return workList;
    }

    private void addWorkListItemsForClasspath(LinkedList<WorkListItem> workList, String path) {
        if (path == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("System classpath entry: ").append(entry).toString());
            }
            this.addToWorkList(workList, new WorkListItem(this.classFactory.createFilesystemCodeBaseLocator(entry), false, 3));
        }
    }

    private void addWorkListItemsForExtDir(LinkedList<WorkListItem> workList, String extDir) {
        File dir = new File(extDir);
        File[] fileList = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String path = pathname.getParent();
                return Archive.isArchiveFileName(path);
            }
        });
        if (fileList == null) {
            return;
        }
        for (File archive : fileList) {
            this.addToWorkList(workList, new WorkListItem(this.classFactory.createFilesystemCodeBaseLocator(archive.getPath()), false, 3));
        }
    }

    private void processWorkList(IClassPath classPath, LinkedList<WorkListItem> workList, IClassPathBuilderProgress progress) throws InterruptedException, IOException, ResourceNotFoundException {
        while (!workList.isEmpty()) {
            WorkListItem item;
            block10: {
                DiscoveredCodeBase discoveredCodeBase;
                item = workList.removeFirst();
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Working: ").append(item.getCodeBaseLocator()).toString());
                }
                if ((discoveredCodeBase = this.discoveredCodeBaseMap.get(((Object)item.getCodeBaseLocator()).toString())) != null) {
                    if (discoveredCodeBase.getCodeBase().isApplicationCodeBase() || !item.isAppCodeBase()) continue;
                    discoveredCodeBase.getCodeBase().setApplicationCodeBase(true);
                    continue;
                }
                try {
                    discoveredCodeBase = new DiscoveredCodeBase(item.getCodeBaseLocator().openCodeBase());
                    discoveredCodeBase.getCodeBase().setApplicationCodeBase(item.isAppCodeBase());
                    discoveredCodeBase.getCodeBase().setHowDiscovered(item.getHowDiscovered());
                    this.discoveredCodeBaseMap.put(((Object)item.getCodeBaseLocator()).toString(), discoveredCodeBase);
                    this.discoveredCodeBaseList.addLast(discoveredCodeBase);
                    if (discoveredCodeBase.getCodeBase() instanceof IScannableCodeBase && discoveredCodeBase.codeBase.isApplicationCodeBase()) {
                        this.scanCodebase(classPath, workList, discoveredCodeBase);
                    }
                    this.scanJarManifestForClassPathEntries(workList, discoveredCodeBase.getCodeBase());
                }
                catch (IOException e) {
                    if (item.isAppCodeBase()) {
                        throw e;
                    }
                    if (item.getHowDiscovered() == 0) {
                        this.errorLogger.logError(new StringBuffer().append("Cannot open codebase ").append(item.getCodeBaseLocator()).toString(), e);
                    }
                }
                catch (ResourceNotFoundException e) {
                    if (item.isAppCodeBase()) {
                        throw e;
                    }
                    if (item.getHowDiscovered() != 0) break block10;
                    this.errorLogger.logError(new StringBuffer().append("Cannot open codebase ").append(item.getCodeBaseLocator()).toString(), e);
                }
            }
            if (item.getHowDiscovered() != 0) continue;
            progress.finishArchive();
        }
    }

    private void scanCodebase(IClassPath classPath, LinkedList<WorkListItem> workList, DiscoveredCodeBase discoveredCodeBase) throws InterruptedException {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Scanning ").append(discoveredCodeBase.getCodeBase().getCodeBaseLocator()).toString());
        }
        IScannableCodeBase codeBase = (IScannableCodeBase)discoveredCodeBase.getCodeBase();
        ICodeBaseIterator i = codeBase.iterator();
        while (i.hasNext()) {
            ICodeBaseEntry entry = i.next();
            if (VERBOSE) {
                System.out.println(new StringBuffer().append("Entry: ").append(entry.getResourceName()).toString());
            }
            if (!NO_PARSE_CLASS_NAMES && codeBase.isApplicationCodeBase() && ClassDescriptor.isClassResource(entry.getResourceName())) {
                this.parseClassName(entry);
            }
            discoveredCodeBase.addCodeBaseEntry(entry);
            if (!this.scanNestedArchives || !codeBase.isApplicationCodeBase() || !Archive.isArchiveFileName(entry.getResourceName())) continue;
            if (VERBOSE) {
                System.out.println("Entry is an archive!");
            }
            ICodeBaseLocator nestedArchiveLocator = this.classFactory.createNestedArchiveCodeBaseLocator(codeBase, entry.getResourceName());
            this.addToWorkList(workList, new WorkListItem(nestedArchiveLocator, codeBase.isApplicationCodeBase(), 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parseClassName(ICodeBaseEntry entry) {
        DataInputStream in = null;
        try {
            in = new DataInputStream(entry.openResource());
            ClassParser parser = new ClassParser(in, null, entry);
            ClassNameAndSuperclassInfo classInfo = new ClassNameAndSuperclassInfo();
            parser.parse(classInfo);
            entry.overrideResourceName(classInfo.getClassDescriptor().toResourceName());
        }
        catch (IOException e) {
            this.errorLogger.logError(new StringBuffer().append("Invalid class resource ").append(entry.getResourceName()).append(" in ").append(entry).toString(), e);
            IO.close(in);
        }
        catch (InvalidClassFileFormatException e2) {
            this.errorLogger.logError(new StringBuffer().append("Invalid class resource ").append(entry.getResourceName()).append(" in ").append(entry).toString(), e2);
            {
                catch (Throwable throwable) {
                    IO.close(in);
                    throw throwable;
                }
            }
            IO.close(in);
        }
        IO.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJarManifestForClassPathEntries(LinkedList<WorkListItem> workList, ICodeBase codeBase) throws IOException {
        try {
            ICodeBaseEntry manifestEntry = codeBase.lookupResource("META-INF/MANIFEST.MF");
            InputStream in = null;
            try {
                in = manifestEntry.openResource();
                Manifest manifest = new Manifest(in);
                Attributes mainAttrs = manifest.getMainAttributes();
                String classPath = mainAttrs.getValue("Class-Path");
                if (classPath != null) {
                    String[] pathList;
                    for (String path : pathList = classPath.split("\\s+")) {
                        ICodeBaseLocator relativeCodeBaseLocator = codeBase.getCodeBaseLocator().createRelativeCodeBaseLocator(path);
                        this.addToWorkList(workList, new WorkListItem(relativeCodeBaseLocator, false, 2));
                    }
                }
            }
            finally {
                if (in != null) {
                    IO.close(in);
                }
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
    }

    private void addToWorkList(LinkedList<WorkListItem> workList, WorkListItem itemToAdd) {
        if (DEBUG) {
            new RuntimeException(new StringBuffer().append("Adding work list item ").append(itemToAdd).toString()).printStackTrace(System.out);
        }
        if (!itemToAdd.isAppCodeBase()) {
            workList.addLast(itemToAdd);
            return;
        }
        ListIterator<WorkListItem> i = workList.listIterator();
        while (i.hasNext()) {
            WorkListItem listItem = (WorkListItem)i.next();
            if (listItem.isAppCodeBase()) continue;
            i.previous();
            break;
        }
        i.add(itemToAdd);
    }

    @Override
    public List<ClassDescriptor> getAppClassList() {
        return this.appClassList;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoveredCodeBase {
        ICodeBase codeBase;
        LinkedList<ICodeBaseEntry> resourceList;

        public DiscoveredCodeBase(ICodeBase codeBase) {
            this.codeBase = codeBase;
            this.resourceList = new LinkedList();
        }

        public ICodeBase getCodeBase() {
            return this.codeBase;
        }

        public LinkedList<ICodeBaseEntry> getResourceList() {
            return this.resourceList;
        }

        public void addCodeBaseEntry(ICodeBaseEntry entry) {
            this.resourceList.add(entry);
        }

        public ICodeBaseIterator iterator() throws InterruptedException {
            if (this.codeBase instanceof IScannableCodeBase) {
                return ((IScannableCodeBase)this.codeBase).iterator();
            }
            return new ICodeBaseIterator(){

                public boolean hasNext() throws InterruptedException {
                    return false;
                }

                public ICodeBaseEntry next() throws InterruptedException {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class WorkListItem {
        private ICodeBaseLocator codeBaseLocator;
        private boolean isAppCodeBase;
        private int howDiscovered;

        public String toString() {
            return "WorkListItem(" + this.codeBaseLocator + ", " + this.isAppCodeBase + ", " + this.howDiscovered + ")";
        }

        public WorkListItem(ICodeBaseLocator codeBaseLocator, boolean isApplication, int howDiscovered) {
            this.codeBaseLocator = codeBaseLocator;
            this.isAppCodeBase = isApplication;
            this.howDiscovered = howDiscovered;
        }

        public ICodeBaseLocator getCodeBaseLocator() {
            return this.codeBaseLocator;
        }

        public boolean isAppCodeBase() {
            return this.isAppCodeBase;
        }

        public int getHowDiscovered() {
            return this.howDiscovered;
        }
    }
}

