/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.plus.jaas.JAASUserPrincipal;
import org.eclipse.jetty.plus.jaas.callback.ObjectCallback;
import org.eclipse.jetty.plus.jaas.callback.RequestParameterCallback;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JAASLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final Logger LOG = Log.getLogger(JAASLoginService.class);
    public static String DEFAULT_ROLE_CLASS_NAME = "org.eclipse.jetty.plus.jaas.JAASRole";
    public static String[] DEFAULT_ROLE_CLASS_NAMES = new String[]{DEFAULT_ROLE_CLASS_NAME};
    protected String[] _roleClassNames = DEFAULT_ROLE_CLASS_NAMES;
    protected String _callbackHandlerClass;
    protected String _realmName;
    protected String _loginModuleName;
    protected JAASUserPrincipal _defaultUser = new JAASUserPrincipal(null, null, null);
    protected IdentityService _identityService;

    public JAASLoginService() {
    }

    public JAASLoginService(String name) {
        this();
        this._realmName = name;
        this._loginModuleName = name;
    }

    public String getName() {
        return this._realmName;
    }

    public void setName(String name) {
        this._realmName = name;
    }

    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this._identityService = identityService;
    }

    public void setLoginModuleName(String name) {
        this._loginModuleName = name;
    }

    public void setCallbackHandlerClass(String classname) {
        this._callbackHandlerClass = classname;
    }

    public void setRoleClassNames(String[] classnames) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (classnames != null) {
            tmp.addAll(Arrays.asList(classnames));
        }
        if (!tmp.contains(DEFAULT_ROLE_CLASS_NAME)) {
            tmp.add(DEFAULT_ROLE_CLASS_NAME);
        }
        this._roleClassNames = tmp.toArray(new String[tmp.size()]);
    }

    public String[] getRoleClassNames() {
        return this._roleClassNames;
    }

    protected void doStart() throws Exception {
        if (this._identityService == null) {
            this._identityService = new DefaultIdentityService();
        }
        super.doStart();
    }

    public UserIdentity login(final String username, final Object credentials) {
        try {
            CallbackHandler callbackHandler = null;
            if (this._callbackHandlerClass == null) {
                callbackHandler = new CallbackHandler(){

                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (Callback callback : callbacks) {
                            if (callback instanceof NameCallback) {
                                ((NameCallback)callback).setName(username);
                                continue;
                            }
                            if (callback instanceof PasswordCallback) {
                                ((PasswordCallback)callback).setPassword(credentials.toString().toCharArray());
                                continue;
                            }
                            if (callback instanceof ObjectCallback) {
                                ((ObjectCallback)callback).setObject(credentials);
                                continue;
                            }
                            if (callback instanceof RequestParameterCallback) {
                                Request request;
                                AbstractHttpConnection connection = AbstractHttpConnection.getCurrentConnection();
                                Request request2 = request = connection == null ? null : connection.getRequest();
                                if (request == null) continue;
                                RequestParameterCallback rpc = (RequestParameterCallback)callback;
                                rpc.setParameterValues(Arrays.asList(request.getParameterValues(rpc.getParameterName())));
                                continue;
                            }
                            throw new UnsupportedCallbackException(callback);
                        }
                    }
                };
            } else {
                Class clazz = Loader.loadClass(this.getClass(), this._callbackHandlerClass);
                callbackHandler = (CallbackHandler)clazz.newInstance();
            }
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this._loginModuleName, subject, callbackHandler);
            loginContext.login();
            JAASUserPrincipal userPrincipal = new JAASUserPrincipal(this.getUserName(callbackHandler), subject, loginContext);
            subject.getPrincipals().add(userPrincipal);
            return this._identityService.newUserIdentity(subject, userPrincipal, this.getGroups(subject));
        }
        catch (LoginException e) {
            LOG.warn(e);
        }
        catch (IOException e) {
            LOG.warn(e);
        }
        catch (UnsupportedCallbackException e) {
            LOG.warn(e);
        }
        catch (InstantiationException e) {
            LOG.warn(e);
        }
        catch (IllegalAccessException e) {
            LOG.warn(e);
        }
        catch (ClassNotFoundException e) {
            LOG.warn(e);
        }
        return null;
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    private String getUserName(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        NameCallback nameCallback = new NameCallback("foo");
        callbackHandler.handle(new Callback[]{nameCallback});
        return nameCallback.getName();
    }

    public void logout(UserIdentity user) {
        Set<JAASUserPrincipal> userPrincipals = user.getSubject().getPrincipals(JAASUserPrincipal.class);
        LoginContext loginContext = userPrincipals.iterator().next().getLoginContext();
        try {
            loginContext.logout();
        }
        catch (LoginException e) {
            LOG.warn(e);
        }
    }

    private String[] getGroups(Subject subject) {
        String[] roleClassNames = this.getRoleClassNames();
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        try {
            for (String roleClassName : roleClassNames) {
                Class<?> load_class = Thread.currentThread().getContextClassLoader().loadClass(roleClassName);
                Set<?> rolesForType = subject.getPrincipals(load_class);
                for (Principal principal : rolesForType) {
                    groups.add(principal.getName());
                }
            }
            return groups.toArray(new String[groups.size()]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

