/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.console.command.AbstractCommand;

public class StartCommand
extends AbstractCommand {
    public static final String DEFAULT_CONFIG_URI = "xbean:activemq.xml";
    protected String[] helpFile = new String[]{"Task Usage: Main start [start-options] [uri]", "Description: Creates and starts a broker using a configuration file, or a broker URI.", "", "Start Options:", "    -D<name>=<value>      Define a system property.", "    --version             Display the version information.", "    -h,-?,--help          Display the start broker help information.", "", "URI:", "", "    XBean based broker configuration:", "", "        Example: Main xbean:file:activemq.xml", "            Loads the xbean configuration file from the current working directory", "        Example: Main xbean:activemq.xml", "            Loads the xbean configuration file from the classpath", "", "    URI Parameter based broker configuration:", "", "        Example: Main broker:(tcp://localhost:61616, tcp://localhost:5000)?useJmx=true", "            Configures the broker with 2 transport connectors and jmx enabled", "        Example: Main broker:(tcp://localhost:61616, network:tcp://localhost:5000)?persistent=false", "            Configures the broker with 1 transport connector, and 1 network connector and persistence disabled", ""};
    private URI configURI;
    private List<BrokerService> brokers = new ArrayList<BrokerService>(5);

    @Override
    protected void runTask(List<String> brokerURIs) throws Exception {
        block6: {
            try {
                if (brokerURIs.isEmpty()) {
                    this.setConfigUri(new URI(DEFAULT_CONFIG_URI));
                    this.startBroker(this.getConfigUri());
                    break block6;
                }
                while (!brokerURIs.isEmpty()) {
                    String strConfigURI = brokerURIs.remove(0);
                    try {
                        this.setConfigUri(new URI(strConfigURI));
                    }
                    catch (URISyntaxException e) {
                        this.context.printException(e);
                        return;
                    }
                    this.startBroker(this.getConfigUri());
                }
            }
            catch (Exception e) {
                this.context.printException(new RuntimeException("Failed to execute start task. Reason: " + e, e));
                throw new Exception(e);
            }
        }
        this.waitForShutdown();
    }

    public void startBroker(URI configURI) throws Exception {
        System.out.println("Loading message broker from: " + configURI);
        BrokerService broker = BrokerFactory.createBroker((URI)configURI);
        this.brokers.add(broker);
        broker.start();
        if (!broker.waitUntilStarted()) {
            throw new Exception(broker.getStartException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForShutdown() throws Exception {
        final boolean[] shutdown = new boolean[]{false};
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Iterator i = StartCommand.this.brokers.iterator();
                while (i.hasNext()) {
                    try {
                        BrokerService broker = (BrokerService)i.next();
                        broker.stop();
                    }
                    catch (Exception exception) {}
                }
            }
        });
        final AtomicInteger brokerCounter = new AtomicInteger(this.brokers.size());
        for (BrokerService bs : this.brokers) {
            bs.addShutdownHook(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (brokerCounter.decrementAndGet() != 0) return;
                    boolean[] blArray = shutdown;
                    synchronized (shutdown) {
                        shutdown[0] = true;
                        shutdown.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        boolean[] blArray = shutdown;
        synchronized (shutdown) {
            while (!shutdown[0]) {
                try {
                    shutdown.wait();
                }
                catch (InterruptedException e) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setConfigUri(URI uri) {
        this.configURI = uri;
    }

    public URI getConfigUri() {
        return this.configURI;
    }

    @Override
    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }
}

