/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TimeoutMap;
import org.apache.camel.Traceable;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.ClosedCorrelationKeyException;
import org.apache.camel.processor.aggregate.CompletionAwareAggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregate.TimeoutAwareAggregationStrategy;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultTimeoutMap;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateProcessor
extends ServiceSupport
implements Processor,
Navigate<Processor>,
Traceable,
ShutdownPrepared {
    public static final String AGGREGATE_TIMEOUT_CHECKER = "AggregateTimeoutChecker";
    private static final Logger LOG = LoggerFactory.getLogger(AggregateProcessor.class);
    private final Lock lock = new ReentrantLock();
    private final CamelContext camelContext;
    private final Processor processor;
    private final AggregationStrategy aggregationStrategy;
    private final Expression correlationExpression;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private ScheduledExecutorService timeoutCheckerExecutorService;
    private boolean shutdownTimeoutCheckerExecutorService;
    private ScheduledExecutorService recoverService;
    private TimeoutMap<String, String> timeoutMap;
    private ExceptionHandler exceptionHandler = new LoggingExceptionHandler(this.getClass());
    private AggregationRepository aggregationRepository = new MemoryAggregationRepository();
    private Map<Object, Object> closedCorrelationKeys;
    private Set<String> batchConsumerCorrelationKeys = new LinkedHashSet<String>();
    private final Set<String> inProgressCompleteExchanges = new HashSet<String>();
    private final Map<String, RedeliveryData> redeliveryState = new ConcurrentHashMap<String, RedeliveryData>();
    private boolean ignoreInvalidCorrelationKeys;
    private Integer closeCorrelationKeyOnCompletion;
    private boolean parallelProcessing;
    private boolean eagerCheckCompletion;
    private Predicate completionPredicate;
    private long completionTimeout;
    private Expression completionTimeoutExpression;
    private long completionInterval;
    private int completionSize;
    private Expression completionSizeExpression;
    private boolean completionFromBatchConsumer;
    private AtomicInteger batchConsumerCounter = new AtomicInteger();
    private boolean discardOnCompletionTimeout;
    private boolean forceCompletionOnStop;
    private ProducerTemplate deadLetterProducerTemplate;

    public AggregateProcessor(CamelContext camelContext, Processor processor, Expression correlationExpression, AggregationStrategy aggregationStrategy, ExecutorService executorService, boolean shutdownExecutorService) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processor, "processor");
        ObjectHelper.notNull(correlationExpression, "correlationExpression");
        ObjectHelper.notNull(aggregationStrategy, "aggregationStrategy");
        ObjectHelper.notNull(executorService, "executorService");
        this.camelContext = camelContext;
        this.processor = processor;
        this.correlationExpression = correlationExpression;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public String toString() {
        return "AggregateProcessor[to: " + this.processor + "]";
    }

    @Override
    public String getTraceLabel() {
        return "aggregate[" + this.correlationExpression + "]";
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        boolean completeAllGroups = exchange.getIn().getHeader("CamelAggregationCompleteAllGroups", false, Boolean.TYPE);
        if (completeAllGroups) {
            this.forceCompletionOfAllGroups();
            return;
        }
        String key = this.correlationExpression.evaluate(exchange, String.class);
        if (ObjectHelper.isEmpty(key)) {
            if (this.isIgnoreInvalidCorrelationKeys()) {
                LOG.debug("Invalid correlation key. This Exchange will be ignored: {}", (Object)exchange);
                return;
            }
            throw new CamelExchangeException("Invalid correlation key", exchange);
        }
        if (this.closedCorrelationKeys != null && this.closedCorrelationKeys.containsKey(key)) {
            throw new ClosedCorrelationKeyException(key, exchange);
        }
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
        this.lock.lock();
        try {
            this.doAggregation(key, copy);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Exchange doAggregation(String key, Exchange exchange) throws CamelExchangeException {
        Exchange answer;
        LOG.trace("onAggregation +++ start +++ with correlation key: {}", (Object)key);
        Exchange oldExchange = this.aggregationRepository.get(exchange.getContext(), key);
        Exchange newExchange = exchange;
        Integer size = 1;
        if (oldExchange != null) {
            Integer n = size = oldExchange.getProperty("CamelAggregatedSize", 0, Integer.class);
            Integer n2 = size = Integer.valueOf(size + 1);
        }
        String complete = null;
        if (this.isEagerCheckCompletion()) {
            newExchange.setProperty("CamelAggregatedSize", size);
            complete = this.isCompleted(key, newExchange);
            newExchange.removeProperty("CamelAggregatedSize");
        }
        ExchangeHelper.prepareAggregation(oldExchange, newExchange);
        try {
            answer = this.onAggregation(oldExchange, exchange);
        }
        catch (Throwable e) {
            throw new CamelExchangeException("Error occurred during aggregation", exchange, e);
        }
        if (answer == null) {
            throw new CamelExchangeException("AggregationStrategy " + this.aggregationStrategy + " returned null which is not allowed", exchange);
        }
        answer.setProperty("CamelAggregatedSize", size);
        if (!this.isEagerCheckCompletion()) {
            complete = this.isCompleted(key, answer);
        }
        if (complete == null) {
            LOG.trace("In progress aggregated exchange: {} with correlation key: {}", (Object)answer, (Object)key);
            this.aggregationRepository.add(exchange.getContext(), key, answer);
        } else if ("consumer".equals(complete)) {
            for (String batchKey : this.batchConsumerCorrelationKeys) {
                Exchange batchAnswer = batchKey.equals(key) ? answer : this.aggregationRepository.get(this.camelContext, batchKey);
                if (batchAnswer == null) continue;
                batchAnswer.setProperty("CamelAggregatedCompletedBy", complete);
                this.onCompletion(batchKey, batchAnswer, false);
            }
            this.batchConsumerCorrelationKeys.clear();
        } else {
            answer.setProperty("CamelAggregatedCompletedBy", complete);
            this.onCompletion(key, answer, false);
        }
        LOG.trace("onAggregation +++  end  +++ with correlation key: {}", (Object)key);
        return answer;
    }

    protected String isCompleted(String key, Exchange exchange) {
        Long value;
        int size;
        int size2;
        Integer value2;
        boolean answer;
        if (this.getCompletionPredicate() != null && (answer = this.getCompletionPredicate().matches(exchange))) {
            return "predicate";
        }
        if (this.getCompletionSizeExpression() != null && (value2 = this.getCompletionSizeExpression().evaluate(exchange, Integer.class)) != null && value2 > 0 && (size2 = exchange.getProperty("CamelAggregatedSize", 1, Integer.class).intValue()) >= value2) {
            return "size";
        }
        if (this.getCompletionSize() > 0 && (size = exchange.getProperty("CamelAggregatedSize", 1, Integer.class).intValue()) >= this.getCompletionSize()) {
            return "size";
        }
        boolean timeoutSet = false;
        if (this.getCompletionTimeoutExpression() != null && (value = this.getCompletionTimeoutExpression().evaluate(exchange, Long.class)) != null && value > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Updating correlation key {} to timeout after {} ms. as exchange received: {}", new Object[]{key, value, exchange});
            }
            this.addExchangeToTimeoutMap(key, exchange, value);
            timeoutSet = true;
        }
        if (!timeoutSet && this.getCompletionTimeout() > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Updating correlation key {} to timeout after {} ms. as exchange received: {}", new Object[]{key, this.getCompletionTimeout(), exchange});
            }
            this.addExchangeToTimeoutMap(key, exchange, this.getCompletionTimeout());
        }
        if (this.isCompletionFromBatchConsumer()) {
            this.batchConsumerCorrelationKeys.add(key);
            this.batchConsumerCounter.incrementAndGet();
            size2 = exchange.getProperty("CamelBatchSize", 0, Integer.class);
            if (size2 > 0 && this.batchConsumerCounter.intValue() >= size2) {
                this.batchConsumerCounter.set(0);
                return "consumer";
            }
        }
        return null;
    }

    protected Exchange onAggregation(Exchange oldExchange, Exchange newExchange) {
        return this.aggregationStrategy.aggregate(oldExchange, newExchange);
    }

    protected void onCompletion(String key, Exchange exchange, boolean fromTimeout) {
        exchange.setProperty("CamelAggregatedCorrelationKey", key);
        this.aggregationRepository.remove(exchange.getContext(), key, exchange);
        if (!fromTimeout && this.timeoutMap != null) {
            this.timeoutMap.remove(key);
        }
        if (this.closedCorrelationKeys != null) {
            this.closedCorrelationKeys.put(key, key);
        }
        if (fromTimeout && this.aggregationStrategy instanceof TimeoutAwareAggregationStrategy) {
            long timeout = this.getCompletionTimeout() > 0L ? this.getCompletionTimeout() : -1L;
            ((TimeoutAwareAggregationStrategy)this.aggregationStrategy).timeout(exchange, -1, -1, timeout);
        }
        if (fromTimeout && this.isDiscardOnCompletionTimeout()) {
            LOG.debug("Aggregation for correlation key {} discarding aggregated exchange: ()", (Object)key, (Object)exchange);
            this.aggregationRepository.confirm(exchange.getContext(), exchange.getExchangeId());
            this.redeliveryState.remove(exchange.getExchangeId());
        } else {
            this.onSubmitCompletion(key, exchange);
        }
    }

    private void onSubmitCompletion(Object key, final Exchange exchange) {
        LOG.debug("Aggregation complete for correlation key {} sending aggregated exchange: {}", key, (Object)exchange);
        this.inProgressCompleteExchanges.add(exchange.getExchangeId());
        if (this.aggregationStrategy instanceof CompletionAwareAggregationStrategy) {
            ((CompletionAwareAggregationStrategy)this.aggregationStrategy).onCompletion(exchange);
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                LOG.debug("Processing aggregated exchange: {}", (Object)exchange);
                exchange.addOnCompletion(new AggregateOnCompletion(exchange.getExchangeId()));
                try {
                    AggregateProcessor.this.processor.process(exchange);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                if (exchange.getException() != null) {
                    AggregateProcessor.this.getExceptionHandler().handleException("Error processing aggregated exchange", exchange, exchange.getException());
                } else {
                    LOG.trace("Processing aggregated exchange: {} complete.", (Object)exchange);
                }
            }
        });
    }

    protected void restoreTimeoutMapFromAggregationRepository() throws Exception {
        Set<String> keys = this.aggregationRepository.getKeys();
        if (keys == null || keys.isEmpty()) {
            return;
        }
        StopWatch watch = new StopWatch();
        LOG.trace("Starting restoring CompletionTimeout for {} existing exchanges from the aggregation repository...", (Object)keys.size());
        for (String key : keys) {
            Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
            long timeout = exchange.hasProperties() ? exchange.getProperty("CamelAggregatedTimeout", 0, Long.TYPE) : 0L;
            if (timeout <= 0L) continue;
            LOG.trace("Restoring CompletionTimeout for exchangeId: {} with timeout: {} millis.", (Object)exchange.getExchangeId(), (Object)timeout);
            this.addExchangeToTimeoutMap(key, exchange, timeout);
        }
        LOG.info("Restored {} CompletionTimeout conditions in the AggregationTimeoutChecker in {}", (Object)this.timeoutMap.size(), (Object)TimeUtils.printDuration(watch.stop()));
    }

    private void addExchangeToTimeoutMap(String key, Exchange exchange, long timeout) {
        exchange.setProperty("CamelAggregatedTimeout", timeout);
        this.timeoutMap.put(key, exchange.getExchangeId(), timeout);
    }

    public Predicate getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(Predicate completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public boolean isEagerCheckCompletion() {
        return this.eagerCheckCompletion;
    }

    public void setEagerCheckCompletion(boolean eagerCheckCompletion) {
        this.eagerCheckCompletion = eagerCheckCompletion;
    }

    public long getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public Expression getCompletionTimeoutExpression() {
        return this.completionTimeoutExpression;
    }

    public void setCompletionTimeoutExpression(Expression completionTimeoutExpression) {
        this.completionTimeoutExpression = completionTimeoutExpression;
    }

    public long getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(long completionInterval) {
        this.completionInterval = completionInterval;
    }

    public int getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(int completionSize) {
        this.completionSize = completionSize;
    }

    public Expression getCompletionSizeExpression() {
        return this.completionSizeExpression;
    }

    public void setCompletionSizeExpression(Expression completionSizeExpression) {
        this.completionSizeExpression = completionSizeExpression;
    }

    public boolean isIgnoreInvalidCorrelationKeys() {
        return this.ignoreInvalidCorrelationKeys;
    }

    public void setIgnoreInvalidCorrelationKeys(boolean ignoreInvalidCorrelationKeys) {
        this.ignoreInvalidCorrelationKeys = ignoreInvalidCorrelationKeys;
    }

    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.closeCorrelationKeyOnCompletion;
    }

    public void setCloseCorrelationKeyOnCompletion(Integer closeCorrelationKeyOnCompletion) {
        this.closeCorrelationKeyOnCompletion = closeCorrelationKeyOnCompletion;
    }

    public boolean isCompletionFromBatchConsumer() {
        return this.completionFromBatchConsumer;
    }

    public void setCompletionFromBatchConsumer(boolean completionFromBatchConsumer) {
        this.completionFromBatchConsumer = completionFromBatchConsumer;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public AggregationRepository getAggregationRepository() {
        return this.aggregationRepository;
    }

    public void setAggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
    }

    public boolean isDiscardOnCompletionTimeout() {
        return this.discardOnCompletionTimeout;
    }

    public void setDiscardOnCompletionTimeout(boolean discardOnCompletionTimeout) {
        this.discardOnCompletionTimeout = discardOnCompletionTimeout;
    }

    public void setForceCompletionOnStop(boolean forceCompletionOnStop) {
        this.forceCompletionOnStop = forceCompletionOnStop;
    }

    public void setTimeoutCheckerExecutorService(ScheduledExecutorService timeoutCheckerExecutorService) {
        this.timeoutCheckerExecutorService = timeoutCheckerExecutorService;
    }

    public ScheduledExecutorService getTimeoutCheckerExecutorService() {
        return this.timeoutCheckerExecutorService;
    }

    public boolean isShutdownTimeoutCheckerExecutorService() {
        return this.shutdownTimeoutCheckerExecutorService;
    }

    public void setShutdownTimeoutCheckerExecutorService(boolean shutdownTimeoutCheckerExecutorService) {
        this.shutdownTimeoutCheckerExecutorService = shutdownTimeoutCheckerExecutorService;
    }

    @Override
    protected void doStart() throws Exception {
        RecoverableAggregationRepository recoverable;
        if (this.getCompletionTimeout() <= 0L && this.getCompletionInterval() <= 0L && this.getCompletionSize() <= 0 && this.getCompletionPredicate() == null && !this.isCompletionFromBatchConsumer() && this.getCompletionTimeoutExpression() == null && this.getCompletionSizeExpression() == null) {
            throw new IllegalStateException("At least one of the completions options [completionTimeout, completionInterval, completionSize, completionPredicate, completionFromBatchConsumer] must be set");
        }
        if (this.getCloseCorrelationKeyOnCompletion() != null) {
            if (this.getCloseCorrelationKeyOnCompletion() > 0) {
                LOG.info("Using ClosedCorrelationKeys with a LRUCache with a capacity of " + this.getCloseCorrelationKeyOnCompletion());
                this.closedCorrelationKeys = new LRUCache<Object, Object>(this.getCloseCorrelationKeyOnCompletion());
            } else {
                LOG.info("Using ClosedCorrelationKeys with unbounded capacity");
                this.closedCorrelationKeys = new HashMap<Object, Object>();
            }
        }
        ServiceHelper.startServices(this.processor, this.aggregationRepository);
        if (this.aggregationRepository instanceof RecoverableAggregationRepository && (recoverable = (RecoverableAggregationRepository)this.aggregationRepository).isUseRecovery()) {
            long interval = recoverable.getRecoveryIntervalInMillis();
            if (interval <= 0L) {
                throw new IllegalArgumentException("AggregationRepository has recovery enabled and the RecoveryInterval option must be a positive number, was: " + interval);
            }
            this.recoverService = this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, "AggregateRecoverChecker", 1);
            RecoverTask recoverTask = new RecoverTask(recoverable);
            LOG.info("Using RecoverableAggregationRepository by scheduling recover checker to run every " + interval + " millis.");
            this.recoverService.scheduleWithFixedDelay(recoverTask, 1000L, interval, TimeUnit.MILLISECONDS);
            if (recoverable.getDeadLetterUri() != null) {
                int max = recoverable.getMaximumRedeliveries();
                if (max <= 0) {
                    throw new IllegalArgumentException("Option maximumRedeliveries must be a positive number, was: " + max);
                }
                LOG.info("After " + max + " failed redelivery attempts Exchanges will be moved to deadLetterUri: " + recoverable.getDeadLetterUri());
                Endpoint endpoint = this.camelContext.getEndpoint(recoverable.getDeadLetterUri());
                if (endpoint == null) {
                    throw new NoSuchEndpointException(recoverable.getDeadLetterUri());
                }
                this.deadLetterProducerTemplate = this.camelContext.createProducerTemplate();
            }
        }
        if (this.getCompletionInterval() > 0L && this.getCompletionTimeout() > 0L) {
            throw new IllegalArgumentException("Only one of completionInterval or completionTimeout can be used, not both.");
        }
        if (this.getCompletionInterval() > 0L) {
            LOG.info("Using CompletionInterval to run every " + this.getCompletionInterval() + " millis.");
            if (this.getTimeoutCheckerExecutorService() == null) {
                this.setTimeoutCheckerExecutorService(this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, AGGREGATE_TIMEOUT_CHECKER, 1));
                this.shutdownTimeoutCheckerExecutorService = true;
            }
            this.getTimeoutCheckerExecutorService().scheduleAtFixedRate(new AggregationIntervalTask(), this.getCompletionInterval(), this.getCompletionInterval(), TimeUnit.MILLISECONDS);
        }
        if (this.getCompletionTimeout() > 0L || this.getCompletionTimeoutExpression() != null) {
            LOG.info("Using CompletionTimeout to trigger after " + this.getCompletionTimeout() + " millis of inactivity.");
            if (this.getTimeoutCheckerExecutorService() == null) {
                this.setTimeoutCheckerExecutorService(this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, AGGREGATE_TIMEOUT_CHECKER, 1));
                this.shutdownTimeoutCheckerExecutorService = true;
            }
            this.timeoutMap = new AggregationTimeoutMap(this.getTimeoutCheckerExecutorService(), 1000L);
            this.restoreTimeoutMapFromAggregationRepository();
            ServiceHelper.startService(this.timeoutMap);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.recoverService != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.recoverService);
        }
        ServiceHelper.stopServices(this.timeoutMap, this.processor, this.deadLetterProducerTemplate);
        if (this.closedCorrelationKeys != null) {
            ServiceHelper.stopService(this.closedCorrelationKeys);
            this.closedCorrelationKeys.clear();
        }
        this.batchConsumerCorrelationKeys.clear();
        this.redeliveryState.clear();
    }

    @Override
    public void prepareShutdown(boolean forced) {
        if (!forced && this.forceCompletionOnStop) {
            this.doForceCompletionOnStop();
        }
    }

    private void doForceCompletionOnStop() {
        int expected = this.forceCompletionOfAllGroups();
        StopWatch watch = new StopWatch();
        while (this.inProgressCompleteExchanges.size() > 0) {
            LOG.trace("Waiting for {} inflight exchanges to complete", (Object)this.inProgressCompleteExchanges.size());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for {} inflight exchanges to complete.", (Object)this.inProgressCompleteExchanges.size());
                break;
            }
        }
        if (expected > 0) {
            LOG.info("Forcing completion of all groups with {} exchanges completed in {}", (Object)expected, (Object)TimeUtils.printDuration(watch.stop()));
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopService(this.aggregationRepository);
        this.inProgressCompleteExchanges.clear();
        if (this.shutdownExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
        }
        if (this.shutdownTimeoutCheckerExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.timeoutCheckerExecutorService);
            this.timeoutCheckerExecutorService = null;
        }
        super.doShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forceCompletionOfAllGroups() {
        boolean allow;
        boolean bl = allow = this.camelContext.getStatus().isStarted() || this.camelContext.getStatus().isStopping();
        if (!allow) {
            LOG.warn("Cannot start force completion of all groups because CamelContext({}) has not been started", (Object)this.camelContext.getName());
            return 0;
        }
        LOG.trace("Starting force completion of all groups task");
        Set<String> keys = this.aggregationRepository.getKeys();
        int total = 0;
        if (keys != null && !keys.isEmpty()) {
            this.lock.lock();
            total = keys.size();
            try {
                for (String key : keys) {
                    Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
                    if (exchange == null) continue;
                    LOG.trace("Force completion triggered for correlation key: {}", (Object)key);
                    exchange.setProperty("CamelAggregatedCompletedBy", "forceCompletion");
                    this.onCompletion(key, exchange, false);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        LOG.trace("Completed force completion of all groups task");
        if (total > 0) {
            LOG.debug("Forcing completion of all groups with {} exchanges", (Object)total);
        }
        return total;
    }

    private final class RecoverTask
    implements Runnable {
        private final RecoverableAggregationRepository recoverable;

        private RecoverTask(RecoverableAggregationRepository recoverable) {
            this.recoverable = recoverable;
        }

        @Override
        public void run() {
            if (!AggregateProcessor.this.camelContext.getStatus().isStarted()) {
                LOG.trace("Recover check cannot start due CamelContext({}) has not been started yet", (Object)AggregateProcessor.this.camelContext.getName());
                return;
            }
            LOG.trace("Starting recover check");
            Set<String> exchangeIds = this.recoverable.scan(AggregateProcessor.this.camelContext);
            for (String exchangeId : exchangeIds) {
                if (!AggregateProcessor.this.isRunAllowed()) {
                    LOG.info("We are shutting down so stop recovering");
                    return;
                }
                boolean inProgress = AggregateProcessor.this.inProgressCompleteExchanges.contains(exchangeId);
                if (inProgress) {
                    LOG.trace("Aggregated exchange with id: {} is already in progress.", (Object)exchangeId);
                    continue;
                }
                LOG.debug("Loading aggregated exchange with id: {} to be recovered.", (Object)exchangeId);
                Exchange exchange = this.recoverable.recover(AggregateProcessor.this.camelContext, exchangeId);
                if (exchange == null) continue;
                String key = exchange.getProperty("CamelAggregatedCorrelationKey", String.class);
                exchange.getIn().setHeader("CamelRedelivered", Boolean.TRUE);
                RedeliveryData data = (RedeliveryData)AggregateProcessor.this.redeliveryState.get(exchange.getExchangeId());
                if (data != null && this.recoverable.getMaximumRedeliveries() > 0 && data.redeliveryCounter >= this.recoverable.getMaximumRedeliveries()) {
                    LOG.warn("The recovered exchange is exhausted after " + this.recoverable.getMaximumRedeliveries() + " attempts, will now be moved to dead letter channel: " + this.recoverable.getDeadLetterUri());
                    try {
                        exchange.getIn().setHeader("CamelRedeliveryCounter", data.redeliveryCounter);
                        exchange.getIn().setHeader("CamelRedeliveryExhausted", Boolean.TRUE);
                        AggregateProcessor.this.deadLetterProducerTemplate.send(this.recoverable.getDeadLetterUri(), exchange);
                    }
                    catch (Throwable e) {
                        exchange.setException(e);
                    }
                    if (exchange.getException() != null) {
                        AggregateProcessor.this.getExceptionHandler().handleException("Failed to move recovered Exchange to dead letter channel: " + this.recoverable.getDeadLetterUri(), exchange.getException());
                        continue;
                    }
                    this.recoverable.confirm(AggregateProcessor.this.camelContext, exchangeId);
                    continue;
                }
                if (data == null) {
                    data = new RedeliveryData();
                    AggregateProcessor.this.redeliveryState.put(exchange.getExchangeId(), data);
                }
                ++data.redeliveryCounter;
                exchange.getIn().setHeader("CamelRedeliveryCounter", data.redeliveryCounter);
                if (this.recoverable.getMaximumRedeliveries() > 0) {
                    exchange.getIn().setHeader("CamelRedeliveryMaxCounter", this.recoverable.getMaximumRedeliveries());
                }
                LOG.debug("Delivery attempt: {} to recover aggregated exchange with id: {}", (Object)data.redeliveryCounter, (Object)exchangeId);
                AggregateProcessor.this.onSubmitCompletion(key, exchange);
            }
            LOG.trace("Recover check complete");
        }
    }

    private final class AggregationIntervalTask
    implements Runnable {
        private AggregationIntervalTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!AggregateProcessor.this.camelContext.getStatus().isStarted()) {
                LOG.trace("Completion interval task cannot start due CamelContext({}) has not been started yet", (Object)AggregateProcessor.this.camelContext.getName());
                return;
            }
            LOG.trace("Starting completion interval task");
            Set<String> keys = AggregateProcessor.this.aggregationRepository.getKeys();
            if (keys != null && !keys.isEmpty()) {
                AggregateProcessor.this.lock.lock();
                try {
                    for (String key : keys) {
                        Exchange exchange = AggregateProcessor.this.aggregationRepository.get(AggregateProcessor.this.camelContext, key);
                        if (exchange == null) continue;
                        LOG.trace("Completion interval triggered for correlation key: {}", (Object)key);
                        exchange.setProperty("CamelAggregatedCompletedBy", "interval");
                        AggregateProcessor.this.onCompletion(key, exchange, false);
                    }
                }
                finally {
                    AggregateProcessor.this.lock.unlock();
                }
            }
            LOG.trace("Completion interval task complete");
        }
    }

    private final class AggregationTimeoutMap
    extends DefaultTimeoutMap<String, String> {
        private AggregationTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
            super(executor, requestMapPollTimeMillis, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void purge() {
            AggregateProcessor.this.lock.lock();
            try {
                super.purge();
            }
            finally {
                AggregateProcessor.this.lock.unlock();
            }
        }

        @Override
        public boolean onEviction(String key, String exchangeId) {
            this.log.debug("Completion timeout triggered for correlation key: {}", (Object)key);
            boolean inProgress = AggregateProcessor.this.inProgressCompleteExchanges.contains(exchangeId);
            if (inProgress) {
                LOG.trace("Aggregated exchange with id: {} is already in progress.", (Object)exchangeId);
                return true;
            }
            Exchange answer = AggregateProcessor.this.aggregationRepository.get(AggregateProcessor.this.camelContext, key);
            if (answer != null) {
                answer.setProperty("CamelAggregatedCompletedBy", "timeout");
                AggregateProcessor.this.onCompletion(key, answer, true);
            }
            return true;
        }
    }

    private final class AggregateOnCompletion
    implements Synchronization {
        private final String exchangeId;

        private AggregateOnCompletion(String exchangeId) {
            this.exchangeId = exchangeId;
        }

        @Override
        public void onFailure(Exchange exchange) {
            LOG.trace("Aggregated exchange onFailure: {}", (Object)exchange);
            AggregateProcessor.this.inProgressCompleteExchanges.remove(this.exchangeId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(Exchange exchange) {
            LOG.trace("Aggregated exchange onComplete: {}", (Object)exchange);
            try {
                AggregateProcessor.this.aggregationRepository.confirm(exchange.getContext(), this.exchangeId);
                AggregateProcessor.this.redeliveryState.remove(this.exchangeId);
            }
            finally {
                AggregateProcessor.this.inProgressCompleteExchanges.remove(this.exchangeId);
            }
        }

        public String toString() {
            return "AggregateOnCompletion";
        }
    }

    private class RedeliveryData {
        int redeliveryCounter;

        private RedeliveryData() {
        }
    }
}

