/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollEnricher
extends ServiceSupport
implements Processor {
    private static final transient Logger LOG = LoggerFactory.getLogger(PollEnricher.class);
    private AggregationStrategy aggregationStrategy;
    private PollingConsumer consumer;
    private long timeout;
    private Boolean pollMultiple;

    public PollEnricher(PollingConsumer consumer) {
        this(PollEnricher.defaultAggregationStrategy(), consumer, 0L, false);
    }

    public PollEnricher(AggregationStrategy aggregationStrategy, PollingConsumer consumer, long timeout) {
        this.aggregationStrategy = aggregationStrategy;
        this.consumer = consumer;
        this.timeout = timeout;
    }

    public PollEnricher(AggregationStrategy aggregationStrategy, PollingConsumer consumer, long timeout, Boolean pollMultiple) {
        this.aggregationStrategy = aggregationStrategy;
        this.consumer = consumer;
        this.timeout = timeout;
        this.pollMultiple = pollMultiple;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public void setDefaultAggregationStrategy() {
        this.aggregationStrategy = PollEnricher.defaultAggregationStrategy();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setPollMultiple(Boolean value) {
        this.pollMultiple = value;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.preCheckPoll(exchange);
        if (this.pollMultiple != null && this.pollMultiple.booleanValue()) {
            ArrayList<Exchange> exchangeList = new ArrayList<Exchange>();
            while (true) {
                Exchange receivedExchange;
                if (this.timeout == 0L) {
                    LOG.debug("Polling Consumer receiveNoWait: {}", (Object)this.consumer);
                    receivedExchange = this.consumer.receiveNoWait();
                } else {
                    LOG.debug("Polling Consumer receive with timeout: {} ms. {}", (Object)this.timeout, (Object)this.consumer);
                    receivedExchange = this.consumer.receive(this.timeout);
                }
                if (receivedExchange == null) break;
                exchangeList.add(receivedExchange);
            }
            exchange.getIn().setBody(exchangeList);
        } else {
            Exchange resourceExchange;
            if (this.timeout < 0L) {
                LOG.debug("Consumer receive: {}", (Object)this.consumer);
                resourceExchange = this.consumer.receive();
            } else if (this.timeout == 0L) {
                LOG.debug("Consumer receiveNoWait: {}", (Object)this.consumer);
                resourceExchange = this.consumer.receiveNoWait();
            } else {
                LOG.debug("Consumer receive with timeout: {} ms. {}", (Object)this.timeout, (Object)this.consumer);
                resourceExchange = this.consumer.receive(this.timeout);
            }
            if (resourceExchange == null) {
                LOG.debug("Consumer received no exchange");
            } else {
                LOG.debug("Consumer received: {}", (Object)resourceExchange);
            }
            if (resourceExchange != null && resourceExchange.isFailed()) {
                ExchangeHelper.copyResultsPreservePattern(exchange, resourceExchange);
            } else {
                Exchange aggregatedExchange;
                PollEnricher.prepareResult(exchange);
                ExchangeHelper.prepareAggregation(exchange, resourceExchange);
                try {
                    aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
                }
                catch (Throwable e) {
                    throw new CamelExchangeException("Error occurred during aggregation", exchange, e);
                }
                if (aggregatedExchange != null) {
                    ExchangeHelper.copyResultsPreservePattern(exchange, aggregatedExchange);
                    if (resourceExchange != null) {
                        resourceExchange.handoverCompletions(exchange);
                    }
                }
            }
        }
        if (exchange.hasOut()) {
            exchange.getOut().setHeader("CamelToEndpoint", this.consumer.getEndpoint().getEndpointUri());
        } else {
            exchange.getIn().setHeader("CamelToEndpoint", this.consumer.getEndpoint().getEndpointUri());
        }
    }

    protected void preCheckPoll(Exchange exchange) throws Exception {
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return "PollEnrich[" + this.consumer + "]";
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.consumer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.consumer);
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        @Override
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(oldExchange, newExchange);
            } else {
                oldExchange.getIn().setBody(null);
                oldExchange.setOut(null);
            }
            return oldExchange;
        }
    }
}

