/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class BezierControlPointHandle
extends AbstractHandle {
    protected int index;
    protected int controlPointIndex;
    private CompositeEdit edit;
    private Figure transformOwner;
    private BezierPath.Node oldNode;

    public BezierControlPointHandle(BezierFigure bezierFigure, int n, int n2) {
        this(bezierFigure, n, n2, bezierFigure);
    }

    public BezierControlPointHandle(BezierFigure bezierFigure, int n, int n2, Figure figure) {
        super(bezierFigure);
        this.index = n;
        this.controlPointIndex = n2;
        this.transformOwner = figure;
        figure.addFigureListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.transformOwner.removeFigureListener(this);
        this.transformOwner = null;
    }

    protected BezierFigure getBezierFigure() {
        return this.getOwner();
    }

    protected Figure getTransformOwner() {
        return this.transformOwner;
    }

    protected Point getLocation() {
        if (this.getBezierFigure().getNodeCount() > this.index) {
            Point2D.Double double_ = this.getBezierFigure().getPoint(this.index, this.controlPointIndex);
            if (this.getTransformOwner().get(AttributeKeys.TRANSFORM) != null) {
                this.getTransformOwner().get(AttributeKeys.TRANSFORM).transform(double_, double_);
            }
            return this.view.drawingToView(double_);
        }
        return new Point(10, 10);
    }

    protected BezierPath.Node getBezierNode() {
        return this.getBezierFigure().getNodeCount() > this.index ? this.getBezierFigure().getNode(this.index) : null;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        BezierFigure bezierFigure = this.getBezierFigure();
        if (bezierFigure.getNodeCount() > this.index) {
            Color color;
            Stroke stroke;
            Color color2;
            Stroke stroke2;
            Color color3;
            Color color4;
            BezierPath.Node node = bezierFigure.getNode(this.index);
            Point2D.Double double_ = new Point2D.Double(node.x[0], node.y[0]);
            Point2D.Double double_2 = new Point2D.Double(node.x[this.controlPointIndex], node.y[this.controlPointIndex]);
            Figure figure = this.getTransformOwner();
            if (figure.get(AttributeKeys.TRANSFORM) != null) {
                figure.get(AttributeKeys.TRANSFORM).transform(double_, double_);
                figure.get(AttributeKeys.TRANSFORM).transform(double_2, double_2);
            }
            if (this.getEditor().getTool().supportsHandleInteraction()) {
                color4 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_CONTROL_POINT_HANDLE_FILL_COLOR);
                color3 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_CONTROL_POINT_HANDLE_STROKE_COLOR);
                stroke2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_STROKE_1);
                color2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_COLOR_1);
                stroke = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_STROKE_2);
                color = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_COLOR_2);
            } else {
                color4 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_CONTROL_POINT_HANDLE_FILL_COLOR_DISABLED);
                color3 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_CONTROL_POINT_HANDLE_STROKE_COLOR_DISABLED);
                stroke2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_STROKE_1_DISABLED);
                color2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_COLOR_1_DISABLED);
                stroke = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_STROKE_2_DISABLED);
                color = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_COLOR_2_DISABLED);
            }
            if (stroke2 != null && color2 != null) {
                graphics2D.setStroke(stroke2);
                graphics2D.setColor(color2);
                graphics2D.draw(new Line2D.Double(this.view.drawingToView(double_), this.view.drawingToView(double_2)));
            }
            if (stroke != null && color != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setColor(color);
                graphics2D.draw(new Line2D.Double(this.view.drawingToView(double_), this.view.drawingToView(double_2)));
            }
            if (node.keepColinear && node.mask == 3 && (this.index > 0 && this.index < bezierFigure.getNodeCount() - 1 || bezierFigure.isClosed())) {
                this.drawCircle(graphics2D, color3, color4);
            } else {
                this.drawCircle(graphics2D, color4, color3);
            }
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation());
        int n = this.getHandlesize();
        rectangle.x -= n / 2;
        rectangle.y -= n / 2;
        rectangle.width = rectangle.height = n;
        return rectangle;
    }

    @Override
    public void trackStart(Point point, int n) {
        BezierFigure bezierFigure = this.getOwner();
        this.edit = new CompositeEdit("Punkt verschieben");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(this.getLocation()));
        Point2D.Double double_2 = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point));
        this.oldNode = bezierFigure.getNode(this.index);
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
        BezierFigure bezierFigure = this.getBezierFigure();
        Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point2));
        BezierPath.Node node = bezierFigure.getNode(this.index);
        this.fireAreaInvalidated(node);
        bezierFigure.willChange();
        Figure figure = this.getTransformOwner();
        if (figure.get(AttributeKeys.TRANSFORM) != null) {
            try {
                figure.get(AttributeKeys.TRANSFORM).inverseTransform(double_, double_);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        if (!node.keepColinear) {
            bezierFigure.setPoint(this.index, this.controlPointIndex, double_);
        } else {
            double d = Math.PI + Math.atan2(double_.y - node.y[0], double_.x - node.x[0]);
            int n2 = this.controlPointIndex == 1 ? 2 : 1;
            double d2 = Math.sqrt((node.x[n2] - node.x[0]) * (node.x[n2] - node.x[0]) + (node.y[n2] - node.y[0]) * (node.y[n2] - node.y[0]));
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            Point2D.Double double_2 = new Point2D.Double(d2 * d4 + node.x[0], d2 * d3 + node.y[0]);
            bezierFigure.setPoint(this.index, this.controlPointIndex, double_);
            bezierFigure.setPoint(this.index, n2, double_2);
        }
        bezierFigure.changed();
        this.fireAreaInvalidated(bezierFigure.getNode(this.index));
    }

    private void fireAreaInvalidated(BezierPath.Node node) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(node.x[0], node.y[0], 0.0, 0.0);
        for (int i = 1; i < 3; ++i) {
            double_.add(node.x[i], node.y[i]);
        }
        Rectangle rectangle = this.view.drawingToView(double_);
        rectangle.grow(this.getHandlesize(), this.getHandlesize());
        this.fireAreaInvalidated(rectangle);
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
        BezierFigure bezierFigure = this.getBezierFigure();
        BezierPath.Node node = (BezierPath.Node)this.oldNode.clone();
        BezierPath.Node node2 = bezierFigure.getNode(this.index);
        if ((n & 0x3C0) != 0) {
            bezierFigure.willChange();
            boolean bl = node2.keepColinear = !node2.keepColinear;
            if (node2.keepColinear) {
                Point2D.Double double_ = bezierFigure.getPoint(this.index, this.controlPointIndex);
                double d = Math.PI + Math.atan2(double_.y - node2.y[0], double_.x - node2.x[0]);
                int n2 = this.controlPointIndex == 1 ? 2 : 1;
                double d2 = Math.sqrt((node2.x[n2] - node2.x[0]) * (node2.x[n2] - node2.x[0]) + (node2.y[n2] - node2.y[0]) * (node2.y[n2] - node2.y[0]));
                double d3 = Math.sin(d);
                double d4 = Math.cos(d);
                Point2D.Double double_2 = new Point2D.Double(d2 * d4 + node2.x[0], d2 * d3 + node2.y[0]);
                node2.x[n2] = double_2.x;
                node2.y[n2] = double_2.y;
            }
            bezierFigure.setNode(this.index, node2);
            bezierFigure.changed();
        }
        this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, node, node2){

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                BezierControlPointHandle.this.fireHandleRequestSecondaryHandles();
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                BezierControlPointHandle.this.fireHandleRequestSecondaryHandles();
            }
        });
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        if (super.isCombinableWith(handle)) {
            BezierControlPointHandle bezierControlPointHandle = (BezierControlPointHandle)handle;
            return bezierControlPointHandle.index == this.index && bezierControlPointHandle.controlPointIndex == this.controlPointIndex && bezierControlPointHandle.getBezierFigure().getNodeCount() == this.getBezierFigure().getNodeCount();
        }
        return false;
    }

    @Override
    public String getToolTipText(Point point) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        BezierPath.Node node = this.getBezierNode();
        if (node == null) {
            return null;
        }
        if (node.mask == 3) {
            return resourceBundleUtil.getFormatted("handle.bezierControlPoint.toolTipText", resourceBundleUtil.getFormatted(node.keepColinear ? "handle.bezierControlPoint.cubicColinear.value" : "handle.bezierControlPoint.cubicUnconstrained.value", new Object[0]));
        }
        return resourceBundleUtil.getString("handle.bezierControlPoint.quadratic.toolTipText");
    }

    @Override
    public BezierFigure getOwner() {
        return (BezierFigure)super.getOwner();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        BezierFigure bezierFigure = this.getOwner();
        BezierPath.Node node = bezierFigure.getNode(this.index);
        switch (keyEvent.getKeyCode()) {
            case 38: {
                bezierFigure.willChange();
                bezierFigure.setPoint(this.index, this.controlPointIndex, new Point2D.Double(node.x[this.controlPointIndex], node.y[this.controlPointIndex] - 1.0));
                bezierFigure.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, node, bezierFigure.getNode(this.index)));
                keyEvent.consume();
                break;
            }
            case 40: {
                bezierFigure.willChange();
                bezierFigure.setPoint(this.index, this.controlPointIndex, new Point2D.Double(node.x[this.controlPointIndex], node.y[this.controlPointIndex] + 1.0));
                bezierFigure.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, node, bezierFigure.getNode(this.index)));
                keyEvent.consume();
                break;
            }
            case 37: {
                bezierFigure.willChange();
                bezierFigure.setPoint(this.index, this.controlPointIndex, new Point2D.Double(node.x[this.controlPointIndex] - 1.0, node.y[this.controlPointIndex]));
                bezierFigure.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, node, bezierFigure.getNode(this.index)));
                keyEvent.consume();
                break;
            }
            case 39: {
                bezierFigure.willChange();
                bezierFigure.setPoint(this.index, this.controlPointIndex, new Point2D.Double(node.x[this.controlPointIndex] + 1.0, node.y[this.controlPointIndex]));
                bezierFigure.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, node, bezierFigure.getNode(this.index)));
                keyEvent.consume();
                break;
            }
            case 8: 
            case 127: {
                keyEvent.consume();
            }
        }
    }
}

