<?php

// Backwards compatibility for the function sys_get_temp_dir which was
// introduced in PHP 5.2.1
if ( !function_exists('sys_get_temp_dir') ) {
	// Reference http://php.net/manual/en/function.sys-get-temp-dir.php
	// Based on http://www.phpit.net/
	// article/creating-zip-tar-archives-dynamically-php/2/
	function sys_get_temp_dir()
	{
		// Try to get from environment variable
		if ( !empty($_ENV['TMP']) ) {
			return realpath( $_ENV['TMP'] );
		} else if ( !empty($_ENV['TMPDIR']) ) {
			return realpath( $_ENV['TMPDIR'] );
		} else if ( !empty($_ENV['TEMP']) ) {
			return realpath( $_ENV['TEMP'] );
		} else {
			// Detect by creating a temporary file
			// Try to use system's temporary directory
			// as random name shouldn't exist
			$temp_file = tempnam( md5(uniqid(rand(), TRUE)), '' );
			if ( $temp_file ) {
				$temp_dir = realpath( dirname($temp_file) );
				unlink( $temp_file );
				return $temp_dir;
			} else {
				return FALSE;
			}
		}
	}
}

?>
